<?php
class Exceldownload extends CI_Controller
{
     public function __construct()
    {
            parent::__construct();
        $this -> load -> helper(array('form', 'url'));
        $this -> load -> library(array('session', 'form_validation'));
        $this -> load -> database();
        $this -> load -> model('User_model');
    }
    public function index()
    {
         $this->load->model('Gamemasters_model');
       $tasks = $this->Gamemasters_model -> getGameCategoryList();
      $data['tasks'] = $tasks;        
        $this -> load -> view('exceldownload',$data);
    
    }
    function excel()
    {
        $this->load->model('Gamemasters_model');
       $tasks = $this->Gamemasters_model -> getGameCategoryList();
       $data['tasks'] = $tasks;
       
           require(APPPATH.'third_party/PHPExcel.php');
           require(APPPATH.'third_party/PHPExcel/Writer/Excel2007.php');
          
           //instance of phpexcel
           $objPHPExcel = new PHPExcel();
           
           //set basic standard properties
           $objPHPExcel->getProperties()->setCreator("");
          $objPHPExcel->getProperties()->setLastModifiedBy("");
          $objPHPExcel->getProperties()->setTitle("");
          $objPHPExcel->getProperties()->setSubject("");
          $objPHPExcel->getProperties()->setDescription("");
          
          //create active sheet
          $objPHPExcel->setActiveSheetIndex(0);
          
          //set data values 
          $objPHPExcel->getActiveSheet()->SetCellValue('A1','Cat_ID');
          $objPHPExcel->getActiveSheet()->SetCellValue('B1','Description');
          $objPHPExcel->getActiveSheet()->SetCellValue('C1','Sequence');
          $objPHPExcel->getActiveSheet()->SetCellValue('D1','Status');
          
          //add rows to excel
          $row = 2;
          //data is fetched from database
          foreach ($data['tasks'] as $value) {
              $objPHPExcel->getActiveSheet()->setCellValue('A'.$row,$value->GAME_CAT_ID);
              $objPHPExcel->getActiveSheet()->setCellValue('B'.$row,$value->GAME_CAT_DESC);
              $objPHPExcel->getActiveSheet()->setCellValue('C'.$row,$value->SEQ_NO);
              $objPHPExcel->getActiveSheet()->setCellValue('D'.$row,$value->STATUS);
              
              $row++;
          }
          
          // create filename
          $filename="Game-data-exported-on-".date("Y-m-d-H-i-s").".xlsx";
          //create title of file
          $objPHPExcel->getActiveSheet()->setTitle("Game Details");
          
           //access to download the file
       header('Content-Type: application/vnd.openxmlformats-officedocument.spreedsheetml.sheet');
         header('Content-Disposition: attachment;filename="'.$filename.'"');
        header('Cache-COntrol: max-age=0');
        
        $objWriter = \PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        $objWriter->save('php://output');
          //$this->sendmail($file);
         // redirect('game/Main');
          exit;
          
       
         
    }

    public function getreport()
    {
         $this->load->model('Safetygame_model');
         $mangId = $this->input->post('MANA_ID');
         $tlId = $this->input->post('TL_ID');
      $data['managerList'] = json_decode(json_encode($this -> Safetygame_model -> getUserforRoleId(1)),true);
      $data['teamLeadList'] = json_decode(json_encode($this -> Safetygame_model -> getUserforRoleId(2)),true);
      $data['managerID'] = $mangId;
      $data['teamleadID'] = $tlId;
       
           // var_dump($data);
        $this -> load -> view('emailreport_view',$data);
    
    }
    function chartmail($userkey)
    {
       $this->load->model('Safetygame_model');
       $tasks = $this->Safetygame_model -> getScorelistforuser($userkey);
       $data['tasks'] = $tasks;
       
           require(APPPATH.'third_party/PHPExcel.php');
           require(APPPATH.'third_party/PHPExcel/Writer/Excel2007.php');
           
           //instance of phpexcel
           $ea = new PHPExcel();
           $ea->getProperties()
               ->setCreator('Processbee')
               ->setTitle('PHPExcel Demo')
               ->setLastModifiedBy('Processbee')
               ->setDescription('Safety Game Report')
               ->setSubject('Safety Game Report')
               ->setKeywords('excel game safety')
               ->setCategory('Analytics')
               ;
           $ews = $ea->getSheet(0);
            $ews->setTitle('Data');
           //set basic standard properties
           // $objPHPExcel->getProperties()->setCreator("");
          // $objPHPExcel->getProperties()->setLastModifiedBy("");
          // $objPHPExcel->getProperties()->setTitle("");
          // $objPHPExcel->getProperties()->setSubject("");
          // $objPHPExcel->getProperties()->setDescription("");
          
          //create active sheet
        //  $objPHPExcel->setActiveSheetIndex(0);
          
          //set data values 
          $ews->setCellValue('A1','FIRST_NAME');
          $ews->setCellValue('B1','DISTANCE');
          $ews->setCellValue('C1','SAFETY_SCORE');
          $ews->setCellValue('D1','GAME_SCORE');
          $ews->setCellValue('E1','DATE');
          
          //add rows to excel
          $row = 2;
          //data is fetched from database
          foreach ($data['tasks'] as $value) {
              $ews->setCellValue('A'.$row,$value->FIRST_NAME);
              $ews->setCellValue('B'.$row,$value->DISTANCE);
              $ews->setCellValue('C'.$row,$value->SAFETY_SCORE);
              $ews->setCellValue('D'.$row,$value->GAME_SCORE);
              $ews->setCellValue('E'.$row,$value->DATE);
              
              $row++;
          }
          $header = 'a1:h1';
            $ews->getStyle($header)->getFill()->setFillType(\PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setARGB('00ffff00');
            $style = array(
                'font' => array('bold' => true,),
                'alignment' => array('horizontal' => \PHPExcel_Style_Alignment::HORIZONTAL_CENTER,),
                );
            $ews->getStyle($header)->applyFromArray($style);
                      for ($col = ord('a'); $col <= ord('h'); $col++)
            {
                $ews->getColumnDimension(chr($col))->setAutoSize(true);
            }
          //to create new sheet
         // $ews2 = new \PHPExcel_Worksheet($ea, 'Summary');
        // $ea->addSheet($ews2, 0);
        // $ews2->setTitle('Summary');
        // $ews2->setCellValue('b2', '=COUNTIF(Data!G2:G91, "W")-COUNTIF(Data!G2:G9, "W")');
        // $ews2->setCellValue('b3', '=COUNTIF(Data!G2:G91, "L")-COUNTIF(Data!G2:G9, "L")');
        // $ews2->setCellValue('b4', '=b2/(b2+b3)');
        // 
        // $ews->getStyle('b4')->getNumberFormat()->setFormatCode(\PHPExcel_Style_NumberFormat::FORMAT_PERCENTAGE);
        // 
        // $ews2->setCellValue('a1', 'Lakers 2013-2014 Season');
        // $style = array(
            // 'font' => array('bold' => true, 'size' => 20,),
            // 'alignment' => array('horizontal' => \PHPExcel_Style_Alignment::HORIZONTAL_LEFT,),
        // );
        // $ews2->mergeCells('a1:b1');
        // $ews2->getStyle('a1')->applyFromArray($style);
        // $ews2->getColumnDimension('a')->setAutoSize(true);
        //Data Series Labels
        $dsl=array(
                        new PHPExcel_Chart_DataSeriesValues('String', 'Data!$C$1', NULL, 1),
                        new PHPExcel_Chart_DataSeriesValues('String', 'Data!$D$1', NULL, 1),
        
                    );
        //X Axis Value Label
        $xal=array(
                        new PHPExcel_Chart_DataSeriesValues('String', 'Data!$E$2:$E$15', NULL, 15),
                    );
        //Data Series Values
        $dsv=array(
                        new PHPExcel_Chart_DataSeriesValues('Number', 'Data!$C$2:$C$15', NULL, 15),
                        new PHPExcel_Chart_DataSeriesValues('Number', 'Data!$D$2:$D$15', NULL, 15),
                    );
        //set up Data Series
        $ds=new PHPExcel_Chart_DataSeries(
                            PHPExcel_Chart_DataSeries::TYPE_LINECHART,
                            PHPExcel_Chart_DataSeries::GROUPING_STANDARD,
                            range(0, count($dsv)-1),
                            $dsl,
                            $xal,
                            $dsv
                            );
        //create the Plot Area and Legend
        $pa=new PHPExcel_Chart_PlotArea(NULL, array($ds));
        $legend=new PHPExcel_Chart_Legend(PHPExcel_Chart_Legend::POSITION_RIGHT, NULL, false);
         //title of chart
        $title=new PHPExcel_Chart_Title('Score Details');
        //create chart
        $chart= new PHPExcel_Chart(
                            'chart1',
                            $title,
                            $legend,
                            $pa,
                            true,
                            0,
                            NULL, 
                            NULL
                            );
        
        $chart->setTopLeftPosition('K1');
        $chart->setBottomRightPosition('R15');
        $ews->addChart($chart);
      
            $filename="Game-data-".date("Y-m-d-H-i-s").".xlsx";
          // //create title of file
        // //  $objPHPExcel->getActiveSheet()->setTitle("Game Details");
          
          // //access to download the file
       //header('Content-Type:application/vnd.openxmlformats-officedocument.spreedsheetml.sheet');
       //   header('Content-Disposition: attachment;filename="'.$filename.'"');
       //  header('Cache-COntrol: max-age=0');
     
             //location of file saved
             $file = base_url().''.$filename;
          
          //create writer
        $writer = \PHPExcel_IOFactory::createWriter($ea, 'Excel2007');
            
        $writer->setIncludeCharts(true);
        $writer->save($filename);
        //$writer->save('php://output');
          $this->sendmail($file);
          unlink($filename);//to delete saved file after sending mail
           redirect('game/Main');
           exit;
    }
    function chartdownload($userkey)
    {
        $this->load->model('Safetygame_model');
       $tasks = $this->Safetygame_model -> getScorelistforuser($userkey);
       $data['tasks'] = $tasks;
       
           require(APPPATH.'third_party/PHPExcel.php');
           require(APPPATH.'third_party/PHPExcel/Writer/Excel2007.php');
           
           //instance of phpexcel
           $ea = new PHPExcel();
           $ea->getProperties()
               ->setCreator('Processbee')
               ->setTitle('PHPExcel Demo')
               ->setLastModifiedBy('Processbee')
               ->setDescription('Safety Game Report')
               ->setSubject('Safety Game Report')
               ->setKeywords('excel game safety')
               ->setCategory('Analytics')
               ;
           $ews = $ea->getSheet(0);
            $ews->setTitle('Data');
           //set basic standard properties
           // $objPHPExcel->getProperties()->setCreator("");
          // $objPHPExcel->getProperties()->setLastModifiedBy("");
          // $objPHPExcel->getProperties()->setTitle("");
          // $objPHPExcel->getProperties()->setSubject("");
          // $objPHPExcel->getProperties()->setDescription("");
          
          //create active sheet
        //  $objPHPExcel->setActiveSheetIndex(0);
          
          //set data values 
          $ews->setCellValue('A1','FIRST_NAME');
          $ews->setCellValue('B1','DISTANCE');
          $ews->setCellValue('C1','SAFETY_SCORE');
          $ews->setCellValue('D1','GAME_SCORE');
          $ews->setCellValue('E1','DATE');
          
          //add rows to excel
          $row = 2;
          //data is fetched from database
          foreach ($data['tasks'] as $value) {
              $ews->setCellValue('A'.$row,$value->FIRST_NAME);
              $ews->setCellValue('B'.$row,$value->DISTANCE);
              $ews->setCellValue('C'.$row,$value->SAFETY_SCORE);
              $ews->setCellValue('D'.$row,$value->GAME_SCORE);
              $ews->setCellValue('E'.$row,$value->DATE);
              
              $row++;
          }
          $header = 'a1:h1';
            $ews->getStyle($header)->getFill()->setFillType(\PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setARGB('00ffff00');
            $style = array(
                'font' => array('bold' => true,),
                'alignment' => array('horizontal' => \PHPExcel_Style_Alignment::HORIZONTAL_CENTER,),
                );
            $ews->getStyle($header)->applyFromArray($style);
                      for ($col = ord('a'); $col <= ord('h'); $col++)
            {
                $ews->getColumnDimension(chr($col))->setAutoSize(true);
            }
         
        //Data Series Labels
        $dsl=array(
                        new PHPExcel_Chart_DataSeriesValues('String', 'Data!$C$1', NULL, 1),
                        new PHPExcel_Chart_DataSeriesValues('String', 'Data!$D$1', NULL, 1),
        
                    );
        //X Axis Value Label
        $xal=array(
                        new PHPExcel_Chart_DataSeriesValues('String', 'Data!$E$2:$E$15', NULL, 15),
                    );
        //Data Series Values
        $dsv=array(
                        new PHPExcel_Chart_DataSeriesValues('Number', 'Data!$C$2:$C$15', NULL, 15),
                        new PHPExcel_Chart_DataSeriesValues('Number', 'Data!$D$2:$D$15', NULL, 15),
                    );
        //set up Data Series
        $ds=new PHPExcel_Chart_DataSeries(
                            PHPExcel_Chart_DataSeries::TYPE_LINECHART,
                            PHPExcel_Chart_DataSeries::GROUPING_STANDARD,
                            range(0, count($dsv)-1),
                            $dsl,
                            $xal,
                            $dsv
                            );
        //create the Plot Area and Legend
        $pa=new PHPExcel_Chart_PlotArea(NULL, array($ds));
        $legend=new PHPExcel_Chart_Legend(PHPExcel_Chart_Legend::POSITION_RIGHT, NULL, false);
         //title of chart
        $title=new PHPExcel_Chart_Title('Score Details');
        //create chart
        $chart= new PHPExcel_Chart(
                            'chart1',
                            $title,
                            $legend,
                            $pa,
                            true,
                            0,
                            NULL, 
                            NULL
                            );
        
        $chart->setTopLeftPosition('K1');
        $chart->setBottomRightPosition('R15');
        $ews->addChart($chart);
        
      
            $filename="Game-data-".date("Y-m-d-H-i-s").".xlsx";
     
        //access to download the file
       header('Content-Type: application/vnd.openxmlformats-officedocument.spreedsheetml.sheet');
         header('Content-Disposition: attachment;filename="'.$filename.'"');
        header('Cache-COntrol: max-age=0');
        
    
        $objPHPWriter = \PHPExcel_IOFactory::createWriter($ea, 'Excel2007');
        $objPHPWriter->setIncludeCharts(TRUE);
        $objPHPWriter->save('php://output');

           exit;
         
    }
    function excelDown()
    {
        $fromdate=$this->input->post('ExFROM_DATE');
        $todate=$this->input->post('ExTO_DATE');
		
        $this->load->model('Safetygame_model');
        if($this ->session -> userdata('roleid') == 4)
        {
            $roleId = 2;
            $TeamLeadList = $this -> Safetygame_model -> getUserforRoleId($roleId);
        }
        else{
            $userKey = $this ->session -> userdata('uid');
            $TeamLeadList = $this -> Safetygame_model -> getUserforReportId($userKey);
        }
        
       $begin = new DateTime($fromdate);
       $end = clone $begin;

       // this will default to a time of 00:00:00    
       $end->modify($todate); // 2016-07-08
        
       $end->setTime(0,0,1);
        //$end = new DateTime($todate);
        
       $daterange = new DatePeriod($begin, new DateInterval('P1D'), $end);
       $i=0;
       $s=0;
       $j=0;
       $k=0;
       
       $propertymstr = $this -> Safetygame_model -> getPropertymstr();
       foreach($propertymstr as $property)
       {
           if($property->PROPERTY_KEY=='PLAYCOUNT_DISTANCE')
           {
               $distance = $property->PROPERTY_VALUE;
           }
       }
       
       $scenarioDesc = $this ->Safetygame_model -> getScenarioCategoryMstr();
       
       $questresult = array();
       $resultScore = array();
       $result = array();
       $violationresult = array();
   
       $day =0;
       foreach($daterange as $date)
       {
           $k=0;
           $playeddate=$date->format("Y-m-d");
           $day += 1;
           foreach($TeamLeadList as $team)
           {
               
               $safetyscore=0;
               $gamescore=0; 
               $playerdistance=0;
               
               $empuserkey = $team->USER_KEY;
              
               
               $teamregDateTemp = $team->REGISTERED_DATE;
			   $teamregDate = new DateTime($teamregDateTemp);			   
               $teamleadtodate = new DateTime($todate);
               $diff=date_diff($teamregDate,$teamleadtodate);  //to find the dates between 2 dates 
               $qteamcount= $diff->format("%a")+1;  //to get the number of days
               
                $teamleadregDate = $teamregDate->format("Y-m-d");
               $EmpList = $this -> Safetygame_model -> getUserforReportId($empuserkey);
               foreach($EmpList as $emp)
               {
                    
                   $safetyscore=0;
                   $gamescore=0;
                   $playerdistance=0;
                   $empkey = $emp->USER_KEY;
                  
                   
                   $empDateTemp = $emp->REGISTERED_DATE;
				   $empDate = new DateTime($empDateTemp);
                   $emptodate = new DateTime($todate);
                   $diff=date_diff($empDate,$emptodate);
                   $qempcount= $diff->format("%a")+1;
                   
                   $empregDate = $empDate->format("Y-m-d");
                   $EmpPlayedgame = $this -> Safetygame_model -> PlayedReportforexcel($empkey,$playeddate);
            
                   if(sizeof($EmpPlayedgame)>0)
                   {
                       $safetyscore= $EmpPlayedgame[0]->SAFETY_SCORE;
                       $gamescore = $EmpPlayedgame[0]->GAME_SCORE;
                       $playerdistance=$EmpPlayedgame[0]->DISTANCE;
                       if($EmpPlayedgame[0]->DISTANCE>=$distance)
                       {
                           $played = 'Yes';
                           $resultScore[$s]['Employee_Name']=($emp->FIRST_NAME).' '.($emp->LAST_NAME);
                           $resultScore[$s]['Date']= $date->format("Y-m-d");
                           $resultScore[$s]['Safety_Score']=$safetyscore;
                           $resultScore[$s]['Game_Score']=$gamescore;
                           $resultScore[$s]['Distance']=$playerdistance;
                           $resultScore[$s]['percentage']=round(($safetyscore/$playerdistance)*100,2);
                           $s++;
                       }
                       else {
                           $played = 'No';
                       }
                   }
                   else {
                       $played = 'No';
                   }
                   if($played=='No')
                   {
                       $result[$i]['Employee_Name']=($emp->FIRST_NAME).' '.($emp->LAST_NAME);
                       $result[$i]['Date']= $date->format("Y-m-d");
                       $result[$i]['Played_Game']=$played;
                       $i++;
                   }
                   
                   $empviolation = $this ->Safetygame_model -> PlayedVoilationcntforexcel($empkey,$playeddate);
                   if(sizeof($empviolation)>0)
                   {
                       $totalviolation = 0;
                       $violationresult[$j]['Employee_Name'] = ($emp->FIRST_NAME).' '.($emp->LAST_NAME);
                       
                       foreach ($scenarioDesc as $scenarioData) 
                       {
                           $violationcnt=0;
                           $scenarioname=str_replace(" ","_",$scenarioData->SCENARIO_CATEGORY_DESC);
                           if(sizeof($empviolation)>0)
                           {
                               foreach($empviolation as $key => $violation)
                               {
                                   $violationdistance = $violation->DISTANCE;
                                   
                                   if($scenarioData->SCENARIO_CATEGORY_DESC == $violation->SCENARIO_CATEGORY_DESC)
                                   {
                                       $violationcnt=$violation->VIOLATION_COUNT;
                                       $violationresult[$j][$scenarioname] = $violationcnt;
                                       $totalviolation += $violationcnt;
                                       unset($empviolation[$key]); //to remove current index row
                                       break;
                                   }
                                   else {
                                       $violationresult[$j][$scenarioname] = $violationcnt;
                                       $totalviolation += $violationcnt;
                                   }
                               }
                           }
                           else {
                               $violationresult[$j][$scenarioname] = $violationcnt;
                               $totalviolation += $violationcnt;
                           }
                       }
if($violationdistance==0)
{
    $violationdistance=1;
}
                       $violationresult[$j]['Violation_Ratio'] = round($totalviolation/$violationdistance,2);
                       $violationresult[$j]['Date'] = $date->format("Y-m-d");
                       $j++;
                   }
                   
                   $empquest = $this ->Safetygame_model -> Questcompforexcel($empkey,$empregDate,$todate);
                   // to get day wise count
                   // if(count($empquest)>0)
                   // {
                       // if(count($questresult)>0)
                       // {
                           // for($val=count($questresult)-1;$val>=0;$val--)
                           // {
                               // if($questresult[$val]['Employee_Name']==($emp->FIRST_NAME).' '.($emp->LAST_NAME))
                               // {
                                   // $equestcount= $questresult[$val]['Quest_completed'];
                               // $emquest= (int)$empquest[0]->COMPLETED_QUEST;
                                   // $questcomp = $equestcount+$emquest;
                                // break;
                               // }
                                // else{
                           // $questcomp =(int)$empquest[0]->COMPLETED_QUEST;
                       // }
                           // }
                       // }
                       // else{
                           // $questcomp =(int)$empquest[0]->COMPLETED_QUEST;
                       // } 
                   // }
                   // else {
                       // $questcomp = 0;
                   // }
                   
                   $questresult[$k]['Employee_Name'] = ($emp->FIRST_NAME).' '.($emp->LAST_NAME);
                   $questresult[$k]['Day_No'] = $qempcount;
                   $questresult[$k]['Quest_completed'] = $empquest[0]->COMPLETED_QUEST;
                   $questresult[$k]['Quest_Ratio'] = round($empquest[0]->COMPLETED_QUEST/$qempcount,2);
                   $k++;
               }

               $TeamleadPlayedgame = $this -> Safetygame_model -> PlayedReportforexcel($empuserkey,$playeddate);
               if(sizeof($TeamleadPlayedgame)>0)
               {
                   $safetyscore= $TeamleadPlayedgame[0]->SAFETY_SCORE;
                   $gamescore = $TeamleadPlayedgame[0]->GAME_SCORE;
                   $playerdistance=$TeamleadPlayedgame[0]->DISTANCE;
                   if($TeamleadPlayedgame[0]->DISTANCE>=$distance)
                   {
                       $played = 'Yes';
                       $resultScore[$s]['Employee_Name']=($team->FIRST_NAME).' '.($team->LAST_NAME);
                       $resultScore[$s]['Date']= $date->format("Y-m-d");
                       $resultScore[$s]['Safety_Score']=$safetyscore;
                       $resultScore[$s]['Game_Score']=$gamescore;
                       $resultScore[$s]['Distance']=$playerdistance;
                       $resultScore[$s]['percentage']=round(($safetyscore/$playerdistance)*100,2);
                       $s++;
                   }
                   else {
                       $played = 'No';
                   }
               }
               else {
                   $played = 'No';
               }
               if($played == 'No')
               {
                   $result[$i]['Employee_Name']=($team->FIRST_NAME).' '.($team->LAST_NAME);
                   $result[$i]['Date']= $date->format("Y-m-d");
                   $result[$i]['Played_Game']=$played;
                   $i++;
               }
               $TeamLeadviolation = $this ->Safetygame_model -> PlayedVoilationcntforexcel($empuserkey,$playeddate);
               if(sizeof($TeamLeadviolation)>0)
               {
                   $totalviolation = 0; 
                   $violationresult[$j]['Employee_Name'] = ($team->FIRST_NAME).' '.($team->LAST_NAME);
                   
                   foreach ($scenarioDesc as $scenarioData)
                   {
                       $violationcnt =0;
                       $scenarioname=str_replace(" ","_",$scenarioData->SCENARIO_CATEGORY_DESC);
                       
                       if(sizeof($TeamLeadviolation)>0)
                       {
                           foreach($TeamLeadviolation as $key => $teamviolation)
                           {
                               $violationdistance = $teamviolation->DISTANCE;
                               if($scenarioData->SCENARIO_CATEGORY_DESC == $teamviolation->SCENARIO_CATEGORY_DESC)
                               {
                                   $violationcnt=$teamviolation->VIOLATION_COUNT;
                                   $violationresult[$j][$scenarioname] = $violationcnt;
                                   $totalviolation += $violationcnt;
                                   unset($TeamLeadviolation[$key]);
                                   break;
                               }
                               else {
                                   $violationresult[$j][$scenarioname] = $violationcnt;
                                   $totalviolation += $violationcnt;
                               }
                           }
                       }
                       else {
                           $violationresult[$j][$scenarioname] = $violationcnt;
                           $totalviolation += $violationcnt;
                       }
                   }
if($violationdistance==0)
{
    $violationdistance=1;
}
                   $violationresult[$j]['Violation_Ratio'] = round($totalviolation/$violationdistance,2);
                   $violationresult[$j]['Date'] = $date->format("Y-m-d");
                   $j++;
               }
               $teamleadquest = $this ->Safetygame_model -> Questcompforexcel($empuserkey,$teamleadregDate,$todate);
                   // if(count($teamleadquest)>0)
                   // {
                       // if(count($questresult)>0)
                       // {
                           // for($val=count($questresult)-1;$val>=0;$val--)
                           // {
                               // if($questresult[$val]['Employee_Name']==($team->FIRST_NAME).' '.($team->LAST_NAME))
                               // {
                                   // $questcount= $questresult[$val]['Quest_completed'];
                               // $tequest= (int)$teamleadquest[0]->COMPLETED_QUEST;
                                   // $questcomp = $questcount+$tequest;
                                // break;
                               // }
                                // else{
                           // $questcomp =(int)$teamleadquest[0]->COMPLETED_QUEST;
                       // }
                           // }
                       // }
                       // else{
                           // $questcomp =(int)$teamleadquest[0]->COMPLETED_QUEST;
                       // }
                   // }
                   // else {
                       // $questcomp = 0;
                   // }
                   
               $questresult[$k]['Employee_Name'] = ($team->FIRST_NAME).' '.($team->LAST_NAME);
               $questresult[$k]['Day_No'] = $qteamcount;
               $questresult[$k]['Quest_completed'] = $teamleadquest[0]->COMPLETED_QUEST;
               $questresult[$k]['Quest_Ratio'] = round($teamleadquest[0]->COMPLETED_QUEST/$qteamcount,2);
               $k++;
           }
       }
       //to sort array value in desc order
       $violationsort = array();
       foreach($violationresult as $k=>$v) {
           $violationsort['Violation_Ratio'][$k] = $v['Violation_Ratio'];
       }
       array_multisort($violationsort['Violation_Ratio'], SORT_ASC, $violationresult);
       
       $questsort = array();
       foreach($questresult as $k=>$v) {
           $questsort['Quest_Ratio'][$k] = $v['Quest_Ratio'];
       }
       array_multisort($questsort['Quest_Ratio'], SORT_ASC, $questresult);

       require(APPPATH.'third_party/PHPExcel.php');
       require(APPPATH.'third_party/PHPExcel/Writer/Excel2007.php');
          
       //instance of phpexcel
       $objPHPExcel = new PHPExcel();
           
       //set basic standard properties
       $objPHPExcel->getProperties()->setCreator("");
       $objPHPExcel->getProperties()->setLastModifiedBy("");
       $objPHPExcel->getProperties()->setTitle("");
       $objPHPExcel->getProperties()->setSubject("");
       $objPHPExcel->getProperties()->setDescription("");
          
       //create active sheet
       $objPHPExcel->setActiveSheetIndex(0);
       $ews = $objPHPExcel->getSheet(0);
       
       //set data values 
       $objPHPExcel->getActiveSheet()->SetCellValue('A1','Employee Name');
       $objPHPExcel->getActiveSheet()->SetCellValue('B1','Date');
       $objPHPExcel->getActiveSheet()->SetCellValue('C1','Game Played');
          
       //add rows to excel
       $row = 2;
       //data is fetched from database
       for($val=count($result)-1;$val>=0;$val--)  
       {
           $objPHPExcel->getActiveSheet()->setCellValue('A'.$row,$result[$val]['Employee_Name']);
           $objPHPExcel->getActiveSheet()->setCellValue('B'.$row,$result[$val]['Date']);
           $objPHPExcel->getActiveSheet()->setCellValue('C'.$row,$result[$val]['Played_Game']);
              
           $row++;
       }
       $objPHPExcel->getActiveSheet()->setTitle("Players who did not play");
       
       $header = 'a1:c1';
       $ews->getStyle($header)->getFill()->setFillType(\PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setARGB('ffffffff');
       $style = array(
                'font' => array('bold' => true,),
                'alignment' => array('horizontal' => \PHPExcel_Style_Alignment::HORIZONTAL_CENTER,),
                'borders' => array(
                'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN
                )
                )
                );
       $ews->getStyle($header)->applyFromArray($style);
       for ($col = ord('a'); $col <= ord('c'); $col++)
       {
           $ews->getColumnDimension(chr($col))->setAutoSize(true);
       }
       
       // Create a new worksheet, after the default sheet
       $objPHPExcel->createSheet();

       // Add some data to the second sheet, resembling some different data types
       $objPHPExcel->setActiveSheetIndex(1);
       $ews2 = $objPHPExcel->getSheet(1);
       
       //set data values 
       $objPHPExcel->getActiveSheet()->SetCellValue('A1','Employee Name');
       $objPHPExcel->getActiveSheet()->SetCellValue('B1','Date');
       $objPHPExcel->getActiveSheet()->SetCellValue('C1','Health Lost');
       $objPHPExcel->getActiveSheet()->SetCellValue('D1','Game Score');
       $objPHPExcel->getActiveSheet()->SetCellValue('E1','Distance');
       $objPHPExcel->getActiveSheet()->SetCellValue('F1','Health Lost/Distance (in %)');
          
       $row = 2;
      
       foreach ($resultScore as $value) {
           $objPHPExcel->getActiveSheet()->setCellValue('A'.$row,$value['Employee_Name']);
           $objPHPExcel->getActiveSheet()->setCellValue('B'.$row,$value['Date']);
           $objPHPExcel->getActiveSheet()->setCellValue('C'.$row,$value['Safety_Score']);
           $objPHPExcel->getActiveSheet()->setCellValue('D'.$row,$value['Game_Score']);
           $objPHPExcel->getActiveSheet()->setCellValue('E'.$row,$value['Distance']);
           $objPHPExcel->getActiveSheet()->setCellValue('F'.$row,$value['percentage']);
           $row++;
       }
       $objPHPExcel->getActiveSheet()->setTitle("List by Most Risk Taking Player");
       
       $header = 'a1:f1';
       $ews2->getStyle($header)->getFill()->setFillType(\PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setARGB('ffffffff');
       $style = array(
                'font' => array('bold' => true,),
                'alignment' => array('horizontal' => \PHPExcel_Style_Alignment::HORIZONTAL_CENTER,),
                'borders' => array(
                'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN
                )
                )
                );
       $ews2->getStyle($header)->applyFromArray($style);
       for ($col = ord('a'); $col <= ord('f'); $col++)
       {
           $ews2->getColumnDimension(chr($col))->setAutoSize(true);
       }

       // Create a new worksheet, after the default sheet
       $objPHPExcel->createSheet();

       // Add some data to the second sheet, resembling some different data types
       $objPHPExcel->setActiveSheetIndex(2);
       $ews3 = $objPHPExcel->getSheet(2);
          
       //set data values 
       $objPHPExcel->getActiveSheet()->SetCellValue('A1','Employee Name');
       $i=1;
        foreach ($scenarioDesc as $scenarioData) {
           
                
           $columnLetter = PHPExcel_Cell::stringFromColumnIndex($i);
           $objPHPExcel->getActiveSheet()->SetCellValue($columnLetter.'1',$scenarioData->SCENARIO_CATEGORY_DESC);
           
          $i++;
       }
      $columnLetter = PHPExcel_Cell::stringFromColumnIndex($i);
      $objPHPExcel->getActiveSheet()->SetCellValue($columnLetter.'1','Violation_Ratio');
      $i++;
       $columnLetter = PHPExcel_Cell::stringFromColumnIndex($i);
       $objPHPExcel->getActiveSheet()->SetCellValue($columnLetter.'1','Date');
       
       $row = 2;
          
       foreach ($violationresult as $value) 
       {
           $objPHPExcel->getActiveSheet()->setCellValue('A'.$row,$value['Employee_Name']);
           $i=1;
           foreach ($scenarioDesc as $scenarioData) {
               $scenario=str_replace(" ","_",$scenarioData->SCENARIO_CATEGORY_DESC);
               
               $columnLetter = PHPExcel_Cell::stringFromColumnIndex($i);
               $objPHPExcel->getActiveSheet()->SetCellValue($columnLetter.$row,$value[$scenario]);
               $i++;
            }
            $columnLetter = PHPExcel_Cell::stringFromColumnIndex($i);
            $objPHPExcel->getActiveSheet()->setCellValue($columnLetter.$row,$value['Violation_Ratio']);
            $i++;
            
           $columnLetter = PHPExcel_Cell::stringFromColumnIndex($i);
           $objPHPExcel->getActiveSheet()->setCellValue($columnLetter.$row,$value['Date']);
              
           $row++;
       }
       $objPHPExcel->getActiveSheet()->setTitle("List by Most Player Violations");
       
       $header = 'a1:z1';
       $ews3->getStyle($header)->getFill()->setFillType(\PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setARGB('ffffffff');
       $style = array(
                'font' => array('bold' => true,),
                'alignment' => array('horizontal' => \PHPExcel_Style_Alignment::HORIZONTAL_CENTER,),
                'borders' => array(
                'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN
                )
                )
                );
       $ews3->getStyle($header)->applyFromArray($style);
       for ($col = ord('a'); $col <= ord('z'); $col++)
       {
           $ews3->getColumnDimension(chr($col))->setAutoSize(true);
       }
       // Create a new worksheet, after the default sheet
       $objPHPExcel->createSheet();

       // Add some data to the second sheet, resembling some different data types
       $objPHPExcel->setActiveSheetIndex(3);
       $ews4 = $objPHPExcel->getSheet(3);
          
       //set data values 
       $objPHPExcel->getActiveSheet()->SetCellValue('A1','Employee Name');
       $objPHPExcel->getActiveSheet()->SetCellValue('B1','Day No.');
       $objPHPExcel->getActiveSheet()->SetCellValue('C1','No of Quest Completed');
       $objPHPExcel->getActiveSheet()->SetCellValue('D1','Quest_Ratio');
       
       $row = 2;
          
       foreach ($questresult as $value) {
           $objPHPExcel->getActiveSheet()->setCellValue('A'.$row,$value['Employee_Name']);
           $objPHPExcel->getActiveSheet()->setCellValue('B'.$row,$value['Day_No']);
           $objPHPExcel->getActiveSheet()->setCellValue('C'.$row,$value['Quest_completed']);
           $objPHPExcel->getActiveSheet()->setCellValue('D'.$row,$value['Quest_Ratio']);
              
           $row++;
       }
       $objPHPExcel->getActiveSheet()->setTitle("List by Player completed Quest");
       
       $header = 'a1:d1';
       $ews4->getStyle($header)->getFill()->setFillType(\PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setARGB('ffffffff');
       $style = array(
                'font' => array('bold' => true,),
                'alignment' => array('horizontal' => \PHPExcel_Style_Alignment::HORIZONTAL_CENTER,),
                'borders' => array(
                'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN
                )
                )
                );
       $ews4->getStyle($header)->applyFromArray($style);
       for ($col = ord('a'); $col <= ord('d'); $col++)
       {
           $ews4->getColumnDimension(chr($col))->setAutoSize(true);
       }
       // create filename
       $filename="Game-Report-on-".date("Y-m-d-H-i-s").".xlsx";
       //create title of file
       $objPHPExcel->setActiveSheetIndex(0) ;
          
       //access to download the file
       header('Content-Type: application/vnd.openxmlformats-officedocument.spreedsheetml.sheet');
       header('Content-Disposition: attachment;filename="'.$filename.'"');
       header('Cache-COntrol: max-age=0');
        
       $objWriter = \PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
       $objWriter->save('php://output');
         
       exit;
    }

    function excelEmail()
    {
        $date = (new DateTime('now-1day'));
        $previousdate = $date->format('Y-m-d');
 
        $this->load->model('Safetygame_model');
        if($this ->session -> userdata('roleid') == 4)
        {
            $roleId = 2;
            $TeamLeadList = $this -> Safetygame_model -> getUserforRoleId($roleId);
        }
        else{
            $userKey = $this ->session -> userdata('uid');
            $TeamLeadList = $this -> Safetygame_model -> getUserforReportId($userKey);
        }
        
        $propertymstr = $this -> Safetygame_model -> getPropertymstr();
        foreach($propertymstr as $property)
        {
            if($property->PROPERTY_KEY=='PLAYCOUNT_DISTANCE')
            {
                $distance = $property->PROPERTY_VALUE;
            }
        }
        $scenarioDesc = $this ->Safetygame_model -> getScenarioCategoryMstr();
         
        foreach($TeamLeadList as $team)
        {
            $i=0;
            $j=0;
            $k=0;
            $s=0;
            
            $result=array();
            $violationresult=array();      
            $resultScore = array();  
            $safetyscore=0;
            $gamescore=0; 
            $questresult = array();
           // $day=0;
     
            $empuserkey = $team->USER_KEY;
           
            
            $teamregDateTemp = $team->REGISTERED_DATE;
			$teamregDate = new DateTime($teamregDateTemp);
            $teamleadtodate = new DateTime($previousdate);
            
            $diff=date_diff($teamregDate,$teamleadtodate);
            $qteamcount= $diff->format("%a")+1;
            
             $teamleadregDate = $teamregDate->format('Y-m-d');
            $teamLeadEmail = $team->EMAIL;
            //to get quest count date wise
             // for($q=1;$q<=$qcount;$q++)
        // {
           // $qdate=$date1->format('Y-m-d');
            //echo $qdate;
            //$day +=1;
            $EmpList = $this -> Safetygame_model -> getUserforReportId($empuserkey);
            foreach($EmpList as $emp)
            {
                $safetyscore=0;
                $gamescore=0;
                $empkey = $emp->USER_KEY;
                $empregDate = 
                
                $empDate = new DateTime($emp->REGISTERED_DATE);
                $emptodate = new DateTime($previousdate);
                
                $diff=date_diff($empDate,$emptodate);
                $qempcount= $diff->format("%a")+1;
                
                $empregDate = $empDate->format('Y-m-d');
                $EmpPlayedgame = $this -> Safetygame_model -> PlayedReportforexcel($empkey,$previousdate);
            
                if(sizeof($EmpPlayedgame)>0)
                {
                    $safetyscore= $EmpPlayedgame[0]->SAFETY_SCORE;
                    $gamescore = $EmpPlayedgame[0]->GAME_SCORE;
                    $playerdistance=$EmpPlayedgame[0]->DISTANCE;
                    
                    if($EmpPlayedgame[0]->DISTANCE>=$distance)
                    {
                        $played = 'Yes';
                        $resultScore[$s]['Employee_Name']=($emp->FIRST_NAME).' '.($emp->LAST_NAME);
                        $resultScore[$s]['Date']= $date->format("Y-m-d");
                        $resultScore[$s]['Safety_Score']=$safetyscore;
                        $resultScore[$s]['Game_Score']=$gamescore;
                        $resultScore[$s]['Distance']=$playerdistance;
                        $resultScore[$s]['percentage']=round(($safetyscore/$playerdistance)*100,2);
                        $s++;
                    }
                    else {
                        $played = 'No';
                    }
                }
                else {
                    $played = 'No';
                }
                if($played == 'No')
                {
                    $result[$i]['Employee_Name']=($emp->FIRST_NAME).' '.($emp->LAST_NAME);
                    $result[$i]['Date']= $previousdate;
                    $result[$i]['Played_Game']=$played;
                    $i++;
                }
                
                $empviolation = $this ->Safetygame_model -> PlayedVoilationcntforexcel($empkey,$previousdate);
                if(sizeof($empviolation)>0)
                {
                    $totalviolation = 0;
                    $violationresult[$j]['Employee_Name'] = ($emp->FIRST_NAME).' '.($emp->LAST_NAME);
                       
                    foreach ($scenarioDesc as $scenarioData) 
                    {
                        $violationcnt=0;
                        $scenarioname=str_replace(" ","_",$scenarioData->SCENARIO_CATEGORY_DESC);
                           
                        if(sizeof($empviolation)>0)
                        {
                            foreach($empviolation as $key => $violation)
                            {
                                $violationdistance = $violation->DISTANCE;
                                if($scenarioData->SCENARIO_CATEGORY_DESC == $violation->SCENARIO_CATEGORY_DESC)
                                {
                                    $violationcnt=$violation->VIOLATION_COUNT;
                                    $violationresult[$j][$scenarioname] = $violationcnt;
                                    $totalviolation += $violationcnt;
                                    unset($empviolation[$key]);
                                    break;
                                }
                                else {
                                    $violationresult[$j][$scenarioname] = $violationcnt;
                                    $totalviolation += $violationcnt;
                                }
                            }
                        }
                        else {
                            $violationresult[$j][$scenarioname] = $violationcnt;
                            $totalviolation += $violationcnt;
                        }
                    }
                    $violationresult[$j]['Violation_Ratio'] = round($totalviolation/$violationdistance,2);
                    $violationresult[$j]['Date'] = $date->format("Y-m-d");
                    $j++;
                }
                $empquest = $this ->Safetygame_model -> Questcompforexcel($empkey,$empregDate,$previousdate);
                  
                $questresult[$k]['Employee_Name'] = ($emp->FIRST_NAME).' '.($emp->LAST_NAME);
                $questresult[$k]['Day_No'] = $qempcount;
                $questresult[$k]['Quest_completed'] = $empquest[0]->COMPLETED_QUEST;
                $questresult[$k]['Quest_Ratio'] = round($empquest[0]->COMPLETED_QUEST/$qempcount,2);
                $k++;
            }
            $TeamleadPlayedgame = $this -> Safetygame_model -> PlayedReportforexcel($empuserkey,$previousdate);
            if(sizeof($TeamleadPlayedgame)>0)
            {
                $safetyscore= $TeamleadPlayedgame[0]->SAFETY_SCORE;
                $gamescore = $TeamleadPlayedgame[0]->GAME_SCORE;
                $playerdistance=$TeamleadPlayedgame[0]->DISTANCE;
                if($TeamleadPlayedgame[0]->DISTANCE>=$distance)
                {
                    $played = 'Yes';
                    $resultScore[$s]['Employee_Name']=($team->FIRST_NAME).' '.($team->LAST_NAME);
                    $resultScore[$s]['Date']= $date->format("Y-m-d");
                    $resultScore[$s]['Safety_Score']=$safetyscore;
                    $resultScore[$s]['Game_Score']=$gamescore;
                    $resultScore[$s]['Distance']=$playerdistance;
                    $resultScore[$s]['percentage']=round(($safetyscore/$playerdistance)*100,2);
                    $s++;
                }
                else {
                    $played = 'No';
                }
            }
            else {
                $played = 'No';
            }
            if($played == 'No')
            {
                $result[$i]['Employee_Name']=($team->FIRST_NAME).' '.($team->LAST_NAME);
                $result[$i]['Date']= $previousdate;
                $result[$i]['Played_Game']=$played;
                $i++;
            }
           
            $TeamLeadviolation = $this ->Safetygame_model -> PlayedVoilationcntforexcel($empuserkey,$previousdate);
            if(sizeof($TeamLeadviolation)>0)
            {
                $totalviolation = 0;   
                $violationresult[$j]['Employee_Name'] = ($team->FIRST_NAME).' '.($team->LAST_NAME);
                foreach ($scenarioDesc as $scenarioData) 
                {
                    $violationcnt =0;
                    $scenarioname=str_replace(" ","_",$scenarioData->SCENARIO_CATEGORY_DESC);
                    if(sizeof($TeamLeadviolation)>0)
                    {
                        foreach($TeamLeadviolation as $key => $teamviolation)
                        {
                            $violationdistance = $teamviolation->DISTANCE;
                            if($scenarioData->SCENARIO_CATEGORY_DESC == $teamviolation->SCENARIO_CATEGORY_DESC)
                            {
                                $violationcnt=$teamviolation->VIOLATION_COUNT;
                                $violationresult[$j][$scenarioname] = $violationcnt;
                                $totalviolation += $violationcnt;
                                unset($TeamLeadviolation[$key]);
                                break;
                            }
                            else {
                                $violationresult[$j][$scenarioname] = $violationcnt;
                                $totalviolation += $violationcnt;
                            }
                        }
                    }
                    else {
                        $violationresult[$j][$scenarioname] = $violationcnt;
                        $totalviolation += $violationcnt;
                    }
                }
                $violationresult[$j]['Violation_Ratio'] = round($totalviolation/$violationdistance,2);
                $violationresult[$j]['Date'] = $date->format("Y-m-d");
                $j++;
            }
          
            $teamleadquest = $this ->Safetygame_model -> Questcompforexcel($empuserkey,$teamleadregDate,$previousdate);
                   
            $questresult[$k]['Employee_Name'] = ($team->FIRST_NAME).' '.($team->LAST_NAME);
            $questresult[$k]['Day_No'] = $qteamcount;
            $questresult[$k]['Quest_completed'] = $teamleadquest[0]->COMPLETED_QUEST;
            $questresult[$k]['Quest_Ratio'] = round($teamleadquest[0]->COMPLETED_QUEST/$qteamcount,2);
            $k++;
                      
            //  date_add($date1, date_interval_create_from_date_string('1 days')); //to add 1 date to the date
      //  }
      
          //to sort array value in desc order
            $violationsort = array();
            foreach($violationresult as $k=>$v) {
                $violationsort['Violation_Ratio'][$k] = $v['Violation_Ratio'];
            }
            array_multisort($violationsort['Violation_Ratio'], SORT_ASC, $violationresult);
           
            $questsort = array();
            foreach($questresult as $k=>$v) {
                $questsort['Quest_Ratio'][$k] = $v['Quest_Ratio'];
            }
            array_multisort($questsort['Quest_Ratio'], SORT_ASC, $questresult);
       
            $this->mailteamdata($result,$resultScore,$violationresult,$questresult,$teamLeadEmail);
        }
        redirect('game/Main');
    }
    
    function mailteamdata($result,$resultScore,$violationresult,$questresult,$teamLeadEmail)
    {
        require_once(APPPATH.'third_party/PHPExcel.php');
        require_once (APPPATH.'third_party/PHPExcel/Writer/Excel2007.php');
        
        $this->load->model('Safetygame_model');  
        $scenarioDesc = $this ->Safetygame_model -> getScenarioCategoryMstr();
        //instance of phpexcel
        $objPHPExcel = new PHPExcel();
           
        //set basic standard properties
        $objPHPExcel->getProperties()->setCreator("");
        $objPHPExcel->getProperties()->setLastModifiedBy("");
        $objPHPExcel->getProperties()->setTitle("");
        $objPHPExcel->getProperties()->setSubject("");
        $objPHPExcel->getProperties()->setDescription("");
          
        //create active sheet
        $objPHPExcel->setActiveSheetIndex(0);
        $ews = $objPHPExcel->getSheet(0);
        //set data values 
        $objPHPExcel->getActiveSheet()->SetCellValue('A1','Employee Name');
        $objPHPExcel->getActiveSheet()->SetCellValue('B1','Date');
        $objPHPExcel->getActiveSheet()->SetCellValue('C1','Game Played');
          
        //add rows to excel
        $row = 2;
        //data is fetched from database
        for($val=count($result)-1;$val>=0;$val--)
              {
        // foreach ($result as $value) 
        // {
            $objPHPExcel->getActiveSheet()->setCellValue('A'.$row,$result[$val]['Employee_Name']);
            $objPHPExcel->getActiveSheet()->setCellValue('B'.$row,$result[$val]['Date']);
            $objPHPExcel->getActiveSheet()->setCellValue('C'.$row,$result[$val]['Played_Game']);
              
            $row++;
        }
        $objPHPExcel->getActiveSheet()->setTitle("Players who did not play");
        
        $header = 'a1:c1';
        $ews->getStyle($header)->getFill()->setFillType(\PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setARGB('ffffffff');
        $style = array(
                 'font' => array('bold' => true,),
                 'alignment' => array('horizontal' => \PHPExcel_Style_Alignment::HORIZONTAL_CENTER,),
                 'borders' => array(
                 'allborders' => array(
                 'style' => PHPExcel_Style_Border::BORDER_THIN
                 )
                 )
                 );
                 
        $ews->getStyle($header)->applyFromArray($style);
        for ($col = ord('a'); $col <= ord('c'); $col++)
        {
            $ews->getColumnDimension(chr($col))->setAutoSize(true);
        }
        // Create a new worksheet, after the default sheet
        $objPHPExcel->createSheet();

        // Add some data to the second sheet, resembling some different data types
        $objPHPExcel->setActiveSheetIndex(1);
        $ews2 = $objPHPExcel->getSheet(1);
        //set data values 
        $objPHPExcel->getActiveSheet()->SetCellValue('A1','Employee Name');
       $objPHPExcel->getActiveSheet()->SetCellValue('B1','Date');
       $objPHPExcel->getActiveSheet()->SetCellValue('C1','Health Lost');
       $objPHPExcel->getActiveSheet()->SetCellValue('D1','Game Score');
       $objPHPExcel->getActiveSheet()->SetCellValue('E1','Distance');
       $objPHPExcel->getActiveSheet()->SetCellValue('F1','Health Lost/Distance (in %)');
        //add rows to excel
        $row = 2;
        //data is fetched from database
        foreach ($resultScore as $value) {
            $objPHPExcel->getActiveSheet()->setCellValue('A'.$row,$value['Employee_Name']);
            $objPHPExcel->getActiveSheet()->setCellValue('B'.$row,$value['Date']);
            $objPHPExcel->getActiveSheet()->setCellValue('C'.$row,$value['Safety_Score']);
            $objPHPExcel->getActiveSheet()->setCellValue('D'.$row,$value['Game_Score']);
            $objPHPExcel->getActiveSheet()->setCellValue('E'.$row,$value['Distance']);
            $objPHPExcel->getActiveSheet()->setCellValue('F'.$row,$value['percentage']);
              
            $row++;
        }
        $objPHPExcel->getActiveSheet()->setTitle("List by Most Risk Taking Player");
        
        $header = 'a1:f1';
        $ews2->getStyle($header)->getFill()->setFillType(\PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setARGB('ffffffff');
        $style = array(
                 'font' => array('bold' => true,),
                 'alignment' => array('horizontal' => \PHPExcel_Style_Alignment::HORIZONTAL_CENTER,),
                 'borders' => array(
                 'allborders' => array(
                 'style' => PHPExcel_Style_Border::BORDER_THIN
                 )
                 )
                 );
        $ews2->getStyle($header)->applyFromArray($style);
        for ($col = ord('a'); $col <= ord('f'); $col++)
        {
            $ews2->getColumnDimension(chr($col))->setAutoSize(true);
        }
        
        // Create a new worksheet, after the default sheet
        $objPHPExcel->createSheet();

        // Add some data to the second sheet, resembling some different data types
        $objPHPExcel->setActiveSheetIndex(2);
        $ews3 = $objPHPExcel->getSheet(2);
        //set data values 
         $objPHPExcel->getActiveSheet()->SetCellValue('A1','Employee Name');
       $i=1;
        foreach ($scenarioDesc as $scenarioData) {
           
                
           $columnLetter = PHPExcel_Cell::stringFromColumnIndex($i);
           $objPHPExcel->getActiveSheet()->SetCellValue($columnLetter.'1',$scenarioData->SCENARIO_CATEGORY_DESC);
           
          $i++;
       }
      $columnLetter = PHPExcel_Cell::stringFromColumnIndex($i);
      $objPHPExcel->getActiveSheet()->SetCellValue($columnLetter.'1','Violation_Ratio');
      $i++;
       $columnLetter = PHPExcel_Cell::stringFromColumnIndex($i);
       $objPHPExcel->getActiveSheet()->SetCellValue($columnLetter.'1','Date');
       
       $row = 2;
          
       foreach ($violationresult as $value) {
          //$empname= $value['Employee_Name'];
          // $date = $value['Date'];
            $objPHPExcel->getActiveSheet()->setCellValue('A'.$row,$value['Employee_Name']);
              $i=1;
           foreach ($scenarioDesc as $scenarioData) {
           $scenario=str_replace(" ","_",$scenarioData->SCENARIO_CATEGORY_DESC);
              
           $columnLetter = PHPExcel_Cell::stringFromColumnIndex($i);
           $objPHPExcel->getActiveSheet()->SetCellValue($columnLetter.$row,$value[$scenario]);
           
          $i++;
       }
          $columnLetter = PHPExcel_Cell::stringFromColumnIndex($i);
           $objPHPExcel->getActiveSheet()->setCellValue($columnLetter.$row,$value['Violation_Ratio']);
           $i++;
          $columnLetter = PHPExcel_Cell::stringFromColumnIndex($i);
           $objPHPExcel->getActiveSheet()->setCellValue($columnLetter.$row,$value['Date']);
              
           $row++;
       }
        $objPHPExcel->getActiveSheet()->setTitle("List by Most Player Violations");
        
        $header = 'a1:z1';
        $ews3->getStyle($header)->getFill()->setFillType(\PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setARGB('ffffffff');
        $style = array(
                 'font' => array('bold' => true,),
                 'alignment' => array('horizontal' => \PHPExcel_Style_Alignment::HORIZONTAL_CENTER,),
                 'borders' => array(
                 'allborders' => array(
                 'style' => PHPExcel_Style_Border::BORDER_THIN
                 )
                 )
                 );
        $ews3->getStyle($header)->applyFromArray($style);
        for ($col = ord('a'); $col <= ord('z'); $col++)
        {
            $ews3->getColumnDimension(chr($col))->setAutoSize(true);
        }
        // Create a new worksheet, after the default sheet
       $objPHPExcel->createSheet();

       // Add some data to the second sheet, resembling some different data types
       $objPHPExcel->setActiveSheetIndex(3);
       $ews4 = $objPHPExcel->getSheet(3);
          
       //set data values 
       $objPHPExcel->getActiveSheet()->SetCellValue('A1','Employee Name');
       $objPHPExcel->getActiveSheet()->SetCellValue('B1','Day No.');
       $objPHPExcel->getActiveSheet()->SetCellValue('C1','No of Quest Completed');
       $objPHPExcel->getActiveSheet()->SetCellValue('D1','Quest Ratio');
       
       $row = 2;
          
       foreach ($questresult as $value) {
           $objPHPExcel->getActiveSheet()->setCellValue('A'.$row,$value['Employee_Name']);
           $objPHPExcel->getActiveSheet()->setCellValue('B'.$row,$value['Day_No']);
           $objPHPExcel->getActiveSheet()->setCellValue('C'.$row,$value['Quest_completed']);
           $objPHPExcel->getActiveSheet()->setCellValue('D'.$row,$value['Quest_Ratio']);
              
           $row++;
       }
       $objPHPExcel->getActiveSheet()->setTitle("List by Player completed Quest");
       
       $header = 'a1:d1';
       $ews4->getStyle($header)->getFill()->setFillType(\PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setARGB('ffffffff');
       $style = array(
                'font' => array('bold' => true,),
                'alignment' => array('horizontal' => \PHPExcel_Style_Alignment::HORIZONTAL_CENTER,),
                'borders' => array(
                'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN
                )
                )
                );
       $ews4->getStyle($header)->applyFromArray($style);
       for ($col = ord('a'); $col <= ord('d'); $col++)
       {
           $ews4->getColumnDimension(chr($col))->setAutoSize(true);
       }
          // create filename
          $filename="Safety Game Report ".date("Y-m-d").".xlsx";
          //create title of file
          $objPHPExcel->setActiveSheetIndex(0) ;
         //location of file saved
		$filepath = 'application/logs/'.$filename;
        $objWriter = \PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        $objWriter->save($filepath);
		$this->sendmail($filepath,$teamLeadEmail);
		unlink($filepath);//to delete saved file after sending mail
        //   redirect('game/Main');
         // exit;

        
    }

    function sendmail($file,$teamLeadEmail)
    {
        $this->load->library('email'); // load email library
        $this->email->clear(TRUE);//to clear previous attachment
        $this->email->from(supportMailId);
        $this->email->to($teamLeadEmail);
        $this->email->cc(''); 
        $this->email->subject('Safety Game Dashboard');
        $this->email->message('<p>Dear Sir,</p>
        <p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Please find attached the Safety Game Dashboard of your team.&nbsp;</p>
        <p>Regards,</p>
        <p>Safety Team</p>
        <p>(This is an automated mail. Please do not reply to this mail)</p>');
        $this->email->attach($file); // attach file
        // $this->email->attach('/path/to/file2.pdf');
        if ($this->email->send())
        {
            //$this->session->set_flashdata('msg', '<div class="alert alert-success text-center"> We have sent your Login Credential to your e-MailID <br /> Please <a href="'.base_url().'"/login/index.php">Click Here</a> to Login</div>');
            //echo "Mail Sent!";
        }
        else
        {
            // $this->session->set_flashdata('msg', '<div class="alert alert-success text-center">We cant find your email address</div>');
            show_error($this->email->print_debugger());
        }  
    }
}
?>
