<?php
include (APPPATH . 'controllers/api/Gamemasters.php');

class Login extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->helper(array('form','url','html'));
		$this->load->library(array('session', 'form_validation'));
		$this->load->database();
		$this->load->model('Safetygame_model');
		
		//unset($_SESSION['msg']); // Need to check if this line is required if the reset password are sent through mail.
	}
	public function index()
	{
		//$data['_view'] = 'trivia/login_view';
		$this->load->view('trivia/login_view');
	}
	
	function logout()
	{
		// destroy session
		$data = array('login' => '', 
					 'uname' => '',
					 'uid' => '', 
					 'clientId'=>'',
					 'usertypeid'=>'');
		$this->session->unset_userdata($data);
		$this->session->sess_destroy();
		// $data['_view'] = 'prelogin/login_view';
		// $this->load->view('layouts/main_view', $data);
		//redirect('login'); 
		redirect(BizgamesBaseURL);
	}
	function login()
	{
		$data = array('success' => false, 'messages' => array());
		$uimage = 'resources/img/blank_user.png';
		// get form input
		$emailId = $this->input->post("email");
		$password = $this->input->post("psw");

		// form validation
		$this->form_validation->set_rules("email", "Email Id", "trim|required");
		$this->form_validation->set_rules("psw", "Password", "trim|required");
			
		if ($this -> form_validation -> run()==FALSE)
		{
			//$this->session->set_flashdata('msg', '<span class="text-danger text-center">Login Error</span>');
			foreach ($_POST as $key => $value) 
			{
				$data['messages'][$key] = form_error($key);
			}               
			$this->session->set_flashdata('msg', '<span class="text-danger text-center">'.$data.'</span>');
			//redirect("login");
			redirect(BizgamesBaseURL);
			//$this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Invalid Login Credentials.</div>');
		}
		else 
		{
			// check for user credentials
			$this -> load -> model('User_model');
			$uresult = $this -> User_model -> verifyUser($emailId, $password);
			if (count($uresult)>0)
			{
				// $userDtls = $this->user_model->get_user_by_id($uresult[0]->USER_ID);
				$uimage = $uresult[0]->PROFILE_PIC_PATH;
				if(!isset($uresult[0]->PROFILE_PIC_PATH))
				{
					$uimage = 'resources/img/blank_user.png';
				} 
				
				$userType = $this-> User_model -> getUserTypeByEmailId($emailId);
				// set session
				$sess_data = array('login' => TRUE, 
									'uid' => $uresult[0]->USER_ID,
									'uname' => $uresult[0]->PROFILE_NAME,
									'nickname' => $uresult[0]->NICK_NAME,
									'usertype'=>$userType[0]->USER_TYPE_NAME,
									'uimage'=>$uimage
								);
				$this->session->set_userdata($sess_data);
									
				if($sess_data['usertype'] !="Admin" && $sess_data['usertype'] != "Trainer")
				{
					$this->session->set_flashdata('msg_login', '<div class="alert alert-danger text-center">Sorry, you don have access to login.</div>');
					//redirect('login');
					redirect(BizgamesBaseURL);
				}
				else
				{
					$data['success'] = true;
					// echo json_encode($data);
					redirect("Main/workspaceListView");
				}
			} 
			else
			{
				$this->session->set_flashdata('msg_login', '<div class="alert alert-danger text-center">'.$uresult->ErrorMsg.'</div>');
				//redirect('login');
				redirect(BizgamesBaseURL);
			}
		}
	}

	function checkforUser($emailId,$password)
	{
		$this -> load -> library('rest', array('server' => APIBaseURL . 'api/TriviaService/', 
												'http_user' => 'admin', 
												'http_pass' => '1234', 
												'http_auth' => 'digest' // or 'digest'
												)
								);
		$uresult = $this -> rest -> get('verifyUser?loginId='.$emailId.'&password='.$password.'&workspace='.$workspace);
		//  $uresult = $this->Safetygame_model->getCheckforUser($username, $password);
		return $uresult;
	}
		
		// function myaccount()
		// {
				 // $this -> load -> model('Gamemasters_model');
					 // $emailId = $this->session->userdata('emailid');
//        
				// $params['limit'] = RECORDS_PER_PAGE;
				// $params['offset'] = ($this -> input -> get('per_page')) ? $this -> input -> get('per_page') : 0;
// 
				// $config = $this -> config -> item('pagination');
				// $config['base_url'] = site_url('login/myaccount?');
				// $count= $this->Gamemasters_model->listPlayedGamesByUserCount($emailId);
					// $config['total_rows'] = $count[0]['Count'] ;
				// $this->pagination->initialize($config);
//       
				// $data['data']=$this->Gamemasters_model -> listPlayedGamesByUser($params,$emailId);
				// $data['_view'] = 'my_account_view';
				// $this->load->view('layouts/main_view', $data);
		// }
		// function myaccountDtls($gameToken)
		// {
				// $data['TeamA'] = array('team_id' => '',
											 // 'game_id'=>'',
											 // 'TEAM_NAME'=>'',
											 // 'EMAIL_ID'=>'',
											 // 'DEPARTMENT_NAME'=>'',
											 // 'UNIVERSE_TOKEN'=>'');
//                        
				 // $data['TeamB'] = array('team_id' => '',
											 // 'game_id'=>'',
											 // 'TEAM_NAME'=>'',
											 // 'EMAIL_ID'=>'',
											 // 'DEPARTMENT_NAME'=>'',
											 // 'UNIVERSE_TOKEN'=>'');
//                        
				// $emailId = $this->session->userdata('emailid');
				// $this -> load -> model('Gamemasters_model');
//         
				// $gameIdDtls = $this->Gamemasters_model ->getGameIdForEmailId($gameToken,$emailId);
				// if(!empty($gameIdDtls))
				// {
						// $data['gameInfo']=$this->Gamemasters_model -> getGameStartInfo($gameToken);
						// $data['TeamA']=$this->Gamemasters_model -> listRolesTakenForStratupGame($gameToken,$gameIdDtls[0]['game_id'],'A');
						// $data['TeamB']=$this->Gamemasters_model -> listRolesTakenForStratupGame($gameToken,$gameIdDtls[0]['game_id'],'B');
				// }
//         
				 // echo json_encode($data);
				 // //var_dump($gameIdDtls);
		// }
		// function enquiry()
		// {
				// // set form validation rules
				// $this -> form_validation -> set_rules('name_enq', 'Full Name', 'trim|required|alpha|min_length[3]|max_length[30]');
				// $this -> form_validation -> set_rules('email_enq', 'EMAIL', 'trim|required|valid_email');
				// if($this -> input -> post('enquirytype')!= 'ReachOut'){
						 // $this -> form_validation -> set_rules('phoneno_enq', 'Phone No', 'regex_match[/^[0-9]{10}$/]');
					 // $this -> form_validation -> set_rules('orgname_enq', 'Organisation Name', 'required');
				// }
				// if($this -> input -> post('enquirytype')== 'Contact'){
						// $this -> form_validation -> set_rules('noofpar_enq','No of Participants',  'required');
						// if(isset($_REQUEST['facilit_enq']) && $_REQUEST['facilit_enq'] == '') { 
									// echo '<p>Please select an option.</p>';
								// } 
				// }
				 // if($this -> input -> post('enquirytype')== 'Order'){
						 // if(isset($_REQUEST['gamename_enq']) && $_REQUEST['gamename_enq'] == '') { 
									// echo '<p>Please select an option.</p>';
								// } 
				// }
//         
					// $this -> form_validation -> set_rules('textmsg_enq', 'Tell us your requirements', 'required');
				// $this->form_validation->set_error_delimiters('<p class="text-danger">', '</p>');
				// // submit
				// if ($this -> form_validation -> run() == FALSE)
				// {
						// // fails
						// foreach ($_POST as $key => $value) 
								// {
										// $data['messages'][$key] = form_error($key);
								// }               
								// echo json_encode($data);
				// }
				// else
				// {
//             
						// $params = array(
												// 'ENQUIRY_FOR' => $this -> input -> post('enquirytype'), 
												// 'NAME' => $this -> input -> post('name_enq'), 
												// 'EMAIL' => $this -> input -> post('email_enq'),
												// 'PHONENO' => $this->input -> post('phoneno_enq'),
												// 'ORGANISATION' => $this-> input -> post('orgname_enq'),
												// 'DESIGNATION' => $this->input -> post ('design_enq'),
												// 'NO_OF_PARTICIPANT' => $this -> input -> post ('noofpar_enq'),
												// 'TRAINING_DATE' => $this -> input -> post ('tradate_enq'),
												// 'FACILITATION' => $_REQUEST['facilit_enq'],
												// 'GAME_NAME' => $_REQUEST['gamename_enq'],
												// 'NO_OF_PIECES' => $this -> input -> post ('noofpiece_enq'),
												// 'MESSAGE' => $this->input -> post('textmsg_enq'),
												// );
//                       
						 // $this -> load -> model('User_model');            
						// $this -> User_model -> insertEnquiry($params);
//            
//            
						// if ($this->db->trans_status() === FALSE)
						// {
										// $this->db->trans_rollback();
										// $data['messages']['msg_enq'] = '<div class="alert alert-danger text-center">Oops! Something went wrong. Please try again</div>';
										// echo json_encode($data);
//                     
						// }
						// else
						// {
										// $this->db->trans_commit();
										 // if($this -> input -> post('enquirytype')== 'Contact'){
										// $data['messages']['msg_enq'] = '<div class="alert alert-success text-center">Our learning team will get in touch with you to understand your speciﬁc requirements before we send you a proposal.</div>';
										// }
										// else if($this -> input -> post('enquirytype')== 'Order'){
												 // $data['messages']['msg_enq'] = '<div class="alert alert-success text-center">Our learning team will reach out to you to understand your requirements in detail</div>';
										// }
										 // else{
												 // $data['messages']['msg_enq'] = '<div class="alert alert-success text-center">Thanks for providing your info</div>';
										// }
										// $data['success'] = true;
										// echo json_encode($data);
						// }
				// }
		// }
		
}