<?php
include (APPPATH . 'controllers/api/Gamemasters.php');

class Main extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->helper(array('form','url','html'));
		$this->load->library(array('session', 'form_validation'));
		$this->load->database();
		$this->load->model('TriviaPortal_model');
        $this->load->model('User_model');
        if(!$this->session->userdata('login'))
        {
           // redirect('login');
           redirect(BizgamesBaseURL);
        }
	}

    function departmentListView()
    {
        $params['limit'] = RECORDS_PER_PAGE;
        $params['offset'] = ($this -> input -> get('per_page')) ? $this -> input -> get('per_page') : 0;

        $config = $this -> config -> item('pagination');
        $config['base_url'] = site_url('Main/departmentListView?');
        $deptDtls = $this -> TriviaPortal_model -> getAllDepartments();
        $config['total_rows'] = count($deptDtls) ;
        $this->pagination->initialize($config);
        
        $data['deptDtls'] = $deptDtls;
        $data['_view'] = 'trivia/department_list_view';
        $data['_navview'] = 'trivia/nav_bar_view';
        $this -> load -> view('trivia/main_view',$data);
    }

    function addDepartmentMstr()
    {
        $departmentName = $_POST['departmentName'];
        $status = $_POST['status']; 
        $required = array('departmentName', 'status');
        // Loop over field names, make sure each one exists and is not empty
        $error = false;
        foreach($required as $field) {
          if (empty($_POST[$field])) {
            $error = true;
          }
        }

        if($error == false)
        {
            $this->db-> trans_begin(); 
            $params=array('DEPARTMENT_NAME'=> $departmentName,
                           'STATUS'=> $status);
                           
            $this -> TriviaPortal_model -> insertdepartment($params);
            if ( $this->db-> trans_status() === FALSE)
            {
                $this->db-> trans_rollback();
                $data['success'] = false;
                $data['messages']['msg-dept'] = '<div class="alert alert-danger text-center">Oops Something went wrong.</div>';      
            }
            else
            {
                $this->db-> trans_commit();
                $data['success'] = true;
                $data['messages']['msg-dept'] = '<div class="alert alert-success text-center">Successfully Inserted.</div>';
            }
         }
        else
        {
            $data['success'] = false;
            $data['messages']['msg-dept'] = '<div class="alert alert-danger text-center">All Fields are mandatory</div>';
        }    
        echo json_encode($data);
    }

    function updateDepartmentMstr()
    {
        $deptId = $_POST['deptId'];
        $departmentName = $_POST['departmentName'];
        $status = $_POST['status']; 
        $required = array('departmentName', 'status');
        // Loop over field names, make sure each one exists and is not empty
        $error = false;
        foreach($required as $field) {
          if (empty($_POST[$field])) {
            $error = true;
          }
        }

        if($error == false)
        {
            $this->db-> trans_begin(); 
            $params=array('DEPARTMENT_NAME'=> $departmentName,
                           'STATUS'=> $status);
                           
            $this -> TriviaPortal_model -> updatedepartment($params, $deptId) ;
            if ( $this->db-> trans_status() === FALSE)
            {
                $this->db-> trans_rollback();
                $data['success'] = false;
                $data['messages']['msg-dept'] = '<div class="alert alert-danger text-center">Oops Something went wrong.</div>';      
            }
            else
            {
                $this->db-> trans_commit();
                $data['success'] = true;
                $data['messages']['msg-dept'] = '<div class="alert alert-success text-center">Successfully Updated.</div>';
            }
         }
        else
        {
            $data['success'] = false;
            $data['messages']['msg-dept'] = '<div class="alert alert-danger text-center">All Fields are mandatory</div>';
        }    
        echo json_encode($data);
    }

    function teamListView()
    {
        $teamDtls = $this -> TriviaPortal_model -> getAllTeams();
        $data['teamDtls'] = $teamDtls;
        $data['_view'] = 'trivia/team_list_view';
        $data['_navview'] = 'trivia/nav_bar_view';
        $this -> load -> view('trivia/main_view',$data);
    }

    function addTeamMstr()
    {
        $teamName = $_POST['teamName'];
        $departmentId = $_POST['departmentId'];
        $status = $_POST['status']; 
        $required = array('teamName', 'departmentId', 'status');
        // Loop over field names, make sure each one exists and is not empty
        $error = false;
        foreach($required as $field) {
          if (empty($_POST[$field])) {
            $error = true;
          }
        }

        if($error == false)
        {
            $this->db-> trans_begin(); 
            $params=array('TEAM_NAME'=> $teamName,
                           'DEPARTMENT_ID'=> $departmentId,
                           'STATUS'=> $status);
                           
            $this -> TriviaPortal_model -> insertTeamMstr($params);
            if ( $this->db-> trans_status() === FALSE)
            {
                $this->db-> trans_rollback();
                $data['success'] = false;
                $data['messages']['msg-team'] = '<div class="alert alert-danger text-center">Oops Something went wrong.</div>';      
            }
            else
            {
                $this->db-> trans_commit();
                $data['success'] = true;
                $data['messages']['msg-team'] = '<div class="alert alert-success text-center">Successfully Inserted.</div>';
            }
         }
        else
        {
            $data['success'] = false;
            $data['messages']['msg-team'] = '<div class="alert alert-danger text-center">All Fields are mandatory</div>';
        }    
        echo json_encode($data);
    }

    function updateTeamMstr()
    {
        $teamId = $_POST['teamId'];
        $teamName = $_POST['teamName'];
        $deptId = $_POST['deptId'];
        $status = $_POST['status']; 
        $required = array('teamName', 'deptId', 'status');
        // Loop over field names, make sure each one exists and is not empty
        $error = false;
        foreach($required as $field) {
          if (empty($_POST[$field])) {
            $error = true;
          }
        }

        if($error == false)
        {
            $this->db-> trans_begin(); 
            $params=array('TEAM_NAME'=> $teamName,
                           'DEPARTMENT_ID'=> $deptId,
                           'STATUS'=> $status);
                           
            $this -> TriviaPortal_model -> updateTeamMstr($params, $teamId) ;
            if ( $this->db-> trans_status() === FALSE)
            {
                $this->db-> trans_rollback();
                $data['success'] = false;
                $data['messages']['msg-team'] = '<div class="alert alert-danger text-center">Oops Something went wrong.</div>';      
            }
            else
            {
                $this->db-> trans_commit();
                $data['success'] = true;
                $data['messages']['msg-team'] = '<div class="alert alert-success text-center">Successfully Updated.</div>';
            }
         }
        else
        {
            $data['success'] = false;
            $data['messages']['msg-team'] = '<div class="alert alert-danger text-center">All Fields are mandatory</div>';
        }    
        echo json_encode($data);
    }

    function pointListview()
    {
        // $params['limit'] = RECORDS_PER_PAGE;
        // $params['offset'] = ($this -> input -> get('per_page')) ? $this -> input -> get('per_page') : 0;

        // $config = $this -> config -> item('pagination');
        // $config['base_url'] = site_url('Main/pointListview?');
        // $pointslist = $this -> Triviaservice_model -> getAllPointsDetails();
        // $config['total_rows'] = count($pointslist) ;
        // $this->pagination->initialize($config);

        $userId = $this->session->userdata('uid');
        $data['workspaceList'] = $this -> User_model -> getWorkspaceForUserByUserId($userId);
        $workspaceId = $this->input->post('WORKSPACE_SCHEMA');
        $pointsDtls = array();
        if($workspaceId != '')
        {

            $workspaceDtls = $this -> TriviaPortal_model ->getWorkspaceDetailsById($workspaceId);
            $workspaceSchema = $workspaceDtls[0]->WS_SCHEMA;
            $data['workspaceSchema']=$workspaceSchema;
            $data['workspaceName']=$workspaceDtls[0]->WS_NAME;
            $data['categoryList'] = $this -> TriviaPortal_model -> getAllQuestionCategoryForSchema($workspaceSchema);
            $pointsDtls = $this -> TriviaPortal_model -> getAllPointsDetailsfromWorkspace($workspaceSchema);
        }
        else
        {
            $data['workspaceSchema']='';
            $data['workspaceName']='';
            $data['categoryList'] = array();
        }
        $data['pointsDtls'] = $pointsDtls;
        
        $data['_view'] = 'trivia/points_list_view';
        $data['_navview'] = 'trivia/nav_bar_view';
        $this -> load -> view('trivia/main_view',$data);
    }

    function addPointsMstr($workspaceSchema)
    {
        $gameMode = $this->input->post('gameMode');
        $questionCategoryId = $this->input->post('quesCate');
        $points = $this->input->post('points'); 

        if($gameMode != "")
        {
            if($questionCategoryId != "")
            {
                $this->db-> trans_begin(); 
                $params=array('GAME_MODE'=> $gameMode,
                            'QN_CATEGORY_ID'=> $questionCategoryId,
                            'QN_DIFFICULTY'=> '1',
                            'COINS' => $points,
                            'GEMS' => '0');
                            
                $this -> TriviaPortal_model -> insertPointsMstr($params,$workspaceSchema);
                if ( $this->db-> trans_status() === FALSE)
                {
                    $this->db-> trans_rollback();
                    $data['success'] = false;
                    $data['messages']['msg-addpoint'] = '<div class="alert alert-danger text-center">Oops Something went wrong.</div>';      
                }
                else
                {
                    $this->db-> trans_commit();
                    $data['success'] = true;
                    $data['messages']['msg-addpoint'] = '<div class="alert alert-success text-center">Successfully Inserted.</div>';       
                }
            }
            else
            {
                $data['success'] = false;
                $data['messages']['msg-addpoint'] = '<div class="alert alert-danger text-center">Select Question Category</div>';
            } 
         }
        else
        {
            $data['success'] = false;
            $data['messages']['msg-addpoint'] = '<div class="alert alert-danger text-center">Select Gamemode</div>';
        }    
        echo json_encode($data);
    }

    function updatePointsMstr($workspaceSchema)
    {
        $pointsId = $this->input->post('pointsId');
        $gameMode = $this->input->post('edit_gameMode');
        $questionCategoryId = $this->input->post('edit_quesCate');
        $points = $this->input->post('edit_points'); 
        
        if($gameMode != "")
        {
            if($questionCategoryId != "")
            {
                $this->db-> trans_begin(); 
                $params=array('GAME_MODE'=> $gameMode,
                            'QN_CATEGORY_ID'=> $questionCategoryId,
                            'QN_DIFFICULTY'=> "1",
                            'COINS' => $points);
                            
                $this -> TriviaPortal_model -> updatePointsMstr($params, $pointsId,$workspaceSchema) ;
                if ( $this->db-> trans_status() === FALSE)
                {
                    $this->db-> trans_rollback();
                    $data['success'] = false;
                    $data['messages']['msg-points'] = '<div class="alert alert-danger text-center">Oops Something went wrong.</div>';      
                }
                else
                {
                    $this->db-> trans_commit();
                    $data['success'] = true;
                    $data['messages']['msg-points'] = '<div class="alert alert-success text-center">Successfully Updated.</div>';       
                }
            }
            else
            {
                $data['success'] = false;
                $data['messages']['msg-points'] = '<div class="alert alert-danger text-center">Select Question Category</div>';
            }
        }
        else
        {
            $data['success'] = false;
            $data['messages']['msg-points'] = '<div class="alert alert-danger text-center">Select Gamemode</div>';
        }    
        echo json_encode($data);
    }

    function addQuestionCategoryMstr($workspaceSchema)
    {
        $categoryName = $this->input->post('categoryName');
        $categoryMascot = $this->input->post('categoryMascot');
        $status = $this->input->post('status'); 
      //  $workspaceSchema = $this->input->post('workspaceSchema'); 
        $error = false;
        if($status !="")
        {
            $this->db-> trans_begin(); 
            $params=array('QN_CATEGORY'=> $categoryName,
                           'QN_CATEGORY_MASCOT'=> $categoryMascot,
                           'STATUS'=> $status);
                           
            $this -> TriviaPortal_model -> insertQuestionCategoryMstr($params,$workspaceSchema);
            if ( $this->db-> trans_status() === FALSE)
            {
                $this->db-> trans_rollback();
                $data['success'] = false;
                $data['messages']['msg-quesCate'] = '<div class="alert alert-danger text-center">Oops Something went wrong.</div>';      
            }
            else
            {
                $this->db-> trans_commit();
                $data['success'] = true;
                $data['messages']['msg-quesCate'] = '<div class="alert alert-success text-center">Successfully Inserted.</div>';       
            }
         }
        else
        {
            $data['success'] = false;
            $data['messages']['msg-quesCate'] = '<div class="alert alert-danger text-center">Please select Status</div>';
        }    
        echo json_encode($data);
    }

    function updateQuestionCategoryMstr($workspaceSchema)
    {
        $categoryId = $this->input->post('categoryId');
        $categoryName = $this->input->post('edit_categoryName');
        $categoryMascot = $this->input->post('edit_categoryMascot');
        $status = $this->input->post('edit_status'); 
       // $workspaceSchema = $this->input->post('edit_workspaceSchema'); 
//$required = array('categoryName', 'status');
        // Loop over field names, make sure each one exists and is not empty
        // $error = false;
        // foreach($required as $field) {
        //   if (empty($_POST[$field])) {
        //     $error = true;
        //   }
        // }

        if($status != "")
        {
            $this->db-> trans_begin(); 
            $params=array('QN_CATEGORY'=> $categoryName,
                           'QN_CATEGORY_MASCOT'=> $categoryMascot,
                           'STATUS'=> $status);
                           
            $this -> TriviaPortal_model -> updateQuestionCategoryMstr($params, $categoryId, $workspaceSchema) ;
            if ( $this->db-> trans_status() === FALSE)
            {
                $this->db-> trans_rollback();
                $data['success'] = false;
                $data['messages']['msg-editquesCate'] = '<div class="alert alert-danger text-center">Oops Something went wrong.</div>';      
            }
            else
            {
                $this->db-> trans_commit();
                $data['success'] = true;
                $data['messages']['msg-editquesCate'] = '<div class="alert alert-success text-center">Successfully Updated.</div>'; 
            }
         }
        else
        {
            $data['success'] = false;
            $data['messages']['msg-editquesCate'] = '<div class="alert alert-danger text-center">Please Select Status</div>';
        }    
        echo json_encode($data);
    }

    function addQuestionMstr($workspaceSchema)
    {
        $questionCategoryId = $this->input->post('questionCate');
        if($questionCategoryId != '')
        {
            $gameMechanic = $this->input->post('gameMechanic');
            if($gameMechanic != '')
            {
                $questionDesc = $this->input->post('questionDesc');
                $mediaPath = $this->input->post('mediaPath');
                $mediaType = $this->input->post('mediaType'); 

                $this->db-> trans_begin(); 
                $params=array('GAME_MECHANIC'=> $gameMechanic,
                            'QN_CATEGORY_ID'=> $questionCategoryId,
                            'QN_DIFFICULTY_ID'=> '1',
                            'QN_DESCRIPTION'=> $questionDesc,
                            'QN_MEDIA_PATH'=> $mediaPath,
                            'QN_MEDIA_TYPE'=> $mediaType,
                            'STATUS'=> "A");
                            
                $this -> TriviaPortal_model -> insertQuestionMstr($params,$workspaceSchema);
                if ( $this->db-> trans_status() === FALSE)
                {
                    $this->db-> trans_rollback();
                    $data['success'] = false;
                    $data['messages']['msg-ques'] = '<div class="alert alert-danger text-center">Oops Something went wrong.</div>';      
                }
                else
                {
                    $this->db-> trans_commit();
                    $data['success'] = true;
                    $data['messages']['msg-ques'] = '<div class="alert alert-success text-center">Successfully Inserted.</div>';
                }
            }
            else
            {
                $data['success'] = false;
                $data['messages']['msg-ques'] = '<div class="alert alert-danger text-center">Select Game Mechanic</div>';
            }  
        }
        else
        {
            $data['success'] = false;
            $data['messages']['msg-ques'] = '<div class="alert alert-danger text-center">Select Question Category</div>';
        } 
        echo json_encode($data);
    }

    function updateQuestionMstr($workspaceSchema)
    {
        $questionId = $this->input->post('questionId');
        $questionCategoryId = $this->input->post('edit_questionCate');
        if($questionCategoryId != '')
        {
            $gameMechanic = $this->input->post('edit_gameMechanic');
            if($gameMechanic != '')
            {
                $questionDesc = $this->input->post('edit_questionDesc');
                $mediaPath = $this->input->post('edit_mediaPath');
                $mediaType = $this->input->post('edit_mediaType');
                $status = $this->input->post('edit_status'); 

                if($status != '')
                {
                    $this->db-> trans_begin(); 
                    $params=array('GAME_MECHANIC'=> $gameMechanic,
                                'QN_CATEGORY_ID'=> $questionCategoryId,
                                'QN_DIFFICULTY_ID'=> '1',
                                'QN_DESCRIPTION'=> $questionDesc,
                                'QN_MEDIA_PATH'=> $mediaPath,
                                'QN_MEDIA_TYPE'=> $mediaType,
                                'STATUS'=> $status);
                                
                    $this -> TriviaPortal_model -> updateQuestionMstr($params, $questionId,$workspaceSchema) ;
                    if ( $this->db-> trans_status() === FALSE)
                    {
                        $this->db-> trans_rollback();
                        $data['success'] = false;
                        $data['messages']['msg-quesedit'] = '<div class="alert alert-danger text-center">Oops Something went wrong.</div>';      
                    }
                    else
                    {
                        $this->db-> trans_commit();
                        $data['success'] = true;
                        $data['messages']['msg-quesedit'] = '<div class="alert alert-success text-center">Successfully Updated.</div>';       
                    }
                }
                else
                {
                    $data['success'] = false;
                    $data['messages']['msg-quesedit'] = '<div class="alert alert-danger text-center">Select Status</div>';
                }  
            }
            else
            {
                $data['success'] = false;
                $data['messages']['msg-quesedit'] = '<div class="alert alert-danger text-center">Select Game Mechanic</div>';
            } 
        }
        else
        {
            $data['success'] = false;
            $data['messages']['msg-quesedit'] = '<div class="alert alert-danger text-center">Select Question Category</div>';
        }  
        echo json_encode($data);
    }

    function questionListView()
    {
        $userId = $this->session->userdata('uid');
        $data['workspaceList'] = $this -> User_model -> getWorkspaceForUserByUserId($userId);
        $workspaceId = $this->input->post('WORKSPACE_SCHEMA');
        $gameMechanic = $this->input->post('GAME_MECHANIC');
        $questionCategoryId = $this->input->post('QUESTION_CATEGORY');

        if($workspaceId !='')
        {
            $workspaceDtls = $this -> TriviaPortal_model ->getWorkspaceDetailsById($workspaceId);
            $workspaceSchema = $workspaceDtls[0]->WS_SCHEMA;
            $data['workspaceSchema']=$workspaceSchema;
            $data['workspaceName']=$workspaceDtls[0]->WS_NAME;

            $data['gameMechanicList'] = $this -> TriviaPortal_model -> getGameMechanicsFromWorkSpace($workspaceSchema);
            $data['categoryList'] = $this -> TriviaPortal_model -> getAllQuestionCategoryForSchema($workspaceSchema);
            if($questionCategoryId !='')
            {
                $categorydetails = $this -> TriviaPortal_model ->getQuestionCategoryByIdForSchema($workspaceSchema,$questionCategoryId);
               
                $questions = $this -> TriviaPortal_model -> getQuestionsByGameMechanicFromWorkSpace($workspaceSchema,$gameMechanic, $questionCategoryId) ;
                $data['questionCategory'] = $categorydetails[0]->QN_CATEGORY;
                $data['questionCategoryId'] = $questionCategoryId;
            }
            else
            {
                $questions = array();
                $data['questionCategory'] = '';
                $data['questionCategoryId'] = '';
            }
        }
        else
        {
            $data['workspaceSchema']='';
            $data['workspaceName']='';
            $data['questionCategory'] = '';
            $data['questionCategoryId'] = '';
            $data['gameMechanicList'] = array();
            $data['categoryList'] = array();
            $questions = array();
        }

        $data['gameMechanic']=$gameMechanic;
        $data['questionCategoryId']=$questionCategoryId;
        
        $data['questions']= $questions;   
        $data['_view'] = 'trivia/question_view';
        $data['_navview'] = 'trivia/nav_bar_view';
        $this -> load -> view('trivia/main_view',$data);
    }

    function getquestionbyid($workspaceSchema,$questionId)
    {
        $datapassed['question'] = $this -> TriviaPortal_model -> getQuestionByIdFromWorkspace($workspaceSchema,$questionId);
        $datapassed['questionCategory'] = $this -> TriviaPortal_model -> getAllQuestionCategoryForSchema($workspaceSchema);
        $datapassed['gameMechanicList'] = $this -> TriviaPortal_model -> getGameMechanicsFromWorkSpace($workspaceSchema);
        $datapassed['edit_workspaceSchema'] = $workspaceSchema;
        $data=$this->load->view('trivia/question_edit_view',$datapassed,TRUE);
     
         echo json_encode($data);
    }
    function getDepartment()
    {
        $data['department'] = $this -> TriviaPortal_model -> getAllDepartments();
        echo json_encode($data);
    }
    function getQuestionCategoryList()
    {
        $data['questionCategory'] = $this -> TriviaPortal_model -> getAllQuestionCategory();
        echo json_encode($data);
    }
    function optionsListView($workspaceSchema, $questionId)
    {
        $datapassed['question'] = $this -> TriviaPortal_model -> getQuestionByIdFromWorkspace($workspaceSchema,$questionId);
        $datapassed['options']= $this -> TriviaPortal_model -> getOptionsForQuestionIdFromWorkspace($workspaceSchema,$questionId);
        $datapassed['workspaceSchema'] = $workspaceSchema;
        $data= $this -> load -> view('trivia/options_list_view',$datapassed,TRUE);
        echo json_encode($data);
    }
    function quizListViewForQuestionId($workspaceSchema, $questionId)
    {
        $datapassed['question'] = $this -> TriviaPortal_model -> getQuestionByIdFromWorkspace($workspaceSchema,$questionId);
        $currdate = $this -> User_model -> getCurrentTimeFromDatabase();
        $datapassed['quizDtls'] = $this -> TriviaPortal_model -> getQuizmappedtoQuestion($workspaceSchema, $questionId);
        $datapassed['workspaceSchema'] = $workspaceSchema;
        $data= $this -> load -> view('trivia/quiz_for_question_view',$datapassed,TRUE);
        echo json_encode($data);
    }
    function flashCardListViewForQuestionId($workspaceSchema, $questionId)
    {
        $datapassed['question'] = $this -> TriviaPortal_model -> getQuestionByIdFromWorkspace($workspaceSchema,$questionId);
        $flashCards = $this -> TriviaPortal_model -> getFlashCardmappedtoQuestion($workspaceSchema, $questionId);
        $i = 0;
        $tempCardId = "";
        $flashCardList = array();
        if(count($flashCards) > 0)
        {
            foreach ($flashCards as $card) 
            {
                if($tempCardId!=$card->CARD_ID && $tempCardId !="")
                {
                    if(!array_key_exists("TITLE", $flashCardList[$i]))
                    {
                        $flashCardList[$i]['TITLE'] = "";
                    }
                    if(!array_key_exists("DESCRIPTION", $flashCardList[$i]))
                    {
                        $flashCardList[$i]['DESCRIPTION'] = "";
                    }
                    if(!array_key_exists("MEDIA_URL", $flashCardList[$i]))
                    {
                        $flashCardList[$i]['MEDIA_URL'] = "";
                    }
                    $i++;
                }
                $flashCardList[$i]['CARD_ID'] = $card->CARD_ID;
                if($card->CARD_DETAIL_CODE == "TITLE")
                {
                    $flashCardList[$i]['TITLE'] = $card->CARD_DETAIL_DESC;
                }
                if($card->CARD_DETAIL_CODE == "DESCRIPTION")
                {
                    $flashCardList[$i]['DESCRIPTION'] = $card->CARD_DETAIL_DESC;
                }
                if($card->CARD_DETAIL_CODE == "IMAGE")
                {
                    $flashCardList[$i]['MEDIA_URL'] = $card->MEDIA_URL;
                }
                $tempCardId = $card->CARD_ID;
            }            
        }   
        if(count($flashCardList) > 0)
        {
            if(!array_key_exists("TITLE", $flashCardList[0]))
            {
                $flashCardList[0]['TITLE'] = "";
            }
            if(!array_key_exists("DESCRIPTION", $flashCardList[$i]))
            {
                $flashCardList[0]['DESCRIPTION'] = "";
            }
            if(!array_key_exists("MEDIA_URL", $flashCardList[$i]))
            {
                $flashCardList[0]['MEDIA_URL'] = "";
            } 
        }
        else
        {
            $flashCardList[0]['TITLE'] = "";
            $flashCardList[0]['DESCRIPTION'] = "";
            $flashCardList[0]['MEDIA_URL'] = "";
        }
        $datapassed['flashCard'] = $flashCardList;
        $datapassed['workspaceSchema'] = $workspaceSchema;
        $data= $this -> load -> view('trivia/flashcard_for_question_view',$datapassed,TRUE);
        echo json_encode($data);
    }
    function getOptionsAddView($workspaceSchema, $questionId)
    {
        $datapassed['question'] = $this -> TriviaPortal_model -> getQuestionByIdFromWorkspace($workspaceSchema,$questionId);
        $datapassed['options']= $this -> TriviaPortal_model -> getOptionsForQuestionIdFromWorkspace($workspaceSchema,$questionId);
        $datapassed['workspaceSchema'] = $workspaceSchema;
        $data=$this->load->view('trivia/options_add_view',$datapassed,TRUE);
        echo json_encode($data);
    }
    function getOptionsEditView($workspaceSchema, $optionId, $questionId)
    {
        $datapassed['workspaceSchema'] = $workspaceSchema;
        $datapassed['questionDetails'] = $this -> TriviaPortal_model -> getQuestionByIdFromWorkspace($workspaceSchema,$questionId);
        $datapassed['optionsDetails']= $this -> TriviaPortal_model -> getOptionsForOptionIdFromWorkspace($workspaceSchema,$optionId);
        $data=$this->load->view('trivia/options_edit_view',$datapassed,TRUE);
        echo json_encode($data);
    }

    function addOptionMstr($workspaceSchema)
    {
        $correctans[] = array();
        $otherchoice[] = array();
        $correctoptmedia = "";
        $otheroptmedia = "";
        $topCardDesc = "";
        $topCardMedia = "";
        $matchingCardDesc = "";
        $matchingCardMedia = "";
        $Drag2Cate1 = "";
        $Drag2Cate1Text = "";
        $Drag2Cate1Media = "";
        $Drag2Cate2 = "";
        $Drag2Cate2Text = "";
        $Drag2Cate2Media = "";
        $Drag3CardDesc = "";
        $Drag3SeqNo = "";
        $questionId = $this->input->post('addquestionId');
        $gameMechanic = $this->input->post('addgameMechanic');
        
        $options = $this -> TriviaPortal_model -> getOptionsForQuestionIdFromWorkspace($workspaceSchema,$questionId);
        
        $this->db-> trans_begin(); 
        if($gameMechanic == "MCQ" || $gameMechanic == "MCQ-TF")
        {
            if(count($_POST['correctans']) > 0)
            {
                for($i = 0; $i < count($_POST['correctans']); $i++)
                {
                    if($_POST['correctans'][$i] != "")
                    {
                        $params = array('OPT_DESC' => $_POST['correctans'][$i],
                                  'OPT_ANSWER' => "Y",
                                  'QN_ID' => $questionId);
                        $optionId=  $this -> TriviaPortal_model -> insertOptionsMstr($params,$workspaceSchema);
                    }
                }
            }
            if(count($_POST['otherchoice']) > 0)
            {
                for($i = 0; $i < count($_POST['otherchoice']); $i++)
                {
                    if($_POST['otherchoice'][$i] != "")
                    {
                        $params = array('OPT_DESC' => $_POST['otherchoice'][$i],
                                  'QN_ID' => $questionId);
                        $optionId=  $this -> TriviaPortal_model -> insertOptionsMstr($params,$workspaceSchema);
                    }
                }
            }
        }
        else if($gameMechanic == "Bubble_Burster")
        {
            if(count($_POST['correctans']) > 0)
            {
                for($i = 0; $i < count($_POST['correctans']); $i++)
                {
                    if($_POST['correctans'][$i] != "")
                    {
                        $params = array('OPT_DESC' => $_POST['correctans'][$i],
                                  'OPT_MEDIA_PATH' => $_POST['correctoptmedia'][$i],
                                  'OPT_ANSWER' => "Y",
                                  'QN_ID' => $questionId);
                        $optionId=  $this -> TriviaPortal_model -> insertOptionsMstr($params,$workspaceSchema);
                    }
                }
            }
            if(count($_POST['otherchoice']) > 0)
            {
                for($i = 0; $i < count($_POST['otherchoice']); $i++)
                {
                    if($_POST['otherchoice'][$i] != "")
                    {
                        $params = array('OPT_DESC' => $_POST['otherchoice'][$i],
                                  'OPT_MEDIA_PATH' => $_POST['otheroptmedia'][$i],
                                  'QN_ID' => $questionId);
                        $optionId=  $this -> TriviaPortal_model -> insertOptionsMstr($params,$workspaceSchema);
                    }
                }
            }
        }
        else if($gameMechanic == "Scrambled_Words")
        {
            if($_POST['correctans'][0] != "")
            {
                $params=array('OPT_ANSWER'=> $_POST['correctans'][0],
                              'QN_ID'=> $questionId);
                $this -> TriviaPortal_model -> insertOptionsMstr($params,$workspaceSchema);
            }
        }
        else if($gameMechanic == "Drag_Answer_1")
        {
            if(count($_POST['topCardDesc']) > 0)
            {
                for($i = 0; $i < count($_POST['topCardDesc']); $i++)
                {
                    if($_POST['topCardDesc'][$i] != "" && $_POST['matchingCardDesc'][$i] != "")
                    {
                        $params=array('OPT_DESC'=> $_POST['topCardDesc'][$i],
                              'OPT_MEDIA_PATH'=> $_POST['topCardMedia'][$i],
                              'OPT_ANSWER' => $_POST['matchingCardDesc'][$i],
                              'OPT_ANS_MEDIA_PATH' => $_POST['matchingCardMedia'][$i],
                              'QN_ID'=> $questionId);
                        $this -> TriviaPortal_model -> insertOptionsMstr($params,$workspaceSchema);
                    }
                }
            }
        }
        else if($gameMechanic == "Drag_Answer_2")
        {
            $error = false;
            if(count($_POST['Drag2Cate1']) > 0)
            {
                for($i = 0; $i < count($_POST['Drag2Cate1']); $i++)
                {
                    if($i != 0)
                    {
                        if(($_POST['Drag2Cate1'][$i]) != ($_POST['Drag2Cate1'][$i-1]))
                        {
                            $error = true;
                            break;
                        }
                        else if(count($options) > 0)
                        {
                            if(!in_array($_POST['Drag2Cate1'][$i],array_column($options,'OPT_DESC')))
                            {
                                $error = true;
                                break;
                            }                            
                        }
                    }
                    //$i++;
                }
                if($error == false)
                {
                    for($i = 0; $i < count($_POST['Drag2Cate1']); $i++)
                    {
                        if($_POST['Drag2Cate1'][$i] != "" && $_POST['Drag2Cate1Text'][$i] != "")
                        {
                            $params=array('OPT_DESC'=> $_POST['Drag2Cate1'][$i],
                                'OPT_ANSWER'=> $_POST['Drag2Cate1Text'][$i],
                                'OPT_ANS_MEDIA_PATH' => $_POST['Drag2Cate1Media'][$i],
                                'QN_ID'=> $questionId);
                            $this -> TriviaPortal_model -> insertOptionsMstr($params,$workspaceSchema);
                        }
                    }
                }
                else
                {
                    $data['success'] = false;
                    $data['messages']['msg-option'] = '<div class="alert alert-danger text-center">Category 1 value needs to be same.</div>';      
                   // echo json_encode($data);
                }                
            }                              
            if(count($_POST['Drag2Cate2']) > 0 && $error == false)
            {
                for($i = 0; $i < count($_POST['Drag2Cate2']); $i++)
                {
                    if($i > 0)
                    {
                        if(($_POST['Drag2Cate2'][$i]) != ($_POST['Drag2Cate2'][$i-1]))
                        {
                            $error = true;
                            break;
                        }
                        else if(count($options) > 0)
                        {
                            if(!in_array($_POST['Drag2Cate2'][$i],array_column($options,'OPT_DESC')))
                            {
                                $error = true;
                                break;
                            }                            
                        }
                    }
                   // $i++;
                }
                if($error == false)
                {
                    for($i = 0; $i < count($_POST['Drag2Cate2']); $i++)
                    {
                        if($_POST['Drag2Cate2'][$i] != "" && $_POST['Drag2Cate2Text'][$i] != "")
                        {
                            $params=array('OPT_DESC'=> $_POST['Drag2Cate2'][$i],
                                'OPT_ANSWER'=> $_POST['Drag2Cate2Text'][$i],
                                'OPT_ANS_MEDIA_PATH' => $_POST['Drag2Cate2Media'][$i],
                                'QN_ID'=> $questionId);
                            $this -> TriviaPortal_model -> insertOptionsMstr($params,$workspaceSchema);
                        }
                    }
                }
                else
                {
                    $data['success'] = false;
                    $data['messages']['msg-option'] = '<div class="alert alert-danger text-center">Category 2 value needs to be same.</div>';      
                   // echo json_encode($data);
                } 
            }
        }
        else if($gameMechanic == "Drag_Answer_3")
        {
            if(count($_POST['Drag3CardDesc']) > 0)
            {
                for($i = 0; $i < count($_POST['Drag3CardDesc']); $i++)
                {
                    if($_POST['Drag3CardDesc'][$i] != "" && $_POST['Drag3SeqNo'][$i] != "")
                    {
                        $params=array('OPT_DESC'=> $_POST['Drag3CardDesc'][$i],
                              'OPT_SEQ_NO'=> $_POST['Drag3SeqNo'][$i],
                              'QN_ID'=> $questionId);
                        $this -> TriviaPortal_model -> insertOptionsMstr($params,$workspaceSchema);
                    }
                }
            } 
        } 
                
        if ( $this->db-> trans_status() === FALSE && !isset($data['success']))
        {
            $this->db-> trans_rollback();
            $data['success'] = false;
            $data['messages']['msg-option'] = '<div class="alert alert-danger text-center">Oops Something went wrong.</div>';      
        }
        else if(!isset($data['success']))
        {
            $this->db-> trans_commit();
            $data['success'] = true;
            $data['messages']['msg-option'] = '<div class="alert alert-success text-center">Successfully Inserted.</div>';       
        }
        // }
        // else
        // {
        //     $data['success'] = false;
        //     $data['messages']['msg-option'] = '<div class="alert alert-danger text-center">All Fields are mandatory</div>';
        // }    
        echo json_encode($data);
    }
    function removeEmptyValuesForOption($options)
    {
        if(count($options) > 0)
        {
            for($i =0; $i < count($options); $i++ )
            {
                if($option[$i !=""])
                {

                }
            }
        }        
    }
    function updateOptionMstr($workspaceSchema)
    {
        $correctans = "";
        $otherchoice = "";
        $optmedia = "";
        $optanswer = "";
        $optanswermedia = "";
        $optanswerseq = "";
        $cateoneoptdesc = "";
        $catetwooptdesc = "";
        $cateonemedia = "";
        $catetwomedia = "";
        $optionId = $this->input->post('optionId');
        $questionId = $this->input->post('editquestionId');
        $gameMechanic = $this->input->post('editgameMechanic');
        
        if( ($this->input->post('editcorrectans'))!="" )
        {
            $correctans = $this->input->post('editcorrectans');
        }
        if( ($this->input->post('editotherchoice'))!="" )
        {
            $otherchoice = $this->input->post('editotherchoice');
        }
        if( ($this->input->post('editoptmedia'))!="" )
        {
            $optmedia = $this->input->post('editoptmedia');
        }
        if( ($this->input->post('editoptAns'))!="" )
        {
            $optanswer = $this->input->post('editoptAns');
        }
        if( ($this->input->post('editoptAnsMedia'))!="" )
        {
            $optanswermedia = $this->input->post('editoptAnsMedia');
        }
        if( ($this->input->post('editcateoneoptDesc'))!="" )
        {
            $cateoneoptdesc = $this->input->post('editcateoneoptDesc');
        }
        if( ($this->input->post('editcatetwooptDesc'))!="" )
        {
            $catetwooptdesc = $this->input->post('editcatetwooptDesc');
        }
        if( ($this->input->post('editcateonemedia'))!="" )
        {
            $cateonemedia = $this->input->post('editcateonemedia');
        }
        if( ($this->input->post('editcatetwomedia')) )
        {
            $catetwomedia = $this->input->post('editcatetwomedia');
        }
        // $optionId = $this->input->post('optionId');
        // $gameMechanic = $this->input->post('editgameMechanic');
        // $optDesc = $this->input->post('optDesc');
        // $optmedia = $this->input->post('optmedia');
        // $optanswer = $this->input->post('optAns');
        // $optanswermedia = $this->input->post('optAnsMedia');
        // $questionId = $this->input->post('editquestionId');
        // $oldOptDesc = $this->input->post('oldOptDesc');
        // $required = array();

            // Loop over field names, make sure each one exists and is not empty
            $error = false;
            // foreach($required as $field) {
            //   if (empty($_POST[$field])) {
            //     $error = true;
            //   }
            // }

            if($error == false)
            { 
                $this->db-> trans_begin();
                // if($gameMechanic != 'Drag_Answer_2')
                // {
                //     $params=array('OPT_DESC'=> $optDesc);
                //     if($gameMechanic == 'Bubble_Burster' || $gameMechanic == 'Drag_Answer_1')
                //     {
                //         $params['OPT_MEDIA_PATH'] = $optmedia;
                //     }
                //     if($gameMechanic == 'Scrambled_Words' || $gameMechanic == 'Drag_Answer_1')
                //     {
                //         $params['OPT_ANSWER'] = $optanswer;
                //     }
                //     if($gameMechanic == 'Drag_Answer_1')
                //     {
                //         $params['OPT_ANS_MEDIA_PATH'] = $optanswermedia;
                //     }
                //     $this -> Triviaservice_model -> updateOptionsMstr($params, $optionId) ;
                // }
                // else
                // {
                //     if($oldOptDesc != '')
                //     {
                //         $params = array('OPT_DESC' => $optDesc);
                //         $this -> Triviaservice_model -> updateOptionsMstrForDescAndQuestionId($params, $oldOptDesc, $questionId) ;
                //     }
                //     else
                //     {
                //        $params = array('OPT_ANSWER' => $optanswer,
                //                     'OPT_ANS_MEDIA_PATH' => $optanswermedia);
                //         $this -> Triviaservice_model -> updateOptionsMstr($params, $optionId) ; 
                //     }
                // }         
                if($gameMechanic == "MCQ" || $gameMechanic == "MCQ-TF")
                {
                    if($correctans !="")
                    {
                        $params = array('OPT_DESC' => $correctans);
                      $optionId=  $this -> TriviaPortal_model -> updateOptionsMstr($params, $optionId,$workspaceSchema);
                    }
    
                    if($otherchoice !="")
                    {
                        $params = array('OPT_DESC' => $otherchoice);
                        $this -> TriviaPortal_model -> updateOptionsMstr($params, $optionId,$workspaceSchema);
                    }
    
                }
                else if($gameMechanic == "Bubble_Burster")
                {
                    if($correctans !="")
                    {
                        $params=array('OPT_DESC'=> $correctans,
                                      'OPT_MEDIA_PATH' => $optmedia);
                        $this -> TriviaPortal_model -> updateOptionsMstr($params, $optionId,$workspaceSchema);
                       
                    }
                    if($otherchoice !="")
                    {
                        $params=array('OPT_DESC'=> $otherchoice,
                                      'OPT_MEDIA_PATH' => $optmedia);
                        $this -> TriviaPortal_model -> updateOptionsMstr($params, $optionId,$workspaceSchema);
                       
                    }
                }
                else if($gameMechanic == "Scrambled_Words")
                {
                    if($correctans !="")
                    {
                        $params=array('OPT_ANSWER'=> $correctans);
                        $this -> TriviaPortal_model -> updateOptionsMstr($params, $optionId,$workspaceSchema);
                    }
                }
                else if($gameMechanic == "Drag_Answer_1")
                {
                    if($correctans !="")
                    {
                        $params=array('OPT_DESC'=> $correctans,
                                      'OPT_MEDIA_PATH'=> $optmedia,
                                      'OPT_ANSWER' => $optanswer,
                                      'OPT_ANS_MEDIA_PATH' => $optanswermedia);
                        $this -> TriviaPortal_model -> updateOptionsMstr($params, $optionId,$workspaceSchema);
                    }
                }
                else if($gameMechanic == "Drag_Answer_3")
                {
                    $i=0;
                    if($correctans !="")
                    {
                        $params=array('OPT_DESC'=> $correctans,
                                      'OPT_SEQ_NO'=> ($i + 1));
                        $this -> TriviaPortal_model -> updateOptionsMstr($params, $optionId,$workspaceSchema);
                    }
                }
                else if($gameMechanic == "Drag_Answer_2")
                {
                    if($correctans !="")
                    {
                        $params=array('OPT_DESC'=> $cateoneoptdesc,
                                      'OPT_ANSWER'=> $correctans,
                                      'OPT_ANS_MEDIA_PATH' => $cateonemedia);
                        $this -> TriviaPortal_model -> updateOptionsMstr($params, $optionId,$workspaceSchema);
                    }                                   
                       
                    if($otherchoice != "")
                    {
                        $params=array('OPT_DESC'=> $catetwooptdesc,
                                      'OPT_ANSWER'=> $otherchoice,
                                      'OPT_ANS_MEDIA_PATH' => $catetwomedia);
                        $this -> TriviaPortal_model -> updateOptionsMstr($params, $optionId,$workspaceSchema);
                    }
                }
            if ( $this->db-> trans_status() === FALSE)
            {
                $this->db-> trans_rollback();
                $data['success'] = false;
                $data['messages']['msg-editoption'] = '<div class="alert alert-danger text-center">Oops Something went wrong.</div>';      
            }
            else
            {
                $this->db-> trans_commit();
                $data['success'] = true;
                $data['messages']['msg-editoption'] = '<div class="alert alert-success text-center">Successfully Updated.</div>';       
            }
         }
        else
        {
                $data['success'] = false;
                $data['messages']['msg-editoption'] = '<div class="alert alert-danger text-center">All Fields are mandatory</div>';
        }    
        echo json_encode($data);
    }
    function inviteUserstoWorkspaceView()
    {
        if($this->session->userdata('usertype')=="Admin")
        {
            $data['workspaceDtls'] = $this -> User_model -> getAllWorkspace();
        }
        else
        {
            $userId = $this->session->userdata('uid');
            $data['workspaceDtls'] = $this -> User_model -> getWorkspaceForUserByUserId($userId);
        }
        $this->session->set_userdata('in','');
        $data['_view'] = 'trivia/inviteUsertoWorkspace_view';
        $data['_navview'] = 'trivia/nav_bar_view';
        $this -> load -> view('trivia/main_view',$data);
        
    }
    function inviteUserstoWorkspace()
    {        
        $workspace = $this->input->post("WORKSPACE");
        $emailId = $this->input->post("EMAILID");

        // form validation
        $this->form_validation->set_rules("WORKSPACE", "WorkSpace", "trim|required");
        $this->form_validation->set_rules("EMAILID", "Email Id", "trim|required");

        if ($this -> form_validation -> run())
        {
            $emailIdArray = array();
            $emailIdArray = explode(',', $emailId);
            if(count($emailIdArray)<=50)
            {
                $invitedDtls = array();
                $emailArray = array();
               // $emailIdList = json_encode($emailIdArray);
                for($i = 0; $i < count($emailIdArray); $i++)
                {
                    $workspaceDtls = $this -> User_model -> getWorkspaceByEmailIdAndWorkspace($emailIdArray[$i], $workspace);
                    if(count($workspaceDtls) == 0)
                    {
                        array_push($emailArray,$emailIdArray[$i]);
                    }
                }
                if(count($emailArray) > 0)
                {
                    $emailIdList = json_encode($emailArray);
                    $invitedDtls = $this->inviteUserApi($workspace,$emailIdList);
                    //var_dump($invitedDtls);
                   if(($invitedDtls->Success == "true")||($invitedDtls == ""))
                   {
                      $this->session->set_flashdata('msg_invite', '<div class="alert alert-success text-center">Successfully Invited</div>');
                       redirect('inviteToGamespace'); 
                   }
                   else if($invitedDtls->Success == "false")
                   {
                       $this->session->set_flashdata('msg_invite', '<div class="alert alert-danger text-center">'.$invitedDtls->ErrorMsg.'</div>');
                       redirect('inviteToGamespace');
                   }
                }
                else
                {
                    $this->session->set_flashdata('msg_invite', '<div class="alert alert-success text-center">User Already have access to this workspace.</div>');
                    redirect('inviteToGamespace');
                }
            }
            else
            {
                $this -> session -> set_flashdata('msg_invite', '<div class="alert alert-danger text-center">Only 50 emailIds can be entered to invite.</div>');
                redirect('inviteToGamespace');
            }
        }
        else
        {
            $this -> session -> set_flashdata('msg_invite', '<div class="alert alert-danger text-center">Ooop! Something wrong.</div>');
            redirect('inviteToGamespace');
        }
        
    }
    function inviteUserApi($workspace,$emailId)
    {
       // echo $emailId;
        $this -> load -> library('rest', array('server' => APIBaseURL . 'api/TriviaService/', 
                                                'http_user' => 'admin', 
                                                'http_pass' => '1234', 
                                                'http_auth' => 'digest' // or 'digest'
                                                )
                                );
        $uresult = $this -> rest -> get('inviteUserToWorkSpace?emailIds='.$emailId.'&workspace='.$workspace);
        //  $uresult = $this->Safetygame_model->getCheckforUser($username, $password);
       // var_dump($uresult);
        return $uresult;
    }

    function workspaceListForUser()
    {
        // if($this->session->userdata('usertype')=="Admin")
        // {
        //     $data['workspaceDtls'] = json_decode(json_encode($this -> User_model -> getAllWorkspace()),true);
        // }
        // else
        // {
        //     $userId = $this->session->userdata('uid');
        //     $data['workspaceDtls'] = json_decode(json_encode($this -> User_model -> getWorkspaceForUserByUserId($userId)),true);
        // }
        $emailId = $this->input->post("EMAILID");
        $in = $this->session->userdata('in');
    //     $workspace = $this->input->post("WORKSPACE");
    //     if($workspace !='')
    //     {
	// 		$data['selectedstory'] = '';			
    //         $data['workspace']=$workspace;
    //         $workspaceName = $workspace;
    //     }
    //     else 
    //     {
    //         if($in !='' && $workspace != 'Gamespace')
    //         {
    //             $data['selectedstory'] = $in;
    //             $data['workspace']=$in;
    //             $workspaceName = $in;
    //         }
    //         else
    //         {
	// 			$data['selectedstory'] = '';
    //             $data['workspace']=$workspace;
    //             $workspaceName = $workspace;
    //         }
    //     }
        $params['limit'] = RECORDS_PER_PAGE;
        $params['offset'] = ($this -> input -> get('per_page')) ? $this -> input -> get('per_page') : 0;
    
        $config = $this -> config -> item('pagination');
        $config['base_url'] = site_url('Main/User-Gamespacelist?');
        $workspaceList = $this -> User_model -> getWorkspaceForUserByEmailId($emailId);
        $config['total_rows'] = count($workspaceList) ;
        $this->pagination->initialize($config);
    
        $workspaceDtls = $this -> User_model -> getWorkspaceForUserByEmailId($emailId,$params);
           
        $data['workspaceDtls'] = $workspaceDtls;
        $data['_view'] = 'trivia/workspacelistforuser_view';
        $data['_navview'] = 'trivia/nav_bar_view';
        $this -> load -> view('trivia/main_view',$data);
    }
    function performanceReport($userId,$workspace)
    {
        $this -> load -> library('rest', array('server' => APIBaseURL . 'api/TriviaService/', 
                                                'http_user' => 'admin', 
                                                'http_pass' => '1234', 
                                                'http_auth' => 'digest' // or 'digest'
                                                )
                                );
        if($this->input->post("category")=='')
        {
            $category= 'All Category';
        }
        else
        {
            $category= $this->input->post("category");
        }
        $categoryName = str_replace(' ', '%20', $category);
        if($this->input->post('month') == '')
        {
            $month=date("F");
        }
        else
        {
            $month= $this->input->post('month');
        }
        if($this->input->post('year') == '')
        {
            $year=date("Y");
        }
        else
        {
            $year= $this->input->post('year');
        }
        $monthYear = $month.'%20'.$year;

        $dateWisePerformance = $this -> rest -> get('getDateWisePeformanceReport?userId='.$userId.'&category='.$categoryName.'&monthYear='.$monthYear.'&workspace='.$workspace);
       // var_dump($dateWisePerformance);
        $dateWiseReport = json_decode(json_encode($dateWisePerformance), true);

        $overallPerformance = $this -> rest -> get('getOverallPerformanceForUser?userId='.$userId.'&workspace='.$workspace);
        $overallReport = json_decode(json_encode($overallPerformance), true);
        $allCategory = array('QN_CATEGORY' => 'All Category');
        $workSpaceSchema = $this -> User_model -> getWorkspaceByDesc($workspace);
		
		//define('TIRIVA_SCHEMA',$workSpaceSchema[0]->WS_SCHEMA);
        $allCategoryDetails = $this -> rest -> get('getQuestionCategory?workspace='.$workspace);
        $allCategoryList = json_decode(json_encode($allCategoryDetails->QUESTION_CATEGORY), true);
        array_unshift($allCategoryList, $allCategory);
       //var_dump($allCategoryDetails);
        $new = array("dateWiseReport" => $dateWiseReport,
                    "attemptDetails" => $overallReport['GAMES_PLAYED_DETAILS'],
                    "categoryWisePerformance" => $overallReport['CATEGORY_WISE_PERFORMANCE'],
                    "totalCorrectAnswer" => $overallReport['TOTAL_ATTEMPT_DETAILS'],
                    "questionCategory" => $allCategoryList,
                    "userId" => $userId,
                    "workspace" => $workspace);
         $data['chartdata'] = json_encode($new);
        $data['_view'] = 'trivia/userWisePerformance_view';
        $data['_navview'] = 'trivia/nav_bar_view';
        $this -> load -> view('trivia/main_view',$data);
    }
    function workspaceListView()
    {
        $userId = $this->session->userdata('uid');
        $data['workspaceList'] = $this -> User_model -> getWorkspaceForUserByUserId($userId);
        $data['_view'] = 'trivia/workspace_list_view';
        $data['_navview'] = 'trivia/nav_bar_view';
        $this -> load -> view('trivia/main_view',$data);
    }
    function questionCategory($workspaceId)
    {
        $workspacedetails = $this -> TriviaPortal_model -> getWorkspaceDetailsById($workspaceId);
        $workspaceSchema = $workspacedetails[0]->WS_SCHEMA;
        $datapassed['categoryDtls'] = $this -> TriviaPortal_model -> getAllQuestionCategoryForSchema($workspaceSchema);
        $datapassed['workspaceSchema'] = $workspaceSchema;
        $data= $this -> load -> view('trivia/questionCategory_view',$datapassed,TRUE);
        echo json_encode($data);
    }
    function questionCategoryUpdateView($workspaceSchema,$categoryId)
    {
        $datapassed['workspaceSchema'] = $workspaceSchema;
        $datapassed['categoryDtls'] = $this -> TriviaPortal_model -> getQuestionCategoryByIdForSchema($workspaceSchema,$categoryId);
        $data= $this -> load -> view('trivia/questionCategory_edit_view',$datapassed,TRUE);
        echo json_encode($data);
    }
    function pointsUpdateView($workspaceSchema,$pointsId)
    {
        $datapassed['workspaceSchema'] = $workspaceSchema;
        $datapassed['pointsDtls'] = $this -> TriviaPortal_model -> getPointsDetailsByIdfromWorkspace($workspaceSchema,$pointsId);
        $datapassed['categoryDtls'] = $this -> TriviaPortal_model -> getAllQuestionCategoryForSchema($workspaceSchema);
        $data= $this -> load -> view('trivia/points_edit_view',$datapassed,TRUE);
        echo json_encode($data);
    }
    function UpdateQuizView($workspaceSchema,$quizId)
    {
        $datapassed['workspaceSchema'] = $workspaceSchema;
        $datapassed['quizDtls'] = $this -> TriviaPortal_model -> getQuizDetailsByQuizId($workspaceSchema,$quizId);
        $data= $this -> load -> view('trivia/quiz_edit_view',$datapassed,TRUE);
        echo json_encode($data);
    }
    function quizListview()
    {
        $userId = $this->session->userdata('uid');
        $data['workspaceList'] = $this -> User_model -> getWorkspaceForUserByUserId($userId);
        $workspaceId = $this->input->post('WORKSPACE_SCHEMA');
        $quizDtls = array();
        if($workspaceId != '')
        {
            $workspaceDtls = $this -> TriviaPortal_model ->getWorkspaceDetailsById($workspaceId);
            $workspaceSchema = $workspaceDtls[0]->WS_SCHEMA;
            $data['workspaceSchema']=$workspaceSchema;
            $currdate = $this -> User_model -> getCurrentTimeFromDatabase();
            $quizDtls = $this -> TriviaPortal_model ->getAllQuizForWorkspace($workspaceSchema);
            foreach ($quizDtls as $quiz) 
            {
                if($currdate[0]->CurrentDate >= $quiz->END_TIME)
                {
                    $quiz->QUIZ_STATUS = 'COMPLETED';
                }
                if(($currdate[0]->CurrentDate < $quiz->END_TIME) && ($currdate[0]->CurrentDate >= $quiz->START_TIME))
                {
                    $quiz->QUIZ_STATUS = 'ACTIVE';
                }
                if($currdate[0]->CurrentDate < $quiz->START_TIME)
                {
                    $quiz->QUIZ_STATUS = 'UPCOMING';
                }
            }
        }
        else
        {
            $data['workspaceSchema']='';
        }
        $data['quizDtls'] = $quizDtls;
        
        $data['_view'] = 'trivia/quiz_list_view';
        $data['_navview'] = 'trivia/nav_bar_view';
        $this -> load -> view('trivia/main_view',$data);
    }
    function mapQuestionQuizView($workspaceSchema, $questionId)
    {
        $datapassed['questionId'] = $questionId;
        $datapassed['workspaceSchema'] = $workspaceSchema;
        $datapassed['questionDtls'] = $this -> TriviaPortal_model -> getQuestionByIdFromWorkspace($workspaceSchema,$questionId);
       // $datapassed['quizList'] = $this -> Triviaservice_model -> getAllActiveQuiz();
       $currdate = $this -> User_model -> getCurrentTimeFromDatabase();
       $quizDtls = $this -> TriviaPortal_model ->getAllQuizForWorkspace($workspaceSchema);
       foreach ($quizDtls as $quiz) 
		{
			if($currdate[0]->CurrentDate >= $quiz->END_TIME)
			{
				$quiz->QUIZ_STATUS = 'COMPLETED';
			}
			if(($currdate[0]->CurrentDate < $quiz->END_TIME) && ($currdate[0]->CurrentDate >= $quiz->START_TIME))
			{
				$quiz->QUIZ_STATUS = 'ACTIVE';
			}
			if($currdate[0]->CurrentDate < $quiz->START_TIME)
			{
				$quiz->QUIZ_STATUS = 'UPCOMING';
			}
        }
        $datapassed['quizList'] = $quizDtls;
        $data= $this -> load -> view('trivia/map_question_to_quiz_view',$datapassed,TRUE);
		$alldata = array("addView"=>$data);
        echo json_encode($alldata);
    }
    function mapQuestionToQuiz()
    {
        $quizId = $this->input->post('quizId');
        $workspaceSchema = $this->input->post('workspaceSchema');
        if(isset($_POST) && count($_POST) > 0)     
        {   
            $error = false;
            $required = array('quizId','questionId');

            // Loop over field names, make sure each one exists and is not empty
            foreach($required as $field) 
            {
                if (empty($_POST[$field])) 
                {
                    $error = true;
                    break;
                }
            }

            if($error == false)
            {
                for($i = 0; $i < count($_POST['questionId']); $i++)
                {
                    $checkQuestionMappedToQuiz = $this-> TriviaPortal_model->checkQuestionMappedToQuiz($workspaceSchema, $quizId, $_POST['questionId'][$i]);
                    if(count($checkQuestionMappedToQuiz) == 0)
                    {
                        $params = array(
                            'QUIZ_ID' => $quizId,
                            'QN_ID' => $_POST['questionId'][$i],
                            'STATUS' => "A",
                        );
                        $questionToQuizMap=$this-> TriviaPortal_model->insertquestionToQuizForWorkspace($workspaceSchema,$params);
                    }
                    else
                    {
                        $questionToQuizMap = $this -> TriviaPortal_model -> updatequestionToQuizForWorkspace($workspaceSchema, $checkQuestionMappedToQuiz[0]->QUIZ_QN_ID, "A");
                    }                 
                }            
                $data['success'] = true;
                $data['messages']['msg_mapQuiz'] = '<div class="alert alert-success text-center">Inserted Successfully.</div>';
            }
            else
            {
                $data['success'] = false;
                $data['messages']['msg_mapQuiz'] = '<div class="alert alert-danger text-center">Please Enter Mandatory fields.</div>';
            }
        }
        else
        {
            $data['success'] = false;
            $data['messages']['msg_mapQuiz'] = '<div class="alert alert-danger text-center">oops! Something went wrong.</div>';
        }
        echo json_encode($data);
    }
    function updateMapQuestionToQuiz()
    {
        $quizId = $this->input->post('quizId');
        $workspaceSchema = $this->input->post('workspaceSchema');
        if(isset($_POST) && count($_POST) > 0)     
        {   
            // $error = false;
            // $required = array('quizId','questionId');

            // // Loop over field names, make sure each one exists and is not empty
            // foreach($required as $field) 
            // {
            //     if (empty($_POST[$field])) 
            //     {
            //         $error = true;
            //         break;
            //     }
            // }

            if($error == false)
            {
                $mappedQuestion = $this-> TriviaPortal_model -> getQuestionToQuiz($workspaceSchema, $quizId);
                foreach($mappedQuestion as $mapQues)
                {
                    if(!in_array($mapQues->QN_ID, $_POST['questionId']))
                    {
                        $questionToQuizMap = $this -> TriviaPortal_model -> updatequestionToQuizForWorkspace($workspaceSchema, $mapQues->QUIZ_QN_ID, "I");
                    }
                }
                // for($i = 0; $i < count($_POST['questionId']); $i++)
                // {
                //     $checkQuestionMappedToQuiz = $this-> TriviaPortal_model->checkQuestionMappedToQuiz($workspaceSchema, $quizId, $_POST['questionId'][$i]);
                //     if(count($checkQuestionMappedToQuiz) == 0)
                //     {
                //         $params = array(
                //             'QUIZ_ID' => $quizId,
                //             'QN_ID' => $_POST['questionId'][$i],
                //             'STATUS' => "A",
                //         );
                //         $questionToQuizMap=$this-> TriviaPortal_model->insertquestionToQuizForWorkspace($workspaceSchema,$params);
                //     }      
                //     else
                //     {
                //         $questionToQuizMap = $this -> TriviaPortal_model -> updatequestionToQuizForWorkspace($workspaceSchema, $checkQuestionMappedToQuiz[0]->QUIZ_QN_ID, "A");
                //     }          
                // }            
                $data['success'] = true;
                $data['messages']['msg-updatemapquesquiz'] = '<div class="alert alert-success text-center">Updated Successfully.</div>';
            }
            else
            {
                $data['success'] = false;
                $data['messages']['msg-updatemapquesquiz'] = '<div class="alert alert-danger text-center">Please Enter Mandatory fields.</div>';
            }
        }
        else
        {
            $data['success'] = false;
            $data['messages']['msg-updatemapquesquiz'] = '<div class="alert alert-danger text-center">oops! Something went wrong.</div>';
        }
        echo json_encode($data);
    }
    function mapFlashCardToQuestionView($workspaceSchema, $questionId)
    {
        $datapassed['questionId'] = $questionId;
        $datapassed['workspaceSchema'] = $workspaceSchema;
        $datapassed['questionDtls'] = $this -> TriviaPortal_model -> getQuestionByIdFromWorkspace($workspaceSchema,$questionId);
      
        $datapassed['flashCards'] = $this -> TriviaPortal_model ->getAllFlashCardsForWorkspace($workspaceSchema);
        $data= $this -> load -> view('trivia/map_question_to_card_view',$datapassed,TRUE);
		$alldata = array("addView"=>$data);
        echo json_encode($alldata);
    }
    function mapFlashCardToQuestion()
    {
        $questionId = $this->input->post('questionId');
        $workspaceSchema = $this->input->post('workspaceSchema');
        $selectFlashCardType = $this->input->post('selectflashCard');// get type of flash card i.e., new or existing flash card
        
        if(isset($_POST) && count($_POST) > 0)     
        {   
            if($selectFlashCardType == "newFlashCard")
            {
                $error = false;
                $required = array('title');

                // Loop over field names, make sure each one exists and is not empty
                foreach($required as $field) 
                {
                    if (empty($_POST[$field])) 
                    {
                        $error = true;
                        break;
                    }
                }

                if($error == false)
                {
                    $flashCardParam = array();
                    $title = $this->input->post('title');
                    $description = $this->input->post('flashdesc');
                    $mediaPath = $this->input->post('imageurl');
                    $i = 0;
                    if($title !="")
                    {
                        $flashCardParam[$i]['Name'] = "TITLE";
                        $flashCardParam[$i]['Value'] = $title;
                        $i++;
                    }
                    if($description !="")
                    {
                        $flashCardParam[$i]['Name'] = "DESCRIPTION";
                        $flashCardParam[$i]['Value'] = $description;
                        $i++;
                    }
                    if($mediaPath !="")
                    {
                        $flashCardParam[$i]['Name'] = "IMAGE";
                        $flashCardParam[$i]['Value'] = $mediaPath;
                        $i++;
                    }
                    $getMaxFlashCardId = $this -> TriviaPortal_model ->getAllFlashCardsForWorkspace($workspaceSchema);

                    $MaxIdFlashCard   = end($getMaxFlashCardId);
                    $maxCardId = $MaxIdFlashCard->CARD_ID;
                    for($j = 0; $j < count($flashCardParam); $j++)
                    {
                        if($flashCardParam[$j]['Name'] != "IMAGE")
                        {
                            $params=array('CARD_ID'=> (int)$maxCardId + 1,
                                'CARD_DETAIL_CODE'=> $flashCardParam[$j]['Name'],
                                'CARD_DETAIL_DESC'=> $flashCardParam[$j]['Value'],
                                'STATUS' => "A");
                            $this -> TriviaPortal_model -> insertFlashCardForWorkspace($workspaceSchema,$params);
                        }
                        else
                        {
                            $params=array('CARD_ID'=> (int)$maxCardId + 1,
                                'CARD_DETAIL_CODE'=> $flashCardParam[$j]['Name'],
                                'MEDIA_URL'=> $flashCardParam[$j]['Value'],
                                'STATUS' => "A");
                            $this -> TriviaPortal_model -> insertFlashCardForWorkspace($workspaceSchema,$params);
                        }
                    }
                    $cardmappingparams = array(
                        'CARD_ID' => (int)$maxCardId + 1,
                        'QN_ID' => $questionId
                    );
                    $questionToCardMap=$this-> TriviaPortal_model->insertcardToquesMapForWorkspace($workspaceSchema,$cardmappingparams);
                    $data['success'] = true;
                    $data['messages']['msg_mapFlashCard'] = '<div class="alert alert-success text-center">Inserted Successfully.</div>';
                }
            }
            else
            {
                $error = false;
                $required = array('cardId');

                // Loop over field names, make sure each one exists and is not empty
                foreach($required as $field) 
                {
                    if (empty($_POST[$field])) 
                    {
                        $error = true;
                        break;
                    }
                }

                if($error == false)
                {
                    $checkcardMapToQues = $this-> TriviaPortal_model->checkCardMappedToQuestion($workspaceSchema, $questionId);
                    if(count($checkcardMapToQues) == 0)
                    {
                        $params = array(
                            'CARD_ID' => $this-> input->post('cardId'),
                            'QN_ID' => $questionId
                        );
                        $questionToCardMap=$this-> TriviaPortal_model->insertcardToquesMapForWorkspace($workspaceSchema,$params);
                        $data['success'] = true;
                        $data['messages']['msg_mapFlashCard'] = '<div class="alert alert-success text-center">Inserted Successfully.</div>';
                    }           
                    else
                    {
                        $data['success'] = false;
                        $data['messages']['msg_mapFlashCard'] = '<div class="alert alert-danger text-center">Card is already mapped to this question.</div>';
                    }
                }
                else
                {
                    $data['success'] = false;
                    $data['messages']['msg_mapFlashCard'] = '<div class="alert alert-danger text-center">Please Select Flash Card.</div>';
                }
            }
            
        }
        else
        {
            $data['success'] = false;
            $data['messages']['msg_mapFlashCard'] = '<div class="alert alert-danger text-center">oops! Something went wrong.</div>';
        }
        echo json_encode($data);
    }
    function addQuizMstr($workspaceSchema)
    {
        if(isset($_POST) && count($_POST) > 0)     
        {   
            $error = false;
            $required = array('quizDesc','START_DATE', 'END_DATE', 'status');

            // Loop over field names, make sure each one exists and is not empty
            foreach($required as $field) 
            {
                if (empty($_POST[$field])) 
                {
                    $error = true;
                    break;
                }
            }

            if($error == false)
            {
                $params=array('QUIZ_DESC'=> $this->input->post('quizDesc'),
                            'START_TIME'=> $this->input->post('START_DATE'),
                            'END_TIME'=> $this->input->post('END_DATE'),
                            'STATUS' => $this->input->post('status'));
                            
                $this -> TriviaPortal_model -> insertQuizMstrForWorkspace($workspaceSchema,$params);
                $data['success'] = true;
                $data['messages']['msg-addquiz'] = '<div class="alert alert-success text-center">Successfully Inserted.</div>';       
            }
            else
            {
                $data['success'] = false;
                $data['messages']['msg-addquiz'] = '<div class="alert alert-danger text-center">Please Enter Mandatory Fields</div>';
            } 
         }
        else
        {
            $data['success'] = false;
            $data['messages']['msg-addquiz'] = '<div class="alert alert-danger text-center">Oops! Something went Wrong.</div>';
        }    
        echo json_encode($data);
    }
    function updateQuizMstr($workspaceSchema)
    {
        if(isset($_POST) && count($_POST) > 0)     
        {   
            $quizId = $this->input->post('quizId');
            $error = false;
            $required = array('quizDesc','EDIT_START_DATE', 'EDIT_END_DATE', 'status');

            // Loop over field names, make sure each one exists and is not empty
            foreach($required as $field) 
            {
                if (empty($_POST[$field])) 
                {
                    $error = true;
                    break;
                }
            }

            if($error == false)
            {
                $params=array('QUIZ_DESC'=> $this->input->post('quizDesc'),
                            'START_TIME'=> $this->input->post('EDIT_START_DATE'),
                            'END_TIME'=> $this->input->post('EDIT_END_DATE'),
                            'STATUS' => $this->input->post('status'));
                            
                $this -> TriviaPortal_model -> updateQuizMstrForWorkspace($quizId, $params,$workspaceSchema);
                $data['success'] = true;
                $data['messages']['msg-editquiz'] = '<div class="alert alert-success text-center">Successfully Inserted.</div>';       
            }
            else
            {
                $data['success'] = false;
                $data['messages']['msg-editquiz'] = '<div class="alert alert-danger text-center">Please Enter Mandatory Fields</div>';
            } 
         }
        else
        {
            $data['success'] = false;
            $data['messages']['msg-editquiz'] = '<div class="alert alert-danger text-center">Oops! Something went Wrong.</div>';
        }    
        echo json_encode($data);
    }
    function quizQuesListView($workspaceSchema, $quizId)
    {
        $quizDtls = $this -> TriviaPortal_model -> getQuizDetailsByQuizId($workspaceSchema,$quizId);
        $currdate = $this -> User_model -> getCurrentTimeFromDatabase();

       if($currdate[0]->CurrentDate >= $quizDtls[0]->END_TIME)
		{
			$quizDtls[0]->QUIZ_STATUS = 'COMPLETED';
		}
		if(($currdate[0]->CurrentDate < $quizDtls[0]->END_TIME) && ($currdate[0]->CurrentDate >= $quizDtls[0]->START_TIME))
		{
			$quizDtls[0]->QUIZ_STATUS = 'ACTIVE';
		}
		if($currdate[0]->CurrentDate < $quizDtls[0]->START_TIME)
		{
			$quizDtls[0]->QUIZ_STATUS = 'UPCOMING';
		}
        $datapassed['quiz'] = $quizDtls;
        $datapassed['questions']= $this -> TriviaPortal_model -> getQuestionToQuiz($workspaceSchema,$quizId);
        $datapassed['workspaceSchema'] = $workspaceSchema;
        $data= $this -> load -> view('trivia/quiz_question_view',$datapassed,TRUE);
        echo json_encode($data);
    }
    function mapMultiQuesToQuizView($workspaceSchema, $quizId)
    {
        $datapassed['quizId'] = $quizId;
        $datapassed['workspaceSchema'] = $workspaceSchema;
        $questionList = $this -> TriviaPortal_model -> getAllQuestionsForWorkspaceNotMappedToQuizId($workspaceSchema, $quizId);
        $mappedQuestion = $this -> TriviaPortal_model -> getInactiveQuestionToQuiz($workspaceSchema, $quizId);
        if(count($mappedQuestion)>0)
        {
            for($i = 0; $i < count($mappedQuestion); $i++)
            {
                array_push($questionList,$mappedQuestion[$i]);
            }            
        }
        $datapassed['questionList'] = $questionList;
        $data= $this -> load -> view('trivia/map_multi_ques_to_quiz_view',$datapassed,TRUE);
		$alldata = array("addView"=>$data);
        echo json_encode($alldata);
    }
    function updatemapMultiQuesToQuizView($workspaceSchema, $quizId)
    {
        $datapassed['quizId'] = $quizId;
        $datapassed['workspaceSchema'] = $workspaceSchema;
        $datapassed['questionList'] = $this -> TriviaPortal_model -> getQuestionToQuiz($workspaceSchema, $quizId);
        $data= $this -> load -> view('trivia/update_map_multi_ques_to_quiz_view',$datapassed,TRUE);
		$alldata = array("addView"=>$data);
        echo json_encode($alldata);
    }
    function flashCardListview()
    {
        $userId = $this->session->userdata('uid');
        $data['workspaceList'] = $this -> User_model -> getWorkspaceForUserByUserId($userId);
        $workspaceId = $this->input->post('WORKSPACE_SCHEMA');
        $flashCardList = array();
        if($workspaceId != '')
        {
            $workspaceDtls = $this -> TriviaPortal_model ->getWorkspaceDetailsById($workspaceId);
            $workspaceSchema = $workspaceDtls[0]->WS_SCHEMA;
            $data['workspaceSchema']=$workspaceSchema;
            $flashCards = $this -> TriviaPortal_model ->getAllFlashCardsForWorkspace($workspaceSchema);
            
            $i = 0;
            $tempCardId = "";
            if(count($flashCards) > 0)
            {
                foreach ($flashCards as $card) 
                {
                    if($tempCardId!=$card->CARD_ID && $tempCardId !="")
                    {
                        if(!array_key_exists("TITLE", $flashCardList[$i]))
                        {
                            $flashCardList[$i]['TITLE'] = "";
                        }
                        if(!array_key_exists("DESCRIPTION", $flashCardList[$i]))
                        {
                            $flashCardList[$i]['DESCRIPTION'] = "";
                        }
                        if(!array_key_exists("MEDIA_URL", $flashCardList[$i]))
                        {
                            $flashCardList[$i]['MEDIA_URL'] = "";
                        }
                        $i++;
                    }
                    $flashCardList[$i]['CARD_ID'] = $card->CARD_ID;
                    if($card->CARD_DETAIL_CODE == "TITLE")
                    {
                        $flashCardList[$i]['TITLE'] = $card->CARD_DETAIL_DESC;
                    }
                    if($card->CARD_DETAIL_CODE == "DESCRIPTION")
                    {
                        $flashCardList[$i]['DESCRIPTION'] = $card->CARD_DETAIL_DESC;
                    }
                    if($card->CARD_DETAIL_CODE == "IMAGE")
                    {
                        $flashCardList[$i]['MEDIA_URL'] = $card->MEDIA_URL;
                    }
                    $flashCardList[$i]['STATUS'] = $card->STATUS;
                    $tempCardId = $card->CARD_ID;
                }
                if(!array_key_exists("TITLE", $flashCardList[$i]))
                {
                    $flashCardList[$i]['TITLE'] = "";
                }
                if(!array_key_exists("DESCRIPTION", $flashCardList[$i]))
                {
                    $flashCardList[$i]['DESCRIPTION'] = "";
                }
                if(!array_key_exists("MEDIA_URL", $flashCardList[$i]))
                {
                    $flashCardList[$i]['MEDIA_URL'] = "";
                }
            }            
        }
        else
        {
            $data['workspaceSchema']='';
        }
        
        $data['flashCards'] = $flashCardList;
        $data['_view'] = 'trivia/flash_card_list_view';
        $data['_navview'] = 'trivia/nav_bar_view';
        $this -> load -> view('trivia/main_view',$data);
    }
    function getflashCardEditView($workspaceSchema,$cardId)
    {
        $flashCardDetails = $this -> TriviaPortal_model -> getFlashCardsByIdForWorkspace($workspaceSchema,$cardId);
        $flashCard = array();
        $i = 0;
        foreach ($flashCardDetails as $card) 
        {
            $flashCard[$i]['CARD_ID'] = $card->CARD_ID;
            if($card->CARD_DETAIL_CODE == "TITLE")
            {
                $flashCard[$i]['TITLE'] = $card->CARD_DETAIL_DESC;
            }
            if($card->CARD_DETAIL_CODE == "DESCRIPTION")
            {
                $flashCard[$i]['DESCRIPTION'] = $card->CARD_DETAIL_DESC;
            }
            if($card->CARD_DETAIL_CODE == "IMAGE")
            {
                $flashCard[$i]['MEDIA_URL'] = $card->MEDIA_URL;
            }
            $flashCard[$i]['STATUS'] = $card->STATUS;
            //$i++;
        }
        if(!array_key_exists("TITLE", $flashCard[0]))
        {
            $flashCard[0]['TITLE'] = "";
        }
        if(!array_key_exists("DESCRIPTION", $flashCard[0]))
        {
            $flashCard[0]['DESCRIPTION'] = "";
        }
        if(!array_key_exists("MEDIA_URL", $flashCard[0]))
        {
            $flashCard[0]['MEDIA_URL'] = "";
        }
        $datapassed['flashCard'] = $flashCard;
        $datapassed['workspaceSchema'] = $workspaceSchema;
        $data=$this->load->view('trivia/flash_card_edit_view',$datapassed,TRUE);
     
        echo json_encode($data);
    }
    function addFlashCardMstr($workspaceSchema)
    {
        if(isset($_POST) && count($_POST) > 0)     
        {   
            $error = false;
            $required = array('title');

            // Loop over field names, make sure each one exists and is not empty
            foreach($required as $field) 
            {
                if (empty($_POST[$field])) 
                {
                    $error = true;
                    break;
                }
            }

            if($error == false)
            {
                $flashCardParam = array();
                $title = $this->input->post('title');
                $description = $this->input->post('flashdesc');
                $mediaPath = $this->input->post('imageurl');
                $i = 0;
                if($title !="")
                {
                    $flashCardParam[$i]['Name'] = "TITLE";
                    $flashCardParam[$i]['Value'] = $title;
                    $i++;
                }
                if($description !="")
                {
                    $flashCardParam[$i]['Name'] = "DESCRIPTION";
                    $flashCardParam[$i]['Value'] = $description;
                    $i++;
                }
                if($mediaPath !="")
                {
                    $flashCardParam[$i]['Name'] = "IMAGE";
                    $flashCardParam[$i]['Value'] = $mediaPath;
                    $i++;
                }
                $getMaxFlashCardId = $this -> TriviaPortal_model ->getAllFlashCardsForWorkspace($workspaceSchema);

                $MaxIdFlashCard   = end($getMaxFlashCardId);
                $maxCardId = $MaxIdFlashCard->CARD_ID;
                for($j = 0; $j < count($flashCardParam); $j++)
                {
                    if($flashCardParam[$j]['Name'] != "IMAGE")
                    {
                        $params=array('CARD_ID'=> (int)$maxCardId + 1,
                            'CARD_DETAIL_CODE'=> $flashCardParam[$j]['Name'],
                            'CARD_DETAIL_DESC'=> $flashCardParam[$j]['Value'],
                            'STATUS' => "A");
                        $this -> TriviaPortal_model -> insertFlashCardForWorkspace($workspaceSchema,$params);
                    }
                    else
                    {
                        $params=array('CARD_ID'=> (int)$maxCardId + 1,
                            'CARD_DETAIL_CODE'=> $flashCardParam[$j]['Name'],
                            'MEDIA_URL'=> $flashCardParam[$j]['Value'],
                            'STATUS' => "A");
                        $this -> TriviaPortal_model -> insertFlashCardForWorkspace($workspaceSchema,$params);
                    }
                }
                $data['success'] = true;
                $data['messages']['msg-flash'] = '<div class="alert alert-success text-center">Successfully Inserted.</div>';       
            }
            else
            {
                $data['success'] = false;
                $data['messages']['msg-flash'] = '<div class="alert alert-danger text-center">Please Enter Mandatory Fields</div>';
            } 
         }
        else
        {
            $data['success'] = false;
            $data['messages']['msg-flash'] = '<div class="alert alert-danger text-center">Oops! Something went Wrong.</div>';
        }    
        echo json_encode($data);
    }
    function updateFlashCardMstr($workspaceSchema)
    {
        if(isset($_POST) && count($_POST) > 0)     
        {   
            $error = false;
            $required = array('edittitle');

            // Loop over field names, make sure each one exists and is not empty
            foreach($required as $field) 
            {
                if (empty($_POST[$field])) 
                {
                    $error = true;
                    break;
                }
            }

            if($error == false)
            {
                $flashCardParam = array();
                $cardId = $this->input->post('flashCardId');
                $title = $this->input->post('edittitle');
                $description = $this->input->post('editflashdesc');
                $mediaPath = $this->input->post('editimageurl');
                $status = $this->input->post('edit_status');
                $i = 0;
                if($title !="")
                {
                    $flashCardParam[$i]['Name'] = "TITLE";
                    $flashCardParam[$i]['Value'] = $title;
                    $flashCardParam[$i]['Status'] = $status;
                    $i++;
                }
                if($description !="")
                {
                    $flashCardParam[$i]['Name'] = "DESCRIPTION";
                    $flashCardParam[$i]['Value'] = $description;
                    $flashCardParam[$i]['Status'] = $status;
                    $i++;
                }
                if($mediaPath !="")
                {
                    $flashCardParam[$i]['Name'] = "IMAGE";
                    $flashCardParam[$i]['Value'] = $mediaPath;
                    $flashCardParam[$i]['Status'] = $status;
                    $i++;
                }
                for($j = 0; $j < count($flashCardParam); $j++)
                {
                    $cardDetailByCode = $this-> TriviaPortal_model ->getFlashCardsByIdAndCodeForWorkspace($workspaceSchema,$cardId, $flashCardParam[$j]['Name']);
                    if($flashCardParam[$j]['Name'] != "IMAGE")
                    {                        
                        if(count($cardDetailByCode) > 0)
                        {
                            $params=array('CARD_DETAIL_DESC'=> $flashCardParam[$j]['Value'],
                            'STATUS' => $flashCardParam[$j]['Status']);
                            $this -> TriviaPortal_model -> updateFlashCardForWorkspace($workspaceSchema, $params, $cardId, $flashCardParam[$j]['Name']);
                        }
                        else
                        {
                            $params=array('CARD_ID'=> $cardId,
                            'CARD_DETAIL_CODE'=> $flashCardParam[$j]['Name'],
                            'CARD_DETAIL_DESC'=> $flashCardParam[$j]['Value'],
                            'STATUS' => $flashCardParam[$j]['Status']);
                            $this -> TriviaPortal_model -> insertFlashCardForWorkspace($workspaceSchema,$params);
                        }
                    }
                    else
                    {
                        if(count($cardDetailByCode) > 0)
                        {
                            $params=array('MEDIA_URL'=> $flashCardParam[$j]['Value'],
                                'STATUS' => $flashCardParam[$j]['Status']);
                            $this -> TriviaPortal_model -> updateFlashCardForWorkspace($workspaceSchema, $params, $cardId, $flashCardParam[$j]['Name']);
                        }
                        else
                        {
                            $params=array('CARD_ID'=> $cardId,
                            'CARD_DETAIL_CODE'=> $flashCardParam[$j]['Name'],
                            'MEDIA_URL'=> $flashCardParam[$j]['Value'],
                            'STATUS' => $flashCardParam[$j]['Status']);
                            $this -> TriviaPortal_model -> insertFlashCardForWorkspace($workspaceSchema,$params);
                        }
                    }
                }
                $data['success'] = true;
                $data['messages']['msg-editflash'] = '<div class="alert alert-success text-center">Successfully Updated.</div>';       
            }
            else
            {
                $data['success'] = false;
                $data['messages']['msg-editflash'] = '<div class="alert alert-danger text-center">Please Enter Mandatory Fields</div>';
            } 
         }
        else
        {
            $data['success'] = false;
            $data['messages']['msg-editflash'] = '<div class="alert alert-danger text-center">Oops! Something went Wrong.</div>';
        }    
        echo json_encode($data);
    }
    public function getAllImageFromResource()
    { 
        $dirname = "resources/img/";
        $images = glob($dirname.'*.{jpg,JPG,jpeg,JPEG,png,PNG}',GLOB_BRACE);
        $sorted_files=array(); /* a new array that have modification time as values
        and files as keys the purpose is to sort files according to the values in reverse order */ 
        $i = 0;
        foreach ($images as $file)
        {
            $sorted_files[$i]['time']=filemtime($file);
            $sorted_files[$i]['image']=$file;
            $i++;
        }
        // arsort($sorted_files);
        array_multisort( array_column($sorted_files, "time"), SORT_DESC, $sorted_files );
        $data['images']=array_column($sorted_files, "image");
        echo json_encode($data);
    } 
    public function uploadImagetoResource()
    {        
        if(isset($_FILES['Filename']['name']))
        {
            $config['upload_path'] = './resources/img/';
            $config['allowed_types'] = 'jpg|jpeg|png';
            $this -> load ->library('upload',$config);
            if(!$this->upload->do_upload('Filename'))
            {
               // echo $this->upload->display_errors();
               //Gives and error if its not uploaded
                $data['success'] = "Sorry, there was a problem uploading your file.";
                echo json_encode($data);
            }
            else
            {
                $data = $this->upload->data();

                //to resize the uploaded image
                $config['image_library'] = 'gd2'; // gd2 library to resize image
                $config['source_image'] = './resources/img/'.$data['file_name'];
                $config['create_thumb'] = FALSE;
                $config['maintain_ratio'] = FALSE;
                $config['quality'] = '60%';
                $config['width'] = 1024; //width in pixel
                $config['height'] = 1024; //height in pixel
                $config['new_image'] = './resources/img/'.$data['file_name'];
                $this->load->library('image_lib',$config);
                $this->image_lib->resize();
                $data['success'] = true;
                echo json_encode($data);
            }
        }
    }
}