<?php
class Signup extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this -> load -> helper(array('form', 'url'));
		$this -> load -> library(array('session', 'form_validation'));
		$this -> load -> database();
		$this -> load -> model('User_model');
	}

	function index()
	{
		$this->form_validation->set_message('is_unique', 'The %s is already taken');
		// set form validation rules
		$this -> form_validation -> set_rules('fname_reg', 'Full Name', 'trim|required|alpha|min_length[3]|max_length[30]');
		$this -> form_validation -> set_rules('email_reg', 'Email ID', 'trim|required|valid_email|is_unique[user_mstr.EMAIL_ID]');
		//$this->form_validation->set_rules('password', 'Password', 'trim|required|matches[cpassword]|md5');
		$this -> form_validation -> set_rules('password_reg', 'Password', 'required');
		$this -> form_validation -> set_rules('cpassword_reg', 'Confirm Password', 'matches[password_reg]');
		$this->form_validation->set_error_delimiters('<p class="text-danger">', '</p>');
		// submit
		if ($this -> form_validation -> run() == FALSE)
		{
			// fails
			foreach ($_POST as $key => $value) 
                {
                    $data['messages'][$key] = form_error($key);
                }               
                echo json_encode($data);
		}
		else
		{
			$data = array(
                        'FIRST_NAME' => $this -> input -> post('fname_reg'), 
                        'EMAIL_ID' => $this -> input -> post('email_reg'), 
                        'PASSWORD' => $this -> input -> post('password_reg'),
                        'EMAIL_VERIFY_TOKEN' => $this->emailToken(),
                        'USER_TYPE_ID' => '3'
            			);


			$newUserId = $this -> User_model -> add_user_mstr($data);
            if ($this->db->trans_status() === FALSE)
            {
                    $this->db->trans_rollback();
                    //redirect('Signup');
                    $data['messages']['msg'] = '<div class="alert alert-danger text-center">Oops! Something went wrong. Please try again</div>';
                    echo json_encode($data);
                    
            }
            else
            {
                    $this->db->trans_commit();
                    // redirect('Signup');
                    $sess_data = array('login' => TRUE, 
                                        'uname' => $this -> input -> post('fname'),
                                        'uid' => $newUserId,
                                        'emailid' => $this -> input -> post('email'),
                                        'usertypeid'=>'3',
                                        'uimage'=>'resources/img/blank_user.png'
                                        );
                    $this->session->set_userdata($sess_data);
                    // $this->session->mark_as_temp('login', 300);
                    //echo $this->db->last_query();
                    // redirect("login");
                    $data['success'] = true;
                    echo json_encode($data);
            }
		}
	}

	function select_validate($selectValue)
	{
		// 'none' is the first option and the text says something like "-Choose one-"
		if (empty($selectValue))
		{
			$this -> form_validation -> set_message('select_validate', 'Please Select.');
			return false;
		}
		else// user picked something
		{
			return true;
		}
	}
    function CCode_valid($clientcode)
    {
        if (empty($clientcode))
        {
            $this -> form_validation -> set_message('CCode_valid', 'The Client Code field is required.');
            return false;
        }
        else 
        {
            $data = $this -> User_model -> checkClientCodeForUserRegister($clientcode);
            if (empty($data))
            {
                $this -> form_validation -> set_message('CCode_valid', 'Not a Valid Client Code.');
                return false;
            }
            else// user picked something
            {
                return true;
            }
        }
        
    }

    function sendmail($toemail,$userfullname,$userid,$passwd)
    {
        $this->load->library('email'); // load email library
        $this->email->from(supportMailId);
        $this->email->to($toemail);
        $this->email->cc(''); 
        $this->email->subject('STRATUP Account Verification');
        $this->email->message('<p><span style="font-family:Arial,Helvetica,sans-serif">Hello '.$userfullname.',</span></p>

                                <p>Thank you for registering with STRATUP. Your account is created and must be activated before you can use it.</br>
								To activate the account <a href="'.base_url().'index.php/Signup/verifyEmail?loginId='.$userid.'&hash='.$passwd.'">Click Here</a> or copy-paste the below link in your browser:</p>

                                <p>'.base_url().'index.php/Signup/verifyEmail?loginId='.$userid.'&hash='.$passwd.'</p>

                                <p>After activation you may login using the following username:
                                
                                <p>Your Login ID : '.$userid.'</p>
                                
                                
                                <p>&nbsp;</p>
                                
                                <p>Thanks,</p>
                                
                                <p>Team Processbee</p>');
        // $this->email->attach('/path/to/file1.png'); // attach file
        // $this->email->attach('/path/to/file2.pdf');
        if ($this->email->send())
        {
            //$this->session->set_flashdata('msg', '<div class="alert alert-success text-center"> We have sent your Login Credential to your e-MailID <br /> Please <a href="'.base_url().'"/login/index.php">Click Here</a> to Login</div>');
            //echo "Mail Sent!";
        }
        else
        {
            // $this->session->set_flashdata('msg', '<div class="alert alert-success text-center">We cant find your email address</div>');
            show_error($this->email->print_debugger());
        }
            
    }
    function generate_key_string($char,$segment) 
    {
        // Modified by : Leela
        // Modified on : 26-02-2018
        // function to create random String
        $tokens = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
        
        // $segment_chars = 8;
        // $num_segments = 1;
        $segment_chars = $char;
        $num_segments = $segment;
        $key_string = '';
        for ($i = 0; $i < $num_segments; $i++) 
        {
            $segment = '';
            for ($j = 0; $j < $segment_chars; $j++) 
            {
                $segment .= $tokens[rand(0, strlen($tokens)-1)];
            }
            $key_string .= $segment;

             if ($i < ($num_segments - 1)) 
             {
                 $key_string .= '-';
             }
        }
        return $key_string;
    }
    function emailToken()
    {
        // function to check duplicate token
        do
        {
            $emailToken = $this -> generate_key_string(16,1);
            $result = $this -> User_model -> getEmailToken($emailToken);
        }
        while ($result != false);
        return $emailToken;
    }
    function verifyEmail()
    {
        $loginId = $_GET['loginId'];
        $token = $_GET['hash'];

        // function to verify new user and update Email Verified
         $data = $this->User_model->verifyEmailToken($loginId,$token);
         if(!$data)
         {
             $this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Email Verification Failed. Please ensure the link you have entered is correct. </div>');
             $this -> load -> view('message_view');
         }
         else  
         {
             if($data[0]['EMAIL_VERIFIED']==1)
             {
                 $this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Email has been verified successfully.</br> <a href="'.base_url().'">Click Here to Login</a></div>');
                 $this -> load -> view('message_view');
             }
             else 
             {
                 $this->User_model->upateVerifiedUser($data[0]['USER_ID']);
                 $this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Email has been verified successfully.</br> <a href="'.base_url().'">Click Here to Login</a></div>');
                 $this -> load -> view('message_view');
             }
             
         }
    }

}
