<?php
include (APPPATH . 'libraries/REST_Controller.php');
class DialogueService extends REST_Controller
{
		public function __construct() {
		parent::__construct();
		$this -> load -> model('Dialogueservice_model');
		}

	function computerStatements_get()
	{
		$this -> load -> model('Dialogueservice_model');
		$data = $this -> Dialogueservice_model -> getComputerStatements();
		$this -> response(json_decode(json_encode($data),true), 200);
	}
	
	function insertComputerStatements_get()
	{
		$statement = $this -> get('statement');
		$this -> load -> model('Dialogueservice_model');
		$data = $this -> Dialogueservice_model -> insertComputerStatements($statement);
		$this -> response("SUCCESS", 200);
	}
	
	function updateComputerStatements_get()
	{
		$statement = $this -> get('statement');
		$stmtcode = $this -> get('stmtcode');
		$this -> load -> model('Dialogueservice_model');
		$data = $this -> Dialogueservice_model -> updateComputerStatements($statement,$stmtcode);
		$this -> response("SUCCESS", 200);
	}
	
	function getCompPlayStatementsForTrigger_get()
	{
		$compstmtcode = $this -> get('compstmtcode');
		$this -> load -> model('Dialogueservice_model');
		$data = $this -> Dialogueservice_model -> getCompPlayStatementsForTrigger($compstmtcode);
		$this -> response($data, 200);
	}
	
	private function formatJsonToSql($categories)
	{	
		(array) $responsedata = (array) json_decode($categories);
		$in = "";
        $i=0;
        foreach ($responsedata as $condition)
        {
            if ($i!=0)
			{
				$in = $in.",";
			}
            $in = $in.$condition;
            $i++;
        }
		
		return $in;
	}
	
	function categorywiseCondnCompStmtsForPlayer_get()
	{
		//For Training List
		//$categories = '{"1":"GAME=STRATUP","2":"ROLE=HR","3":"MOVE_NO<35"}';
		$categories = $this -> get('categories');
        $this -> load -> model('Dialogueservice_model');
		$in = $this-> formatJsonToSql($categories);
        $data = $this -> Dialogueservice_model -> categorywiseCondnCompStmtsForPlayer($in);
		$compplaystmtsarray[] = '';
		if(empty($data))
		{
			$compplaystmtsarray = array();
		}
		else
		{
			foreach ($data as $compstmtcode)
	        {
	            $compplaystmts = $this -> Dialogueservice_model -> getCompPlayStatementsForTrigger($compstmtcode -> COMP_STMT_CODE);
				if ($compplaystmtsarray [0] == '')
				{
					$compplaystmtsarray = $compplaystmts;
				}
				else
				{
					foreach ($compplaystmts as $row) 
					{
						array_push($compplaystmtsarray,$row);
					}
				}
	        }
		}
        
        $this -> response($compplaystmtsarray, 200);
	}
	
	function getCompStmtsForGame_get()
	{
		//$categories = '{"1":"GAME=STRATUP","2":"ROLE=HR","3":"MOVE_NO<35"}';
		//$mode	= 'SUMMARY'; (Applicable Values - SUMMARY / DETAIL);
		//$status	= 'PENDING'; (Applicable Values - COMPLETED / PENDING);
		//$compStmtType = 'CONV'; (Applicable Values - CONV / TASK / EMAIL / IMAG/VIDEO);
		$categories = $this -> get('categories');
		$mode = $this -> get('mode');
		$status = $this -> get('status');
		$ugsStatusId = $this -> get('ugsStatusId');
		$compStmtType = $this -> get('compStmtType');
		$in = $this -> formatJsonToSql($categories);		
        $this -> load -> model('Dialogueservice_model');
        $data = $this -> Dialogueservice_model -> getCompStmtsForGame($in,$mode,$status,$ugsStatusId,$compStmtType);
        $this -> response($data, 200);
	}
	
	function answerwiseCompStmtsForPlayer_get()
	{
		$answer = $this -> get('answer');		
		$this -> load -> model('Dialogueservice_model');
		$data = $this -> Dialogueservice_model -> answerwiseCompStmtsForPlayer($answer);		
		foreach ($data as $compstmtcode)
		{
			$compplaystmts =  $this -> Dialogueservice_model -> getCompPlayStatementsForTrigger($compstmtcode -> DESTN_COMP_STMT_CODE);
		}
		$this -> response($compplaystmts, 200);
	}
	
	function triggerEvent_get()
	{	
		$this -> load -> model('Dialogueservice_model');
		
		$compstmtcode = $this -> get('compstmtcode');
		$playstmtcode = $this -> get('playstmtcode');
		$ugsStatusId = $this -> get('ugsStatusId');
		$playEntry1 = $this -> get('playEntry1');	
		
		$compplaystmts = array();
		
		if ($playstmtcode == '')
		{
			if($playEntry1 != '')
			{
				//If user sends free text as response, just record the response
				$this -> Dialogueservice_model -> insertActions($compstmtcode, $playstmtcode, $ugsStatusId, $playEntry1);
			}
			else
			{
				//If this webservice is called for the first time
				$compplaystmts = $this -> Dialogueservice_model -> getCompPlayStatementsForTrigger($compstmtcode);
			}	
		}
		else
		{
			//If $playstmtcode is not empty
			$stmtcode = $this -> Dialogueservice_model -> answerwiseCompStmtsForPlayer($playstmtcode);
			$data = $this -> Dialogueservice_model -> insertActions($compstmtcode, $playstmtcode, $ugsStatusId, $playEntry1);
			$this -> calculatePoints($playstmtcode,$ugsStatusId);
			$compplaystmts = $this -> Dialogueservice_model -> getCompPlayStatementsForTrigger($stmtcode[0] -> DESTN_COMP_STMT_CODE);	
		}
		$this -> response($compplaystmts, 200);
	}
	
	function descwiseCompStmtsForPlayer_get()
	{
		//To get Destination Computer Statement Codes a given question and predefined answer desc
		//For Invoking ask shireen from Training List
		$compstmtcode = $this -> get('compstmtcode');		
		$answerdesc = $this -> get('answerdesc');		
		$this -> load -> model('Dialogueservice_model');
		$data = $this -> Dialogueservice_model -> descwiseCompStmtsForPlayer($compstmtcode,$answerdesc);		
		$compplaystmts = '';
		foreach ($data as $compstmtcode)
		{
			$compplaystmts =  $this -> Dialogueservice_model -> getCompPlayStatementsForTrigger($compstmtcode -> DESTN_COMP_STMT_CODE);
		}
		$this -> response($compplaystmts, 200);
	}
	
	
	function insertActions_get()
	{
		//For Training List. When and action is completed, insert in to this table
		$compstatement = $this -> get('compstatement');		
		$playstatement = $this -> get('playstatement');			
		$ugsStatusId = $this -> get('ugsStatusId');				
		$playEntry1 = $this -> get('playEntry1');	
		$this -> load -> model('Dialogueservice_model');
		$data = $this -> Dialogueservice_model -> insertActions($compstatement,$playstatement,$ugsStatusId,$playEntry1);
		$this -> response("SUCCESS", 200);
	}
	
	function calculatePoints_get()
	{
		$answer = $this -> get('answer');			
		$ugsStatusId = $this -> get('ugsStatusId');			
		$this -> load -> model('Dialogueservice_model');
		$this -> calculatePoints($answer,$ugsStatusId);
		$this -> response($data, 200);		
	}
	
	private function calculatePoints($playstmtcode,$ugsStatusId)
	{
		//If first point for the current game then insert else update existing points data
		$isPoints = $this -> Dialogueservice_model -> isPointsInitiated($playstmtcode,$ugsStatusId);
		$isnewPoints = $isPoints [0] -> ISPOINTS;
		if ($isnewPoints  == "FALSE")
			$data = $this -> Dialogueservice_model -> insertPoints($playstmtcode,$ugsStatusId);
		else
			$data = $this -> Dialogueservice_model -> updatePoints($playstmtcode,$ugsStatusId);		
		return $data;
	}
	
	function getPlayerPointsForGame_get()
	{	
		$ugsStatusId = $this -> get('ugsStatusId');			
		$this -> load -> model('Dialogueservice_model');
		$data = $this -> Dialogueservice_model -> getPlayerPointsForGame($ugsStatusId);
		$this -> response($data, 200);
	}
	
	function getPointsForAnswer_get()
	{
		$answer = $this -> get('answer');				
		$this -> load -> model('Dialogueservice_model');
		$data = $this -> Dialogueservice_model -> getPointsForAnswer($answer);
		$this -> response($data, 200);
	}
	
	function getBotSuggestions_get()
	{
		$searchtext = $this -> get('searchtext');				
		$this -> load -> model('Dialogueservice_model');
		$data = $this -> Dialogueservice_model -> getBotSuggestions($searchtext);
		$this -> response($data, 200);
	}
	
	function getTimeAvailableForCurrentGame_get()
	{
		$ugsStatusId = $this -> get('ugsStatusId');				
		$this -> load -> model('Dialogueservice_model');
		$data = $this -> Dialogueservice_model -> getTimeAvailableForCurrentGame($ugsStatusId);
		$this -> response($data, 200);
	}
	
	function getStoryForUserGame_get()
	{
		// Provides a random story for a user game combination
		$gameId = $this -> get('gameId');				
		$userId = $this -> get('userId');
		$this -> load -> model('Dialogueservice_model');
		//$data = $this -> Dialogueservice_model -> getStoryForUserGame($gameId,$userId);
		$data = $this -> Dialogueservice_model -> getRandomStoryForGame($gameId);
		$this -> response($data, 200);
	}	
	
	function getStory_get()
	{
		$storyId = $this -> get('storyId');				
		$this -> load -> model('Dialogueservice_model');
		$data = $this -> Dialogueservice_model -> getStory($storyId);
		$this -> response($data, 200);
	}
	
	function getStoriesForGame_get()
	{
		$gameId = $this -> get('gameId');				
		$this -> load -> model('Dialogueservice_model');
		$data = $this -> Dialogueservice_model -> getStoriesForGame($gameId);
		$this -> response($data, 200);
	}
	
	function getStoriesForGameUser_get()
	{
		$gameId = $this -> get('gameId');				
		$userId = $this -> get('userId');			
		$paramdesc = $this -> get('paramdesc');			
		$this -> load -> model('Dialogueservice_model');
		$data = $this -> Dialogueservice_model -> getStoriesForGameUser($gameId,$paramdesc,$userId);
		$this -> response($data, 200);
	}
	
	function setUserGameStatus_get()
	{
		// For Invoking on New Game Initiation for a user
		$userId = $this -> get('userId');		
		$gsMapId = $this -> get('gsMapId');		
		$status	= $this -> get('status');		
		$this -> load -> model('Dialogueservice_model');
		
		$isGameNewDtls = $this -> Dialogueservice_model -> isGameStatusInitiated($userId,$gsMapId);
		foreach ($isGameNewDtls as $row) 
		{
			$isGameNew = $row -> ISGAME;;
		}
		if ($isGameNew == "FALSE")
		{
			$this -> Dialogueservice_model -> insertGameStatus($userId,$gsMapId);
			$data[0]['UGS_STATUS_ID'] = $this -> db -> insert_id();
		}
		else
		{
			$data = $this -> Dialogueservice_model -> updateGameStatus($userId,$gsMapId,$status);
		}
			
		$this -> response($data, 200);	
	}
	
	function getFiltersForGame_get()
	{
		// Provides Answer Filters for game
		$gameId = $this -> get('gameId');				
		$parentFilterId = $this -> get('parentFilterId');
		$filterType = $this -> get('filterType');
		$this -> load -> model('Dialogueservice_model');
		$data = $this -> Dialogueservice_model -> getFiltersForGame($gameId,$parentFilterId,$filterType);
		$this -> response($data, 200);
	}		
	
	function getPlayStmtsForGameFilter_get()
	{
		//$categories = '{"1":"GROUPED=1","2":"STANDALONE3=4","3":"MOVE_NO<35"}';
		$categories = $this -> get('categories');
        $this -> load -> model('Dialogueservice_model');
        $data = $this -> Dialogueservice_model -> getPlayStmtsForGameFilter($this -> formatJsonToSql($categories));
        $this -> response($data, 200);
	}
}
?>