<?php
include (APPPATH . 'libraries/REST_Controller.php');
class TriviaService extends REST_Controller
{
	public function __construct() {
		parent::__construct();
		$this -> load -> model('User_model');
	}

	function verifyUser_get()
	{
		//$userId = "INVALID USER";
		$loginId = $this -> get('loginId');
		if ($loginId == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Please Enter LoginID";
			$this -> response($data, 200);
		}
		if(!empty($loginId) && filter_var($loginId, FILTER_VALIDATE_EMAIL) === false) 
		{
		    $data["Success"] = "false";
			$data["ErrorMsg"] = "Email Id is not Valid";
			$this -> response($data, 200);
		}
		$password = $this -> get('password');
		if ($password == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Please Enter Password";
			$this -> response($data, 200);
		}
		// $workspace = $this -> get('workspace');
		// if($workspace == '')
		// {
		// 	$data["Success"] = "false";
		// 	$data["ErrorMsg"] = "Enter workspace";
		// 	$this -> response($data, 200);
		// }
		$data = array();
		
		$userDtls = $this -> User_model -> verifyUser($loginId);
		
		if (!empty($userDtls))
		{
			$userWorkspaceDetails = $this -> User_model -> getAllWorkspaceWithLockForUserId($userDtls[0]->USER_ID);
			//$randomNum = rand(1,20);

			// to setimages for workspace 
			
			$i=1; // used to define sufix with image name 
			foreach($userWorkspaceDetails as $workspace)
			{
				$image="PP".$i;
				$workspace->MEDIA_URL = ('resources/img/users/PlayerProfileIcons/'.$image.'.png');
				if($i == 20) 
				{
					// we have oly 20 images in specific folder 
					//Hence reseting "i" value to fetch from first image
					$i=0;
				}
				$i++;
			}
			foreach($userDtls as $user)
			{
				if($user->NICK_NAME == "")
				{
					$user->NICK_NAME = $user->PROFILE_NAME;
				}
			}
			$data['Success'] = "true";
			$data["UserDtls"] = $userDtls;
			$data['WORKSPACE_DETAILS'] = $userWorkspaceDetails;
		}
		else
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Invalid Login Credential";
		}
		$this -> response($data, 200);
	}
	public function select_database($database_schema)
	{
		//Created By : Ashwini
		//to save database schema name based on user into session.

	   // $your_dbs = array('2010', '2011');
	   // $db = $this->input->post('database');

	   // if( ! in_array($db, $your_dbs))
	   //     show_error('This database not exists');
		$this->session->set_userdata('selected_db', $database_schema);
		 // $errormgs = "";
		 //  $this->load->dbutil(); 
   //      if ($this->dbutil->database_exists($database_schema))
   //      {
   //      	$this->session->set_userdata('selected_db', $database_schema);
   //      	echo "exists";
   //          return $errormgs;
   //      }
   //      else
   //      {
   //          $errormgs= $database_schema." schema is not configured in database.php file.";
   //          echo $errormgs;
   //          return $errormgs;
   //      }
		
	    
	    //redirect('/');
	}
	function departments_get()
	{
		$this -> load -> model('Triviaservice_model');
		$data = $this -> Triviaservice_model -> getDepartments();
		$this -> response($data, 200);
	}
	
	function teamsfordepartment_get()
	{
		$departmentId = $this -> get('departmentId');
        $teamSearchText = $this -> get('teamSearchText');
		
		$this -> load -> model('Triviaservice_model');
		$data = $this -> Triviaservice_model -> getTeamsforDepartment($departmentId, $teamSearchText);
		$this -> response($data, 200);
	}

	function questionforplayer_get()
	{
		// Identify Player
		// Identify Player Difficulty Level	
		$userId = $this -> get('userId');
		$categoryId = $this -> get('categoryId');
		$ugsId = $this -> get('ugsId');
		$answerId = $this -> get('answerId');
		$difficultyId = 1;// $this -> get('difficultyId');

		$this -> load -> model('Triviaservice_model');
		// Getquestion for Player based on category and question not attempted
		$questiondata = $this -> Triviaservice_model -> getQuestionForPlayer($userId, $categoryId, $difficultyId);
		$qnId = $questiondata[0] -> QN_ID;
		// Get Options for the Question
		$optionsdata = $this -> Triviaservice_model -> getOptionsForQuestionId($qnId);
		// Update answer 
		// Calculate and store score of previous question
		// Update answered question list
		// Update Player Experience Level
		$lives=0;$gems=0;$coins=0;$levels=0;$streak=0;$beststreak=0;$powerup1=0;$powerup2=0;$powerup3=0;
		$this -> Triviaservice_model -> updateScore($lives,$gems,$coins,$levels,$streak,$beststreak,$powerup1,$powerup2,$powerup3,$userId);
		// Update Player status in Current Game
		$characters=0;$crowns=0;$roundno=0;$status='W';$turnstarttime=time();
		$this -> Triviaservice_model -> updateUgsData($characters,$crowns,$roundno,$status,$turnstarttime,$userId,$ugsId);
		$data['question'] = $questiondata;			
		$data['options'] = $optionsdata;

		$this -> response($data, 200);
	}

	function optionsForQuestion_get()
	{
	    $questionId =  $this -> get('questionId');
	    $this -> load -> model('Triviaservice_model');
		$data = $this -> Triviaservice_model -> getOptionsForQuestionId($questionId);
		$this -> response($data, 200);
	}
	
	function score_get()
	{
		$userId = $this -> get('userId'); 
		$this -> load -> model('Triviaservice_model');
		$data = $this -> Triviaservice_model -> getScore($userId);
		$this -> response($data, 200);
	}
	
	function chatsforgame_get()
	{
		$ugs_id = $this -> get('ugs_id');
		$this -> load -> model('Triviaservice_model');
		$data = $this -> Triviaservice_model -> getChatsForGame($ugs_id);
		$this -> response($data, 200);
	}
	
	function usergamelistfordisplay_get()
	{
		$userId = $this -> get('userId'); 
		$this -> load -> model('Triviaservice_model');
		$data = $this -> Triviaservice_model -> getUserGameListForDisplay($userId);
		$this -> response($data, 200);
	}
	
	function initiateGame_get()
	{
		// Values of parameter gameMode For Smart Match - RANDOM, Selected Friend - FRIEND, League Match - LEAGUE				
		$userId = $this -> get('userId'); 
		$gameMode = $this -> get('gameMode');
		$this -> load -> model('Triviaservice_model');
		if ($gameMode == "RANDOM")
		{
			$oppData = $this -> Triviaservice_model -> getPlayeratSameLevel($userId);
			$opponentUserId = $oppData[0] -> USER_ID;
		}
		else
				$opponentUserId = $this -> get('opponentUserId');
		$ugsId = $this -> Triviaservice_model -> insertUserGameStatus($gameMode);		
		$data = $this -> Triviaservice_model -> insertUserGameData($ugsId,'1',$userId,'P');
		$data = $this -> Triviaservice_model -> insertUserGameData($ugsId,'2',$opponentUserId,'N');
		$this -> response($ugsId, 200);		
	}

	function updateScore_get()
	{
		// Calculate Lives to add or reduce
		// Calculate Gems to add or reduce

		updateScore($userId,$lives,$gems,$coins,$levels,$streak,$beststreak,$powerup1,$powerup2,$powerup3);
	}
	function registerUser_get()
	{
		//Created by : Ashwini
		//for ABG removed registration
		//After the event need to revert
		// $data["Success"] = "false";
		// $data["ErrorMsg"] = "Registration is temporarily blocked. Please contact your HR.";
		// $this -> response($data, 200);

		// function to register new user
		$loginId = $this -> get('loginId');
		if ($loginId == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Please Enter LoginID";
			$this -> response($data, 200);
		}
		if(!empty($loginId) && filter_var($loginId, FILTER_VALIDATE_EMAIL) === false) 
		{
		    $data["Success"] = "false";
			$data["ErrorMsg"] = "Email Id is not Valid";
			$this -> response($data, 200);
		}
		$password = $this -> get('password');
		if ($password == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Please Enter Password";
			$this -> response($data, 200);
		}
		$fullName = $this -> get('fullName');
		if ($fullName == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Please Enter Full Name";
			$this -> response($data, 200);
		}
		$nickName = $this -> get('nickName');
		if ($nickName == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Please Enter Nick Name";
			$this -> response($data, 200);
		}
		$profileImage = $this -> get('profileImage');
		// if ($profileImage == '')
		// {
		// 	$data["Success"] = "false";
		// 	$data["ErrorMsg"] = "Please Select Profile Image";
		// 	$this -> response($data, 200);
		// }
		$data = array();

		$userDtls = $this -> User_model -> getUserByLoginId($loginId);
		if (count($userDtls)>0)
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "User Already Exists";
		}
		else
		{
			$randomNum = rand(1,20);
			//$imageName=array("PP","women");
			//$randomImageName=array_rand($imageName);
			
			//$image = $imageName[$randomImageName].$randomNum;
			if($profileImage =="")
			{
				$profileImage = 'resources/img/users/PlayerProfileIcons/'.$image.'.png';
			}
			else
			{
				$profileImage = 'resources/'.$profileImage.'.png';
			}			

			$image="PP".$randomNum;
			$params = array('LOGIN_ID' => $loginId,
							'PASSWORD' => $password,
							'FIRST_NAME' => $fullName,
							'NICK_NAME' => $nickName,
							'EMAIL_ID' => $loginId,
							'PROFILE_PIC_PATH' => $profileImage);

			$userId = $this -> User_model -> insertMstrUser($params);
			$defaultWorkspace = $this -> User_model -> getWorkspaceForClientByClientName("PROCESSBEE");
			foreach ($defaultWorkspace as $workspace) 
			{
				$userWorkspaceParam = array('USER_ID' => $userId,
											'WS_ID' => $workspace->WS_ID,
											'VALID_FROM' => $workspace->VALID_FROM,
											'VALID_TO' => $workspace->VALID_TO);
				$this -> User_model -> insertWorkspaceForUser($userWorkspaceParam);
			}
			$workspaceForUser = array_column($defaultWorkspace, 'WS_DESC');
			//$workspaceUrl = array();
			//for($i=0;$i<count($workspaceForUser);$i++)
			//{
			   $workspaceUrl = $workspaceForUser[0];  
			//}
			$workspaceName = array_column($defaultWorkspace, 'WS_NAME');
			$workspaceDtls = $this -> User_model -> getWorkspaceByName($workspaceName[0]);
			$this->select_database($workspaceDtls[0]->WS_SCHEMA);
			$userWorkspaceDetails = $this -> User_model -> getAllWorkspaceWithLockForUserId($userId);
			//$randomNum = rand(1,20);

			// to setimages for workspace 
			
			$i=1; // used to define sufix with image name 
			foreach($userWorkspaceDetails as $workspace)
			{
				$image="PP".$i;
				$workspace->MEDIA_URL = ('resources/img/users/PlayerProfileIcons/'.$image.'.png');
				if($i == 20) 
				{
					// we have oly 20 images in specific folder 
					//Hence reseting "i" value to fetch from first image
					$i=0;
				}
				$i++;
			}
			$this -> sendmail($loginId, $fullName, $workspaceForUser,'FALSE');
			$userDtls = $this -> User_model ->getUserDtlsById($userId);
			$data["Success"] = "true";
			$data["USER_ID"] = strval($userId); 
			$data["PROFILE_PIC"] = $userDtls[0]->PHOTO_PATH;
			$data["WORKSPACE_DETAILS"] = $userWorkspaceDetails;
		}
		$this -> response($data, 200);
	}

	function getRandomPlayerList_get()
	{
		//Created by : Ashwini
		//modified by : Leela
		// included Nick Name
		$userId = $this -> get('userId');
		if ($userId == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter UserID";
			$this -> response($data, 200);
		}
		$gameMode = $this -> get('gameMode');
		if($gameMode == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter gameMode";
			$this -> response($data, 200);
		}
		$workspace = $this -> get('workspace');
		if($workspace == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter workspace";
			$this -> response($data, 200);
		}

		$userWorkspaceDetails = $this -> User_model -> getWorkspaceForUserByUserId($userId);

		$i = 0;
		if(!in_array($workspace, array_column($userWorkspaceDetails, 'WS_DESC')))
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Workspace does not exist";
			$this -> response($data, 200);
		}
		
		$this -> defineTriviaSchema($workspace);
		$userRank = array();
		$this -> load -> model('Triviaservice_model');
		$leaderboard = $this -> Triviaservice_model -> getLeaderboardForGameMode($gameMode, $workspace);
		
		$rank = 0;
		$temp = 0;
		for ($i = 0; $i < count($leaderboard); $i++) 
		{
			if($leaderboard[$i]->POINTS!=$temp)
			{
				$rank++;
			}
			$leaderboard[$i]->RANK = strval($rank);
			$temp=$leaderboard[$i]->POINTS;
		}
		// $opponentUserId = array();
		// $checkRequestAlreadySent = $this -> Triviaservice_model -> checkRequestAlreadySentToOpponentran($userId);
		// foreach ($checkRequestAlreadySent as $row)
		// {
		// 	array_push($opponentUserId, $row -> USER_ID);
		// }
		// //$oppUserId = $this -> checkRequestAlreadySentToOpponent($userId, $opponentUserId);
		// $ids = join(',',$opponentUserId);
		
		$randomUserList = $this -> Triviaservice_model -> randomTenUsersExceptUserId($userId, $workspace);
		$i=0;
		$flag=false;
		$resultRandomList=array();
		foreach ($randomUserList as $random) 
		{
			$flag=false;
			foreach ($leaderboard as $value) 
			{
				if($value->USER_ID == $random->USER_ID)
				{
					$resultRandomList[$i]['USER_ID'] = $random->USER_ID;
					$resultRandomList[$i]['PROFILE_NAME'] = $random->PROFILE_NAME;
					$resultRandomList[$i]['PHOTO_PATH'] = $random->PHOTO_PATH;
					if($random->NICK_NAME == "")
					{
						$resultRandomList[$i]['NICK_NAME'] = $random->PROFILE_NAME;
					}
					else
					{
						$resultRandomList[$i]['NICK_NAME'] = $random->NICK_NAME;
					}
					$resultRandomList[$i]['POINTS'] = $value->POINTS;
					$resultRandomList[$i]['RANK'] = $value->RANK;
					$checkRequestAlreadySent = $this -> Triviaservice_model -> checkRequestAlreadySentToOpponent($userId, $random->USER_ID,$gameMode);
					if(count($checkRequestAlreadySent) > 0)
					{
						$resultRandomList[$i]['REQUEST_SENT'] = "YES";
					}
					else
					{
						$resultRandomList[$i]['REQUEST_SENT'] = "NO";
					}
					$i++;
					$flag=true;
				}
			}
			if($flag== false)
			{
				$resultRandomList[$i]['USER_ID'] = $random->USER_ID;
				$resultRandomList[$i]['PROFILE_NAME'] = $random->PROFILE_NAME;
				$resultRandomList[$i]['PHOTO_PATH'] = $random->PHOTO_PATH;
				if($random->NICK_NAME == "")
				{
					$resultRandomList[$i]['NICK_NAME'] = $random->PROFILE_NAME;
				}
				else
				{
					$resultRandomList[$i]['NICK_NAME'] = $random->NICK_NAME;
				}
				$resultRandomList[$i]['POINTS'] = strval(0);
				$resultRandomList[$i]['RANK'] = strval(0);
				$checkRequestAlreadySent = $this -> Triviaservice_model -> checkRequestAlreadySentToOpponent($userId, $random->USER_ID,$gameMode);
				if(count($checkRequestAlreadySent) > 0)
				{
					$resultRandomList[$i]['REQUEST_SENT'] = "YES";
				}
				else
				{
					$resultRandomList[$i]['REQUEST_SENT'] = "NO";
				}
				$i++;
			}
		}
		$data["Success"] = "true";
		$data["UserList"] = $resultRandomList;
		$this -> response($data, 200);
	}

	function searchPlayersForKey_get()
	{
		//Created by : Ashwini
		$userId = $this -> get('userId');
		if ($userId == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter userId";
			$this -> response($data, 200);
		}
		$gameMode = $this -> get('gameMode');
		if($gameMode == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter gameMode";
			$this -> response($data, 200);
		}
		$profileName = $this -> get('profileName');
		if($profileName == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter profileName";
			$this -> response($data, 200);
		}
		$workspace = $this -> get('workspace');
		if($workspace == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter workspace";
			$this -> response($data, 200);
		}
		$userWorkspaceDetails = $this -> User_model -> getWorkspaceForUserByUserId($userId);
		$i = 0;
		if(!in_array($workspace, array_column($userWorkspaceDetails, 'WS_DESC')))
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Workspace does not exist";
			$this -> response($data, 200);
		}
		$this -> defineTriviaSchema($workspace);
		
		$userRank = array();
		$this -> load -> model('Triviaservice_model');
		$leaderboard = $this -> Triviaservice_model -> getLeaderboardForGameMode($gameMode, $workspace);
		
		$rank = 0;
		$temp = 0;
		for ($i = 0; $i < count($leaderboard); $i++) 
		{
			if($leaderboard[$i]->POINTS!=$temp)
			{
				$rank++;
			}
			$leaderboard[$i]->RANK=strval($rank);
			$temp=$leaderboard[$i]->POINTS;
		}
		$searchlist = $this -> Triviaservice_model -> searchPlayersForLoginKey($userId, $profileName, $workspace);
		$i=0;
		$flag=false;
		$resultSeacrhList=array();
		foreach ($searchlist as $search) 
		{
			foreach ($leaderboard as $value) 
			{
				if($value->USER_ID == $search->USER_ID)
				{
					$resultSeacrhList[$i]['USER_ID'] = $search->USER_ID;
					$resultSeacrhList[$i]['PROFILE_NAME'] = $search->PROFILE_NAME;
					if($search->NICK_NAME == "")
					{
						$resultSeacrhList[$i]['NICK_NAME'] = $search->PROFILE_NAME;
					}
					else
					{
						$resultSeacrhList[$i]['NICK_NAME'] = $search->NICK_NAME;
					}
					
					$resultSeacrhList[$i]['PHOTO_PATH'] = $search->PHOTO_PATH;
					$resultSeacrhList[$i]['POINTS'] = $value->POINTS;
					$resultSeacrhList[$i]['RANK'] = $value->RANK;
					$checkRequestAlreadySent = $this -> Triviaservice_model -> checkRequestAlreadySentToOpponent($userId, $search->USER_ID,$gameMode);
					if(count($checkRequestAlreadySent) > 0)
					{
						$resultSeacrhList[$i]['REQUEST_SENT'] = "YES";
					}
					else
					{
						$resultSeacrhList[$i]['REQUEST_SENT'] = "NO";
					}
					$i++;
					$flag=true;
				}
			}
			if($flag== false)
			{
				$resultSeacrhList[$i]['USER_ID'] = $search->USER_ID;
				$resultSeacrhList[$i]['PROFILE_NAME'] = $search->PROFILE_NAME;
				if($search->NICK_NAME == "")
				{
					$resultSeacrhList[$i]['NICK_NAME'] = $search->PROFILE_NAME;
				}
				else
				{
					$resultSeacrhList[$i]['NICK_NAME'] = $search->NICK_NAME;
				}
				$resultSeacrhList[$i]['PHOTO_PATH'] = $search->PHOTO_PATH;
				$resultSeacrhList[$i]['POINTS'] = strval(0);
				$resultSeacrhList[$i]['RANK'] = strval(0);
				$checkRequestAlreadySent = $this -> Triviaservice_model -> checkRequestAlreadySentToOpponent($userId, $search->USER_ID,$gameMode);
				if(count($checkRequestAlreadySent) > 0)
				{
					$resultSeacrhList[$i]['REQUEST_SENT'] = "YES";
				}
				else
				{
					$resultSeacrhList[$i]['REQUEST_SENT'] = "NO";
				}
				$i++;
			}
		}
		if(count($resultSeacrhList) > 0)
		{
			$data["Success"] = "true";
			$data["UserList"] = $resultSeacrhList;
		}
		else
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "User Not Found";
		}
		$this -> response($data, 200);
	}

	function respondToGameRequest_get()
	{
		//Created by : Ashwini
		$userId = $this -> get('userId');
		if ($userId == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter userId";
			$this -> response($data, 200);
		}
		$ugsId = $this -> get('ugsId');
		if ($ugsId == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter ugsId";
			$this -> response($data, 200);
		}

		//status N = Waiting / Oppturn, P = Playing / Myturn, TR = To Respond, Q = Quit, W = Won, L = Lost
		$myStatus = 'P';
		//$oppStatus ='P';
		$score = 0;
		$this -> load -> model('Triviaservice_model');
		$userGameData = $this -> Triviaservice_model -> getUserGameDataForUgsId($ugsId);
		foreach($userGameData as $row)
		{
			if(($row -> USER_ID) != $userId)
			{
				$oppUserId = $row -> USER_ID;
			}
		}

		$respond = $this -> Triviaservice_model -> updateRespondToGameRequest($userId, $ugsId, $myStatus, $score);
		//$data = $this -> Triviaservice_model -> updateRespondToGameRequest($oppUserId, $ugsId, $oppStatus, $score);

		if($respond == true)
		{
			$respondData["Success"] = "true";
		}
		else
		{
			$respondData["Success"] = "false";
		}
		$this -> response($respondData, 200);
	}

	function getStreakAndAttemptsForAllCategories_get()
	{
		//Created by : Ashwini
		$userId = $this -> get('userId');
		if ($userId == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter userId";
			$this -> response($data, 200);
		}
		$this -> load -> model('Triviaservice_model');
		
		$data["Success"] = "true";
		$data["StreakDtls"] = $this -> Triviaservice_model -> getCategorywiseStreakandAttempt($userId);
		$this -> response($data, 200);
	}

	function getUserProfile_get()
	{
		//Created by : Ashwini
		$userId = $this -> get('userId');
		if ($userId == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter userId";
			$this -> response($data, 200);
		}
		$userDtls = $this -> User_model -> getUserDtlsById($userId);
		if(count($userDtls)>0)
		{
			$data["Success"] = "true";
			foreach($userDtls as $user)
			{
				if($user->NICK_NAME == "")
				{
					$user->NICK_NAME = $user->PROFILE_NAME;
				}
			}
			$data["UserDtls"] = $userDtls;
		}
		else
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "User does not exists";
		}
		
		$this -> response($data, 200);
	}

	function getLeaderBoard_get()
	{
		//Created by : Ashwini
		$this -> load -> model('Triviaservice_model');
		$leaderboard = $this -> Triviaservice_model -> getLeaderboard();
		$rank = 1;
		for ($i = 0; $i < count($leaderboard); $i++) 
		{
			$leaderboard[$i] -> RANK = $rank;
			$rank++;
		}
		$data["Success"] = "true";
		$data["LeaderBoard"] = $leaderboard;
		$this -> response($data, 200);
	}

	function selectOpponent_get()
	{
		//Created by : Ashwini
		$userId = $this -> get('userId');
		if ($userId == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter userId";
			$this -> response($data, 200);
		}
		$oppUserId = $this -> get('oppUserId');
	
		$gameMode = $this -> get('gameMode');
		if ($gameMode == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter gameMode";
			$this -> response($data, 200);
		}
		$workspace = $this -> get('workspace');
		if($workspace == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter workspace";
			$this -> response($data, 200);
		}
		$userWorkspaceDetails = $this -> User_model -> getWorkspaceForUserByUserId($userId);
		$i = 0;
		if(!in_array($workspace, array_column($userWorkspaceDetails, 'WS_DESC')))
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Workspace does not exist";
			$this -> response($data, 200);
		}
		
		$this -> defineTriviaSchema($workspace);
		$this -> load -> model('Triviaservice_model');

		//status N = Waiting / Oppturn, P = Playing / Myturn, TR = To Respond, Q = Quit, W = Won, L = Lost
		//gameSatus O = Ongoing, C = Completed
		$myStatus = 'P';
		$oppStatus = 'TR';
		$gameStatus = 'O';

		if($oppUserId == '')
		{
			$opponentUserId = array();
			
			$checkRequestAlreadySent = $this -> Triviaservice_model -> checkRequestAlreadySentToOpponentran($userId, $gameMode);
			foreach ($checkRequestAlreadySent as $row)
			{
				array_push($opponentUserId, $row -> USER_ID);
			}
			//$oppUserId = $this -> checkRequestAlreadySentToOpponent($userId, $opponentUserId);
			$ids = join(',',$opponentUserId);
			
			$randomUser = $this -> Triviaservice_model -> randomUsersExceptUserId($userId, $workspace, $ids);
			if(count($randomUser) > 0)
			{
				$oppUserId = $randomUser[0] -> USER_ID;
			}
			else
			{
				$respondData["Success"] = "false";
				$respondData["ErrorMsg"] = "Opponents not available. Please try again later.";
				$this -> response($respondData, 200);
			}
		}
		else
		{
			$checkRequestAlreadySent = $this -> Triviaservice_model -> checkRequestAlreadySentToOpponent($userId, $oppUserId, $gameMode);
			if(count($checkRequestAlreadySent) > 0)
			{
				$respondData["Success"] = "false";
				$respondData["ErrorMsg"] = "Request Already Sent";
				$this -> response($respondData, 200);
			}
		}
		$currdate = gmdate("Y-m-d H:i:s");
		$param = array('GAME_MODE' => $gameMode,
						'START_TIME' => $currdate,
						'STATUS' => $gameStatus);
		
		$ugsId = $this -> Triviaservice_model -> insertUserGameStatus($param);		
		$data = $this -> Triviaservice_model -> insertUserGameData($ugsId, '1', $userId, $myStatus);
		$data = $this -> Triviaservice_model -> insertUserGameData($ugsId, '2', $oppUserId, $oppStatus);

		$respondData["Success"] = "true";
		$respondData["OpponentDtls"] = $this -> User_model -> getUserById($oppUserId);
		$respondData["UGS_ID"] = strval($ugsId) ;

		$this -> response($respondData, 200);
	}

	function getUserCommonData_get()
	{
		//Created by : Ashwini
		//modifed by : Leela
		// included NICK_NAME
		$userId = $this -> get('userId');
		if ($userId == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter userId";
			$this -> response($data, 200);
		}
		$workspace = $this -> get('workspace');
		if($workspace == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter workspace";
			$this -> response($data, 200);
		}
		$userWorkspaceDetails = $this -> User_model -> getWorkspaceForUserByUserId($userId);
		$i = 0;
		if(!in_array($workspace, array_column($userWorkspaceDetails, 'WS_DESC')))
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Workspace does not exist";
			$this -> response($data, 200);
		}
		$this -> defineTriviaSchema($workspace);
		$this -> load -> model('Triviaservice_model');
		
		$responseData = array();

		$responseData["Success"] = "true";

		$scoreData = $this -> Triviaservice_model -> checkScoreExistsForUser($userId);
		if(count($scoreData)>0)
		{
			$score = $this -> Triviaservice_model -> getScore($userId);
			// $categoryStreak = $this -> Triviaservice_model ->getuserCategoryStatus($userId);
			// foreach ($categoryStreak as $row) 
			// {
			// 	$streak="CATEGORY".$row->QN_CATEGORY_ID."_STREAK";
			// 	$attempt="CATEGORY".$row->QN_CATEGORY_ID."_ATTEMPT";
			// 	$attemptOverTime="CATEGORY".$row->QN_CATEGORY_ID."_ATTEMPT_OVER_TIME";
			// 	$score[0]->$streak = $row->STREAK;
			// 	$score[0]->$attempt = $row->ATTEMPT;
			// 	$score[0]->$attemptOverTime = $row->ATTEMPT_OVER_TIME;
			// }
			$responseData['SCORE'] = $score;
		}
		else
		{
			$score = array("USER_ID" => $userId,
						"LIVES" => "0",
						"GEMS" => "0",
						"COINS" => "0",
						"LEVEL" => "1",
						"STREAK" => "0",
						"BEST_STREAK" => "0",
						"POINTS" => "0",
						"CROWNS" => "0");
			$scoreData[0] = (object)$score;
			// $allQuestionCategory = $this -> Triviaservice_model-> getAllQuestionCategory();
			// foreach ($allQuestionCategory as $row) 
			// {
			// 	$streak="CATEGORY".$row->QN_CATEGORY_ID."_STREAK";
			// 	$attempt="CATEGORY".$row->QN_CATEGORY_ID."_ATTEMPT";
			// 	$attemptOverTime="CATEGORY".$row->QN_CATEGORY_ID."_ATTEMPT_OVER_TIME";
			// 	$scoreData[0]->$streak = "0";
			// 	$scoreData[0]->$attempt = "0";
			// 	$scoreData[0]->$attemptOverTime = "0";
			// }
			$responseData['SCORE'] = $scoreData;
		}

		// Fetch Chat 
		// Need to change game_chat tbl and modify below code to fetch chat
		// $chatData = $this -> Triviaservice_model -> getChatsForGame($userId);
		// $responseData['CHAT'] = $chatData;
		
		// Fetch Notification
		
		$leagueStatus = $this -> Triviaservice_model -> getCurrentLeagueStatusAndEndTime();
		
		$currdate = $this -> User_model -> getCurrentTimeFromDatabase();
		$leagueDurationDtls = $this -> Triviaservice_model -> getPropertyDtlsForPropertyName("LEAGUE DURATION");
		if(count($leagueStatus) == 0)
		{
			$starttime = date('Y-m-d H:i:s', strtotime('+1 seconds', strtotime($currdate[0]->CurrentDate)));

			$endtime = date('Y-m-d H:i:s', strtotime('+'.$leagueDurationDtls[0]->PROPERTY_VALUE.' seconds', strtotime($starttime)));
			$param = array('START_TIME' => $starttime,
							'END_TIME' => $endtime,
							'STATUS' => 'A');
			$this -> Triviaservice_model -> insertLeagueStatus($param);
			$leagueStatus = $this -> Triviaservice_model -> getCurrentLeagueStatusAndEndTime();
		}
		//$leagueEndTime = new DateTime($leagueStatus[0]->END_TIME);
		//$currentDate = new DateTime($currdate[0]->CurrentDate);
		//var_dump(($leagueStatus[0]->END_TIME<$currdate[0]->CurrentDate));
		while($leagueStatus[0]->END_TIME < $currdate[0]->CurrentDate)
		{
			$this -> Triviaservice_model -> updateLeagueStatus($leagueStatus[0]->LGS_ID, 'I');

			$starttime = date('Y-m-d H:i:s', strtotime('+1 seconds', strtotime($leagueStatus[0]->END_TIME)));

			$endtime = date('Y-m-d H:i:s', strtotime('+'.$leagueDurationDtls[0]->PROPERTY_VALUE.' seconds', strtotime($starttime)));
			$param = array('START_TIME' => $starttime,
							'END_TIME' => $endtime,
							'STATUS' => 'A');
			$this -> Triviaservice_model -> insertLeagueStatus($param);
			$leagueStatus = $this -> Triviaservice_model -> getCurrentLeagueStatusAndEndTime();
		}
		$leaguePlayed = $this -> Triviaservice_model -> getLeaguePlayedIdsByUser($userId);
		$i=0;
		foreach ($leaguePlayed as $leaPlay) 
		{
			if($leaPlay->STATUS != "A")
			{
				$leagueLeaderboard = $this -> Triviaservice_model -> getLeaderBoardForLeagueById($leaPlay->LGS_ID);
				$rank = 0;
				$temp = 0;
				for ($i = 0; $i < count($leagueLeaderboard); $i++) 
				{
					if($leagueLeaderboard[$i]->COINS!=$temp)
					{
						$rank++;
					}
					$leagueLeaderboard[$i]->RANK=$rank;
					$temp=$leagueLeaderboard[$i]->COINS;
				}
				//To give Rewards for which League is Completed based on Rank 
				$rewardForLeague = $this -> Triviaservice_model -> getRewardForGameMode("LEAGUE");
				$firstRankSetForLeague = explode ("to", $rewardForLeague[0]->RANK);
				$firstRankSetFromRank = explode(" ", $firstRankSetForLeague[0]);
				$secondRankSetForLeague = explode ("to", $rewardForLeague[1]->RANK);
				$secondRankSetFromRank = explode(" ", $secondRankSetForLeague[0]);
				$thirdRankSetForLeague = explode ("to", $rewardForLeague[2]->RANK);
				$thirdRankSetFromRank = explode(" ", $thirdRankSetForLeague[0]);
				
				foreach ($leagueLeaderboard as $leader) 
				{
					if($leader->USER_ID == $userId)
					{
						if(($leader->RANK >= $firstRankSetFromRank[1]) && ($leader->RANK <= $firstRankSetForLeague[1]))
						{
							$coins = $rewardForLeague[0]->COINS;
							$gems = $rewardForLeague[0]->GEMS;
							//$this -> Triviaservice_model -> updateCoinsInUserScore($coins, $gems, $userId);

							//$ugsIdForLeague = $this -> Triviaservice_model -> getListOfUgsIdForLeagueIdAndUserID($userId, $leaPlay->LGS_ID);
							//foreach ($ugsIdForLeague as $ugsdata) 
							//{
								//$this -> Triviaservice_model -> updateLeagueRewardCollectedStatus($userId, $ugsdata->UGS_ID);
								$checkGameNotification = $this -> Triviaservice_model -> checkNotificationExists($userId, $leaPlay->LGS_ID);
								if(count($checkGameNotification)<=0)
								{
									$paramNotification = array('NOT_DESC' => "You Got reward for League",
														'NOT_TIME' => 1,
														'NOT_STATUS' => 'A',
														'LGS_ID' => $leaPlay->LGS_ID,
														'NOT_TYPE' => 'LEAGUE REWARD',
														'REWARD_COINS' => $coins,
														'REWARD_GEMS' => $gems);
									$notificationId = $this -> Triviaservice_model -> insertGameNotification($paramNotification);

									$paramUserNotif = array('USER_ID' => $userId,
															'NOT_ID' => $notificationId,
															'STATUS' => 'P');

									$this -> Triviaservice_model -> insertUserNotification($paramUserNotif);
								}
							//}
							
						}
						else if(($leader->RANK >= $secondRankSetFromRank[1]) && ($leader->RANK <= $secondRankSetForLeague[1]))
						{
							$coins = $rewardForLeague[1]->COINS;
							$gems = $rewardForLeague[1]->GEMS;
							//$this -> Triviaservice_model -> updateCoinsInUserScore($coins, $gems, $userId);

							//$ugsIdForLeague = $this -> Triviaservice_model -> getListOfUgsIdForLeagueIdAndUserID($userId, $leaPlay->LGS_ID);
							//foreach ($ugsIdForLeague as $ugsdata) 
							//{
								//$this -> Triviaservice_model -> updateLeagueRewardCollectedStatus($userId, $ugsdata->UGS_ID);
								$checkGameNotification = $this -> Triviaservice_model -> checkNotificationExists($userId, $leaPlay->LGS_ID);
								if(count($checkGameNotification)<=0)
								{
									$paramNotification = array('NOT_DESC' => "You Got reward for League",
															'NOT_TIME' => 1,
															'NOT_STATUS' => 'A',
															'LGS_ID' => $leaPlay->LGS_ID,
															'NOT_TYPE' => 'LEAGUE REWARD',
															'REWARD_COINS' => $coins,
															'REWARD_GEMS' => $gems);
									$notificationId = $this -> Triviaservice_model -> insertGameNotification($paramNotification);

									$paramUserNotif = array('USER_ID' => $userId,
																'NOT_ID' => $notificationId,
																'STATUS' => 'P');

									$this -> Triviaservice_model -> insertUserNotification($paramUserNotif);
								}
							//}
							
						}
						else if(($leader->RANK >= $thirdRankSetFromRank[1]) && ($leader->RANK <= $thirdRankSetForLeague[1]))
						{
							$coins = $rewardForLeague[2]->COINS;
							$gems = $rewardForLeague[2]->GEMS;
							//$this -> Triviaservice_model -> updateCoinsInUserScore($coins, $gems, $userId);

							//$ugsIdForLeague = $this -> Triviaservice_model -> getListOfUgsIdForLeagueIdAndUserID($userId, $leaPlay->LGS_ID);
							//foreach ($ugsIdForLeague as $ugsdata) 
							//{
								//$this -> Triviaservice_model -> updateLeagueRewardCollectedStatus($userId, $ugsdata->UGS_ID);
								$checkGameNotification = $this -> Triviaservice_model -> checkNotificationExists($userId, $leaPlay->LGS_ID);
								if(count($checkGameNotification)<=0)
								{
									$paramNotification = array('NOT_DESC' => "You Got reward for League",
															'NOT_TIME' => 1,
															'NOT_STATUS' => 'A',
															'LGS_ID' => $leaPlay->LGS_ID,
															'NOT_TYPE' => 'LEAGUE REWARD',
															'REWARD_COINS' => $coins,
															'REWARD_GEMS' => $gems);
									$notificationId = $this -> Triviaservice_model -> insertGameNotification($paramNotification);

									$paramUserNotif = array('USER_ID' => $userId,
																'NOT_ID' => $notificationId,
																'STATUS' => 'P');

									$this -> Triviaservice_model -> insertUserNotification($paramUserNotif);
								}
							//}
						}
					}
				}
			}
		}
		$notificationData = $this -> Triviaservice_model -> getNotificationForUser($userId);

		$responseData['NOTIFICATION'] = $notificationData;
		
		//Fetch Ongoing Game
		$onGoingGameData = array();
		$allGameData = $this -> Triviaservice_model -> getOnGoingGameForUser($userId);
		$currentLeague = $this -> Triviaservice_model -> getCurrentLeagueStatusAndEndTime();
		$i=0;
		foreach ($allGameData as $row) 
		{
			//To remove leagues which is completed from OnGoingGames
			$gameDataToUpdateLeague = $this -> Triviaservice_model -> getUserGameDataAndUserDataForUgsId($row -> UGS_ID);
			if(count($gameDataToUpdateLeague)>0)
			{
				if($gameDataToUpdateLeague[0] -> GAME_MODE == "LEAGUE" && $gameDataToUpdateLeague[0] -> START_TIME <= $currentLeague[0]->START_TIME )
				{
					$this -> Triviaservice_model -> updateStatusInUsergameStatus($row -> UGS_ID, 'C');
					$myData = $this -> Triviaservice_model -> getUserGameDataForUgsIdAndUserId($gameDataToUpdateLeague[0] -> USER_ID, $row -> UGS_ID);
					$oppData = $this -> Triviaservice_model -> getUserGameDataForUgsIdAndUserId($gameDataToUpdateLeague[1] -> USER_ID, $row -> UGS_ID);

					if($myData[0]->COINS > $oppData[0]->COINS)
					{
						$this -> Triviaservice_model -> updateRespondToGameRequest($gameDataToUpdateLeague[0] -> USER_ID, $row -> UGS_ID, 'W', '');
						$this -> Triviaservice_model -> updateRespondToGameRequest($gameDataToUpdateLeague[1] -> USER_ID, $row -> UGS_ID, 'L', '');
					}
					else if($myData[0]->COINS <= $oppData[0]->COINS)
					{
						$this -> Triviaservice_model -> updateRespondToGameRequest($gameDataToUpdateLeague[0] -> USER_ID, $row -> UGS_ID, 'L', '');
						$this -> Triviaservice_model -> updateRespondToGameRequest($gameDataToUpdateLeague[1] -> USER_ID, $row -> UGS_ID, 'W', '');
					}
				}
				else if($gameDataToUpdateLeague[0] -> GAME_MODE == "LEAGUE" && $gameDataToUpdateLeague[0] -> START_TIME >= $currentLeague[0]->END_TIME)
				{
					$this -> Triviaservice_model -> updateStatusInUsergameStatus($row -> UGS_ID, 'C');
					$myData = $this -> Triviaservice_model -> getUserGameDataForUgsIdAndUserId($gameDataToUpdateLeague[0] -> USER_ID, $row -> UGS_ID);
					$oppData = $this -> Triviaservice_model -> getUserGameDataForUgsIdAndUserId($gameDataToUpdateLeague[1] -> USER_ID, $row -> UGS_ID);

					if($myData[0]->COINS > $oppData[0]->COINS)
					{
						$this -> Triviaservice_model -> updateRespondToGameRequest($gameDataToUpdateLeague[0] -> USER_ID, $row -> UGS_ID, 'W', '');
						$this -> Triviaservice_model -> updateRespondToGameRequest($gameDataToUpdateLeague[1] -> USER_ID, $row -> UGS_ID, 'L', '');
					}
					else if($myData[0]->COINS <= $oppData[0]->COINS)
					{
						$this -> Triviaservice_model -> updateRespondToGameRequest($gameDataToUpdateLeague[0] -> USER_ID, $row -> UGS_ID, 'L', '');
						$this -> Triviaservice_model -> updateRespondToGameRequest($gameDataToUpdateLeague[1] -> USER_ID, $row -> UGS_ID, 'W', '');
					}
				}
			}
		}
		$gameData = $this -> Triviaservice_model -> getOnGoingGameForUser($userId);
		foreach ($gameData as $row) 
		{
			//To get OnGoingGames List
			$gameDataWithOpponentDtls = $this -> Triviaservice_model -> getUserGameDataAndUserDataForUgsId($row -> UGS_ID);
			if($gameDataWithOpponentDtls[0]->USER_ID!= $userId)
			{
				$temparray=$gameDataWithOpponentDtls[0];
				$gameDataWithOpponentDtls[0]=$gameDataWithOpponentDtls[1];
				$gameDataWithOpponentDtls[1]=$temparray;
			}
			if(count($gameDataWithOpponentDtls)>0)
			{
				$j=0;
				foreach ($gameDataWithOpponentDtls as $gameDtls) 
				{
					$onGoingGameData[$i]['UGS_ID'] = $gameDtls -> UGS_ID;
					
					$onGoingGameData[$i]['GAME_MODE'] = $gameDtls -> GAME_MODE;

					$pointsforGameModeAndLevel = $this -> Triviaservice_model -> getPointsForGameModeAndLevel($gameDtls -> GAME_MODE, $gameDtls -> LEVEL);
					if(count($pointsforGameModeAndLevel)<=0)
					{
						$data["Success"] = "false";
						$data["ErrorMsg"] = "GameMode or Level is not valid";
						$this -> response($data, 200);
					}
					$leaderboard = $this -> Triviaservice_model -> getLeaderboardForGameMode($gameDtls -> GAME_MODE, $workspace);
					$rank = 0;
					$temp = 0;
					for ($j = 0; $j < count($leaderboard); $j++) 
					{
						if($leaderboard[$j]->POINTS!=$temp)
						{
							$rank++;
						}
						$leaderboard[$j]->RANK = $rank;
						$temp=$leaderboard[$j]->POINTS;
					}
					foreach ($leaderboard as $leader) 
					{
						if($leader -> USER_ID == $userId)
						{
							$onGoingGameData[$i]['MY_RANK'] = strval($leader -> RANK);
						}
					}
	
					if( $gameDtls -> USER_ID != $userId)
					{
						$onGoingGameData[$i]['OPP_USER_ID'] = $gameDtls -> USER_ID;
						$onGoingGameData[$i]['OPP_LOGIN_ID'] = $gameDtls -> LOGIN_ID;
						$onGoingGameData[$i]['OPP_PROFILE_NAME'] = $gameDtls -> PROFILE_NAME;
						$onGoingGameData[$i]['OPP_NICK_NAME'] = $gameDtls -> NICK_NAME;
						$onGoingGameData[$i]['OPP_PHOTO_PATH'] = $gameDtls -> PHOTO_PATH;
						$onGoingGameData[$i]['ROUND_NO'] = strval(($gameDtls -> ROUND_NO)+1);
						foreach ($leaderboard as $leader) 
						{
							if($leader -> USER_ID == $gameDtls -> USER_ID)
							{
								//echo $gameDtls -> USER_ID;
								$onGoingGameData[$i]['OPP_RANK'] = strval($leader -> RANK);
							}
							else
							{
								$onGoingGameData[$i]['OPP_RANK'] = strval(0);
							}
						}
						$onGoingGameData[$i]['REWARD_COINS_FOR_EACH_QUESTION'] = $pointsforGameModeAndLevel[0]->COINS;	
					}
					else if( $gameDtls -> USER_ID == $userId)
					{
						$onGoingGameData[$i]['STATUS'] = $gameDtls -> STATUS;
					}					
				}
				$i++;
			}
		}
		$responseData['ONGOING_GAME'] = $onGoingGameData;
		$this -> response($responseData, 200);
	}

	function getLeagueLeaderBoard_get()
	{
		//Created by : Ashwini
		$this -> load -> model('Triviaservice_model');
		
		$leagueLeaderboard = $this -> Triviaservice_model -> getLeagueLeaderboard();
		$rank = 1;
		for ($i = 0; $i < count($leagueLeaderboard); $i++) 
		{
			$leagueLeaderboard[$i] -> RANK = $rank;
			$rank++;
		}
		$data["Success"] = "true";
		$data["LeagueLeaderboard"] = $leagueLeaderboard;
		$this -> response($data, 200);
	}

	function getBonusAndRewardForGameMode_get()
	{
		//Created by : Ashwini
		$gameMode = $this -> get('gameMode');
		if ($gameMode == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter gameMode";
			$this -> response($data, 200);
		}

		$userId = $this -> get('userId');
		if ($userId == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter userId";
			$this -> response($data, 400);
		}

		$level = $this -> get('level');
		if ($level == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter level";
			$this -> response($data, 200);
		}
		$workspace = $this -> get('workspace');
		if($workspace == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter workspace";
			$this -> response($data, 200);
		}
		$userWorkspaceDetails = $this -> User_model -> getWorkspaceForUserByUserId($userId);
		$i = 0;
		if(!in_array($workspace, array_column($userWorkspaceDetails, 'WS_DESC')))
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Workspace does not exist";
			$this -> response($data, 200);
		}
		$this -> defineTriviaSchema($workspace);

		$this -> load -> model('Triviaservice_model');
		
		$data["Success"] = "true";
		$data["REWARD_FOR_EACH_QUESTION"] = $this -> Triviaservice_model -> getPointsForGameModeAndLevel($gameMode, $level);
		$data["REWARD_FOR_GAME_MODE"] = $this -> Triviaservice_model -> getRewardForGameMode($gameMode);
		$timeForQuestion = $this -> Triviaservice_model -> getPropertyDtlsForPropertyName($gameMode.' QUESTION TIMER');
		
		if($gameMode == "LEAGUE")
		{
			// $timezone = 330;
   			// $currdate=date("Y-m-d H:i:s");
			// $timestampStart = strtotime($currdate) + ($timezone * 60);
   			// $currentDate = date("Y-m-d H:i:s", $timestampStart);
            $currdate = $this -> User_model -> getCurrentTimeFromDatabase();
			// $currentDate = new DateTime($currdate[0]->CurrentDate );
			// $currentDate->format('Y-m-d H:i:s');
			$leagueStatus = $this -> Triviaservice_model -> getCurrentLeagueStatusAndEndTime();
			$leagueDurationDtls = $this -> Triviaservice_model -> getPropertyDtlsForPropertyName("LEAGUE DURATION");
	
			if($leagueStatus[0]->LEAGUE_STATUS == 'COMPLETED' || $leagueStatus[0]->END_TIME < $currdate[0]->CurrentDate)
			{
				while($leagueStatus[0]->END_TIME < $currdate[0]->CurrentDate)
				{
					$this -> Triviaservice_model -> updateLeagueStatus($leagueStatus[0]->LGS_ID, 'I');

					$starttime = date('Y-m-d H:i:s', strtotime('+1 seconds', strtotime($leagueStatus[0]->END_TIME)));

					$endtime = date('Y-m-d H:i:s', strtotime('+'.$leagueDurationDtls[0]->PROPERTY_VALUE.' seconds', strtotime($starttime)));
					$param = array('START_TIME' => $starttime,
									'END_TIME' => $endtime,
									'STATUS' => 'A');
					$this -> Triviaservice_model -> insertLeagueStatus($param);
					$leagueStatus = $this -> Triviaservice_model -> getCurrentLeagueStatusAndEndTime();
				}
			}

			$data["GENERAL_INFO"] = $this -> Triviaservice_model -> getCurrentLeagueStatusAndEndTime();;
			$data["GENERAL_INFO"][0]->TIME_FOR_EACH_QUESTION = $timeForQuestion[0]->PROPERTY_VALUE;
		}
		else if($gameMode == "TRIVIATOPICS")
		{
			$streakCount = "";
			$attempts = "";
			$timeToResetAttempt = "";
			$attemptAndStreak = $this -> Triviaservice_model -> getPropertyMstrForTriviaTopics();
			$questionCategories = $this -> Triviaservice_model -> getAllQuestionCategory();
			foreach ($attemptAndStreak as $value) 
			{
			 	if($value->PROPERTY_NAME == "TRIVIATOPICS STREAK")
			 	{
			 		$streakCount = $value->PROPERTY_VALUE;
			 	}
			 	if($value->PROPERTY_NAME == "TRIVIATOPICS ATTEMPTS")
			 	{
			 		$attempts = $value->PROPERTY_VALUE;
			 	}
			 	if($value->PROPERTY_NAME == "TRIVIATOPICS TIME TO RESET ATTEMPT")
			 	{
			 		$timeToResetAttempt = $value->PROPERTY_VALUE;
			 	}
			}
			// $timezone = 330;
   			// $currdate=date("Y-m-d H:i:s");
			// $timestampStart = strtotime($currdate) + ($timezone * 60);
   			// $currentDate = date("Y-m-d H:i:s", $timestampStart);
			$currdate = $this -> User_model -> getCurrentTimeFromDatabase();
			//$currentDate = new DateTime($currdate[0]->CurrentDate );
			// $currentDate->format('Y-m-d H:i:s');
			$scoreDtls = $this -> Triviaservice_model -> checkScoreExistsForUser($userId);
			if(count($scoreDtls)>0)
			{
				$score = $this -> Triviaservice_model -> getScore($userId);
				$categoryStreak = $this -> Triviaservice_model ->getuserCategoryStatus($userId);
				if(count($categoryStreak)>0)
				{
					foreach ($categoryStreak as $row) 
					{
						$streak="CATEGORY".$row->QN_CATEGORY_ID."_STREAK";
						$attempt="CATEGORY".$row->QN_CATEGORY_ID."_ATTEMPT";
						$attemptOverTime="CATEGORY".$row->QN_CATEGORY_ID."_ATTEMPT_OVER_TIME";
						$score[0]->$streak = $row->STREAK;
						$score[0]->$attempt = $row->ATTEMPT;
						$score[0]->$attemptOverTime = $row->ATTEMPT_OVER_TIME;
					}
				}
				else
				{
					$allQuestionCategory = $this -> Triviaservice_model-> getAllQuestionCategory();
					foreach ($allQuestionCategory as $row) 
					{
						$streak="CATEGORY".$row->QN_CATEGORY_ID."_STREAK";
						$attempt="CATEGORY".$row->QN_CATEGORY_ID."_ATTEMPT";
						$attemptOverTime="CATEGORY".$row->QN_CATEGORY_ID."_ATTEMPT_OVER_TIME";
						$score[0]->$streak = "0";
						$score[0]->$attempt = "0";
						$score[0]->$attemptOverTime = "0";
					}
				}
				
				$remainingAttempt = $score;
			}
			else
			{
				$score = array("USER_ID" => $userId,
						"LIVES" => "0",
						"GEMS" => "0",
						"COINS" => "0",
						"LEVEL" => "1",
						"STREAK" => "0",
						"BEST_STREAK" => "0",
						"POINTS" => "0",
						"CROWNS" => "0");
				$scoreData[0] = (object)$score;
				$allQuestionCategory = $this -> Triviaservice_model-> getAllQuestionCategory();
				foreach ($allQuestionCategory as $row) 
				{
					$streak="CATEGORY".$row->QN_CATEGORY_ID."_STREAK";
					$catattempt="CATEGORY".$row->QN_CATEGORY_ID."_ATTEMPT";
					$attemptOverTime="CATEGORY".$row->QN_CATEGORY_ID."_ATTEMPT_OVER_TIME";
					$scoreData[0]->$streak = "0";
					$scoreData[0]->$catattempt = "0";
					$scoreData[0]->$attemptOverTime = "0";
				}
				$remainingAttempt = $scoreData;
			}
			//var_dump($remainingAttempt);
			$i = 0;
			$progressCount = 0;
			$rewardPoints = $this -> Triviaservice_model -> getPointsForGameModeAndLevel($gameMode, $level);
			$questionCateCount = 0;
			//To reset Attempt for TRIVIATOPICS after a given period of time which is there in propertymstr
			foreach($rewardPoints as $points)
			{
				foreach ($questionCategories as $category) 
				{
					$questions = $this -> Triviaservice_model ->getAllQuestionsByCategory($category->QN_CATEGORY_ID, $gameMode);
					if(count($questions)>0)
					{
						$catestreak="CATEGORY".$category->QN_CATEGORY_ID."_STREAK";
						$cateattempt="CATEGORY".$category->QN_CATEGORY_ID."_ATTEMPT";
						$attemptOverTime="CATEGORY".$category->QN_CATEGORY_ID."_ATTEMPT_OVER_TIME";

						$timeRemaining = strval(0);
						if($category->QN_CATEGORY == $points->QN_CATEGORY)
						{
							if($remainingAttempt[0]->$attemptOverTime > 0)
							{ 
								$timeToReset = new DateTime($remainingAttempt[0]->$attemptOverTime);
								$timeToReset->modify('+'.$timeToResetAttempt.' seconds');
								$newTimeToResetAttempt = $timeToReset->format('Y-m-d H:i:s');

								$newAttempt = new DateTime($newTimeToResetAttempt);

								$currTime = new DateTime($currdate[0]->CurrentDate);
								$currentDate = $currTime->format('Y-m-d H:i:s');
								
								if($currTime >= $newAttempt)
								{
									$this -> Triviaservice_model -> resetCategoryAttemptAndTime($userId, $category->QN_CATEGORY_ID);
									$categoryStreak = $this -> Triviaservice_model ->getuserCategoryStatus($userId);
									foreach ($categoryStreak as $row) 
									{
										$streak="CATEGORY".$row->QN_CATEGORY_ID."_STREAK";
										$attempt="CATEGORY".$row->QN_CATEGORY_ID."_ATTEMPT";
										$attemptOverTime="CATEGORY".$row->QN_CATEGORY_ID."_ATTEMPT_OVER_TIME";
										$score[0]->$streak = $row->STREAK;
										$score[0]->$attempt = $row->ATTEMPT;
										$score[0]->$attemptOverTime = $row->ATTEMPT_OVER_TIME;
									}
					
									$remainingAttempt = $score;
								}
								else
								{
									$seconds = strtotime($newTimeToResetAttempt) - strtotime($currentDate);
									//$days    = floor($seconds / 86400);
									//$hours   = floor(($seconds - ($days * 86400)) / 3600);
									//$minutes = floor(($seconds - ($days * 86400) - ($hours * 3600))/60);
									//$seconds = floor(($seconds - ($days * 86400) - ($hours * 3600) - ($minutes*60)));
									//$timeRemaining = $days.":".$hours.":".$minutes.":".$seconds;
									$timeRemaining = strval($seconds);
								}
							}
							$data["GENERAL_INFO"][$i]['STREAK_COUNT'] = $streakCount;
							$data["GENERAL_INFO"][$i]['ATTEMPTS'] = $attempts;
							$data["GENERAL_INFO"][$i]['CATEGORY'] = $category->QN_CATEGORY;
							$data["GENERAL_INFO"][$i]['CATEGORY_IMAGE'] = $category->QN_CATEGORY_MASCOT;
							$data["GENERAL_INFO"][$i]['REMAINING_ATTEMPT'] = strval($attempts - $remainingAttempt[0]->$cateattempt);
							$data["GENERAL_INFO"][$i]['REMAINING_TIME_TO_RESET_ATTEMPT'] = $timeRemaining;
							$data["GENERAL_INFO"][$i]["TIME_FOR_EACH_QUESTION"] = $timeForQuestion[0]->PROPERTY_VALUE;
							$data["GENERAL_INFO"][$i]["COINS"] = $points->COINS;
							$data["GENERAL_INFO"][$i]["GEMS"] = $points->GEMS;
							if($remainingAttempt[0]->$catestreak == $streakCount)
							{
								$progressCount += 1;
								$data["GENERAL_INFO"][$i]['CATEGORY_PROGRESS'] = 'COMPLETED';
							}
							else
							{
								$data["GENERAL_INFO"][$i]['CATEGORY_PROGRESS'] = 'PENDING';
							}
							$questionCateCount++; // to get count of questioncategory which has question count greater than zero
							$i++;
						}
					}
				} 
			}
			for($j = 0 ; $j < $i; $j++)
			{
				$data["GENERAL_INFO"][$j]['PROGRESS_PERCENTAGE'] = strval(round(($progressCount / $questionCateCount) * 100 ));
			}
		}
		else
		{
			$data["GENERAL_INFO"][0]["TIME_FOR_EACH_QUESTION"] = $timeForQuestion[0]->PROPERTY_VALUE;
		}
		
		$this -> response($data, 200);
	}

	function getQuestionandOptionsForCategoryLevelPlayerandGameMode_get()
	{
		//Created by : Ashwini
		$gameMode = $this -> get('gameMode');
		if ($gameMode == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter gameMode";
			$this -> response($data, 200);
		}

		if($gameMode != "GAMELETQUESTION")
		{
			$userId = $this -> get('userId');
			if ($userId == '')
			{
				$data["Success"] = "false";
				$data["ErrorMsg"] = "Enter userId";
				$this -> response($data, 200);
			}
			if($gameMode == "CLASSIC" || $gameMode == "LEAGUE")
			{
				$ugsId = $this -> get('ugsId');
				if ($ugsId == '')
				{
					$data["Success"] = "false";
					$data["ErrorMsg"] = "Enter ugsId";
					$this -> response($data, 200);
				}
			}
			if($gameMode != "TRIVIATHON")
			{
				$category = $this -> get('category');
				if ($category == '')
				{
					$data["Success"] = "false";
					$data["ErrorMsg"] = "Enter category";
					$this -> response($data, 200);
				}
			}
			if($gameMode == "TRIVIATHON")
			{
				$triviathonCoins = $this -> get('triviathonCoins');
				if ($triviathonCoins == '')
				{
					$data["Success"] = "false";
					$data["ErrorMsg"] = "Enter triviathonCoins";
					$this -> response($data, 200);
				}
			}
			$timeUp = $this -> get('timeUp');
			if ($timeUp == '')
			{
				$data["Success"] = "false";
				$data["ErrorMsg"] = "Enter timeUp";
				$this -> response($data, 200);
			}
		}
		else
		{
			$questionId = $this -> get('questionId');
		}
		$workspace = $this -> get('workspace');
		if($workspace == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter workspace";
			$this -> response($data, 200);
		}
		$userWorkspaceDetails = $this -> User_model -> getWorkspaceForUserByUserId($userId);
		$i = 0;
		if(!in_array($workspace, array_column($userWorkspaceDetails, 'WS_DESC')))
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Workspace does not exist";
			$this -> response($data, 200);
		}
		$this -> defineTriviaSchema($workspace);
		
		$workspaceDtls = $this -> User_model -> getWorkspaceByDesc($workspace);

		$answeredQuestionId = $this -> get('answeredQuestionId');
		$answer = $this -> get('answer');

		//need to remove this parameter 
		//For getting same question even after answering that question based on questionId
		$repeatquestionId = $this -> get('repeatquestionId');

		$answerArray = json_decode($answer, true);

		$responseData = array();
			
		$message = "";
		$incorrect = 0;
		$lastAttempt = 0;
		$gameStatus = "";
		$mileStone = "";
		$currentAndTotalRound = "";
		$attemptStatus = "";
		$beststreakStatus =  "FALSE";
		$currentScore = strval(0);
		$bonus = "";
		
		$this -> load -> model('Triviaservice_model');
		
		if(($answeredQuestionId != null && $answer != null))
		{
			$validateUserAnswer = $this -> validateUserAnswer($answeredQuestionId, $answerArray);
			$message = $validateUserAnswer['message'];
			$incorrect = $validateUserAnswer['incorrect'];
			$lastAttempt = $validateUserAnswer['lastAttempt'];

			if($gameMode != "GAMELETQUESTION")
			{
				if($timeUp == "TRUE")
				{
					$message = "INCORRECT";
					$incorrect = 1;
				}
				//To insert into user_question_faced tbl
				$attemptStatus = $this -> insertAttemptedQuestionStatus($userId, $answeredQuestionId, $validateUserAnswer, $gameMode);

				$questionDtls = $this -> Triviaservice_model -> getQuestionById($answeredQuestionId);
				$questionCategoryId = $questionDtls[0] -> QN_CATEGORY_ID;
				$questionLevel = $questionDtls[0] -> QN_DIFFICULTY_ID;

				$questionCategoryDtls = $this -> Triviaservice_model -> getQuestionCategoryById($questionCategoryId);
				$questionCategory = $questionCategoryDtls[0] -> QN_CATEGORY;

				$allQuestionCategory = $this -> Triviaservice_model -> getAllQuestionCategory();
				//To update Score in User_score tbl
				$coinsForQuestion = 0;
				$pointsDtls = $this -> Triviaservice_model -> getPointsForGameModeQuestionAndLevel($gameMode, $questionCategory, $questionLevel);
				$coinsForQuestion = $pointsDtls[0]->COINS;
				if($message == "CORRECT")
				{	
					$scoreDtls = $this -> Triviaservice_model -> checkScoreExistsForUser($userId);
					if(count($scoreDtls)>0)
					{
						//Score updation need to discuss for now it is commented
						$this -> Triviaservice_model -> updateScoreForUserId($userId);
						$categoryStreak = $this -> Triviaservice_model ->getuserCategoryStatus($userId);
						if(count($categoryStreak)<=0)
						{
							foreach($allQuestionCategory as $categories)
							{
								$Streakparams = array('USER_ID' => $userId,
												'QN_CATEGORY_ID' => $categories->QN_CATEGORY_ID,
												'STREAK' => 0,
												'ATTEMPT' => 0);
								$this -> Triviaservice_model -> insertUserCategoryStatus($Streakparams);
							}
						}
					}
					else
					{
						$Scoreparams = array('USER_ID' => $userId,
											'LIVES' => 10,
											'LEVEL' => 1,
											'POINTS' => 1);
						$this -> Triviaservice_model -> insertUserScore($Scoreparams);
						foreach($allQuestionCategory as $categories)
						{
							$Streakparams = array('USER_ID' => $userId,
											'QN_CATEGORY_ID' => $categories->QN_CATEGORY_ID,
											'STREAK' => 0,
											'ATTEMPT' => 0);
							$this -> Triviaservice_model -> insertUserCategoryStatus($Streakparams);
						}
					}
					
					$this -> Triviaservice_model -> updateCoinsInUserScore($coinsForQuestion, 0, $userId);
				}

				// if gameMode is Classic / League update Score and status in user_game_data tbl
				if($gameMode == "CLASSIC" || $gameMode == "LEAGUE")
				{
					$gameClassicLeagueDtls = $this -> updateScoreForClassicOrLeague($userId, $ugsId, $gameMode, $coinsForQuestion, $message);
					$gameStatus = $gameClassicLeagueDtls['gameStatus'];
					$currentAndTotalRound = $gameClassicLeagueDtls['currentAndTotalRound'];
					$currentScore = strval($gameClassicLeagueDtls['currentScore']);
					$mileStone = $gameClassicLeagueDtls['mileStone'];
				}

				// if gameMode is TriviaTopics update category streak and category attempt
				if($gameMode == "TRIVIATOPICS")
				{
					$triviatopicGames = $this -> updateStreakAndAttemptForTriviaTopic($userId, $questionCategoryId, $message, $gameMode, $coinsForQuestion);
					$currentScore = strval($triviatopicGames['currentScore']);
					$gameStatus = $triviatopicGames['gameStatus'];
				}
				// if gameMode is Triviathon update streak and best streak
				if($gameMode == "TRIVIATHON")
				{
					$trivithonGames = $this -> updateStreakForTriviathon($userId, $gameMode, $message, $triviathonCoins, $coinsForQuestion);
					$beststreakStatus =  $trivithonGames['streakStatus'];
					$currentScore = strval($trivithonGames['currentScore']);
					$bonus = strval($trivithonGames['rewardCoins']);
				}
			}
		}
		if($gameMode !="GAMELETQUESTION")
		{
			if($answeredQuestionId == null && $answer == null && $gameMode == "TRIVIATHON")
			{	
				$this -> Triviaservice_model -> resetStreakInUserScore($userId);
			}
			if($answeredQuestionId == null && $answer == null && ( $gameMode == "CLASSIC" || $gameMode == "LEAGUE"))
			{
				$roundProperty = $this -> Triviaservice_model -> getPropertyDtlsForPropertyName('ROUND');
				$userDataDtls = $this -> Triviaservice_model -> getUserGameDataForUgsIdAndUserId($userId, $ugsId);
				$roundCount = $userDataDtls[0]->ROUND_NO;
				$currentAndTotalRound = "ROUND ".($roundCount+1)."/".$roundProperty[0]->PROPERTY_VALUE;
			}
			
			$scoreforUser = $this -> Triviaservice_model -> checkScoreExistsForUser($userId);
			if(count($scoreforUser)>0)
			{
				$score = $this -> Triviaservice_model -> getScore($userId);
				// $categoryStreak = $this -> Triviaservice_model ->getuserCategoryStatus($userId);
				// foreach ($categoryStreak as $row) 
				// {
				// 	$streak="CATEGORY".$row->QN_CATEGORY_ID."_STREAK";
				// 	$attempt="CATEGORY".$row->QN_CATEGORY_ID."_ATTEMPT";
				// 	$attemptOverTime="CATEGORY".$row->QN_CATEGORY_ID."_ATTEMPT_OVER_TIME";
				// 	$score[0]->$streak = $row->STREAK;
				// 	$score[0]->$attempt = $row->ATTEMPT;
				// 	$score[0]->$attemptOverTime = $row->ATTEMPT_OVER_TIME;
				// }
				$scoreData = $score;
			}
			else
			{
				$score = array("USER_ID" => $userId,
							"LIVES" => "0",
							"GEMS" => "0",
							"COINS" => "0",
							"LEVEL" => "1",
							"STREAK" => "0",
							"BEST_STREAK" => "0",
							"POINTS" => "0",
							"CROWNS" => "0");
				$scoreDataDtls[0] = (object)$score;
				// $allQuestionCategory = $this -> Triviaservice_model-> getAllQuestionCategory();
				// foreach ($allQuestionCategory as $row) 
				// {
				// 	$streak="CATEGORY".$row->QN_CATEGORY_ID."_STREAK";
				// 	$attempt="CATEGORY".$row->QN_CATEGORY_ID."_ATTEMPT";
				// 	$attemptOverTime="CATEGORY".$row->QN_CATEGORY_ID."_ATTEMPT_OVER_TIME";
				// 	$scoreDataDtls[0]->$streak = "0";
				// 	$scoreDataDtls[0]->$attempt = "0";
				// 	$scoreDataDtls[0]->$attemptOverTime = "0";
				// }
				$scoreData = $scoreDataDtls;
			}
			$level = $scoreData[0] -> LEVEL;

			if($repeatquestionId != Null)
			{
				$questionDtls = $this -> Triviaservice_model -> getQuestionById($repeatquestionId);
				if(count($questionDtls)>0)
				{
					$responseData['Success'] = "true";
					$responseData['SCORE'] = $scoreData;
					$responseData['QUESTION'] = $questionDtls;

					$optionsForQuestion = $this -> Triviaservice_model -> getOptionsForQuestionId($repeatquestionId);
					$optionSwitch = $this -> Triviaservice_model -> getPropertyDtlsForPropertyName('OPTION_ANSWER');
					if(($questionDtls[0]->GAME_MECHANIC) == "Scrambled_Words")
					{
						$srcambledoptions = str_split($optionsForQuestion[0]->OPT_ANSWER);
						$i=0;
						foreach($srcambledoptions as $row)
						{
							$options[$i]['OPT_ID'] = $optionsForQuestion[0]->OPT_ID;
							$options[$i]['OPT_ANSWER'] = $row;
							$options[$i]['OPT_ANSWER_SEQ_NO'] = strval($i+1);
							$i++;
						}
						$optionsForQuestion = $options;
					}
				
					if(($questionDtls[0]->GAME_MECHANIC) == "Drag_Answer_1")
					{
						$suffledOptions = $optionsForQuestion;
						shuffle($suffledOptions);
						$i=0;
						foreach($optionsForQuestion as $row)
						{
							$options[$i]['OPT_ID'] = $row->OPT_ID;
							$options[$i]['OPT_DESC'] = $row->OPT_DESC;
							$options[$i]['OPT_MEDIA_PATH'] = $row->OPT_MEDIA_PATH;
							$options[$i]['OPT_MEDIA_TYPE'] = $row->OPT_MEDIA_TYPE;
							$options[$i]['OPT_SEQ_NO'] = $row->OPT_SEQ_NO;
							$options[$i]['OPT_ANSWER'] = $suffledOptions[$i]->OPT_ANSWER;
							$options[$i]['OPT_ANS_MEDIA_PATH'] = $row->OPT_ANS_MEDIA_PATH;
							$options[$i]['OPT_ANSWER_MEDIA_TYPE'] = $row->OPT_ANSWER_MEDIA_TYPE;
							$options[$i]['OPT_ANSWER_SEQ_NO'] = $row->OPT_ANSWER_SEQ_NO;
							$i++;
						}
						$optionsForQuestion = $options;
					}
					else if((($questionDtls[0]->GAME_MECHANIC) == "MCQ") || (($questionDtls[0]->GAME_MECHANIC) == "MCQ-TF"))
					{
						foreach ($optionsForQuestion as $options) 
						{
							if($optionSwitch[0]->PROPERTY_VALUE == 0)
							{
								$options->OPT_ANSWER = "";
							}
						}
					}
					shuffle($optionsForQuestion);
					$responseData['OPTIONS'] = $optionsForQuestion;
				}	
				else
				{
					$responseData['Success'] = "false";
					$responseData['ErrorMsg'] = $repeatquestionId." question Id does not exists.";
					$this -> response($responseData, 200);
				}
			}
			else
			{				
				if($message != 'INCORRECT')
				{
					if($gameStatus == 'WON' || $gameStatus == 'LOST')
					{
						$responseData['Success'] = "true";
						$responseData['SCORE'] = $scoreData;
						$mileStone = 'COMPLETED';
					}
					else if($mileStone == 'COMPLETED')
					{
						$responseData['Success'] = "true";
						$responseData['SCORE'] = $scoreData;
					}
					else
					{
						$triviatopicStreakAchieved = false;
						$triviatopicStreak = $this -> Triviaservice_model -> getPropertyDtlsForPropertyName($gameMode.' STREAK');
						$streaksCount = $this -> Triviaservice_model -> getuserCategoryStatus($userId);
						if ($gameMode == "TRIVIATOPICS")
						{
							$categoryDtls = $this -> Triviaservice_model -> getQuestionCategoryByName($category);
							//$triviatopicStreakAchieved = false;
							foreach ($streaksCount as $streak) 
							{
								if($streak->QN_CATEGORY_ID == $categoryDtls[0]->QN_CATEGORY_ID)
								{
									if($triviatopicStreak[0]->PROPERTY_VALUE == $streak->STREAK)
									{
										$triviatopicStreakAchieved = true;
										break;
									}									
								}
							}
						}
						if($triviatopicStreakAchieved == true)
						{
							if($message == 'CORRECT')
							{
								$responseData['Success'] = "true";
								$responseData['SCORE'] = $scoreData;
								$mileStone = "COMPLETED";
							}
							else
							{
								$responseData['Success'] = "false";
								$responseData['ErrorMsg'] = "Streak of 10 is achieved";
								$this -> response($responseData, 200);
							}
						}
						else
						{
						//	$randomCategory = $this -> Triviaservice_model -> getRandomQuestionCategory();
							$randomCategory = $this-> getRandomCategory($gameMode);
							if($gameMode == 'TRIVIATHON')
							{
								//check if restrict question switch is enabled
								// if enabled compare if no. of question attempted in triviathon is less than the no. defined in property master
								$repeatQuestionSwitch = $this -> Triviaservice_model -> getPropertyDtlsForPropertyName('REPEAT QUESTION');

								//get no. of question that can be attempted in triviathon which includes previous attempt
								$totalDefinedQuestion = $this -> Triviaservice_model -> getPropertyDtlsForPropertyName('TRIVIATHON STREAK');

								//$scoreDetails = $this -> Triviaservice_model -> getScore($userId);
								$totalQuestionAteempted = $this -> Triviaservice_model -> getTotalQuestionsAttemptedForUserBasedonGameMode($userId, $gameMode);
								if($repeatQuestionSwitch[0]->PROPERTY_VALUE == 1)
								{
									if((int)($totalQuestionAteempted[0]->TOTAL_QUESTION_ATTEMPTED) < (int)($totalDefinedQuestion[0] -> PROPERTY_VALUE))
									{
										$questionOptionDtls = $this -> getQuestionandOption($userId, $randomCategory[0]->QN_CATEGORY, $level, $answeredQuestionId,$gameMode);
									}
									else
									{
										$responseData['Success'] = "true";
										$responseData['SCORE'] = $scoreData;
										$responseData['MESSAGE'] = $message;
										$responseData['GAMESTATUS'] = $gameStatus;
										$responseData['MILESTONE'] = $mileStone;
										$responseData['ROUND_DETAILS'] = $currentAndTotalRound;
										$responseData['BEST_STREAK_STATUS'] = $beststreakStatus;
										$responseData['CURRENT_COINS'] = $currentScore;
										$responseData['BONUS'] = $bonus;
										$responseData['TRIVIATHON_STREAK_STATUS'] = "TRUE";
										$this -> response($responseData, 200);
									}
								}
								else
								{
									$questionOptionDtls = $this -> getQuestionandOption($userId, $randomCategory[0]->QN_CATEGORY, $level, $answeredQuestionId,$gameMode);
								}
								
							}
							else
							{
								$questionOptionDtls = $this -> getQuestionandOption($userId, $category, $level, $answeredQuestionId,$gameMode);
							}
							
							if($questionOptionDtls['Success'] == "true")
							{
								$responseData['Success'] = "true";
								$responseData['SCORE'] = $scoreData;
								$responseData['QUESTION'] = $questionOptionDtls['questionForCategory'];
								$responseData['OPTIONS'] = $questionOptionDtls['optionsForQuestion'];
							}
							else
							{
								$responseData['Success'] = "false";
								$responseData['SCORE'] = $scoreData;
								$responseData['MESSAGE'] = $message;
								$responseData['GAMESTATUS'] = $gameStatus;
								$responseData['MILESTONE'] = $mileStone;
								$responseData['ROUND_DETAILS'] = $currentAndTotalRound;
								$responseData['BEST_STREAK_STATUS'] = $beststreakStatus;
								$responseData['CURRENT_COINS'] = $currentScore;
								$responseData['BONUS'] = $bonus;
								$responseData['TRIVIATHON_STREAK_STATUS'] = "";
								$responseData['ErrorMsg'] = "There is no question to answer.";
								$this -> response($responseData, 200);
							}

						}
					}
				}
				else
				{
					$responseData['Success'] = "true";
					$responseData['SCORE'] = $scoreData;
					$questionDtls = $this -> Triviaservice_model -> getQuestionById($answeredQuestionId);
					
					$responseData['QUESTION'] = $questionDtls;

					$optionsForQuestion = $this -> Triviaservice_model -> getOptionsForQuestionId($answeredQuestionId);
					$i = 0;
					if((($questionDtls[0] -> GAME_MECHANIC) == "MCQ") || (($questionDtls[0] -> GAME_MECHANIC) == "MCQ-TF"))
					{
						foreach ($answerArray['OPTION'] as $ans) 
						{
							foreach ($optionsForQuestion as $opt) 
							{
								if(($opt -> OPT_ID) == ($ans['OPT_ID']))
								{
									$option[$i]['OPT_ID'] = $opt -> OPT_ID;
									$option[$i]['OPT_DESC'] = $opt -> OPT_DESC;
									$option[$i]['OPT_MEDIA_PATH'] = $opt -> OPT_MEDIA_PATH;
									$option[$i]['OPT_MEDIA_TYPE'] = $opt -> OPT_MEDIA_TYPE;
									$option[$i]['OPT_SEQ_NO'] = $opt -> OPT_SEQ_NO;
									$option[$i]['OPT_ANSWER'] = $opt -> OPT_ANSWER;
									$option[$i]['OPT_ANS_MEDIA_PATH'] = $opt -> OPT_ANS_MEDIA_PATH;
									$option[$i]['OPT_ANSWER_MEDIA_TYPE'] = $opt -> OPT_ANSWER_MEDIA_TYPE;
									$option[$i]['OPT_ANSWER_SEQ_NO'] = $opt -> OPT_ANSWER_SEQ_NO;

									if(($ans['OPT_ANSWER']) == "Y")
									{
										$option[$i]['OPTION_SELECTED'] = "TRUE";
									}
									else
									{
										$option[$i]['OPTION_SELECTED'] = "FALSE";
									}
									$i++;
								}
							}
						}
						$responseData['OPTIONS'] = $option;
					}
					//shuffle($optionsForQuestion);
					
				}
			}
		}
		else
		{
			$responseData['Success'] = "true";
			//need to remove this condition
			$responseData['Message_For_Gamelet'] = $message;
			
			$questionDtls = $this -> Triviaservice_model -> getQuestionById($questionId);
			$responseData['QUESTION'] = $questionDtls;

			$optionsForQuestion = $this -> Triviaservice_model -> getOptionsForQuestionId($questionId);
			shuffle($optionsForQuestion);
			$responseData['OPTIONS'] = $optionsForQuestion;
		}
		$responseData['MESSAGE'] = $message;
		$responseData['GAMESTATUS'] = $gameStatus;
		$responseData['MILESTONE'] = $mileStone;
		$responseData['ROUND_DETAILS'] = $currentAndTotalRound;
		$responseData['BEST_STREAK_STATUS'] = $beststreakStatus;
		$responseData['CURRENT_COINS'] = $currentScore;
		$responseData['BONUS'] = $bonus;
		$responseData['TRIVIATHON_STREAK_STATUS']="";
		$this -> response($responseData, 200);
	}

	function validateUserAnswer($answeredQuestionId, $answer)
	{
		$message = "";
		$incorrect = 0;
		$lastAttempt = 0;
		$this -> load -> model('Triviaservice_model');
		$optionsDtls = $this -> Triviaservice_model -> getOptionsForQuestionId($answeredQuestionId);
		$questionDtls = $this -> Triviaservice_model -> getQuestionById($answeredQuestionId);
			//MCQ, Bubble Burst and Subcategory answer Type
		if((($questionDtls[0] -> GAME_MECHANIC) == "MCQ") || (($questionDtls[0] -> GAME_MECHANIC) == "Bubble_Burster") || (($questionDtls[0] -> GAME_MECHANIC) == "Drag_Answer_1") || (($questionDtls[0] -> GAME_MECHANIC) == "MCQ-TF"))
		{
			foreach ($answer['OPTION'] as $ans) 
			{
				foreach ($optionsDtls as $opt) 
				{
					if(($opt -> OPT_ID) == ($ans['OPT_ID']))
					{
						if(($opt -> OPT_ANSWER) == ($ans['OPT_ANSWER']))
						{
							$message = "CORRECT";
							$lastAttempt = 1;
						}
						else
						{
							$message = "INCORRECT";
							$incorrect = 1;
						}
					}
				}
				if($message == "INCORRECT")
				{
					break;
				}
			}
		}
		//Scrumbled Words
		else if((($questionDtls[0] -> GAME_MECHANIC) == "Scrambled_Words"))
		{
			foreach ($answer['OPTION'] as $ans) 
			{
				$optionsStringArray[($ans['OPT_ANSWER_SEQ_NO']-1)]=$ans['OPT_ANSWER'];
			}
			ksort($optionsStringArray);
			$answerString = join($optionsStringArray);
			
			if(strtoupper($optionsDtls[0]->OPT_ANSWER) == strtoupper($answerString))
			{
				$message = "CORRECT";
				$lastAttempt = 1;
			}
			else
			{
				$message = "INCORRECT";
				$incorrect = 1;
			}
		}
		//Drag Answer Type 2
		else if((($questionDtls[0] -> GAME_MECHANIC) == "Drag_Answer_2"))
		{
			//var_dump($answerArray);
			foreach ($answer['OPTION'] as $ans) 
			{
				$description = $ans['OPT_DESC'];
				$optionDescDetails = array_values(array_filter($optionsDtls, function ($var) use ($description)  {
             		return( ($var -> OPT_DESC == $description));
           		}));
				if(in_array($ans['OPT_ANSWER'], array_column($optionDescDetails, 'OPT_ANSWER')))
				{
					$message = "CORRECT";
					$lastAttempt = 1;
				}
				else
				{
					$message = "INCORRECT";
					$incorrect = 1;
				}
				if($message == "INCORRECT")
				{
					break;
				}
			}
		}
		//Drag Answer Type 3
		else if((($questionDtls[0] -> GAME_MECHANIC) == "Drag_Answer_3"))
		{
			foreach ($answer['OPTION'] as $ans) 
			{
				foreach ($optionsDtls as $opt) 
				{
					if(($opt -> OPT_DESC) == ($ans['OPT_DESC']))
					{
						if(($opt -> OPT_SEQ_NO) == ($ans['OPT_SEQ_NO']))
						{
							$message = "CORRECT";
							$lastAttempt = 1;
						}
						else
						{
							$message = "INCORRECT";
							$incorrect = 1;
						}
					}
				}
				if($message == "INCORRECT")
				{
					break;
				}
			}
		}
		//Drag Answer Type 4
		else if((($questionDtls[0] -> GAME_MECHANIC) == "Drag_Answer_4"))
		{
			foreach ($answer['OPTION'] as $ans) 
			{
				foreach ($optionsDtls as $opt) 
				{
					if(($opt -> OPT_ANSWER) == ($ans['OPT_ANSWER']))
					{
						if(($opt -> OPT_ANSWER_SEQ_NO) == ($ans['OPT_ANSWER_SEQ_NO']))
						{
							$message = "CORRECT";
							$lastAttempt = 1;
						}
						else
						{
							$message = "INCORRECT";
							$incorrect = 1;
						}
					}
				}
				if($message == "INCORRECT")
				{
					break;
				}
			}
		}
		return $validatedArray = array("message" => $message,
										"incorrect" => $incorrect,
										"lastAttempt" => $lastAttempt);
	}

	function insertAttemptedQuestionStatus($userId, $answeredQuestionId, $validateUserAnswer, $gameMode)
	{
		$this -> load -> model('Triviaservice_model');
		$currdate = $this -> User_model -> getCurrentTimeFromDatabase();
		$checkQuestionFaced = $this -> Triviaservice_model -> getUserQuestionFaced($userId, $answeredQuestionId);
		$param = array("USER_ID" => $userId,
					   "QN_ID" => $answeredQuestionId,
					   "ATTEMPTS" => 1,
					   "INCORRECT_ATTEMPTS" => $validateUserAnswer['incorrect'],
					   "LAST_ATTEMPT" => $validateUserAnswer['lastAttempt'],
					   "RESET_QUESTION_FLAG" => 1);	

		if(count($checkQuestionFaced) == 0)
		{
			$this -> Triviaservice_model -> insertUserQuestionFaced($param);
		}
		else
		{
			$this -> Triviaservice_model -> updateUserQuestionFacedForUserId($userId, $answeredQuestionId, $validateUserAnswer['incorrect'], $validateUserAnswer['lastAttempt']);
		}
		if($validateUserAnswer['message'] == "CORRECT")
		{
			$attemptStatus = "C";
		}
		else
		{
			$attemptStatus = "I";
		}
		$param2 = array("USER_ID" => $userId,
					   "QN_ID" => $answeredQuestionId,
					   "QN_ATTEMPTED_DATE" => $currdate[0]->CurrentDate,
					   "ATTEMPT_STATUS" => $attemptStatus,
					   "GAME_MODE" => $gameMode);
		$this -> Triviaservice_model -> insertUserDateWiseQuestionAttempt($param2);
		return $attemptStatus;
	}

	function updateScoreForClassicOrLeague($userId, $ugsId, $gameMode, $coinsForQuestion,$message)
	{
		$gameStatus = 'ONGOING';
		$currentScore = 0;
		$mileStone = "";
		$this -> load -> model('Triviaservice_model');

		//To get oppuserId by ugsId
		$userGameData = $this -> Triviaservice_model -> getUserGameDataForUgsId($ugsId);
		foreach($userGameData as $row)
		{
			if(($row -> USER_ID) != $userId)
			{
				$oppUserId = $row -> USER_ID;
			}
		}
		//To increase question count
		$this -> Triviaservice_model -> updateQuestionCountInUserGameData($userId, $ugsId);
		//$this -> Triviaservice_model -> updateQuestionCountInUserGameData($oppUserId, $ugsId);

		$userGameDataDtls = $this -> Triviaservice_model -> getUserGameDataForUgsIdAndUserId($userId, $ugsId);
		$questionCount = $userGameDataDtls[0]->QUESTION_COUNT;

		$questionProperty = $this -> Triviaservice_model -> getPropertyDtlsForPropertyName('QUESTION');

		if($questionCount == $questionProperty[0]->PROPERTY_VALUE)
		{
			//To reset questionCount and increase Round value
			$this -> Triviaservice_model -> updateRoundAndResetQuestionCnt($userId, $ugsId);
			//$this -> Triviaservice_model -> updateRoundAndResetQuestionCnt($oppUserId, $ugsId);
		}

		$roundProperty = $this -> Triviaservice_model -> getPropertyDtlsForPropertyName('ROUND');
		$userDataDtls = $this -> Triviaservice_model -> getUserGameDataForUgsIdAndUserId($userId, $ugsId);
		$roundCount = $userDataDtls[0]->ROUND_NO;
		$currentAndTotalRound = "ROUND ".($roundCount+1)."/".$roundProperty[0]->PROPERTY_VALUE;
		if($roundCount == $roundProperty[0]->PROPERTY_VALUE)
		{
			$gameStatus = 'COMPLETED';
		}
			
		$oppGameData = $this -> Triviaservice_model ->getUserGameDataForUgsIdAndUserId($oppUserId, $ugsId);
		if($message == "CORRECT")
		{
			//To update streak value for gamemode in UserGameData
			$this -> Triviaservice_model -> updateStreakAndCoinsInUserGameData($userId, $ugsId, $gameMode, $coinsForQuestion);
			$streakDtls = $this -> Triviaservice_model -> getUserGameDataForUgsIdAndUserId($userId, $ugsId);
			$streakname = $gameMode."_STREAK";
			$streakCount = $streakDtls[0]->$streakname;
			$currentScore = $streakCount * $coinsForQuestion;
			$streakProperty = $this -> Triviaservice_model -> getPropertyDtlsForPropertyName($gameMode.' STREAK');
			if($streakCount == $streakProperty[0]->PROPERTY_VALUE)
			{
				$mileStone = "COMPLETED";
				//To update Crown By 1
				$this -> Triviaservice_model -> updateCrownInUserGameData($userId, $ugsId);

				$myStatus = 'N';
				$oppStatus ='P';
				//To reset streak value for gamemode in UserGameData
				$this -> Triviaservice_model -> resetStreakInUserGameData($userId, $ugsId, $gameMode);
				$this -> Triviaservice_model -> updateRespondToGameRequest($userId, $ugsId, $myStatus, '');
							
				//if($oppGameData[0]->STATUS !='TR')
				//{
				$this -> Triviaservice_model -> updateRespondToGameRequest($oppUserId, $ugsId, $oppStatus, '');
				//}

				//Streak bonus for Classic and League is will come only when badges are added.
				// $bonusCoins = 0;
				// $bonusGems = 0;
				// $streakBonusProperty = $this -> Triviaservice_model -> getPropertyDtlsForPropertyName($gameMode.' STREAK BONUS');
				// foreach ($streakBonusProperty as $bonus) 
				// {
				// 	if($bonus->PROPERTY_DESC == "Coins")
				// 	{
				// 		$bonusCoins = $bonus->PROPERTY_VALUE;
				// 	}
				// 	if($bonus->PROPERTY_DESC == "Gems")
				// 	{
				// 		$bonusGems = $bonus->PROPERTY_VALUE;
				// 	}
				// }
				// //streak bonus
				// $this -> Triviaservice_model -> updateCoinsInUserScore($bonusCoins, $bonusGems, $userId);
			}
		}
		else
		{
			//status N = Waiting / Oppturn, P = Playing / Myturn, TR = To Respond, Q = Quit, W = Won, L = Lost
			$myStatus = 'N';
			$oppStatus ='P';

			$streakDtls = $this -> Triviaservice_model -> getUserGameDataForUgsIdAndUserId($userId, $ugsId);
			$streakname = $gameMode."_STREAK";
			$streakCount = $streakDtls[0]->$streakname;
			$currentScore = $streakCount * $coinsForQuestion;
			//To reset streak value for gamemode in UserGameData
			$this -> Triviaservice_model -> resetStreakInUserGameData($userId, $ugsId, $gameMode);

			$this -> Triviaservice_model -> updateRespondToGameRequest($userId, $ugsId, $myStatus, '');
			//if($oppGameData[0]->STATUS !='TR')
			//{
			$this -> Triviaservice_model -> updateRespondToGameRequest($oppUserId, $ugsId, $oppStatus, '');
			//}
		}
		if($gameStatus == 'COMPLETED')
		{
			//update game status as Completed in UserGameStatus
			$this -> Triviaservice_model -> updateStatusInUsergameStatus($ugsId, 'C');
			$myData = $this -> Triviaservice_model -> getUserGameDataForUgsIdAndUserId($userId, $ugsId);
			$oppData = $this -> Triviaservice_model -> getUserGameDataForUgsIdAndUserId($oppUserId, $ugsId);
			if($myData[0]->COINS > $oppData[0]->COINS)
			{
				$this -> Triviaservice_model -> updateRespondToGameRequest($userId, $ugsId, 'W', '');
				$this -> Triviaservice_model -> updateRespondToGameRequest($oppUserId, $ugsId, 'L', '');
			}
			else if($myData[0]->COINS < $oppData[0]->COINS)
			{
				$this -> Triviaservice_model -> updateRespondToGameRequest($userId, $ugsId, 'L', '');
				$this -> Triviaservice_model -> updateRespondToGameRequest($oppUserId, $ugsId, 'W', '');
			}
			else if($myData[0]->COINS == $oppData[0]->COINS)
			{
				$this -> Triviaservice_model -> updateRespondToGameRequest($userId, $ugsId, 'D', '');
				$this -> Triviaservice_model -> updateRespondToGameRequest($oppUserId, $ugsId, 'D', '');
			}
			$myStatusData = $this -> Triviaservice_model -> getUserGameDataForUgsIdAndUserId($userId, $ugsId);
			$oppStatusData = $this -> Triviaservice_model -> getUserGameDataForUgsIdAndUserId($oppUserId, $ugsId);
			// if($gameMode == 'CLASSIC')
			// {
			// 	$rewardDtls = $this -> Triviaservice_model -> getRewardForGameMode($gameMode);
			// 	$coins = $rewardDtls[0]->COINS;
			// 	$gems = $rewardDtls[0]->GEMS;
			// 	$this -> Triviaservice_model -> updateCoinsInUserScore($coins, $gems, $userId);
			// }
			if($myStatusData[0]->STATUS == 'W')
			{
				$notificationText = "Game Completed. You Won.";
			}
			else if($myStatusData[0]->STATUS == 'L')
			{
				$notificationText = "Game Completed. You Lost.";
			}
			else
			{
				$notificationText = "Game Completed. Its Draw.";
			}
			if($myStatusData[0]->STATUS == "W")
			{
		 		$gameStatus = "WON";
		 		$paramMyNotification = array('NOT_DESC' => "Game Completed. You Won",
											'NOT_TIME' => 1,
											'NOT_STATUS' => 'A',
											'NOT_TYPE' => 'CLASSIC GAMECOMPLETED',
											'REWARD_COINS' => 0,
											'REWARD_GEMS' => 0);
				$mynotificationId = $this -> Triviaservice_model -> insertGameNotification($paramMyNotification);

				$paramMyUserNotif = array('USER_ID' => $myStatusData[0]->USER_ID,
										'NOT_ID' => $mynotificationId,
										'STATUS' => 'P');

				$this -> Triviaservice_model -> insertUserNotification($paramMyUserNotif);

				$paramOppNotification = array('NOT_DESC' => "Game Completed. You Lost",
											'NOT_TIME' => 1,
											'NOT_STATUS' => 'A',
											'NOT_TYPE' => 'CLASSIC GAMECOMPLETED',
											'REWARD_COINS' => 0,
											'REWARD_GEMS' => 0);
				$mynotificationId = $this -> Triviaservice_model -> insertGameNotification($paramOppNotification);

				$paramOppUserNotif = array('USER_ID' => $oppStatusData[0]->USER_ID,
										'NOT_ID' => $mynotificationId,
										'STATUS' => 'P');

				$this -> Triviaservice_model -> insertUserNotification($paramOppUserNotif);
			}
			else if($oppStatusData[0]->STATUS == "W")
			{
				$gameStatus = "LOST";
				$paramMyNotification = array('NOT_DESC' => "Game Completed. You Lost",
											'NOT_TIME' => 1,
											'NOT_STATUS' => 'A',
											'NOT_TYPE' => 'CLASSIC GAMECOMPLETED',
											'REWARD_COINS' => 0,
											'REWARD_GEMS' => 0);
				$mynotificationId = $this -> Triviaservice_model -> insertGameNotification($paramMyNotification);

				$paramMyUserNotif = array('USER_ID' => $myStatusData[0]->USER_ID,
										'NOT_ID' => $mynotificationId,
										'STATUS' => 'P');

				$this -> Triviaservice_model -> insertUserNotification($paramMyUserNotif);

				$paramOppNotification = array('NOT_DESC' => "Game Completed. You Won",
											'NOT_TIME' => 1,
											'NOT_STATUS' => 'A',
											'NOT_TYPE' => 'CLASSIC GAMECOMPLETED',
											'REWARD_COINS' => 0,
											'REWARD_GEMS' => 0);
				$mynotificationId = $this -> Triviaservice_model -> insertGameNotification($paramOppNotification);

				$paramOppUserNotif = array('USER_ID' => $oppStatusData[0]->USER_ID,
										'NOT_ID' => $mynotificationId,
										'STATUS' => 'P');

				$this -> Triviaservice_model -> insertUserNotification($paramOppUserNotif);
			}
			else 
			{
				$gameStatus = "Draw";
				$paramMyNotification = array('NOT_DESC' => "Game Completed. Its Draw",
											'NOT_TIME' => 1,
											'NOT_STATUS' => 'A',
											'NOT_TYPE' => 'CLASSIC GAMECOMPLETED',
											'REWARD_COINS' => 0,
											'REWARD_GEMS' => 0);
				$mynotificationId = $this -> Triviaservice_model -> insertGameNotification($paramMyNotification);

				$paramMyUserNotif = array('USER_ID' => $myStatusData[0]->USER_ID,
										'NOT_ID' => $mynotificationId,
										'STATUS' => 'P');

				$this -> Triviaservice_model -> insertUserNotification($paramMyUserNotif);

				$paramOppNotification = array('NOT_DESC' => "Game Completed. Its Draw",
											'NOT_TIME' => 1,
											'NOT_STATUS' => 'A',
											'NOT_TYPE' => 'CLASSIC GAMECOMPLETED',
											'REWARD_COINS' => 0,
											'REWARD_GEMS' => 0);
				$mynotificationId = $this -> Triviaservice_model -> insertGameNotification($paramOppNotification);

				$paramOppUserNotif = array('USER_ID' => $oppStatusData[0]->USER_ID,
										'NOT_ID' => $mynotificationId,
										'STATUS' => 'P');

				$this -> Triviaservice_model -> insertUserNotification($paramOppUserNotif);
			}
		}
		return $gameClassicLeagueDtls = array("gameStatus" => $gameStatus,
												"currentAndTotalRound" => $currentAndTotalRound,
												"currentScore" => $currentScore,
												"mileStone" => $mileStone);
	}

	function updateStreakAndAttemptForTriviaTopic($userId, $questionCategoryId, $message, $gameMode, $coinsForQuestion)
	{
		$currentScore = 0;
		$gameStatus = "";
		$this -> load -> model('Triviaservice_model');
		$allQuestionCategory = $this -> Triviaservice_model -> getAllQuestionCategory();
		if($message == "CORRECT")
		{
			$update = $this -> Triviaservice_model -> updateCategoryStreak($userId, $questionCategoryId);
			$triviatopicProperty = $this -> Triviaservice_model -> getPropertyDtlsForPropertyName($gameMode.' STREAK');
			$streaksForCategory = $this -> Triviaservice_model -> getuserCategoryStatus($userId);
			//var_dump($streaksForCategory);
			$triviatopicStreakStatus = false;
			$streakCount = 0;
			foreach ($streaksForCategory as $categoryStreak) 
			{
				if($categoryStreak->STREAK == $triviatopicProperty[0]->PROPERTY_VALUE)
				{
					$triviatopicStreakStatus = true;
				}
				else
				{
					$triviatopicStreakStatus = false;
					break;
				}
			}
			if($triviatopicStreakStatus == true)
			{				
				$triviatopicsReward = $this -> Triviaservice_model -> getRewardForGameMode($gameMode);
				$paramNotification = array('NOT_DESC' => "You Got chest",
											'NOT_TIME' => 1,
											'NOT_STATUS' => 'A',
											'NOT_TYPE' => 'TRIVIATOPICS REWARD',
											'REWARD_COINS' => $triviatopicsReward[0]->COINS,
											'REWARD_GEMS' => $triviatopicsReward[0]->GEMS);
				$notificationId = $this -> Triviaservice_model -> insertGameNotification($paramNotification);

				$paramUserNotif = array('USER_ID' => $userId,
										'NOT_ID' => $notificationId,
										'STATUS' => 'P');

				$this -> Triviaservice_model -> insertUserNotification($paramUserNotif);
				
				//$this -> Triviaservice_model -> updateCoinsInUserScore($triviatopicsReward[0]->COINS, $triviatopicsReward[0]->GEMS, $userId);
				$gameStatus = "COMPLETED";
			}
			foreach ($streaksForCategory as $attempt) 
			{
				if($questionCategoryId == $attempt->QN_CATEGORY_ID)
				{
					$streakCount = $attempt->STREAK;
				}
			}
			//echo $streakCount;
			//echo $coinsForQuestion;
			$currentScore = $coinsForQuestion * $streakCount;
		}
		else if($message == "INCORRECT")
		{
			$triviatopicProperty = $this -> Triviaservice_model -> getPropertyDtlsForPropertyName($gameMode.' ATTEMPTS');
			$attemptDtls = $this -> Triviaservice_model -> checkScoreExistsForUser($userId);

			if(count($attemptDtls)>0)
			{
				$categoryStreak = $this -> Triviaservice_model ->getuserCategoryStatus($userId);
				if(count($categoryStreak)>0)
				{
					$remainingAttempt = $categoryStreak;
				}
				else
				{
					foreach($allQuestionCategory as $categories)
					{
						$Streakparams = array('USER_ID' => $userId,
												'QN_CATEGORY_ID' => $categories->QN_CATEGORY_ID,
												'STREAK' => 0,
												'ATTEMPT' => 0);
						$this -> Triviaservice_model -> insertUserCategoryStatus($Streakparams);
					}
					$remainingAttempt = $this -> Triviaservice_model -> getuserCategoryStatus($userId);
				}
			}
			else
			{
				$Scoreparams = array('USER_ID' => $userId,
									'LIVES' => 10,
									'LEVEL' => 1);
				$this -> Triviaservice_model -> insertUserScore($Scoreparams);
						
				foreach($allQuestionCategory as $categories)
				{
					$Streakparams = array('USER_ID' => $userId,
										'QN_CATEGORY_ID' => $categories->QN_CATEGORY_ID,
										'STREAK' => 0,
										'ATTEMPT' => 0);
					$this -> Triviaservice_model -> insertUserCategoryStatus($Streakparams);
				}
				$remainingAttempt = $this -> Triviaservice_model -> getuserCategoryStatus($userId);
			}
			//To update attempt by +1 
			foreach ($remainingAttempt as $attempt) 
			{
				if($questionCategoryId == $attempt->QN_CATEGORY_ID)
				{
					$streakCount = $attempt->STREAK;
					if($attempt->ATTEMPT_OVER_TIME == 0)
					{
						$this -> Triviaservice_model -> resetCategoryStreak($userId, $questionCategoryId);
					}
				}
			}

			$attemptsForCategory = $this -> Triviaservice_model -> getuserCategoryStatus($userId);
				
			foreach ($attemptsForCategory as $attempt) 
			{
				if($questionCategoryId == $attempt->QN_CATEGORY_ID)
				{
					if($triviatopicProperty[0]->PROPERTY_VALUE == $attempt->ATTEMPT)
					{
						$this -> Triviaservice_model -> updateCategoryAttemptOverTime($userId, $questionCategoryId);
					}
				}
			}
			$currentScore = $coinsForQuestion * $streakCount;					
		}
		return $trivitopicDtls = array("currentScore" => $currentScore,
										"gameStatus" => $gameStatus);
	}

	function updateStreakForTriviathon($userId, $gameMode, $message, $triviathonCoins, $coinsForQuestion)
	{
		$this -> load -> model('Triviaservice_model');
		$allQuestionCategory = $this -> Triviaservice_model -> getAllQuestionCategory();
		$rewardCoins = 0;
		$streakStatus = "FALSE";
		$currentScore = 0;
		if($message == "CORRECT")
		{
			$this -> Triviaservice_model -> updateCurrentStreakInUserScore($userId);
			//$this -> Triviaservice_model -> updatePreviousStreakInUserScore($userId);
			$currentScore = $coinsForQuestion + $triviathonCoins;
			$repeatQuestionSwitch = $this -> Triviaservice_model -> getPropertyDtlsForPropertyName('REPEAT QUESTION');
			//get no. of question that can be ateempted in triviathon which includes previous attempt
			$totalDefinedQuestion = $this -> Triviaservice_model -> getPropertyDtlsForPropertyName('TRIVIATHON STREAK');
			$scoreDetails = $this -> Triviaservice_model -> getScore($userId);
			$totalQuestionAteempted = $this -> Triviaservice_model -> getTotalQuestionsAttemptedForUserBasedonGameMode($userId, $gameMode);
			if($repeatQuestionSwitch[0]->PROPERTY_VALUE == 1)
			{
				if((int)($totalQuestionAteempted[0]->TOTAL_QUESTION_ATTEMPTED) >= (int)($totalDefinedQuestion[0] -> PROPERTY_VALUE))
				{
					if(($scoreDetails[0] -> STREAK) > ($scoreDetails[0] -> BEST_STREAK))
					{
						//get multiplier for triviathon
						$triviathonReward = $this -> Triviaservice_model -> getRewardForGameMode($gameMode);
						$rewardCoins = ($triviathonCoins * $triviathonReward[0]->MULTIPLIER);
						$streakStatus = "TRUE";
						$this -> Triviaservice_model -> updateBestStreak($userId);
						$this -> Triviaservice_model -> updateCoinsInUserScore($rewardCoins, 0, $userId);
					}
					//$this -> Triviaservice_model -> updatePreviousStreakInUserScore($userId);
					$this -> Triviaservice_model -> resetStreakInUserScore($userId);
				}
			}
		}
		else
		{
			//if streak is grater than best streak update best streak = streak
			$scoreDetails = $this -> Triviaservice_model -> checkScoreExistsForUser($userId);
			if(count($scoreDetails)>0)
			{
				$scoreData = $this -> Triviaservice_model -> getScore($userId);
				$categoryStreak = $this -> Triviaservice_model ->getuserCategoryStatus($userId);
				if(count($categoryStreak)<=0)
				{
					foreach($allQuestionCategory as $categories)
					{
						$Streakparams = array('USER_ID' => $userId,
												'QN_CATEGORY_ID' => $categories->QN_CATEGORY_ID,
												'STREAK' => 0,
												'ATTEMPT' => 0);
						$this -> Triviaservice_model -> insertUserCategoryStatus($Streakparams);
					}
				}
			}
			else
			{
				$Scoreparams = array('USER_ID' => $userId,
									'LIVES' => 10,
									'LEVEL' => 1);
				$this -> Triviaservice_model -> insertUserScore($Scoreparams);
				foreach($allQuestionCategory as $categories)
				{
					$Streakparams = array('USER_ID' => $userId,
										'QN_CATEGORY_ID' => $categories->QN_CATEGORY_ID,
										'STREAK' => 0,
										'ATTEMPT' => 0);
					$this -> Triviaservice_model -> insertUserCategoryStatus($Streakparams);
				}
				$scoreData = $this -> Triviaservice_model -> getScore($userId);
			}
			if(($scoreData[0] -> STREAK) > ($scoreData[0] -> BEST_STREAK))
			{
				//get multiplier for triviathon
				$triviathonReward = $this -> Triviaservice_model -> getRewardForGameMode($gameMode);
				$rewardCoins = ($triviathonCoins * $triviathonReward[0]->MULTIPLIER);
				$streakStatus = "TRUE";
				$this -> Triviaservice_model -> updateBestStreak($userId);
				$this -> Triviaservice_model -> updateCoinsInUserScore($rewardCoins, 0, $userId);
			}
			//$this -> Triviaservice_model -> updatePreviousStreakInUserScore($userId);
			$this -> Triviaservice_model -> resetStreakInUserScore($userId);
			$currentScore = $triviathonCoins;
		}
		
		return $triviathonDtls = array("rewardCoins" => $rewardCoins,
										"streakStatus" => $streakStatus,
										"currentScore" => $currentScore);
	}

	function getQuestionandOption($userId, $category, $level, $previousQnId,$gameMode)
	{
		$this -> load -> model('Triviaservice_model');
		$questionForCategory = $this -> Triviaservice_model -> getNotAnsweredQuestionByCategory($userId, $category, $level, $previousQnId,$gameMode);
							
		if(count($questionForCategory)>0)
		{
			$Success = "true";
			//$randomQuestionIndex=array_rand($questionForCategory,1);
			$nextQuestionId = $questionForCategory[0]->QN_ID;
			$optionsForQuestion = $this -> Triviaservice_model -> getOptionsForQuestionId($nextQuestionId);
			$optionSwitch = $this -> Triviaservice_model -> getPropertyDtlsForPropertyName('OPTION_ANSWER');
			if(($questionForCategory[0]->GAME_MECHANIC) == "Scrambled_Words")
			{
				$srcambledoptions = str_split($optionsForQuestion[0]->OPT_ANSWER);
				$i=0;
				foreach($srcambledoptions as $row)
				{
					$options[$i]['OPT_ID'] = $optionsForQuestion[0]->OPT_ID;
					$options[$i]['OPT_ANSWER'] = $row;
					$options[$i]['OPT_ANSWER_SEQ_NO'] = strval($i+1);
					$i++;
				}
				$optionsForQuestion = $options;
			}
			else if((($questionForCategory[0]->GAME_MECHANIC) == "MCQ") || (($questionForCategory[0]->GAME_MECHANIC) == "MCQ-TF"))
			{
				foreach ($optionsForQuestion as $options) 
				{
					if($optionSwitch[0]->PROPERTY_VALUE == 0)
					{
						$options->OPT_ANSWER = "";
					}
				}
			}
			shuffle($optionsForQuestion);
			return $questionOptionDtls = array("Success" => $Success,
												"questionForCategory" => $questionForCategory,
												"optionsForQuestion" => $optionsForQuestion);
		}
		else
		{ 
			$repeatQuestionSwitch = $this -> Triviaservice_model -> getPropertyDtlsForPropertyName('REPEAT QUESTION');
			if($gameMode == "TRIVIATHON")
			{
				if($repeatQuestionSwitch[0] ->PROPERTY_VALUE != 1)
				{
					$questionIdToReset = $this -> Triviaservice_model -> getUserQuestionFacedByCategory($userId, $category, $level);	
					foreach ($questionIdToReset as $row) 
					{
						$this -> Triviaservice_model -> resetUserQuestionFacedForUserId($userId,$row->QN_ID);
					}
				}
				else
				{
					$Success = "false";
					return $questionOptionDtls = array("Success" => $Success);
				}	
			}
			else
			{
				$questionIdToReset = $this -> Triviaservice_model -> getUserQuestionFacedByCategory($userId, $category, $level);	
				foreach ($questionIdToReset as $row) 
				{
					$this -> Triviaservice_model -> resetUserQuestionFacedForUserId($userId,$row->QN_ID);
				}
			}	
			
			$questionForCategory = $this -> Triviaservice_model -> getNotAnsweredQuestionByCategory($userId, $category, $level,$previousQnId,$gameMode);
			
			if(count($questionForCategory)>0)
			{
				$Success = "true";
				//$randomQuestionIndex=array_rand($questionForCategory,1);
				$nextQuestionId = $questionForCategory[0]->QN_ID;
				$optionsForQuestion = $this -> Triviaservice_model -> getOptionsForQuestionId($nextQuestionId);
				$optionSwitch = $this -> Triviaservice_model -> getPropertyDtlsForPropertyName('OPTION_ANSWER');
				if(($questionForCategory[0]->GAME_MECHANIC) == "Scrambled_Words")
				{
					$srcambledoptions = str_split($optionsForQuestion[0]->OPT_ANSWER);
					$i=0;
					foreach($srcambledoptions as $row)
					{
						$options[$i]['OPT_ID'] = $optionsForQuestion[0]->OPT_ID;
						$options[$i]['OPT_ANSWER'] = $row;
						$options[$i]['OPT_ANSWER_SEQ_NO'] = strval($i+1);
						$i++;
					}
					$optionsForQuestion = $options;
				}
				else if((($questionForCategory[0]->GAME_MECHANIC) == "MCQ") || (($questionForCategory[0]->GAME_MECHANIC) == "MCQ-TF"))
				{
					foreach ($optionsForQuestion as $options) 
					{
						if($optionSwitch[0]->PROPERTY_VALUE == 0)
						{
							$options->OPT_ANSWER = "";
						}
					}
				}
				shuffle($optionsForQuestion);
				return $questionOptionDtls = array("Success" => $Success,
												"questionForCategory" => $questionForCategory,
												"optionsForQuestion" => $optionsForQuestion);
			}
			else
			{
				$Success = "false";
				return $questionOptionDtls = array("Success" => $Success);
			}
							
		}
	}

	function getDeptFromMstr_get()
	{
		//Created by : Ashwini
		//$this -> load -> model('Triviaservice_model');

		$data['Success']="true";
		$data['DeptDtls'] = $this -> User_model -> getDepartments();
		$this -> response($data, 200);
	}

	function getTeamForDept_get()
	{
		//Created by : Ashwini
		$departmentName = $this -> get('departmentName');
		if ($departmentName == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter departmentName";
			$this -> response($data, 200);
		}

		$departmentDtls = $this -> User_model -> getDepartmentsbyName($departmentName);
		if(count($departmentDtls)>0)
		{
			$data['Success']="true";
			$data['TeamDtls'] = $this -> User_model -> getTeamsforDeptId($departmentDtls[0]->DEPARTMENT_ID);
		}
		else
		{
			$data['Success']="false";
			$data['ErrorMsg'] = "Department Name Does not exists.";
		}
	
		$this -> response($data, 200);
	}

	function updateUserprofile_get()
	{
		//Created by : Ashwini
		// Modified by : Leela
		// moidifed date : 16-Nov-2019

		$userId = $this -> get('userId');
		if ($userId == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter userId";
			$this -> response($data, 200);
		}
		$fullName = $this -> get('fullName');
		if ($fullName == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter fullName";
			$this -> response($data, 200);
		}
		$nickName = $this -> get('nickName');
		if ($nickName == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter nickName";
			$this -> response($data, 200);
		}
		$teamName = $this -> get('teamName');
		$departmentName = $this -> get('departmentName');
		$hobbies = $this ->get('hobbies');
		$profileImage = $this->get('profileImage');
		$this -> load -> model('Triviaservice_model');
		if($departmentName=='')
		{
			$departmentDtls = array();
			$departmentDtls[0] = new stdClass;
			$departmentDtls[0]->DEPARTMENT_ID = 0;
		}
		else
		{
			$departmentDtls = $this -> User_model -> getDepartmentsbyName($departmentName);
		}
		if($teamName=='')
		{
			$teamDtls = array();
			$teamDtls[0] = new stdClass;
			$teamDtls[0]->TEAM_ID = 0;
		}
		else
		{
			$teamDtls = $this -> User_model -> getTeamsbyNameandDept($teamName, $departmentDtls[0]->DEPARTMENT_ID);
			if(empty($teamDtls))
			{
				$teamDtls = array();
				$teamDtls[0] = new stdClass;
				$teamDtls[0]->TEAM_ID = 0;
			}	
		}
		if($profileImage != "")
		{
			$profileImage = 'resources/'.$profileImage.'.png';
		}
		else
		{
			$userDetails = $this -> User_model -> getUserDtlsById($userId);
			$profileImage = $userDetails[0]->PHOTO_PATH;
		}
		$param = array('FIRST_NAME' => $fullName,
					    'NICK_NAME' => $nickName,
						'TEAM_ID' => $teamDtls[0]->TEAM_ID,
						'DEPARTMENT_ID' => $departmentDtls[0]->DEPARTMENT_ID,
						'HOBBIES' => $hobbies,
						'PROFILE_PIC_PATH' =>$profileImage);
		
		$updateUser = $this -> User_model -> updateUserDtls($userId, $param);
		if($updateUser == true)
		{
			$data["Success"] = "true";
			$userDtls = $this -> User_model -> getUserDtlsById($userId);
			foreach($userDtls as $user)
			{
				if($user->NICK_NAME == "")
				{
					$user->NICK_NAME = $user->PROFILE_NAME;
				}
			}
			$data["UserDtls"] = $userDtls;
		}
		else
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Something Went Wrong.";
		}
		$this -> response($data, 200);
	}

	function getLeaderBoardForGameMode_get()
	{
		//Created by : Ashwini
		//modifed by : Leela
		// included Nick Name
		$userId = $this -> get('userId');
		if($userId == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter userId";
			$this -> response($data, 200);
		}
		$gameMode = $this -> get('gameMode');
		if($gameMode == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter gameMode";
			$this -> response($data, 200);
		}
		$workspace = $this -> get('workspace');
		if($workspace == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter workspace";
			$this -> response($data, 200);
		}
		$userWorkspaceDetails = $this -> User_model -> getWorkspaceForUserByUserId($userId);
		$i = 0;
		if(!in_array($workspace, array_column($userWorkspaceDetails, 'WS_DESC')))
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Workspace does not exist";
			$this -> response($data, 200);
		}
		$this -> defineTriviaSchema($workspace);

		$userRank = array();
		$this -> load -> model('Triviaservice_model');
		$leaderboard = $this -> Triviaservice_model -> getLeaderboardForGameMode($gameMode, $workspace);
		
		$rank = 0;
		$temp = 0;
		for ($i = 0; $i < count($leaderboard); $i++) 
		{
			if($leaderboard[$i]->POINTS != $temp)
			{
				$rank++;
			}
			$leaderboard[$i]->RANK = strval($rank);
			$temp = $leaderboard[$i]->POINTS;
		}
		if(count($leaderboard) <10)
		{
			$randomUserList = $this -> Triviaservice_model -> firstTenUsersExceptUserId($userId, $workspace);
			$i=0;
			$j = count($leaderboard);
			foreach ($randomUserList as $random) 
			{
				if(!in_array($random->USER_ID, array_column($leaderboard, 'USER_ID')))
				{
					$leaderboard[$j]['USER_ID'] = $random->USER_ID;
					$leaderboard[$j]['PROFILE_NAME'] = $random->PROFILE_NAME;
					$leaderboard[$j]['NICK_NAME'] = $random->NICK_NAME;
					$leaderboard[$j]['PHOTO_PATH'] = $random->PHOTO_PATH;
					$leaderboard[$j]['POINTS'] = strval(0);
					$leaderboard[$j]['RANK'] = strval(0);
					$j++;
				}
			}
			$resultLeaderBoard = $leaderboard;
		}
		else
		{
			$resultLeaderBoard = array_slice($leaderboard, 0, 10, true);
			$index = count($resultLeaderBoard);
			if(!in_array($userId, array_column($resultLeaderBoard, 'USER_ID')))
			{
				if(in_array($userId, array_column($leaderboard, 'USER_ID')))
				{
					foreach ($leaderboard as $value) 
					{
						if($value->USER_ID == $userId)
						{
							$resultLeaderBoard[$index]['USER_ID'] = $value->USER_ID;
							$resultLeaderBoard[$index]['PROFILE_NAME'] = $value->PROFILE_NAME;
							$resultLeaderBoard[$index]['NICK_NAME'] = $value->NICK_NAME;
							$resultLeaderBoard[$index]['PHOTO_PATH'] = $value->PHOTO_PATH;
							$resultLeaderBoard[$index]['POINTS'] = $value->POINTS;
							$resultLeaderBoard[$index]['RANK'] = $value->RANK;
						}
					}
				}
			}
		}

		$data["Success"] = "true";
		$data["LeaderBoard"] = $resultLeaderBoard;
		$this -> response($data, 200);
	}

	function getQuestionCategory_get()
	{
		//Created by : Ashwini
		$workspace = $this -> get('workspace');
		if($workspace == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter workspace";
			$this -> response($data, 200);
		}
		$gameMode = $this -> get('gameMode');
		if($gameMode == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter gameMode";
			$this -> response($data, 200);
		}
		$allWorkspace = $this -> User_model -> getAllWorkspace();
		if(!in_array($workspace, array_column($allWorkspace, 'WS_DESC')))
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Workspace does not exist";
			$this -> response($data, 200);
		}
		$this -> defineTriviaSchema($workspace);	
		
		$this -> load -> model('Triviaservice_model');
		$questionCategoryList = $this -> Triviaservice_model -> getAllQuestionCategory();
		$i = 0;
		foreach($questionCategoryList as $qnCategory)
		{
			$questions = $this -> Triviaservice_model ->getAllQuestionsByCategory($qnCategory->QN_CATEGORY_ID, $gameMode);
			if(count($questions)>0)
			{
				$questionCategory[$i]['QN_CATEGORY_ID'] = $qnCategory->QN_CATEGORY_ID;
				$questionCategory[$i]['QN_CATEGORY'] = $qnCategory->QN_CATEGORY;
				$questionCategory[$i]['QN_CATEGORY_MASCOT'] = $qnCategory->QN_CATEGORY_MASCOT;
				$questionCategory[$i]['STATUS'] = $qnCategory->STATUS;
				$i++;
			}
		}
		$data['Success']="true";
		$data['QUESTION_CATEGORY'] = $questionCategory;
	
		$this -> response($data, 200);
	}

	function updateNotificationStatus_get()
	{
		//Created by : Ashwini
		$userId = $this -> get('userId');
		if($userId == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter userId";
			$this -> response($data, 200);
		}
		$notificationId = $this -> get('notificationId');
		if($notificationId == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter notificationId";
			$this -> response($data, 200);
		}
		$workspace = $this -> get('workspace');
		if($workspace == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter workspace";
			$this -> response($data, 200);
		}
		$userWorkspaceDetails = $this -> User_model -> getWorkspaceForUserByUserId($userId);
		if(!in_array($workspace, array_column($userWorkspaceDetails, 'WS_DESC')))
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Workspace does not exist";
			$this -> response($data, 200);
		}
		$this -> defineTriviaSchema($workspace);

		$this -> load -> model('Triviaservice_model');
		$notificationDetails = $this -> Triviaservice_model -> getuserNotificationById($userId, $notificationId);
		if(count($notificationDetails) > 0)
		{
			if($notificationDetails[0]->STATUS != "C")
			{
				if($notificationDetails[0]->NOT_TYPE == "LEAGUE REWARD")
				{
					$this -> getLeagueRewardRankWise($userId, $notificationDetails[0]->UGS_ID);
				}
				else if($notificationDetails[0]->NOT_TYPE == "TRIVIATOPICS REWARD")
				{
					$triviatopicsReward = $this -> Triviaservice_model -> getRewardForGameMode("TRIVIATOPICS");
					$this -> Triviaservice_model -> updateCoinsInUserScore($triviatopicsReward[0]->COINS, $triviatopicsReward[0]->GEMS, $userId);
				}
			}
		}
		
		$updateStatus = $this -> Triviaservice_model -> updateNotificationStatus($userId, $notificationId);
		if($updateStatus == true)
		{
			$data["Success"] = "true";
		}
		else
		{
			$data["Success"] = "false";
		}
		$this -> response($data, 200);
	}

	function getQuestionGameMechanic_get()
	{
		//Created by : Ashwini
		$workspace = $this -> get('workspace');
		if($workspace == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter workspace";
			$this -> response($data, 200);
		}
		$allWorkspace = $this -> User_model -> getAllWorkspace();
		if(!in_array($workspace, array_column($allWorkspace, 'WS_DESC')))
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Workspace does not exist";
			$this -> response($data, 200);
		}
		$this -> defineTriviaSchema($workspace);

		$this -> load -> model('Triviaservice_model');
		$data['Success']="true";
		$data['GAME_MECHANIC'] = $this -> Triviaservice_model -> getAllGameMechanicForQuestions();
	
		$this -> response($data, 200);
	}

	function getOverallPerformanceForUser_get()
	{
		//Created by : Ashwini
		$userId = $this -> get('userId');
		if($userId == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter userId";
			$this -> response($data, 200);
		}
		$workspace = $this -> get('workspace');
		if($workspace == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter workspace";
			$this -> response($data, 200);
		}
		$userWorkspaceDetails = $this -> User_model -> getWorkspaceForUserByUserId($userId);
		if(!in_array($workspace, array_column($userWorkspaceDetails, 'WS_DESC')))
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Workspace does not exist";
			$this -> response($data, 200);
		}
		$this -> defineTriviaSchema($workspace);

		$this -> load -> model('Triviaservice_model');
		$totalAttemptDetails = $this -> Triviaservice_model -> getCountOfCorrectAnswerForUser($userId);
		$categorywisePerformance = $this -> Triviaservice_model -> getCategorywisePerformanceofUser($userId);
		$gamesPlayedByUser = $this -> Triviaservice_model -> getGamesPlayedByUser($userId);

		$data['Success']="true";
		$data['TOTAL_ATTEMPT_DETAILS'] = $totalAttemptDetails;
		$data['CATEGORY_WISE_PERFORMANCE'] = $categorywisePerformance;
		$data['GAMES_PLAYED_DETAILS'] = $gamesPlayedByUser;
	
		$this -> response($data, 200);
	}

	function getCardsForQuestionId_get()
	{
		//Created by : Ashwini
		$questionId = $this -> get('questionId');
		if($questionId == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter questionId";
			$this -> response($data, 200);
		}
		$workspace = $this -> get('workspace');
		if($workspace == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter workspace";
			$this -> response($data, 200);
		}
		$allWorkspace = $this -> User_model -> getAllWorkspace();
		if(!in_array($workspace, array_column($allWorkspace, 'WS_DESC')))
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Workspace does not exist";
			$this -> response($data, 200);
		}
		$this -> defineTriviaSchema($workspace);

		$this -> load -> model('Triviaservice_model');
		$cardsDetails = $this -> Triviaservice_model -> getCardsForQuestionId($questionId);
		$i = 0;
		$tempCardId = 0;
		$j = 1;
		$k = 1;
		if(count($cardsDetails)>0)
		{
			foreach ($cardsDetails as $row) 
			{
				if($tempCardId != 0 && $tempCardId != $row->CARD_ID)
				{
					$i++;
					$j = 1;
					$k = 1;
				}
				$card[$i]['CARD_ID'] = $row->CARD_ID;
				if($row->CARD_DETAIL_CODE == "TITLE")
				{
					$card[$i]['CARD_TITLE'] = $row->CARD_DETAIL_DESC;
				}
				else if($row->CARD_DETAIL_CODE == "DESCRIPTION")
				{
					if(array_key_exists("CARD_DESCRIPTION",$card[$i]))
					{
						$k++;
						$card[$i]['CARD_DESCRIPTION'.$k] = $row->CARD_DETAIL_DESC;
					}
					else
					{
						$card[$i]['CARD_DESCRIPTION'] = $row->CARD_DETAIL_DESC;
					}
				}
				else if($row->CARD_DETAIL_CODE == "IMAGE")
				{
					if(array_key_exists("CARD_IMAGE",$card[$i]))
					{
						$j++;
						$card[$i]['CARD_IMAGE'.$j] = $row->MEDIA_URL;
					}
					else
					{
						$card[$i]['CARD_IMAGE'] = $row->MEDIA_URL;
					}
				}
				else if($row->CARD_DETAIL_CODE == "VIDEO")
				{
					if(array_key_exists("CARD_VIDEO",$card[$i]))
					{
						$j++;
						$card[$i]['VIDEO_URL'.$j] = $row->MEDIA_URL;
					}
					else
					{
						$card[$i]['VIDEO_URL'] = $row->MEDIA_URL;
					}
				}
				$tempCardId = $row->CARD_ID;
			}
			$data['Success']="true";
			$data['CARD_DETAILS'] = $card;
			$this -> response($data, 200);
		}
		else
		{
			$data['Success']="false";
			$data['CARD_DETAILS'] = "No Card";
			$this -> response($data, 200);
		}
	}
	function sendmail($toemail, $userName, $workspaceForUser, $isnewuser)
    {
        $this->load->library('email'); // load email library
        $newUserEmail='';
        $newUserPassword='';
        if($isnewuser=='TRUE')
        {
            $newUserEmail='<p>EmailId: '.$toemail.'</p>';
            
            $userDtls = $this -> User_model->getUserByLoginId($toemail);
            $newUserPassword = '<p>Temporary Password:'.$userDtls[0]->PASSWORD.'</p>';
          
        }
        $userWorkspace = "";
        foreach ($workspaceForUser as $workspace) 
	    {
	       	$userWorkspace .= '<p>'.$workspace.'</p><br>';
	    }
        
        $this->email->from(supportMailId);
        $this->email->to($toemail);
        $this->email->cc(''); 
        $this->email->subject('Registration Successfull');
        $this->email->message('<p><span style="font-family:Arial,Helvetica,sans-serif">Hi '.$userName.',</span></p>

                                <p>Thank you for registering with Bizgames. Your account is created. </p>

                                <p>Below are the Gamespace url for which you have access.</p>
                                
                                <p>&nbsp;</p>

                                <p>'.$userWorkspace.'</p>

                                <p>'.$newUserEmail.'</p><p>'.$newUserPassword.'</p>
                                
                                <p>Regards,</p>
                                
                                <p>Team BizGames</p>
                                
                                 <p>&nbsp;</p>
                                
                                <p> This is an autogenerated email. Incase of any clarifications write to contactus@processbee.com</p>');
        // $this->email->attach('/path/to/file1.png'); // attach file
        // $this->email->attach('/path/to/file2.pdf');
        if ($this->email->send())
        {
            //$this->session->set_flashdata('msg', '<div class="alert alert-success text-center"> We have sent your Login Credential to your e-MailID <br /> Please <a href="'.base_url().'"/login/index.php">Click Here</a> to Login</div>');
            //echo "Mail Sent!";
        }
        else
        {
            // $this->session->set_flashdata('msg', '<div class="alert alert-success text-center">We cant find your email address</div>');
          //  show_error($this->email->print_debugger());
        }
            
    }

    function getWorkspaceAvailableForUser_get()
	{
		//Created by : Ashwini
		$userId = $this -> get('userId');
		if($userId == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter userId";
			$this -> response($data, 200);
		}
		$workspace = $this -> get('workspace');
		if($workspace == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter workspace";
			$this -> response($data, 200);
		}
		
		$userWorkspaceDetails = $this -> User_model -> getWorkspaceForUserByUserId($userId);

		// $timezone = 330;
        // $currdate=date("Y-m-d H:i:s");
        // $timestampStart = strtotime($currdate) + ($timezone * 60);
		// $currentDate = date("Y-m-d H:i:s", $timestampStart);
		$currdate = $this -> User_model -> getCurrentTimeFromDatabase();
		if(in_array($workspace, array_column($userWorkspaceDetails, 'WS_DESC')))
		{
			$workspaceDtls = $this -> User_model -> getWorkspaceByDesc($workspace);
			foreach ($userWorkspaceDetails as $userWorkspace) 
			{
				if($userWorkspace->WS_ID == $workspaceDtls[0]->WS_ID)
				{
					if($userWorkspace->VALID_FROM != "" && $userWorkspace->VALID_TO)
					{
						if($userWorkspace -> VALID_FROM <= $currdate[0]->CurrentDate && $userWorkspace->VALID_TO >= $currdate[0]->CurrentDate)
						{
							$data['Success']="true";
							$data['WORKSPACE_DETAILS'] = $workspaceDtls;
							$this -> response($data, 200);
						}
						else
						{
							$data['Success']="false";
							$data['ErrorMsg']="Access validity for this workspace is over.";
							$this -> response($data, 200);
						}
					}
					else
					{
						$data['Success']="true";
						$data['WORKSPACE_DETAILS'] = $workspaceDtls;
						$this -> response($data, 200);
					}
				}
			}
		}
		else
		{
			$data['Success']="false";
			$data['ErrorMsg']="You don't have access to this Workspace.";
			$this -> response($data, 200);
		}
	}

	function getUserRatingValues_get()
	{
		//Created by : Ashwini
		$workspace = $this -> get('workspace');
		if($workspace == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter workspace";
			$this -> response($data, 200);
		}
		$allWorkspace = $this -> User_model -> getAllWorkspace();
		if(!in_array($workspace, array_column($allWorkspace, 'WS_DESC')))
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Workspace does not exist";
			$this -> response($data, 200);
		}
		$this -> defineTriviaSchema($workspace);

		$this -> load -> model('Triviaservice_model');
		$data['Success']="true";
		$data['RATING_DETAILS'] = $this -> Triviaservice_model -> getUserRatingValues();
	
		$this -> response($data, 200);
	}

	function insertUserFeedback_get()
	{
		//Created by : Ashwini
		$userId = $this -> get('userId');
		if($userId == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter userId";
			$this -> response($data, 200);
		}
		$workspace = $this -> get('workspace');
		if($workspace == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter workspace";
			$this -> response($data, 200);
		}
		$userWorkspaceDetails = $this -> User_model -> getWorkspaceForUserByUserId($userId);
		if(!in_array($workspace, array_column($userWorkspaceDetails, 'WS_DESC')))
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Workspace does not exist";
			$this -> response($data, 200);
		}
		$this -> defineTriviaSchema($workspace);

		$feedback = $this -> get('feedback');

		$feedbackValues = json_decode($feedback, true);

		for($i = 0; $i < count($feedbackValues['FEEDBACK']); $i++)
		{
			$feedbackValues['FEEDBACK'][$i]['USER_ID'] = $userId;
		}
		$this->db-> trans_begin(); 
		$this -> load -> model('Triviaservice_model');
		foreach ($feedbackValues['FEEDBACK'] as $row) 
		{
			$this -> Triviaservice_model -> insertUserFeedback($row);
		}
		$error = $this->db-> error();
        if ( $this->db-> trans_status() === FALSE)
        {
            $this->db-> trans_rollback();
            $data['Success'] = "false";
        }
        else
        {
            $this->db-> trans_commit();
            $data["Success"] = "true";
        }
		$this -> response($data, 200);
	}

	function forgotPassword_get()
	{
	    //$userId = "INVALID USER";
		$emailId = $this -> get('emailId');
		if ($emailId == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Please Enter emailId";
			$this -> response($data, 200);
		}
		if(!empty($emailId) && filter_var($emailId, FILTER_VALIDATE_EMAIL) === false) 
		{
		    $data["Success"] = "false";
			$data["ErrorMsg"] = "Email Id is not Valid";
			$this -> response($data, 200);
		}
		$userInfo = $this-> User_model ->getUserByLoginId($emailId);
		if(empty($userInfo))
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "We cant find your email address";
			$this -> response($data, 200);
		}
		else
		{
			foreach ($userInfo as $row)
            {
                $userid = $row -> LOGIN_ID;
                $passwd = $row -> PASSWORD;
                $userfullname = $row->FIRST_NAME;
            }             
            $this -> sendforgotmail($emailId,$userfullname,$userid,$passwd);
            $data['Success'] = true;
            $data['ErrorMsg'] = 'We have sent your Login Credential to your e-MailID';
            $this -> response($data, 200);
		}
	}
	function sendforgotmail($emailId,$userfullname,$userid,$passwd)
	{
	    $this->load->library('email'); // load email library
	    $this->email->from(supportMailId);
	    $this->email->to($emailId);
	    $this->email->cc(''); 
	    $this->email->subject('Bizgames: Password Retrieval');
	    $this->email->message('<p><span style="font-family:Arial,Helvetica,sans-serif">Dear '.$userfullname.',</span></p>
	    						<p>We have received your request for password retrieval. Please find the details that you used during registration.</p>
                                <p>Name : '.$userfullname.'</p>
								<p>Login ID : '.$userid.'</p>
								
                                <p>Email ID : '.$emailId.'</p>
								
								<p>Password : '.$passwd.'</p>
								
								<p>Please do not share your login credentials with others.</p>
								
								<p>Thanks,</p>
								
								<p>Team Bizgames</p>');
	    if ($this->email->send())
	    {
	        // $this->session->set_flashdata('msg', '<div class="alert alert-success text-center"> We have sent your Login Credential to your e-MailID <br /> Please <a href="'.base_url().'"/login/index.php">Click Here</a> to Login</div>');
            //echo "Mail Sent!";
	    }
	    else
	    {
	        // $this->session->set_flashdata('msg', '<div class="alert alert-success text-center">We cant find your email address</div>');
            //show_error($this->email->print_debugger());
	    }
	}
	function getDateWisePeformanceReport_get()
	{
		//Created by : Ashwini
		$userId = $this -> get('userId');
		if($userId == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter userId";
			$this -> response($data, 200);
		}
		$category = $this -> get('category');
		
		$monthYear = $this -> get('monthYear');
		if($monthYear == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter monthYear";
			$this -> response($data, 200);
		}
		$workspace = $this -> get('workspace');
		if($workspace == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter workspace";
			$this -> response($data, 200);
		}
		$userWorkspaceDetails = $this -> User_model -> getWorkspaceForUserByUserId($userId);
		if(!in_array($workspace, array_column($userWorkspaceDetails, 'WS_DESC')))
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Workspace does not exist";
			$this -> response($data, 200);
		}
		$this -> defineTriviaSchema($workspace);

		$this -> load -> model('Triviaservice_model');
		$totalAttempt = $this -> Triviaservice_model -> getDateWiseTotalAttempt($userId, $category, $monthYear);
		$correctAttempt = $this -> Triviaservice_model -> getDateWiseCorrectAttempt($userId,$category, $monthYear);
		$monthYearArray = explode(' ', $monthYear);
		$month = date("m", strtotime($monthYearArray[0]));
		$year = intval($monthYearArray[1]);
		$numberOfDays = cal_days_in_month(CAL_GREGORIAN, $month, $year);
		//echo $numberOfDays;
		$i=0;
		$flag = false;
		$reportDtls = array();
		for($k = 1; $k <= $numberOfDays; $k++)
		{
			if(count($totalAttempt)>0)
			{
				foreach ($totalAttempt as $total) 
				{
					$attemptDate = intval(date("j", strtotime($total->QN_ATTEMPTED_DATE)));//j to get single digit date
					if($attemptDate == $k)
					{
						foreach ($correctAttempt as $correct) 
						{
							if($total->QN_ATTEMPTED_DATE == $correct->QN_ATTEMPTED_DATE)
							{
								$reportDtls[$i]['CORRECT_ATTEMPTS'] = $correct->CORRECT_ATTEMPT_COUNT;
								$reportDtls[$i]['CORRECT_ATTEMPTS_PERCENTAGE'] = strval(round(($correct->CORRECT_ATTEMPT_COUNT/$total->TOTAL_ATTEMPT_COUNT)*100,0));
								//$reportDtls[$i]['QN_ATTEMPTED_DATE'] = strval($attemptDate);
								$reportDtls[$i]['QN_ATTEMPTED_DATE'] = strval($k);
								$i++;
								$removed = array_shift($correctAttempt);
								$removed = array_shift($totalAttempt);
								$flag = true;
								break;
							}
							else
							{
								$reportDtls[$i]['CORRECT_ATTEMPTS'] = "0";
								$reportDtls[$i]['CORRECT_ATTEMPTS_PERCENTAGE'] = "0";
								//$reportDtls[$i]['QN_ATTEMPTED_DATE'] = strval($attemptDate);
								//$reportDtls[$i]['QN_ATTEMPTED_DATE'] = $j.'-'.$month.'-'.$year;
								$reportDtls[$i]['QN_ATTEMPTED_DATE'] = strval($k);
								$removed = array_shift($totalAttempt);
								$i++;
								$flag = true;
								break;
							}
						}
					}
					else
					{
						$reportDtls[$i]['CORRECT_ATTEMPTS'] = "0";
						$reportDtls[$i]['CORRECT_ATTEMPTS_PERCENTAGE'] = "0";
						//$reportDtls[$i]['QN_ATTEMPTED_DATE'] = $j.'-'.$month.'-'.$year;
						$reportDtls[$i]['QN_ATTEMPTED_DATE'] = strval($k);
						$i++;
						break;
					}
					if($flag == true)
					{
						break;
					}
				}
			}
			else
			{
				$reportDtls[$i]['CORRECT_ATTEMPTS'] = "0";
				$reportDtls[$i]['CORRECT_ATTEMPTS_PERCENTAGE'] = "0";
				//$reportDtls[$i]['QN_ATTEMPTED_DATE'] = $j.'-'.$month.'-'.$year;
				$reportDtls[$i]['QN_ATTEMPTED_DATE'] = strval($k);
				$i++;	
				//$data['Success']="false";
				//$data['ErrorMsg'] = "No Records";	
			}
		}
		$data['Success']="true";
		$data['DATE_WISE_REPORT'] = $reportDtls;
		$this -> response($data, 200);		
	}

	function getFeedbackMstr_get()
	{
		//Created by : Ashwini
		$workspace = $this -> get('workspace');
		if($workspace == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter workspace";
			$this -> response($data, 200);
		}
		$allWorkspace = $this -> User_model -> getAllWorkspace();
		if(!in_array($workspace, array_column($allWorkspace, 'WS_DESC')))
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Workspace does not exist";
			$this -> response($data, 200);
		}
		$this -> defineTriviaSchema($workspace);

		$this -> load -> model('Triviaservice_model');
		$data['Success']="true";
		$data['FEEDBACK_TYPES'] = $this -> Triviaservice_model -> getFeedbackMstr();
	
		$this -> response($data, 200);
	}

	function getLeagueRewardRankWise($userId, $ugsId)
	{
		$this -> load -> model('Triviaservice_model');
		$leaguePlayed = $this -> Triviaservice_model -> getLeaguePlayedIdsByUser($userId);
		$i=0;
		foreach ($leaguePlayed as $leaPlay) 
		{
			if($leaPlay->STATUS != "A")
			{
				$leagueLeaderboard = $this -> Triviaservice_model -> getLeaderBoardForLeagueById($leaPlay->LGS_ID);
				$rank = 0;
				$temp = 0;
				for ($i = 0; $i < count($leagueLeaderboard); $i++) 
				{
					if($leagueLeaderboard[$i]->COINS!=$temp)
					{
						$rank++;
					}
					$leagueLeaderboard[$i]->RANK=$rank;
					$temp=$leagueLeaderboard[$i]->COINS;
				}
				//To give Rewards for which League is Completed based on Rank 
				$rewardForLeague = $this -> Triviaservice_model -> getRewardForGameMode("LEAGUE");
				$firstRankSetForLeague = explode ("to", $rewardForLeague[0]->RANK);
				$firstRankSetFromRank = explode(" ", $firstRankSetForLeague[0]);
				$secondRankSetForLeague = explode ("to", $rewardForLeague[1]->RANK);
				$secondRankSetFromRank = explode(" ", $secondRankSetForLeague[0]);
				$thirdRankSetForLeague = explode ("to", $rewardForLeague[2]->RANK);
				$thirdRankSetFromRank = explode(" ", $thirdRankSetForLeague[0]);
				
				foreach ($leagueLeaderboard as $leader) 
				{
					if($leader->USER_ID == $userId)
					{
						if(($leader->RANK >= $firstRankSetFromRank[1]) && ($leader->RANK <= $firstRankSetForLeague[1]))
						{
							$coins = $rewardForLeague[0]->COINS;
							$gems = $rewardForLeague[0]->GEMS;
							$this -> Triviaservice_model -> updateCoinsInUserScore($coins, $gems, $userId);

							$this -> Triviaservice_model -> updateLeagueRewardCollectedStatus($userId, $ugsId);
						}
						else if(($leader->RANK >= $secondRankSetFromRank[1]) && ($leader->RANK <= $secondRankSetForLeague[1]))
						{
							$coins = $rewardForLeague[1]->COINS;
							$gems = $rewardForLeague[1]->GEMS;
							$this -> Triviaservice_model -> updateCoinsInUserScore($coins, $gems, $userId);

							$this -> Triviaservice_model -> updateLeagueRewardCollectedStatus($userId, $ugsId);							
						}
						else if(($leader->RANK >= $thirdRankSetFromRank[1]) && ($leader->RANK <= $thirdRankSetForLeague[1]))
						{
							$coins = $rewardForLeague[2]->COINS;
							$gems = $rewardForLeague[2]->GEMS;
							$this -> Triviaservice_model -> updateCoinsInUserScore($coins, $gems, $userId);

							$this -> Triviaservice_model -> updateLeagueRewardCollectedStatus($userId, $ugsId);
						}
					}
				}
			}
		}
	}
	function inviteUserToWorkSpace_get()
	{
		//Created by : Ashwini
		//TO send workspace url to user and insert into user_workspace_mapping_tbl
		//API : http://localhost/trivia//api/TriviaService/inviteUserToWorkSpace?emailIds=["ashwini.ash08@gmail.com","ashwini@gamil.com"]&workspace=Trivia.processbee.com
		$emailIds = $this -> get('emailIds');
		if ($emailIds == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Please Enter emailIds";
			$this -> response($data, 200);
		}
		$emailIdsArray = json_decode($emailIds, true);
		//var_dump($emailIdsArray);

		$workspace = $this -> get('workspace');
		if($workspace == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter workspace";
			$this -> response($data, 200);
		}

		$allWorkspace = $this -> User_model -> getAllWorkspace();

		$i = 0;
		if(!in_array($workspace, array_column($allWorkspace, 'WS_DESC')))
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Workspace does not exist";
			$this -> response($data, 200);
		}
		foreach ($emailIdsArray as $emailsList) 
		{
			$email = $emailsList;
			if(!empty($email) && filter_var($email, FILTER_VALIDATE_EMAIL) === false) 
			{
			    $data["Success"] = "false";
				$data["ErrorMsg"] = "Email Id is not Valid";
				$this -> response($data, 200);
			}
		}
		
		$data = array();
		foreach ($emailIdsArray as $email) 
		{
			$workspaceDtls = $this -> User_model -> getWorkspaceByEmailIdAndWorkspace($email, $workspace);
			if(empty($workspaceDtls))
			{
				$this->db-> trans_begin(); 
				$workspaceDtls = $this -> User_model -> getWorkspaceByDesc($workspace);
				$workspaceForUser = array_column($workspaceDtls, 'WS_DESC');
				$userDtls = $this -> User_model -> getUserByLoginId($email);
				if(count($userDtls)>0)
				{
					$params = array('USER_ID' => $userDtls[0]->USER_ID,
							'WS_ID' => $workspaceDtls[0]->WS_ID,
							'VALID_FROM' => "",
							'VALID_TO' => "");
					$this -> User_model -> insertWorkspaceForUser($params);
					$this -> sendmail($email, $userDtls[0]->FIRST_NAME, $workspaceForUser, 'FALSE');
				}
				else
				{
					$password = $this -> generate_key_string(6,1);
					$randomNum = rand(1,20);
					$image="PP".$randomNum;
					$params = array('LOGIN_ID' => $email,
									'PASSWORD' => $password,
									'FIRST_NAME' => $email,
									'NICK_NAME' => $email,
									'EMAIL_ID' => $email,
									'PROFILE_PIC_PATH' => 'resources/img/users/PlayerProfileIcons/'.$image.'.png');

					$userId = $this -> User_model -> insertMstrUser($params);
					
					$params = array('USER_ID' => $userId,
							'WS_ID' => $workspaceDtls[0]->WS_ID,
							'VALID_FROM' => "",
							'VALID_TO' => "");
					$this -> User_model -> insertWorkspaceForUser($params);
					$this -> sendmailtoInvite($email, $email, $workspaceForUser,'TRUE');
				}
				$error = $this->db-> error();
		        if ( $this->db-> trans_status() === FALSE)
		        {
		            $this->db-> trans_rollback();
		            $data['Success'] = "false";
		        }
		        else
		        {
		            $this->db-> trans_commit();
		            $data["Success"] = "true";
		        }
			}
			else
			{
				$data["Success"] = "true";
			}	
		}
		$this -> response($data, 200);
	}
	function sendmailtoInvite($toemail, $userName, $workspaceForUser, $isnewuser)
    {
        $this->load->library('email'); // load email library
        $newUserEmail='';
        $newUserPassword='';
        if($isnewuser=='TRUE')
        {
            $newUserEmail='<p>EmailId: '.$toemail.'</p>';
            
            $userDtls = $this -> User_model->getUserByLoginId($toemail);
            $newUserPassword = '<p>Temporary Password:'.$userDtls[0]->PASSWORD.'</p>';
          
        }
        $userWorkspace = "";
        foreach ($workspaceForUser as $workspace) 
	    {
	       	$userWorkspace .= '<p>'.$workspace.'</p><br>';
	    }
        
        $this->email->from(supportMailId);
        $this->email->to($toemail);
        $this->email->cc(''); 
        $this->email->subject('Invited to Join the Gamespace');
        $this->email->message('<p><span style="font-family:Arial,Helvetica,sans-serif">Hi '.$userName.',</span></p>

                                <p>You are invited to join the Gamespace. </p>

                                <p>Below are the Gamespace url for which you have access.</p>
                                
                                <p>&nbsp;</p>

                                <p>'.$userWorkspace.'</p>

                                <p>'.$newUserEmail.'</p><p>'.$newUserPassword.'</p>
                                
                                <p>Regards,</p>
                                
                                <p>Team BizGames</p>
                                
                                 <p>&nbsp;</p>
                                
                                <p> This is an autogenerated email. Incase of any clarifications write to contactus@processbee.com</p>');
        // $this->email->attach('/path/to/file1.png'); // attach file
        // $this->email->attach('/path/to/file2.pdf');
        if ($this->email->send())
        {
            //$this->session->set_flashdata('msg', '<div class="alert alert-success text-center"> We have sent your Login Credential to your e-MailID <br /> Please <a href="'.base_url().'"/login/index.php">Click Here</a> to Login</div>');
            //echo "Mail Sent!";
        }
        else
        {
            // $this->session->set_flashdata('msg', '<div class="alert alert-success text-center">We cant find your email address</div>');
          //  show_error($this->email->print_debugger());
        }
            
    }
	function generate_key_string($char,$segment) 
    {
        // Modified by : Leela
        // Modified on : 26-02-2018
        // function to create random String
        $tokens = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
        
        // $segment_chars = 8;
        // $num_segments = 1;
        $segment_chars = $char;
        $num_segments = $segment;
        $key_string = '';
        for ($i = 0; $i < $num_segments; $i++) 
        {
            $segment = '';
            for ($j = 0; $j < $segment_chars; $j++) 
            {
                $segment .= $tokens[rand(0, strlen($tokens)-1)];
            }
            $key_string .= $segment;

             if ($i < ($num_segments - 1)) 
             {
                 $key_string .= '-';
             }
        }
        return $key_string;
    }

    function getAllQuizWithUserPoints_get()
	{
		//Created by : Ashwini
		$userId = $this -> get('userId');
		if($userId == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter userId";
			$this -> response($data, 200);
		}
		$workspace = $this -> get('workspace');
		if($workspace == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter workspace";
			$this -> response($data, 200);
		}
		$userWorkspaceDetails = $this -> User_model -> getWorkspaceForUserByUserId($userId);
		if(!in_array($workspace, array_column($userWorkspaceDetails, 'WS_DESC')))
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Workspace does not exist";
			$this -> response($data, 200);
		}
		$this -> defineTriviaSchema($workspace);
		
		$this -> load -> model('Triviaservice_model');
		$allQuizDtls = $this -> Triviaservice_model -> getAllActiveQuiz();

		//$points = 0;
		$message = "";
		$currdate = $this -> User_model -> getCurrentTimeFromDatabase();
		foreach ($allQuizDtls as $quiz) 
		{
			if($currdate[0]->CurrentDate >= $quiz->END_TIME)
			{
				$this -> Triviaservice_model -> updateUserQuizStatus($userId, $quiz->QUIZ_ID);
			}
		}
		$quizDetails = $this -> Triviaservice_model -> getAllQuizWithQuizStatus($userId);
		foreach ($quizDetails as $quiz) 
		{
			//$quizPerformance = $this -> Triviaservice_model -> getQuizWiseUserPerformance($quiz->QUIZ_ID, $userId);
			$points = 0;
			$remaingTime = "0";
			if($currdate[0]->CurrentDate >= $quiz->END_TIME)
			{
				$quiz->QUIZ_STATUS = 'COMPLETED';
			}
			if(($currdate[0]->CurrentDate < $quiz->END_TIME) && ($currdate[0]->CurrentDate >= $quiz->START_TIME))
			{
				$quiz->QUIZ_STATUS = 'ACTIVE';
			}
			if($currdate[0]->CurrentDate < $quiz->START_TIME)
			{
				$quiz->QUIZ_STATUS = 'UPCOMING';
			}
			if(($quiz->QUIZ_STATUS == 'ACTIVE') && ($currdate[0]->CurrentDate >= $quiz->START_TIME))
			{
				$quizendtime = new DateTime($quiz->END_TIME);
				$endtime = $quizendtime->format('Y-m-d H:i:s');
				$currTime = new DateTime($currdate[0]->CurrentDate);
				$currentDate = $currTime->format('Y-m-d H:i:s');
				$remaingTime = strval(strtotime($endtime) - strtotime($currentDate));
			}
			$quiz -> REMAINING_TIME = $remaingTime;
			$pointsDtls = $this -> getPointsForUserAndQuiz($quiz->QUIZ_ID,$userId);
			if(count($pointsDtls) > 0)
			{
				$quiz -> POINTS = strval($pointsDtls[0]['POINTS']);
			}
			else
			{
				$quiz -> POINTS = "0";
			}
		}
		
		$data['Success'] = "true";
		$data['QUIZ_DETAILS'] = $quizDetails;
		$this -> response($data, 200);
	}

	function getAllQuestionsAndOptionsForQuiz_get()
	{
		//Created by : Ashwini
		$userId = $this -> get('userId');
		if($userId == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter userId";
			$this -> response($data, 200);
		}
		$quizId = $this -> get('quizId');
		if($quizId == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter quizId";
			$this -> response($data, 200);
		}
		$workspace = $this -> get('workspace');
		if($workspace == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter workspace";
			$this -> response($data, 200);
		}
		$userWorkspaceDetails = $this -> User_model -> getWorkspaceForUserByUserId($userId);
		if(!in_array($workspace, array_column($userWorkspaceDetails, 'WS_DESC')))
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Workspace does not exist";
			$this -> response($data, 200);
		}
		$this -> defineTriviaSchema($workspace);

		$remaingTime = "0";
		$this -> load -> model('Triviaservice_model');
		$questionsIdsForQuiz = $this -> Triviaservice_model -> getQuestionIdsForQuizId($quizId);
		if(count($questionsIdsForQuiz) > 0)
		{
			$quizQuestionstatusforUser = $this -> Triviaservice_model -> getquizQuestionStatusforUser($quizId, $userId);

			$quizStatusForUser = $this -> Triviaservice_model -> getUserQuizStatus($userId, $quizId);
			if(count($quizStatusForUser) <= 0)
			{
				$userStatusParam = array('USER_ID' => $userId,
										'QUIZ_ID' => $quizId,
										'QUIZ_STATUS' => "O");
				$this -> Triviaservice_model -> insertUserQuizStatus($userStatusParam);
			}
			$j = 0;
			foreach ($questionsIdsForQuiz as $questionDtls) 
			{
				$question = $this -> Triviaservice_model ->getQuestionById($questionDtls->QN_ID);				
				$optionsForQuestion = $this -> Triviaservice_model -> getOptionsForQuestionId($questionDtls->QN_ID);
				foreach ($optionsForQuestion as $options) 
				{
					$currdate = $this -> User_model -> getCurrentTimeFromDatabase();
					$quizDtls = $this -> Triviaservice_model -> getQuizDetailsByQuizId($quizId);
					if($currdate[0]->CurrentDate >= $quizDtls[0]->END_TIME)
					{
						$quizDtls[0]->QUIZ_STATUS = 'COMPLETED';
					}
					if(($currdate[0]->CurrentDate < $quizDtls[0]->END_TIME) && ($currdate[0]->CurrentDate >= $quizDtls[0]->START_TIME))
					{
						$quizDtls[0]->QUIZ_STATUS = 'ACTIVE';
					}
					if($currdate[0]->CurrentDate < $quizDtls[0]->START_TIME)
					{
						$quizDtls[0]->QUIZ_STATUS = 'UPCOMING';
					}
					if(($quizDtls[0]->QUIZ_STATUS == 'ACTIVE') && ($currdate[0]->CurrentDate >= $quizDtls[0]->START_TIME))
					{
						$quizendtime = new DateTime($quizDtls[0]->END_TIME);
						$endtime = $quizendtime->format('Y-m-d H:i:s');
						$currTime = new DateTime($currdate[0]->CurrentDate);
						$currentDate = $currTime->format('Y-m-d H:i:s');
						$remaingTime = strval(strtotime($endtime) - strtotime($currentDate));
					}
					//$quiz -> REMAINING_TIME = $remaingTime;
					
					$optionSwitch = $this -> Triviaservice_model -> getPropertyDtlsForPropertyName('OPTION_ANSWER');
					if($currdate[0]->CurrentDate < $quizDtls[0]->END_TIME)
					{
						if($optionSwitch[0]->PROPERTY_VALUE == 0)
						{
							$options->OPT_ANSWER = "";
						}
					}
					if(count($quizQuestionstatusforUser) > 0)
					{
						if(in_array($options->OPT_ID, array_column($quizQuestionstatusforUser, 'OPT_ID')))
						{
							foreach ($quizQuestionstatusforUser as $userStatus) 
							{
								if($userStatus->OPT_ID == $options->OPT_ID)
								{
									$options->OPTION_SELECTED = "TRUE";
								}
							}
						}
						else
						{
							$options->OPTION_SELECTED = "FALSE";
						}
					}
					else
					{
						$options->OPTION_SELECTED = "FALSE";
					}
				}
				shuffle($optionsForQuestion);
				
				$question[0]->OPTIONS = $optionsForQuestion;
				$questionOption[$j] = $question[0];
				$j++;
			}
			shuffle($questionOption);
			$data['Success'] = "true";
			$data['REMAINING_TIME'] = $remaingTime;
			$data['QUIZ_QUESTIONS'] = $questionOption;
			$this -> response($data, 200);
		}
		else
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "No questions for this quiz.";
			$this -> response($data, 200);
		}
	}

	function updateAnswerForQuizBasedOnUser_get()
	{
		//Created by : Ashwini
		$userId = $this -> get('userId');
		if($userId == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter userId";
			$this -> response($data, 200);
		}
		$quizId = $this -> get('quizId');
		if($quizId == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter quizId";
			$this -> response($data, 200);
		}
		$workspace = $this -> get('workspace');
		if($workspace == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter workspace";
			$this -> response($data, 200);
		}
		$userWorkspaceDetails = $this -> User_model -> getWorkspaceForUserByUserId($userId);
		if(!in_array($workspace, array_column($userWorkspaceDetails, 'WS_DESC')))
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Workspace does not exist";
			$this -> response($data, 200);
		}
		$this -> defineTriviaSchema($workspace);

		$questionId = $this -> get('questionId');
		if($questionId == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter questionId";
			$this -> response($data, 200);
		}
		$optionId = $this -> get('optionId');
		// if($optionId == '')
		// {
		// 	$data["Success"] = "false";
		// 	$data["ErrorMsg"] = "Enter optionId";
		// 	$this -> response($data, 200);
		// }
		$finishedQuiz = $this -> get('finishedQuiz');
		if($finishedQuiz == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter finishedQuiz";
			$this -> response($data, 200);
		}
		$optionArray = explode(",", $optionId);
//var_dump($optionArray);
		$quizCompletedStatus = "PENDING";
		$this -> load -> model('Triviaservice_model');
		$message = "";
		$currdate = $this -> User_model -> getCurrentTimeFromDatabase();
		$quizDtls = $this -> Triviaservice_model -> getQuizDetailsByQuizId($quizId);
		if($currdate[0]->CurrentDate >= $quizDtls[0]->END_TIME)
		{
			$quizStatus = 'COMPLETED';
		}
		if(($currdate[0]->CurrentDate < $quizDtls[0]->END_TIME) && ($currdate[0]->CurrentDate >= $quizDtls[0]->START_TIME))
		{
			$quizStatus = 'ACTIVE';
		}
		if($currdate[0]->CurrentDate < $quizDtls[0]->START_TIME)
		{
			$quizStatus = 'UPCOMING';
		}
		if(($quizStatus == 'ACTIVE') && ($currdate[0]->CurrentDate >= $quizDtls[0]->START_TIME))
		{
			$this -> Triviaservice_model -> deleteUserQuizQuestionStatus($userId, $quizId, $questionId); 
			$optionsDtls = $this -> Triviaservice_model -> getOptionsForQuestionId($questionId);
			foreach ($optionArray as $value) 
			{
				foreach ($optionsDtls as $opt) 
				{
					if($value != "")
					{
						if(($opt -> OPT_ID) == ($value))
						{
							if(($opt -> OPT_ANSWER) == "Y")
							{
								$message = "C";
								//$option = $value->OPT_ID;
							}
							else
							{
								$message = "W";
								//$option = $value->OPT_ID;
							}
						}
					}
					else
					{
						$message = "";
						//$option = $value->OPT_ID;
					}
				}
				$checkUserAlreadyAnswered = $this -> Triviaservice_model -> getUserQuizQuesStatusForQuizAndQuestionId($userId, $quizId, $questionId);
				$updatecurrdate = gmdate("Y-m-d H:i:s");

				// if(count($checkUserAlreadyAnswered) > 0)
				// {
				// 	// $optionParam = array('OPT_ID' => $value,
				// 	// 					'ANS_STATUS' => $message,
				// 	// 					'ANS_ON' => $updatecurrdate);
				// 	$this -> Triviaservice_model -> deleteUserQuizQuestionStatus($userId, $quizId, $questionId); 
				// 	$optionParam = array('USER_ID' => $userId,
				// 						'QUIZ_ID' => $quizId,
				// 						'QN_ID' => $questionId,
				// 						'OPT_ID' => $value,
				// 						'ANS_STATUS' => $message,
				// 						'ANS_ON' => $updatecurrdate);
				// 	$this -> Triviaservice_model -> insertUserQuizQuestionStatus($optionParam);
				// }
				// else
				// {
					$optionParam = array('USER_ID' => $userId,
										'QUIZ_ID' => $quizId,
										'QN_ID' => $questionId,
										'OPT_ID' => $value,
										'ANS_STATUS' => $message,
										'ANS_ON' => $updatecurrdate);
					$this -> Triviaservice_model -> insertUserQuizQuestionStatus($optionParam);
				//}
			}
		}

		//to send value in json array
		// foreach ($questionAnswerArray as $value) 
		// {
		// 	$optionsDtls = $this -> Triviaservice_model -> getOptionsForQuestionId($value->QN_ID);
		// 	foreach ($optionsDtls as $opt) 
		// 	{
		// 		if($value->OPT_ID != "")
		// 		{
		// 			if(($opt -> OPT_ID) == ($value->OPT_ID))
		// 			{
		// 				if(($opt -> OPT_ANSWER) == "Y")
		// 				{
		// 					$message = "C";
		// 					$optionId = $value->OPT_ID;
		// 				}
		// 				else
		// 				{
		// 					$message = "W";
		// 					$optionId = $value->OPT_ID;
		// 				}
		// 			}
		// 		}
		// 		else
		// 		{
		// 			$message = "";
		// 			$optionId = "";
		// 		}
		// 	}
		// 	$checkUserAlreadyAnswered = $this -> Triviaservice_model -> getUserQuizQuesStatusForQuizAndQuestionId($userId, $quizId, $value->QN_ID);
		// 	$currdate = gmdate("Y-m-d H:i:s");
		// 	if(count($checkUserAlreadyAnswered) > 0)
		// 	{
		// 		$optionParam = array('OPT_ID' => $optionId,
		// 							'ANS_STATUS' => $message,
		// 							'ANS_ON' => $currdate);
		// 		$this -> Triviaservice_model -> updateUserQuizQuestionStatus($userId, $quizId, $value->QN_ID, $optionParam);
		// 	}
		// 	else
		// 	{
		// 		$optionParam = array('USER_ID' => $userId,
		// 							'QUIZ_ID' => $quizId,
		// 							'QN_ID' => $value->QN_ID,
		// 							'OPT_ID' => $optionId,
		// 							'ANS_STATUS' => $message,
		// 							'ANS_ON' => $currdate);
		// 		$this -> Triviaservice_model -> insertUserQuizQuestionStatus($optionParam);
		// 	}
		// }
		if($currdate[0]->CurrentDate >= $quizDtls[0]->END_TIME)
		{
			$this -> Triviaservice_model -> updateUserQuizStatus($userId, $quizId);
			$questionsIdsForQuiz = $this -> Triviaservice_model -> getQuestionIdsForQuizId($quizId);
			foreach ($questionsIdsForQuiz as $questions) 
			{
				$checkUserAlreadyAnswered = $this -> Triviaservice_model -> getUserQuizQuesStatusForQuizAndQuestionId($userId, $quizId, $questions->QN_ID);
				$updatecurrdate = gmdate("Y-m-d H:i:s");
				
				if(count($checkUserAlreadyAnswered) <= 0)
				{
					$optionParam = array('USER_ID' => $userId,
										'QUIZ_ID' => $quizId,
										'QN_ID' => $questions->QN_ID,
										'OPT_ID' => "",
										'ANS_STATUS' => "",
										'ANS_ON' => $updatecurrdate);
					$this -> Triviaservice_model -> insertUserQuizQuestionStatus($optionParam);
				}
			}
			//$userQuizPoints = $this -> Triviaservice_model -> getUserQuizWiseAnswerCounts($userId,$quizId);
			$pointsDtls =  $this -> getPointsForUserAndQuiz($quizId,$userId);
			$userQuizPoints[0]['USER_ID'] = $userId;
			$userQuizPoints[0]['QUIZ_ID'] = $quizId;
			$userQuizPoints[0]['QUESTION_COUNT'] = strval($pointsDtls[0]['QUESTION_COUNT']);
			$userQuizPoints[0]['CORRECT'] = strval($pointsDtls[0]['POINTS']);
			$userQuizPoints[0]['WRONG'] = strval($pointsDtls[0]['WRONG']);
			$userQuizPoints[0]['NOT_ATTEMPTED'] = strval($pointsDtls[0]['NOT_ATTEMPTED']);
			$quizPoints[0] = (object) $userQuizPoints[0];
			$data['USER_QUIZ_POINTS'] = $quizPoints;
			$quizCompletedStatus = "SYSTEM";
		}
		$data['Success'] = "true";
		if($finishedQuiz == "TRUE")
		{
			$this -> Triviaservice_model -> updateUserQuizStatus($userId, $quizId);
			//$userQuizPoints = $this -> Triviaservice_model -> getUserQuizWiseAnswerCounts($userId,$quizId);
			$pointsDtls =  $this -> getPointsForUserAndQuiz($quizId,$userId);
			$userQuizPoints[0]['USER_ID'] = $userId;
			$userQuizPoints[0]['QUIZ_ID'] = $quizId;
			$userQuizPoints[0]['QUESTION_COUNT'] = strval($pointsDtls[0]['QUESTION_COUNT']);
			$userQuizPoints[0]['CORRECT'] = strval($pointsDtls[0]['POINTS']);
			$userQuizPoints[0]['WRONG'] = strval($pointsDtls[0]['WRONG']);
			$userQuizPoints[0]['NOT_ATTEMPTED'] = strval($pointsDtls[0]['NOT_ATTEMPTED']);
			$quizPoints[0] = (object) $userQuizPoints[0];
			$data['USER_QUIZ_POINTS'] = $quizPoints;
			$quizCompletedStatus = "USER";
			
		}
		//if($quizCompletedStatus != "")
		//{
			$data['QUIZ_COMPLETED_STATUS'] = $quizCompletedStatus;
		//}
		$this -> response($data, 200);
	}
	function getOverallReportForQuiz_get()
	{
		//Created by : Ashwini
		$quizId = $this -> get('quizId');
		if($quizId == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter quizId";
			$this -> response($data, 200);
		}
		$userId = $this -> get('userId');
		if($userId == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter userId";
			$this -> response($data, 200);
		}
		$workspace = $this -> get('workspace');
		if($workspace == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter workspace";
			$this -> response($data, 200);
		}
		$userWorkspaceDetails = $this -> User_model -> getWorkspaceForUserByUserId($userId);
		if(!in_array($workspace, array_column($userWorkspaceDetails, 'WS_DESC')))
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Workspace does not exist";
			$this -> response($data, 200);
		}
		$this -> defineTriviaSchema($workspace);

		$myGrade = "";
		$this -> load -> model('Triviaservice_model');
		$quizDtls = $this -> Triviaservice_model -> getQuizDetailsByQuizId($quizId);
		
		
		$currdate = $this -> User_model -> getCurrentTimeFromDatabase();
		if($currdate[0]->CurrentDate >= $quizDtls[0]->END_TIME)
		{
			$userListForQuiz = $this -> Triviaservice_model -> getUserListFromUserQuizStatus($quizId);
			$gradeDtls =  $this -> Triviaservice_model -> getGradeMstrDtls('QUIZ');
			//$temp = 0;
			//$tempUserId = "";
			//$points = 0;
			//$message = "";
			$totalStudents = count($userListForQuiz);
			$gradecount = 0;
			$i=0;
			$j=0;
			$performArray = array();
			if($totalStudents > 0)
			{
				foreach ($userListForQuiz as $quizUsers) 
				{
					$pointsDtls = $this ->getPointsForUserAndQuiz($quizId,$quizUsers->USER_ID);
					array_push($performArray,$pointsDtls[0]);
				}
				foreach ($gradeDtls as $grade) 
				{
					foreach ($performArray as $perform) 
					{
						if($perform['GRADE'] == $grade->GRADE)
						{
							$gradecount = $gradecount + 1;
						}
					}
					
					//$overAllPerformance[$i]['QUIZ_DESC'] = $performanceDtls[0]->QUIZ_DESC;
					$overAllPerformance[$i]['GRADE'] = $grade->GRADE;
					$overAllPerformance[$i]['GRADE_COUNT'] = strval($gradecount);
					$overAllPerformance[$i]['GRADE_PERCENTAGE'] = strval(round(($gradecount/$totalStudents)*100,0));
					$i++;
					$gradecount = 0;
				}
				//var_dump($performArray);
				if(in_array($userId, array_column($performArray, 'USER_ID')))
				{
					foreach ($performArray as $perform) 
					{
						if($perform['USER_ID'] == $userId)
						{
							$myGrade = $perform['GRADE'];
						}
					}
				}
			}
			else
			{
				foreach ($gradeDtls as $grade) 
				{
					
					//$overAllPerformance[$i]['QUIZ_DESC'] = $performanceDtls[0]->QUIZ_DESC;
					$overAllPerformance[$i]['GRADE'] = $grade->GRADE;
					$overAllPerformance[$i]['GRADE_COUNT'] = strval($gradecount);
					$overAllPerformance[$i]['GRADE_PERCENTAGE'] = strval($totalStudents);
					$i++;
					$gradecount = 0;
				}
			}
			$quizDesc = $quizDtls[0]->QUIZ_DESC;
			
		}
		else
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Quiz not Completed";
			$this -> response($data, 200);
		}
		
		$data['Success'] = "true";
		$data['MY_GRADE'] = $myGrade;
		$data['QUIZ_DESC'] = $quizDesc;
		$data['OVERALL_PERFORMANCE'] = $overAllPerformance;
		$this -> response($data, 200);
	}
	function getPointsForUserAndQuiz($quizId,$userId)
	{
		$performanceDtls = $this -> Triviaservice_model -> getQuizWiseUserPerformance($quizId,$userId);
		$quizDetails = $this -> Triviaservice_model -> getQuizDetailsByQuizId($quizId);
		$gradeDtls =  $this -> Triviaservice_model -> getGradeMstrDtls('QUIZ');
		$temp = 0;
		//$tempUserId = "";
		$points = 0;
		$wrong = 0;
		$notAttempt = 0;
		$message = "";
		$i = 0;
		$quizQuestionCount = count($this -> Triviaservice_model -> getQuestionIdsForQuizId($quizId));
		$Report = array();
		foreach ($performanceDtls as $perform) 
		{
			if($temp != $perform->QN_ID )
			{
				if($perform->ANS_STATUS == "C")
				{
					$message = "CORRECT";
				}
				else if($perform->ANS_STATUS == "W")
				{
					$message = "WRONG";
				}
				else if($perform->ANS_STATUS == "")
				{
					$message = "NOT_ATTEMPTED";
				}
			}
			else if($temp == $perform->QN_ID && $message =="CORRECT")
			{
				if($perform->ANS_STATUS == "C")
				{
					$message = "CORRECT";
				}
				else if($perform->ANS_STATUS == "W")
				{
					$message = "WRONG";
					$points = 0;
					$wrong = $wrong +1;
				}
				else if($perform->ANS_STATUS == "")
				{
					$message = "NOT_ATTEMPTED";
					$points = 0;
					$notAttempt = $notAttempt + 1;
				}
			}
			if($temp != $perform->QN_ID && $message =="WRONG")
			{
				$wrong = $wrong +1;
			}
			if($temp != $perform->QN_ID && $message =="NOT_ATTEMPTED")
			{
				$notAttempt = $notAttempt + 1;
			}
			$temp = $perform->QN_ID;
			if($temp == $perform->QN_ID && $message =="CORRECT")
			{
				$points = $points + 1;
			}
		}
		
		foreach ($gradeDtls as $grade) 
		{
			if($quizQuestionCount>0)
			{
				$percentage = round(($points / $quizQuestionCount) * 100,0);
			}
			else
			{
				$percentage = 0;
			}
			if(($percentage >= $grade->PERCENTAGE_FROM) && ($percentage <= $grade->PERCENTAGE_TO))
			{
				$Report[$i]['USER_ID'] = $userId;
				$Report[$i]['QUIZ_ID'] = $quizId;
				$Report[$i]['QUIZ_DESC'] = $quizDetails[0]->QUIZ_DESC;
				$Report[$i]['QUESTION_COUNT'] = $quizQuestionCount;
				$Report[$i]['POINTS'] = $points;
				$Report[$i]['WRONG'] = $wrong;
				$Report[$i]['NOT_ATTEMPTED'] = $notAttempt;
				$Report[$i]['GRADE'] = $grade->GRADE;
				$i++;
			}
		}
		$points = 0;
		return $Report;
	}
	function defineTriviaSchema($workspace)
	{
		$workSpaceSchema = $this -> User_model -> getWorkspaceByDesc($workspace);
		if(!defined('TIRIVA_SCHEMA')) {
		define('TIRIVA_SCHEMA',$workSpaceSchema[0]->WS_SCHEMA);
		}
	}

	function getWorkspaceEnableStatus_get()
	{
		$workspace = $this -> get('workspace'); 
		$this -> load -> model('Triviaservice_model');
		$this -> load -> model('User_model');
		$response = array();
		$i=-1;
		$gameModeEndTime = "";
		$gameModeStartTime = "";
		$gameMode = "";
		$tempGameMode = ""; 

		$gameModeStatus = $this -> Triviaservice_model -> getGameModeStatusForWorkspace($workspace);
		$currdate = $this -> User_model -> getCurrentTimeFromDatabase();
		if(count($gameModeStatus) > 0)
		{
			foreach($gameModeStatus as $status)
			{
				if((strpos($status->PROPERTY_KEY,"_END_TIME") !== false) || (strpos($status->PROPERTY_KEY,"_START_TIME") !== false))
				{
					if(strpos($status->PROPERTY_KEY,"_END_TIME") !== false)
					{
						$gameMode = explode('_END_TIME', $status->PROPERTY_KEY)[0];
					}
					else if(strpos($status->PROPERTY_KEY,"_START_TIME") !== false)
					{
						$gameMode = explode('_START_TIME', $status->PROPERTY_KEY)[0];
					}			
					
					if($gameMode != $tempGameMode)
					{
						$i++;						

						$gameModeEndTime = "";
						$gameModeStartTime = "";
						
						$response[$i]['GAME_MODE'] = $gameMode;
						if($status->PROPERTY_KEY == $gameMode."_END_TIME")
						{
							$response[$i]['END_TIME'] = $status->PROPERTY_DAT_VALUE;
							$gameModeEndTime = $status->PROPERTY_DAT_VALUE;
						}
						else if($status->PROPERTY_KEY == $gameMode."_START_TIME")
						{
							$response[$i]['START_TIME'] = $status->PROPERTY_DAT_VALUE;
							$gameModeStartTime = $status->PROPERTY_DAT_VALUE;
						}
						if($gameModeStartTime !="" && $gameModeEndTime !="")
						{
							if($gameModeStartTime <= $currdate[0]->CurrentDate && $gameModeEndTime >= $currdate[0]->CurrentDate)
							{
								$response[$i]['LOCK_STATUS'] = "NO";
								$response[$i]['AVAILABLE_ON'] = "";
							}
							else
							{
								$response[$i]['LOCK_STATUS'] = "YES";
								if($gameModeEndTime < $currdate[0]->CurrentDate)
								{
									$response[$i]['AVAILABLE_ON'] = "";
								}
								else if($gameModeStartTime > $currdate[0]->CurrentDate)
								{
									$response[$i]['AVAILABLE_ON'] = $gameModeStartTime;
								}
							}
						}
					}
					else
					{
						if($status->PROPERTY_KEY == $gameMode."_END_TIME")
						{
							$response[$i]['END_TIME'] = $status->PROPERTY_DAT_VALUE;
							$gameModeEndTime = $status->PROPERTY_DAT_VALUE;
						}
						else if($status->PROPERTY_KEY == $gameMode."_START_TIME")
						{
							$response[$i]['START_TIME'] = $status->PROPERTY_DAT_VALUE;
							$gameModeStartTime = $status->PROPERTY_DAT_VALUE;
						}
						if($gameModeStartTime !="" && $gameModeEndTime !="")
						{
							if($gameModeStartTime <= $currdate[0]->CurrentDate && $gameModeEndTime >= $currdate[0]->CurrentDate)
							{
								$response[$i]['LOCK_STATUS'] = "NO";
								$response[$i]['AVAILABLE_ON'] = "";
							}
							else
							{
								$response[$i]['LOCK_STATUS'] = "YES";
								if($gameModeEndTime < $currdate[0]->CurrentDate)
								{
									$response[$i]['AVAILABLE_ON'] = "";
								}
								else if($gameModeStartTime > $currdate[0]->CurrentDate)
								{
									$response[$i]['AVAILABLE_ON'] = $gameModeStartTime;
								}
							}
						}
					}
					$tempGameMode = $gameMode;
				}
			}
		}
		$this -> response($response, 200);
	}	

	function getAllSurveyWithUserPoints_get()
	{
		//Created by : Ashwini
		$userId = $this -> get('userId');
		if($userId == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter userId";
			$this -> response($data, 200);
		}
		$workspace = $this -> get('workspace');
		if($workspace == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter workspace";
			$this -> response($data, 200);
		}
		$userWorkspaceDetails = $this -> User_model -> getWorkspaceForUserByUserId($userId);
		if(!in_array($workspace, array_column($userWorkspaceDetails, 'WS_DESC')))
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Workspace does not exist";
			$this -> response($data, 200);
		}
		$this -> defineTriviaSchema($workspace);
		
		$this -> load -> model('Triviaservice_model');
		$allSurveyDtls = $this -> Triviaservice_model -> getAllActiveSurvey();

		//$points = 0;
		$message = "";
		$currdate = $this -> User_model -> getCurrentTimeFromDatabase();
		foreach ($allSurveyDtls as $survey) 
		{
			if($currdate[0]->CurrentDate >= $survey->END_TIME)
			{
				$this -> Triviaservice_model -> updateUserSurveyStatus($userId, $survey->SURVEY_ID);
			}
		}
		$surveyDetails = $this -> Triviaservice_model -> getAllSurveyWithSurveyStatus($userId);
		foreach ($surveyDetails as $survey) 
		{
			$points = 0;
			$remaingTime = "0";
			if($currdate[0]->CurrentDate >= $survey->END_TIME)
			{
				$survey->SURVEY_STATUS = 'COMPLETED';
			}
			if(($currdate[0]->CurrentDate < $survey->END_TIME) && ($currdate[0]->CurrentDate >= $survey->START_TIME))
			{
				$survey->SURVEY_STATUS = 'ACTIVE';
			}
			if($currdate[0]->CurrentDate < $survey->START_TIME)
			{
				$survey->SURVEY_STATUS = 'UPCOMING';
			}
			if(($survey->SURVEY_STATUS == 'ACTIVE') && ($currdate[0]->CurrentDate >= $survey->START_TIME))
			{
				$surveyendtime = new DateTime($survey->END_TIME);
				$endtime = $surveyendtime->format('Y-m-d H:i:s');
				$currTime = new DateTime($currdate[0]->CurrentDate);
				$currentDate = $currTime->format('Y-m-d H:i:s');
				$remaingTime = strval(strtotime($endtime) - strtotime($currentDate));
			}
			$survey -> REMAINING_TIME = $remaingTime;
			$pointsDtls = $this -> getPointsForUserAndSurvey($survey->SURVEY_ID,$userId);
			if(count($pointsDtls) > 0)
			{
				$survey -> POINTS = strval($pointsDtls[0]['POINTS']);
			}
			else
			{
				$survey -> POINTS = "0";
			}
		}
		
		$data['Success'] = "true";
		$data['SURVEY_DETAILS'] = $surveyDetails;
		$this -> response($data, 200);
	}

	function getAllQuestionsAndOptionsForSurvey_get()
	{
		//Created by : Ashwini
		$userId = $this -> get('userId');
		if($userId == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter userId";
			$this -> response($data, 200);
		}
		$surveyId = $this -> get('surveyId');
		if($surveyId == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter surveyId";
			$this -> response($data, 200);
		}
		$workspace = $this -> get('workspace');
		if($workspace == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter workspace";
			$this -> response($data, 200);
		}
		$userWorkspaceDetails = $this -> User_model -> getWorkspaceForUserByUserId($userId);
		if(!in_array($workspace, array_column($userWorkspaceDetails, 'WS_DESC')))
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Workspace does not exist";
			$this -> response($data, 200);
		}
		$this -> defineTriviaSchema($workspace);

		$remaingTime = "0";
		$this -> load -> model('Triviaservice_model');
		$questionsIdsForSurvey = $this -> Triviaservice_model -> getQuestionIdsForSurveyId($surveyId);
		if(count($questionsIdsForSurvey) > 0)
		{
			$surveyQuestionstatusforUser = $this -> Triviaservice_model -> getsurveyQuestionStatusforUser($surveyId, $userId);

			$surveyStatusForUser = $this -> Triviaservice_model -> getUserSurveyStatus($userId, $surveyId);
			if(count($surveyStatusForUser) <= 0)
			{
				$userStatusParam = array('USER_ID' => $userId,
										'SURVEY_ID' => $surveyId,
										'SURVEY_STATUS' => "O");
				$this -> Triviaservice_model -> insertUserSurveyStatus($userStatusParam);
			}
			$j = 0;
			foreach ($questionsIdsForSurvey as $questionDtls) 
			{
				$question = $this -> Triviaservice_model ->getQuestionById($questionDtls->QN_ID);				
				$optionsForQuestion = $this -> Triviaservice_model -> getOptionsForQuestionId($questionDtls->QN_ID);
				foreach ($optionsForQuestion as $options) 
				{
					$currdate = $this -> User_model -> getCurrentTimeFromDatabase();
					$surveyDtls = $this -> Triviaservice_model -> getSurveyDetailsBySurveyId($surveyId);
					if($currdate[0]->CurrentDate >= $surveyDtls[0]->END_TIME)
					{
						$surveyDtls[0]->SURVEY_STATUS = 'COMPLETED';
					}
					if(($currdate[0]->CurrentDate < $surveyDtls[0]->END_TIME) && ($currdate[0]->CurrentDate >= $surveyDtls[0]->START_TIME))
					{
						$surveyDtls[0]->SURVEY_STATUS = 'ACTIVE';
					}
					if($currdate[0]->CurrentDate < $surveyDtls[0]->START_TIME)
					{
						$surveyDtls[0]->SURVEY_STATUS = 'UPCOMING';
					}
					if(($surveyDtls[0]->SURVEY_STATUS == 'ACTIVE') && ($currdate[0]->CurrentDate >= $surveyDtls[0]->START_TIME))
					{
						$surveyendtime = new DateTime($surveyDtls[0]->END_TIME);
						$endtime = $surveyendtime->format('Y-m-d H:i:s');
						$currTime = new DateTime($currdate[0]->CurrentDate);
						$currentDate = $currTime->format('Y-m-d H:i:s');
						$remaingTime = strval(strtotime($endtime) - strtotime($currentDate));
					}
					//$quiz -> REMAINING_TIME = $remaingTime;
					
					$optionSwitch = $this -> Triviaservice_model -> getPropertyDtlsForPropertyName('OPTION_ANSWER');
					if($currdate[0]->CurrentDate < $surveyDtls[0]->END_TIME)
					{
						if($optionSwitch[0]->PROPERTY_VALUE == 0)
						{
							$options->OPT_ANSWER = "";
						}
					}
					if(count($surveyQuestionstatusforUser) > 0)
					{
						if(in_array($options->OPT_ID, array_column($surveyQuestionstatusforUser, 'OPT_ID')))
						{
							foreach ($surveyQuestionstatusforUser as $userStatus) 
							{
								if($userStatus->OPT_ID == $options->OPT_ID)
								{
									$options->OPTION_SELECTED = "TRUE";
								}
							}
						}
						else
						{
							$options->OPTION_SELECTED = "FALSE";
						}
					}
					else
					{
						$options->OPTION_SELECTED = "FALSE";
					}
				}
				//shuffle($optionsForQuestion);
				
				$question[0]->OPTIONS = $optionsForQuestion;
				$questionOption[$j] = $question[0];
				$j++;
			}
			shuffle($questionOption);
			$data['Success'] = "true";
			$data['REMAINING_TIME'] = $remaingTime;
			$data['SURVEY_QUESTIONS'] = $questionOption;
			$this -> response($data, 200);
		}
		else
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "No questions for this survey.";
			$this -> response($data, 200);
		}
	}

	function updateAnswerForSurveyBasedOnUser_get()
	{
		//Created by : Ashwini
		$userId = $this -> get('userId');
		if($userId == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter userId";
			$this -> response($data, 200);
		}
		$surveyId = $this -> get('surveyId');
		if($surveyId == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter surveyId";
			$this -> response($data, 200);
		}
		$workspace = $this -> get('workspace');
		if($workspace == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter workspace";
			$this -> response($data, 200);
		}
		$userWorkspaceDetails = $this -> User_model -> getWorkspaceForUserByUserId($userId);
		if(!in_array($workspace, array_column($userWorkspaceDetails, 'WS_DESC')))
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Workspace does not exist";
			$this -> response($data, 200);
		}
		$this -> defineTriviaSchema($workspace);

		$questionId = $this -> get('questionId');
		if($questionId == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter questionId";
			$this -> response($data, 200);
		}
		$optionId = $this -> get('optionId');
		// if($optionId == '')
		// {
		// 	$data["Success"] = "false";
		// 	$data["ErrorMsg"] = "Enter optionId";
		// 	$this -> response($data, 200);
		// }
		$finishedSurvey = $this -> get('finishedSurvey');
		if($finishedSurvey == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter finishedSurvey";
			$this -> response($data, 200);
		}
		$optionArray = explode(",", $optionId);
//var_dump($optionArray);
		$surveyCompletedStatus = "PENDING";
		$this -> load -> model('Triviaservice_model');
		$message = "";
		$currdate = $this -> User_model -> getCurrentTimeFromDatabase();
		$surveyDtls = $this -> Triviaservice_model -> getSurveyDetailsBySurveyId($surveyId);
		if($currdate[0]->CurrentDate >= $surveyDtls[0]->END_TIME)
		{
			$surveyStatus = 'COMPLETED';
		}
		if(($currdate[0]->CurrentDate < $surveyDtls[0]->END_TIME) && ($currdate[0]->CurrentDate >= $surveyDtls[0]->START_TIME))
		{
			$surveyStatus = 'ACTIVE';
		}
		if($currdate[0]->CurrentDate < $surveyDtls[0]->START_TIME)
		{
			$surveyStatus = 'UPCOMING';
		}
		if(($surveyStatus == 'ACTIVE') && ($currdate[0]->CurrentDate >= $surveyDtls[0]->START_TIME))
		{
			$this -> Triviaservice_model -> deleteUserSurveyQuestionStatus($userId, $surveyId, $questionId); 
			$optionsDtls = $this -> Triviaservice_model -> getOptionsForQuestionId($questionId);
			foreach ($optionArray as $value) 
			{
				foreach ($optionsDtls as $opt) 
				{
					if($value != "")
					{
						if(($opt -> OPT_ID) == ($value))
						{
							// if(($opt -> OPT_ANSWER) == "Y")
							// {
							// 	$message = "C";
							// 	//$option = $value->OPT_ID;
							// }
							// else
							// {
							// 	$message = "W";
							// 	//$option = $value->OPT_ID;
							// }
							$message = $opt -> OPT_ANSWER;
						}
					}
					else
					{
						$message = "";
						//$option = $value->OPT_ID;
					}
				}
				$checkUserAlreadyAnswered = $this -> Triviaservice_model -> getUserSurveyQuesStatusForSurveyAndQuestionId($userId, $surveyId, $questionId);
				$updatecurrdate = gmdate("Y-m-d H:i:s");

				$optionParam = array('USER_ID' => $userId,
									'SURVEY_ID' => $surveyId,
									'QN_ID' => $questionId,
									'OPT_ID' => $value,
									'ANS_STATUS' => $message,
									'ANS_ON' => $updatecurrdate);
				$this -> Triviaservice_model -> insertUserSurveyQuestionStatus($optionParam);
			}
		}

		if($currdate[0]->CurrentDate >= $surveyDtls[0]->END_TIME)
		{
			$this -> Triviaservice_model -> updateUserSurveyStatus($userId, $surveyId);
			$questionsIdsForSurvey = $this -> Triviaservice_model -> getQuestionIdsForSurveyId($surveyId);
			foreach ($questionsIdsForSurvey as $questions) 
			{
				$checkUserAlreadyAnswered = $this -> Triviaservice_model -> getUserSurveyQuesStatusForSurveyAndQuestionId($userId, $surveyId, $questions->QN_ID);
				$updatecurrdate = gmdate("Y-m-d H:i:s");
				
				if(count($checkUserAlreadyAnswered) <= 0)
				{
					$optionParam = array('USER_ID' => $userId,
										'SURVEY_ID' => $surveyId,
										'QN_ID' => $questions->QN_ID,
										'OPT_ID' => "",
										'ANS_STATUS' => "",
										'ANS_ON' => $updatecurrdate);
					$this -> Triviaservice_model -> insertUserSurveyQuestionStatus($optionParam);
				}
			}
			//$userQuizPoints = $this -> Triviaservice_model -> getUserQuizWiseAnswerCounts($userId,$quizId);
			$pointsDtls =  $this -> getPointsForUserAndSurvey($surveyId,$userId);
			$userSurveyPoints[0]['USER_ID'] = $userId;
			$userSurveyPoints[0]['SURVEY_ID'] = $surveyId;
			$userSurveyPoints[0]['QUESTION_COUNT'] = strval($pointsDtls[0]['QUESTION_COUNT']);
			$userSurveyPoints[0]['POINTS'] = strval($pointsDtls[0]['POINTS']);
			$userSurveyPoints[0]['NOT_ATTEMPTED'] = strval($pointsDtls[0]['NOT_ATTEMPTED']);
			$surveyPoints[0] = (object) $userSurveyPoints[0];
			$data['USER_SURVEY_POINTS'] = $surveyPoints;
			$surveyCompletedStatus = "SYSTEM";
		}
		$data['Success'] = "true";
		if($finishedSurvey == "TRUE")
		{
			$this -> Triviaservice_model -> updateUserSurveyStatus($userId, $surveyId);
			//$userQuizPoints = $this -> Triviaservice_model -> getUserQuizWiseAnswerCounts($userId,$quizId);
			$pointsDtls =  $this -> getPointsForUserAndSurvey($surveyId,$userId);
			$userSurveyPoints[0]['USER_ID'] = $userId;
			$userSurveyPoints[0]['SURVEY_ID'] = $surveyId;
			$userSurveyPoints[0]['QUESTION_COUNT'] = strval($pointsDtls[0]['QUESTION_COUNT']);
			$userSurveyPoints[0]['POINTS'] = strval($pointsDtls[0]['POINTS']);
			$userSurveyPoints[0]['NOT_ATTEMPTED'] = strval($pointsDtls[0]['NOT_ATTEMPTED']);
			$surveyPoints[0] = (object) $userSurveyPoints[0];
			$data['USER_SURVEY_POINTS'] = $surveyPoints;
			$surveyCompletedStatus = "USER";
			
		}
		//if($quizCompletedStatus != "")
		//{
			$data['SURVEY_COMPLETED_STATUS'] = $surveyCompletedStatus;
		//}
		$this -> response($data, 200);
	}
	function getOverallReportForSurvey_get()
	{
		//Created by : Ashwini
		$surveyId = $this -> get('surveyId');
		if($surveyId == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter surveyId";
			$this -> response($data, 200);
		}
		$userId = $this -> get('userId');
		if($userId == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter userId";
			$this -> response($data, 200);
		}
		$workspace = $this -> get('workspace');
		if($workspace == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter workspace";
			$this -> response($data, 200);
		}
		$userWorkspaceDetails = $this -> User_model -> getWorkspaceForUserByUserId($userId);
		if(!in_array($workspace, array_column($userWorkspaceDetails, 'WS_DESC')))
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Workspace does not exist";
			$this -> response($data, 200);
		}
		$this -> defineTriviaSchema($workspace);

		$myGrade = "";
		$myPoints = "";
		$this -> load -> model('Triviaservice_model');
		$surveyDtls = $this -> Triviaservice_model -> getSurveyDetailsBySurveyId($surveyId);
		
		
		$currdate = $this -> User_model -> getCurrentTimeFromDatabase();
		//if($currdate[0]->CurrentDate >= $surveyDtls[0]->END_TIME)
		//{
			$userListForSurvey = $this -> Triviaservice_model -> getUserListFromUserSurveyStatus($surveyId);
			$gradeDtls =  $this -> Triviaservice_model -> getGradeMstrDtls('SURVEY');
			//$temp = 0;
			//$tempUserId = "";
			//$points = 0;
			//$message = "";
			$totalStudents = count($userListForSurvey);
			$gradecount = 0;
			$i=0;
			$j=0;
			$performArray = array();
			if($totalStudents > 0)
			{
				foreach ($userListForSurvey as $surveyUsers) 
				{
					$pointsDtls = $this ->getPointsForUserAndSurvey($surveyId,$surveyUsers->USER_ID);
					array_push($performArray,$pointsDtls[0]);
				}
				foreach ($gradeDtls as $grade) 
				{
					foreach ($performArray as $perform) 
					{
						if($perform['GRADE'] == $grade->GRADE)
						{
							$gradecount = $gradecount + 1;
						}
					}
					
					//$overAllPerformance[$i]['QUIZ_DESC'] = $performanceDtls[0]->QUIZ_DESC;
					$overAllPerformance[$i]['GRADE'] = $grade->GRADE;
					$overAllPerformance[$i]['GRADE_COUNT'] = strval($gradecount);
					$overAllPerformance[$i]['GRADE_PERCENTAGE'] = strval(round(($gradecount/$totalStudents)*100,0));
					$i++;
					$gradecount = 0;
				}
				//var_dump($performArray);
				if(in_array($userId, array_column($performArray, 'USER_ID')))
				{
					foreach ($performArray as $perform) 
					{
						if($perform['USER_ID'] == $userId)
						{
							$myGrade = $perform['GRADE'];
							$myPoints = $perform['POINTS'];
						}
					}
				}
			}
			else
			{
				foreach ($gradeDtls as $grade) 
				{
					
					//$overAllPerformance[$i]['QUIZ_DESC'] = $performanceDtls[0]->QUIZ_DESC;
					$overAllPerformance[$i]['GRADE'] = $grade->GRADE;
					$overAllPerformance[$i]['GRADE_COUNT'] = strval($gradecount);
					$overAllPerformance[$i]['GRADE_PERCENTAGE'] = strval($totalStudents);
					$i++;
					$gradecount = 0;
				}
			}
			$surveyDesc = $surveyDtls[0]->SURVEY_DESC;
			
		// }
		// else
		// {
		// 	$data["Success"] = "false";
		// 	$data["ErrorMsg"] = "Survey not Completed";
		// 	$this -> response($data, 200);
		// }
		
		$data['Success'] = "true";
		$data['MY_GRADE'] = $myGrade;
		$data['MY_POINTS'] = $myPoints;
		$data['SURVEY_DESC'] = $surveyDesc;
		$data['OVERALL_PERFORMANCE'] = $overAllPerformance;
		$this -> response($data, 200);
	}

	function getPointsForUserAndSurvey($surveyId,$userId)
	{
		$performanceDtls = $this -> Triviaservice_model -> getSurveyWiseUserPerformance($surveyId,$userId);
		$surveyDetails = $this -> Triviaservice_model -> getSurveyDetailsBySurveyId($surveyId);
		$gradeDtls =  $this -> Triviaservice_model -> getGradeMstrDtls('SURVEY');
		$temp = 0;
		//$tempUserId = "";
		$points = 0;
		$wrong = 0;
		$notAttempt = 0;
		$message = "";
		$i = 0;
		$surveyQuestionCount = count($this -> Triviaservice_model -> getQuestionIdsForSurveyId($surveyId));
		$Report = array();
		foreach ($performanceDtls as $perform) 
		{
			if($temp != $perform->QN_ID && $perform->ANS_STATUS != "")
			{
				$points = $points + (int)$perform->ANS_STATUS;
			}
			else if($temp!= $perform->QN_ID && $perform->ANS_STATUS == "")
			{
				$notAttempt = $notAttempt + 1;
			}
			$temp = $perform->QN_ID;
		}
		
		foreach ($gradeDtls as $grade) 
		{
			if($surveyQuestionCount>0)
			{
				// $percentage = round(($points / $surveyQuestionCount) * 100,0);
				$percentage = $points;
			}
			else
			{
				$percentage = 0;
			}
			if(($percentage >= (int) $grade->PERCENTAGE_FROM) && ($percentage <= (int)$grade->PERCENTAGE_TO))
			{
				$Report[$i]['USER_ID'] = $userId;
				$Report[$i]['SURVEY_ID'] = $surveyId;
				$Report[$i]['SURVEY_DESC'] = $surveyDetails[0]->SURVEY_DESC;
				$Report[$i]['QUESTION_COUNT'] = (string)$surveyQuestionCount;
				$Report[$i]['POINTS'] = (string)$points;
				$Report[$i]['NOT_ATTEMPTED'] = (string)$notAttempt;
				$Report[$i]['GRADE'] = $grade->GRADE;
				$i++;
			}
		}
		$points = 0;
		return $Report;
	}
	function getRandomCategory($gameMode)
	{
		$this -> load -> model('Triviaservice_model');
		$questionCategoryList = $this -> Triviaservice_model -> getAllQuestionCategory();
		$i = 0;
		foreach($questionCategoryList as $qnCategory)
		{
			$questions = $this -> Triviaservice_model ->getAllQuestionsByCategory($qnCategory->QN_CATEGORY_ID, $gameMode);
			if(count($questions)>0)
			{
				$questionCategory[$i]['QN_CATEGORY_ID'] = $qnCategory->QN_CATEGORY_ID;
				$questionCategory[$i]['QN_CATEGORY'] = $qnCategory->QN_CATEGORY;
				$questionCategory[$i]['QN_CATEGORY_MASCOT'] = $qnCategory->QN_CATEGORY_MASCOT;
				$questionCategory[$i]['STATUS'] = $qnCategory->STATUS;
				$i++;
			}
		}
		$randomCategoryIndex=array_rand($questionCategory,1);
		$randomCategory[0] = (object)$questionCategory[$randomCategoryIndex];
		return  $randomCategory;
	}

	function getTriviathonStrikeStatus_get()
	{
		$gameMode = $this -> get('gameMode');
		if ($gameMode == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter gameMode";
			$this -> response($data, 200);
		}
		$userId = $this -> get('userId');
		if ($userId == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter userId";
			$this -> response($data, 200);
		}
		$workspace = $this -> get('workspace');
		if($workspace == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter workspace";
			$this -> response($data, 200);
		}
		$userWorkspaceDetails = $this -> User_model -> getWorkspaceForUserByUserId($userId);
		$i = 0;
		if(!in_array($workspace, array_column($userWorkspaceDetails, 'WS_DESC')))
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Workspace does not exist";
			$this -> response($data, 200);
		}
		$this -> defineTriviaSchema($workspace);
		
		$workspaceDtls = $this -> User_model -> getWorkspaceByDesc($workspace);

		$this -> load -> model('Triviaservice_model');

		$repeatQuestionSwitch = $this -> Triviaservice_model -> getPropertyDtlsForPropertyName('REPEAT QUESTION');

		//get no. of question that can be attempted in triviathon which includes previous attempt
		$totalDefinedQuestion = $this -> Triviaservice_model -> getPropertyDtlsForPropertyName('TRIVIATHON STREAK');

		//$scoreDetails = $this -> Triviaservice_model -> getScore($userId);
		$totalQuestionAteempted = $this -> Triviaservice_model -> getTotalQuestionsAttemptedForUserBasedonGameMode($userId, $gameMode);
		if($repeatQuestionSwitch[0]->PROPERTY_VALUE == 1)
		{
			if((int)($totalQuestionAteempted[0]->TOTAL_QUESTION_ATTEMPTED) < (int)($totalDefinedQuestion[0] -> PROPERTY_VALUE))
			{
				$data['Success'] = "true";
			}
			else
			{
				$data['Success'] = "false";
				$data['ErrorMsg'] = "Game Mode Completed";
			}
		}
		else
		{
			$data['Success'] = "true";
		}
		
		$this -> response($data, 200);
	}
	
	function insertGameInvite_get()
	{
		$userId = $this -> get('userId');
		$toUserId = $this -> get('toUserId');
		$gameMode = $this -> get('gameMode');

		$status ='I';

		$workspace = $this -> get('workspace');
		if($workspace == '')
		{
			$response["Success"] = "false";
			$response["ErrorMsg"] = "Enter workspace";
			$this -> response($response, 200);
		}

		$this -> load -> model('Triviaservice_model');

		$userWorkspaceDetails = $this -> User_model -> getWorkspaceForUserByUserId($userId);
		$i = 0;
		if(!in_array($workspace, array_column($userWorkspaceDetails, 'WS_DESC')))
		{
			$response["Success"] = "false";
			$response["ErrorMsg"] = "Workspace does not exist";
			$this -> response($response, 200);
		}
		$this -> defineTriviaSchema($workspace);

		$checkRequestAlreadySent = $this -> Triviaservice_model -> checkRequestAlreadySentToOpponent($userId, $toUserId, $gameMode);
		if(count($checkRequestAlreadySent) > 0)
		{
			$response["Success"] = "false";
			$response["ErrorMsg"] = "A game against this opponent is already in progress";
			$this -> response($response, 200);
		}

		$invitationDtlsByUser = $this -> Triviaservice_model -> getInvitationDtlsForUser($userId, 'I');
		$invitationDtlsForUser = $this -> Triviaservice_model -> getInvitationDtlsForUser($toUserId, 'I');
		if(!empty($invitationDtlsByUser) || !empty($invitationDtlsForUser))
		{
			$response["Success"] = "false";
			$response["ErrorMsg"] = "Sorry. An invitation is active against the same user. Please try after sometime.";
			$this -> response($response, 200);
		}

		$this -> Triviaservice_model -> insertGameInvite($userId, $toUserId, $gameMode, $status) ;

		$response["Success"] = "true";
		$response["ErrorMsg"] = "";
		$response['GAME_INVITE_ID'] = $this -> db -> insert_id();
		$response['STATUS'] = $status;

		$this -> response($response);
	}
	
	function getInvitationStatus_get()
	{
		$userId = $this -> get('userId');
		$invitationId = $this -> get('invitationId');
		$lastRecivedStatus = $this -> get('lastRecivedStatus');

		$workspace = $this -> get('workspace');
		if($workspace == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter workspace";
			$this -> response($data, 200);
		}
		
		$userWorkspaceDetails = $this -> User_model -> getWorkspaceForUserByUserId($userId);
		$i = 0;
		if(!in_array($workspace, array_column($userWorkspaceDetails, 'WS_DESC')))
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Workspace does not exist";
			$this -> response($data, 200);
		}
		$this -> defineTriviaSchema($workspace);

		$this -> load -> model('Triviaservice_model');

		//Update the non-responded invitations sent by the user based on time. 
		$this -> Triviaservice_model -> updateGameInvitationsByUserIdOnTime($userId);

		$invitationDtls = $this -> Triviaservice_model -> getInvitationDtlsForId($invitationId);
		$currentStatus = $invitationDtls[0] -> STATUS;

		$response = array();

		if($lastRecivedStatus != $currentStatus)
		{
			if($currentStatus == 'A')
			{
				$response['MESSAGE'] = 'ACCEPTED';
			}
			else if($currentStatus == 'NR')
			{
				$response['MESSAGE'] = 'NOT RESPONDED';
			}
			else
			{
				$response['MESSAGE'] = 'REJECTED';
			}
		}
		else
		{
			$response['MESSAGE'] = 'WAITING';
		}

		$this -> response($response, 200);
	}

	function getGameInvitationsForUser_get()
	{
		$userId = $this -> get('userId');
		$status = 'I';

		$workspace = $this -> get('workspace');
		if($workspace == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter workspace";
			$this -> response($data, 200);
		}
		
		$userWorkspaceDetails = $this -> User_model -> getWorkspaceForUserByUserId($userId);
		$i = 0;
		if(!in_array($workspace, array_column($userWorkspaceDetails, 'WS_DESC')))
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Workspace does not exist";
			$this -> response($data, 200);
		}
		$this -> defineTriviaSchema($workspace);

		$this -> load -> model('Triviaservice_model');

		//Update the non-responded invitations recived by the user based on time. 
		$this -> Triviaservice_model -> updateGameInvitationsForUserIdOnTime($userId);

		$invitationDtls = $this -> Triviaservice_model -> getInvitationDtlsForUser($userId, $status);

		$pollIntervalDtls = $this -> Triviaservice_model -> getPropertyDtlsForPropertyName('POLL INTERVAL');

		$response['INVITATION_DTLS'] = $invitationDtls;
		$response['POLL_INTERVAL'] = $pollIntervalDtls;

		$this -> response($response, 200);
	}

	function updateGameInvitaion_get()
	{
		$userId = $this -> get('userId');
		$invitationId = $this -> get('invitationId');
		$status = $this -> get('status');

		$workspace = $this -> get('workspace');
		if($workspace == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter workspace";
			$this -> response($data, 200);
		}
		
		$userWorkspaceDetails = $this -> User_model -> getWorkspaceForUserByUserId($userId);
		$i = 0;
		if(!in_array($workspace, array_column($userWorkspaceDetails, 'WS_DESC')))
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Workspace does not exist";
			$this -> response($data, 200);
		}
		$this -> defineTriviaSchema($workspace);

		$this -> load -> model('Triviaservice_model');

		$invitationDtls = $this -> Triviaservice_model -> getInvitationDtlsForId($invitationId);
		$currentStatus = $invitationDtls[0] -> STATUS;

		if($currentStatus == 'NR')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "The validity of the game request is over. Please initiate a new game request.";
		}
		else
		{
			$this -> Triviaservice_model -> updateGameInvitationForUserId($status, $invitationId);
		
			$data["Success"] = "true";
			$data["ErrorMsg"] = "";
		}
		
		$this -> response ($data, 200);
	}

	function getMyTurnGamesForUser_get()
	{
		$userId = $this -> get('userId');

		$workspace = $this -> get('workspace');
		if($workspace == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter workspace";
			$this -> response($data, 200);
		}
		
		$userWorkspaceDetails = $this -> User_model -> getWorkspaceForUserByUserId($userId);
		$i = 0;
		if(!in_array($workspace, array_column($userWorkspaceDetails, 'WS_DESC')))
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Workspace does not exist";
			$this -> response($data, 200);
		}
		$this -> defineTriviaSchema($workspace);

		$this -> load -> model('Triviaservice_model');

		$myTurnGames = $this -> Triviaservice_model -> getGameDtlsForUserandStatus($userId, 'P');
		
		$this -> response ($myTurnGames, 200);
	}

	function getGameResultsForNotification_get()
	{
		$userId = $this -> get('userId');

		$workspace = $this -> get('workspace');
		if($workspace == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter workspace";
			$this -> response($data, 200);
		}
		
		$userWorkspaceDetails = $this -> User_model -> getWorkspaceForUserByUserId($userId);
		$i = 0;
		if(!in_array($workspace, array_column($userWorkspaceDetails, 'WS_DESC')))
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Workspace does not exist";
			$this -> response($data, 200);
		}
		$this -> defineTriviaSchema($workspace);

		$this -> load -> model('Triviaservice_model');

		$gamesWon = $this -> Triviaservice_model -> getGameDtlsForUserandStatus($userId, 'W');
		$gamesLost = $this -> Triviaservice_model -> getGameDtlsForUserandStatus($userId, 'L');
		$gamesDraw = $this -> Triviaservice_model -> getGameDtlsForUserandStatus($userId, 'D');

		foreach($gamesWon as $row)
		{
			$ugdId = $row -> UGD_ID;
			$userGameStatus = $this -> Triviaservice_model -> getUserGameStatusDetails($row -> UGS_ID);
			$oppCorrectAnswerCount = $this -> Triviaservice_model -> getTotalCorrectCountForUserBasedonGameMode($row->USER_ID, $userGameStatus[0]->GAME_MODE,$row -> UGS_ID);
			$row->OPP_POINTS = $oppCorrectAnswerCount[0]->TOTAL_CORRECT_ANSWER;
			$myCorrectAnswerCount = $this -> Triviaservice_model -> getTotalCorrectCountForUserBasedonGameMode($userId, $userGameStatus[0]->GAME_MODE,$row -> UGS_ID);
			$row->MY_POINTS = $myCorrectAnswerCount[0]->TOTAL_CORRECT_ANSWER;
			$this -> Triviaservice_model -> updateWinnerNotificationForGameData($ugdId);
		}
		foreach($gamesLost as $row)
		{
			$ugdId = $row -> UGD_ID;
			$userGameStatus = $this -> Triviaservice_model -> getUserGameStatusDetails($row -> UGS_ID);
			$oppCorrectAnswerCount = $this -> Triviaservice_model -> getTotalCorrectCountForUserBasedonGameMode($row->USER_ID, $userGameStatus[0]->GAME_MODE,$row -> UGS_ID);
			$row->OPP_POINTS = $oppCorrectAnswerCount[0]->TOTAL_CORRECT_ANSWER;
			$myCorrectAnswerCount = $this -> Triviaservice_model -> getTotalCorrectCountForUserBasedonGameMode($userId, $userGameStatus[0]->GAME_MODE,$row -> UGS_ID);
			$row->MY_POINTS = $myCorrectAnswerCount[0]->TOTAL_CORRECT_ANSWER;
			$this -> Triviaservice_model -> updateWinnerNotificationForGameData($ugdId);
		}
		foreach($gamesDraw as $row)
		{
			$ugdId = $row -> UGD_ID;
			$userGameStatus = $this -> Triviaservice_model -> getUserGameStatusDetails($row -> UGS_ID);
			$oppCorrectAnswerCount = $this -> Triviaservice_model -> getTotalCorrectCountForUserBasedonGameMode($row->USER_ID, $userGameStatus[0]->GAME_MODE,$row -> UGS_ID);
			$row->OPP_POINTS = $oppCorrectAnswerCount[0]->TOTAL_CORRECT_ANSWER;
			$myCorrectAnswerCount = $this -> Triviaservice_model -> getTotalCorrectCountForUserBasedonGameMode($userId, $userGameStatus[0]->GAME_MODE,$row -> UGS_ID);
			$row->MY_POINTS = $myCorrectAnswerCount[0]->TOTAL_CORRECT_ANSWER;
			$this -> Triviaservice_model -> updateWinnerNotificationForGameData($ugdId);
		}
		$response['GAMES_WON'] = $gamesWon;
		$response['GAMES_LOST'] = $gamesLost;
		$response['GAMES_DRAW'] = $gamesDraw;
		
		$this -> response ($response, 200);
	}
}
?>
