<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Dashboard_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
        $this -> db = $this->load->database('stratup', TRUE);
    }
    
    function NoofYearsPlayed($gameId)
    {
        $sql = ('SELECT 
                    GETYEAR(max(MOVE_NO)) AS Year 
                 FROM game_play_movement_tbl 
                 WHERE GAME_ID=?');
        $query = $this -> db -> query($sql,array($gameId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function CurrentMove($teamId)
    {
        $sql = ('select max(MOVE_NO) as MoveNo from game_play_movement_tbl where team_id=?');
        $query = $this -> db -> query($sql,array($teamId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    
    function qtrwiseIncomeAndExpenseByTrans($transFor,$teamId)
    {
        $sql = ('SELECT 
                    TRIM(TRANSACTION_FOR) AS Heads,
                    GETYEAR(MOVE_NO) AS Year,
                    GETQTR(MOVE_NO, GETYEAR(MOVE_NO)) AS Qtr,
                    ROUND(sum(AMOUNT)) AS Amount
                FROM
                    department_income_expend_transaction_tbl
                WHERE
                    TEAM_ID = ?
                        AND TRANSACTION_FOR in ?
                GROUP BY 1 , 2 , 3
                ORDER BY 2 , 3');
        $query = $this -> db -> query($sql,array($teamId,$transFor));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function mktproductAllocatedList($teamId)
    {
        $sql = ('SELECT mmt.MKT_MAIN_ID,
                    PRODUCTION_ALLOCATION_ID AS OrderId,
                    MOVE_NO AS MoveNo,
                    GETYEAR(MOVE_NO) AS Year,
                    GETQTR(MOVE_NO, GETYEAR(MOVE_NO)) AS Qtr,
                    pm.PRODUCT_desc AS ProductName,
                    SUM(NO_OF_PRODUCTS) AS AllotedUnits,
                    ROUND(AVG(PRODUCT_PRICE)) AS AvgPrice,
                    mmt.team_id  AS teamId
                FROM
                    mkt_main_tbl mmt
                        INNER JOIN
                    mkt_territory_product_allocation_tbl mpa ON mpa.MKT_MAIN_ID = mmt.MKT_MAIN_ID
                        INNER JOIN
                    opr_product_game_mstr pm ON pm.PRODUCT_ID = mpa.PRODUCT_ID
                WHERE
                    mmt.team_id = ?
                        AND MKT_ACTIONS_ID = 1 and move_no>0
                GROUP BY 1 ,3');
        $query = $this -> db -> query($sql,array($teamId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function mktproductAllocated($teamId)
    {
        $sql = ('SELECT 
                    IFNULL(SUM(NO_OF_PRODUCTS),0) AS PRODUCTS_ALLOTED
                FROM
                    mkt_territory_product_allocation_tbl mtpat 
                    INNER JOIN mkt_main_tbl mmt on mmt.MKT_MAIN_ID=mtpat.MKT_MAIN_ID
                WHERE
                    mtpat.team_id = ? and move_no>0');
        $query = $this -> db -> query($sql,array($teamId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function productSold($teamId)
    {
        $sql = ('SELECT 
                    IFNULL(SUM(PRODUCTS_SOLD),0) AS PRODUCTS_SOLD
                FROM
                    mkt_sales_section_f_tbl
                WHERE
                    team_id = ? and move_no>0');
        $query = $this -> db -> query($sql,array($teamId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function mktProdAllocatandSoldProdwise($teamId,$gameId)
    {
        $sql = ('SELECT pm.PRODUCT_DESC,IFNULL(PRODUCTS_ALLOCATED,0)PRODUCTS_ALLOCATED,
                        IFNULL(PRODUCTS_SOLD,0)PRODUCTS_SOLD
                    FROM  
                        opr_product_game_mstr pm 
                        LEFT JOIN(SELECT PRODUCT_ID,
                                        SUM(PRODUCTS_SOLD) AS PRODUCTS_SOLD
                                    FROM
                                        mkt_sales_section_f_tbl 
                                    WHERE
                                        team_id = ? and move_no>0 GROUP BY PRODUCT_ID)A
                                        ON pm.PRODUCT_ID=A.PRODUCT_ID
                             LEFT JOIN (SELECT PRODUCT_ID,
                                         SUM(NO_OF_PRODUCTS) AS PRODUCTS_ALLOCATED
                                    FROM
                                        mkt_territory_product_allocation_tbl mtpat 
                                        INNER JOIN mkt_main_tbl mmt on mmt.MKT_MAIN_ID=mtpat.MKT_MAIN_ID
                                    WHERE
                                        mtpat.team_id = ? and mmt.move_no>0 group by PRODUCT_ID)B
                             ON pm.PRODUCT_ID=B.PRODUCT_ID WHERE pm.game_id=?');
        $query = $this -> db -> query($sql,array($teamId, $teamId, $gameId));
        return $query -> result_array();
    }
    function awarenessandAdvertise($teamId)
    {
        $sql = ('SELECT 
                    IFNULL(SUM(AWARNESS_CREATED),0) AS AWARNESS_SCORE, IFNULL(SUM(ADVERTISEMENT_COST),0) AS ADVERTISEMENT_COST
                FROM
                    mkt_territory_advertisement_tbl mtpat 
                    INNER JOIN mkt_main_tbl mmt ON mmt.MKT_MAIN_ID=mtpat.MKT_MAIN_ID
                WHERE
                    mtpat.team_id = ? and mmt.move_no>0 ');
        $query = $this -> db -> query($sql,array($teamId));
        return $query -> result_array();
    }
    function distributionCost($teamId)
    {
        $sql = ('SELECT 
                    IFNULL(SUM(MARGIN_COST),0) AS MARGIN_COST 
                 FROM  
                    (SELECT 
                        SUM(MARGIN_COST) MARGIN_COST,mtdet.DISTRIBUTION_MAIN_ID 
                     FROM 
                        mkt_territory_distribution_ecommerce_tbl mtdet
                        INNER JOIN mkt_distribution_main_tbl distMainTbl 
                            ON distMainTbl.DISTRIBUTION_MAIN_ID = mtdet.DISTRIBUTION_MAIN_ID
                        INNER JOIN mkt_main_tbl mainTbl 
                            ON mainTbl.MKT_MAIN_ID = distMainTbl.MKT_MAIN_ID 
                     WHERE mainTbl.TEAM_ID = ? AND mainTbl.move_no>0
                 union 
                    SELECT 
                        SUM(MARGIN_COST) MARGIN_COST,mtdnet.DISTRIBUTION_MAIN_ID 
                    FROM 
                        mkt_territory_distribution_non_ecommerce_tbl mtdnet
                        INNER JOIN mkt_distribution_main_tbl distMainTbl 
                            ON distMainTbl.DISTRIBUTION_MAIN_ID = mtdnet.DISTRIBUTION_MAIN_ID
                        INNER JOIN mkt_main_tbl mainTbl 
                            ON mainTbl.MKT_MAIN_ID = distMainTbl.MKT_MAIN_ID 
                    WHERE mainTbl.TEAM_ID = ? AND mainTbl.move_no>0)A');
        $query = $this -> db -> query($sql,array($teamId,$teamId));
        return $query -> result_array();
    }
    function productProduction($teamId)
    {
        $sql = ('SELECT IFNULL(SUM(NO_OF_UNITS_PLACED),0) AS PRODUCTS_ALLOCATED,
                    IFNULL(SUM(NO_OF_UNITS_PLACED)-sum(SHORTAGE_DUE_TO_PLANT_CAPACITY+
                    SHORTAGE_DUE_TO_MACHINE_CAPACITY +
                    SHORTGE_DUE_TO_OPERATOR_EFFECTIVENESS +
                    SHORTAGE_DUE_TO_OPERATOR_AVAILABILITY +
                    REJECTION_DUE_TO_MACHINERY +
                    REJECTION_DUE_TO_WAREHOUSE +
                    REJECTION_DUE_TO_SUPPLIER +
                    REJECTION_DUE_TO_PACKAGING),0)AS PRODUCTS_PRODUCED,
                    IFNULL(round((SUM(NO_OF_UNITS_PLACED)-sum(SHORTAGE_DUE_TO_PLANT_CAPACITY+
                    SHORTAGE_DUE_TO_MACHINE_CAPACITY +
                    SHORTGE_DUE_TO_OPERATOR_EFFECTIVENESS +
                    SHORTAGE_DUE_TO_OPERATOR_AVAILABILITY +
                    REJECTION_DUE_TO_MACHINERY +
                    REJECTION_DUE_TO_WAREHOUSE +
                    REJECTION_DUE_TO_SUPPLIER +
                    REJECTION_DUE_TO_PACKAGING))/SUM(NO_OF_UNITS_PLACED)*100),0) PRODUCTION_EFFICIENCY
                FROM 
                   opr_production_main_tbl opmt 
                   INNER JOIN opr_main_tbl omt ON omt.OPR_MAIN_ID = opmt.OPR_MAIN_ID
                WHERE
                    omt.TEAM_ID = ? AND move_no>0');
        $query = $this -> db -> query($sql,array($teamId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function productWiseAllocatedProduced($teamId,$gameId)
    {
        $sql = ('SELECT
                     PRODUCT_DESC,IFNULL(a.PRODUCTS_PRODUCED,0) PRODUCTS_PRODUCED,
                     IFNULL(a.NO_OF_UNITS_PLACED,0) AS PRODUCTS_ALLOCATED  
                 FROM 
                     opr_product_game_mstr opgm
                    LEFT JOIN 
                        (SELECT 
                            opmt.Product_ID,(SUM(NO_OF_UNITS_PLACED)-sum(SHORTAGE_DUE_TO_PLANT_CAPACITY+
                            SHORTAGE_DUE_TO_MACHINE_CAPACITY +
                            SHORTGE_DUE_TO_OPERATOR_EFFECTIVENESS +
                            SHORTAGE_DUE_TO_OPERATOR_AVAILABILITY +
                            REJECTION_DUE_TO_MACHINERY +
                            REJECTION_DUE_TO_WAREHOUSE +
                            REJECTION_DUE_TO_SUPPLIER +
                            REJECTION_DUE_TO_PACKAGING))AS PRODUCTS_PRODUCED,
                            SUM(NO_OF_UNITS_PLACED) NO_OF_UNITS_PLACED
                        FROM 
                            opr_production_main_tbl opmt
                            INNER JOIN opr_main_tbl omt ON opmt.opr_main_id = omt.opr_main_id
                        WHERE
                             omt.TEAM_ID = ? AND omt.move_no>0 GROUP BY opmt.Product_ID)a 
                             ON a.Product_ID = opgm.Product_ID 
               WHERE game_id=?');
        $query = $this -> db -> query($sql,array($teamId,$gameId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function productsInventory($teamId)
    {
        $sql = ('SELECT 
                    coalesce(SUM(OPAT.NO_OF_UNITS), 0)TOTAL_NO_OF_PRODUCTS
                 FROM 
                    OPR_PRODUCTS_AVAILABILTY_TBL OPAT
                    LEFT JOIN OPR_PRODUCT_GAME_MSTR OPGM ON OPGM.PRODUCT_ID = OPAT.PRODUCT_ID
                 WHERE  OPAT.TEAM_ID = ? ');
        $query = $this -> db -> query($sql,array($teamId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function stgproductAllocated($teamId)
    {
        $sql = ('SELECT 
                    IFNULL(SUM(NO_OF_UNITS),0) PRODUCTS_ALLOCATED 
                 FROM 
                    strgy_product_allocation_tbl spat
                    INNER JOIN strgy_main_tbl smt ON smt.STRATEGY_MAIN_ID = spat.STRATEGY_MAIN_ID 
                 WHERE smt.TEAM_ID = ? AND move_no>0');
        $query = $this -> db -> query($sql,array($teamId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function stgproductSold($teamId)
    {
        $sql = ('SELECT
                     IFNULL(sum(NO_OF_UNITS_SOLD),0) PRODUCTS_SOLD 
                 FROM 
                     strgy_sales_main_tbl ssmt
                     INNER JOIN strgy_product_allocation_tbl spat 
                     ON ssmt.PRODUCT_ALLOCATION_ID = spat.STRGY_PRODUCT_ALLOCATION_ID
                     INNER JOIN strgy_main_tbl smt ON smt.STRATEGY_MAIN_ID = spat.STRATEGY_MAIN_ID 
                WHERE smt.TEAM_ID = ? AND move_no>0');
        $query = $this -> db -> query($sql,array($teamId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function stgTotalRevenue($teamId)
    {
        $sql = ('SELECT
                     IFNULL(sum(REVENUE),0) REVENUE 
                 FROM 
                     strgy_sales_main_tbl ssmt
                     INNER JOIN strgy_product_allocation_tbl spat 
                     ON ssmt.PRODUCT_ALLOCATION_ID = spat.STRGY_PRODUCT_ALLOCATION_ID
                     INNER JOIN strgy_main_tbl smt ON smt.STRATEGY_MAIN_ID = spat.STRATEGY_MAIN_ID 
                WHERE smt.TEAM_ID = ? AND move_no>0');
        $query = $this -> db -> query($sql,array($teamId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function stgProdAllocatandSoldCounwise($teamId)
    {
        $sql = ('SELECT COUNTRY_DESC,
                        IFNULL(PRODUCTS_ALLOCATED,0) PRODUCTS_ALLOCATED,
                        IFNULL(PRODUCTS_SOLD,0) PRODUCTS_SOLD 
                 FROM 
                    strgy_country_game_mstr scgm
                    LEFT JOIN 
                        (SELECT SUM(ssmt.NO_OF_UNITS_SOLD) PRODUCTS_SOLD,
                                SUM(spat.NO_OF_UNITS) PRODUCTS_ALLOCATED,
                                smt.COUNTRY_ID 
                         FROM 
                            strgy_sales_main_tbl ssmt 
                            INNER JOIN strgy_product_allocation_tbl spat 
                            ON ssmt.PRODUCT_ALLOCATION_ID = spat.STRGY_PRODUCT_ALLOCATION_ID
                            INNER JOIN strgy_main_tbl smt ON smt.STRATEGY_MAIN_ID = spat.STRATEGY_MAIN_ID 
                        WHERE 
                            smt.TEAM_ID = ? AND smt.move_no>0 GROUP BY smt.COUNTRY_ID)A 
                   ON A.COUNTRY_ID = scgm.COUNTRY_ID 
               WHERE scgm.TEAM_ID = ?');
        $query = $this -> db -> query($sql,array($teamId,$teamId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function stgModeWiseRevenue($teamId)
    {
        $sql = ('SELECT MODE_OF_ENTRY,IFNULL(REVENUE,0) REVENUE
                 FROM 
                    strgy_mode_of_entry_game_mstr smegm
                    LEFT JOIN 
                        (SELECT smt.MODE_OF_ENTRY_ID,SUM(REVENUE) REVENUE 
                         FROM 
                            strgy_sales_main_tbl ssmt
                            INNER JOIN strgy_product_allocation_tbl spat 
                            ON spat.STRGY_PRODUCT_ALLOCATION_ID = ssmt.PRODUCT_ALLOCATION_ID
                            INNER JOIN strgy_main_tbl smt ON smt.STRATEGY_MAIN_ID = spat.STRATEGY_MAIN_ID 
                         WHERE smt.TEAM_ID = ? AND move_no>0 GROUP BY smt.MODE_OF_ENTRY_ID)A 
                    ON A.MODE_OF_ENTRY_ID = smegm.MODE_OF_ENTRY_ID 
                WHERE smegm.TEAM_ID = ?');
        $query = $this -> db -> query($sql,array($teamId,$teamId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function stgPartnerhareRevenue($teamId)
    {
        $sql = ('SELECT IFNULL(Round(Avg(PRICE_OF_PRODUCT))*Sum(PARTNERSHIP_SHARE),0) PARTNER_REVENUE 
                 FROM 
                    strgy_sales_main_tbl ssmt
                    INNER JOIN strgy_product_allocation_tbl spat 
                    ON spat.STRGY_PRODUCT_ALLOCATION_ID = ssmt.PRODUCT_ALLOCATION_ID
                    INNER JOIN strgy_main_tbl smt ON smt.STRATEGY_MAIN_ID = spat.STRATEGY_MAIN_ID 
                WHERE smt.TEAM_ID = ? AND move_no>0');
        $query = $this -> db -> query($sql,array($teamId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function stgCounCulturalScore($teamId)
    {
        $sql = ('SELECT COUNTRY_DESC,IFNULL(SCORE,0) SCORE 
                 FROM  
                    strgy_country_game_mstr scgm
                    LEFT JOIN
                        (SELECT Sum(SCORE) SCORE,COUNTRY_ID 
                         FROM 
                            strgy_main_tbl smt 
                            INNER JOIN strgy_cultural_sensitivity_qna_tbl scsqt 
                            ON scsqt.STRATEGY_MAIN_ID = smt.STRATEGY_MAIN_ID
                         WHERE smt.TEAM_ID = ? AND smt.move_no>0 GROUP BY smt.COUNTRY_ID)A 
                    ON A.COUNTRY_ID = scgm.COUNTRY_ID 
                WHERE scgm.TEAM_ID = ?');
        $query = $this -> db -> query($sql,array($teamId,$teamId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function stgCulturalScore($teamId)
    {
        $sql = ('SELECT IFNULL(Sum(SCORE),0) SCORE
                 FROM 
                    strgy_main_tbl smt 
                    INNER JOIN strgy_cultural_sensitivity_qna_tbl scsqt 
                            ON scsqt.STRATEGY_MAIN_ID = smt.STRATEGY_MAIN_ID
                         WHERE smt.TEAM_ID = ? AND smt.move_no>0 ');
        $query = $this -> db -> query($sql,array($teamId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function itCostBreakup($teamId,$transFor)
    {
        $sql = ('SELECT 
                    IFNULL(SUM(CASE
                        WHEN BUDGET_HEAD = "IT SOFTWARE COST" THEN AMOUNT
                    END),0) AS IT_SOFTWARE_COST,
                    IFNULL(SUM(CASE
                        WHEN BUDGET_HEAD = "IT HARDWARE COST" THEN AMOUNT
                    END),0) AS IT_HARDWARE_COST,
                    IFNULL(SUM(CASE
                        WHEN BUDGET_HEAD = "IT FIXED COST" THEN AMOUNT
                    END),0) AS IT_FIXED_COST
                FROM
                    department_income_expend_transaction_tbl incexp
                        JOIN
                    budget_head_game_mstr hedgme ON incexp.BUDGET_HEAD_ID = hedgme.BUDGET_HEAD_ID
                WHERE incexp.team_id = ?
                        AND incexp.move_no >0 AND BUDGET_HEAD IN ? ');
        $query = $this -> db -> query($sql,array($teamId,$transFor));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function hrTotalAllocatvsAccept($teamId)
    {
        $sql = ('SELECT IFNULL(SUM(NO_OF_EMPLOYEES_NEEDED),0)NO_OF_EMPLOYEES_NEEDED,
                        IFNULL(SUM(NO_OF_EMPLOYEES_NEEDED)-
                            SUM(CONVERSION_LOSS_DUE_TO_CHANNEL+
                                CONVERSION_LOSS_DUE_TO_SALARY+
                                CONVERSION_LOSS_DUE_TO_BRAND_IMG),0) NO_OF_PEOPLE_ACCEPTED,
                        IFNULL(round((SUM(NO_OF_EMPLOYEES_NEEDED) - 
                                      SUM(CONVERSION_LOSS_DUE_TO_CHANNEL + 
                                          CONVERSION_LOSS_DUE_TO_SALARY + 
                                          CONVERSION_LOSS_DUE_TO_BRAND_IMG))
                                        /SUM(NO_OF_EMPLOYEES_NEEDED)*100),0)RECRUITMENT_EFFICIENCY_PERCENT
                 FROM 
                    hr_recruitment_tbl 
                 WHERE team_id = ? AND MOVE_NO>0');
        $query = $this -> db -> query($sql,array($teamId));
        return $query -> result_array();
    }
    function hrAttritionPercent($teamId)
    {
        $sql = ('SELECT A.NO_OF_EMPLOYEES,C.NO_OF_PEOPLE_ACCEPTED,B.ATTRITION_COUNT,
                        IFNULL(ROUND(B.ATTRITION_COUNT/(A.NO_OF_EMPLOYEES+C.NO_OF_PEOPLE_ACCEPTED)*100),0)ATTRITION_PERCENT
                 FROM        
                    (SELECT IFNULL(SUM(NO_OF_EMPLOYEES),0)AS NO_OF_EMPLOYEES,TEAM_ID
                     FROM 
                        hr_employee_tbl_audit  
                     WHERE TEAM_ID = ? AND MOVE_NO=0)A
                     LEFT JOIN
                     (SELECT IFNULL(SUM(NO_OF_PEOPLE),0)AS ATTRITION_COUNT,TEAM_ID
                      FROM 
                        hr_attrition_tbl  
                      WHERE TEAM_ID = ?)B ON A.TEAM_ID = B.TEAM_ID
                     LEFT JOIN
                     (SELECT IFNULL(sum(NO_OF_EMPLOYEES_NEEDED)-
                             SUM(CONVERSION_LOSS_DUE_TO_CHANNEL+
                                 CONVERSION_LOSS_DUE_TO_SALARY+
                                 CONVERSION_LOSS_DUE_TO_BRAND_IMG),0)AS NO_OF_PEOPLE_ACCEPTED,TEAM_ID
                     FROM 
                        hr_recruitment_tbl 
                     WHERE TEAM_ID = ? AND MOVE_NO>0)C ON C.TEAM_ID = B.TEAM_ID');
        $query = $this -> db -> query($sql,array($teamId,$teamId,$teamId));
        return $query -> result_array();
    }
    function hrDesignWiseRecruit($teamId,$gameId)
    {
        $sql = ('SELECT DESIGNATION_NAME,
                        IFNULL(NO_OF_EMPLOYEES_NEEDED,0)NO_OF_EMPLOYEES_NEEDED,
                        IFNULL(NO_OF_PEOPLE_ACCEPTED,0) NO_OF_PEOPLE_ACCEPTED
                 FROM 
                    hr_designation_game_mstr hdgm
                    LEFT JOIN
                        (SELECT DESIGNATION_ID, 
                                SUM(NO_OF_EMPLOYEES_NEEDED)NO_OF_EMPLOYEES_NEEDED,
                                (SUM(NO_OF_EMPLOYEES_NEEDED)-
                                SUM(CONVERSION_LOSS_DUE_TO_CHANNEL+
                                CONVERSION_LOSS_DUE_TO_SALARY+
                                CONVERSION_LOSS_DUE_TO_BRAND_IMG)) NO_OF_PEOPLE_ACCEPTED
                        FROM 
                            hr_recruitment_tbl hrt
                        WHERE hrt.TEAM_ID = ? AND hrt.MOVE_NO>0  GROUP BY hrt.DESIGNATION_ID)A
                     ON hdgm.DESIGNATION_ID = A.DESIGNATION_ID
                 WHERE hdgm.GAME_ID = ?');
        $query = $this -> db -> query($sql,array($teamId,$gameId));
        return $query -> result_array();
    }
    function hrEmpGrowthPer($teamId)
    {
        $sql = ('SELECT B.CURRENT_STRENGTH,A.PREVIOUS_STRENGTH,
                        round(((B.CURRENT_STRENGTH-A.PREVIOUS_STRENGTH)/A.PREVIOUS_STRENGTH)*100) GROWTH_PERCENT 
                 FROM                   
                    (SELECT IFNULL(SUM(NO_OF_EMPLOYEES),0)AS PREVIOUS_STRENGTH,TEAM_ID
                     FROM 
                        hr_employee_tbl_audit  
                     WHERE TEAM_ID = ? AND MOVE_NO = 0)A
                     LEFT JOIN 
                     (SELECT IFNULL(SUM(NO_OF_EMPLOYEES),0)AS CURRENT_STRENGTH,TEAM_ID
                      FROM hr_employee_tbl het
                     WHERE TEAM_ID = ?)B ON A.TEAM_ID = B.TEAM_ID');
        $query = $this -> db -> query($sql,array($teamId,$teamId));
        return $query -> result_array();
    }
    function BudgetDetails($teamId,$transFor)
    {
        $sql = ('SELECT IFNULL(SUM(diet.AMOUNT),0) AS AMOUNT 
                 FROM 
                    department_income_expend_transaction_tbl diet
                    INNER JOIN
                    budget_head_game_mstr bhgm ON bhgm.BUDGET_HEAD_ID = diet.BUDGET_HEAD_ID
                 WHERE diet.TEAM_ID = ?
                        AND bhgm.BUDGET_HEAD in ? AND diet.move_no>0');
        $query = $this -> db -> query($sql,array($teamId,$transFor));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function empPromoted($teamId)
    {
        $sql = ('SELECT IFNULL(SUM(NO_OF_EMPLOYEES),0)NO_OF_EMP_PROMOTED 
                 FROM 
                    hr_main_tbl hmt
                    INNER JOIN hr_promotion_tbl hpt ON hpt.HR_MAIN_ID = hmt.HR_MAIN_ID 
                 WHERE hmt.TEAM_ID = ? AND move_no>0');
        $query = $this -> db -> query($sql,array($teamId));
        return $query -> result_array();
    }
    function bookValue($teamId)
    {
        $sql = ('SELECT  BOOK_VALUE
                 FROM
                    fin_share_values_game_mstr_audit 
                 WHERE AUDIT_ID=(SELECT MAX(AUDIT_ID) 
                                                 FROM 
                                                    fin_share_values_game_mstr_audit 
                                                 WHERE TEAM_ID = ?)');
        $query = $this -> db -> query($sql,array($teamId));
       // echo $this->db->last_query();
        return $query -> result_array();
    }
    function opsproductAllocatedList($teamId)
    {
        $sql = ('SELECT omt.OPR_MAIN_ID as orderid,omt.MOVE_NO AS MoveNO,
                    GETYEAR(omt.MOVE_NO) AS Year,
                    GETQTR(omt.MOVE_NO, GETYEAR(omt.MOVE_NO)) AS Qtr,
                    pm.PRODUCT_desc AS ProductName,
                    NO_OF_UNITS_PLACED AS AllotedUnits,
                    omt.team_id AS teamid
                FROM
                    opr_main_tbl omt
                        INNER JOIN
                    opr_production_main_tbl opmt ON opmt.OPR_MAIN_ID = omt.OPR_MAIN_ID
                        INNER JOIN
                    opr_product_game_mstr pm ON pm.PRODUCT_ID = opmt.PRODUCT_ID
                WHERE
                    omt.team_id = ? and  omt.move_no>0 group by 1,2');
        $query = $this -> db -> query($sql,array($teamId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function opsPurchaseList($teamId)
    {
        $sql = ('Select opmt.OPR_PURCHASE_MAIN_ID as orderid,
                        opmt.MOVE_NO AS MoveNO,
                        GETYEAR(opmt.MOVE_NO) AS Year,
                        GETQTR(opmt.MOVE_NO, GETYEAR(opmt.MOVE_NO)) AS Qtr,
                        (case when sum(if(OPR_ACTION="BUY_PLANT",1,0))>0 then "Yes" else "No" End) AS PlantPurchase,
                        (case when sum(if(OPR_ACTION="BUY_MACHINE",1,0))>0 then "Yes" else "No" End) AS MachinePurchase,
                        (case when sum(if(OPR_ACTION="BUY_WAREHOUSE",1,0))>0 then "Yes" else "No" End) AS WarehousePurchase,
                        opmt.team_id AS teamid
                 from opr_purchase_main_tbl opmt
                    inner join opr_actions_game_mstr oagm on oagm.OPR_ACTIONS_ID=opmt.OPR_ACTIONS_ID
                 where opmt.move_no>0 and opmt.team_id = ? and oagm.OPR_ACTION<>"BUY_RAWMATERIAL"
                 group by 2');
        $query = $this -> db -> query($sql,array($teamId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function stgproductAllocatedList($teamId)
    {
        $sql = ('SELECT smt.STRATEGY_MAIN_ID,
                    STRGY_PRODUCT_ALLOCATION_ID AS OrderId,
                    MOVE_NO AS MoveNO,
                    GETYEAR(MOVE_NO) AS Year,
                    GETQTR(MOVE_NO, GETYEAR(MOVE_NO)) AS Qtr,
                    pm.PRODUCT_desc AS ProductName,
                    SUM(NO_OF_UNITS) AS AllotedUnits,
                    scgm.COUNTRY_DESC AS CountryName,
                    smegm.MODE_OF_ENTRY AS ModeofEntry,
                    ROUND(AVG(PRICE_OF_PRODUCT)) AS AvgPrice
                FROM
                    strgy_main_tbl smt
                        INNER JOIN
                    strgy_product_allocation_tbl spat ON spat.STRATEGY_MAIN_ID = smt.STRATEGY_MAIN_ID
                        INNER JOIN
                    opr_product_game_mstr pm ON pm.PRODUCT_ID = spat.PRODUCT_ID 
                        INNER JOIN
                    strgy_country_game_mstr scgm on scgm.COUNTRY_ID = smt.COUNTRY_ID
                        INNER JOIN
                    strgy_mode_of_entry_game_mstr smegm on smegm.MODE_OF_ENTRY_ID = smt.MODE_OF_ENTRY_ID
                WHERE
                    smt.team_id = ? and move_no>0
                GROUP BY 1 , 2 , 3');
        $query = $this -> db -> query($sql,array($teamId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function hrDecisionList($teamId)
    {
        $sql = ('SELECT 
                    HR_MAIN_ID AS OrderId,
                    MOVE_NO AS MoveNO,
                    GETYEAR(MOVE_NO) AS Year,
                    GETQTR(MOVE_NO, GETYEAR(MOVE_NO)) AS Qtr,
                    (CASE WHEN SUM(IF(ham.ACTION_DESC = "RECRUITMENT",1,0))>0 THEN "Yes" ELSE "No" END) AS Recruitment,
                    (CASE WHEN SUM(IF(ham.ACTION_DESC = "TRANING",1,0))>0 THEN "Yes" ELSE "No" END) AS Training,
                    (CASE WHEN SUM(IF(ham.ACTION_DESC = "WELLFARE",1,0))>0 THEN "Yes" ELSE "No" END) AS Welfare,
                    (CASE WHEN SUM(IF(ham.ACTION_DESC = "RETRENCHMENT",1,0))>0 THEN "Yes" ELSE "No" END) AS Retrenchment,
                    (CASE WHEN SUM(IF(ham.ACTION_DESC = "PROMOTION",1,0))>0 THEN "Yes" ELSE "No" END) AS Promotion,
                    hmt.TEAM_ID AS teamid
                FROM
                    hr_main_tbl hmt
                        INNER JOIN
                    hr_actions_mstr ham ON ham.HR_ACTION_ID = hmt.HR_ACTION_ID
                WHERE
                    hmt.team_id = ? and move_no>0 and ham.ACTION_DESC !="ATTRITION"
                GROUP BY 2 ');
        $query = $this -> db -> query($sql,array($teamId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function itProgramImplementList($teamId)
    {
        $sql = ('SELECT IT_MAIN_ID,
                        PGM_INITIATED_MOVE_NO AS MoveNo,
                        GETYEAR(PGM_INITIATED_MOVE_NO) AS Year,
                        GETQTR(PGM_INITIATED_MOVE_NO, GETYEAR(PGM_INITIATED_MOVE_NO)) AS Qtr,
                        IT_PROGRAM AS ProgramName,
                        HARDWARE_NAME AS HardwareName,
                        IF(CHANGE_MGMT_REQUIRED=0,"No","Yes") AS ChangeMgmtRequired,
                        IF(TRAINING_REQUIRED=0,"No","Yes") AS TrainingRequired
                 FROM 
                    it_main_tbl imt 
                    INNER JOIN it_program_game_mstr ipgm on ipgm.IT_PROGRAM_ID = imt.IT_PROGRAM_ID
                    INNER JOIN it_hardware_game_mstr ihgm on ihgm.HARDWARE_ID = imt.HARDWARE_ID
                 WHERE imt.team_id=? Group by 1');
        $query = $this -> db -> query($sql,array($teamId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function mktProdAllocatQtrwise($teamId)
    {
        $sql = ('SELECT 
                    SUM(NO_OF_PRODUCTS) AS PRODUCTS_ALLOTED,
                    getyear(mmt.move_no)Year,GETQTR(mmt.MOVE_NO, GETYEAR(mmt.MOVE_NO)) AS Qtr
                FROM
                    mkt_territory_product_allocation_tbl mtpat 
                    INNER JOIN mkt_main_tbl mmt on mmt.MKT_MAIN_ID=mtpat.MKT_MAIN_ID
                WHERE
                    mtpat.team_id = ? and move_no>0 group by 2,3');
        $query = $this -> db -> query($sql,array($teamId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function mktProdSoldQtrwise($teamId)
    {
        $sql = ('SELECT 
                    SUM(PRODUCTS_SOLD) AS PRODUCTS_SOLD,
                     getyear(move_no)Year,GETQTR(MOVE_NO, GETYEAR(MOVE_NO)) AS Qtr
                FROM
                    mkt_sales_section_f_tbl
                WHERE
                    team_id = ? and move_no>0 group by 2,3');
        $query = $this -> db -> query($sql,array($teamId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function productProductionQtrwise($teamId)
    {
        $sql = ('SELECT IFNULL(SUM(NO_OF_UNITS_PLACED),0) AS PRODUCTS_ALLOCATED,
                    IFNULL(SUM(NO_OF_UNITS_PLACED)-sum(SHORTAGE_DUE_TO_PLANT_CAPACITY+
                    SHORTAGE_DUE_TO_MACHINE_CAPACITY +
                    SHORTGE_DUE_TO_OPERATOR_EFFECTIVENESS +
                    SHORTAGE_DUE_TO_OPERATOR_AVAILABILITY +
                    REJECTION_DUE_TO_MACHINERY +
                    REJECTION_DUE_TO_WAREHOUSE +
                    REJECTION_DUE_TO_SUPPLIER +
                    REJECTION_DUE_TO_PACKAGING),0)AS PRODUCTS_PRODUCED,
                    getyear(move_no)Year,GETQTR(MOVE_NO, GETYEAR(MOVE_NO)) AS Qtr
                FROM 
                   opr_production_main_tbl opmt 
                   INNER JOIN opr_main_tbl omt ON omt.OPR_MAIN_ID = opmt.OPR_MAIN_ID
                WHERE
                    omt.TEAM_ID = ? AND move_no>0 group by 3,4');
        $query = $this -> db -> query($sql,array($teamId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function stgProdAllocatQtrwise($teamId)
    {
        $sql = ('select * from(select IFNULL(SUM(NO_OF_UNITS),0) PRODUCTS_ALLOCATED,0 as PRODUCTS_SOLD,  getyear(move_no)Year,GETQTR(MOVE_NO, GETYEAR(MOVE_NO)) AS Qtr
from strgy_product_allocation_tbl spat 
 INNER JOIN strgy_main_tbl smt ON smt.STRATEGY_MAIN_ID = spat.STRATEGY_MAIN_ID 
  WHERE smt.TEAM_ID = ? AND move_no>0 group by 3,4 union ALL
  
select 0 as PRODUCTS_ALLOCATED, IFNULL(SUM(NO_OF_UNITS_SOLD),0) PRODUCTS_SOLD,  getyear(ALLOCATION_MOVE_NO)Year,GETQTR(ALLOCATION_MOVE_NO, GETYEAR(ALLOCATION_MOVE_NO)) AS Qtr
from strgy_sales_main_tbl ssmt
                     INNER JOIN strgy_product_allocation_tbl spat 
                     ON ssmt.PRODUCT_ALLOCATION_ID = spat.STRGY_PRODUCT_ALLOCATION_ID
                     INNER JOIN strgy_main_tbl smt ON smt.STRATEGY_MAIN_ID = spat.STRATEGY_MAIN_ID 
  WHERE smt.TEAM_ID = ? AND move_no>0 group by 3,4) A order by 3,4');
        $query = $this -> db -> query($sql,array($teamId,$teamId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function AvgCapacityUtilized($teamId)
    {
        $sql = ('SELECT 
                    round(Avg(Total_Capacity_Utilized))AVG_Total_Capacity_Utilized 
                 FROM
                    (SELECT 
                        opmmt.NO_OF_MACHINES_OCCUPIED,MACHINE_CAPACITY,
                        (NO_OF_MACHINES_OCCUPIED*MACHINE_CAPACITY) AS Total_Capacity_Utilized
                     FROM 
                        opr_main_tbl omt
                        INNER JOIN opr_production_main_tbl opmt ON opmt.OPR_MAIN_ID = omt.OPR_MAIN_ID
                        INNER JOIN opr_production_plant_mapping_tbl oppmt 
                        ON oppmt.PRODUCTION_MAIN_ID = opmt.PRODUCTION_MAIN_ID
                        INNER JOIN opr_production_machinery_mapping_tbl opmmt 
                        ON opmmt.PRODUCTION_PLANT_MAP_ID = oppmt.PRODUCTION_PLANT_MAP_ID
                        INNER JOIN opr_machinery_game_mstr omgm ON omgm.MACHINE_GAME_MSTR_ID = opmmt.MACHINE_ID
                     WHERE omt.TEAM_ID = ? AND omt.move_no>0)A');
        $query = $this -> db -> query($sql,array($teamId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function mktMainTblForMainId($mktMainId)
    {
        $sql = ('SELECT mmt.MKT_MAIN_ID      AS OrderId,
           MOVE_NO                           AS MoveNO,
           GETYEAR(MOVE_NO)                  AS Year,
           GETQTR(MOVE_NO, GETYEAR(MOVE_NO)) AS Qtr,
           msm.SEGMENT_DISPLAY_NAME          AS Segment,
           pm.PRODUCT_desc                   AS ProductName,
           SUM(NO_OF_PRODUCTS)               AS AllotedUnits,
           ROUND(AVG(PRODUCT_PRICE))         AS Price,
           mmt.team_id                       AS teamId
    FROM mkt_main_tbl    mmt
         INNER JOIN mkt_territory_product_allocation_tbl mpa
            ON mpa.MKT_MAIN_ID = mmt.MKT_MAIN_ID
         INNER JOIN opr_product_game_mstr pm ON pm.PRODUCT_ID = mpa.PRODUCT_ID
         INNER JOIN mkt_segment_game_mstr msm
            ON msm.SEGMENT_ID = mmt.SEGMENT_ID
    WHERE  mmt.MKT_MAIN_ID=? AND MKT_ACTIONS_ID = 1 
    GROUP BY 1, 2, 3');
        $query = $this -> db -> query($sql,array($mktMainId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function mktProductAllocation($mktMainId)
    {
        $sql = ('SELECT mpat.MKT_MAIN_ID,
                   PRODUCTION_ALLOCATION_ID,
                   pm.PRODUCT_DESC,
                   tcm.TERRITORY_NAME,
                   NO_OF_PRODUCTS,
                   PRODUCT_PRICE,
                   DISCOUNT,
                   TRANSPORTATION_COST
            FROM mkt_territory_product_allocation_tbl    mpat
                 INNER JOIN opr_product_game_mstr pm
                    ON pm.PRODUCT_ID = mpat.PRODUCT_ID
                 INNER JOIN mkt_territory_characteristics_game_mstr tcm
                    ON tcm.TERRITORY_CHARACTERISTIC_ID = mpat.TERRITORY_ID
             INNER JOIN mkt_main_tbl mmt on mmt.MKT_MAIN_ID=mpat.MKT_MAIN_ID
            WHERE mmt.MKT_MAIN_ID = ? ');
        $query = $this -> db -> query($sql,array($mktMainId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function mktAdvt($mktMainId)
    {
        $sql = ('SELECT advt.TERRITORY_ADVERTISEMENT_ID,
                   advt.MKT_MAIN_ID,
                   tcm.TERRITORY_NAME,
                   advt.PRODUCT_ID,
                   mode.ADVERTISEMENT_MODE_NAME,
                   unit.ADVERTISEMENT_UNIT,
                   advt.ADVERTISEMENT_UNIT_FREQUENCY,
                   advt.ADVERTISEMENT_COST,
                   advt.AWARNESS_CREATED
            FROM mkt_territory_advertisement_tbl    advt
                 INNER JOIN mkt_advertisement_mode_game_mstr mode
                    ON mode.ADVERTISEMENT_MODE_ID = advt.ADVERTISEMENT_MODE_ID
                 INNER JOIN mkt_advertisement_unit_game_mstr unit
                    ON unit.ADVERTISEMENT_UNIT_ID = advt.ADVERTISEMENT_UNIT_ID
                 INNER JOIN mkt_territory_characteristics_game_mstr tcm
        ON tcm.TERRITORY_CHARACTERISTIC_ID = advt.TERRITORY_CHARACTERISTIC_ID
            INNER JOIN mkt_main_tbl mmt on mmt.MKT_MAIN_ID=advt.MKT_MAIN_ID
            WHERE mmt.MKT_MAIN_ID = ? ');
        $query = $this -> db -> query($sql,array($mktMainId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function mktDist($mktMainId)
    {
        $sql = ('SELECT cat.DISTRIBUTION_CATEGORY_DESC,
                   tcm.TERRITORY_NAME,
                   necom.MARIGN,
                   necom.SALES_INCENTIVE,
                   necom.MARGIN_COST,
                   necom.SALES_INCENTIVE_COST,
                   necom.TRAINING,
                   necom.MARKETING_SUPPORT
            FROM mkt_territory_distribution_non_ecommerce_tbl    AS necom
                 INNER JOIN mkt_distribution_main_tbl AS dmt
                    ON dmt.DISTRIBUTION_MAIN_ID = necom.DISTRIBUTION_MAIN_ID
                 INNER JOIN mkt_territory_characteristics_game_mstr tcm
                    ON tcm.TERRITORY_CHARACTERISTIC_ID =
                          necom.TERRITORY_CHARACTERISTIC_ID
                 INNER JOIN mkt_distribution_category_game_mstr cat
                    ON cat.DISTRIBUTION_CATEGORY_ID = dmt.DISTRIBUTION_CATEGORY_ID
             INNER JOIN mkt_main_tbl mmt on mmt.MKT_MAIN_ID=dmt.MKT_MAIN_ID
            WHERE mmt.MKT_MAIN_ID = ? 
            UNION ALL
            SELECT cat.DISTRIBUTION_CATEGORY_DESC,
                   "Common For All Territory" AS TERRITORY_NAME,
                   ecom.MARIGN,
                   ecom.SALES_INCENTIVE,
                   ecom.MARGIN_COST,
                   ecom.SALES_INCENTIVE_COST,
                   ecom.TRAINING,
                   ecom.MARKETING_SUPPORT
            FROM mkt_territory_distribution_ecommerce_tbl    AS ecom
                 INNER JOIN mkt_distribution_main_tbl AS dmt
                    ON dmt.DISTRIBUTION_MAIN_ID = ecom.DISTRIBUTION_MAIN_ID
                 INNER JOIN mkt_distribution_category_game_mstr cat
                    ON cat.DISTRIBUTION_CATEGORY_ID = dmt.DISTRIBUTION_CATEGORY_ID
            INNER JOIN mkt_main_tbl mmt on mmt.MKT_MAIN_ID=dmt.MKT_MAIN_ID
            WHERE mmt.MKT_MAIN_ID = ? ;');
        $query = $this -> db -> query($sql,array($mktMainId,$mktMainId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function mktResource($mktMainId)
    {
        $sql = ('SELECT tcm.TERRITORY_NAME, dgm.DESIGNATION_NAME, sf.NO_OF_EMPLOYEES
                    FROM mkt_territory_employee_allocaton_tbl    AS sf
                         INNER JOIN mkt_territory_characteristics_game_mstr tcm
                            ON tcm.TERRITORY_CHARACTERISTIC_ID = sf.TERRITORY_ID
                         INNER JOIN hr_designation_game_mstr dgm
                            ON dgm.DESIGNATION_ID = sf.DESIGNATION_ID
                     INNER JOIN mkt_main_tbl mmt on mmt.MKT_MAIN_ID=sf.MKT_MAIN_ID
            WHERE mmt.MKT_MAIN_ID = ? 
                    ORDER BY tcm.TERRITORY_CHARACTERISTIC_ID, dgm.DESIGNATION_ID;');
        $query = $this -> db -> query($sql,array($mktMainId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function stgProductAllocation($stgMainId)
    {
        $sql = ('SELECT smt.STRATEGY_MAIN_ID,smt.MOVE_NO AS MoveNo,
                    STRGY_PRODUCT_ALLOCATION_ID AS OrderId,
                    smt.ALLOCATION_MOVE_NO AS AllocatedMoveNO, 
                    GETYEAR(smt.ALLOCATION_MOVE_NO) AS Year, 
                    GETQTR(smt.ALLOCATION_MOVE_NO, GETYEAR(smt.ALLOCATION_MOVE_NO)) AS Qtr,
                    pm.PRODUCT_desc AS ProductName,
                    NO_OF_UNITS AS AllotedUnits,
                    scgm.COUNTRY_DESC AS CountryName,
                    smegm.MODE_OF_ENTRY AS ModeofEntry,
                    IFNULL(JV_PARTNER_DESC,"") AS JVPartnerName,
                    IFNULL(SUM(scsqt.SCORE),0) AS CulturalSensitivityScore
                FROM
                    strgy_main_tbl smt
                        INNER JOIN
                    strgy_product_allocation_tbl spat ON spat.STRATEGY_MAIN_ID = smt.STRATEGY_MAIN_ID
                        INNER JOIN
                    opr_product_game_mstr pm ON pm.PRODUCT_ID = spat.PRODUCT_ID 
                        INNER JOIN
                    strgy_country_game_mstr scgm on scgm.COUNTRY_ID = smt.COUNTRY_ID
                        INNER JOIN
                    strgy_mode_of_entry_game_mstr smegm on smegm.MODE_OF_ENTRY_ID = smt.MODE_OF_ENTRY_ID
                        left JOIN
                    strgy_jv_partner_game_mstr sjpgm on sjpgm.JV_PARTNER_ID = spat.JV_PARTNER_ID
                        INNER JOIN
                    strgy_cultural_sensitivity_qna_tbl scsqt on scsqt.STRATEGY_MAIN_ID = smt.STRATEGY_MAIN_ID
                WHERE
                    smt.STRATEGY_MAIN_ID = ? 
                GROUP BY 1 , 2 , 3');
        $query = $this -> db -> query($sql,array($stgMainId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function stgCulturalQues($stgMainId)
    {
        $sql = ('SELECT smt.STRATEGY_MAIN_ID,
                        scaqgm.QUESTION AS Question,
                        scsasgm.ANSWER AS Answer,
                        IF(scsqt.SCORE!=0,"RIGHT","WRONG") AS RightWrong,
                        scsqt.SCORE AS Score
                 FROM  
                    strgy_main_tbl smt
                    INNER JOIN 
                    strgy_cultural_sensitivity_qna_tbl scsqt on scsqt.STRATEGY_MAIN_ID = smt.STRATEGY_MAIN_ID
                    INNER JOIN
                    strgy_cultural_sensitivity_questions_game_mstr scaqgm on scaqgm.QUESTIONS_ID = scsqt.QUESTIONS_ID
                    INNER JOIN
                    strgy_cutural_sensitivity_ans_score_game_mstr scsasgm on scsasgm.ANSWER_ID = scsqt.ANSWER_ID
                WHERE smt.STRATEGY_MAIN_ID = ? ');
        $query = $this -> db -> query($sql,array($stgMainId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function hrRecruitmentDtl($moveNo, $teamId)
    {
        $sql = ('SELECT HR_MAIN_ID,HR_RECRUITMENT_ID,hrt.MOVE_NO AS MoveNo,
                        DEPARTMENT_NAME AS DepartmetName,
                        DESIGNATION_NAME AS DesignationName,
                        SALARY AS Salary,
                        CHANNEL_NAME AS ChannelName,
                        NO_OF_EMPLOYEES_NEEDED AS NoOfEmployeesIntended,
                        ((NO_OF_EMPLOYEES_NEEDED)-
                        (CONVERSION_LOSS_DUE_TO_CHANNEL +
                        CONVERSION_LOSS_DUE_TO_SALARY + 
                        CONVERSION_LOSS_DUE_TO_BRAND_IMG)) AS NoOfEmpAccepted,
                        AVAILABLE_FROM_MOVE_NO AS OnBoardingMoveNo,
                        GETYEAR(AVAILABLE_FROM_MOVE_NO) AS OnBoardYear,
                        GETQTR(AVAILABLE_FROM_MOVE_NO, GETYEAR(AVAILABLE_FROM_MOVE_NO)) AS OnBoardQtr
                FROM 
                    hr_recruitment_tbl hrt
                    INNER JOIN hr_designation_game_mstr hdgm on hdgm.DESIGNATION_ID = hrt.DESIGNATION_ID
                    INNER JOIN hr_dept_designation_salary_var_game_mstr_audit hdsv 
                                on hdsv.DEPARTMENT_ID = hrt.DEPARTMENT_ID
                                AND hdsv.DESIGNATION_ID = hrt.DESIGNATION_ID AND hdsv.SALARY_TYPE_ID = hrt.SALARY_TYPE_ID
                    INNER JOIN hr_channel_game_mstr hcgm on hcgm.CHANNEL_ID = hrt.CHANNEL_ID
                    INNER JOIN department_mstr dgm on dgm.DEPARTMENT_ID = hrt.DEPARTMENT_ID
               WHERE hrt.MOVE_NO=? AND hrt.team_id=? AND
                     GETQTR(hrt.MOVE_NO, GETYEAR(hrt.MOVE_NO))= GETQTR(hdsv.MOVE_NO, GETYEAR(hdsv.MOVE_NO))
                     AND GETYEAR(hrt.MOVE_NO)=GETYEAR(hdsv.MOVE_NO) GROUP BY  1,2,3');
        $query = $this -> db -> query($sql,array($moveNo, $teamId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function hrTrainingDtl($moveNo, $teamId)
    {
        $sql = ('SELECT hmt.HR_MAIN_ID,htpt.HR_TRAINING_ID,hmt.MOVE_NO AS MoveNo,
                        DEPARTMENT_NAME AS DepartmentName,
                        DESIGNATION_NAME AS DesignationName,
                        TRAINING_NAME AS ProgramName,
                        NO_OF_EMPLOYEES AS NoOfEmployees,
                        BENIFIT_MOVE_NO AS BenefitMoveNo,
                        GETYEAR(BENIFIT_MOVE_NO) AS BenefitYear,
                        GETQTR(BENIFIT_MOVE_NO, GETYEAR(BENIFIT_MOVE_NO)) AS BenefitQtr,
                        (EDI_IMPACT*8) AS EDIImpact,
                        PROGRAM_COST AS ProgramCost,
                        (NO_OF_EMPLOYEES*PROGRAM_COST) AS TotalCost
                 FROM 
                    hr_training_pgm_tbl htpt
                    INNER JOIN hr_main_tbl hmt on hmt.HR_MAIN_ID = htpt.HR_MAIN_ID
                    INNER JOIN hr_training_pgm_game_mstr htpgm on htpgm.HR_TRAINING_PGM_ID = htpt.HR_TRAINING_PGM_ID
                    INNER JOIN department_mstr dgm on dgm.DEPARTMENT_ID = htpt.DEPARTMENT_ID
                    INNER JOIN hr_designation_game_mstr hdgm on hdgm.DESIGNATION_ID = htpt.DESIGNATION_ID
                    INNER JOIN hr_training_program_benifit_game_mstr htpbgm on htpbgm.HR_TRAINING_PGM_ID = htpt.HR_TRAINING_PGM_ID
                 WHERE hmt.MOVE_NO=? and hmt.team_id=?');
        $query = $this -> db -> query($sql,array($moveNo, $teamId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function hrTrainingParameterDtl($moveNo, $teamId)
    {
        $sql = ('SELECT hmt.HR_MAIN_ID,htpt.HR_TRAINING_PGM_ID,
                        DEPARTMENT_NAME AS DepartmentName,
                        DESIGNATION_NAME AS DesignationName,
                        PARAMETER_NAME AS ParameterName,
                        htpmg.IMPACT_VAL AS ParameterImpact
                 FROM 
                    hr_training_pgm_tbl htpt
                     INNER JOIN hr_main_tbl hmt on hmt.HR_MAIN_ID = htpt.HR_MAIN_ID
                     INNER JOIN hr_training_pgm_game_mstr htpgm on htpgm.HR_TRAINING_PGM_ID = htpt.HR_TRAINING_PGM_ID
                     INNER JOIN department_mstr dgm on dgm.DEPARTMENT_ID = htpt.DEPARTMENT_ID
                     INNER JOIN hr_designation_game_mstr hdgm on hdgm.DESIGNATION_ID = htpt.DESIGNATION_ID
                     INNER JOIN hr_training_pgm_parameter_mapping_game_mstr htpmg on htpmg.HR_TRAINING_PGM_ID=htpt.HR_TRAINING_PGM_ID
                     INNER JOIN parameter_definition_game_mstr pdgm on pdgm.PARAMETER_DEFINITION_ID=htpmg.PARAMETER_DEFINITION_ID
                  WHERE hmt.MOVE_NO=? and hmt.team_id=? group by 1,2,3,4,5');
        $query = $this -> db -> query($sql,array($moveNo, $teamId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function hrWelfareDtl($moveNo, $teamId)
    {
        $sql = ('SELECT hmt.HR_MAIN_ID,HR_WELFARE_ID,hmt.MOVE_NO AS MoveNo,
                        WELFARE_PGM_NAME AS WelfarePrgm,
                        (hwpbgm.EDI_IMPACT * 8*6) AS EDIBenefit,
                        COST AS Cost,
                        BENIFIT_MOVE_NO AS BenefitMove,
                        GETYEAR(BENIFIT_MOVE_NO) AS BenefitYear,
                        GETQTR(BENIFIT_MOVE_NO, GETYEAR(BENIFIT_MOVE_NO)) AS BenefitQtr,
                        IF(IFNULL(UNIMPLIMENTED_MOVE_NO,0)=0,"Active","Inactive") AS Status
                 FROM  
                    hr_welfare_pgm_tbl hwpt
                    INNER JOIN hr_main_tbl hmt on hmt.HR_MAIN_ID = hwpt.HR_MAIN_ID
                    INNER JOIN hr_welfare_pgm_benifit_game_mstr hwpbgm 
                    on hwpbgm.HR_WELFARE_PROGRAM_ID = hwpt.HR_WELFARE_PROGRAM_ID
                    INNER JOIN hr_welfare_program_game_mstr hwpgm 
                    on hwpgm.HR_WELFARE_PROGRAM_ID = hwpt.HR_WELFARE_PROGRAM_ID
                 WHERE hmt.MOVE_NO=? and hmt.team_id=? group by 1,2');
        $query = $this -> db -> query($sql,array($moveNo, $teamId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function hrRetrenchmentDtl($moveNo, $teamId)
    {
        $sql = ('SELECT hmt.HR_MAIN_ID,hmt.MOVE_NO AS MoveNo,
                        DEPARTMENT_NAME AS DepartmentName,
                        DESIGNATION_NAME AS DesignationName,
                        NO_OF_EMPLOYEES AS NoOfEmployee
                 FROM 
                    hr_retrenchment_tbl hrt
                    INNER JOIN hr_main_tbl hmt on hmt.HR_MAIN_ID = hrt.HR_MAIN_ID
                    INNER JOIN department_mstr dgm on dgm.DEPARTMENT_ID = hrt.DEPARTMENT_ID
                    INNER JOIN hr_designation_game_mstr hdgm on hdgm.DESIGNATION_ID = hrt.DESIGNATION_ID
                 WHERE hmt.MOVE_NO=? and hmt.team_id=? group by 1');
        $query = $this -> db -> query($sql,array($moveNo, $teamId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function hrPromotionDtl($moveNo, $teamId)
    {
        $sql = ('SELECT hpt.HR_MAIN_ID,hmt.MOVE_NO AS MoveNo,
                        DEPARTMENT_NAME AS DepartmentName,
                        hdgm.DESIGNATION_NAME AS FromDesignation,
                        hgm.DESIGNATION_NAME AS ToDesignation,
                        NO_OF_EMPLOYEES AS NoOfEmployee,hdsv.SALARY AS Salary
                 FROM 
                    hr_promotion_tbl hpt
                    INNER JOIN department_mstr dgm on dgm.DEPARTMENT_ID = hpt.DEPARTMENT_ID
                    INNER JOIN hr_designation_game_mstr hdgm on hdgm.DESIGNATION_ID = hpt.FROM_DESIGNATION_ID
                    INNER JOIN hr_designation_game_mstr hgm on hgm.DESIGNATION_ID = hpt.TO_DESIGNATION_ID
                    INNER JOIN hr_main_tbl hmt on hmt.HR_MAIN_ID=hpt.HR_MAIN_ID
                    INNER JOIN hr_dept_designation_salary_var_game_mstr_audit hdsv on hdsv.DEPARTMENT_ID = hpt.DEPARTMENT_ID
                    AND hdsv.DESIGNATION_ID = hpt.TO_DESIGNATION_ID AND hdsv.SALARY_TYPE_ID = hpt.SALARY_TYPE_ID
                 WHERE hmt.MOVE_NO=? AND hmt.team_id=? and  GETQTR(hmt.MOVE_NO, GETYEAR(hmt.MOVE_NO))= GETQTR(hdsv.MOVE_NO, GETYEAR(hdsv.MOVE_NO))
                        AND GETYEAR(hmt.MOVE_NO)=GETYEAR(hdsv.MOVE_NO)');
        $query = $this -> db -> query($sql,array($moveNo, $teamId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function itProgramDtl($itMainId)
    {
        $sql = ('SELECT IT_MAIN_ID,
                        PGM_INITIATED_MOVE_NO AS MoveNo,
                        GETYEAR(PGM_INITIATED_MOVE_NO) AS Year,
                        GETQTR(PGM_INITIATED_MOVE_NO, GETYEAR(PGM_INITIATED_MOVE_NO)) AS Qtr,
                        IT_PROGRAM AS ProgramName,
                        IMPLEMENTATION_TYPE As ImplementationType,
                        IMPLIMENTATION_COST AS ImplementationCost,
                        imt.COST_OF_PROGRAM AS ProgramCost,
                        BENIFIT_ACCRUAL_MOVE_NO AS BenefitMove
                 FROM 
                    it_main_tbl imt 
                    INNER JOIN it_program_game_mstr ipgma on ipgma.IT_PROGRAM_ID = imt.IT_PROGRAM_ID
                    INNER JOIN it_implementation_game_mstr imgm on imgm.IT_IMPLEMENTATION_ID = imt.IT_IMPLEMENTATION_ID
                 WHERE imt.IT_MAIN_ID=? group by 1');
        $query = $this -> db -> query($sql,array($itMainId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function itHardwareDtl($itMainId)
    {
        $sql = ('SELECT IT_MAIN_ID,
                        HARDWARE_NAME AS HardwareName,
                        HARWARE_IMPLIMENTATION_TYPE AS HardwareType,
                        HARDWARE_COST AS HardwareCost,
                        imt.HARDWARE_AMC AS HardwareAMC
                 FROM 
                    it_main_tbl imt 
                    INNER JOIN it_hardware_game_mstr ihgm on ihgm.HARDWARE_ID = imt.HARDWARE_ID
                 WHERE imt.IT_MAIN_ID=? group by 1');
        $query = $this -> db -> query($sql,array($itMainId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function itTrainingDtl($itMainId)
    {
        $sql = ('SELECT IT_MAIN_ID,
                        IF(CHANGE_MGMT_REQUIRED=0,"No","Yes") AS ChangeMgmtRequired,
                        CHANGE_MGMT_COST AS ChangeMgmtCost,
                        IF(TRAINING_REQUIRED=0,"No","Yes") AS TrainingRequired,
                        TRAINING_COST AS TrainingCost
                 FROM 
                    it_main_tbl imt 
                 WHERE imt.IT_MAIN_ID=?');
        $query = $this -> db -> query($sql,array($itMainId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function itParameterDtl($itMainId)
    {
        $sql = ('SELECT IT_MAIN_ID,
                        PARAMETER_NAME AS ParameterName,
                        ipspgm.IMPACT_VALUE AS ImpactValue,
                        IMPACTED_COLUMN_NAME AS ImpactColumn
                 FROM 
                    it_main_tbl imt
                    INNER JOIN it_parameter_success_probability_game_mstr ipspgm
                    ON ipspgm.IT_PROGRAM_IMPLIMENTATION_ID = imt.IT_IMPLEMENTATION_ID
                    INNER JOIN parameter_definition_game_mstr pdgm ON
                    pdgm.PARAMETER_DEFINITION_ID = ipspgm.PARAMETER_DEFINITION_ID
                 WHERE imt.IT_MAIN_ID=? GROUP BY 1,2');
        $query = $this -> db -> query($sql,array($itMainId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function itEDIParameterDtl($itMainId)
    {
        $sql = ('SELECT IT_MAIN_ID,
                        Sum(iespgm.IMPACT_VALUE) AS EDIImpact
                 FROM 
                    it_main_tbl imt
                    INNER JOIN it_edi_success_probability_game_mstr iespgm 
                    ON iespgm.IT_PROGRAM_IMPLIMENTATION_ID = imt.IT_IMPLEMENTATION_ID
                    AND imt.team_id = iespgm.team_id
                 WHERE imt.IT_MAIN_ID=? group by 1');
        $query = $this -> db -> query($sql,array($itMainId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function opsProductionDtl($moveNo,$teamId)
    {
        $sql = ('SELECT omt.OPR_MAIN_ID,omt.move_no AS MoveNo,
                            pm.PRODUCT_desc AS ProductName,
                            NO_OF_UNITS_PLACED AS AllotedUnits,
                            (SHORTAGE_DUE_TO_PLANT_CAPACITY+SHORTAGE_DUE_TO_MACHINE_CAPACITY+
                            SHORTGE_DUE_TO_OPERATOR_EFFECTIVENESS+SHORTAGE_DUE_TO_OPERATOR_AVAILABILITY+
                            REJECTION_DUE_TO_MACHINERY+REJECTION_DUE_TO_WAREHOUSE+
                            REJECTION_DUE_TO_SUPPLIER+REJECTION_DUE_TO_PACKAGING) AS RejectedUnits,
                            (NO_OF_UNITS_PLACED-(SHORTAGE_DUE_TO_PLANT_CAPACITY+SHORTAGE_DUE_TO_MACHINE_CAPACITY+
                            SHORTGE_DUE_TO_OPERATOR_EFFECTIVENESS+SHORTAGE_DUE_TO_OPERATOR_AVAILABILITY+
                            REJECTION_DUE_TO_MACHINERY+REJECTION_DUE_TO_WAREHOUSE+
                            REJECTION_DUE_TO_SUPPLIER+REJECTION_DUE_TO_PACKAGING)) AS ProducedUnits,
                            PRODUCTION_TO_MOVE_NO AS ProdnCompMove,
                            GETYEAR(PRODUCTION_TO_MOVE_NO) AS Year,
                            GETQTR(PRODUCTION_TO_MOVE_NO, GETYEAR(PRODUCTION_TO_MOVE_NO)) AS Qtr,
                            OVERHEAD_COST AS OverheadCost,
                            STATUS AS Status
                     FROM
                        opr_main_tbl omt
                        INNER JOIN
                        opr_production_main_tbl opmt ON opmt.OPR_MAIN_ID = omt.OPR_MAIN_ID
                        INNER JOIN
                        opr_product_game_mstr pm ON pm.PRODUCT_ID = opmt.PRODUCT_ID
                     WHERE
                        omt.move_no = ? and  omt.team_id=?
                GROUP BY 1, 2 ');
        $query = $this -> db -> query($sql,array($moveNo,$teamId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function opsRejectionDtl($moveNo,$teamId)
    {
        $sql = ('SELECT omt.OPR_MAIN_ID,opmt.PRODUCTION_MAIN_ID,
                    (SHORTAGE_DUE_TO_PLANT_CAPACITY+SHORTAGE_DUE_TO_MACHINE_CAPACITY) AS DuetoCapacity,
                    (SHORTGE_DUE_TO_OPERATOR_EFFECTIVENESS+SHORTAGE_DUE_TO_OPERATOR_AVAILABILITY) AS DuetoOperator,
                    REJECTION_DUE_TO_MACHINERY AS DuetoMachie,REJECTION_DUE_TO_WAREHOUSE AS Duetowarehouse,
                    REJECTION_DUE_TO_SUPPLIER AS DuetoSupplier,REJECTION_DUE_TO_PACKAGING AS DuetoPackaging
                FROM
                    opr_main_tbl omt
                        INNER JOIN
                    opr_production_main_tbl opmt ON opmt.OPR_MAIN_ID = omt.OPR_MAIN_ID
                        INNER JOIN
                    opr_product_game_mstr pm ON pm.PRODUCT_ID = opmt.PRODUCT_ID
                WHERE
                    omt.move_no = ? and  omt.team_id=?
                GROUP BY 1, 2');
        $query = $this -> db -> query($sql,array($moveNo,$teamId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function opsProductPlantDtl($moveNo,$teamId)
    {
        $sql = ('SELECT omt.OPR_MAIN_ID,opmt.PRODUCTION_MAIN_ID,
                        PLANT_DESC AS PlantName,
                        MACHINE_DESC AS MachineName,
                        WAREHOUSE_DESC AS Warehouse,
                        PACKAGING_DESC AS Packaging
                 FROM
                    opr_main_tbl omt
                        INNER JOIN
                    opr_production_main_tbl opmt ON opmt.OPR_MAIN_ID = omt.OPR_MAIN_ID
                        INNER JOIN 
                      opr_production_plant_mapping_tbl  oppmt on oppmt.PRODUCTION_MAIN_ID = opmt.PRODUCTION_MAIN_ID
                          INNER JOIN 
                    opr_plant_game_mstr opgm ON opgm.PLANT_GAME_MSTR_ID = oppmt.PLANT_ID
                     INNER JOIN 
                     opr_production_machinery_mapping_tbl opmmt ON opmmt.PRODUCTION_PLANT_MAP_ID = oppmt.PRODUCTION_PLANT_MAP_ID
                    INNER JOIN
                    opr_machinery_game_mstr omgm on omgm.MACHINE_GAME_MSTR_ID = opmmt.MACHINE_ID
                     INNER JOIN
                    opr_production_warehouse_mapping_tbl opwmt on opwmt.PRODUCTION_MAIN_ID = opmt.PRODUCTION_MAIN_ID
                    INNER JOIN
                    opr_warehouse_game_mstr owgm on owgm.WAREHOUSE_GAME_MSTR_ID = opwmt.WAREHOUSE_ID
                    INNER JOIN
                    opr_packaging_game_mstr opagm on opagm.PACKAGING_ID = opmt.PACKAGING_ID
                    INNER JOIN
                    opr_packaging_category_game_mstr opcgm on opcgm.PACKAGING_CATEGORY_ID = opagm.PACKAGING_CATEGORY_ID
                    WHERE
                    omt.move_no = ? and  omt.team_id=? group by 1');
        $query = $this -> db -> query($sql,array($moveNo,$teamId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function opsProdResourceDtl($moveNo,$teamId)
    {
        $sql = ('SELECT omt.OPR_MAIN_ID,
                        opmt.PRODUCTION_MAIN_ID,
                        DESIGNATION_NAME AS DesignationName,
                        NO_EMPLOYEES AS Employees
                 from opr_main_tbl omt 
                    inner join opr_production_main_tbl opmt on opmt.OPR_MAIN_ID = omt.OPR_MAIN_ID
                    inner join opr_production_employess_mapping_tbl opemt 
                    on opemt.PRODUCTION_MAIN_ID = opmt.PRODUCTION_MAIN_ID
                    inner join hr_designation_game_mstr hdgm on hdgm.DESIGNATION_ID = opemt.DESIGNATION_ID
                 where omt.MOVE_NO = ? and omt.TEAM_ID=? ');
        $query = $this -> db -> query($sql,array($moveNo,$teamId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function opsPlantPurchaseDtl($moveNo,$teamId)
    {
        $sql = ('Select opmt.OPR_PURCHASE_MAIN_ID,opmt.move_no AS BoughtMoveNo,
                        PLANT_DESC AS PlantName,
                        VALUE_DURING_DEPLOYMENT AS Cost,
                        (NO_MOVES_TO_SETUP_PLANT+opmt.move_no)MoveNo,
                        GETYEAR(NO_MOVES_TO_SETUP_PLANT+opmt.move_no) AS Year,
                        GETQTR(NO_MOVES_TO_SETUP_PLANT+opmt.move_no, GETYEAR(NO_MOVES_TO_SETUP_PLANT+opmt.move_no)) AS Qtr
                 from 
                    opr_purchase_main_tbl opmt
                    inner join opr_plant_purchase_tbl oppt on oppt.OPR_PURCHASE_MAIN_ID = opmt.OPR_PURCHASE_MAIN_ID
                    inner join opr_plant_game_mstr opgm on opgm.PLANT_GAME_MSTR_ID = oppt.PLANT_MSTR_ID
                 where opmt.move_no=? and opmt.TEAM_ID = ? ');
        $query = $this -> db -> query($sql,array($moveNo,$teamId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function opsMachinePurchaseDtl($moveNo,$teamId)
    {
        $sql = ('Select opmt.OPR_PURCHASE_MAIN_ID,opmt.move_no AS BoughtMoveNo,
                        MACHINE_DESC AS MachineName,
                        NO_OF_MACHINES AS NoOfMachines,
                        VALUE_DURING_DEPLOYMENT AS Cost,
                        (MACHINE_AVAILABLE_IN_NO_MOVES+opmt.move_no) AS MoveNo,
                        GETYEAR(MACHINE_AVAILABLE_IN_NO_MOVES+opmt.move_no) AS Year,
                        GETQTR(MACHINE_AVAILABLE_IN_NO_MOVES+opmt.move_no, GETYEAR(MACHINE_AVAILABLE_IN_NO_MOVES+opmt.move_no)) AS Qtr
                 from 
                    opr_purchase_main_tbl opmt
                    inner join opr_machinery_purchase_tbl ompt on ompt.OPR_PURCHASE_MAIN_ID = opmt.OPR_PURCHASE_MAIN_ID
                    inner join opr_machinery_game_mstr omgm on omgm.MACHINE_GAME_MSTR_ID = ompt.MACHINE_MSTR_ID
                 where opmt.move_no=? and opmt.TEAM_ID = ? ');
        $query = $this -> db -> query($sql,array($moveNo,$teamId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function opsWarehousePurchaseDtl($moveNo,$teamId)
    {
        $sql = ('SELECT  opmt.OPR_PURCHASE_MAIN_ID,opmt.move_no AS BoughtMoveNo,
                         WAREHOUSE_DESC AS WarehouseName,
                         VALUE_DURING_DEPLOYMENT AS Cost,NO_OF_MOVES_FOR_SETUP AS MoveNo,
                         GETYEAR(NO_OF_MOVES_FOR_SETUP+opmt.move_no) AS Year,
                         GETQTR(NO_OF_MOVES_FOR_SETUP+opmt.move_no, GETYEAR(NO_OF_MOVES_FOR_SETUP+opmt.move_no)) AS Qtr
                 from 
                    opr_purchase_main_tbl opmt
                    inner join opr_warehouse_purchase_tbl owpt on owpt.OPR_PURCHASE_MAIN_ID = opmt.OPR_PURCHASE_MAIN_ID
                    inner join opr_warehouse_game_mstr owgm on owgm.WAREHOUSE_GAME_MSTR_ID = owpt.WAREHOUSE_MSTR_ID
                 where opmt.move_no=? and opmt.TEAM_ID = ?');
        $query = $this -> db -> query($sql,array($moveNo,$teamId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function hrDesignDeptWiseRecruit($teamId,$gameId)
    {
        $sql = (' SELECT DESIGNATION_NAME as DesignationName,DEPARTMENT_NAME As DepartmentName,
                        IFNULL(NO_OF_EMPLOYEES_NEEDED,0)NO_OF_EMPLOYEES_NEEDED,
                        IFNULL(NO_OF_PEOPLE_ACCEPTED,0) NO_OF_PEOPLE_ACCEPTED
                 FROM 
                    hr_designation_game_mstr hdgm
                    LEFT JOIN
                        (SELECT DESIGNATION_ID, DEPARTMENT_ID,
                                SUM(NO_OF_EMPLOYEES_NEEDED)NO_OF_EMPLOYEES_NEEDED,
                                (SUM(NO_OF_EMPLOYEES_NEEDED)-
                                SUM(CONVERSION_LOSS_DUE_TO_CHANNEL+
                                CONVERSION_LOSS_DUE_TO_SALARY+
                                CONVERSION_LOSS_DUE_TO_BRAND_IMG)) NO_OF_PEOPLE_ACCEPTED
                        FROM 
                            hr_recruitment_tbl hrt
                        WHERE hrt.TEAM_ID = ? AND hrt.MOVE_NO>0  GROUP BY hrt.DESIGNATION_ID,hrt.DEPARTMENT_ID)A
                     ON hdgm.DESIGNATION_ID = A.DESIGNATION_ID
                     inner join department_mstr dm on dm.DEPARTMENT_ID = A.DEPARTMENT_ID
                 WHERE hdgm.GAME_ID = ? group by 1,2');
        $query = $this -> db -> query($sql,array($teamId,$gameId));
        return $query -> result_array();
    }
    function mylearninglist($teamId)
    {
        $sql = (' SELECT MYLEARNING_id,
                         YEAR,
                         QUARTER,
                         MY_LEARNING,
                         GAME_ID,
                         TEAM_ID,
                         USERNAME,
                         DATE
                  FROM mylearning WHERE team_id=?');
        $query = $this -> db -> query($sql,array($teamId));
        return $query -> result_array();
    }
    function expenseStatement($teamId,$departmentId)
    {
        $sql = ('SELECT
                    GETYEAR(MOVE_NO) AS Year,
                    GETQTR(MOVE_NO, GETYEAR(MOVE_NO)) AS Qtr, 
                    TRANSACTION_FOR, 
                    SUM(BUDGET_AVAILABLE) AS Amount
                FROM
                    department_budget_tbl_audit
                WHERE
                    team_id = ? AND department_id = ?
                GROUP BY DEPARTMENT_BUDGET_AUD_ID
                ORDER BY DEPARTMENT_BUDGET_AUD_ID');
        $query = $this -> db -> query($sql,array($teamId,$departmentId));
        return $query -> result_array();
    }
}
?>