<?php
class Dialogueservice_model extends CI_Model {
	function __construct() {
		parent::__construct();
	}

	function getDetailsForUgsId($ugsStatusId) 
	{
		$sql = ('SELECT * FROM dial_user_game_status dugs
		inner join dial_game_seg_story_map_mstr dgssmm on dugs.gs_map_id = dgssmm.gs_map_id
		where ugs_status_id = ?'); 
		$query = $this -> db -> query($sql, array($ugsStatusId));
		return $query -> result();
	}
	
	function getComputerStatements() 
	{
		$sql = ('SELECT * FROM dial_player_stmt_mstr where play_stmt_code = \'10002\''); 
        //$this->db->cache_delete($this->router->fetch_class(), $this->router->fetch_method());
        //$this->db->simple_query('SET NAMES \'utf-8\'');				
		$query = $this -> db -> query($sql);

		return $query -> result();
	}
	
	function insertComputerStatements($statement) 
	{
		$sql = ('insert into dial_comp_stmt_mstr(COMP_STMT_DESC) values(?)');
		$query = $this -> db -> query($sql, array($statement));
	}
	
	function updateComputerStatements($statement,$stmtcode) 
	{
		$sql = ('update dial_comp_stmt_mstr set COMP_STMT_DESC = ? where COMP_STMT_CODE = ?');
		$query = $this -> db -> query($sql, array($statement,$stmtcode));
	}
	
	function getCompPlayStatementsForTrigger($compstmtcode) 
	{
		$sql = ('SELECT "" filter_type,
                    "" FILTER,
                    "" FILTERLOGO,
                    "" SECONDFILTER,
                    "" SECONDFILTERLOGO,
                    "COMP" TYPE,
                    comp_stmt_code CODE,
                    comp_stmt_desc AS DESCRIPTION,
                    COMP_STMT_TYPE,
                    MEDIA_URL,
                    MEDIA_TYPE,
                    COALESCE(GAME_OBJECT, "") GAME_OBJECT,
                    COALESCE(NPC_TEXT, "") NPC_TEXT,
                    AVAILABLE_FOR_TIME_SEC,
                    IMAGE_CSS_CLASS
                FROM
                    dial_comp_stmt_mstr
                WHERE
                    COMP_STMT_CODE = ? 
                UNION SELECT * FROM (SELECT dfm.filter_type ,
                    dfm.FILTER_TITLE FILTER,
                    dfm.FILTER_ICON_PATH FILTERLOGO,
                    ST2.FILTER_TITLE SECONDFILTER,
                    ST2.FILTER_ICON_PATH SECONDFILTERLOGO,
                    "PLAY" TYPE,
                    dpsm.play_stmt_code CODE,
                    STRIP_TAGS(play_stmt_desc) AS DESCRIPTION,
                    "" AS COMP_STMT_TYPE,
                    COALESCE(MEDIA_URL, "") MEDIA_URL,
                    COALESCE(MEDIA_TYPE, "") MEDIA_TYPE,
                    "" AS GAME_OBJECT,
                    "" AS NPC_TEXT,
                    "" AS AVAILABLE_FOR_TIME_SEC,
                    "" 
                FROM
                    dial_player_stmt_mstr dpsm
                        LEFT JOIN
                    dial_param_options_map_mstr dpomm ON dpomm.PARAM_OPTIONS_GROUP_CODE = dpsm.PARAM_OPTIONS_GROUP_CODE
                        LEFT JOIN
                    dial_filter_mstr dfm ON dfm.filter_id = dpomm.value
                        LEFT JOIN
                    (SELECT 
                        dpsm2.PLAY_STMT_CODE,
                            dfm2.FILTER_TITLE,
                            dfm2.FILTER_ICON_PATH
                    FROM
                        dial_player_stmt_mstr dpsm2
                    LEFT JOIN dial_param_options_map_mstr dpomm2 ON dpomm2.PARAM_OPTIONS_GROUP_CODE = dpsm2.PARAM_OPTIONS_GROUP_CODE
                    LEFT JOIN dial_filter_mstr dfm2 ON dfm2.filter_id = dpomm2.value
                    WHERE
                        source_COMP_STMT_CODE = ?
                            AND dfm2.filter_type = "STANDALONE") ST2 ON ST2.PLAY_STMT_CODE = dpsm.PLAY_STMT_CODE
                WHERE source_COMP_STMT_CODE = ?) A ');
				if(substr($compstmtcode,0,4) != '1015')
				$sql = $sql.'WHERE (A.filter_type = "STANDALONE" OR (A.filter_type = "GROUPED" AND A.SECONDFILTER IS NULL)  or A.filter_type is null)';
				else
				$sql = $sql.'WHERE (A.filter_type = "GROUPED" OR (A.filter_type = "STANDALONE" AND A.SECONDFILTER IS NULL)  or A.filter_type is null)';
		$query = $this -> db -> query($sql, array($compstmtcode,$compstmtcode,$compstmtcode));
		return $query -> result();
	}
	
	function categorywiseCondnCompStmtsForPlayer($in) 
	{
		$inArray = explode(',', $in);		
		// Used to Fetch Computer Statement Set based on certain conditions like '>' or '<' Eg: ntries where move_no < 20; $in = 'GAME=STRATUP,ROLE=HR,MOVE_NO<20'
		$sql = 'SELECT t.COMP_STMT_CODE FROM (SELECT COMP_STMT_CODE FROM dial_param_compstmt_map_mstr WHERE CONCAT(PARAMETER_CODE,COMPARATOR,VALUE) = \''.$inArray[0].'\') t ';
		//$sql = ('SELECT DISTINCT COMP_STMT_CODE FROM dial_param_compstmt_map_mstr WHERE CONCAT(PARAMETER_CODE,COMPARATOR,VALUE) IN ('.$in.')');
        $i=0;		
		foreach ($inArray as $inArrayVal)
		{
            if (($i!=0))
            {		
				$condnArray = '';		
				$istr = $i;		
				if (strpos($inArrayVal, '=') !== false)
					$sql = $sql.' INNER JOIN  (SELECT COMP_STMT_CODE FROM dial_param_compstmt_map_mstr WHERE CONCAT(PARAMETER_CODE,COMPARATOR,VALUE) = \''.$inArrayVal.'\') t'.$istr.' on t.COMP_STMT_CODE = t'.$istr.'.COMP_STMT_CODE ';
				else if (strpos($inArrayVal, '>') !== false)
				{
					$condnArray = explode('>', $inArrayVal);
					$sql = $sql.' INNER JOIN  (SELECT COMP_STMT_CODE FROM dial_param_compstmt_map_mstr WHERE PARAMETER_CODE = \''.$condnArray[0].'\' AND VALUE > '.$condnArray[1].') t'.$istr.' on t.COMP_STMT_CODE = t'.$istr.'.COMP_STMT_CODE';
				}
				else if (strpos($inArrayVal, '<') !== false)
				{
					$condnArray = explode('<', $inArrayVal);
					$sql = $sql.' INNER JOIN  (SELECT COMP_STMT_CODE FROM dial_param_compstmt_map_mstr WHERE PARAMETER_CODE = \''.$condnArray[0].'\' AND VALUE < '.$condnArray[1].') t'.$istr.' on t.COMP_STMT_CODE = t'.$istr.'.COMP_STMT_CODE';
				}
			}
            $i++;			
		}
		$query = $this -> db -> query($sql);
		return $query -> result();
	}
	
	function getCompStmtsForGame($in,$mode,$status,$ugsStatusId,$compStmtType) 
	{
		$inArray = explode(',', $in);		
		// Used to Fetch Computer Statement Set based on certain conditions like '>' or '<' Eg: ntries where move_no < 20; $in = 'GAME=STRATUP,ROLE=HR,MOVE_NO<20'
		if ($mode == 'SUMMARY')
			$sql = 'SELECT dcstm.COMP_STMT_TYPE,dcstm.COMP_STMT_TYPE_DESC,dcstm.ICON_PATH,COUNT(*) CNT ';
		else
			$sql = 'SELECT dcsm.COMP_STMT_CODE,COMP_STMT_DESC,COMP_STMT_TITLE,MEDIA_URL ';
		$sql = $sql.' FROM (SELECT COMP_STMT_CODE FROM dial_param_compstmt_map_mstr WHERE CONCAT(PARAMETER_CODE,COMPARATOR,VALUE) = \''.$inArray[0].'\') t ';

        $i=0;		
		foreach ($inArray as $inArrayVal)
		{
            if (($i!=0))
            {		
				$condnArray = '';		
				$istr = $i;		
				if (strpos($inArrayVal, '=') !== false)
					$sql = $sql.' INNER JOIN  (SELECT COMP_STMT_CODE FROM dial_param_compstmt_map_mstr WHERE CONCAT(PARAMETER_CODE,COMPARATOR,VALUE) = \''.$inArrayVal.'\') t'.$istr.' on t.COMP_STMT_CODE = t'.$istr.'.COMP_STMT_CODE ';
				else if (strpos($inArrayVal, '>') !== false)
				{
					$condnArray = explode('>', $inArrayVal);
					$sql = $sql.' INNER JOIN  (SELECT COMP_STMT_CODE FROM dial_param_compstmt_map_mstr WHERE PARAMETER_CODE = \''.$condnArray[0].'\' AND VALUE > '.$condnArray[1].') t'.$istr.' on t.COMP_STMT_CODE = t'.$istr.'.COMP_STMT_CODE';
				}
				else if (strpos($inArrayVal, '<') !== false)
				{
					$condnArray = explode('<', $inArrayVal);
					$sql = $sql.' INNER JOIN  (SELECT COMP_STMT_CODE FROM dial_param_compstmt_map_mstr WHERE PARAMETER_CODE = \''.$condnArray[0].'\' AND VALUE < '.$condnArray[1].') t'.$istr.' on t.COMP_STMT_CODE = t'.$istr.'.COMP_STMT_CODE';
				}
			}
            $i++;			
		}
		$sql = $sql.' INNER JOIN dial_comp_stmt_mstr dcsm ON t.COMP_STMT_CODE = dcsm.COMP_STMT_CODE
		INNER JOIN dial_comp_stmt_type_mstr dcstm ON dcstm.COMP_STMT_TYPE = dcsm.COMP_STMT_TYPE WHERE dcsm.COMP_STMT_CODE ';
		if ($status == 'PENDING')
			$sql = $sql.'NOT'; 
		$sql = $sql.' IN (SELECT dpat.COMP_STMT_CODE FROM dial_player_action_tbl dpat where dpat.UGS_STATUS_ID=?)';
		
		if ($compStmtType != '')
		{
			$sql = $sql.' AND dcsm.COMP_STMT_TYPE = ?';
			$query = $this -> db -> query($sql, array($ugsStatusId,$compStmtType));
		}
		else
		{
			$sql = $sql.' group by 1,2';
			$query = $this -> db -> query($sql, array($ugsStatusId));
		}
        // echo $this->db->last_query();
		return $query -> result();
	}
	
	function answerwiseCompStmtsForPlayer($answer) 
	{
		$sql = ('SELECT DESTN_COMP_STMT_CODE FROM dial_player_stmt_mstr WHERE PLAY_STMT_CODE = ?');
		$query = $this -> db -> query($sql, array($answer));
		return $query -> result();
		//Also update transaction table and points table
	}	
	
	function descwiseCompStmtsForPlayer($compstmtcode,$answerdesc) 
	{
		$sql = ('SELECT DESTN_COMP_STMT_CODE FROM dial_player_stmt_mstr WHERE SOURCE_COMP_STMT_CODE = ? and PLAY_STMT_DESC = ?');
		$query = $this -> db -> query($sql, array($compstmtcode,$answerdesc));
		return $query -> result();
		//Also update transaction table and points table
	}	
	
	function insertActions($compstatement,$playstatement,$ugsStatusId) 
	{
		$sql = ('insert into dial_player_action_tbl(COMP_STMT_CODE,PLAY_STMT_CODE,UGS_STATUS_ID) values(?,?,?)');
		$query = $this -> db -> query($sql, array($compstatement,$playstatement,$ugsStatusId));
	}
	
	function isPointsInitiated($answer,$ugsStatusId) 
	{
		$sql = ('SELECT case when count(*) > 0 then "TRUE" WHEN COUNT(*) = 0 THEN "FALSE" END AS ISPOINTS FROM dial_player_points_tbl where UGS_STATUS_ID = ?');
		$query = $this -> db -> query($sql, array($ugsStatusId));
		return $query -> result();
	}	
	
	function insertPoints($answer,$ugsStatusId) 
	{
			$sql = ('insert into dial_player_points_tbl(UGS_STATUS_ID,POINTS_PARAM_CODE,VALUE) SELECT ?,dppm.POINTS_PARAM_CODE,
	CASE INCREASE_DECREASE
	WHEN "I" THEN 0+pspm.VALUE
	WHEN "D" THEN 0-pspm.VALUE
	END AS VALUE1
	FROM dial_player_stmt_points_mstr pspm 
	INNER JOIN dial_points_param_mstr dppm on pspm.POINTS_PARAM_CODE = dppm.POINTS_PARAM_CODE 
	WHERE PLAY_STMT_CODE = ?');
			$query = $this -> db -> query($sql, array($ugsStatusId,$answer));
	}
	function updatePoints($answer,$ugsStatusId) 
	{
			$sql = ('update dial_player_points_tbl dppt1 inner join 
		(SELECT dppm.POINTS_PARAM_CODE,
		CASE INCREASE_DECREASE
		WHEN "I" THEN dppt.VALUE+pspm.VALUE
		WHEN "D" THEN dppt.VALUE-pspm.VALUE
		END AS VALUE1
		FROM dial_player_stmt_points_mstr pspm 
		INNER JOIN dial_points_param_mstr dppm on pspm.POINTS_PARAM_CODE = dppm.POINTS_PARAM_CODE 
		INNER JOIN dial_player_points_tbl dppt on dppm.POINTS_PARAM_CODE = dppt.POINTS_PARAM_CODE
		WHERE PLAY_STMT_CODE = ? AND UGS_STATUS_ID = ?) updatevalues on dppt1.POINTS_PARAM_CODE = updatevalues.POINTS_PARAM_CODE
		set dppt1.value = updatevalues.value1
		where dppt1.UGS_STATUS_ID = ?');
			$query = $this -> db -> query($sql, array($answer,$ugsStatusId,$ugsStatusId));		
	}
	
	function getPlayerPointsForGame($ugsStatusId) 
	{
		//Returns the  points for the current level for the given user and game
		$sql = ('SELECT POINTS_PARAM_DESC,DPPM.POINTS_PARAM_TYPE ,SUM(value) VALUE,SUM(target)target,case when round(sum(value)/sum(target)*100) >100 then 100 when round(sum(value)/sum(target)*100) < (-100) then (-100) else round(sum(value)/sum(target)*100) end percent,POINTS_PARAM_ICON_PATH FROM dial_player_points_tbl dppt
inner join dial_story_param_target_mstr dsptm on dppt.POINTS_PARAM_CODE  = dsptm.POINTS_PARAM_CODE
inner join dial_points_param_mstr dppm on dppt.POINTS_PARAM_CODE  = dppm.POINTS_PARAM_CODE
inner join dial_user_game_status dugs on dugs.ugs_status_id = dppt.ugs_status_id
inner join dial_game_seg_story_map_mstr dgssmm on dgssmm.story_id = dsptm.story_id  and dugs.gs_map_id = dgssmm.gs_map_id
where dppt.ugs_status_id= ? AND DPPM.POINTS_PARAM_TYPE IN (\'N\',\'D\',\'A\') GROUP BY 1,2');
		$query = $this -> db -> query($sql, array($ugsStatusId));
		return $query -> result();
	}
	
	function getSettingsForGame($ugsStatusId) 
	{
		$sql = ('SELECT * FROM dial_player_points_tbl WHERE UGS_STATUS_ID = ?');
		$query = $this -> db -> query($sql, array($ugsStatusId));
		return $query -> result();
	}
	
	function getTotalPointsForGame($userId,$gameId) 
	{
		//Returns sum of all levels' points param for the given user and game
		$sql = ('SELECT dppm.POINTS_PARAM_CODE,dppm.POINTS_PARAM_DESC,dppm.POINTS_PARAM_ICON_PATH,SUM(VALUE) FROM dial_player_points_tbl ppt 
		INNER JOIN dial_points_param_mstr dppm on ppt.POINTS_PARAM_CODE = dppm.POINTS_PARAM_CODE 
		inner join dial_user_game_status dugs on dugs.UGS_STATUS_ID = ppt.UGS_STATUS_ID
		inner join dial_game_seg_story_map_mstr dgssmm on dgssmm.GS_MAP_ID = dugs.GS_MAP_ID WHERE 
		USER_ID = ? AND GAME_ID = ? AND STATUS=\'P\' GROUP BY 1,2,3');
		$query = $this -> db -> query($sql, array($userId,$gameId));
		return $query -> result();
	}
	
	function getPointsForAnswer($answer) 
	{
		$sql = ('SELECT dppm.POINTS_PARAM_DESC,INCREASE_DECREASE,VALUE FROM dial_player_stmt_points_mstr pspm INNER JOIN dial_points_param_mstr dppm on pspm.POINTS_PARAM_CODE = dppm.POINTS_PARAM_CODE WHERE PLAY_STMT_CODE = ?');
		$query = $this -> db -> query($sql, array($answer));
		return $query -> result();
	}

	function getPointsForAnimation($answer) 
	{
		$sql = ('SELECT 
                    dppm.POINTS_PARAM_DESC,
                    CASE
                        WHEN INCREASE_DECREASE = "I" THEN CONCAT("+", VALUE)
                        ELSE CONCAT("-", VALUE)
                    END AS VALUE,
                    POINTS_PARAM_ICON_PATH,
                    PLAY_STMT_CUE
                FROM
                    dial_player_stmt_points_mstr pspm
                        INNER JOIN
                    dial_points_param_mstr dppm ON pspm.POINTS_PARAM_CODE = dppm.POINTS_PARAM_CODE
                        INNER JOIN
                    dial_player_stmt_mstr dpsm ON dpsm.PLAY_STMT_CODE = pspm.PLAY_STMT_CODE
                WHERE
                    dpsm.PLAY_STMT_CODE = ?
                        AND POINTS_PARAM_TYPE = "D"');
		$query = $this -> db -> query($sql, array($answer));
		return $query -> result();
	}
	
	function getBotSuggestions($searchtext) 
	{
		$sql = ('SELECT COMP_STMT_CODE,strip_tags(COMP_STMT_DESC) COMP_STMT_DESC FROM dial_comp_stmt_mstr 
		where COMP_STMT_TYPE = "BOT" AND lower(MEDIA_URL) like lower("%'.$searchtext.'%")');
		$query = $this -> db -> query($sql);
		return $query -> result();
	}	
	
	function getTimeAvailableForCurrentGame($ugsStatusId) 
	{
		$sql = ('SELECT greatest(round(dgssmm.TIME_LIMIT_SECONDS-time_to_sec(timediff(current_timestamp(),started_on))),0) TIME_AVAILABLE FROM dial_user_game_status  dugs
		INNER JOIN dial_game_seg_story_map_mstr dgssmm on dugs.GS_MAP_ID = dgssmm.GS_MAP_ID 
		where ugs_status_id = ?'); 
		$query = $this -> db -> query($sql, array($ugsStatusId));
		return $query -> result();
	}
	
	function getStoryForUserGame($gameId,$userId) 
	{
		//Returns story for game not played yet by the user
		$sql = ('select * from dial_story_mstr dsm 
		inner join dial_game_seg_story_map_mstr dgssmm on dsm.story_id = dgssmm.story_id 
		where game_id = ? and gs_map_id not in (SELECT gs_map_id FROM dial_user_game_status where user_id = ? and completed_on is not null) limit 1'); 
		$query = $this -> db -> query($sql, array($gameId,$userId));
		return $query -> result();
	}
	
	function getRandomStoryForGame($gameId) 
	{
		$sql = ('select * from dial_story_mstr dsm 
		inner join dial_game_seg_story_map_mstr dgssmm on dsm.story_id = dgssmm.story_id 
		where game_id = ?  ORDER BY RAND() limit 1'); 
		$query = $this -> db -> query($sql, array($gameId));
		return $query -> result();
	}
	
	function getGsMapIdForGameStory($gameId,$storyId) 
	{
		$sql = ('select * from dial_story_mstr dsm 
		inner join dial_game_seg_story_map_mstr dgssmm on dsm.story_id = dgssmm.story_id 
		where game_id = ?  and dsm.story_id = ?'); 
		$query = $this -> db -> query($sql, array($gameId,$storyId));
		return $query -> result();
	}
	
	function isGameStatusInitiated($userId,$gsMapId) 
	{
		$sql = ('SELECT case when count(*) > 0 then "TRUE" WHEN COUNT(*) = 0 THEN "FALSE" END AS ISGAME FROM dial_user_game_status where USER_ID = ? AND GS_MAP_ID = ?');
		$query = $this -> db -> query($sql, array($userId,$gsMapId));
		return $query -> result();
	}	
	
	function insertGameStatus($userId,$gsMapId) 
	{
		$sql = ('INSERT INTO dial_user_game_status (USER_ID,GS_MAP_ID) VALUES (?,?)');
		$query = $this -> db -> query($sql, array($userId,$gsMapId));
	}	
	
	function updateGameStatus($userId,$gsMapId,$status) 
	{
		if ($status == 'COMPLETED')
			$sql = ('update dial_user_game_status set COMPLETED_ON = (CURRENT_TIMESTAMP()) , STATUS = \'C\' where USER_ID = ? AND GS_MAP_ID = ?');
		else
			$sql = ('update dial_user_game_status set COMPLETED_ON = NULL , STATUS = \'P\' where USER_ID = ? AND GS_MAP_ID = ?');			
		$query = $this -> db -> query($sql, array($userId,$gsMapId));		
	}	
	
	function getFiltersForGame($gameId,$parentFilterId,$filterType) 
	{
		$sql = 'SELECT * FROM dial_filter_mstr where game_id = ? and status = \'A\' and FILTER_TYPE = ? and parent_filter_id ';
		if ($parentFilterId != '')
		{
			$sql = $sql.' = ?';
			$query = $this -> db -> query($sql, array($gameId,$filterType,$parentFilterId));
		}
		else
		{			
			$sql = $sql.' is null';
			$query = $this -> db -> query($sql, array($gameId,$filterType));			
		}
		return $query -> result();
	}	
	
	function getPlayStmtsForGameFilter($in) 
	{
		/*$in='GROUPED=5,STANDALONE3=8'*/
		$inArray = explode(',', $in);		
		$sql = 'SELECT PLAY_STMT_CODE,PLAY_STMT_DESC FROM (SELECT PARAM_OPTIONS_GROUP_CODE FROM dial_param_options_map_mstr 
					WHERE CONCAT(PARAMETER_CODE,COMPARATOR,VALUE) = '.$inArray[0].') t ';

        $i=0;		
		foreach ($inArray as $inArrayVal)
		{
            if (($i!=0))
            {		
				$condnArray = '';		
				$istr = $i;		
				$sql = $sql.' INNER JOIN  (SELECT PARAM_OPTIONS_GROUP_CODE FROM dial_param_options_map_mstr 
								WHERE CONCAT(PARAMETER_CODE,COMPARATOR,VALUE) = '.$inArrayVal.') t'.$istr.' on t.PARAM_OPTIONS_GROUP_CODE = t'.$istr.'.PARAM_OPTIONS_GROUP_CODE ';
			}
            $i++;			
		}
		$sql = $sql.' INNER JOIN dial_player_stmt_mstr dcsm ON t.PARAM_OPTIONS_GROUP_CODE = dcsm.PARAM_OPTIONS_GROUP_CODE ';
		$query = $this -> db -> query($sql);
		return $query -> result();
	}	
	
	function getStoriesForGame($gameId)
	{
		$sql = ('SELECT * FROM dial_game_seg_story_map_mstr dgssmm inner join dial_story_mstr dsm on dgssmm.story_id = dsm.story_id where game_id = ?');
		$query = $this -> db -> query($sql, array($gameId));
		return $query -> result();		
	}

	function getStoriesForGameUser($gameId,$userId)
	{
		// Returns all stories with lock unlock status and level/story rate for the given user and game
		$sql = ('		SELECT dgssmm.GS_MAP_ID,dgssmm.GAME_ID,dgssmm.STORY_ID,TIME_LIMIT_SECONDS,STORY_TITLE,STORY_DESC,STORY_SHORT_DESC,STORY_LANGUAGE,STORY_LOGO_URL, 
		round(((sum(COALESCE (value,0))/STAR_MAX_VAL)*3),0) MY_STAR_VAL, 
		case when round(((sum(COALESCE (value,0))/STAR_MAX_VAL)*3),0) < 1  || round(((sum(COALESCE (value,0))/STAR_MAX_VAL)*3),0) is null
		then \'YES\' else \'NO\' end NEXT_STORY_LOCK
		FROM dial_game_seg_story_map_mstr dgssmm 
		left join dial_story_mstr dsm on dgssmm.story_id = dsm.story_id 
		left join (select * from dial_user_game_status where user_id = ?) dugs on dgssmm.GS_MAP_ID = dugs.GS_MAP_ID 
		left JOIN dial_player_points_tbl ppt on dugs.UGS_STATUS_ID = ppt.UGS_STATUS_ID 
        left join dial_story_param_target_mstr dsptm on dsptm.story_id = dgssmm.story_id
		where game_id = ? and dsptm.TARGET_TYPE  = \'M\' 
        and (user_id = ? or user_id is null)
		group by 1,2,3,4,5,6  order by story_seq_no');
		$query = $this -> db -> query($sql, array($userId,$gameId,$userId));
		return $query -> result();		
	}
	
	function getStory($storyId)
	{
		$sql = ('SELECT * FROM dial_story_mstr where story_id=?');
		$query = $this -> db -> query($sql, array($storyId));
		return $query -> result();		
	}
	
	function getHistory($ugsStatusId)
	{
		$sql = ('SELECT 
                    *
                FROM
                    (SELECT 
                        PLAY_ACTION_CODE,
                            COMP_STMT_TITLE,
                            COMP_STMT_DESC DESCR,
                            COMP_STMT_TYPE,
                            MEDIA_URL,
                            IMAGE_CSS_CLASS
                    FROM
                        dial_player_action_tbl dpat
                    LEFT JOIN dial_comp_stmt_mstr dcsm ON dpat.comp_stmt_code = dcsm.comp_stmt_code
                    WHERE
                        UGS_STATUS_ID = ?
                            AND COMP_STMT_TYPE NOT IN ("STORY" , "VIEW") UNION SELECT 
                        PLAY_ACTION_CODE,
                            "" COMP_STMT_TITLE,
                            PLAY_STMT_DESC DESCR,
                            "" COMP_STMT_TYPE,
                            "resources/img/blank_user.png" MEDIA_URL,
                            ""
                    FROM
                        dial_player_action_tbl dpat
                    LEFT JOIN dial_player_stmt_mstr dpsm ON dpat.play_stmt_code = dpsm.play_stmt_code
                    WHERE
                        UGS_STATUS_ID = ?
                            AND PLAY_STMT_DESC <> "NULL") A
                ORDER BY A.PLAY_ACTION_CODE');
		$query = $this -> db -> query($sql, array($ugsStatusId,$ugsStatusId));
		return $query -> result();	
	}
	
	function getFiltersforQuestion($compstmtcode)
	{
		$sql = ('SELECT dpsm.PLAY_STMT_CODE,dpsm.PLAY_STMT_DESC,dfm.FILTER_ID,FILTER_TITLE,FILTER_ICON_PATH FROM dial_player_stmt_mstr dpsm	LEFT JOIN dial_player_stmt_filter_map_mstr dpfm on dpsm.play_stmt_code = dpfm.play_stmt_code
		left join dial_filter_mstr dfm on dpfm.filter_id = dfm.filter_id where source_comp_stmt_code = ?');
		$query = $this -> db -> query($sql, array($compstmtcode));
		return $query -> result();	
	}
	
	function getStoryForStarter($compstmtcode)
	{
		// Master Story Writing
		$sql = ('SELECT dpsm.PLAY_STMT_CODE,dpsm.PLAY_STMT_DESC,dfm.FILTER_ID,FILTER_TITLE,FILTER_ICON_PATH FROM dial_player_stmt_mstr dpsm	LEFT JOIN dial_player_stmt_filter_map_mstr dpfm on dpsm.play_stmt_code = dpfm.play_stmt_code
		left join dial_filter_mstr dfm on dpfm.filter_id = dfm.filter_id where source_comp_stmt_code = ?');
		$query = $this -> db -> query($sql, array($compstmtcode));
		return $query -> result();	
	}
	
	function getBulkStory($storyId)
	{
		//$sql = ('SELECT TREE_ID as id,TREE_PARENT_ID as parent,DESCRIPTION as name from bulk_story_upload where STORY_ID = ?');
		$sql = ('select * from (
				select concat(\'A\',play_stmt_code) AS id,play_stmt_desc as name,CONCAT(\'Q\',source_comp_stmt_code) AS parent from (select * from dial_comp_stmt_mstr where comp_stmt_code like \'1000%\') dcsm  left join (select * from dial_player_stmt_mstr where play_stmt_code like \'1000%\') dpsm on dcsm.comp_stmt_code =  dpsm.DESTN_COMP_STMT_CODE
				UNION ALL
				select ifnull(CONCAT(\'Q\',destn_comp_stmt_code),\'Q10001\') AS id, comp_stmt_desc as name, ifnull(concat(\'A\',play_stmt_code),\'0\') AS parent from (select * from dial_comp_stmt_mstr where comp_stmt_code like \'1000%\') dcsm  left join (select * from dial_player_stmt_mstr where play_stmt_code like \'1000%\') dpsm on dcsm.comp_stmt_code =  dpsm.DESTN_COMP_STMT_CODE)
				a where a.name is not null order by a.parent');
		$query = $this -> db -> query($sql, array($storyId));
		return $query -> result();	
	}	
	
	function getPlayerAnswersCategoryCountForStory($ugsStatusId,$parameterCode)
	{
		/* Used to get Feedback page data for Chart at Story Level - $parameterCode = 'GROUPED'/'STANDALONE'*/		
		$sql = ('SELECT 
                    CASE
                        WHEN FILTER_TITLE IS NULL THEN "Others"
                        ELSE FILTER_TITLE
                    END AS FILTER_TITLE,
                    a.cnt,
                    a.total,
                    ROUND((a.cnt * 100 / a.total), 2) percent
                FROM
                    (SELECT 
                        FILTER_TITLE,
                            COUNT(*) cnt,
                            (SELECT 
                                    COUNT(*)
                                FROM
                                    dial_player_action_tbl
                                WHERE
                                    ugs_status_id = ?) total
                    FROM
                        dial_player_action_tbl dpat
                    LEFT JOIN dial_player_stmt_mstr dpsm ON dpat.PLAY_STMT_CODE = dpsm.PLAY_STMT_CODE
                    LEFT JOIN (SELECT 
                        *
                    FROM
                        dial_param_options_map_mstr
                    WHERE
                        PARAMETER_CODE = ?) dpomm ON dpomm.PARAM_OPTIONS_GROUP_CODE = dpsm.PARAM_OPTIONS_GROUP_CODE
                    LEFT JOIN dial_filter_mstr dfm ON dfm.filter_id = dpomm.value
                    WHERE
                        ugs_status_id = ?
                            AND (PARAMETER_CODE = ?
                            OR PARAMETER_CODE IS NULL)
                    GROUP BY 1) a');
		$query = $this -> db -> query($sql, array($ugsStatusId,$parameterCode,$ugsStatusId,$parameterCode));
		return $query -> result();			
	}

	function getPlayerAnswersCategoryCountForGame($userId,$gameId,$parameterCode)
	{
		/* Used to get Feedback page data for Chart at User Game Level - $parameterCode = 'GROUPED'/'STANDALONE' */
		$sql = ('select a.FILTER_TITLE,a.cnt,a.total,round(a.cnt*100/a.total) percent from (
				select FILTER_TITLE,count(*) cnt,(select count(*) from dial_player_action_tbl where UGS_STATUS_ID in (
				SELECT UGS_STATUS_ID FROM dial_user_game_status dugs
				inner join dial_game_seg_story_map_mstr dgssmm on dugs.GS_MAP_ID = dgssmm.GS_MAP_ID
				where user_id = ? and game_id=?)) total from dial_player_action_tbl dpat  
				inner join dial_player_stmt_mstr dpsm on dpat.PLAY_STMT_CODE = dpsm.PLAY_STMT_CODE 
				inner join dial_param_options_map_mstr dpomm on dpomm.PARAM_OPTIONS_GROUP_CODE = dpsm.PARAM_OPTIONS_GROUP_CODE 
				inner join dial_filter_mstr dfm on dfm.filter_id = dpomm.value 
				where UGS_STATUS_ID in (
				SELECT UGS_STATUS_ID FROM dial_user_game_status dugs
				inner join dial_game_seg_story_map_mstr dgssmm on dugs.GS_MAP_ID = dgssmm.GS_MAP_ID
				where user_id = ? and game_id=?) and PARAMETER_CODE = ? group by 1) a');
		$query = $this -> db -> query($sql, array($userId,$gameId,$userId,$gameId,$parameterCode));
		return $query -> result();			
	}	
	
	function getPercentTargetAchievedForStory($ugsStatusId,$targetTypeMain)
	{
		/* Used to get Feedback page data for target achieved in progress bar at Story Level*/
		$sql = ('SELECT POINTS_PARAM_DESC,SUM(value)value,SUM(target)target,case when round(sum(value)/sum(target)*100)  > 100 then 100 when round(sum(value)/sum(target)*100)  < (-100) then (-100) else round(sum(value)/sum(target)*100) end percent FROM dial_player_points_tbl dppt
        inner join dial_story_param_target_mstr dsptm on dppt.POINTS_PARAM_CODE  = dsptm.POINTS_PARAM_CODE
        inner join dial_points_param_mstr dppm on dppt.POINTS_PARAM_CODE  = dppm.POINTS_PARAM_CODE
		inner join dial_user_game_status dugs on dugs.ugs_status_id = dppt.ugs_status_id
		inner join dial_game_seg_story_map_mstr dgssmm on dgssmm.story_id = dsptm.story_id
		where dppt.ugs_status_id= ? AND ');
		if($targetTypeMain == 'Y')
			$sql = $sql.'dsptm.TARGET_TYPE = "M" ';
		else
			$sql = $sql.'dsptm.TARGET_TYPE != "M" ';
		$sql = $sql.'GROUP BY 1 ';
		$query = $this -> db -> query($sql, array($ugsStatusId));
		return $query -> result();			
	}	
	
	function getPercentTargetAchievedForGame($userId,$gameId)
	{
		/* Used to get Feedback page data for target achieved in progress bar at User Game Level */
		$sql = ('SELECT value,target,case when round(value/target*100) > 100 then 100 when round(value/target*100) < (-100) then (-100) else round(value/target*100) end percent FROM dial_player_points_tbl dppt
		inner join dial_story_param_target_mstr dsptm on dppt.POINTS_PARAM_CODE  = dsptm.POINTS_PARAM_CODE
		inner join dial_user_game_status dugs on dugs.ugs_status_id = dppt.ugs_status_id
		inner join dial_game_seg_story_map_mstr dgssmm on dgssmm.story_id = dsptm.story_id
		where dppt.ugs_status_id in (SELECT UGS_STATUS_ID FROM dial_user_game_status dugs
		inner join dial_game_seg_story_map_mstr dgssmm on dugs.GS_MAP_ID = dgssmm.GS_MAP_ID
		where user_id = ? and game_id=?) ');
		$query = $this -> db -> query($sql, array($userId,$gameId));
		return $query -> result();			
	}
	
	function getMainTargetForStory($storyId)
	{
		/* Used to get Main Target Value for Story for display*/
		$sql = ('SELECT * FROM dial_story_param_target_mstr where story_id = ? and target_type = \'M\'');
		$query = $this -> db -> query($sql, array($storyId));
		return $query -> result();			
	}
    function getPlayerStmtForPlayStmtCode($playstmtcode)
    {
        $sql = ('select * from dial_player_stmt_mstr where PLAY_STMT_CODE = ?');
        $query = $this -> db -> query($sql, array($playstmtcode));
        return $query -> result_array();
        
    }
}
?>