<?php
class Gamemasters_model extends CI_Model {
	function __construct() {
		parent::__construct();
	}

	function getGameList() 
	{
		$sql = ('SELECT dgm.*,dgcm.GAME_CAT_ID,dgcm.GAME_CAT_DESC,dgcm.SEQ_NO,a.GAME_DETAIL_CODE,a.GAME_DETAIL_TITLE,a.GAME_DETAIL_DESC,
		 ROUND(ifnull(sum(duft.FEEDBACK_VALUE)/count(*),0),1) rating ,if(sum(duft.FEEDBACK_VALUE)>0,count(*) ,0) Total FROM dial_game_mstr dgm
        INNER JOIN dial_game_category_mstr dgcm on dgm.GAME_CAT_ID = dgcm.GAME_CAT_ID 
        left join(select * from dial_game_details_mstr where GAME_DETAIL_CODE=\'RIBBON\')A on A.GAME_ID = dgm.GAME_ID
         left JOIN dial_user_feedback_tbl duft ON dgm.game_id = duft.game_id
        where dgm.status in  (\'A\',\'U\') AND dgcm.status = \'A\' group by dgm.game_id ORDER BY DGM.SEQ_NO;'); 
		$query = $this -> db -> query($sql);
		return $query -> result();
	}	
	
	function getGameDescriptionForGameId($gameId) 
	{
		$sql = ('SELECT * FROM dial_game_mstr WHERE GAME_ID = ?'); 
		$query = $this -> db -> query($sql,array($gameId));
		return $query -> result();
	}	
	
	function getGameIdForGameTag($gameTag) 
	{
		$sql = ('SELECT GAME_ID FROM dial_game_mstr WHERE GAME_TAG = ?'); 
		$query = $this -> db -> query($sql,array($gameTag));
		return $query -> result();
	}	
	
	function getGameDetailsForGameId($gameId) 
	{
		$sql = ('SELECT * FROM dial_game_details_mstr WHERE GAME_ID = ?'); 
		$query = $this -> db -> query($sql,array($gameId));
		return $query -> result();
	}	
	
	function getGameDetailsForGameIdDetailsCode($gameId,$gameDetailCode) 
	{
		$sql = ('SELECT * FROM dial_game_details_mstr WHERE GAME_ID = ? AND STATUS = \'A\' AND GAME_DETAIL_CODE = ?'); 
		$query = $this -> db -> query($sql,array($gameId,$gameDetailCode));
		return $query -> result();
	}	
	
	function getTitleForGameIdDetailsCode($gameId,$gameDetailCode) 
	{
		$sql = ('SELECT DISTINCT GAME_DETAIL_CODE,GAME_DETAIL_TITLE FROM dial_game_details_mstr WHERE GAME_ID = ? AND GAME_DETAIL_CODE = ? AND STATUS = \'A\''); 
		$query = $this -> db -> query($sql,array($gameId,$gameDetailCode));
		return $query -> result();
	}	
	
	function getGameCategoryList() 
	{
		$sql = ('SELECT * FROM dial_game_category_mstr dgm WHERE STATUS = \'A\'  order by DGM.SEQ_NO'); 
		$query = $this -> db -> query($sql);
		return $query -> result();
	}	
	
	function getGameListForCategory($gameCategoryId) 
	{
		$sql = ('SELECT dgm.*,duft.game_id,sum(duft.feedback_value)/count(*) rating FROM dial_game_mstr dgm 
		left JOIN dial_user_feedback_tbl duft ON dgm.game_id = duft.game_id
		where dgm.GAME_CAT_ID = ? and dgm.status= \'A\' group by duft.game_id ORDER BY DGM.SEQ_NO'); 
		$query = $this -> db -> query($sql, array($gameCategoryId));
		return $query -> result();
	}
	
	function getLastTenRatingForGame($gameId) 
	{
		$sql = ('select SUBSTR( FIRST_NAME, 1 , 2 )as FIrstTwoLetters, FIRST_NAME,FEEDBACK_VALUE,COMMENT,PROFILE_PIC_PATH from dial_user_feedback_tbl duft
left join '.STRATUP_SCHEMA.'.user_mstr um on duft.user_id = um.user_id where game_id = ? order by feedback_id desc limit 10');
		$query = $this -> db -> query($sql, array($gameId));
		return $query -> result();
	}	

	function getFeauredRatingForGame($gameId) 
	{
		$sql = ('select SUBSTR( FIRST_NAME, 1 , 2 )as FIrstTwoLetters,FIRST_NAME,FEEDBACK_VALUE,COMMENT,PROFILE_PIC_PATH from dial_user_feedback_tbl duft
left join '.STRATUP_SCHEMA.'.user_mstr um on duft.user_id = um.user_id where game_id = ? and FEATURED_FLAG = \'Y\' order by feedback_id desc limit 10');
		$query = $this -> db -> query($sql, array($gameId));
		return $query -> result();
	}	
	
	function getStarwiseRatingForGame($gameId) 
	{
		$sql = ('select feedback_value RATING,count(*) CNT,round(count(*)/(select count(*) from dial_user_feedback_tbl where game_id = ?)*100,2) PERCENT from dial_user_feedback_tbl where game_id = ? group by 1 order by RATING DESC');
		$query = $this -> db -> query($sql, array($gameId,$gameId));
		return $query -> result();
	}
	
	function getClientList() 
	{
		$sql = ('SELECT * FROM client_mstr order by SEQ_NO');
		$query = $this -> db -> query($sql);
		return $query -> result();
	}	

	function getTesimonialsList() 
	{
		$sql = ('SELECT 
                        tm.*, gm.GAME_TITLE
                    FROM
                        testimonial_mstr tm
                            INNER JOIN
                        dial_game_mstr gm ON gm.game_id = tm.game_id
                    WHERE
                        tm.STATUS = "A"
                    LIMIT 10');
		$query = $this -> db -> query($sql);
		return $query -> result();
	}	

	function gameTopFourList() 
	{
		$sql = ('SELECT * FROM dial_game_mstr order by rand() limit 4');
		$query = $this -> db -> query($sql);
		return $query -> result();
	}
    function gameOtherCatGameList() 
    {
        $sql = ('SELECT dgm.*,A.GAME_DETAIL_CODE,A.GAME_DETAIL_TITLE,A.GAME_DETAIL_DESC,
ROUND(ifnull(sum(duft.FEEDBACK_VALUE)/count(*),0),1) rating ,if(sum(duft.FEEDBACK_VALUE)>0,count(*) ,0) Total  FROM dial_game_mstr dgm 
        left Join (select * from dial_game_details_mstr 
        where GAME_DETAIL_CODE=\'RIBBON\')A on dgm.GAME_ID=A.GAME_ID 
         left JOIN dial_user_feedback_tbl duft ON dgm.game_id = duft.game_id
          where GAME_TAG="OTHERS"  group by dgm.game_id ORDER BY dgm.GAME_ID');
        $query = $this -> db -> query($sql);
        return $query -> result();
    }
    function stratupuser()
    {
        // $stratupdb = $this->load->database('stratup', TRUE);
        $sql = ('select * from '.STRATUP_SCHEMA.'.user_mstr');
        $query = $stratupdb->query($sql);
        return $query -> result_array();
    }
    /* stratup user details */
    function getUserDetailsForEmailId($emailId)
    {
        $stratupdb = $this->load->database('stratup', TRUE);
        $sql = ('SELECT * FROM '.STRATUP_SCHEMA.'.USER_MSTR where EMAIL_ID=?');
        $query = $stratupdb -> query($sql, array($emailId));
        return $query -> result_array();
    }
    /* stratup department ID */
    function getDepartmentIdForTeamIdDeptName($teamId, $deptName)
    {
        $stratupdb = $this->load->database('stratup', TRUE);
        $sql = ('SELECT DEPARTMENT_ID FROM DEPARTMENT_GAME_MSTR WHERE TEAM_ID= ? and DEPARTMENT_NAME=?');
        $query = $stratupdb-> query($sql, array($teamId, $deptName));
        return $query -> result_array();
    }
    /* stratup Team ID */
    function getTeamDtlsForGameId($gameId)
    {
        $stratupdb = $this->load->database('stratup', TRUE);
        $sql = ('SELECT * FROM TEAM_TBL WHERE GAME_ID=?');
        $query = $stratupdb-> query($sql, array($gameId));
        //echo $stratupdb->last_query();
        return $query -> result_array();
    }
    /* stratup insert team user role*/
    function insertTeamUserRoleMaptbl($teamId, $userId, $roleId)
    {
        $stratupdb = $this->load->database('stratup', TRUE);
        $sql = ('INSERT INTO TEAM_USER_ROLE_MAPPING_TBL
                        (
                            TEAM_ID,
                            USER_ID,
                            ROLE_ID
                        )
                        VALUES
                        (?,?,?)');
        $query = $stratupdb -> query($sql, array($teamId, $userId, $roleId));
    }
    function deleteUserFromTemUserRoleTbl($teamId, $userId)
    {
        $stratupdb = $this->load->database('stratup', TRUE);
        $sql = 'DELETE FROM team_user_role_mapping_tbl WHERE TEAM_ID = ? and USER_ID = ?';
        $query = $stratupdb -> query($sql, array($teamId, $userId));
    }
    function add_user_game_status($params)
    {
        $this->db->insert('dial_user_game_status',$params);
    }
    function listPlayedGamesByUserCount($emailId)
    {
        $sql = ('SELECT 
                   count(*) as Count
                FROM
                    dial_user_game_status ugs
                        INNER JOIN
                    '.STRATUP_SCHEMA.'.user_mstr um ON um.user_id = ugs.user_id
                                  WHERE
                    um.email_Id = ?');
        $query = $this -> db -> query($sql,array($emailId));
        
        return $query -> result_array();
    }
    function listPlayedGamesByUser($params = array(),$emailId)
    {
        $sql = 'SELECT 
                    gm.*, ugs.game_token
                FROM
                    dial_user_game_status ugs
                        INNER JOIN
                    '.STRATUP_SCHEMA.'.user_mstr um ON um.user_id = ugs.user_id
                        INNER JOIN
                    dial_game_seg_story_map_mstr gssm ON gssm.GS_MAP_ID = ugs.GS_MAP_ID
                        INNER JOIN
                    dial_game_mstr gm ON gm.game_id = gssm.game_id
                WHERE
                    um.email_Id = ?';
                    if (isset($params) && !empty($params))
        {
            //$this -> db -> limit($params['limit'], $params['offset']);
                $sql=$sql.' LIMIT '.$params['offset'].','.$params['limit'];
        }
        $query = $this -> db -> query($sql,array($emailId));
        return $query -> result_array();
    }
    function listRolesTakenForStratupGame($gameToken,$gameId,$teamMstrName)
    {
        $sql = 'SELECT tt.team_id,
                       gt.game_id,
                       tt.TEAM_NAME,
                       tt.TEAM_LOGO_NAME,
                       um.EMAIL_ID,
                       dgm.DEPARTMENT_NAME,
                       UNIVERSE_TOKEN
                FROM '.STRATUP_SCHEMA.'.team_user_role_mapping_tbl    turm
                     INNER JOIN '.STRATUP_SCHEMA.'.user_mstr um ON turm.USER_ID = um.USER_ID
                     INNER JOIN '.STRATUP_SCHEMA.'.team_tbl tt ON tt.TEAM_ID = turm.TEAM_ID
                     INNER JOIN '.STRATUP_SCHEMA.'.game_tbl gt ON gt.GAME_ID = tt.GAME_ID
                     INNER JOIN '.STRATUP_SCHEMA.'.game_batch_tbl gbt
                        ON gbt.GAME_BATCH_ID = gt.GAME_BATCH_ID
                     INNER JOIN '.STRATUP_SCHEMA.'.department_game_mstr dgm
                        ON dgm.DEPARTMENT_ID = turm.ROLE_ID
                WHERE UNIVERSE_TOKEN = ? and gt.game_id= ? AND tt.team_name = ?';
        $query = $this -> db -> query($sql,array($gameToken,$gameId,$teamMstrName));
        return $query -> result_array();
    }
    function getTeamUserRoleMapTbl_by_userTeam($teamId,$userId)
    {
        $stratupdb = $this->load->database('stratup', TRUE);
        $stratupdb->where('TEAM_ID', $teamId); 
        $stratupdb->where('USER_ID', $userId);
        $query=$stratupdb->get('TEAM_USER_ROLE_MAPPING_TBL');
        return $query -> result_array();
        
    }
    function getGameStartInfo($gameToken)
    {
        $sql ='SELECT gbt.START_DATE, gbt.END_DATE, gbt.NO_OF_YEAR_IN_GAME,UNIVERSE_TOKEN,cm.CLIENT_NAME
                    FROM '.STRATUP_SCHEMA.'.game_batch_tbl gbt
                    INNER JOIN '.STRATUP_SCHEMA.'.client_mstr cm ON cm.CLIENT_ID = gbt.CLIENT_ID
                    WHERE UNIVERSE_TOKEN = ?';
        $query = $this -> db -> query($sql,array($gameToken));
        return $query -> result_array();
        
    }
	
    function getProperty($propertykey)
    {
        $sql ='SELECT PROPERTY_VALUE FROM dial_property_mstr WHERE PROPERTY_KEY = ?';
        $query = $this -> db -> query($sql,array($propertykey));
        return $query -> result_array();
    }
    function getGameCatForCatId($gameCategoryId)
    {
        $this->db->where('GAME_CAT_ID', $gameCategoryId); 
        $query = $this->db->get('dial_game_category_mstr');
        return $query -> result_array();
    }
    function getGameIdForEmailId($universeToken,$emaiId)
    {
        $stratupdb = $this->load->database('stratup', TRUE);
        $sql = (' SELECT 
                    gt.game_id
                FROM
                    user_mstr um
                        INNER JOIN
                    team_user_role_mapping_tbl turm ON turm.USER_ID = um.USER_ID
                        INNER JOIN
                    team_tbl tt ON tt.TEAM_ID = turm.TEAM_ID
                        INNER JOIN
                    game_tbl gt ON gt.GAME_ID = tt.GAME_ID
                        INNER JOIN
                    game_batch_tbl gbt ON gbt.GAME_BATCH_ID = gt.GAME_BATCH_ID
                WHERE
                    gbt.UNIVERSE_TOKEN = ?
                        AND um.EMAIL_ID = ?');
        $query = $stratupdb-> query($sql,array($universeToken,$emaiId));
        return $query -> result_array();
    }
    function getOverAllRatingForGame($gameId) 
    {
        $sql = ('SELECT ROUND(ifnull(sum(FEEDBACK_VALUE)/count(*),0),1) AS TOTAL_FEEDBACK_VALUE, count(*) AS TOTAL_COUNT
        FROM dial_user_feedback_tbl where GAME_ID=?');
        $query = $this -> db -> query($sql, array($gameId));
        return $query -> result();
    }
}
?>