<?php
class TriviaPortal_model extends CI_Model {
	function __construct() {
		parent::__construct();
		$this->load->dbutil(); 
	    
		if(!empty($this->session->userdata('selected_db')))
		{
			$this-> db = $this->load->database($this->session->userdata('selected_db'), TRUE);
		}
	}
	
	function getTeamsforDepartment($departmentId,$teamSearchText)
	{
		$teamSearchText = $teamSearchText."%";
		$sql = ('SELECT mt.team_id,mt.team_name FROM mstr_teams mt INNER JOIN mstr_departments md
		ON mt.department_id = md.department_id where md.department_id = ?
		AND mt.status = "A" AND md.status = "A" AND mt.team_name like ?'); 				
		$query = $this -> db -> query($sql, array($departmentId,$teamSearchText));
		return $query -> result();
	}

	function getQuestionForPlayer($userId,$categoryId,$difficultyId)
	{
		$sql = ('SELECT mq.QN_ID,GAME_MECHANIC,QN_DESCRIPTION,QN_MEDIA_PATH,QN_MEDIA_TYPE FROM '.TIRIVA_SCHEMA.'.mstr_questions mq
		LEFT JOIN (select * from user_questions_faced where user_id = ?) uqf 
		on mq.qn_id = uqf.qn_id where QN_CATEGORY_ID = ? and QN_DIFFICULTY_ID = ? and STATUS = "A" AND uqf.qn_id is null
		ORDER BY RAND() LIMIT 1'); 				
		$query = $this -> db -> query($sql, array($userId,$categoryId,$difficultyId));
		return $query -> result();
	}
	
	function getOptionsForQuestionId($questionId)
	{
		$sql = ('SELECT OPT_ID,OPT_DESC,OPT_MEDIA_PATH,OPT_MEDIA_TYPE,OPT_SEQ_NO,OPT_ANSWER,OPT_ANS_MEDIA_PATH,
						OPT_ANSWER_MEDIA_TYPE,OPT_ANSWER_SEQ_NO FROM '.TIRIVA_SCHEMA.'.mstr_options WHERE qn_id = ?'); 				
		$query = $this -> db -> query($sql, array($questionId));
		return $query -> result();
	}

	function getScore($userId)
	{
		$sql = ('SELECT  us.USER_ID,IFNULL(us.LIVES,0) LIVES, IFNULL(us.GEMS,0) GEMS, IFNULL(us.COINS,0)COINS,
			IFNULL(us.LEVEL,0)LEVEL, IFNULL(us.STREAK,0)STREAK, IFNULL(us.BEST_STREAK,0)BEST_STREAK,
			IFNULL(us.POINTS,0)POINTS,ifnull(sum(ugd.CROWNS),0) CROWNS 
			FROM '.TIRIVA_SCHEMA.'.user_score us INNER JOIN '.TIRIVA_SCHEMA.'.user_game_data ugd on ugd.user_id = us.user_id  
			WHERE us.USER_ID = ?'); 			
		$query = $this -> db -> query($sql, array($userId));
		return $query -> result();
	}

	function getChatsForGame($ugs_id)
	{
		$sql = ('SELECT * FROM game_chat where ugs_id = ? order by CHAT_ID'); 				
		$query = $this -> db -> query($sql, array($ugs_id));
		return $query -> result();
	}
	
	function getUserGameListForDisplay($userId)
	{
		$sql = ('SELECT * FROM user_game_status ugs inner join user_game_data ugd 
		on ugs.ugs_id = ugd.ugs_id where user_id = ? and datediff(curdate(),ugs.start_date) < 6'); 				
		$query = $this -> db -> query($sql, array($userId));
		return $query -> result();
	}
	
	function insertNewChat($ugsId,$chatText,$userId) 
	{
		$sql = ('INSERT INTO game_chat(UGS_ID,CHAT_TEXT,SENT_BY_USER_ID) VALUES(?,?,?)');
		$query = $this -> db -> query($sql, array($ugsId,$chatText,$userId));
	}
	
	function insertUserGameStatus($params) 
	{
		//$sql = ('INSERT INTO user_game_status (GAME_MODE,STATUS) VALUES(?,?)');
		//$query = $this -> db -> query($sql, array($gameMode,$status));
      //  $insert_id = $this->db->insert_id();
	   // return $insert_id;
	   $this->db->insert(TIRIVA_SCHEMA.'.user_game_status', $params);
	   return $this->db->insert_id();
	}
	
	function insertUserGameData($ugsId,$player,$userId,$status) 
	{
		$sql = ('INSERT INTO '.TIRIVA_SCHEMA.'.user_game_data (UGS_ID,PLAYER,USER_ID,STATUS) VALUES(?,?,?,?)');
		$query = $this -> db -> query($sql, array($ugsId,$player,$userId,$status));
	}
	
	function getPlayeratSameLevel($userId)
	{
		$sql = ('select mu.user_id USER_ID from mstr_users mu
		left join (select user_id,level from user_score) us on mu.user_id = us.user_id
		inner join (select ugs_id, user_id from user_game_data where player= 2 and status not in ("P","N")) ougd on ougd.user_id = us.user_id
		inner join (select ugs_id from user_game_data where user_id = ?) sugd on sugd.ugs_id = ougd.ugs_id 
		order by RAND() limit 1');
		$query = $this -> db -> query($sql, array($userId));
		return $query -> result();		
	}
	
	/*function getCurrentLeague()
	{
		$sql = ('SELECT MAX(UGS_ID) CURR_LEAGUE_ID,START_TIME FROM trivia.user_game_status WHERE GAME_MODE = "LEAGUE" AND STATUS = "O"'); 				
		$query = $this -> db -> query($sql);
		return $query -> result();		
	}*/
	
	function updateScore($lives,$gems,$coins,$levels,$streak,$beststreak,$powerup1,$powerup2,$powerup3,$userId) 
	{
		$sql = ('UPDATE user_score SET LIVES = LIVES + ?,GEMS = GEMS + ?,COINS = COINS + ?,LEVEL = LEVEL + ?,STREAK = STREAK + ?,BEST_STREAK = BEST_STREAK + ?,POWERUP1 = POWERUP1 + ?,POWERUP2 = POWERUP2 + ?,POWERUP3 = POWERUP3 + ? WHERE USER_ID = ?');
		$query = $this -> db -> query($sql, array($lives,$gems,$coins,$levels,$streak,$beststreak,$powerup1,$powerup2,$powerup3,$userId));
	}

	function updateUgsData($characters,$crowns,$roundno,$status,$turnstarttime,$userId,$ugsId) 
	{
		$sql = ('UPDATE user_game_data SET CHARACTERS = ?,CROWNS = CROWNS + ?,ROUND_NO = ROUND_NO + ?,STATUS = ?,TURN_START_TIME = ? WHERE USER_ID = ? and UGS_ID = ?');
		$query = $this -> db -> query($sql, array($characters,$crowns,$roundno,$status,$turnstarttime,$userId,$ugsId));
	}

	function randomTenUsersExceptUserId($userId, $workspaceDesc)
	{
		//Created by : Ashwini
		$sql = ('SELECT mu.USER_ID,mu.LOGIN_ID,mu.FIRST_NAME as PROFILE_NAME,mu.PROFILE_PIC_PATH as PHOTO_PATH,
					IFNULL(mu.NICK_NAME,"") NICK_NAME,IFNULL(us.LEVEL,1) LEVEL FROM user_mstr mu 
					INNER JOIN user_workspace_mapping_mstr uwmm ON uwmm.USER_ID = mu.USER_ID
                    INNER JOIN workspace_mstr wm ON wm.WS_ID = uwmm.WS_ID 
					LEFT JOIN '.TIRIVA_SCHEMA.'.user_score us on us.USER_ID = mu.USER_ID 
					WHERE mu.user_id != ? AND WS_DESC = ? ORDER BY RAND() LIMIT 10'); 		
		//$db = $this->load->database($workspaceSchema, TRUE);	
		//$query = $db-> query($sql, array($userId, $workspaceDesc));
		$query = $this -> db -> query($sql, array($userId, $workspaceDesc));
		return $query -> result();
	}

	function searchPlayersForLoginKey($userId, $profileName, $workspaceName)
	{
		//Created by : Ashwini
		$profileName = $profileName."%";
		$sql = ('SELECT mu.USER_ID,mu.LOGIN_ID,mu.FIRST_NAME as PROFILE_NAME,mu.PROFILE_PIC_PATH as PHOTO_PATH,
					IFNULL(mu.NICK_NAME,"") NICK_NAME, IFNULL(us.LEVEL,1) LEVEL FROM user_mstr mu
					INNER JOIN user_workspace_mapping_mstr uwmm ON uwmm.USER_ID = mu.USER_ID
                    INNER JOIN workspace_mstr wm ON wm.WS_ID = uwmm.WS_ID 
					LEFT JOIN '.TIRIVA_SCHEMA.'.user_score us on us.USER_ID = mu.USER_ID 
					WHERE mu.user_id != ? AND WS_DESC = ? AND (FIRST_NAME like ? OR NICK_NAME like ?)'); 				
		$query = $this -> db -> query($sql, array($userId, $workspaceName, $profileName, $profileName));
		return $query -> result();
	}

	function updateRespondToGameRequest($userId, $ugsId, $status, $score) 
	{
		//Created by : Ashwini
		$sql = 'UPDATE '.TIRIVA_SCHEMA.'.user_game_data SET STATUS = ?';
		if(isset($score) && $score !== '')
		{
			$sql = $sql. ', SCORE = '.$score;
		}
		if($status == "W" || $status == "L")
		{
			$sql = $sql. ', TURN_START_TIME = utc_timestamp()';
		}
		$sql = $sql.' WHERE USER_ID = ? AND UGS_ID = ?';
		return $this -> db -> query($sql, array($status, $userId, $ugsId));
	}

	function getUserGameDataForUgsId($ugsId)
	{
		//Created by : Ashwini
		$sql = ('SELECT * FROM '.TIRIVA_SCHEMA.'.user_game_data WHERE UGS_ID = ?'); 				
		$query = $this -> db -> query($sql, array($ugsId));
		return $query -> result();
	}

	function getCategorywiseStreakandAttempt($userId)
	{
		//Created by : Ashwini
		$sql = ('SELECT USER_ID,CATEGORY1_ATTEMPT,CATEGORY2_STREAK,CATEGORY2_ATTEMPT,
						CATEGORY3_STREAK,CATEGORY3_ATTEMPT,CATEGORY4_STREAK,CATEGORY4_ATTEMPT 
					FROM user_score WHERE USER_ID = ?'); 				
		$query = $this -> db -> query($sql, array($userId));
		return $query -> result();
	}

	function getLeaderboard()
	{
		//Created by : Ashwini
		$sql = ('SELECT mu.USER_ID,FIRST_NAME as PROFILE_NAME,PROFILE_PIC_PATH as PHOTO_PATH,
			IFNULL(mu.NICK_NAME,"") NICK_NAME,POINTS FROM user_score us
					INNER JOIN user_mstr mu ON mu.USER_ID = us.USER_ID ORDER BY 3 DESC'); 				
		$query = $this -> db -> query($sql, array());
		return $query -> result();
	}

	function randomUsersExceptUserId($userId, $workspaceName, $oppUserIds)
	{
		//Created by : Ashwini
		$sql = ('SELECT mu.USER_ID,LOGIN_ID,FIRST_NAME as PROFILE_NAME,PROFILE_PIC_PATH as PHOTO_PATH,
					IFNULL(NICK_NAME,"") NICK_NAME FROM user_mstr mu
					INNER JOIN user_workspace_mapping_mstr uwmm ON uwmm.USER_ID = mu.USER_ID
        			INNER JOIN workspace_mstr wm ON wm.WS_ID = uwmm.WS_ID
					WHERE mu.user_id !=? AND WS_DESC = ? ');
		if(isset($oppUserIds) && $oppUserIds != '')
		{
			$sql = $sql. ' AND mu.USER_ID not in (' .$oppUserIds .')';
		}
		 $sql = $sql. ' ORDER BY RAND() LIMIT 1'; 				
		$query = $this -> db -> query($sql, array($userId, $workspaceName));
		return $query -> result();
	}

	function getNotificationForUser($userId)
	{
		//Created by : Ashwini
		$sql = ('SELECT gn.NOT_ID,NOT_DESC,IFNULL(MEDIA_URL,"") MEDIA_URL,NOT_TIME,NOT_STATUS,
						IFNULL(LGS_ID,0) LGS_ID,NOT_TYPE,USER_ID,STATUS 
					FROM '.TIRIVA_SCHEMA.'.game_notifications gn 
					INNER JOIN '.TIRIVA_SCHEMA.'.user_notification_status uns ON uns.NOT_ID = gn.NOT_ID WHERE USER_ID = ? 
					AND STATUS = "P" ORDER BY gn.NOT_ID DESC'); 				
		$query = $this -> db -> query($sql, array($userId));
		return $query -> result();
	}

	function getOnGoingGameForUser($userId)
	{
		//Created by : Ashwini
		$sql = ('SELECT * FROM '.TIRIVA_SCHEMA.'.user_game_data WHERE USER_ID = ? AND Status in ("P","N")'); 				
		$query = $this -> db -> query($sql, array($userId));
		return $query -> result();
	}

	function getLeagueLeaderboard()
	{
		//Created by : Ashwini
		$sql = ('SELECT mu.USER_ID,FIRST_NAME as PROFILE_NAME,IFNULL(mu.NICK_NAME,"") NICK_NAME,ifnull(sum(SCORE),0)SCORE
				 	FROM user_game_data ugd 
					INNER JOIN user_mstr mu ON mu.user_id=ugd.user_id 
					WHERE TURN_START_TIME >= (SELECT START_TIME FROM league_game_status ORDER BY LGS_ID DESC LIMIT 1) 
					AND TURN_START_TIME<= (SELECT END_TIME FROM league_game_status ORDER BY LGS_ID DESC LIMIT 1) 
					GROUP by USER_ID ORDER BY SCORE DESC'); 				
		$query = $this -> db -> query($sql, array());
		return $query -> result();
	}

	function getPointsForGameModeQuestionAndLevel($gameMode, $questionCategory, $level)
	{
		//Created by : Ashwini
		$sql = ('SELECT mp.POINTS_ID, mp.GAME_MODE, mqc.QN_CATEGORY, mp.QN_DIFFICULTY, mp.COINS, mp.GEMS
					FROM '.TIRIVA_SCHEMA.'.mstr_points mp 
					INNER JOIN '.TIRIVA_SCHEMA.'.mstr_questions_category mqc ON mp.QN_CATEGORY_ID = mqc.QN_CATEGORY_ID 
					WHERE GAME_MODE = ? AND QN_CATEGORY = ? AND QN_DIFFICULTY = ? AND mqc.STATUS = "A"'); 				
		$query = $this -> db -> query($sql, array($gameMode, $questionCategory, $level));
		return $query -> result();
	}

	function getPointsForGameModeAndLevel($gameMode, $level)
	{
		//Created by : Ashwini
		$sql = ('SELECT mp.POINTS_ID, mp.GAME_MODE, mqc.QN_CATEGORY, mp.QN_DIFFICULTY, mp.COINS, mp.GEMS
					FROM '.TIRIVA_SCHEMA.'.mstr_points mp 
					INNER JOIN '.TIRIVA_SCHEMA.'.mstr_questions_category mqc ON mp.QN_CATEGORY_ID = mqc.QN_CATEGORY_ID 
					WHERE GAME_MODE = ? AND QN_DIFFICULTY = ? AND mqc.STATUS = "A"'); 				
		$query = $this -> db -> query($sql, array($gameMode, $level));
		return $query -> result();
	}

	function getNotAnsweredQuestionByCategory($userId, $category, $level)
	{
		//Created by : Ashwini
		$sql = ('SELECT mq.QN_ID,mq.GAME_MECHANIC,mq.QN_SOURCE_ID,mqc.QN_CATEGORY,mq.QN_DIFFICULTY_ID,
						mq.QN_DESCRIPTION,mq.QN_MEDIA_PATH,mq.QN_MEDIA_TYPE,mq.CREATED_BY,mq.CREATED_ON,
						mq.MODIFIED_BY,mq.MODIFIED_ON,mq.STATUS
					FROM '.TIRIVA_SCHEMA.'.mstr_questions mq 
					INNER JOIN '.TIRIVA_SCHEMA.'.mstr_questions_category mqc ON mq.QN_CATEGORY_ID=mqc.QN_CATEGORY_ID
					WHERE QN_CATEGORY = ? AND QN_DIFFICULTY_ID = ? AND mq.QN_ID not in 
					(SELECT QN_ID FROM '.TIRIVA_SCHEMA.'.user_questions_faced WHERE user_id=? and RESET_QUESTION_FLAG = 1) 
					AND mqc.STATUS = "A" 
					AND mq.STATUS = "A" ORDER BY RAND() LIMIT 1'); 				
		$query = $this -> db -> query($sql, array($category, $level, $userId));
		return $query -> result();
	}

	function getUserQuestionFaced($userId, $questionId)
	{
		//Created by : Ashwini
		$sql = ('SELECT * FROM '.TIRIVA_SCHEMA.'.user_questions_faced	WHERE USER_ID = ? AND QN_ID = ?'); 				
		$query = $this -> db -> query($sql, array($userId, $questionId));
		return $query -> result();
	}

	function insertUserQuestionFaced($params)
	{
		//Created by : Ashwini
		return $this->db->insert(TIRIVA_SCHEMA.'.user_questions_faced', $params);
	}

	function updateScoreForUserId($userId)
	{
		//Created by : Ashwini
		$sql = ('UPDATE '.TIRIVA_SCHEMA.'.user_score SET POINTS = IFNULL(POINTS, 0) + 1 WHERE USER_ID = ?');
		return $this -> db -> query($sql, array($userId));
	}

	function updateScoreInGameData($ugsId, $userId)
	{
		//Created by : Ashwini
		$sql = ('UPDATE user_game_data SET SCORE = IFNULL(SCORE, 0) + 1 WHERE UGS_ID = ? AND USER_ID = ?');
		return $this -> db -> query($sql, array($ugsId, $userId));
	}

	function getQuestionById($questionId)
	{
		//Created by : Ashwini
		$sql = ('SELECT QN_ID,GAME_MECHANIC,QN_SOURCE_ID,QN_CATEGORY_ID,QN_DIFFICULTY_ID,QN_DESCRIPTION,
			QN_MEDIA_PATH,QN_MEDIA_TYPE,STATUS
		 from '.TIRIVA_SCHEMA.'.mstr_questions WHERE QN_ID = ? AND STATUS = "A"');
		$query = $this -> db -> query($sql, array($questionId));
		return $query -> result();
	}

	function updateCategoryStreak($userId, $categoryId)
	{
		//Created by : Ashwini
		$sql = 'UPDATE '.TIRIVA_SCHEMA.'.user_category_status SET STREAK = IFNULL(STREAK, 0) + 1 
					WHERE USER_ID = ? AND QN_CATEGORY_ID = ?';		
		return $this -> db -> query($sql, array($userId, $categoryId));
	}

	function updateBestStreak($userId)
	{
		//Created by : Ashwini
		$sql = ('UPDATE '.TIRIVA_SCHEMA.'.user_score SET BEST_STREAK = STREAK WHERE USER_ID = ?');		
		return $this -> db -> query($sql, array($userId));
	}

	function checkRequestAlreadySentToOpponent($userId,$oppUserId,$gameMode)
	{
		//Created by : Ashwini
		$sql = ('SELECT ugd.*,A.UGS_ID, A.My_USER_ID FROM '.TIRIVA_SCHEMA.'.user_game_data ugd
					INNER JOIN '.TIRIVA_SCHEMA.'.user_game_status ugs ON ugs.UGS_ID = ugd.UGS_ID
					INNER JOIN (SELECT UGS_ID,USER_ID AS My_USER_ID, PLAYER FROM '.TIRIVA_SCHEMA.'.user_game_data ) A 
					ON A.ugs_id = ugd.ugs_id WHERE ugd.USER_ID = ? AND ugd.Status in ("N","P","TR") 
					AND A.ugs_id = ugd.UGS_ID AND A.My_USER_ID = ? AND ugs.GAME_MODE = ?'); 				
		$query = $this -> db -> query($sql, array($oppUserId, $userId, $gameMode));
		return $query -> result();
	}

	function checkRequestAlreadySentToOpponentran($userId, $gameMode)
	{
		//Created by : Ashwini
		$sql = ('SELECT ugd.*,A.UGS_ID, A.My_USER_ID FROM '.TIRIVA_SCHEMA.'.user_game_data ugd
					INNER JOIN '.TIRIVA_SCHEMA.'.user_game_status ugs ON ugs.UGS_ID = ugd.UGS_ID
					INNER JOIN (SELECT UGS_ID,USER_ID AS My_USER_ID, PLAYER FROM '.TIRIVA_SCHEMA.'.user_game_data ) A 
					ON A.ugs_id = ugd.ugs_id WHERE ugd.USER_ID != ? AND ugd.Status in ("N","P","TR") 
					AND A.ugs_id = ugd.UGS_ID AND A.My_USER_ID = ? AND ugs.GAME_MODE = ?'); 				
		$query = $this -> db -> query($sql, array($userId, $userId, $gameMode));
		return $query -> result();
	}

	function getAllDepartments()
	{
		//Created By : Ashwini
		$sql = ('SELECT * FROM mstr_departments'); 				
		$query = $this -> db -> query($sql, array());
		return $query -> result();
	}

	function getAllTeams()
	{
		//Created By : Ashwini
		$sql = ('SELECT mt.*,md.DEPARTMENT_NAME FROM mstr_teams mt 
					INNER JOIN mstr_departments md ON md.DEPARTMENT_ID = mt.DEPARTMENT_ID');
		$query = $this -> db -> query($sql, array());
		return $query -> result();
	}

	function getAllQuestionCategory()
	{
		//Created By : Ashwini
		$sql = ('SELECT * FROM '.TIRIVA_SCHEMA.'.mstr_questions_category WHERE STATUS = "A"'); 				
		$query = $this -> db -> query($sql, array());
		return $query -> result();
	}

	function getAllQuestionsByCategory($categoryId)
	{
		//Created By : Ashwini
		$sql = ('SELECT * FROM '.TIRIVA_SCHEMA.'.mstr_questions  WHERE STATUS = "A" AND QN_CATEGORY_ID = ?'); 				
		$query = $this -> db -> query($sql, array($categoryId));
		return $query -> result();
	}

	function getAllPointsDetails($params=array())
	{
		//Created By : Ashwini
		$sql = ('SELECT mp.*,mqc.QN_CATEGORY FROM '.TIRIVA_SCHEMA.'.mstr_points mp 
					INNER JOIN '.TIRIVA_SCHEMA.'.mstr_questions_category mqc ON mqc.QN_CATEGORY_ID = mp.QN_CATEGORY_ID 
					WHERE mqc.STATUS = "A"'); 
		if (isset($params) && !empty($params))
        {
            $sql=$sql.' LIMIT '.$params['offset'].','.$params['limit'];
        }				
		$query = $this -> db -> query($sql, array());
		return $query -> result();
	}

	function getAllQuestions($params=array())
	{
		//Created By : Ashwini
		$sql = ('SELECT mq.QN_ID,
						mq.GAME_MECHANIC,
						mq.QN_CATEGORY_ID,
						mqc.QN_CATEGORY,
						mq.QN_DIFFICULTY_ID,
						mq.QN_DESCRIPTION,
						mq.QN_MEDIA_PATH,
						mq.QN_MEDIA_TYPE,
						mq.STATUS 
					FROM '.TIRIVA_SCHEMA.'.mstr_questions mq 
					INNER JOIN '.TIRIVA_SCHEMA.'.mstr_questions_category mqc ON mqc.QN_CATEGORY_ID = mq.QN_CATEGORY_ID 
					WHERE mqc.STATUS = "A" AND mq.STATUS = "A"'); 	
		if (isset($params) && !empty($params))
        {
            $sql=$sql.' LIMIT '.$params['offset'].','.$params['limit'];
        }			
		$query = $this -> db -> query($sql, array());
		return $query -> result();
	}

	function insertUserScore($params) 
	{
		//Created by : Ashwini
		$this->db->insert(TIRIVA_SCHEMA.'.user_score', $params);
		return $this->db->insert_id();
	}

	function insertUserCategoryStatus($params) 
	{
		//Created by : Ashwini
		$this->db->insert(TIRIVA_SCHEMA.'.user_category_status', $params);
		return $this->db->insert_id();
	}

	function insertdepartment($params) 
	{
		//Created by : Ashwini
		$this->db->insert('mstr_departments', $params);
		return $this->db->insert_id();
	}

	function updatedepartment($params, $deptId) 
	{
		//Created by : Ashwini
		$this->db->where('DEPARTMENT_ID',$deptId);
        return $this->db->update('mstr_departments',$params);
	}

	function insertTeamMstr($params) 
	{
		//Created by : Ashwini
		$this->db->insert('mstr_teams', $params);
		return $this->db->insert_id();
	}

	function updateTeamMstr($params, $teamId) 
	{
		//Created by : Ashwini
		$this->db->where('TEAM_ID',$teamId);
        return $this->db->update('mstr_teams',$params);
	}

	function insertPointsMstr($params,$workspaceSchema) 
	{
		//Created by : Ashwini
		$this->db->insert($workspaceSchema.'.mstr_points', $params);
		return $this->db->insert_id();
	}

	function updatePointsMstr($params, $pointsId,$workspaceSchema) 
	{
		//Created by : Ashwini
		$this->db->where('POINTS_ID',$pointsId);
        return $this->db->update($workspaceSchema.'.mstr_points',$params);
	}

	function insertQuestionCategoryMstr($params,$workspaceSchema) 
	{
		//Created by : Ashwini
		$this->db->insert($workspaceSchema.'.mstr_questions_category', $params);
		return $this->db->insert_id();
	}

	function updateQuestionCategoryMstr($params, $categoryId,$workspaceSchema) 
	{
		//Created by : Ashwini
		$this->db->where('QN_CATEGORY_ID',$categoryId);
        return $this->db->update($workspaceSchema.'.mstr_questions_category',$params);
	}

	function insertQuestionMstr($params,$workspaceSchema) 
	{
		//Created by : Ashwini
		$this->db->insert($workspaceSchema.'.mstr_questions', $params);
		return $this->db->insert_id();
	}

	function updateQuestionMstr($params, $questionId,$workspaceSchema) 
	{
		//Created by : Ashwini
		$this->db->where('QN_ID',$questionId);
        return $this->db->update($workspaceSchema.'.mstr_questions',$params);
	}

	function getGameMechanicsFromQuestionMstr() 
	{
		//Created by : Ashwini
		$sql = ('SELECT distinct(GAME_MECHANIC) FROM '.TIRIVA_SCHEMA.'.mstr_questions'); 				
		$query = $this -> db -> query($sql, array());
		return $query -> result();
	}

	function getQuestionsByGameMechanicFromWorkSpace($workspaceSchema,$gameMechanic, $questionCategoryId) 
	{
		//Created by : Ashwini
		$sql = ('SELECT mq.QN_ID,
						mq.GAME_MECHANIC,
						mqc.QN_CATEGORY,
						mq.QN_DIFFICULTY_ID,
						mq.QN_DESCRIPTION,
						mq.QN_MEDIA_PATH,
						mq.QN_MEDIA_TYPE,
						mq.STATUS 
					FROM '.$workspaceSchema.'.mstr_questions mq 
					INNER JOIN '.$workspaceSchema.'.mstr_questions_category mqc ON mqc.QN_CATEGORY_ID = mq.QN_CATEGORY_ID 
					WHERE mq.QN_CATEGORY_ID = ? '); 
		if(isset($gameMechanic) && $gameMechanic !== '')
		{
			$sql = $sql. ' AND GAME_MECHANIC = "'.$gameMechanic.'"';
		}

		$query = $this -> db -> query($sql, array($questionCategoryId));
		return $query -> result();
	}

	function getUserGameDataAndUserDataForUgsId($ugsId) 
	{
		//Created by : Ashwini
		$sql = ('SELECT ugd.*,
						mu.LOGIN_ID,
		 				mu.FIRST_NAME as PROFILE_NAME,
		 				IFNULL(mu.NICK_NAME,"") NICK_NAME,
		 				mu.PROFILE_PIC_PATH as PHOTO_PATH,
		 				ugs.GAME_MODE,
		 				ugs.START_TIME,
		 				IFNULL(us.LEVEL,1)LEVEL
		 			FROM '.TIRIVA_SCHEMA.'.user_game_data ugd 
		 			INNER JOIN user_mstr mu ON mu.USER_ID = ugd.USER_ID
		 			INNER JOIN '.TIRIVA_SCHEMA.'.user_game_status ugs on ugs.UGS_ID = ugd.UGS_ID
		 			LEFT JOIN '.TIRIVA_SCHEMA.'.user_score us on mu.USER_ID = us.USER_ID
		 			WHERE ugd.UGS_ID = ?'); 				
		$query = $this -> db -> query($sql, array($ugsId));
		return $query -> result();
	}

	function insertOptionsMstr($params, $workspaceSchema) 
	{
		//Created by : Ashwini
		$this->db->insert($workspaceSchema.'.mstr_options', $params);
		return $this->db->insert_id();
	}

	function updateOptionsMstr($params, $optionId, $workspaceSchema) 
	{
		//Created by : Ashwini
		$this->db->where('OPT_ID',$optionId);
        return $this->db->update($workspaceSchema.'.mstr_options',$params);
	}

	function getRewardForGameMode($gameMode)
	{
		//Created by : Ashwini
		$sql = ('SELECT GAME_MODE, 
						IFNULL(CONCAT("Rank ",RANK_FROM," to ",RANK_TO),0) AS RANK,
						IFNULL(COINS,0) AS COINS,
						IFNULL(GEMS,0) AS GEMS,
						IFNULL(MULTIPLIER,0) AS MULTIPLIER
				FROM '.TIRIVA_SCHEMA.'.mstr_game_reward WHERE GAME_MODE = ? ORDER BY RANK_FROM Asc'); 				
		$query = $this -> db -> query($sql, array($gameMode));
		return $query -> result();
	}

	function updateOptionsMstrForDescAndQuestionId($params, $optDesc, $questionId) 
	{
		//Created by : Ashwini
		$this->db->where('OPT_DESC',$optDesc);
		$this->db->where('QN_ID',$questionId);
        return $this->db->update('mstr_options',$params);
	}

	function getQuestionCategoryById($questionCategoryId)
	{
		//Created by : Ashwini
		$sql = ('SELECT * FROM '.TIRIVA_SCHEMA.'.mstr_questions_category WHERE QN_CATEGORY_ID = ?'); 				
		$query = $this -> db -> query($sql, array($questionCategoryId));
		return $query -> result();
	}
	function getQuestionCategoryByName($category)
	{
		//Created by : Ashwini
		$sql = ('SELECT * FROM '.TIRIVA_SCHEMA.'.mstr_questions_category WHERE QN_CATEGORY = ?'); 				
		$query = $this -> db -> query($sql, array($category));
		return $query -> result();
	}

	function updateCoinsInUserScore($coins, $gems, $userId) 
	{
		//Created by : Ashwini
		$sql = ('UPDATE '.TIRIVA_SCHEMA.'.user_score SET COINS = IFNULL(COINS,0) + ?, GEMS = IFNULL(GEMS,0) + ? WHERE USER_ID = ?');		
		return $this -> db -> query($sql, array($coins, $gems, $userId));
	}

	function updateStreakInUserScore($userId) 
	{
		//Created by : Ashwini
		$sql = ('UPDATE '.TIRIVA_SCHEMA.'.user_score SET STREAK = IFNULL(STREAK,0) + 1 WHERE USER_ID = ?');		
		return $this -> db -> query($sql, array($userId));
	}

	function resetStreakInUserScore($userId) 
	{
		//Created by : Ashwini
		$sql = ('UPDATE '.TIRIVA_SCHEMA.'.user_score SET STREAK = 0 WHERE USER_ID = ?');		
		return $this -> db -> query($sql, array($userId));
	}

	function updateQuestionCountInUserGameData($userId, $ugsId) 
	{
		//Created by : Ashwini
		$sql = ('UPDATE '.TIRIVA_SCHEMA.'.user_game_data SET QUESTION_COUNT = IFNULL(QUESTION_COUNT,0) + 1
				 WHERE USER_ID = ? AND UGS_ID = ?');		
		return $this -> db -> query($sql, array($userId, $ugsId));
	}

	function updateStreakAndCoinsInUserGameData($userId, $ugsId, $gameMode, $coins) 
	{
		//Created by : Ashwini
		$sql = ('UPDATE '.TIRIVA_SCHEMA.'.user_game_data SET '.$gameMode.'_STREAK = IFNULL('.$gameMode.'_STREAK,0) + 1,
					COINS = IFNULL(COINS, 0) + ? WHERE USER_ID = ? AND UGS_ID = ?');		
		return $this -> db -> query($sql, array($coins, $userId, $ugsId));
	}

	function resetStreakInUserGameData($userId, $ugsId, $gameMode)
	{
		//Created by : Ashwini
		$sql = ('UPDATE '.TIRIVA_SCHEMA.'.user_game_data SET '.$gameMode.'_STREAK = 0 WHERE USER_ID = ? AND UGS_ID = ?');		
		return $this -> db -> query($sql, array($userId, $ugsId));
	}

	function getUserGameDataForUgsIdAndUserId($userId, $ugsId)
	{
		//Created by : Ashwini
		$sql = ('SELECT * FROM '.TIRIVA_SCHEMA.'.user_game_data WHERE USER_ID=? AND UGS_ID = ?'); 				
		$query = $this -> db -> query($sql, array($userId, $ugsId));
		return $query -> result();
	}

	function getPropertyMstrDtls()
	{
		//Created by : Ashwini
		$sql = ('SELECT * FROM mstr_properties');
		$query = $this -> db -> query($sql, array());
		return $query -> result();
	}

	function getPropertyDtlsForPropertyName($propertyName)
	{
		//Created by : Ashwini
		$sql = ('SELECT * FROM '.TIRIVA_SCHEMA.'.mstr_properties WHERE PROPERTY_NAME = ?');
		$query = $this -> db -> query($sql, array($propertyName));
		return $query -> result();
	}

	function updateRoundAndResetQuestionCnt($userId, $ugsId)
	{
		//Created by : Ashwini
		$sql = ('UPDATE '.TIRIVA_SCHEMA.'.user_game_data SET QUESTION_COUNT = 0, ROUND_NO = IFNULL(ROUND_NO,0) + 1
				 WHERE USER_ID = ? AND UGS_ID = ?');
		return $this -> db -> query($sql, array($userId, $ugsId));
	}

	function resetCategoryStreak($userId, $categoryId)
	{
		//Created by : Ashwini
		$sql = 'UPDATE '.TIRIVA_SCHEMA.'.user_category_status SET STREAK = 0, ATTEMPT = IFNULL(ATTEMPT,0) + 1
					WHERE USER_ID = ? AND QN_CATEGORY_ID = ?';
		
		return $this -> db -> query($sql, array($userId, $categoryId));
	}

	function getCurrentLeagueStatusAndEndTime()
	{
		//Created By : Ashwini
		$sql = ('SELECT LGS_ID,START_TIME, END_TIME, STATUS, IF(END_TIME < utc_timestamp(),"COMPLETED", "ONGOING") AS LEAGUE_STATUS 
					FROM '.TIRIVA_SCHEMA.'.league_game_status WHERE STATUS = "A"');
		$query = $this -> db -> query($sql, array());
		return $query -> result(); 
	}

	function getLeaderboardForGameMode($gameMode, $workspaceDesc)
	{
		//Created by : Ashwini
		$sql = ('SELECT mu.USER_ID,FIRST_NAME as PROFILE_NAME,PROFILE_PIC_PATH as PHOTO_PATH,
						IFNULL(mu.NICK_NAME,"") NICK_NAME,IFNULL(POINTS,0)POINTS
				 	FROM '.TIRIVA_SCHEMA.'.user_game_data ugd 
					INNER JOIN user_mstr mu ON mu.user_id=ugd.user_id 
					INNER JOIN user_workspace_mapping_mstr uwmm ON uwmm.USER_ID = mu.USER_ID
                    INNER JOIN workspace_mstr wm ON wm.WS_ID = uwmm.WS_ID 
					INNER JOIN '.TIRIVA_SCHEMA.'.user_game_status ugs ON ugs.UGS_ID = ugd.UGS_ID 
					LEFT JOIN (SELECT count(QN_ID) POINTS,GAME_MODE,USER_ID,QN_ATTEMPTED_DATE FROM '.TIRIVA_SCHEMA.'.user_date_wise_question_attempt 
                    WHERE ATTEMPT_STATUS = "C" AND GAME_MODE = ?');
        if ($gameMode == 'LEAGUE') 
		{
			$sql = $sql.' AND QN_ATTEMPTED_DATE >= (SELECT START_TIME FROM '.TIRIVA_SCHEMA.'.league_game_status WHERE STATUS = "A") 
                    AND QN_ATTEMPTED_DATE <= (SELECT END_TIME FROM '.TIRIVA_SCHEMA.'.league_game_status WHERE STATUS = "A") ';
		}
		$sql = $sql.' GROUP BY USER_ID)A ON A.GAME_MODE = ugs.GAME_MODE AND ugd.USER_ID = A.USER_ID 
				WHERE ugs.GAME_MODE = ?';
		if ($gameMode == 'LEAGUE') 
		{
			$sql = $sql.' AND ugs.START_TIME >= (SELECT START_TIME FROM '.TIRIVA_SCHEMA.'.league_game_status WHERE STATUS = "A") 
					AND ugs.START_TIME<= (SELECT END_TIME FROM '.TIRIVA_SCHEMA.'.league_game_status WHERE STATUS = "A") ';
		}
		$sql = $sql.' AND WS_DESC = ? GROUP by USER_ID ORDER BY POINTS DESC'; 	
		//$db = $this->load->database($workspaceSchema, TRUE);			
		//$query = $db-> query($sql, array($gameMode,$gameMode, $workspaceDesc));
		$query = $this -> db -> query($sql, array($gameMode,$gameMode, $workspaceDesc));
		return $query -> result();
	}

	function resetAllCategoryStreak($userId)
	{
		//Created by : Ashwini
		$sql = 'UPDATE user_score SET CATEGORY1_STREAK = 0, CATEGORY1_ATTEMPT = IFNULL(CATEGORY1_ATTEMPT,0) + 1, CATEGORY2_STREAK = 0, 
						CATEGORY2_ATTEMPT = IFNULL(CATEGORY2_ATTEMPT,0) + 1, CATEGORY3_STREAK = 0, CATEGORY3_ATTEMPT = IFNULL(CATEGORY3_ATTEMPT,0) + 1, 
						CATEGORY4_STREAK = 0, CATEGORY4_ATTEMPT = IFNULL(CATEGORY4_ATTEMPT,0) + 1 WHERE USER_ID = ?';
		
		return $this -> db -> query($sql, array($userId));
	}

	function getPropertyMstrForTriviaTopics()
	{
		//Created By : Ashwini
		$sql = ('SELECT * FROM '.TIRIVA_SCHEMA.'.mstr_properties WHERE PROPERTY_NAME in( "TRIVIATOPICS ATTEMPTS" ,"TRIVIATOPICS STREAK","TRIVIATOPICS TIME TO RESET ATTEMPT") ');
		$query = $this -> db -> query($sql, array());
		return $query -> result(); 
	}

	function updateCrownInUserGameData($userId, $ugsId)
	{
		//Created by : Ashwini
		$sql = 'UPDATE '.TIRIVA_SCHEMA.'.user_game_data SET CROWNS = IFNULL(CROWNS,0) + 1 WHERE USER_ID = ? AND UGS_ID = ?';
		return $this -> db -> query($sql, array($userId, $ugsId));
	}

	function resetUserQuestionFacedForUserId($userId, $questionId)
	{
		//Created by : Ashwini
		$sql = ('UPDATE '.TIRIVA_SCHEMA.'.user_questions_faced SET RESET_QUESTION_FLAG = 0 WHERE USER_ID = ? AND QN_ID = ?');
		return $this -> db -> query($sql, array($userId, $questionId));
	}

	function updateUserQuestionFacedForUserId($userId, $questionId,$incorrect,$lastAttempt)
	{
		//Created by : Ashwini
		$sql = ('UPDATE '.TIRIVA_SCHEMA.'.user_questions_faced SET ATTEMPTS = ATTEMPTS + 1, INCORRECT_ATTEMPTS = ?,
		LAST_ATTEMPT = ?, RESET_QUESTION_FLAG = 1 WHERE USER_ID = ? AND QN_ID = ?');
		return $this -> db -> query($sql, array($incorrect, $lastAttempt, $userId, $questionId));
	}

	function getUserQuestionFacedByCategory($userId, $questionCategory, $level)
	{
		//Created by : Ashwini
		$sql = ('SELECT uqf.* FROM '.TIRIVA_SCHEMA.'.user_questions_faced uqf 
					INNER JOIN '.TIRIVA_SCHEMA.'.mstr_questions mq ON mq.QN_ID = uqf.QN_ID
					INNER JOIN '.TIRIVA_SCHEMA.'.mstr_questions_category mqc ON mq.QN_CATEGORY_ID=mqc.QN_CATEGORY_ID
					WHERE QN_CATEGORY = ? AND QN_DIFFICULTY_ID = ? AND USER_ID = ? AND mqc.STATUS = "A"
					AND mq.STATUS = "A"');
		$query = $this -> db -> query($sql, array($questionCategory, $level, $userId));
		return $query -> result();
	}

	function getRandomQuestionCategory()
	{
		//Created by : Ashwini
		$sql = ('SELECT mqc.* FROM '.TIRIVA_SCHEMA.'.mstr_questions_category mqc
					INNER JOIN '.TIRIVA_SCHEMA.'.mstr_questions mq ON mq.QN_CATEGORY_ID = mqc.QN_CATEGORY_ID 
					WHERE mq.STATUS = "A" AND mqc.STATUS = "A" ORDER BY RAND() LIMIT 1');
		$query = $this -> db -> query($sql, array());
		return $query -> result();
	}

	function updateStatusInUsergameStatus($ugsId, $status)
	{
		//Created by : Ashwini
		$sql = ('UPDATE '.TIRIVA_SCHEMA.'.user_game_status SET STATUS = ? WHERE UGS_ID = ?');
		return $this -> db -> query($sql, array($status, $ugsId));
	}

	function insertLeagueStatus($params)
	{
		//Created by : Ashwini
		$this->db->insert(TIRIVA_SCHEMA.'.league_game_status', $params);
		return $this->db->insert_id();
	}

	function updateLeagueStatus($leagueId, $status)
	{
		//Created by : Ashwini
		$sql = ('UPDATE '.TIRIVA_SCHEMA.'.league_game_status SET STATUS = ? WHERE LGS_ID = ?');
		return $this -> db -> query($sql, array($status, $leagueId));
	}

	function getLeaguePlayedIdsByUser($userId)
	{
		//Created by : Ashwini
		$sql = ('SELECT ugs.*,lgs.*
				 	FROM '.TIRIVA_SCHEMA.'.user_game_status ugs 
					INNER JOIN '.TIRIVA_SCHEMA.'.user_game_data ugd ON ugs.ugs_id=ugd.ugs_id
					inner join '.TIRIVA_SCHEMA.'.league_game_status lgs on ugs.START_TIME >= lgs.START_TIME 
					AND ugs.START_TIME <= lgs.END_TIME WHERE GAME_MODE = "LEAGUE"
					AND ugd.USER_ID = ? AND ugd.LEAGUE_REWARD_STATUS = "N" group by LGS_ID');
		$query = $this -> db -> query($sql, array($userId));
		return $query -> result();
	}

	function getLeaderBoardForLeagueById($lgsId)
	{
		//Created by : Ashwini
		$sql = ('SELECT mu.USER_ID,FIRST_NAME as PROFILE_NAME,PROFILE_PIC_PATH as PHOTO_PATH,
						IFNULL(mu.NICK_NAME,"") NICK_NAME,ifnull(sum(COINS),0)COINS
				 	FROM '.TIRIVA_SCHEMA.'.user_game_data ugd 
					INNER JOIN user_mstr mu ON mu.user_id=ugd.user_id 
					INNER JOIN '.TIRIVA_SCHEMA.'.user_game_status ugs ON ugs.UGS_ID = ugd.UGS_ID 
					WHERE ugs.GAME_MODE = "LEAGUE"  AND ugs.START_TIME >= (SELECT START_TIME FROM '.TIRIVA_SCHEMA.'.league_game_status where LGS_ID = ?) 
					AND ugs.START_TIME<= (SELECT END_TIME FROM '.TIRIVA_SCHEMA.'.league_game_status where LGS_ID = ?)  GROUP by USER_ID ORDER BY COINS DESC');
		$query = $this -> db -> query($sql, array($lgsId, $lgsId));
		return $query -> result();
	}

	function updateLeagueRewardCollectedStatus($userId, $ugsId)
	{
		//Created by : Ashwini
		$sql = ('UPDATE '.TIRIVA_SCHEMA.'.user_game_data SET LEAGUE_REWARD_STATUS = "C" WHERE USER_ID = ? AND UGS_ID = ?');
		return $this -> db -> query($sql, array($userId, $ugsId));
	}

	function getListOfUgsIdForLeagueIdAndUserID($userId, $lgsId)
	{
		//Created by : Ashwini
		$sql = ('SELECT ugs.*,lgs.*
				 	FROM '.TIRIVA_SCHEMA.'.user_game_status ugs 
					INNER JOIN '.TIRIVA_SCHEMA.'.user_game_data ugd ON ugs.ugs_id=ugd.ugs_id
					inner join '.TIRIVA_SCHEMA.'.league_game_status lgs on ugs.START_TIME >= lgs.START_TIME 
					AND ugs.START_TIME<= lgs.END_TIME WHERE GAME_MODE="LEAGUE"
					AND ugd.USER_ID = ? AND ugd.LEAGUE_REWARD_STATUS ="N" and LGS_ID = ?');
		$query = $this -> db -> query($sql, array($userId, $lgsId));
		return $query -> result();
	}

	function insertGameNotification($params)
	{
		//Created by : Ashwini
		$this->db->insert(TIRIVA_SCHEMA.'.game_notifications', $params);
		return $this->db->insert_id();
	}

	function insertUserNotification($params)
	{
		//Created by : Ashwini
		$this->db->insert(TIRIVA_SCHEMA.'.user_notification_status', $params);
		return $this->db->insert_id();
	}

	function updateNotificationStatus($userId, $notificationId)
	{
		//Created by : Ashwini
		$sql = ('UPDATE '.TIRIVA_SCHEMA.'.user_notification_status SET STATUS = "C" WHERE USER_ID = ? AND NOT_ID = ?');
		return $this -> db -> query($sql, array($userId, $notificationId));
	}

	function updateCategoryAttemptOverTime($userId, $categoryId)
	{
		//Created by : Ashwini
		$sql = 'UPDATE '.TIRIVA_SCHEMA.'.user_category_status SET ATTEMPT_OVER_TIME = utc_timestamp() 
					WHERE USER_ID = ? AND QN_CATEGORY_ID = ?';
		return $this -> db -> query($sql, array($userId, $categoryId));
	}
	function resetCategoryAttemptAndTime($userId, $categoryId)
	{
		//Created by : Ashwini
		$sql = 'UPDATE '.TIRIVA_SCHEMA.'.user_category_status SET STREAK = 0, ATTEMPT = 0, ATTEMPT_OVER_TIME = 0 
				WHERE USER_ID = ? AND QN_CATEGORY_ID = ?';
		return $this -> db -> query($sql, array($userId, $categoryId));
	}

	function firstTenUsersExceptUserId($userId, $workspaceName)
	{
		//Created by : Ashwini
		$sql = ('SELECT mu.USER_ID, mu.FIRST_NAME as PROFILE_NAME, mu.PROFILE_PIC_PATH as PHOTO_PATH,
						IFNULL(mu.NICK_NAME,"") NICK_NAME,IFNULL(us.LEVEL,1) LEVEL FROM user_mstr mu
						INNER JOIN user_workspace_mapping_mstr uwmm ON uwmm.USER_ID = mu.USER_ID
                    INNER JOIN workspace_mstr wm ON wm.WS_ID = uwmm.WS_ID 
					LEFT JOIN '.TIRIVA_SCHEMA.'.user_score us on us.USER_ID = mu.USER_ID 
					WHERE mu.user_id != ? AND WS_DESC = ? LIMIT 10'); 				
		$query = $this -> db -> query($sql, array($userId, $workspaceName));
		return $query -> result();
	}

	function getAllGameMechanicForQuestions()
	{
		//Created by : Ashwini
		$sql = ('SELECT GAME_MECHANIC_ID, GAME_MECHANIC_NAME, STATUS 
				FROM '.TIRIVA_SCHEMA.'.mstr_question_game_mechanic WHERE STATUS = "A"');		
		$query = $this -> db -> query($sql, array());
		return $query -> result();
	}

	function insertUserDateWiseQuestionAttempt($params)
	{
		//Created by : Ashwini
		return $this->db->insert(TIRIVA_SCHEMA.'.user_date_wise_question_attempt', $params);
	}

	function getCategorywisePerformanceofUser($userId)
	{
		//Created by : Ashwini
		$sql = ('SELECT mqc.QN_CATEGORY,
						IFNULL(ATTEMPTS,0) ATTEMPTS,
						IFNULL(INCORRECT_ATTEMPTS,0)INCORRECT_ATTEMPTS,
						IFNULL(CORRECT_ATTEMPT,0)CORRECT_ATTEMPT,
						IFNULL(PERCENTAGE,0)PERCENTAGE,
						mqc.QN_CATEGORY_MASCOT AS MEDIA_URL
					FROM '.TIRIVA_SCHEMA.'.mstr_questions_category mqc 
					LEFT JOIN
					(SELECT mu.USER_ID,
							sum(uqf.ATTEMPTS) ATTEMPTS,
							sum(uqf.INCORRECT_ATTEMPTS) INCORRECT_ATTEMPTS,
							(sum(uqf.ATTEMPTS)-sum(uqf.INCORRECT_ATTEMPTS)) CORRECT_ATTEMPT,
							round(((sum(uqf.ATTEMPTS)-sum(uqf.INCORRECT_ATTEMPTS))/sum(uqf.ATTEMPTS))*100,0) PERCENTAGE,
							QN_CATEGORY_ID
						FROM '.TIRIVA_SCHEMA.'.user_questions_faced uqf 
						INNER JOIN '.TIRIVA_SCHEMA.'.mstr_questions mq ON mq.QN_ID = uqf.QN_ID
 						INNER JOIN user_mstr mu ON mu.USER_ID = uqf.USER_ID
 						WHERE mu.user_id = ? GROUP BY mq.QN_CATEGORY_ID) A 
 					ON A.QN_CATEGORY_ID = mqc.QN_CATEGORY_ID WHERE mqc.STATUS = "A"');
		$query = $this -> db -> query($sql, array($userId));
		return $query -> result();
	}

	function getCardsForQuestionId($questionId)
	{
		//Created by : Ashwini
		$sql = ('SELECT mcd.CARD_ID,CARD_DETAIL_CODE,
						STRIP_TAGS(IFNULL(CARD_DETAIL_DESC,""))CARD_DETAIL_DESC,
						IFNULL(MEDIA_URL,"")MEDIA_URL 
					FROM '.TIRIVA_SCHEMA.'.mstr_cards_details mcd
					INNER JOIN '.TIRIVA_SCHEMA.'.cards_question_mapping_tbl cqmt ON cqmt.CARD_ID = mcd.CARD_ID 
					WHERE QN_ID in('.$questionId.')  AND STATUS = "A"');		
		$query = $this -> db -> query($sql, array());
		//echo $this -> db ->last_query();
		return $query -> result();
	}

	function checkScoreExistsForUser($userId)
	{
		//Created by : Ashwini
		$sql = ('SELECT  * from '.TIRIVA_SCHEMA.'.user_score WHERE USER_ID = ?'); 			
		$query = $this -> db -> query($sql, array($userId));
		return $query -> result();
	}

	function getUserRatingValues()
	{
		//Created by : Ashwini
		$sql = ('SELECT  USER_RATING_ID,USER_RATING_NAME,USER_RATING_DESC,USER_RATING_POINTS from '.TIRIVA_SCHEMA.'.user_rating_mstr'); 			
		$query = $this -> db -> query($sql, array());
		return $query -> result();
	}

	function insertUserFeedback($params)
	{
		//Created by : Ashwini
		return $this->db->insert(TIRIVA_SCHEMA.'.user_feedback_tbl', $params);
	}

	function getDateWiseCorrectAttempt($userId, $category, $monthYear)
	{
		//Created By : Ashwini
		$sql = ('SELECT count(ATTEMPT_STATUS) CORRECT_ATTEMPT_COUNT,
						DATE_FORMAT(QN_ATTEMPTED_DATE, "%d-%b-%y") QN_ATTEMPTED_DATE 
					FROM '.TIRIVA_SCHEMA.'.user_date_wise_question_attempt udwqa
					INNER JOIN '.TIRIVA_SCHEMA.'.mstr_questions mq ON mq.QN_ID = udwqa.QN_ID
					INNER JOIN '.TIRIVA_SCHEMA.'.mstr_questions_category mqc ON mqc.QN_CATEGORY_ID = mq.QN_CATEGORY_ID
					WHERE USER_ID = ? AND ATTEMPT_STATUS = "C" AND mqc.STATUS = "A" ');
		if($category != "All Category")
		{
			$sql = $sql.' AND QN_CATEGORY = "'.$category.'"';
		}
		$sql = $sql.' AND concat(MONTHNAME(udwqa.QN_ATTEMPTED_DATE)," ", YEAR(udwqa.QN_ATTEMPTED_DATE)) = ? 
		GROUP BY CAST(QN_ATTEMPTED_DATE AS DATE),MONTH(QN_ATTEMPTED_DATE), YEAR(QN_ATTEMPTED_DATE)';
		$query = $this -> db -> query($sql, array($userId, $monthYear));
		return $query -> result(); 
	}

	function getDateWiseTotalAttempt($userId, $category, $monthYear)
	{
		//Created By : Ashwini
		$sql = ('SELECT count(ATTEMPT_STATUS) TOTAL_ATTEMPT_COUNT,
						DATE_FORMAT(QN_ATTEMPTED_DATE, "%d-%b-%y") QN_ATTEMPTED_DATE 
					FROM '.TIRIVA_SCHEMA.'.user_date_wise_question_attempt udwqa
					INNER JOIN '.TIRIVA_SCHEMA.'.mstr_questions mq ON mq.QN_ID = udwqa.QN_ID
					INNER JOIN '.TIRIVA_SCHEMA.'.mstr_questions_category mqc ON mqc.QN_CATEGORY_ID = mq.QN_CATEGORY_ID
					WHERE USER_ID = ? AND mqc.STATUS = "A" ');
		if($category != "All Category")
		{
			$sql = $sql.' AND QN_CATEGORY = "'.$category.'"';
		}
		$sql = $sql.' AND concat(MONTHNAME(udwqa.QN_ATTEMPTED_DATE)," ", YEAR(udwqa.QN_ATTEMPTED_DATE)) = ? GROUP BY CAST(QN_ATTEMPTED_DATE AS DATE)';
		$query = $this -> db -> query($sql, array($userId, $monthYear));
		return $query -> result(); 
	}

	function getFeedbackMstr()
	{
		//Created by : Ashwini
		$sql = ('SELECT  FEEDBACK_ID,FEEDBACK_NAME,FEEDBACK_TYPE from '.TIRIVA_SCHEMA.'.user_feedback_mstr'); 			
		$query = $this -> db -> query($sql, array());
		return $query -> result();
	}

	function getCountOfCorrectAnswerForUser($userId)
	{
		//Created by : Ashwini
		$sql = ('SELECT mu.USER_ID,
							sum(uqf.ATTEMPTS) ATTEMPTS,
							sum(uqf.INCORRECT_ATTEMPTS) INCORRECT_ATTEMPTS,
							(sum(uqf.ATTEMPTS)-sum(uqf.INCORRECT_ATTEMPTS)) CORRECT_ATTEMPT,
							round(((sum(uqf.ATTEMPTS)-sum(uqf.INCORRECT_ATTEMPTS))/sum(uqf.ATTEMPTS))*100,0) PERCENTAGE
						FROM '.TIRIVA_SCHEMA.'.user_questions_faced uqf 
						INNER JOIN '.TIRIVA_SCHEMA.'.mstr_questions mq ON mq.QN_ID = uqf.QN_ID
 						INNER JOIN user_mstr mu ON mu.USER_ID = uqf.USER_ID
 						WHERE mu.user_id = ?');
		$query = $this -> db -> query($sql, array($userId));
		return $query -> result();
	}

	function getGamesPlayedByUser($userId)
	{
		//Created by : Ashwini
		$sql = ('SELECT USER_ID,SUM(CASE WHEN STATUS = "W" THEN 1 ELSE 0 END) AS WON_GAMES,
						SUM(CASE WHEN STATUS = "L" THEN 1 ELSE 0 END) AS LOST_GAMES,
						SUM(CASE WHEN STATUS != "W" THEN (CASE WHEN STATUS != "L" THEN 1 ELSE 0 END) ELSE 0 END) AS INPROGRESS_GAMES,
						COUNT(STATUS) AS TOTAL_GAMES
					FROM '.TIRIVA_SCHEMA.'.user_game_data WHERE USER_ID = ?');
		$query = $this -> db -> query($sql, array($userId));
		return $query -> result();
	}

	function getuserCategoryStatus($userId)
	{
		//Created by : Ashwini
		$sql = ('SELECT USER_ID,QN_CATEGORY_ID,IFNULL(STREAK,0)STREAK,IFNULL(ATTEMPT,0)ATTEMPT,
						IFNULL(ATTEMPT_OVER_TIME,0)ATTEMPT_OVER_TIME 
					FROM '.TIRIVA_SCHEMA.'.user_category_status WHERE USER_ID = ?');
		$query = $this -> db -> query($sql, array($userId));
		return $query -> result();
	}

	function getuserNotificationById($userId, $notificationId)
	{
		//Created by : Ashwini
		$sql = ('SELECT NOT_DESC,NOT_STATUS,gn.NOT_ID,LGS_ID,NOT_TYPE,USER_ID,STATUS 
					FROM '.TIRIVA_SCHEMA.'.game_notifications gn 
					INNER JOIN '.TIRIVA_SCHEMA.'.user_notification_status uns ON uns.NOT_ID = gn.NOT_ID
					WHERE USER_ID = ? AND uns.NOT_ID = ?');
		$query = $this -> db -> query($sql, array($userId, $notificationId));
		return $query -> result();
	}

	function getAllQuizWithQuizStatus($userId)
	{
		//Created By : Ashwini
		$sql = ('SELECT mq.QUIZ_ID,QUIZ_DESC,START_TIME,END_TIME,
						TIMESTAMPDIFF(SECOND,START_TIME,END_TIME)DURATION_IN_SECONDS,
						CASE WHEN QUIZ_STATUS = "C" THEN "COMPLETED" ELSE (CASE WHEN QUIZ_STATUS = "O" THEN "ONGOING" ELSE "NOT PARTICIPATED" END) END USER_QUIZ_STATUS
					FROM '.TIRIVA_SCHEMA.'.mstr_quizes mq
					LEFT JOIN (SELECT USER_ID,QUIZ_ID,QUIZ_STATUS
								FROM '.TIRIVA_SCHEMA.'.user_quiz_status WHERE USER_ID = ? )uqs ON uqs.QUIZ_ID = mq.QUIZ_ID
					WHERE mq.STATUS = "A" ORDER BY QUIZ_ID ASC'); 				
		$query = $this -> db -> query($sql, array($userId));
		return $query -> result();
	}

	function getQuestionIdsForQuizId($quizId)
	{
		//Created By : Ashwini
		$sql = ('SELECT QUIZ_ID,mqq.QN_ID,mqq.STATUS FROM '.TIRIVA_SCHEMA.'.mstr_quiz_questions mqq
					INNER JOIN '.TIRIVA_SCHEMA.'.mstr_questions mq ON mq.QN_ID = mqq.QN_ID
		 WHERE QUIZ_ID = ? AND mqq.STATUS = "A" AND mq.STATUS = "A"'); 				
		$query = $this -> db -> query($sql, array($quizId));
		return $query -> result();
	}

	function getquizQuestionStatusforUser($quizId, $userId)
	{
		//Created By : Ashwini
		$sql = ('SELECT QUIZ_ID,QN_ID,OPT_ID,ANS_STATUS,ANS_ON
					 FROM '.TIRIVA_SCHEMA.'.user_quiz_question_status WHERE QUIZ_ID = ? AND USER_ID = ?'); 				
		$query = $this -> db -> query($sql, array($quizId, $userId));
		return $query -> result();
	}

	function getAllActiveQuiz()
	{
		//Created By : Ashwini
		$sql = ('SELECT QUIZ_ID,QUIZ_DESC,START_TIME,END_TIME
					FROM '.TIRIVA_SCHEMA.'.mstr_quizes WHERE STATUS = "A"'); 				
		$query = $this -> db -> query($sql, array());
		return $query -> result();
	}

	function updateUserQuizStatus($userId, $quizId)
	{
		//Created by : Ashwini
		$sql = ('UPDATE '.TIRIVA_SCHEMA.'.user_quiz_status SET QUIZ_STATUS = "C" WHERE USER_ID = ? AND QUIZ_ID = ?');
		return $this -> db -> query($sql, array($userId, $quizId));
	}

	function getUserQuizQuesStatusForQuizAndQuestionId($userId, $quizId, $questionId)
	{
		//Created by :Ashwini
		$sql = ('SELECT USER_ID,QUIZ_ID,QN_ID,OPT_ID,ANS_STATUS,ANS_ON 
					FROM '.TIRIVA_SCHEMA.'.user_quiz_question_status WHERE USER_ID = ? AND QUIZ_ID = ? AND QN_ID = ?');
		$query = $this -> db -> query($sql, array($userId, $quizId, $questionId));
		//echo $this -> db ->last_query();
		return $query -> result();
	}

	function updateUserQuizQuestionStatus($userId, $quizId, $questionId, $optionParam)
	{
		//Created by : Ashwini
		$this->db->where('USER_ID',$userId);
        $this -> db ->where('QUIZ_ID', $quizId);
        $this -> db ->where('QN_ID', $questionId);
        return $this->db->update(TIRIVA_SCHEMA.'.user_quiz_question_status',$optionParam);
	}
	function deleteUserQuizQuestionStatus($userId, $quizId, $questionId)
	{
		//Created by : Ashwini
		$this->db->where('USER_ID',$userId);
        $this -> db ->where('QUIZ_ID', $quizId);
        $this -> db ->where('QN_ID', $questionId);
        return $this->db->delete(TIRIVA_SCHEMA.'.user_quiz_question_status');
	}

	function insertUserQuizQuestionStatus($params)
	{
		//Created by : Ashwini
		return $this->db->insert(TIRIVA_SCHEMA.'.user_quiz_question_status', $params);
	}

	function insertUserQuizStatus($params)
	{
		//Created by : Ashwini
		return $this->db->insert(TIRIVA_SCHEMA.'.user_quiz_status', $params);
	}

	function getUserQuizWiseAnswerCounts($userId,$quizId)
	{
		//Created By: Ashwini
		$sql = ('SELECT USER_ID, QUIZ_ID, COUNT(QN_ID) QUESTION_COUNT,
						SUM(CASE WHEN ANS_STATUS = "C" THEN 1 ELSE 0 END) CORRECT, 
						SUM(CASE WHEN ANS_STATUS = "W" THEN 1 ELSE 0 END) WRONG,
						SUM(CASE WHEN ANS_STATUS = " " THEN 1 ELSE 0 END) NOT_ATTEMPTED
					FROM '.TIRIVA_SCHEMA.'.user_quiz_question_status 
					WHERE USER_ID = ? AND QUIZ_ID = ? GROUP BY USER_ID');
		$query = $this -> db -> query($sql, array($userId, $quizId));
		return $query -> result();
	}

	function getQuizDetailsByQuizId($workspaceSchema, $quizId)
	{
		//Created by : Ashwini
		$sql = ('SELECT QUIZ_ID,QUIZ_DESC,START_TIME,END_TIME,STATUS FROM '.$workspaceSchema.'.mstr_quizes WHERE QUIZ_ID = ?');
		$query = $this -> db -> query($sql, array($quizId));
		return $query -> result();
	}

	function getUserQuizStatus($userId, $quizId)
	{
		//Created by : Ashwini
		$sql = ("SELECT USER_ID,QUIZ_ID,QUIZ_STATUS FROM ".TIRIVA_SCHEMA.".user_quiz_status WHERE USER_ID = ? AND QUIZ_ID = ?");
		$query = $this -> db -> query($sql, array($userId, $quizId));
		return $query -> result();
	}
	function getUserListFromUserQuizStatus($quizId)
	{
		//Created by : Ashwini
		$sql = ("SELECT USER_ID,QUIZ_ID,QUIZ_STATUS FROM ".TIRIVA_SCHEMA.".user_quiz_status WHERE QUIZ_ID = ?");
		$query = $this -> db -> query($sql, array($quizId));
		return $query -> result();
	}

	function getQuizWiseUserPerformance($quizId, $userId)
	{
		//Created By: Ashwini
		$sql = ('SELECT USER_ID, uqqs.QUIZ_ID,QUIZ_DESC, QN_ID,OPT_ID,ANS_STATUS
					FROM '.TIRIVA_SCHEMA.'.user_quiz_question_status uqqs 
					INNER JOIN '.TIRIVA_SCHEMA.'.mstr_quizes mq ON mq.QUIZ_ID = uqqs.QUIZ_ID
					WHERE uqqs.QUIZ_ID = ? AND USER_ID = ?');
		$query = $this -> db -> query($sql, array( $quizId, $userId));
		return $query -> result();
	}

	function getGradeMstrDtls()
	{
		//Created By: Ashwini
		$sql = ('SELECT GRADE, PERCENTAGE_FROM, PERCENTAGE_TO FROM '.TIRIVA_SCHEMA.'.mstr_grade');
		$query = $this -> db -> query($sql, array());
		return $query -> result();
	}
	function checkNotificationExists($userId, $lgsId)
	{
		//Created By: Ashwini
		$sql = ('SELECT gn.NOT_ID,NOT_DESC,IFNULL(MEDIA_URL,"") MEDIA_URL,NOT_TIME,NOT_STATUS,
		IFNULL(LGS_ID,0) LGS_ID,NOT_TYPE,USER_ID,STATUS 
	FROM '.TIRIVA_SCHEMA.'.game_notifications gn 
	INNER JOIN '.TIRIVA_SCHEMA.'.user_notification_status uns ON uns.NOT_ID = gn.NOT_ID WHERE USER_ID = ? 
	AND LGS_ID = ?');
		$query = $this -> db -> query($sql, array($userId, $lgsId));
		return $query -> result();
	}
	function getAllQuestionCategoryForSchema($workspaceSchema)
	{
		//Created By : Ashwini
		$sql = ('SELECT * FROM '.$workspaceSchema.'.mstr_questions_category'); 				
		$query = $this -> db -> query($sql, array());
		return $query -> result();
	}
	function getWorkspaceDetailsById($workspaceId)
	{
		//Created By : Ashwini
		$sql = ('SELECT * FROM workspace_mstr where WS_ID=?'); 				
		$query = $this -> db -> query($sql, array($workspaceId));
		return $query -> result();
	}
	function getQuestionCategoryByIdForSchema($workspaceSchema,$categoryId)
	{
		//Created By : Ashwini
		$sql = ('SELECT * FROM '.$workspaceSchema.'.mstr_questions_category where QN_CATEGORY_ID = ?'); 				
		$query = $this -> db -> query($sql, array($categoryId));
		return $query -> result();
	}
	function getGameMechanicsFromWorkSpace($workspaceSchema) 
	{
		//Created by : Ashwini
		$sql = ('SELECT * FROM '.$workspaceSchema.'.mstr_question_game_mechanic where status="A"'); 				
		$query = $this -> db -> query($sql, array());
		return $query -> result();
	}
	function getQuestionByIdFromWorkspace($workspaceSchema,$questionId)
	{
		//Created by : Ashwini
		$sql = ('SELECT QN_ID,GAME_MECHANIC,QN_SOURCE_ID,QN_CATEGORY_ID,QN_DIFFICULTY_ID,QN_DESCRIPTION,
			QN_MEDIA_PATH,QN_MEDIA_TYPE,STATUS
		 from '.$workspaceSchema.'.mstr_questions WHERE QN_ID = ?');
		$query = $this -> db -> query($sql, array($questionId));
		return $query -> result();
	}
	function getOptionsForQuestionIdFromWorkspace($workspaceSchema,$questionId)
	{
		$sql = ('SELECT OPT_ID,OPT_DESC,OPT_MEDIA_PATH,OPT_MEDIA_TYPE,OPT_SEQ_NO,OPT_ANSWER,OPT_ANS_MEDIA_PATH,
						OPT_ANSWER_MEDIA_TYPE,OPT_ANSWER_SEQ_NO FROM '.$workspaceSchema.'.mstr_options WHERE qn_id = ?'); 				
		$query = $this -> db -> query($sql, array($questionId));
		return $query -> result();
	}
	
	function getOptionsForOptionIdFromWorkspace($workspaceSchema,$optionId)
	{
		$sql = ('SELECT OPT_ID,OPT_DESC,OPT_MEDIA_PATH,OPT_MEDIA_TYPE,OPT_SEQ_NO,OPT_ANSWER,OPT_ANS_MEDIA_PATH,
						OPT_ANSWER_MEDIA_TYPE,OPT_ANSWER_SEQ_NO FROM '.$workspaceSchema.'.mstr_options WHERE OPT_ID = ?'); 				
		$query = $this -> db -> query($sql, array($optionId));
		return $query -> result();
	}

	function getAllPointsDetailsfromWorkspace($workspaceSchema)
	{
		//Created By : Ashwini
		$sql = ('SELECT mp.*,mqc.QN_CATEGORY FROM '.$workspaceSchema.'.mstr_points mp 
					INNER JOIN '.$workspaceSchema.'.mstr_questions_category mqc ON mqc.QN_CATEGORY_ID = mp.QN_CATEGORY_ID 
					where mqc.status="A"'); 
		$query = $this -> db -> query($sql, array());
		return $query -> result();
	}
	function getPointsDetailsByIdfromWorkspace($workspaceSchema,$pointsId)
	{
		//Created By : Ashwini
		$sql = ('SELECT mp.*,mqc.QN_CATEGORY FROM '.$workspaceSchema.'.mstr_points mp 
					INNER JOIN '.$workspaceSchema.'.mstr_questions_category mqc ON mqc.QN_CATEGORY_ID = mp.QN_CATEGORY_ID 
					where mqc.status="A" and mp.POINTS_ID = ?'); 
		$query = $this -> db -> query($sql, array($pointsId));
		return $query -> result();
	}
	function getAllQuizForWorkspace($workspaceSchema)
	{
		//Created By : Ashwini
		$sql = ('SELECT QUIZ_ID,QUIZ_DESC,START_TIME,END_TIME,STATUS
					FROM '.$workspaceSchema.'.mstr_quizes '); 				
		$query = $this -> db -> query($sql, array());
		return $query -> result();
	}
	function insertquestionToQuizForWorkspace($workspaceSchema, $params)
    {
        $this->db->insert($workspaceSchema.'.mstr_quiz_questions',$params);
        return $this->db->insert_id();
	}
	function updatequestionToQuizForWorkspace($workspaceSchema, $quizQnId, $status)
    {
		$sql = ('UPDATE '.$workspaceSchema.'.mstr_quiz_questions SET STATUS = ? WHERE QUIZ_QN_ID = ?');
        $query = $this -> db -> query($sql, array($status, $quizQnId));
       // return $query -> result();
	}
	function checkQuestionMappedToQuiz($workspaceSchema, $quizId, $questionId)
	{
		//Created By : Ashwini
		$sql = ('SELECT QUIZ_QN_ID,QUIZ_ID,QN_ID,STATUS
					FROM '.$workspaceSchema.'.mstr_quiz_questions where QUIZ_ID = ? and QN_ID = ?'); 				
		$query = $this -> db -> query($sql, array($quizId, $questionId));
		return $query -> result();
	}
	function getAllFlashCardsForWorkspace($workspaceSchema)
	{
		//Created By : Ashwini
		$sql = ('SELECT CARD_DETAILS_ID,CARD_ID,CARD_DETAIL_CODE,CARD_DETAIL_DESC,MEDIA_URL,STATUS
					FROM '.$workspaceSchema.'.mstr_cards_details where CARD_ID !=0 order by  CARD_ID Asc'); 				
		$query = $this -> db -> query($sql, array());
		return $query -> result();
	}
	function checkCardMappedToQuestion($workspaceSchema, $questionId)
	{
		//Created By : Ashwini
		$sql = ('SELECT CARDS_QN_MAPPING_ID,CARD_ID,QN_ID
					FROM '.$workspaceSchema.'.cards_question_mapping_tbl where QN_ID = ?'); 				
		$query = $this -> db -> query($sql, array($questionId));
		return $query -> result();
	}
	function insertcardToquesMapForWorkspace($workspaceSchema, $params)
    {
        $this->db->insert($workspaceSchema.'.cards_question_mapping_tbl',$params);
        return $this->db->insert_id();
	}
	function insertQuizMstrForWorkspace($workspaceSchema, $params)
    {
        $this->db->insert($workspaceSchema.'.mstr_quizes',$params);
        return $this->db->insert_id();
    }
    function updateQuizMstrForWorkspace($quizId, $params,$workspaceSchema)
	{
		//Created by : Ashwini
        $this -> db ->where('QUIZ_ID', $quizId);
        return $this->db->update($workspaceSchema.'.mstr_quizes',$params);
    }
    function getQuestionToQuiz($workspaceSchema, $quizId)
	{
		//Created By : Ashwini
		$sql = ('SELECT QUIZ_QN_ID,QUIZ_ID,mq.QN_ID,GAME_MECHANIC,QN_CATEGORY,QN_DESCRIPTION,QN_MEDIA_PATH,mq.STATUS 
                from '.$workspaceSchema.'.mstr_quiz_questions mqq 
                inner join '.$workspaceSchema.'.mstr_questions mq on mq.QN_ID = mqq.QN_ID
                inner join '.$workspaceSchema.'.mstr_questions_category mqc on mqc.QN_CATEGORY_ID = mq.QN_CATEGORY_ID
                where QUIZ_ID = ? AND mqq.STATUS = "A" AND mq.STATUS = "A" '); 				
		$query = $this -> db -> query($sql, array($quizId));
		return $query -> result();
	}
	function getInactiveQuestionToQuiz($workspaceSchema, $quizId)
	{
		//Created By : Ashwini
		$sql = ('SELECT mq.QN_ID,
					mq.GAME_MECHANIC,
					mq.QN_CATEGORY_ID,
					mqc.QN_CATEGORY,
					mq.QN_DIFFICULTY_ID,
					mq.QN_DESCRIPTION,
					mq.QN_MEDIA_PATH,
					mq.QN_MEDIA_TYPE,
					mq.STATUS
                from '.$workspaceSchema.'.mstr_questions mq 
					INNER JOIN '.$workspaceSchema.'.mstr_quiz_questions mqq  on mqq.QN_ID = mq.QN_ID
					INNER JOIN '.$workspaceSchema.'.mstr_questions_category mqc ON mqc.QN_CATEGORY_ID = mq.QN_CATEGORY_ID 
					WHERE mqc.STATUS = "A" AND mq.STATUS = "A" AND mqq.STATUS = "I" AND mqq.QUIZ_ID = ? '); 				
		$query = $this -> db -> query($sql, array($quizId));
		return $query -> result();
    }
    function getAllQuestionsForWorkspace($workspaceSchema)
	{
		//Created By : Ashwini
		$sql = ('SELECT mq.QN_ID,
						mq.GAME_MECHANIC,
						mq.QN_CATEGORY_ID,
						mqc.QN_CATEGORY,
						mq.QN_DIFFICULTY_ID,
						mq.QN_DESCRIPTION,
						mq.QN_MEDIA_PATH,
						mq.QN_MEDIA_TYPE,
						mq.STATUS 
					FROM '.$workspaceSchema.'.mstr_questions mq 
					INNER JOIN '.$workspaceSchema.'.mstr_questions_category mqc ON mqc.QN_CATEGORY_ID = mq.QN_CATEGORY_ID 
					WHERE mqc.STATUS = "A" AND mq.STATUS = "A"'); 			
		$query = $this -> db -> query($sql, array());
		return $query -> result();
	}
	function getAllQuestionsForWorkspaceNotMappedToQuizId($workspaceSchema,$quizId)
	{
		//Created By : Ashwini
		$sql = ('SELECT mq.QN_ID,
						mq.GAME_MECHANIC,
						mq.QN_CATEGORY_ID,
						mqc.QN_CATEGORY,
						mq.QN_DIFFICULTY_ID,
						mq.QN_DESCRIPTION,
						mq.QN_MEDIA_PATH,
						mq.QN_MEDIA_TYPE,
						mq.STATUS 
					FROM '.$workspaceSchema.'.mstr_questions mq 
					INNER JOIN '.$workspaceSchema.'.mstr_quiz_questions mqq  on mqq.QN_ID = mq.QN_ID
					INNER JOIN '.$workspaceSchema.'.mstr_questions_category mqc ON mqc.QN_CATEGORY_ID = mq.QN_CATEGORY_ID 
					WHERE mqc.STATUS = "A" AND mq.STATUS = "A" AND mqq.QUIZ_ID != ?'); 			
		$query = $this -> db -> query($sql, array($quizId));
		return $query -> result();
	}
	function insertFlashCardForWorkspace($workspaceSchema, $params)
    {
        $this->db->insert($workspaceSchema.'.mstr_cards_details',$params);
        return $this->db->insert_id();
	}
	function getFlashCardsByIdForWorkspace($workspaceSchema,$cardId)
	{
		//Created By : Ashwini
		$sql = ('SELECT CARD_DETAILS_ID,CARD_ID,CARD_DETAIL_CODE,CARD_DETAIL_DESC,MEDIA_URL,STATUS
					FROM '.$workspaceSchema.'.mstr_cards_details where CARD_ID = ?'); 				
		$query = $this -> db -> query($sql, array($cardId));
		return $query -> result();
	}
	function updateFlashCardForWorkspace($workspaceSchema, $params, $cardId, $cardCode) 
	{
		//Created by : Ashwini
		$this->db->where('CARD_ID',$cardId);
		$this->db->where('CARD_DETAIL_CODE',$cardCode);
        return $this->db->update($workspaceSchema.'.mstr_cards_details',$params);
	}
	function getFlashCardsByIdAndCodeForWorkspace($workspaceSchema,$cardId, $cardCode)
	{
		//Created By : Ashwini
		$sql = ('SELECT CARD_DETAILS_ID,CARD_ID,CARD_DETAIL_CODE,CARD_DETAIL_DESC,MEDIA_URL,STATUS
					FROM '.$workspaceSchema.'.mstr_cards_details where CARD_ID = ? AND CARD_DETAIL_CODE = ?'); 				
		$query = $this -> db -> query($sql, array($cardId, $cardCode));
		return $query -> result();
	}
	function getQuizmappedtoQuestion($workspaceSchema, $questionId)
	{
		//Created By : Ashwini
		$sql = ('SELECT mq.QUIZ_ID,QUIZ_DESC,START_TIME,END_TIME,mq.STATUS
                from '.$workspaceSchema.'.mstr_quiz_questions mqq 
                inner join '.$workspaceSchema.'.mstr_quizes mq on mq.QUIZ_ID = mqq.QUIZ_ID
                where QN_ID = ?'); 				
		$query = $this -> db -> query($sql, array($questionId));
		return $query -> result();
	}
	function getFlashCardmappedtoQuestion($workspaceSchema, $questionId)
	{
		//Created By : Ashwini
		$sql = ('SELECT mcd.CARD_ID,CARD_DETAIL_CODE,CARD_DETAIL_DESC,MEDIA_URL
                from '.$workspaceSchema.'.cards_question_mapping_tbl cqmt
                inner join '.$workspaceSchema.'.mstr_cards_details mcd on mcd.CARD_ID = cqmt.CARD_ID
                where QN_ID = ?'); 				
		$query = $this -> db -> query($sql, array($questionId));
		return $query -> result();
	}
}
?>
