<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class User_model extends CI_Model
{
	function __construct()
    {
        parent::__construct();
       
    }

    function verifyUser($loginId)
    {
      //  $login = '(EMAIL_ID="'.$loginId.'" or LOGIN_ID="'.$loginId.'")';
     //  $this -> db ->where($login);
       // $this -> db ->where('PASSWORD', ($password));
      //  $query = $this -> db ->get(USER_SCHEMA.'.user_mstr');
       // return $query->result();
         $sql = ('SELECT USER_ID,FIRST_NAME as PROFILE_NAME,IFNULL(PROFILE_PIC_PATH,"") as PROFILE_PIC_PATH,
                        IFNULL(NICK_NAME,"") NICK_NAME from user_mstr
                         where (LOGIN_ID = ? or EMAIL_ID = ? )');               
         $query = $this -> db -> query($sql, array($loginId,$loginId));
         return $query -> result();
    }
    function getWorkspaceForUserByUserId($userId)
    {
        //Created by : Ashwini
        $sql = ('SELECT wm.WS_ID, WS_NAME, WS_DESC, IFNULL(WS_SCHEMA,"")WS_SCHEMA, USER_ID,
                    IFNULL(VALID_FROM,"") VALID_FROM, IFNULL(VALID_TO,"") VALID_TO
                    FROM user_workspace_mapping_mstr uwmm 
                    INNER JOIN workspace_mstr wm on wm.WS_ID = uwmm.WS_ID WHERE USER_ID = ?');
        $query = $this -> db -> query($sql, array($userId));
        return $query -> result();
    }
    function getAllWorkspace()
    {
        //Created by : Ashwini
        $sql = ('SELECT WS_ID, WS_NAME, WS_DESC, STATUS, IFNULL(WS_SCHEMA,"")WS_SCHEMA
                    FROM workspace_mstr ');
        $query = $this -> db -> query($sql, array());
        return $query -> result();
    }
    function getWorkspaceByName($workspaceName)
    {
        //Created by : Ashwini
        $sql = ('SELECT WS_ID, WS_NAME, WS_DESC, STATUS, IFNULL(WS_SCHEMA,"")WS_SCHEMA
                    FROM workspace_mstr WHERE WS_NAME = ?');
        $query = $this -> db -> query($sql, array($workspaceName));
        return $query -> result();
    }
    function getUserByLoginId($loginId)
    {
        //Created by : Ashwini
        $sql = ('SELECT USER_ID,LOGIN_ID,PASSWORD,FIRST_NAME,MIDDLE_NAME,LAST_NAME,EMAIL_ID,
            IFNULL(NICK_NAME,"") NICK_NAME,IFNULL(PROFILE_PIC_PATH,"") PHOTO_PATH FROM user_mstr WHERE EMAIL_ID = ? OR LOGIN_ID = ?'); 
        $query = $this -> db -> query($sql, array($loginId, $loginId));
        return $query -> result();
    }
    function insertMstrUser($params) 
    {
        //Created by : Ashwini
        $this->db->insert('user_mstr', $params);
        return $this->db->insert_id();
    }
    function getWorkspaceForClientByClientName($clientName)
    {
        //Created by : Ashwini
        $sql = ('SELECT cwmm.WS_ID,WS_NAME,WS_DESC,IFNULL(WS_SCHEMA,"")WS_SCHEMA,CLIENT_NAME,
                        IFNULL(VALID_FROM,"")VALID_FROM,IFNULL(VALID_TO,"")VALID_TO 
                    FROM client_workspace_mapping_mstr cwmm 
                    inner join workspace_mstr wm on wm.WS_ID = cwmm.WS_ID
                    inner join client_mstr cm on cm.CLIENT_ID = cwmm.CLIENT_ID
                    where CLIENT_NAME = ? and STATUS = "A"');
        $query = $this -> db -> query($sql, array($clientName));
        return $query -> result();
    }
    function insertWorkspaceForUser($params)
    {
        //Created by : Ashwini
        return $this->db->insert('user_workspace_mapping_mstr', $params);
    }
    function getUserDtlsById($userId)
    {
        //Created by : Ashwini
        $sql = ('SELECT USER_ID,FIRST_NAME as PROFILE_NAME,IFNULL(PROFILE_PIC_PATH,"") as PHOTO_PATH,
                        IFNULL(NICK_NAME,"") NICK_NAME,EMAIL_ID,IFNULL(TEAM_NAME,"")TEAM_NAME, 
                        IFNULL(DEPARTMENT_NAME,"")DEPARTMENT_NAME,IFNULL(HOBBIES,"")HOBBIES 
                    FROM user_mstr um
                    LEFT JOIN mstr_departments md ON md.DEPARTMENT_ID=um.DEPARTMENT_ID
                    LEFT JOIN mstr_teams mt ON mt.TEAM_ID=um.TEAM_ID AND mt.DEPARTMENT_ID = md.DEPARTMENT_ID
                    WHERE USER_ID = ?');                
        $query = $this -> db -> query($sql, array($userId));
        return $query -> result();
    }
    function getCurrentTimeFromDatabase()
    {
        //Created by : Ashwini
        $sql = ('select utc_timestamp() as CurrentDate');               
        $query = $this -> db -> query($sql, array());
        return $query -> result();
    }

    function getWorkspaceByEmailIdAndWorkspace($emailId, $workspaceName)
    {
        //Created by : Ashwini
        $sql = ('SELECT wm.WS_ID, WS_NAME, WS_DESC, IFNULL(WS_SCHEMA,"")WS_SCHEMA, um.USER_ID,
                    IFNULL(VALID_FROM,"") VALID_FROM, IFNULL(VALID_TO,"") VALID_TO
                    FROM user_workspace_mapping_mstr uwmm 
                    INNER JOIN workspace_mstr wm on wm.WS_ID = uwmm.WS_ID
                    INNER JOIN user_mstr um on um.USER_ID = uwmm.USER_ID
                    WHERE EMAIL_ID = ? AND WS_DESC = ?');
        $query = $this -> db -> query($sql, array($emailId, $workspaceName));
        return $query -> result();
    }

    function getWorkspaceByDesc($workspaceName)
    {
        //Created by : Ashwini
        $sql = ('SELECT WS_ID, WS_NAME, WS_DESC, STATUS, IFNULL(WS_SCHEMA,"")WS_SCHEMA
                    FROM workspace_mstr WHERE WS_DESC = ?');
        $query = $this -> db -> query($sql, array($workspaceName));
        return $query -> result();
    }

    function getUserTypeByEmailId($emailId)
    {
        //Created by : Ashwini
        $sql = ('SELECT USER_ID, EMAIL_ID, um.USER_TYPE_ID, USER_TYPE_NAME
                    FROM user_mstr um 
                    INNER JOIN user_type_mstr utm ON utm.USER_TYPE_ID = um.USER_TYPE_ID 
                    WHERE EMAIL_ID = ?');
        $query = $this -> db -> query($sql, array($emailId));
        return $query -> result();
    }

    function getUserListForWorkspace($emailId,$workspaceName,$params=array())
    {
        //Created by : Ashwini
        $sql = ('SELECT um.USER_ID,FIRST_NAME,EMAIL_ID,WS_NAME,WS_DESC 
                    FROM user_workspace_mapping_mstr uwmm
                    INNER JOIN workspace_mstr wm ON wm.WS_ID = uwmm.WS_ID
                    INNER JOIN user_mstr um ON um.USER_ID = uwmm.USER_ID
                    WHERE WS_DESC = ?');
        if($emailId!="")
        {
            $emailId = $emailId."%";
            $sql=$sql.' AND EMAIL_ID like "'.$emailId.'"';
        }
        if (isset($params) && !empty($params))
        {
            $sql=$sql.' LIMIT '.$params['offset'].','.$params['limit'];
        }           
        $query = $this -> db -> query($sql, array($workspaceName));
        return $query -> result();
    }

    function getDepartments()
	{
        //Created by : Ashwini
		$sql = ('SELECT department_id, department_name from mstr_departments where status ="A"'); 				
		$query = $this -> db -> query($sql);
		return $query -> result();
    }
    
    function getDepartmentsbyName($departmentName)
	{
		//Created by : Ashwini
		$sql = ('SELECT DEPARTMENT_ID, DEPARTMENT_NAME FROM mstr_departments WHERE DEPARTMENT_NAME=?'); 				
		$query = $this -> db -> query($sql, array($departmentName));
		return $query -> result();
    }
    
    function getTeamsforDeptId($departmentId)
	{
		//Created by : Ashwini
		$sql = ('SELECT mt.team_id,mt.team_name FROM mstr_teams mt INNER JOIN mstr_departments md
		ON mt.department_id = md.department_id where md.department_id = ?'); 				
		$query = $this -> db -> query($sql, array($departmentId));
		return $query -> result();
    }
    
    function getTeamsbyNameandDept($teamName, $deptId)
	{
		//Created by : Ashwini
		$sql = ('SELECT TEAM_ID, TEAM_NAME FROM mstr_teams WHERE TEAM_NAME=? AND DEPARTMENT_ID=?'); 				
		$query = $this -> db -> query($sql, array($teamName, $deptId));
		return $query -> result();
    }
    
    function updateUserDtls($userId, $param)
	{
		//Created by : Ashwini
		//$sql = ('UPDATE mstr_users SET ? WHERE USER_ID = ?');		
		//return $this -> db -> query($sql, array($param, $userId));
		$this->db->where('USER_ID',$userId);
        return $this->db->update('user_mstr',$param);
    }
    function getUserById($userId)
	{
		//Created by : Ashwini
		$sql = ('SELECT USER_ID,LOGIN_ID,FIRST_NAME as PROFILE_NAME,PROFILE_PIC_PATH as PHOTO_PATH,
		IFNULL(NICK_NAME,"") NICK_NAME FROM user_mstr WHERE USER_ID = ?'); 				
		$query = $this -> db -> query($sql, array($userId));
		return $query -> result();
    }
    function getAllWorkspaceWithLockForUserId($userId)
	{
        //Created by : Ashwini
		$sql = ('SELECT wm.WS_ID, WS_NAME, WS_DESC, IFNULL(WS_SCHEMA,"") AS WS_SCHEMA, 
					case when A.WS_ID is NULL THEN \'YES\' ELSE \'NO\' END LOCK_STATUS
					FROM workspace_mstr wm
					left JOIN (select USER_WS_MAPPING_ID, WS_ID, VALID_FROM, VALID_TO from user_workspace_mapping_mstr uwmm  WHERE USER_ID = ?)A
					on wm.WS_ID = A.WS_ID where WS_SCHEMA is not null');
		$query = $this -> db -> query($sql, array($userId));
		return $query -> result();
    }
    function getWorkspaceForUserByEmailId($emailId)
	{
		//Created By : Ashwini
		$sql = ('SELECT wm.WS_ID,WS_NAME,WS_DESC,WS_SCHEMA,um.USER_ID from workspace_mstr wm
		inner join user_workspace_mapping_mstr uwmm on uwmm.WS_ID = wm.WS_ID
		inner join user_mstr um on um.USER_ID = uwmm.USER_ID
		where EMAIL_ID = ? and STATUS="A"'); 				
		$query = $this -> db -> query($sql, array($emailId));
		return $query -> result();
	}
}
?>