/**
 * @author ashwini
 */
var cardOpt = {
    legend: {
        position: 'bottom'
    },
    scales: {
        yAxes: [{
            gridLines : {
                display : false
            }
        }],
        xAxes : [ {
            gridLines : {
                display : false
            }
        } ]
    }
};
var bgColor = ['rgba(255, 99, 132, 0.2)',
				    'rgba(54, 162, 235, 0.2)',
				    'rgba(255, 206, 86, 0.2)',
				    'rgba(75, 192, 192, 0.2)',
				    'rgba(153, 102, 255, 0.2)',
				    'rgba(255, 159, 64, 0.2)'];
				    
var bdColor = ['rgba(255,99,132,1)',
                    'rgba(54, 162, 235, 1)',
                    'rgba(255, 206, 86, 1)',
                    'rgba(75, 192, 192, 1)',
                    'rgba(153, 102, 255, 1)',
                    'rgba(255, 159, 64, 1)'];
                    
function chartProd(obj){
	var objProdSoldProduce=obj.ProdSoldProduce;
	var Year = [];
    var ProdSoldProduce = [];
    var ProdSold =[];

    for (var i in objProdSoldProduce) {
        Year.push('Y'+objProdSoldProduce[i].Year+'Q'+objProdSoldProduce[i].Qtr);
        ProdSoldProduce.push((objProdSoldProduce[i].ProdAllocat));
    }
    for (var i in objProdSoldProduce) {
        ProdSold.push((objProdSoldProduce[i].ProdSold));
    }
     // Prepare Chart Start
     var config = {
        type: 'line',
        data: {
                datasets: [
                  {
                      label: 'Allocated',
                      data: ProdSoldProduce,
                      backgroundColor: 'rgba(255, 99, 132, 0.2)',
                      borderWidth: 1
                  },
                  {
                      label: 'Produced',
                      data: ProdSold,
                      backgroundColor: 'rgba(54, 162, 235, 0.2)',
                      borderWidth: 1
                  }
                ],
                labels:Year
            },
        options: {legend: {
        position: 'bottom'
    },
    scales: {
        yAxes: [{
            gridLines : {
                display : false
            },
            scaleLabel: {
            display: true,
            labelString: 'No. of Products'
          }
        }],
        xAxes : [ {
            gridLines : {
                display : false
            }
        } ]
    }
    }
    };
    var patChart = document.getElementById("prodChart").getContext('2d');
    patChart = new Chart(patChart, config);       
    // Prepare Chart End
}
function chartCogs(obj){
	var objRawMaterial=obj.RawMaterial;
	var objPackaging=obj.Packaging;
	var objWarehouse=obj.Warehouse;
	var objPlantMain=obj.PlantMain;
	var objOverhead=obj.Overhead;
	var objLabour=obj.Labour;
	var Year = [];
    var RawMaterial = [];
    var Packaging = [];
    var Warehouse = [];
    var PlantMain = [];
    var Overhead = [];
    var Labour = [];

    for (var i in objRawMaterial) {
        Year.push('Y'+objRawMaterial[i].YEAR);
        RawMaterial.push((objRawMaterial[i].VALUE/1000000).toFixed(2));
    }
    for (var i in objPackaging) {
    	
        Packaging.push((objPackaging[i].VALUE/1000000).toFixed(2));
    }
    for (var i in objWarehouse) {
        Warehouse.push((objWarehouse[i].VALUE/1000000).toFixed(2));
    }
    for (var i in objPlantMain) {
        PlantMain.push((objPlantMain[i].VALUE/1000000).toFixed(2));
    }
    for (var i in objOverhead) {
        Overhead.push((objOverhead[i].VALUE/1000000).toFixed(2));
    }
    for (var i in objLabour) {
        Labour.push((objLabour[i].VALUE/1000000).toFixed(2));
    }
     // Prepare Chart Start
     var config = {
        type: 'bar',
        data: {
                datasets: [
                
                  {
                      label: "Raw Material",
                      data: RawMaterial,
                      backgroundColor: 'rgba(255, 99, 132, 0.2)',
                      borderWidth: 1
                  },
                  {
                      label: 'Packaging',
                      data: Packaging,
                      backgroundColor: 'rgba(54, 162, 235, 0.2)',
                      borderWidth: 1
                  },
                  {
                      label: 'Warehouse',
                      data: Warehouse,
                      backgroundColor: 'rgba(150, 50, 200, 0.2)',
                      borderWidth: 1
                  },
                  {
                      label: 'Plant Maintaince',
                      data: PlantMain,
                      backgroundColor: 'rgba(255, 125, 25, 0.4)',
                      borderWidth: 1
                  },
                  {
                      label: 'Overhead',
                      data: Overhead,
                      backgroundColor: 'rgba(200, 300, 128, 0.5)',
                      borderWidth: 1
                  },
                  {
                      label: 'Labour',
                      data: Labour,
                      backgroundColor: 'rgba(255, 255, 128, 0.5)',
                      borderWidth: 1
                  }
                 
                ],
                
                labels:Year
            },
        options: cardOpt
    };
    var patChart = document.getElementById("cogsChart").getContext('2d');
    patChart = new Chart(patChart, config);       
    // Prepare Chart End
}
function chartUnitcost(obj){
	var objunitcostPrice=obj.unitcostPrice;
	var Year = [];
	var Price = [];
    var unitcostPrice = [];

    for (var i in objunitcostPrice) {
    	Year.push('Y'+objunitcostPrice[i].Year);
        unitcostPrice.push((objunitcostPrice[i].Unitcost));
    }
    for (var i in objunitcostPrice) {
        Price.push((objunitcostPrice[i].Price));
    }
     // Prepare Chart Start
     var config = {
        type: 'line',
        data: {
                datasets: [
                
                  {
                      label: 'Unit Cost',
                      data: unitcostPrice,
                      backgroundColor: 'rgba(255, 99, 132, 0.2)',
                      borderWidth: 1
                  },
                  {
                      label: 'Avg Price',
                      data: Price,
                      backgroundColor: 'rgba(54, 162, 235, 0.2)',
                      borderWidth: 1
                  }
                 
                ],
                
                labels:Year
            },
        options: cardOpt
    };
    var patChart = document.getElementById("unitChart").getContext('2d');
    patChart = new Chart(patChart, config);       
    // Prepare Chart End
}
function chartreject(obj){
	var objMachineCapacity=obj.MachineCapacity;
	var objOprAvail=obj.OprAvail;
	var objOprEffect=obj.OprEffect;
	var objMachinery=obj.Machinery;
	var objWarehouseQua=obj.WarehouseQua;
	var objSupplierQua=obj.SupplierQua;
	var objPackageEff=obj.PackageEff;
	var Year = [];
    var MachineCapacity = [];
    var OprAvail = [];
    var OprEffect = [];
    var Machinery = [];
    var WarehouseQua = [];
    var SupplierQua = [];
    var PackageEff = [];

    for (var i in objMachineCapacity) {
        Year.push('Y'+objMachineCapacity[i].YEAR);
        MachineCapacity.push((objMachineCapacity[i].VALUE));
    }
    for (var i in objOprAvail) {
    	
        OprAvail.push((objOprAvail[i].VALUE));
    }
    for (var i in objOprEffect) {
        OprEffect.push((objOprEffect[i].VALUE));
    }
    for (var i in objMachinery) {
        Machinery.push((objMachinery[i].VALUE));
    }
    for (var i in objWarehouseQua) {
        WarehouseQua.push((objWarehouseQua[i].VALUE));
    }
    for (var i in objSupplierQua) {
        SupplierQua.push((objSupplierQua[i].VALUE));
    }
    for (var i in objPackageEff) {
        PackageEff.push((objPackageEff[i].VALUE));
    }
     // Prepare Chart Start
     var config = {
        type: 'bar',
        data: {
                datasets: [
                
                  {
                      label: "Machine Capacity",
                      data: MachineCapacity,
                      backgroundColor: 'rgba(255, 99, 132, 0.2)',
                      borderWidth: 1
                  },
                  {
                      label: 'Operator Availability',
                      data: OprAvail,
                      backgroundColor: 'rgba(54, 162, 235, 0.2)',
                      borderWidth: 1
                  },
                  {
                      label: 'Operator Effectiveness',
                      data: OprEffect,
                      backgroundColor: 'rgba(150, 50, 200, 0.2)',
                      borderWidth: 1
                  },
                  {
                      label: 'Machinery',
                      data: Machinery,
                      backgroundColor: 'rgba(255, 125, 25, 0.4)',
                      borderWidth: 1
                  },
                  {
                      label: 'Warehouse Quality',
                      data: WarehouseQua,
                      backgroundColor: 'rgba(200, 300, 128, 0.5)',
                      borderWidth: 1
                  },
                  {
                      label: 'Supplier Quality',
                      data: SupplierQua,
                      backgroundColor: 'rgba(255, 255, 128, 0.5)',
                      borderWidth: 1
                  },
                  {
                      label: 'Packaging Effectiveness',
                      data: PackageEff,
                      backgroundColor: 'rgba(20, 125, 25, 0.4)',
                      borderWidth: 1
                  }
                 
                ],
                
                labels:Year
            },
        options: cardOpt
    };
    var patChart = document.getElementById("rejectChart").getContext('2d');
    patChart = new Chart(patChart, config);       
    // Prepare Chart End
}