<?php
class CourseDescription extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
		 $this->load->library('facebook');
        $this -> load -> helper(array(
            'form',
            'url',
            'html'
        ));
        $this -> load -> library(array(
            'session',
            'form_validation'
        ));
        $this -> load -> database();
    }
    public function gameDtls($gameId)
    {
        if(!empty($_GET["param"])) 
        {
            $param = $_GET["param"];
        }
        $data=$this->getgameDtls($gameId);
        $data['_view'] = 'prelogin/course_view';
        $this -> load -> view('layouts/main_view', $data);
    }
    public function getgameDtls($gameId)
    {
        $this -> load -> model('Gamemasters_model');
        $data['gameInfo'] = json_decode(json_encode($this -> Gamemasters_model -> getGameDetailsForGameId($gameId)), true);
        $data['gamePageTitleInfo'] = json_decode(json_encode($this -> Gamemasters_model -> getGameDetailsForGameIdDetailsCode($gameId, 'PAGE2TITLE')), true);
        $data['gameNoOfPlayerInfo'] = json_decode(json_encode($this -> Gamemasters_model -> getGameDetailsForGameIdDetailsCode($gameId, 'PLAYERS')), true);
        
        $data['gameDesc'] = json_decode(json_encode($this -> Gamemasters_model -> getGameDescriptionForGameId($gameId)), true);
        $gameDInfo = $this -> Gamemasters_model -> getGameDescriptionForGameId($gameId);

        $gameCategoryId = $gameDInfo[0] -> GAME_CAT_ID;
        $data['catGameList'] = json_decode(json_encode($this -> Gamemasters_model -> getGameListForCategory($gameCategoryId)), true);
        $data['featuredRating'] = json_decode(json_encode($this -> Gamemasters_model -> getFeauredRatingForGame($gameId)), true);
        
        $params['limit'] = RECORDS_PER_PAGE;
        $params['offset'] = ($this -> input -> get('per_page')) ? $this -> input -> get('per_page') : 0;

        $config = $this -> config -> item('pagination');
        $config['base_url'] = site_url('CourseDescription/gameDtls/'.$gameId.'?');
        
        //$count= $this->Gamemasters_model->getCountofAllRatingForGame($gameId);
        $count= $this->Gamemasters_model->getCountofAllRatingwithGameRating($gameId);
        $config['total_rows'] = $count[0]->Count ;
        $this->pagination->initialize($config);
        
        // $data['allRating'] = json_decode(json_encode($this -> Gamemasters_model -> getAllRatingForGame($params,$gameId)), true);
        $data['allRating'] = json_decode(json_encode($this -> Gamemasters_model -> getAllRatingwithGameRating($params, $gameId)), true);
        // $data['starwiseRating'] = json_decode(json_encode($this -> Gamemasters_model -> getStarwiseRatingForGame($gameId)), true);
        $data['starwiseRating'] = json_decode(json_encode($this -> Gamemasters_model -> getStarwiseRatingwithGameRating($gameId)), true);
    
        // $data['overallRating']= json_decode(json_encode($this -> Gamemasters_model -> getOverAllRatingForGame($gameId)),true);
        $data['overallRating']= json_decode(json_encode($this -> Gamemasters_model -> getOverAllRatingwithGameRating($gameId)),true);
        $data['gameCatDtls'] = $this -> Gamemasters_model -> getGameCatForCatId($gameCategoryId);
        $data['gameId'] = $gameId;
        // if($gameCategoryId==1)
        // {
            $UserPCdtls = $this->getuserPCinfo();
        $UserPCOS = explode(' ',$UserPCdtls['os']);
           if($UserPCOS[0]=='Mac')
        {
            $data['downloadStratup']=json_decode(json_encode($this -> Gamemasters_model -> getDownloadlink(0,$UserPCOS[0])), true);
        }
        else{
            $data['downloadStratup']=json_decode(json_encode($this -> Gamemasters_model -> getDownloadlink(0,'Windows')), true);
        }
            //$data['downloadStratup']=json_decode(json_encode($this -> Gamemasters_model -> getGameDetailsForGameId(0)), true);
        //}
        $this -> load -> model('Common_model');
        $data['introVideo']= $this -> Common_model ->get_gameEnvironment_video_list();
        $data['pbVideo']= $this -> Common_model ->get_pb_video_list();
        $data['dfVideo']= $this -> Common_model ->get_df_video_list();
		$data['authURL'] =  $this->facebook->login_url();
        $data['occupationmstr'] = json_decode(json_encode($this -> Gamemasters_model -> getOccupationMstr()),true);
        $data['organisationmstr'] = json_decode(json_encode($this -> Gamemasters_model -> getUserOrganisationMstr()),true);
        $data['locationmstr'] = json_decode(json_encode($this -> Gamemasters_model -> getUserLocationMstr()),true);
        foreach ($data['gameInfo'] as $gi)// loop created since maxplayers and simulation type required to display rows in assign role
        {
            switch ($gi['GAME_DETAIL_TITLE'])
            {
                case 'MAX_PLAYERS' :
                    $data['MAX_PLAYER'] = $gi['GAME_DETAIL_DESC'];
                    // No. of Players Required to Play stratup game
                    break;
                case 'SIMULATION_TYPE' :
                    $data['SIMULATION_TYPE'] = $gi['GAME_DETAIL_DESC'] ;
                    // GOLD / SILVER / BRONZE
                    break;
                case 'STRATUP_TYPE' :
                    $data['STRATUP_TYPE'] = $gi['GAME_DETAIL_DESC'];
                    // SYNC / ASYNC
                    break;
                case 'NOOFYEARS' :
                    $data['NOOFYEARS'] = $gi['GAME_DETAIL_DESC'];
                    // NO OF GAME PLAYS
                    break;
            }
        }
        return $data;
    }
    // function playGame($gameId,$isValidation)
    // {
        // if ($gameId==21)
        // {
            // redirect('game/Main');
        // }
        // if($gameId==9)
        // {
            // $this->playStraupGame($gameId,$isValidation);
        // }
    // }
    function playStraupGame($gameTypeId,$isValidation)
    {
        $data = array('success' => false, 'messages' => array());
        
        $goldRole[0]='IT'; 
        $goldRole[1]='HR';
        $goldRole[2]='MKT';
       // $goldRole[3]='STG';
        $goldRole[3]='FIN';
        $goldRole[4]='OPS';
        
        $silverRole[0]='HR';
        $silverRole[1]='MKT';
        $silverRole[2]='FIN';
        $silverRole[3]='OPS';
        $gamePlayPara = array();
        
        $this -> load -> model('Gamemasters_model');
        $gameInfos = $this -> Gamemasters_model -> getGameDetailsForGameIdDetailsCode($gameTypeId, 'VALUES');

        foreach ($gameInfos as $gi)// loop created since all required values
        // are under same column.
        {
            switch ($gi->GAME_DETAIL_TITLE)
            {
                case 'MAX_PLAYERS' :
                    $gamePlayPara['MAX_PLAYER'] = $gi -> GAME_DETAIL_DESC;
                    // No. of Players Required to Play stratup game
                    break;
                case 'SIMULATION_TYPE' :
                    $gamePlayPara['SIMULATION_TYPE'] = $gi -> GAME_DETAIL_DESC;
                    // GOLD / SILVER / BRONZE
                    break;
                case 'STRATUP_TYPE' :
                    $gamePlayPara['STRATUP_TYPE'] = $gi -> GAME_DETAIL_DESC;
                    // SYNC / ASYNC
                    break;
                case 'NOOFYEARS' :
                    $gamePlayPara['NOOFYEARS'] = $gi -> GAME_DETAIL_DESC;
                    // NO OF GAME PLAYS
                    break;
            }
        }
        if ( $gamePlayPara['SIMULATION_TYPE']=='GOLD')
        {
            $maxRole=5;
            $role = $goldRole;
            $roleName = 'IT:HR:MKT:STG:FIN:OPS';
        }
        else
        {
            $maxRole=4;
            $role = $silverRole;
            $roleName = 'HR:MKT:FIN:OPS';
        } 
                
        $this -> load -> library('form_validation');
        $this->form_validation->set_message('is_unique', 'The %s is already taken');
        $this -> form_validation -> set_rules('START_DATE', 'Start Date', 'required');
        $this -> form_validation -> set_rules('END_DATE', 'End Date', 'required');
        $this -> form_validation -> set_rules('TEAM_A_NAME', 'Team A Name', 'required');
        $this -> form_validation -> set_rules('TEAM_B_NAME', 'Team B Name', 'required');
        $this->form_validation->set_error_delimiters('<span class="text-danger">', '</span>');
        
        if($gamePlayPara['MAX_PLAYER']>2)
        {
           for ($i=0; $i < $maxRole ; $i++) 
           { 
               $this -> form_validation -> set_rules('TEAM_A_PLAYER_EMAIL'.$i, 'Email', 'trim|required|valid_email');
               $this -> form_validation -> set_rules('TEAM_B_PLAYER_EMAIL'.$i, 'Email', 'trim|required|valid_email');
           } 
        }
        else 
        {
            $this -> form_validation -> set_rules('TEAM_A_PLAYER_EMAIL', 'Email', 'trim|required|valid_email');
            $this -> form_validation -> set_rules('TEAM_B_PLAYER_EMAIL', 'Email', 'trim|required|valid_email');
        }
        
        $timezone = 330;//$this -> input -> post('OFFSET');
        // echo $timezone;
        if ($this -> form_validation -> run())
        {
            //Convert Client Machine Start DateTime to GMT DateTime
            $dbValueStart = $this -> input -> post('START_DATE');
            $timestampStart = strtotime($dbValueStart) + ($timezone * 60);
            $startDateConv = date("Y-m-d H:i:s", $timestampStart);

            //Convert Client Machine End DateTime to GMT DateTime
            $dbValueEnd = $this -> input -> post('END_DATE');
            $timestampEnd = strtotime($dbValueEnd) + ($timezone * 60);
            $endDateConv = date("Y-m-d H:i:s", $timestampEnd);

            $teamAName=$this -> input -> post('TEAM_A_NAME');
            $teamBName=$this -> input -> post('TEAM_B_NAME');
            
            $teamADtls=$this->Gamemasters_model ->getTeamsForTeamName($teamAName);
            if(count($teamADtls)>0)
            {
                $data['messages']['emailerr'] = '<span class="text-danger">Company Name Already Exists</span>';
                    // redirect('login');
                echo json_encode($data);
            }
            else
            {
                $teamBDtls=$this->Gamemasters_model ->getTeamsForTeamName($teamBName);
                if(count($teamBDtls)>0)
                {
                    $data['messages']['emailerr'] = '<span class="text-danger">Company Name Already Exists</span>';
                        // redirect('login');
                    echo json_encode($data);
                }
                else
                {
                    // params variable array is used to create universe token
                    $params = array(
                        'CLIENT_ID' => 7,
                        'PRODUCT_SUB_CATEGORY_ID' => '1',
                        'TRAINIER_ID' => '18',
                        'gameType' => 'actual',
                        'universeType' => 'CLOSED',
                        'universeMode' => 'DUO TEAM BOARD',
                        'NO_OF_YEAR_IN_GAME' => 1,
                        'START_DATE' => $startDateConv,
                        'END_DATE' => $endDateConv,
                        'maxPlayers' => $gamePlayPara['MAX_PLAYER'],
                        'stratupProductType' => $gamePlayPara['SIMULATION_TYPE'],                
                        'gameMode' => $this -> input -> post('hidden_mode'),
                        'courseName' => 'ONLINE'.date("h:i:sa"),
                        'isSingleTeamGame' => 0,
                        'isCampaign' => 0
                    );
                    $message = $this -> createGameAPI($params);
                    // echo $this -> rest -> debug();
                    $ob = json_decode(json_encode($message), true);
                    if ($ob=='try again') 
                    {
                        // $this -> session -> set_flashdata('error', 'Oops!! Some Thing Went Wrong. Please Try Again');
                        // redirect('CourseDescription/playStraupGame'.$gameTypeId, 'refresh');
                        $data['messages']['emailerr'] = '<span class="text-danger">Oops!! Some Thing Went Wrong. Please Try Again</span>';
                        echo json_encode($data);
                    }
                    else if ($message['message'] == 'Game Instance Created') 
                    {
                        $this -> session -> set_flashdata('response', $message['message']);
                        $this -> session -> set_flashdata('universe', "Universe Token=" . $message['universe']);
                        $teamId = $this->Gamemasters_model -> getTeamDtlsForGameId($message['gameId']);
                        $randomNumA = rand(1,20);
                        $imageA="PP".$randomNumA;
                        $randomNumB = rand(1,20);
                        $imageB="PP".$randomNumB;
                        $this->Gamemasters_model -> updateTeamNameForTeamId($teamId[0]['TEAM_ID'],$teamAName);
                        $this->Gamemasters_model -> updateTeamNameForTeamId($teamId[1]['TEAM_ID'],$teamBName);
                        $this->Gamemasters_model -> updateTeamLogoPathForTeamId($teamId[0]['TEAM_ID'],'resources/img/users/PlayerProfileIcons/'.$imageA.'.png');
                        $this->Gamemasters_model -> updateTeamLogoPathForTeamId($teamId[1]['TEAM_ID'],'resources/img/users/PlayerProfileIcons/'.$imageB.'.png');
                        //$stratupdb = $this->load->database('stratup', TRUE);
                
                        // delete if user as role already to aviod duplicate role assignment
                
                        /*** since we are creating new game ids delete role is not required hence commented
                        for ($i=0; $i < $maxRole ; $i++) 
                        {
                            $teamAPlayerEmail[$i]= $this -> input -> post('TEAM_A_PLAYER_EMAIL'.$i);
                            $teamBPlayerEmail[$i]= $this -> input -> post('TEAM_B_PLAYER_EMAIL'.$i);
                    
                            $userADtls = $this -> Gamemasters_model->getUserDetailsForEmailId($teamAPlayerEmail[$i]);
                            $userAId = $userADtls[0]['USER_ID'];
                            $userBDtls = $this -> Gamemasters_model->getUserDetailsForEmailId($teamAPlayerEmail[$i]);
                            $userBId = $userBDtls[0]['USER_ID'];
                            $this->Gamemasters_model ->deleteUserFromTemUserRoleTbl($teamId[0]['TEAM_ID'], $userAId);
                            $this->Gamemasters_model ->deleteUserFromTemUserRoleTbl($teamId[1]['TEAM_ID'], $userBId);
                        }
                        **/
                 
                        // insert user role mapping
                        $this->db-> trans_begin(); 
                        if($gamePlayPara['MAX_PLAYER']>2)
                        {
                            for ($i=0; $i < $maxRole ; $i++) 
                            {
                                $teamAPlayerEmail[$i]= $this -> input -> post('TEAM_A_PLAYER_EMAIL'.$i);
                                $teamBPlayerEmail[$i]= $this -> input -> post('TEAM_B_PLAYER_EMAIL'.$i);
                         
                                $teamAPlayerNew[$i]=$this->insertTeamUserRole($gameTypeId,$message['gameId'],$teamId[0]['TEAM_ID'],$teamAPlayerEmail[$i],$role[$i],$message['universe']);
                                $teamBPlayerNew[$i]=$this->insertTeamUserRole($gameTypeId,$message['gameId'],$teamId[1]['TEAM_ID'],$teamBPlayerEmail[$i],$role[$i],$message['universe']);
                            }
                        }
                        else
                        {
                            for ($i=0; $i < $maxRole ; $i++) 
                            {
                                $teamAPlayerEmail= $this -> input -> post('TEAM_A_PLAYER_EMAIL');
                                $teamBPlayerEmail= $this -> input -> post('TEAM_B_PLAYER_EMAIL');
                              
                                $teamAPlayerNew=$this->insertTeamUserRole($gameTypeId,$message['gameId'],$teamId[0]['TEAM_ID'],$teamAPlayerEmail,$role[$i],$message['universe']);
                                $teamBPlayerNew=$this->insertTeamUserRole($gameTypeId,$message['gameId'],$teamId[1]['TEAM_ID'],$teamBPlayerEmail,$role[$i],$message['universe']);
                            }
                        }
                 
                        $error = $this->db-> error();
                        if ( $this->db-> trans_status() === FALSE)
                        {
                            $this->db-> trans_rollback();
                            // $data=$this->getgameDtls($gameTypeId);
                            // $data['_view'] = 'prelogin/course_view';
                            // $this -> load -> view('layouts/main_view', $data);
                        
                            $data['success'] = false;
                            echo json_encode($data);
                        }
                        else
                        {
                            $this->db-> trans_commit();
                            // $data=$this->getgameDtls($gameTypeId);
                            // $data['_view'] = 'prelogin/course_view';
                            // $this -> load -> view('layouts/main_view', $data);
                            // sendmail($toemail,$companyName,$startdate,$enddate,$universetoken)
                            if($gamePlayPara['MAX_PLAYER']>2)
                            {
                                for ($i=0; $i < $maxRole ; $i++) 
                                {
                                    $teamAPlayerEmail[$i]= $this -> input -> post('TEAM_A_PLAYER_EMAIL'.$i);
                                    $userDtlsA = $this -> Gamemasters_model->getUserDetailsForEmailId($teamAPlayerEmail[$i]);
                                
                                    $params2 = array(
                                        'universe' => $message['universe'],
                                        'userid' => $userDtlsA[0]['USER_ID'],
                                        'roleName' => $role[$i]
                                    );
                                    $message2 = $this -> createGameForPortalAPI($params2);
                                    $ob2 = json_decode(json_encode($message2), true);
                                     
                                    $teamBPlayerEmail[$i]= $this -> input -> post('TEAM_B_PLAYER_EMAIL'.$i);
                                    $userDtlsB = $this -> Gamemasters_model->getUserDetailsForEmailId($teamBPlayerEmail[$i]);
                                 
                                    $params3 = array(
                                        'universe' => $message['universe'],
                                        'userid' => $userDtlsB[0]['USER_ID'],
                                        'roleName' => $role[$i]
                                    );
                                    $message3 = $this -> createGameForPortalAPI($params3);
                                    $ob3 = json_decode(json_encode($message3), true);
                                    //var_dump($teamAPlayerEmail[$i]);
                                    $this ->sendmail($teamAPlayerEmail[$i],$this -> input -> post('TEAM_A_NAME'),$params['START_DATE'],$params['END_DATE'],$message['universe'],$teamAPlayerNew[$i]);
                                    $this ->sendmail($teamBPlayerEmail[$i],$this -> input -> post('TEAM_B_NAME'),$params['START_DATE'],$params['END_DATE'],$message['universe'],$teamBPlayerNew[$i]);
                                }
                            }
                            else 
                            {
                                $teamAPlayerEmail= $this -> input -> post('TEAM_A_PLAYER_EMAIL');
                                $userDtlsA = $this -> Gamemasters_model->getUserDetailsForEmailId($teamAPlayerEmail);
                                
                                $params2 = array(
                                    'universe' => $message['universe'],
                                    'userid' => $userDtlsA[0]['USER_ID'],
                                    'roleName' => $roleName
                                );
                                $message2 = $this -> createGameForPortalAPI($params2);
                                $ob2 = json_decode(json_encode($message2), true);
                                
                                $teamBPlayerEmail= $this -> input -> post('TEAM_B_PLAYER_EMAIL');
                                $userDtlsB = $this -> Gamemasters_model->getUserDetailsForEmailId($teamBPlayerEmail);
                                
                                $params3 = array(
                                            'universe' => $message['universe'],
                                            'userid' =>  $userDtlsB[0]['USER_ID'],
                                            'roleName' => $roleName
                                        );
                                $message3 = $this -> createGameForPortalAPI($params3);
                                $ob3 = json_decode(json_encode($message3), true);
                                
                                $this ->sendmail($teamAPlayerEmail,$this -> input -> post('TEAM_A_NAME'),$params['START_DATE'],$params['END_DATE'],$message['universe'],$teamAPlayerNew);
                                $this ->sendmail($teamBPlayerEmail,$this -> input -> post('TEAM_B_NAME'),$params['START_DATE'],$params['END_DATE'],$message['universe'],$teamBPlayerNew);
                            }
                            $data['universe']='<br/>Universe Token='. $message['universe'];
                   
                            $data['success'] = true;
                            echo json_encode($data);
                        }
                    }
                }
            }  
        }
        else
        {
			if ($isValidation == 'VALIDATION')
			{
				foreach ($_POST as $key => $value) 
				{
				    if(substr($key,14,5)=='EMAIL')
                    {
                        $data['messages']['emailerr'] = '<span class="text-danger">Please Enter a Valid Email.</span>';
                        $data['messages'][$key] = '<span class="text-danger"></span>';
                    }
                    else 
                    {
                    	$data['messages'][$key] = form_error($key);
                    }
				}				
				echo json_encode($data);				
			}
        }
    }

    function playStratupSolo()
    {
            $silverRole[0]='HR';
            $silverRole[1]='MKT';
            $silverRole[2]='FIN';
            $silverRole[3]='OPS';
            $startDateConv = date("Y-m-d H:i:s");
            $endDateConv = date("Y-m-d H:i:s",strtotime("tomorrow"));
            $teamname=$_POST['teamName'];
            
            if($teamname!='')
            {
                // params variable array is used to create universe token
                $params = array(
                    'CLIENT_ID' => 7,
                    'PRODUCT_SUB_CATEGORY_ID' => '1',
                    'TRAINIER_ID' => '18',
                    'gameType' => 'actual',
                    'universeType' => 'CLOSED',
                    'universeMode' => 'DUO TEAM BOARD',
                    'NO_OF_YEAR_IN_GAME' => 1,
                    'START_DATE' => $startDateConv,
                    'END_DATE' => $endDateConv,
                    'maxPlayers' => 1,
                    'stratupProductType' => 'SILVER',      
                    'gameMode' => 'SYNC',
                    'courseName' => 'SOLO : '.date("h:i:sa"),
                    'isSingleTeamGame' => 1
                );
            
                $message = $this -> createGameAPI($params);
                $ob = json_decode(json_encode($message), true);
                $emailId = $this->session->userdata('emailid');
                if ($message['message'] == 'Game Instance Created') 
                {
                    $params2 = array(
                        'universe' => $message['universe'],
                        'userid' => $this->session->userdata('uid'),
                        'roleName' => 'HR:MKT:FIN:OPS'
                    );
                
                    $message2 = $this -> createGameForPortalAPI($params2);
                    $ob2 = json_decode(json_encode($message2), true);

                    $this -> session -> set_flashdata('response', $message['message']);
                    $this -> session -> set_flashdata('universe', "Universe Token=" . $message['universe']);
                    $this -> sendmailtoSolo($emailId,$teamname,$startDateConv,$endDateConv,$message['universe']);
                    
                    $this -> load -> model('Gamemasters_model');                
                    $teamId = $this->Gamemasters_model -> getTeamDtlsForGameId($message['gameId']); 
                    $randomNum = rand(1,20);
                    $image="PP".$randomNum;
                    $this->Gamemasters_model -> updateTeamNameForTeamId($teamId[0]['TEAM_ID'],$teamname);    
                    $this->Gamemasters_model -> updateTeamLogoPathForTeamId($teamId[0]['TEAM_ID'],'resources/img/users/PlayerProfileIcons/'.$image.'.png');            
                    for ($i=0; $i < 4 ; $i++) 
                    {
                        $this->insertTeamUserRole(15,$message['gameId'],$teamId[0]['TEAM_ID'],$emailId,$silverRole[$i],$message['universe']);
                    }          
                    $data['universe']='<span class="text-success">'.$message['message'].'<br/>Universe Token='. $message['universe'].'</span>';
                    echo json_encode($data);      
                }
                else 
                {
                    $data['universe']='';
                    // $this -> session -> set_flashdata('error', 'Oops!! Some Thing Went Wrong. Please Try Again');
                    // redirect('CourseDescription/playStraupGame'.$gameTypeId, 'refresh');
                    $data['errormessage'] = '<span class="text-danger">Oops!! Some Thing Went Wrong. Please Try Again</span>';
                    echo json_encode($data);
                }
            }
            else
            {
                $data['universe']='';
                $data['errormessage'] = '<span class="text-danger">Please Enter your company Name</span>';
                echo json_encode($data);
            }    
    }

    function createGameAPI($params)
    {
        $m = array();
        $this -> load -> library('rest', array(
            'server' => straupAPIBaseURL . 'GameInitControl',
            'http_user' => APIuser,
            'http_pass' => APIpwd,
            'http_auth' => APIauth // or 'digest'
        ));

        //echo($this -> rest -> get('insertGameBatchTbl', $params));
        $newGame = $this -> rest -> get('insertGameBatchTbl', $params, 'json');

        //$lb = json_decode(json_encode($newGame), true);
        if (!isset($newGame))
        {
            echo $this -> rest -> debug();
        }
        else
        {
            //$m = $newGame[sizeof($newGame) - 1] -> MESSAGE;
            if ($this -> rest -> status() == 200)
            {
                $result = array();
                $result['universe'] = ($newGame[sizeof($newGame) - 2] -> UNIVERSE_TOKEN);
                $result['message'] = ($newGame[sizeof($newGame) - 1] -> MESSAGE);
                $result['gameId'] = ($newGame[sizeof($newGame) - 2] -> GAME_ID);
                return $result;
            }
            else
            {
                return ('try again');
            }
        }
    }

    function createGameForPortalAPI($params)
    {
        $m = array();
        $this -> load -> library('rest', array(
            'server' => straupAPIBaseURL . 'GameInitControl',
            'http_user' => APIuser,
            'http_pass' => APIpwd,
            'http_auth' => APIauth // or 'digest'
        ));

        //echo($this -> rest -> get('insertGameBatchTbl', $params));
        $newGame = $this -> rest -> get('createGameForPortal', $params, 'json');

        //$lb = json_decode(json_encode($newGame), true);
        if (!isset($newGame))
        {
            //echo $this -> rest -> debug();
        }

        //$m = $newGame[sizeof($newGame) - 1] -> MESSAGE;
        if ($this -> rest -> status() == 200)
        {
            return ('success');
        }
        else
        {
            return ('try again');
        }
    }

    function team_user_rolemapAPI($gameId,$teamId,$emailId,$roleName)
    {
        // This API is not used instead we use "insertTeamUserRole" internal function
        
        // $this -> load -> model('Gamemasters_model');
        // $userDtls = $this -> Gamemasters_model->stratupuser();
        // var_dump($userDtls);
        // http://localhost/Stratup/index.php/GameInitControl/insertTeamUserRoleMap?gameId=1&teamid=1&username=leela&rolename=1
        // http://localhost/beegames/CourseDescription/team_user_rolemapAPI/1/4040/IT/leela
        // $gameId = $this -> get('gameId');
        // $teamId = $this -> get('teamid');
        // $userName = $this -> get('username');
        // $roleName = $this -> get('rolename');//Format: roleName1:roleName2:...
        
        $this -> load -> model('Gamemasters_model');
        $userName = $this -> Gamemasters_model->getUserDetailsForEmailId($emailId);
        //var_dump($userName);
        $params = array(
                'gameId' => $gameId,
                'teamid' => $teamId,
                'username' => $userName[0]['LOGIN_ID'],
                'rolename' => $roleName
            );
        $this -> load -> library('rest', array(
            'server' => straupAPIBaseURL . 'GameInitControl',
            'http_user' => APIuser,
            'http_pass' => APIpwd,
            'http_auth' => APIauth // or 'digest'
        ));
        $roleMapping = $this -> rest -> get('insertTeamUserRoleMap', $params, 'json');
        echo $this -> rest -> debug();
    }
    function insertTeamUserRole($gameTypeId,$gameId,$teamId,$emailId,$roleName,$universeToken)
    {
        $this -> load -> model('Gamemasters_model');
        
        $userDtls = $this -> Gamemasters_model->getUserDetailsForEmailId($emailId);
        if(!empty($userDtls))
        {
            $userId = $userDtls[0]['USER_ID'];
            $isnewuser='FALSE';
        }
        else 
        {
            $password = $this -> generate_key_string(6,1);
            $newUserData = array(
                        'FIRST_NAME' => $emailId,
                        'EMAIL_ID' => $emailId, 
                        'LOGIN_ID' => $emailId,         
                        'PASSWORD' => $password,
                         'EMAIL_VERIFIED' => '1',
                        //'EMAIL_VERIFY_TOKEN' => $this->emailToken(),
                        'USER_TYPE_ID' => '3'
                        );
            $this -> load -> model('User_model');
            $userId = $this -> User_model -> add_user_mstr($newUserData);
            $isnewuser='TRUE';
        }
        
        $roleDtls = $this ->Gamemasters_model->getDepartmentIdForTeamIdDeptName($teamId, $roleName);
        $roleId = $roleDtls[0]['DEPARTMENT_ID'];
        
        $sameUserTeam = $this->Gamemasters_model ->getTeamUserRoleMapTbl_by_userTeam($teamId,$userId);
        if(empty($sameUserTeam))
        {
            $this -> insertUserGameStatus($gameTypeId,$userId,$universeToken);
        }
        $this->Gamemasters_model ->insertTeamUserRoleMaptbl($teamId, $userId, $roleId);
        if($roleName=='IT')
        {
            $roleDtls = $this ->Gamemasters_model->getDepartmentIdForTeamIdDeptName($teamId, 'STG');
        $roleId = $roleDtls[0]['DEPARTMENT_ID'];
        
        $sameUserTeam = $this->Gamemasters_model ->getTeamUserRoleMapTbl_by_userTeam($teamId,$userId);
        if(empty($sameUserTeam))
        {
            $this -> insertUserGameStatus($gameTypeId,$userId,$universeToken);
        }
        $this->Gamemasters_model ->insertTeamUserRoleMaptbl($teamId, $userId, $roleId);
        }
        return $isnewuser;
        
    }
    function listPlayedGames()
    {
        $userId = 1;
        $this -> load -> model('Gamemasters_model');
        $teamId = $this->Gamemasters_model -> getTeamDtlsForGameId('3008');
        var_dump($teamId);
    }
    function generate_key_string($char,$segment) 
    {
        // Modified by : Leela
        // Modified on : 26-02-2018
        // function to create random String
        $tokens = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
        
        // $segment_chars = 8;
        // $num_segments = 1;
        $segment_chars = $char;
        $num_segments = $segment;
        $key_string = '';
        for ($i = 0; $i < $num_segments; $i++) 
        {
            $segment = '';
            for ($j = 0; $j < $segment_chars; $j++) 
            {
                $segment .= $tokens[rand(0, strlen($tokens)-1)];
            }
            $key_string .= $segment;

             if ($i < ($num_segments - 1)) 
             {
                 $key_string .= '-';
             }
        }
        return $key_string;
    }
    function emailToken()
    {
        // function to check duplicate token
        $this -> load -> model('User_model');
        do
        {
            $emailToken = $this -> generate_key_string(16,1);
            $result = $this -> User_model -> getEmailToken($emailToken);
        }
        while ($result != false);
        return $emailToken;
    }
    function verifyEmail()
    {
        $this -> load -> model('User_model');
        $loginId = $_GET['loginId'];
        $token = $_GET['hash'];

        // function to verify new user and update Email Verified
         $data = $this->User_model->verifyEmailToken($loginId,$token);
         if(!$data)
         {
             $this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Email Verification Failed. Please ensure the link you have entered is correct. </div>');
             $this -> load -> view('message_view');
         }
         else  
         {
             if($data[0]['EMAIL_VERIFIED']==1)
             {
                 $this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Email has been verified successfully.</br> <a href="'.base_url().'">Click Here to Login</a></div>');
                 $this -> load -> view('message_view');
             }
             else 
             {
                 $this->User_model->upateVerifiedUser($data[0]['USER_ID']);
                 $this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Email has been verified successfully.</br> <a href="'.base_url().'">Click Here to Login</a></div>');
                 $this -> load -> view('message_view');
             }
         }
    }
    function insertUserGameStatus($gameId,$userId,$universeToken)
    {
        // $userId may use in future once the model is modified.
        
        $this -> load -> model('Dialogueservice_model');
        $gameStoryDtls = $this->Dialogueservice_model->getRandomStoryForGame($gameId);
        $gsMapId = $gameStoryDtls[0]->GS_MAP_ID;
        $this -> load -> model('Gamemasters_model');
        $params = array(
                        'USER_ID' => $userId, 
                        'GS_MAP_ID' => $gsMapId,
                        'GAME_TOKEN' => $universeToken         
                        );
        $this -> Gamemasters_model ->add_user_game_status($params);
    }
    function sendmail($toemail,$companyName,$startdate,$enddate,$universetoken,$isnewuser)
    {
        $this->load->library('email'); // load email library
        $newUserEmail='';
        $newUserPassword='';
        if($isnewuser=='TRUE')
        {
            $newUserEmail='<p>EmailId: '.$toemail.'</p>';
            
            $this -> load -> model('Gamemasters_model');
            $userDtls = $this -> Gamemasters_model->getUserDetailsForEmailId($toemail);
            $newUserPassword = '<p>Temporary Password:'.$userDtls[0]['PASSWORD'].'</p>';
          
        }
        $this->email->from(supportMailId);
        $this->email->to($toemail);
        $this->email->cc(''); 
        $this->email->subject('Invitation: Your friend has invited you to virtually run a business enterprise');
        $this->email->message('<p><span style="font-family:Arial,Helvetica,sans-serif">Hi,</span></p>

                                <p>Your friend '.$this->session->userdata('uname').' has invited you to join his virtual organisation, to head one of the departments of a manufacturing company. </p>

                                <p>This is a Business Simulation Game, you along with your friends will assume the role of heads of various departments such as Marketing, FInance, HR, Operations, IT and International Business and compete with other teams to grow a profitable business.</p>

                                <p>Please find below the details of the game </p>
                                
                                <p>Your Organisation Name: '.$companyName.'</p>
                                
                                <p>Game Start Date: '.$startdate.'</p>
                                
                                <p>Game End Date: '.$enddate.'</p>
                                
                                <p>Game Universe Token: '.$universetoken.'</p>

                                <p>Click on the below link to play the game.</p>
                                
                                <p>'.base_url().'stratupx</p>
                                
                                <p>Are you ready to grow a profitable enterprise? All the Best!</p>
                                
                                <p>'.$newUserEmail.'</p><p>'.$newUserPassword.'</p>
                                
                                <p>&nbsp;</p>
                                
                                <p>Regards,</p>
                                
                                <p>Team BizGames</p>
                                
                                 <p>&nbsp;</p>
                                
                                <p> This is an autogenerated email. Incase of any clarifications write to contactus@processbee.com</p>');
        // $this->email->attach('/path/to/file1.png'); // attach file
        // $this->email->attach('/path/to/file2.pdf');
        if ($this->email->send())
        {
            //$this->session->set_flashdata('msg', '<div class="alert alert-success text-center"> We have sent your Login Credential to your e-MailID <br /> Please <a href="'.base_url().'"/login/index.php">Click Here</a> to Login</div>');
            //echo "Mail Sent!";
        }
        else
        {
            // $this->session->set_flashdata('msg', '<div class="alert alert-success text-center">We cant find your email address</div>');
          //  show_error($this->email->print_debugger());
        }
            
    }
    function GamePayment($gameId,$batchId,$gameType)
    {
        // call payment module
         $this -> load -> model('Gamemasters_model');
        
        if($batchId=='')
        {
                $data['errormessage'] = '<span class="text-danger">Sorry, not able to initiate game for Campaign.Please try again later</span>';
                    // redirect('login');
                echo json_encode($data);
        }
        else
        {            
            $mobileNum=$_POST['mobileNumber'];
            $maxPlayer=$_POST['maxPlayer'];
            $userSource = $_POST['usersource'];

            $this -> load -> model('Game_model');
            $gameDetails = $this -> Gamemasters_model -> getGameDescriptionForGameId($gameId);
            $this -> load -> model('Common_model');
            $currentDate = $this -> Common_model -> getCurrentDate();
            $discountDateDtls = $this -> Gamemasters_model ->getDiscountTillDateForGameId($gameId);
            if(count($discountDateDtls)>0)
            {
                if($currentDate[0]['CurrentDateTime'] > $discountDateDtls[0]->GAME_DETAIL_DESC)
                {
                    $amount = number_format($gameDetails[0]->PRICE, 2, '.', '');
                }
                else
                {
                    $amount = number_format($gameDetails[0]->DISCOUNT_PRICE, 2, '.', '');
                }
            }
            else
            {
                $amount = number_format($gameDetails[0]->PRICE, 2, '.', '');
            }          
                       
            $emailId = $this->session->userdata('emailid');
            $userName = $this->session->userdata('uname');
           
            $gameCreationParam = array($gameId, $maxPlayer);
            $paymentMessage = $this -> payment($userName,$emailId,$mobileNum,$amount, $gameType, $gameCreationParam,$userSource);
            $data['errormessage']='';
            $data['url'] = $paymentMessage[0];
            $data['posted'] = $paymentMessage[1];
            echo json_encode($data);                                
        }
    }
    function campaign_playStratupSolo($batchId,$gameType)
    {
        $silverRole[0]='HR';
        $silverRole[1]='MKT';
        $silverRole[2]='FIN';
        $silverRole[3]='OPS';
            
        $goldRole[0]='IT'; 
        $goldRole[1]='HR';
        $goldRole[2]='MKT';
       // $goldRole[3]='STG';
        $goldRole[3]='FIN';
        $goldRole[4]='OPS';
         $this -> load -> model('Gamemasters_model');
        
        if($gameType=="SILVER")
        {
            $rolename='HR:MKT:FIN:OPS';
            $role=$silverRole;
            $gameTypeId = 15;
        }
        else
        {
            $rolename='IT:HR:MKT:STG:FIN:OPS';
            $role=$goldRole;
            $gameTypeId = 2;
        }
        if($batchId=='')
        {
            $data['universe']='';
            $data['errormessage'] = '<span class="text-danger">Sorry, not able to initiate game for Campaign.Please try again later</span>';
                    // redirect('login');
            echo json_encode($data);
        }
        else
        {            
            $teamName=$_POST['teamName'];
            $this -> load -> model('Game_model');
            $gamebatchDtls = $this -> Game_model ->get_game_batch_tbl($batchId);
            $startDateConv = $gamebatchDtls['START_DATE'];
            $endDateConv = $gamebatchDtls['END_DATE'];
            
            $emailId = $this->session->userdata('emailid');
            $userId = $this->session->userdata('uid');

            //  $teamname1 = $this -> input -> post('TEAM_NAME');
            if($teamName!='')
            {
                $teamDtls=$this->Gamemasters_model ->getTeamsForTeamName($teamName);
                if(count($teamDtls)>0)
                {
                    $data['universe']='';
                    $data['errormessage'] = '<span class="text-danger">Company Name Already Exists</span>';
                        // redirect('login');
                    echo json_encode($data);
                }
                else
                {
                    // params variable array is used to create universe token
                    $params = array(
                        'CLIENT_ID' => 7,
                        'PRODUCT_SUB_CATEGORY_ID' => '1',
                        'TRAINIER_ID' => '18',
                        'gameType' => 'actual',
                        'universeType' => 'CLOSED',
                        'universeMode' => 'DUO TEAM BOARD',
                        'NO_OF_YEAR_IN_GAME' => 3,
                        'START_DATE' => $startDateConv,
                        'END_DATE' => $endDateConv,
                        'maxPlayers' => 1,
                        'stratupProductType' => $gameType,      
                        'gameMode' => 'SYNC',
                        'courseName' => '',
                        'isSingleTeamGame' => 1,
                        'isCampaign' => 1,
                        'batchId' => $batchId
                        );
                                
                    $message = $this -> createGameAPI($params);
                    $ob = json_decode(json_encode($message), true);
                                
                    if ($message['message'] == 'Game Instance Created') 
                    {
                        $params2 = array(
                            'universe' => $message['universe'],
                            'userid' => $this->session->userdata('uid'),
                            'roleName' => $rolename
                        );
                                    
                        $message2 = $this -> createGameForPortalAPI($params2);
                        $ob2 = json_decode(json_encode($message2), true);
                    
                        $this -> session -> set_flashdata('response', $message['message']);
                        $this -> session -> set_flashdata('universe', "Universe Token=" . $message['universe']);
                        $this -> sendmailtoSolo($emailId,$teamName,$startDateConv,$endDateConv,$message['universe']);
                                    
                        $this -> load -> model('Gamemasters_model');                
                        $teamId = $this->Gamemasters_model -> getTeamDtlsForGameId($message['gameId']);     
                        $randomNum = rand(1,20);
                        $image="PP".$randomNum;               
                        $this->Gamemasters_model -> updateTeamNameForTeamId($teamId[0]['TEAM_ID'],$teamName); 
                        $this->Gamemasters_model -> updateTeamLogoPathForTeamId($teamId[0]['TEAM_ID'],'resources/img/users/PlayerProfileIcons/'.$image.'.png');    
                        if($gameType=="SILVER")
                        {
                            for ($i=0; $i < 4 ; $i++) 
                            {
                                $this->insertTeamUserRole($gameTypeId,$message['gameId'],$teamId[0]['TEAM_ID'],$emailId,$role[$i],$message['universe']);
                            }          
                            $data['universe']=$message['universe'];
                            echo json_encode($data);   
                            //$this -> session -> set_flashdata('msg_success', $message['message'].'<br/>Universe Token=' . $message['universe']); 
                        //redirect('Payumoney/paymentDetailView');
                        }
                        else
                        {
                            for ($i=0; $i < 5 ; $i++) 
                            {
                                $this->insertTeamUserRole($gameTypeId,$message['gameId'],$teamId[0]['TEAM_ID'],$emailId,$role[$i],$message['universe']);
                            }          
                            $data['universe']= $message['universe'];
                            echo json_encode($data);  
                        //$this -> session -> set_flashdata('msg_success', $message['message'].'<br/>Universe Token=' . $message['universe']); 
                        //redirect('Payumoney/paymentDetailView');
                        }
                    }
                    else 
                    {
                        $data['universe']='';
                        $data['errormessage'] = '<span class="text-danger">Oops!! Some Thing Went Wrong. Please Try Again</span>';
                        echo json_encode($data);
                    }
                }            
            }
            else
            {
                $data['universe']='';
                $data['errormessage'] = '<span class="text-danger">Please Enter your company Name</span>';
                echo json_encode($data);
            }
        }
    }
    function campaign_playsoloTeamwitComp($batchId,$isValidation)
    {
        $data = array('success' => false, 'messages' => array());
        $maxPlayer =$this -> input -> post('MAX_PLAYER');
        $simulationType= $this -> input -> post('SIMULATION_TYPE');
        
        $silverRole[0]='HR';
        $silverRole[1]='MKT';
        $silverRole[2]='FIN';
        $silverRole[3]='OPS';
        
        $goldRole[0]='IT'; 
        $goldRole[1]='HR';
        $goldRole[2]='MKT';
        // $goldRole[3]='STG';
        $goldRole[3]='FIN';
        $goldRole[4]='OPS';
        
        $this -> load -> model('Game_model');
        $gamebatchDtls = $this -> Game_model ->get_game_batch_tbl($batchId);
            
        $startDateConv = $gamebatchDtls['START_DATE'];
        $endDateConv = $gamebatchDtls['END_DATE'];
        
        if($simulationType=="SILVER")
        {
            $maxRole=4;
            $role = $silverRole;
        }
        else 
        {
            $maxRole=5;
            $role = $goldRole;
        }
                
        $this -> load -> library('form_validation');
        $this->form_validation->set_message('is_unique', 'The %s is already taken');
        $this -> form_validation -> set_rules('TEAM_A_NAME', 'Team A Name', 'required');
        // $this -> form_validation -> set_rules('TEAM_B_NAME', 'Team B Name', 'required');
        $this->form_validation->set_error_delimiters('<span class="text-danger">', '</span>');
      
        for ($i=0; $i < $maxRole ; $i++) 
        { 
            $this -> form_validation -> set_rules('TEAM_A_PLAYER_EMAIL'.$i, 'Email', 'trim|required|valid_email');
        } 
             
        $timezone = 330;//$this -> input -> post('OFFSET');
        // echo $timezone;
        $this -> load -> model('Gamemasters_model');
        if ($this -> form_validation -> run())
        {
            $teamAName=$this -> input -> post('TEAM_A_NAME');
           // $teamBName=$this -> input -> post('TEAM_B_NAME');
           for ($i=0; $i < $maxRole ; $i++) 
           {
               $teamEmail[$i]= $this -> input -> post('TEAM_A_PLAYER_EMAIL'.$i);
           }
            $teamADtls=$this->Gamemasters_model ->getTeamsForTeamName($teamAName);
            if(count($teamADtls)>0)
            {
                $data['messages']['ONE_TEAM_NAME'] = '<span class="text-danger">Company Name Already Exists<br/></span>';
                    // redirect('login');
                echo json_encode($data);
            }            
            else
            {
                if(!in_array($this->session->userdata('emailid') , $teamEmail))
                {
                    $data['messages']['emailerr'] = '<span class="text-danger">Team does not contain current User EmailId.<br/></span>';
                        // redirect('login');
                    echo json_encode($data);
                }
                else
                {
                    $userexist = false;
                    $existingEmailId = "";
                    for ($i=0; $i < count($teamEmail) ; $i++) 
                    {
                        $this -> load -> model('Joingame_model');
                        $checkUserExists = $this->Joingame_model ->checkuserAvailableInUniverseByBatchId($batchId,$teamEmail[$i]);
                        if(count($checkUserExists)>0)
                        {
                            $userexist = true;
                            $existingEmailId = $teamEmail[$i];
                            break;
                        }
                    }
                    if($userexist)
                    {
                        $data['messages']['emailerr'] = '<span class="text-danger">'.$existingEmailId.' already exists in this universe.<br/></span>';
                            // redirect('login');
                            echo json_encode($data);
                    }
                    else
                    {
                        // params variable array is used to create universe token
                        $params = array(
                            'CLIENT_ID' => 7,
                            'PRODUCT_SUB_CATEGORY_ID' => '1',
                            'TRAINIER_ID' => '18',
                            'gameType' => 'actual',
                            'universeType' => 'CLOSED',
                            'universeMode' => 'DUO TEAM BOARD',
                            'NO_OF_YEAR_IN_GAME' => 1,
                            'START_DATE' => $startDateConv,
                            'END_DATE' => $endDateConv,
                            'maxPlayers' => $maxPlayer,
                            'stratupProductType' => $simulationType,                
                            'gameMode' => 'SYNC',
                            'courseName' => '',
                            'isSingleTeamGame' => 1,
                            'isCampaign' => 1,
                            'batchId' => $batchId
                        );
                        $message = $this -> createGameAPI($params);
                            // echo $this -> rest -> debug();
                        $ob = json_decode(json_encode($message), true);
                        if ($ob=='try again') 
                        {
                            // $this -> session -> set_flashdata('error', 'Oops!! Some Thing Went Wrong. Please Try Again');
                            // redirect('CourseDescription/playStraupGame'.$gameTypeId, 'refresh');
                            $data['messages']['emailerr'] = '<span class="text-danger">Oops!! Some Thing Went Wrong. Please Try Again</span>';
                            echo json_encode($data);
                        }
                        else if ($message['message'] == 'Game Instance Created') 
                        {
                            $this -> session -> set_flashdata('response', $message['message']);
                            $this -> session -> set_flashdata('universe', "Universe Token=" . $message['universe']);
                            $teamId = $this->Gamemasters_model -> getTeamDtlsForGameId($message['gameId']);
                            $randomNum = rand(1,20);
                            $image="PP".$randomNum;                    
                            $this->Gamemasters_model -> updateTeamNameForTeamId($teamId[0]['TEAM_ID'],$teamAName);
                            $this->Gamemasters_model -> updateTeamLogoPathForTeamId($teamId[0]['TEAM_ID'],'resources/img/users/PlayerProfileIcons/'.$image.'.png');
                                            
                            // insert user role mapping
                            $this->db-> trans_begin(); 
                            
                            for ($i=0; $i < $maxRole ; $i++) 
                            {
                                $teamAPlayerEmail[$i]= $this -> input -> post('TEAM_A_PLAYER_EMAIL'.$i);
                                
                                $teamAPlayerNew[$i]=$this->insertTeamUserRole(11,$message['gameId'],$teamId[0]['TEAM_ID'],$teamAPlayerEmail[$i],$role[$i],$message['universe']);
                            }
                        
                            $error = $this->db-> error();
                            if ( $this->db-> trans_status() === FALSE)
                            {
                                $this->db-> trans_rollback();                            
                                
                                $data['success'] = false;
                                echo json_encode($data);
                            }
                            else
                            {
                                $this->db-> trans_commit();
                                    
                                for ($i=0; $i < $maxRole ; $i++) 
                                {
                                    $teamAPlayerEmail[$i]= $this -> input -> post('TEAM_A_PLAYER_EMAIL'.$i);
                                    $userDtlsA = $this -> Gamemasters_model->getUserDetailsForEmailId($teamAPlayerEmail[$i]);
                                        
                                    $params2 = array(
                                        'universe' => $message['universe'],
                                        'userid' => $userDtlsA[0]['USER_ID'],
                                        'roleName' => $role[$i]
                                    );
                                            
                                    $message2 = $this -> createGameForPortalAPI($params2);
                                    $ob2 = json_decode(json_encode($message2), true);
                                    
                                    $this ->sendmail($teamAPlayerEmail[$i],$this -> input -> post('TEAM_A_NAME'),$params['START_DATE'],$params['END_DATE'],$message['universe'],$teamAPlayerNew[$i]);
                                } 
                                $data['universe']='<br/>Universe Token=' . $message['universe'];
                                $data['success'] = true;
                                echo json_encode($data);
                            }
                        }
                    }                    
                }                
            }      
        }
        else
        {
            if ($isValidation == 'VALIDATION')
            {
                foreach ($_POST as $key => $value) 
                {
                    if(substr($key,14,5)=='EMAIL')
                    {
                        $data['messages']['emailerr'] = '<span class="text-danger">Please Enter a Valid Email.</span>';
                        $data['messages'][$key] = '<span class="text-danger"></span>';
                    }
                    else 
                    {
                        $data['messages'][$key] = form_error($key);
                    }
                }               
                echo json_encode($data);                
            }
        }
    }
    function campaign_playStraupGame($batchId,$isValidation)
    {
        $data = array('success' => false, 'messages' => array());
        $maxPlayer =$this -> input -> post('MAX_PLAYER');
        $simulationType= $this -> input -> post('SIMULATION_TYPE');
        
        $silverRole[0]='HR';
        $silverRole[1]='MKT';
        $silverRole[2]='FIN';
        $silverRole[3]='OPS';
        
        $goldRole[0]='IT'; 
        $goldRole[1]='HR';
        $goldRole[2]='MKT';
        // $goldRole[3]='STG';
        $goldRole[3]='FIN';
        $goldRole[4]='OPS';
        
        $this -> load -> model('Game_model');
        $gamebatchDtls = $this -> Game_model ->get_game_batch_tbl($batchId);
            
        $startDateConv = $gamebatchDtls['START_DATE'];
        $endDateConv = $gamebatchDtls['END_DATE'];
        
        if($simulationType=="SILVER")
        {
            $maxRole=4;
            $role = $silverRole;
            $roleName = 'HR:MKT:FIN:OPS';
        }
        else 
        {
            $maxRole=5;
            $role = $goldRole;
            $roleName = 'IT:HR:MKT:STG:FIN:OPS';
        }
                
        $this -> load -> library('form_validation');
        $this->form_validation->set_message('is_unique', 'The %s is already taken');
        $this -> form_validation -> set_rules('TEAM_A_NAME', 'Team A Name', 'required');
        $this -> form_validation -> set_rules('TEAM_B_NAME', 'Team B Name', 'required');
        $this->form_validation->set_error_delimiters('<span class="text-danger">', '</span>');
        if($maxPlayer>2)
        {
           for ($i=0; $i < $maxRole ; $i++) 
           { 
               $this -> form_validation -> set_rules('TEAM_A_PLAYER_EMAIL'.$i, 'Email', 'trim|required|valid_email');
               $this -> form_validation -> set_rules('TEAM_B_PLAYER_EMAIL'.$i, 'Email', 'trim|required|valid_email');
           } 
        }
        else 
        {
            $this -> form_validation -> set_rules('TEAM_A_PLAYER_EMAIL', 'Email', 'trim|required|valid_email');
            $this -> form_validation -> set_rules('TEAM_B_PLAYER_EMAIL', 'Email', 'trim|required|valid_email');
        }
        
        $timezone = 330;//$this -> input -> post('OFFSET');
        // echo $timezone;
        $this -> load -> model('Gamemasters_model');
        if ($this -> form_validation -> run())
        {
            if($maxPlayer > 2)
            {
                for ($i=0; $i < $maxRole ; $i++) 
                {
                    $teamAEmail[$i]= $this -> input -> post('TEAM_A_PLAYER_EMAIL'.$i);
                    $teamBEmail[$i]= $this -> input -> post('TEAM_B_PLAYER_EMAIL'.$i);
                }
            }
            else
            {
                $i=0;
                    $teamAEmail[$i]= $this -> input -> post('TEAM_A_PLAYER_EMAIL');
                    $teamBEmail[$i]= $this -> input -> post('TEAM_B_PLAYER_EMAIL');
                
            }
            
            $teamAName=$this -> input -> post('TEAM_A_NAME');
            $teamBName=$this -> input -> post('TEAM_B_NAME');
            
            $teamADtls=$this->Gamemasters_model ->getTeamsForTeamName($teamAName);
            if(count($teamADtls)>0)
            {
                $data['messages']['TEAM_A_NAME'] = '<span class="text-danger">Company Name Already Exists<br/></span>';
                    // redirect('login');
                echo json_encode($data);
            }
            else
            {
                $teamBDtls=$this->Gamemasters_model ->getTeamsForTeamName($teamBName);
                if(count($teamBDtls)>0)
                {
                    $data['messages']['TEAM_B_NAME'] = '<span class="text-danger">Company Name Already Exists<br/></span>';
                        // redirect('login');
                    echo json_encode($data);
                }
                else
                {
                    if(!in_array($this->session->userdata('emailid') , $teamAEmail) && !in_array($this->session->userdata('emailid') , $teamBEmail))
                    {
                        $data['messages']['emailerr'] = '<span class="text-danger">Team does not contain current User EmailId.<br/></span>';
                            // redirect('login');
                        echo json_encode($data);
                    }
                    else
                    {
                        $userexist = false;
                        $existingEmailId = "";
                        for ($i=0; $i < count($teamAEmail) ; $i++) 
                        {
                            $this -> load -> model('Joingame_model');
                            $checkUserExists = $this->Joingame_model ->checkuserAvailableInUniverseByBatchId($batchId,$teamAEmail[$i]);
                            if(count($checkUserExists)>0)
                            {
                                $userexist = true;
                                $existingEmailId = $teamAEmail[$i];
                                break;
                            }
                        }
                        if($userexist)
                        {
                            $data['messages']['emailerr'] = '<span class="text-danger">'.$existingEmailId.' already exists in this universe.<br/></span>';
                                // redirect('login');
                                echo json_encode($data);
                        }
                        else
                        {
                            for ($i=0; $i < count($teamBEmail) ; $i++) 
                            {
                                $this -> load -> model('Joingame_model');
                                $checkUserExists = $this->Joingame_model ->checkuserAvailableInUniverseByBatchId($batchId,$teamBEmail[$i]);
                                if(count($checkUserExists)>0)
                                {
                                    $userexist = true;
                                    $existingEmailId = $teamBEmail[$i];
                                    break;
                                }
                            }
                            if($userexist)
                            {
                                $data['messages']['emailerr'] = '<span class="text-danger">'.$existingEmailId.' already exists in this universe.<br/></span>';
                                    // redirect('login');
                                echo json_encode($data);
                            }
                            else
                            {
                                // params variable array is used to create universe token
                                $params = array(
                                    'CLIENT_ID' => 7,
                                    'PRODUCT_SUB_CATEGORY_ID' => '1',
                                    'TRAINIER_ID' => '18',
                                    'gameType' => 'actual',
                                    'universeType' => 'CLOSED',
                                    'universeMode' => 'DUO TEAM BOARD',
                                    'NO_OF_YEAR_IN_GAME' => 1,
                                    'START_DATE' => $startDateConv,
                                    'END_DATE' => $endDateConv,
                                    'maxPlayers' => $maxPlayer,
                                    'stratupProductType' => $simulationType,                
                                    'gameMode' => 'SYNC',
                                    'courseName' => '',
                                    'isSingleTeamGame' => 0,
                                    'isCampaign' => 1,
                                    'batchId' => $batchId
                                );
                                $message = $this -> createGameAPI($params);
                                // echo $this -> rest -> debug();
                                $ob = json_decode(json_encode($message), true);
                                if ($ob=='try again') 
                                {
                                    // $this -> session -> set_flashdata('error', 'Oops!! Some Thing Went Wrong. Please Try Again');
                                    // redirect('CourseDescription/playStraupGame'.$gameTypeId, 'refresh');
                                    $data['messages']['emailerr'] = '<span class="text-danger">Oops!! Some Thing Went Wrong. Please Try Again</span>';
                                    echo json_encode($data);
                                }
                                else if ($message['message'] == 'Game Instance Created') 
                                {
                                    $this -> session -> set_flashdata('response', $message['message']);
                                    $this -> session -> set_flashdata('universe', "Universe Token=" . $message['universe']);
                                    $teamId = $this->Gamemasters_model -> getTeamDtlsForGameId($message['gameId']);
                                    $randomNumA = rand(1,20);
                                    $imageA="PP".$randomNumA;   
                                    $randomNumB = rand(1,20);
                                    $imageB="PP".$randomNumB;                  
                                    $this->Gamemasters_model -> updateTeamNameForTeamId($teamId[0]['TEAM_ID'],$teamAName);
                                    $this->Gamemasters_model -> updateTeamNameForTeamId($teamId[1]['TEAM_ID'],$teamBName);
                                    $this->Gamemasters_model -> updateTeamLogoPathForTeamId($teamId[0]['TEAM_ID'],'resources/img/users/PlayerProfileIcons/'.$imageA.'.png');
                                    $this->Gamemasters_model -> updateTeamLogoPathForTeamId($teamId[1]['TEAM_ID'],'resources/img/users/PlayerProfileIcons/'.$imageB.'.png');
                                                    
                                    // insert user role mapping
                                    $this->db-> trans_begin(); 
                                    if($maxPlayer>2)
                                    {
                                        for ($i=0; $i < $maxRole ; $i++) 
                                        {
                                            $teamAPlayerEmail[$i]= $this -> input -> post('TEAM_A_PLAYER_EMAIL'.$i);
                                            $teamBPlayerEmail[$i]= $this -> input -> post('TEAM_B_PLAYER_EMAIL'.$i);
                                    
                                            $teamAPlayerNew[$i]=$this->insertTeamUserRole(11,$message['gameId'],$teamId[0]['TEAM_ID'],$teamAPlayerEmail[$i],$role[$i],$message['universe']);
                                            $teamBPlayerNew[$i]=$this->insertTeamUserRole(11,$message['gameId'],$teamId[1]['TEAM_ID'],$teamBPlayerEmail[$i],$role[$i],$message['universe']);
                                        }
                                    }
                                    else
                                    {
                                        for ($i=0; $i < $maxRole ; $i++) 
                                        {
                                            $teamAPlayerEmail= $this -> input -> post('TEAM_A_PLAYER_EMAIL');
                                            $teamBPlayerEmail= $this -> input -> post('TEAM_B_PLAYER_EMAIL');
                                        
                                            $teamAPlayerNew=$this->insertTeamUserRole(11,$message['gameId'],$teamId[0]['TEAM_ID'],$teamAPlayerEmail,$role[$i],$message['universe']);
                                            $teamBPlayerNew=$this->insertTeamUserRole(11,$message['gameId'],$teamId[1]['TEAM_ID'],$teamBPlayerEmail,$role[$i],$message['universe']);                         
                                        }
                                    }
                                    $error = $this->db-> error();
                                    if ( $this->db-> trans_status() === FALSE)
                                    {
                                        $this->db-> trans_rollback();
                                                            
                                        $data['success'] = false;
                                        echo json_encode($data);
                                    }
                                    else
                                    {
                                        $this->db-> trans_commit();
                                    
                                        if($maxPlayer>2)
                                        {
                                            for ($i=0; $i < $maxRole ; $i++) 
                                            {
                                                $teamAPlayerEmail[$i]= $this -> input -> post('TEAM_A_PLAYER_EMAIL'.$i);
                                                $userDtlsA = $this -> Gamemasters_model->getUserDetailsForEmailId($teamAPlayerEmail[$i]);
                                            
                                                $params2 = array(
                                                'universe' => $message['universe'],
                                                'userid' => $userDtlsA[0]['USER_ID'],
                                                'roleName' => $role[$i]
                                                );
                                                $message2 = $this -> createGameForPortalAPI($params2);
                                                $ob2 = json_decode(json_encode($message2), true);
                                                
                                                $teamBPlayerEmail[$i]= $this -> input -> post('TEAM_B_PLAYER_EMAIL'.$i);
                                                $userDtlsB = $this -> Gamemasters_model->getUserDetailsForEmailId($teamBPlayerEmail[$i]);
                                            
                                                $params3 = array(
                                                'universe' => $message['universe'],
                                                'userid' => $userDtlsB[0]['USER_ID'],
                                                'roleName' => $role[$i]
                                                );
                                                $message3 = $this -> createGameForPortalAPI($params3);
                                                $ob3 = json_decode(json_encode($message3), true);
                                                //var_dump($teamAPlayerEmail[$i]);
                                                $this ->sendmail($teamAPlayerEmail[$i],$this -> input -> post('TEAM_A_NAME'),$params['START_DATE'],$params['END_DATE'],$message['universe'],$teamAPlayerNew[$i]);
                                                $this ->sendmail($teamBPlayerEmail[$i],$this -> input -> post('TEAM_B_NAME'),$params['START_DATE'],$params['END_DATE'],$message['universe'],$teamBPlayerNew[$i]);
                                            }
                                        }
                                        else 
                                        {
                                        
                                            $teamAPlayerEmail= $this -> input -> post('TEAM_A_PLAYER_EMAIL');
                                            $userDtlsA = $this -> Gamemasters_model->getUserDetailsForEmailId($teamAPlayerEmail);
                                            
                                            $params2 = array(
                                                'universe' => $message['universe'],
                                                'userid' => $userDtlsA[0]['USER_ID'],
                                                'roleName' => $roleName
                                            );
                                            $message2 = $this -> createGameForPortalAPI($params2);
                                            $ob2 = json_decode(json_encode($message2), true);
                                            
                                            $teamBPlayerEmail= $this -> input -> post('TEAM_B_PLAYER_EMAIL');
                                            $userDtlsB = $this -> Gamemasters_model->getUserDetailsForEmailId($teamBPlayerEmail);
                                            
                                            $params3 = array(
                                                'universe' => $message['universe'],
                                                'userid' =>  $userDtlsB[0]['USER_ID'],
                                                'roleName' => $roleName
                                            );
                                            $message3 = $this -> createGameForPortalAPI($params3);
                                            $ob3 = json_decode(json_encode($message3), true);
                                            
                                            $this ->sendmail($teamAPlayerEmail,$this -> input -> post('TEAM_A_NAME'),$params['START_DATE'],$params['END_DATE'],$message['universe'],$teamAPlayerNew);
                                            $this ->sendmail($teamBPlayerEmail,$this -> input -> post('TEAM_B_NAME'),$params['START_DATE'],$params['END_DATE'],$message['universe'],$teamBPlayerNew);
                                        }
                                        $data['universe']='<br/>Universe Token=' . $message['universe'];
                                        $data['success'] = true;
                                        echo json_encode($data);
                                    }
                                }
                            }
                        }                        
                    }                    
                }
            }      
        }
        else
        {
            if ($isValidation == 'VALIDATION')
            {
                foreach ($_POST as $key => $value) 
                {
                    if(substr($key,14,5)=='EMAIL')
                    {
                       // $data['messages']['emailerr'] = '<span class="text-danger">Please Enter a Valid Email.</span>';
                        $data['messages'][$key] = '<span class="text-danger">Please Enter a Valid Email.</span>';
                    }
                    else 
                    {
                        $data['messages'][$key] = form_error($key);
                    }
                }               
                echo json_encode($data);                
            }
        }
    }
    function sendmailtoSolo($toemail,$companyName,$startdate,$enddate,$universetoken)
    {
        $start = new DateTime($startdate);
        $end = new DateTime($enddate);
        $this->load->library('email'); // load email library
        $this->email->from(supportMailId);
        $this->email->to($toemail);
        $this->email->cc(''); 
        $this->email->subject('STRATUP Business Simulation : Run your virtual business enterprise');
        $this->email->message('<p><span style="font-family:Arial,Helvetica,sans-serif">Hi,</span></p>

                                <p>Congratulations! You have taken the first step towards setting up your virtual business enterprise. </p>

                                <p>STRATUP is a first of its kind multiplayer game based business simulator. In the game you would be assuming roles of heads of departments, draw strategic plans and make decisions to outperform your competitors. </p>

                                <p>Please find the details of the game </p>
                                
                                <p>Your Organisation Name: '.$companyName.'</p>
                                
                                <p><b>Game Universe Token: '.$universetoken.' <br/>(Enter this token in the game to get started) </b></p>
                                
                                <p>Game Start Date: '.date_format($start, 'd-M-Y').'</p>
                                
                                <p>Game End Date: '.date_format($end, 'd-M-Y').'</p>
                                
                                <p>Click on the below link to play the game.</p>
                                
                                <p>'.base_url().'stratupx</p>
                                
                                <p>If the link is not displayed correctly, please copy the URL above and paste it into your browser.</p>
                                
                                <p>Wishing you the best in your learning journey.</p>
                                
                                <p>&nbsp;</p>
                                
                                <p>Regards,</p>
                                
                                <p>Team BizGames</p>
                                
                                 <p>&nbsp;</p>
                                
                                <p> This is an autogenerated email. Incase of any clarifications write to contactus@processbee.com</p>');
        // $this->email->attach('/path/to/file1.png'); // attach file
        // $this->email->attach('/path/to/file2.pdf');
         // echo "http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]?param=download";
        if ($this->email->send())
        {
            //$this->session->set_flashdata('msg', '<div class="alert alert-success text-center"> We have sent your Login Credential to your e-MailID <br /> Please <a href="'.base_url().'"/login/index.php">Click Here</a> to Login</div>');
            //echo "Mail Sent!";
        }
        else
        {
            // $this->session->set_flashdata('msg', '<div class="alert alert-success text-center">We cant find your email address</div>');
          //  show_error($this->email->print_debugger());
        }
            
    }
    function getuserPCinfo()
    {
           $this->load->library('user_agent');

      $data['browser'] = $this->agent->browser();

      $data['browser_version'] = $this->agent->version();

      $data['os'] = $this->agent->platform();

      $data['ip_address'] = $this->input->ip_address();
      
      return $data;
    }
    function checkUserinUniverse($batchId)
    {
           $this -> load -> model('Gamemasters_model');
            $userId = $this->session->userdata('uid');
         $userAvailableInOtherTeam=$this ->Gamemasters_model->checkUserinUniverse($batchId,$userId);
                
               if(count($userAvailableInOtherTeam)>0)
                {
                    $data['joined'] = true;
                    echo json_encode($data);
                }
                else
                {
                    $data['joined'] = false;
                    echo json_encode($data);
                }
    }
    function payment($userName, $emailId, $mobileNum, $amount, $gameType, $gameCreationParam,$userSource)
    {
        $this ->load->helper('url');
        $this->load->helper(array('string'));
        // Merchant key here as provided by Payu
        $MERCHANT_KEY = "RqVRBmxz";

        // Merchant Salt as provided by Payu
        $SALT = "5gLvZarBe8";

        // End point - change to https://secure.payu.in for LIVE mode
        // $PAYU_BASE_URL = "https://sandboxsecure.payu.in";
        $PAYU_BASE_URL = "https://secure.payu.in";

        $action = '';

        $posted = array();

        //Generate random transaction id
        $txnid = random_string('numeric', 5);

       // if(!empty($_POST)) {
                
                $posted['amount'] = $amount;
                $posted['phone'] = $mobileNum;
                $posted['firstname'] = $userName;
                $posted['email'] = $emailId;
                $posted['key'] = $MERCHANT_KEY;
                $posted['txnid'] = $txnid;
                $posted['productinfo'] = $gameType;
                $posted['surl'] = base_url("payumoney/success");
                $posted['furl'] = base_url("payumoney/error");
                $posted['curl'] = base_url("payumoney/cancel");
                $posted['service_provider'] = 'payu_paisa';
                $posted['udf1'] = $gameCreationParam[0];
                $posted['udf2'] = $gameCreationParam[1];

        //}
        // print_r($_POST);
        $hash = '';

        // Hash Sequence
        $hashSequence = "key|txnid|amount|productinfo|firstname|email|udf1|udf2|udf3|udf4|udf5|udf6|udf7|udf8|udf9|udf10";

        if(empty($posted['hash']) && sizeof($posted) > 0) {
                
                $hashVarsSeq = explode('|', $hashSequence);
                $hash_string = '';
                foreach($hashVarsSeq as $hash_var){
                    $hash_string .= isset($posted[$hash_var]) ? $posted[$hash_var] : '';
                    $hash_string .= '|';
                }

                $hash_string .= $SALT;
                $hash = strtolower(hash('sha512', $hash_string));
                $posted['hash'] = $hash;
                $action = $PAYU_BASE_URL. '/_payment' ;
               // $action = "https://www.google.com";
                $payment[0] = $action;
                $payment[1] = $posted;

                $this ->  load -> model('Common_model');
                if($gameCreationParam[1] == 1)
                {
                    $selectedgameType = 'SinglePlayer vs Computer';
                }
                else if($gameCreationParam[1] == 2)
                {
                    $selectedgameType = 'SinglePlayer vs SinglePlayer';
                }
                else if($gameCreationParam[1] == 4 || $gameCreationParam[1] == 5)
                {
                    $selectedgameType = 'Team vs Computer';
                }
                else
                {
                    $selectedgameType = 'Team vs Team';
                }
                $this ->  load -> model('User_model');
                $userDetails = $this -> User_model -> getUserDetailsByEmail($emailId);
                $params = array(
                    'TRANSACTION_ID' => $txnid,
                    'TRANSACTION_DATE' => '',
                    'USER_ID' => $userDetails[0]->USER_ID,
                    'PRODUCT_ID' => $gameCreationParam[0],
                    'TRANSACTION_MODE' => '',
                    'STATUS' => '',
                    'AMOUNT' => $amount,
                    'GAME_TYPE' => $selectedgameType,
                    'GAME_MODE' => $gameType,
                    'SELECTED_MAX_PLAYER' => $gameCreationParam[1]
                );
                // $paymentDetails = $this -> Common_model ->getPaymentForGameIdandUserId($userDetails[0]->USER_ID, $gameCreationParam[0]);
                // if(count($paymentDetails)>0)
                // {
                //     $this -> Common_model -> updatePaymentTractionDetails($userDetails[0]->USER_ID, $gameCreationParam[0], $params);
                // } 
                // else
                // {
                    $this-> Common_model -> insertPaymentTractionDetails($params);
                //}
                $mobileparams = array('MOBILE_NO' => $mobileNum,'USER_SOURCE'=>$userSource);
                $this -> User_model ->update_user_mstr($userDetails[0]->USER_ID,$mobileparams);
                return $payment;
        }
        elseif(!empty($posted['hash'])){
        $hash = $posted['hash'];
        $action = $PAYU_BASE_URL . '/_payment';
        
        }
    }
    public function landingPage()
    {
        if(!empty($_GET["param"])) 
        {
            $param = $_GET["param"];
        }
        $data=$this->getgameDtls(11);
        $data['getTesimonialsList'] = json_decode(json_encode($this -> Gamemasters_model -> getTesimonialsList()),true);
        $data['_view'] = 'prelogin/professor_landing_page_view';
        $this -> load -> view('layouts/main_view', $data);
    }
}
