<?php
include (APPPATH . 'libraries/CommonUtilities.php');
class Dashboard extends CommonUtilities
{
    function __construct()
    {
        parent::__construct();
        $this -> load -> helper(array('url', 'html'));
        $this -> load -> library('session');
        $this -> load -> model('Game_model');
        $this->load->model('Mylearning_model');
        header('Access-Control-Allow-Origin: *');
        if(!$this->session->userdata('login'))
        {
            redirect('login');
        }
    }
    function index()
    {
        if(strtolower($this->session->userdata('utype'))!='admin')
        {
            redirect('myaccount');
        }
        else
        {
            redirect('course-details');
        }
        
    }
    function dhistory($dept,$teamId,$gameId)
    {
        $dept = strtoupper($dept);
        $convertionType = implode(" ", $this->input->post());
        if(count($_POST)==0 )
        {
            $convertionType=1;
        }
        $departmentId = $this -> input -> post('DEPT');
        
        if($dept=="MKT")
        {
            $qtrStatus=$this -> Game_model -> getQtrStatus($gameId);
            $this -> load -> library('rest', array('server' => straupAPIBaseURL . 'DiagnosticReportController/', 
                                                'http_user' => 'admin', 
                                                'http_pass' => '1234', 
                                                'http_auth' => 'digest' // or 'digest'
                                                )
                                );
          
            $this -> load -> model('Dashboard_model');
            $mktCostFilter = array('MKT - ADVERTISEMENT COST',
                                'MKT - AFTER SALES COST',
                                'MKT - DISTRIBUTION SETUP COST',
                                'MKT - DISTRIBUTION SUPPORT COST',
                                'MKT - DISTRIBUTION TRAINING COST',
                                'MKT - FEATURE CATEGORY COST',
                                'MKT - MARGIN COST',
                                'MKT - SALES FORCE INCENTIVE',
                                'MKT - TRANSPORTATION COST',
                                'MKT - WARRENTY COST',
                                'Advertisement Cost');
            $mktRevFilter = array('SALES REVENUE',
                                  'SALES REVENUE - COST');
            $mktSalaryFilter = array('MKT RECRUITMENT COST');
            
            $mktCostDtls = $this->Dashboard_model->qtrwiseIncomeAndExpenseByTrans($mktCostFilter,$teamId);
            $mktRevDtls = $this->Dashboard_model->qtrwiseIncomeAndExpenseByTrans($mktRevFilter,$teamId);
            $mktProductAllocList = $this->Dashboard_model->mktproductAllocatedList($teamId);
            $mktProductAllocated = $this->Dashboard_model->mktproductAllocated($teamId);
            $mktProductSold = $this->Dashboard_model->productSold($teamId);
            $mktProdAllocatSoldProdWise = $this->Dashboard_model->mktProdAllocatandSoldProdwise($teamId,$gameId);
            $mktAwareAdvertise = $this->Dashboard_model->awarenessandAdvertise($teamId);
            $mktDistributionCost = $this->Dashboard_model->distributionCost($teamId);
            $mktSalaryCost = $this->Dashboard_model->BudgetDetails($teamId,$gameId,$mktSalaryFilter);
            $mktProdAllocatQtr = $this->Dashboard_model->mktProdAllocatQtrwise($teamId);
            $mktProdSoldQtr = $this->Dashboard_model->mktProdSoldQtrwise($teamId);
            $AwarenessScore = $this -> rest -> get('getModeWiseAwarenessScore?teamId='.$teamId.'&gameId='.$gameId);
            $mktAwarenessScore = json_decode(json_encode($AwarenessScore), true);
            $productMstrName = $this->Dashboard_model->getProductNameFromgameMstr($gameId);
           // $mylearning = $this->Dashboard_model->mylearninglist($teamId);
           // echo $mktAwarenessScore;
            $TotalMktCost=0;
            $TotalMktRev=0;
            $mktCostChartData = array();
            $mktRevChartData=array();
            $mktProdAllocatChartData=array();
            $mktProdSoldChartData=array();
            $mktAwarenessChartData=array();
            $key = 0;

            foreach ($mktCostDtls as $row) 
            {
                $TotalMktCost += $row['Amount'];
                if($row['Year']!=0)
                {
                    $key = 'Y'.$row['Year'].'Q'.$row['Qtr'];
                    if (!array_key_exists($key, $mktCostChartData)) {
                        $mktCostChartData[$key] = array(
                            'Year' => $row['Year'],
                            'Qtr' => $row['Qtr'],
                            'Amount' => $row['Amount'],
                        );
                    } else 
                    {
                        $mktCostChartData[$key]['Amount'] = $mktCostChartData[$key]['Amount'] + $row['Amount'];
                    }
                }
            }
            foreach ($mktRevDtls as $row) 
            {
                $TotalMktRev += $row['Amount'];
                if($row['Year']!=0)
                {
                    $key = 'Y'.$row['Year'].'Q'.$row['Qtr'];
                    if (!array_key_exists($key, $mktRevChartData)) {
                        $mktRevChartData[$key] = array(
                            'Year' => $row['Year'],
                            'Qtr' => $row['Qtr'],
                            'Amount' => $row['Amount'],
                        );
                    } else 
                    {
                        $mktRevChartData[$key]['Amount'] = $mktRevChartData[$key]['Amount'] + $row['Amount'];
                    }
                }
            }
            foreach ($mktProdAllocatQtr as $row) 
            {
                $key = 'Y'.$row['Year'].'Q'.$row['Qtr'];
                if (!array_key_exists($key, $mktProdAllocatChartData)) {
                    $mktProdAllocatChartData[$key] = array(
                        'Year' => $row['Year'],
                        'Qtr' => $row['Qtr'],
                        'PRODUCTS' => $row['PRODUCTS_ALLOTED'],
                    );
                } else 
                {
                    $mktProdAllocatChartData[$key]['PRODUCTS'] = $mktProdAllocatChartData[$key]['PRODUCTS'] + $row['PRODUCTS_ALLOTED'];
                }
            }
            foreach ($mktProdSoldQtr as $row) 
            {
                $key = 'Y'.$row['Year'].'Q'.$row['Qtr'];
                if (!array_key_exists($key, $mktProdSoldChartData)) {
                    $mktProdSoldChartData[$key] = array(
                        'Year' => $row['Year'],
                        'Qtr' => $row['Qtr'],
                        'PRODUCTS' => $row['PRODUCTS_SOLD'],
                    );
                } else 
                {
                    $mktProdSoldChartData[$key]['PRODUCTS'] = $mktProdSoldChartData[$key]['PRODUCTS'] + $row['PRODUCTS_SOLD'];
                }
            }
            foreach ($mktAwarenessScore as $row) 
            {
                $key = $row['ADVERTISEMENT_MODE_NAME'];
                if (!array_key_exists($key, $mktAwarenessChartData)) {
                    $mktAwarenessChartData[$key] = array(
                        'MODE' => $row['ADVERTISEMENT_MODE_NAME'],
                        'SCORE' => $row['AWARNESS_CREATED']
                    );
                } else 
                {
                    $mktAwarenessChartData[$key]['SCORE'] = $mktAwarenessChartData[$key]['SCORE'] + $row['AWARNESS_CREATED'];
                }
            }
            
            
            $new = array("rev"=>$mktRevChartData,
                         "cost"=>$mktCostChartData,
                         "Allocat"=>$mktProdAllocatChartData,
                         "Sold"=>$mktProdSoldChartData,
                         "AwarenessScore"=>$mktAwarenessChartData,
                         "totalrev"=>$this->convertToSmallNum($TotalMktRev,$convertionType),
                         "totalmktcost"=>$this->convertToSmallNum($TotalMktCost,$convertionType),
                         "mktProductAllocList"=>$mktProductAllocList,
                         "mktProductAllocat"=>$this->convertToSmallNum($mktProductAllocated[0]['PRODUCTS_ALLOTED'],$convertionType),
                         "mktProductSold"=>$this->convertToSmallNum($mktProductSold[0]['PRODUCTS_SOLD'],$convertionType),
                         "Dept"=> $dept,
                         "mktProduct1Allocated"=>$mktProdAllocatSoldProdWise[0]['PRODUCTS_ALLOCATED'],
                         "mktProduct2Allocated"=>$mktProdAllocatSoldProdWise[1]['PRODUCTS_ALLOCATED'],
                         "mktProduct3Allocated"=>$mktProdAllocatSoldProdWise[2]['PRODUCTS_ALLOCATED'],
                         "mktProduct4Allocated"=>$mktProdAllocatSoldProdWise[3]['PRODUCTS_ALLOCATED'],
                         "mktProduct1Sold"=>$mktProdAllocatSoldProdWise[0]['PRODUCTS_SOLD'],
                         "mktProduct2Sold"=>$mktProdAllocatSoldProdWise[1]['PRODUCTS_SOLD'],
                         "mktProduct3Sold"=>$mktProdAllocatSoldProdWise[2]['PRODUCTS_SOLD'],
                         "mktProduct4Sold"=>$mktProdAllocatSoldProdWise[3]['PRODUCTS_SOLD'],
                         "mktAwarenessScore"=>$mktAwareAdvertise[0]['AWARNESS_SCORE'],
                         "mktAdvertiseCost"=>$this->convertToSmallNum($mktAwareAdvertise[0]['ADVERTISEMENT_COST'],$convertionType),
                         "mktDistributionCost"=>$this->convertToSmallNum($mktDistributionCost[0]['MARGIN_COST'],$convertionType),
                         "mktSalaryCost"=>$this->convertToSmallNum($mktSalaryCost[0]['AMOUNT'],$convertionType),
                         "qtrstatus"=>$qtrStatus,
                         "teamId"=>$teamId,
                         "gameId"=>$gameId,
                         "product"=>$productMstrName
                            );
                            
        $data['chartdata'] = json_encode($new);
        
        $data['_view'] = 'dept_dashboard/mkt_view';
        $this -> load -> view('layouts/main_view', $data);
        }
        else if($dept=="OPS")
        {
         $this -> load -> library('rest', array('server' => straupAPIBaseURL . 'DiagnosticReportController/', 
                                                'http_user' => 'admin', 
                                                'http_pass' => '1234', 
                                                'http_auth' => 'digest' // or 'digest'
                                                )
                                );
                                
            $qtrStatus=$this -> Game_model -> getQtrStatus($gameId);
            
            // $this -> load -> library('rest', array('server' => straupAPIBaseURL . 'DiagnosticReportController/', 
                                                    // 'http_user' => 'admin', 
                                                    // 'http_pass' => '1234', 
                                                    // 'http_auth' => 'digest' // or 'digest'
                                                    // )
                                    // );
            // $chartdata = $this -> rest -> get('wininigCriteriaYearWise?teamId='.$teamId, 'json');
            // $array = json_decode(json_encode($chartdata), true);
            // // Filter Array for Revenue Growth 
            // // array_values used to reindex 
            // $revGrowth = array_values(array_filter($array, function ($var)  {
                // return( ($var['WINING_CRITERIA_DESC'] == 'REVENUE GROWTH'));
            // }));
            
            $this -> load -> model('Dashboard_model');
            $opsCostFilter = array('WAREHOUSE Cost - PRODUCT',
                                'Warehouse Cost - Raw Material',
                                'PACKAGE_COST',
                                'WAREHOUSE COST',
                                'COST OF BUYING PLANT',
                                'COST OF BUYING MACHINE',
                                'COST OF BUYING WAREHOUSE');
            $opsProductionFilter = array('MACHINARY MAINTENANCE COST',
                                          'OVER HEAD COST',
                                          'PLANT MAINTENANCE',
                                          'IT_HARDWARE_DEPRECIATION',
                                          'PLANT_DEPRECIATION',
                                          'MACHINE_DEPRECIATION',
                                          'WAREHOUSE_DEPRECIATION');
            $OpsSalaryFilter = array('OPS RECRUITMENT COST');
            $RawMaterialFilter = array('OPENING RAW MATERIAL',
                                       'OPS RAWMATERIAL PURCHASE COST');
            $ClosingRawMaterialFilter = array('CLOSING RAW MATERIAL');
            
            $opsCostDtls = $this->Dashboard_model->qtrwiseIncomeAndExpenseByTrans($opsCostFilter,$teamId);
            $opsProductProduction = $this->Dashboard_model->productProduction($teamId);
            $opsProdwiseProduced = $this->Dashboard_model->productWiseAllocatedProduced($teamId,$gameId);
            $ProductInventory = $this->Dashboard_model->productsInventory($teamId);
            $opsSalaryCost = $this->Dashboard_model->BudgetDetails($teamId,$gameId,$OpsSalaryFilter);
            $opsProductAllocList = $this->Dashboard_model->opsproductAllocatedList($teamId);
            $opsPurchList = $this->Dashboard_model->opsPurchaseList($teamId);
            $RawMaterial = $this->Dashboard_model->BudgetDetails($teamId,$gameId,$RawMaterialFilter);
            $ClosingRawMaterial = $this->Dashboard_model->BudgetDetails($teamId,$gameId,$ClosingRawMaterialFilter);
            $ProductionCost = $this->Dashboard_model->BudgetDetails($teamId,$gameId,$opsProductionFilter);
            $ProductionQtr = $this->Dashboard_model->productProductionQtrwise($teamId);
            //$producttype=  $this->input->post('product');
            $productMstrName = $this->Dashboard_model->getProductNameFromgameMstr($gameId);
            // if(count($_POST)==0 )
            // {
                // $producttype=1;
            // }
            // if($producttype==1)
            // {
                // $productName=$productMstrName[0]['PRODUCT_DESC'];
                // $productName=str_replace(' ', '%20', $productName);
                // //$productName="Kisan%20Micra";
            // }
            // else if($producttype==2)
            // {
                // $productName=$productMstrName[1]['PRODUCT_DESC'];
                // $productName=str_replace(' ', '%20', $productName);
               // // $productName="Swift%20Micra";
            // }
            // else if($producttype==3)
            // {
                // $productName=$productMstrName[2]['PRODUCT_DESC'];
                // $productName=str_replace(' ', '%20', $productName);
               // // $productName="Kitz";
            // }
            // else{
                // $productName=$productMstrName[3]['PRODUCT_DESC'];
                // $productName=str_replace(' ', '%20', $productName);
               // // $productName="Figa";
            // }
            $productName1=$productMstrName[0]['PRODUCT_DESC'];
            $productName1=str_replace(' ', '%20', $productName1);
            $productName2=$productMstrName[1]['PRODUCT_DESC'];
            $productName2=str_replace(' ', '%20', $productName2);
            $productName3=$productMstrName[2]['PRODUCT_DESC'];
            $productName3=str_replace(' ', '%20', $productName3);
            $productName4=$productMstrName[3]['PRODUCT_DESC'];
            $productName4=str_replace(' ', '%20', $productName4);
            
            $Cogsbreakupprod1 = $this -> rest -> get('getCogsBreakUp?teamId='.$teamId.'&gameId='.$gameId.'&productName='.$productName1);
            $opsCogsbreakupprod1 = json_decode(json_encode($Cogsbreakupprod1), true);
            $Cogsbreakupprod2 = $this -> rest -> get('getCogsBreakUp?teamId='.$teamId.'&gameId='.$gameId.'&productName='.$productName2);
            $opsCogsbreakupprod2 = json_decode(json_encode($Cogsbreakupprod2), true);
            $Cogsbreakupprod3 = $this -> rest -> get('getCogsBreakUp?teamId='.$teamId.'&gameId='.$gameId.'&productName='.$productName3);
            $opsCogsbreakupprod3 = json_decode(json_encode($Cogsbreakupprod3), true);
            $Cogsbreakupprod4 = $this -> rest -> get('getCogsBreakUp?teamId='.$teamId.'&gameId='.$gameId.'&productName='.$productName4);
            $opsCogsbreakupprod4 = json_decode(json_encode($Cogsbreakupprod4), true);
            
            $unitcostPriceprod1 = $this -> rest -> get('getUnitCostvsRevenuePrice?teamId='.$teamId.'&gameId='.$gameId.'&productName='.$productName1);
            $unitcostandPriceprod1 = json_decode(json_encode($unitcostPriceprod1), true);
            $unitcostPriceprod2 = $this -> rest -> get('getUnitCostvsRevenuePrice?teamId='.$teamId.'&gameId='.$gameId.'&productName='.$productName2);
            $unitcostandPriceprod2 = json_decode(json_encode($unitcostPriceprod2), true);
            $unitcostPriceprod3 = $this -> rest -> get('getUnitCostvsRevenuePrice?teamId='.$teamId.'&gameId='.$gameId.'&productName='.$productName3);
            $unitcostandPriceprod3 = json_decode(json_encode($unitcostPriceprod3), true);
            $unitcostPriceprod4 = $this -> rest -> get('getUnitCostvsRevenuePrice?teamId='.$teamId.'&gameId='.$gameId.'&productName='.$productName4);
            $unitcostandPriceprod4 = json_decode(json_encode($unitcostPriceprod4), true);
            
            $rejectionReasonprod1 = $this -> rest -> get('reasonForRejectionNew?teamId='.$teamId.'&gameId='.$gameId.'&productName='.$productName1);
            $rejectionprod1 = json_decode(json_encode($rejectionReasonprod1), true);
            $rejectionReasonprod2 = $this -> rest -> get('reasonForRejectionNew?teamId='.$teamId.'&gameId='.$gameId.'&productName='.$productName2);
            $rejectionprod2 = json_decode(json_encode($rejectionReasonprod2), true);
            $rejectionReasonprod3 = $this -> rest -> get('reasonForRejectionNew?teamId='.$teamId.'&gameId='.$gameId.'&productName='.$productName3);
            $rejectionprod3 = json_decode(json_encode($rejectionReasonprod3), true);
            $rejectionReasonprod4 = $this -> rest -> get('reasonForRejectionNew?teamId='.$teamId.'&gameId='.$gameId.'&productName='.$productName4);
            $rejectionprod4 = json_decode(json_encode($rejectionReasonprod4), true);
            
            $unitdata = $this -> rest -> get('getUnitCostDtlsForGame?teamId='.$teamId.'&gameId='.$gameId);
            $unit = json_decode(json_encode($unitdata), true);
            $gamePlayedyear = $this->Dashboard_model->NoofYearsPlayed($gameId);
            $CapUtilizeData = $this -> rest -> get('getAvgCapacity?teamId='.$teamId);
            $CapUtilize = json_decode(json_encode($CapUtilizeData), true);
            //$mylearning = $this->Dashboard_model->mylearninglist($teamId);
            //print_r($CapUtilize);  
            $TotalOpsCost=0;
            $TotalOpsProductionCost=0;
            $TotalUnitCost = 0;
            $unitcost=array();
            $opsAllocatChartData = array();
            $unitcostChartData=array();
            $key = 0;
            
            $AvgCapUtilized =  Ceil(array_sum(array_column($CapUtilize,'Capacity_utilized')) / count($CapUtilize)) ;
            
            for($i=1;$i<=5;$i++)
            {
                $filterBy = $i;
            $year = array_values(array_filter($unit, function ($var) use ($filterBy)  {
            return( ($var['YEAR'] == $filterBy));
            }));
            
            $unitcost [$i]=array_sum(array_column($year, 'VALUE'));
            }
            if($gamePlayedyear[0]['Year']>0)
            {
                $TotalUnitCost =  array_sum($unitcost) / $gamePlayedyear[0]['Year'] ;
            }
            else
            {
                $TotalUnitCost=0;
            }
           
          // print_r($TotalUnitCost);
            foreach ($ProductionQtr as $row) 
            {
    
                $key = 'Y'.$row['Year'].'Q'.$row['Qtr'];
                if (!array_key_exists($key, $opsAllocatChartData)) {
                    $opsAllocatChartData[$key] = array(
                        'Year' => $row['Year'],
                        'Qtr' => $row['Qtr'],
                        'ProdAllocat' => $row['PRODUCTS_ALLOCATED'],
                        'ProdSold' => $row['PRODUCTS_PRODUCED'],
                    );
                } else 
                {
                    $opsAllocatChartData[$key]['ProdAllocat'] = $opsAllocatChartData[$key]['ProdAllocat'] + $row['PRODUCTS_ALLOCATED'];
                    $opsAllocatChartData[$key]['ProdSold'] = $opsAllocatChartData[$key]['ProdSold'] + $row['PRODUCTS_PRODUCED'];
                }
            }
            // $RawMat = array_values(array_filter($opsCogsbreakup, function ($var)  {
            // return( ($var['HEAD'] == 'RAWMATERIAL_COST'));
            // }));
            // $Packaging = array_values(array_filter($opsCogsbreakup, function ($var)  {
            // return( ($var['HEAD'] == 'PACKAGING_COST'));
            // }));
            // $Warehouse = array_values(array_filter($opsCogsbreakup, function ($var)  {
            // return( ($var['HEAD'] == 'WAREHOUSE_COST'));
            // }));
            // $PlantMain = array_values(array_filter($opsCogsbreakup, function ($var)  {
            // return( ($var['HEAD'] == 'PLANT_MAINTENANCE_COST'));
            // }));
            // $Overhead = array_values(array_filter($opsCogsbreakup, function ($var)  {
            // return( ($var['HEAD'] == 'OVERHEAD_COST'));
            // }));
            // $Labour = array_values(array_filter($opsCogsbreakup, function ($var)  {
            // return( ($var['HEAD'] == 'LABOUR_COST'));
            // }));
//             
            // foreach ($unitcostandPrice as $row) 
            // {
//     
                // $key = 'Y'.$row['YEAR'];
                // if (!array_key_exists($key, $unitcostChartData)) {
                    // $unitcostChartData[$key] = array(
                        // 'Year' => $row['YEAR'],
                        // 'Unitcost' => $row['UNIT_COST'],
                        // 'Price' => $row['PRICE'],
                    // );
                // } else 
                // {
                    // $unitcostChartData[$key]['Unitcost'] = $unitcostChartData[$key]['Unitcost'] + $row['UNIT_COST'];
                    // $unitcostChartData[$key]['Price'] = $unitcostChartData[$key]['Price'] + $row['PRICE'];
                // }
            // }
            // $MachCapacity = array_values(array_filter($rejectionprod4, function ($var)  {
            // return( ($var['HEAD'] == 'MACHINE_CAPACITY'));
            // }));
            // $operatorAvail = array_values(array_filter($rejectionprod4, function ($var)  {
            // return( ($var['HEAD'] == 'OPERATOR_AVAILABILITY'));
            // }));
            // $operatorEff = array_values(array_filter($rejectionprod4, function ($var)  {
            // return( ($var['HEAD'] == 'OPERATOR_EFFECTIVENESS'));
            // }));
            // $Machinery = array_values(array_filter($rejectionprod4, function ($var)  {
            // return( ($var['HEAD'] == 'MACHINERY'));
            // }));
            // $warehouseQua = array_values(array_filter($rejectionprod4, function ($var)  {
            // return( ($var['HEAD'] == 'WAREHOUSE_QUALITY'));
            // }));
            // $supplierQua = array_values(array_filter($rejectionprod4, function ($var)  {
            // return( ($var['HEAD'] == 'SUPPLIER_QUALITY'));
            // }));
            // $PackagingEff = array_values(array_filter($rejectionprod4, function ($var)  {
            // return( ($var['HEAD'] == 'PACKAGING_EFFECTIVENESS'));
            // }));
            
            $rawMaterialInventory = $RawMaterial[0]['AMOUNT'] - $ClosingRawMaterial[0]['AMOUNT'];
            $costofGoodsSold = $rawMaterialInventory + $opsSalaryCost[0]['AMOUNT'] + $ProductionCost[0]['AMOUNT'];
           
            if(empty($opsProductAllocList) &&  empty($opsPurchList))
            {
                $maintbl=array();
            }
            else
            {
                if(sizeof($opsProductAllocList)>0 && sizeof($opsPurchList)>0)
                {
                    if(max(array_column($opsProductAllocList, 'MoveNO'))<max(array_column($opsPurchList, 'MoveNO')))
                    {
                        $outerarray=$opsPurchList;
                        $innerarray=$opsProductAllocList;
                    }
                    else 
                    {
                        $outerarray=$opsProductAllocList;
                        $innerarray=$opsPurchList;
                    }
                 }
                 else
                 {
                    if(sizeof($opsPurchList)>0)
                    {
                        $outerarray=$opsPurchList;
                        $innerarray=$opsProductAllocList;
                    }
                    else 
                    {
                        $outerarray=$opsProductAllocList;
                        $innerarray=$opsPurchList;
                    }
                 }
            $row=0;
            foreach($outerarray as $value)
            {
                 $flag = FALSE;
                foreach($innerarray as $value2)
                {
                    if($value['MoveNO'] === $value2['MoveNO'])
                    {
                       
                        if(array_key_exists('ProductName', $value2))
                        {
                            $maintbl[$row]['orderid'] = $value2['orderid'];
                            $maintbl[$row]['MoveNO'] = $value2['MoveNO'];
                            $maintbl[$row]['Year'] = $value2['Year'];
                            $maintbl[$row]['Qtr'] = $value2['Qtr'];
                            $maintbl[$row]['ProductName'] = $value2['ProductName'];
                            $maintbl[$row]['AllotedUnits'] = $value2['AllotedUnits'];
                            $maintbl[$row]['PlantPurchase'] = $value['PlantPurchase'];
                            $maintbl[$row]['MachinePurchase'] = $value['MachinePurchase'];
                            $maintbl[$row]['WarehousePurchase'] = $value['WarehousePurchase'];
                            $maintbl[$row]['teamid'] = $value2['teamid'];
                            $row++;
                        }
                        else {
                            $maintbl[$row]['orderid'] = $value['orderid'];
                            $maintbl[$row]['MoveNO'] = $value['MoveNO'];
                            $maintbl[$row]['Year'] = $value['Year'];
                            $maintbl[$row]['Qtr'] = $value['Qtr'];
                            $maintbl[$row]['ProductName'] = $value['ProductName'];
                            $maintbl[$row]['AllotedUnits'] = $value['AllotedUnits'];
                            $maintbl[$row]['PlantPurchase'] = $value2['PlantPurchase'];
                            $maintbl[$row]['MachinePurchase'] = $value2['MachinePurchase'];
                            $maintbl[$row]['WarehousePurchase'] = $value2['WarehousePurchase'];
                            $maintbl[$row]['teamid'] = $value['teamid'];
                            $row++;
                        }
                       
                        $removed = array_shift($innerarray);
                        $flag = true;
                        break;
                    }
                    else if($value['MoveNO'] > $value2['MoveNO'])
                    {
                        if(array_key_exists('PlantPurchase', $value2))
                        {
                            $maintbl[$row]['orderid'] = $value2['orderid'];
                            $maintbl[$row]['MoveNO'] = $value2['MoveNO'];
                            $maintbl[$row]['Year'] = $value2['Year'];
                            $maintbl[$row]['Qtr'] = $value2['Qtr'];
                            $maintbl[$row]['ProductName'] = "NA";
                            $maintbl[$row]['AllotedUnits'] =  "NA";
                            $maintbl[$row]['PlantPurchase'] = $value2['PlantPurchase'];
                            $maintbl[$row]['MachinePurchase'] = $value2['MachinePurchase'];
                            $maintbl[$row]['WarehousePurchase'] = $value2['WarehousePurchase'];
                            $maintbl[$row]['teamid'] = $value['teamid'];
                            $row++;
                            $removed = array_shift($innerarray);
                        }
                        else
                        {
                            $maintbl[$row]['orderid'] = $value2['orderid'];
                            $maintbl[$row]['MoveNO'] = $value2['MoveNO'];
                            $maintbl[$row]['Year'] = $value2['Year'];
                            $maintbl[$row]['Qtr'] = $value2['Qtr'];
                            $maintbl[$row]['ProductName'] = $value2['ProductName'];
                            $maintbl[$row]['AllotedUnits'] = $value2['AllotedUnits'];
                            $maintbl[$row]['PlantPurchase'] = "No";
                            $maintbl[$row]['MachinePurchase'] = "No";
                            $maintbl[$row]['WarehousePurchase'] ="No";
                            $maintbl[$row]['teamid'] = $value2['teamid'];
                            $row++;
                            $removed = array_shift($innerarray);
                        }
                        
                    }
                    else if($value['MoveNO'] < $value2['MoveNO'])
                    {
                        if(array_key_exists('ProductName', $value))
                        {
                            $maintbl[$row]['orderid'] = $value['orderid'];
                            $maintbl[$row]['MoveNO'] = $value['MoveNO'];
                            $maintbl[$row]['Year'] = $value['Year'];
                            $maintbl[$row]['Qtr'] = $value['Qtr'];
                            $maintbl[$row]['ProductName'] = $value['ProductName'];
                            $maintbl[$row]['AllotedUnits'] = $value['AllotedUnits'];
                            $maintbl[$row]['PlantPurchase'] = "No";
                            $maintbl[$row]['MachinePurchase'] = "No";
                            $maintbl[$row]['WarehousePurchase'] ="No";
                            $maintbl[$row]['teamid'] = $value['teamid'];
                            $row++;
                            $flag = TRUE;
                            break;
                        }
                        else
                        {
                            $maintbl[$row]['orderid'] = $value['orderid'];
                            $maintbl[$row]['MoveNO'] = $value['MoveNO'];
                            $maintbl[$row]['Year'] = $value['Year'];
                            $maintbl[$row]['Qtr'] = $value['Qtr'];
                            $maintbl[$row]['ProductName'] = "NA";
                            $maintbl[$row]['AllotedUnits'] =  "NA";
                            $maintbl[$row]['PlantPurchase'] = $value['PlantPurchase'];
                            $maintbl[$row]['MachinePurchase'] = $value['MachinePurchase'];
                            $maintbl[$row]['WarehousePurchase'] = $value['WarehousePurchase'];
                            $maintbl[$row]['teamid'] = $value['teamid'];
                            $row++;
                            $flag = TRUE;
                            break;
                        }
                    }
                }
                if($flag == FALSE)
                {
                    if(array_key_exists('ProductName', $value))
                        {
                            $maintbl[$row]['orderid'] = $value['orderid'];
                            $maintbl[$row]['MoveNO'] = $value['MoveNO'];
                            $maintbl[$row]['Year'] = $value['Year'];
                            $maintbl[$row]['Qtr'] = $value['Qtr'];
                            $maintbl[$row]['ProductName'] = $value['ProductName'];
                            $maintbl[$row]['AllotedUnits'] = $value['AllotedUnits'];
                            $maintbl[$row]['PlantPurchase'] = "No";
                            $maintbl[$row]['MachinePurchase'] = "No";
                            $maintbl[$row]['WarehousePurchase'] ="No";
                            $maintbl[$row]['teamid'] = $value['teamid'];
                            $row++;
                            continue;
                        }
                    else 
                    {
                            $maintbl[$row]['orderid'] = $value['orderid'];
                            $maintbl[$row]['MoveNO'] = $value['MoveNO'];
                            $maintbl[$row]['Year'] = $value['Year'];
                            $maintbl[$row]['Qtr'] = $value['Qtr'];
                            $maintbl[$row]['ProductName'] = "NA";
                            $maintbl[$row]['AllotedUnits'] = "NA";
                            $maintbl[$row]['PlantPurchase'] = $value['PlantPurchase'];
                            $maintbl[$row]['MachinePurchase'] = $value['MachinePurchase'];
                            $maintbl[$row]['WarehousePurchase'] =$value['WarehousePurchase'];
                            $maintbl[$row]['teamid'] = $value['teamid'];
                            $row++;
                            continue;
                    }
                }                
            }
            }
           

           // print_r($opsProductAllocList);
            $new = array("ProdSoldProduce"=>$opsAllocatChartData,
                        // "RawMaterial"=>$RawMat,
                        // "Packaging"=>$Packaging,
                        // "Warehouse"=>$Warehouse,
                        // "PlantMain"=>$PlantMain,
                        // "Overhead"=>$Overhead,
                        // "Labour"=>$Labour,
                        "opsCogsbreakupprod1"=>$opsCogsbreakupprod1,
                        "opsCogsbreakupprod2"=>$opsCogsbreakupprod2,
                        "opsCogsbreakupprod3"=>$opsCogsbreakupprod3,
                        "opsCogsbreakupprod4"=>$opsCogsbreakupprod4,
                         //"unitcostPrice"=>$unitcostChartData,
                         "unitcostPriceprod1"=>$unitcostandPriceprod1,
                         "unitcostPriceprod2"=>$unitcostandPriceprod2,
                         "unitcostPriceprod3"=>$unitcostandPriceprod3,
                         "unitcostPriceprod4"=>$unitcostandPriceprod4,
                         // "MachineCapacity"=>$MachCapacity,
                         // "OprAvail"=>$operatorAvail,
                         // "OprEffect"=>$operatorEff,
                         // "Machinery"=>$Machinery,
                         // "WarehouseQua"=>$warehouseQua,
                         // "SupplierQua"=>$supplierQua,
                         // "PackageEff"=>$PackagingEff,
                         "rejectionprod1"=>$rejectionprod1,
                         "rejectionprod2"=>$rejectionprod2,
                         "rejectionprod3"=>$rejectionprod3,
                         "rejectionprod4"=>$rejectionprod4,
                         "totalProdCost"=>$this->convertToSmallNum($TotalOpsProductionCost,$convertionType),
                         "totalopscost"=>$this->convertToSmallNum($TotalOpsCost,$convertionType),
                         "capUtilized"=>$AvgCapUtilized,
                         "opsProductAllocList"=>$maintbl,
                         "opsProductAllocated"=>$this->convertToSmallNum($opsProductProduction[0]['PRODUCTS_ALLOCATED'],$convertionType),
                         "opsProductProduced"=>$this->convertToSmallNum($opsProductProduction[0]['PRODUCTS_PRODUCED'],$convertionType),
                         "opsProductEfficiency"=>$opsProductProduction[0]['PRODUCTION_EFFICIENCY'],
                         "totunitcost"=>$TotalUnitCost,
                         "Dept"=> $dept,
                         "opsProduct1Allocated"=>$opsProdwiseProduced[0]['PRODUCTS_ALLOCATED'],
                         "opsProduct2Allocated"=>$opsProdwiseProduced[1]['PRODUCTS_ALLOCATED'],
                         "opsProduct3Allocated"=>$opsProdwiseProduced[2]['PRODUCTS_ALLOCATED'],
                         "opsProduct4Allocated"=>$opsProdwiseProduced[3]['PRODUCTS_ALLOCATED'],
                         "opsProduct1Produced"=>$opsProdwiseProduced[0]['PRODUCTS_PRODUCED'],
                         "opsProduct2Produced"=>$opsProdwiseProduced[1]['PRODUCTS_PRODUCED'],
                         "opsProduct3Produced"=>$opsProdwiseProduced[2]['PRODUCTS_PRODUCED'],
                         "opsProduct4Produced"=>$opsProdwiseProduced[3]['PRODUCTS_PRODUCED'],
                         "ProductInventory"=>$this->convertToSmallNum($ProductInventory[0]['TOTAL_NO_OF_PRODUCTS'],$convertionType),
                         "CostofGoodsSold"=>$this->convertToSmallNum($costofGoodsSold,$convertionType),
                         "opsSalaryCost"=>$this->convertToSmallNum($opsSalaryCost[0]['AMOUNT'],$convertionType),
                         "qtrstatus"=>$qtrStatus,
                         "teamId"=>$teamId,
                         "gameId"=>$gameId,
                         "currencyType"=>$convertionType,
                         "product"=>$productMstrName
                            );
                            
                           // var_dump($maintblData);
        $data['chartdata'] = json_encode($new);
        
        $data['_view'] = 'dept_dashboard/ops_view';
        $this -> load -> view('layouts/main_view', $data);
        }
        else if($dept=="STG")
        {
            $this -> load -> library('rest', array('server' => straupAPIBaseURL . 'DiagnosticReportController/', 
                                                'http_user' => 'admin', 
                                                'http_pass' => '1234', 
                                                'http_auth' => 'digest' // or 'digest'
                                                )
                                );
                                
            $qtrStatus=$this -> Game_model -> getQtrStatus($gameId);
            
            $this -> load -> model('Dashboard_model');
            $stgCostFilter = array('JV TOTAL PER UNIT COST',
                                   'JV SETUP COST',
                                   'EXPORT TOTAL PER UNIT COST',
                                   'EXPORT SETUP COST');
            $stgRevFilter = array('EXPORT REVENUE',
                                  'JV REVENUE');
            
            $stgCostDtls = $this->Dashboard_model->BudgetDetails($teamId,$gameId,$stgCostFilter);
            $stgProductAllocated = $this->Dashboard_model->stgproductAllocated($teamId);
            $stgProductSold = $this->Dashboard_model->stgproductSold($teamId);
            // $stgTotalRevenue = $this->Dashboard_model->stgTotalRevenue($teamId);
            $stgTotalRevenue = $this->Dashboard_model->BudgetDetails($teamId,$gameId,$stgRevFilter);
            $stgProdAllocatSoldCounWise = $this->Dashboard_model->stgProdAllocatandSoldCounwise($teamId);
            $stgModeWiseRevenue = $this->Dashboard_model->stgModeWiseRevenue($teamId);
            $stgPartnerShareRevenue = $this->Dashboard_model->stgPartnerhareRevenue($teamId);
            $stgCounwiseCulScore = $this->Dashboard_model->stgCounCulturalScore($teamId);
            $stgCulScore = $this->Dashboard_model->stgCulturalScore($teamId);
            $stgProductAllocList = $this->Dashboard_model->stgproductAllocatedList($teamId);
            $stgCountryMstr = $this->Dashboard_model->getCountryNameFromgameMstr($gameId,$teamId);
            
            $stgProdAllocatQtr = $this->Dashboard_model->stgProdAllocatQtrwise($teamId);
            $stgRevYear = $this -> rest -> get('getStrgRevenue?teamId='.$teamId.'&gameId='.$gameId);
            $stgRev = json_decode(json_encode($stgRevYear), true);
            //$mylearning = $this->Dashboard_model->mylearninglist($teamId);
         
           $stgAllocatChartData = array();
           $stgSoldChartData = array();
           $stgRevChartData = array();
           $stgCounScoreChartData = array();
           $key = 0;
          foreach ($stgProdAllocatQtr as $row) 
            {
    
                $key = 'Y'.$row['Year'].'Q'.$row['Qtr'];
                if (!array_key_exists($key, $stgAllocatChartData)) {
                    $stgAllocatChartData[$key] = array(
                        'Year' => $row['Year'],
                        'Qtr' => $row['Qtr'],
                        'ProdAllocat' => $row['PRODUCTS_ALLOCATED'],
                        'ProdSold' => $row['PRODUCTS_SOLD'],
                    );
                } else 
                {
                    $stgAllocatChartData[$key]['ProdAllocat'] = $stgAllocatChartData[$key]['ProdAllocat'] + $row['PRODUCTS_ALLOCATED'];
                     $stgAllocatChartData[$key]['ProdSold'] = $stgAllocatChartData[$key]['ProdSold'] + $row['PRODUCTS_SOLD'];
                }
            }
            $export = array_values(array_filter($stgRev, function ($var)  {
            return( ($var['HEAD'] == 'EXPORTREVENUE'));
             }));
            $jv = array_values(array_filter($stgRev, function ($var)  {
            return( ($var['HEAD'] == 'JVREVENUE'));
             }));
        
            foreach ($stgCounwiseCulScore as $row) 
            {
                $key = $row['COUNTRY_DESC'];
                if (!array_key_exists($key, $stgCounScoreChartData)) {
                    $stgCounScoreChartData[$key] = array(
                        'COUNTRY' => $row['COUNTRY_DESC'],
                        'SCORE' => $row['SCORE']
                    );
                } else 
                {
                    $stgCounScoreChartData[$key]['SCORE'] = $stgCounScoreChartData[$key]['SCORE'] + $row['SCORE'];
                }
            }

            $new = array("totalstgcost"=>$this->convertToSmallNum($stgCostDtls[0]['AMOUNT'],$convertionType),
                         "stgProductAllocated"=>$this->convertToSmallNum($stgProductAllocated[0]['PRODUCTS_ALLOCATED'],$convertionType),
                         "stgProductSold"=>$this->convertToSmallNum($stgProductSold[0]['PRODUCTS_SOLD'],$convertionType),
                         "stgTotalRevenue"=>$this->convertToSmallNum($stgTotalRevenue[0]['AMOUNT'],$convertionType),
                         "stgAllocatQtr"=>$stgAllocatChartData,
                         "stgExportRevYear"=>$export,
                         "stgJVRevYear"=>$jv,
                         "stgProductAllocList"=>$stgProductAllocList,
                         "stgCoun1Allocated"=>$stgProdAllocatSoldCounWise[0]['PRODUCTS_ALLOCATED'],
                         "stgCoun2Allocated"=>$stgProdAllocatSoldCounWise[1]['PRODUCTS_ALLOCATED'],
                         "stgCoun3Allocated"=>$stgProdAllocatSoldCounWise[2]['PRODUCTS_ALLOCATED'],
                         "stgCoun4Allocated"=>$stgProdAllocatSoldCounWise[3]['PRODUCTS_ALLOCATED'],
                         "stgCoun5Allocated"=>$stgProdAllocatSoldCounWise[4]['PRODUCTS_ALLOCATED'],
                         "stgCoun1Sold"=>$stgProdAllocatSoldCounWise[0]['PRODUCTS_SOLD'],
                         "stgCoun2Sold"=>$stgProdAllocatSoldCounWise[1]['PRODUCTS_SOLD'],
                         "stgCoun3Sold"=>$stgProdAllocatSoldCounWise[2]['PRODUCTS_SOLD'],
                         "stgCoun4Sold"=>$stgProdAllocatSoldCounWise[3]['PRODUCTS_SOLD'],
                         "stgCoun5Sold"=>$stgProdAllocatSoldCounWise[4]['PRODUCTS_SOLD'],
                         "stgExportRevenue"=>$this->convertToSmallNum($stgModeWiseRevenue[0]['REVENUE'],$convertionType),
                         "stgJVRevenue"=>$this->convertToSmallNum($stgModeWiseRevenue[1]['REVENUE'],$convertionType),
                         "stgPartnerRevenue"=>$this->convertToSmallNum($stgPartnerShareRevenue[0]['PARTNER_REVENUE'],$convertionType),
                         "stgCounwiseScore"=>$stgCounScoreChartData,
                         "stgCulScore"=>$this->convertToSmallNum($stgCulScore[0]['SCORE'],$convertionType),
                         "Dept"=> $dept,
                         "qtrstatus"=>$qtrStatus,
                         "teamId"=>$teamId,
                         "gameId"=>$gameId,
                         "country"=>$stgCountryMstr
                            );
                            
            $data['chartdata'] = json_encode($new);
            
            $data['_view'] = 'dept_dashboard/stg_view';
            $this -> load -> view('layouts/main_view', $data);  
        }
        else if($dept=="HR")
        {
            $this -> load -> library('rest', array('server' => straupAPIBaseURL . 'DiagnosticReportController/', 
                                                'http_user' => 'admin', 
                                                'http_pass' => '1234', 
                                                'http_auth' => 'digest' // or 'digest'
                                                )
                                );
                                
            $qtrStatus=$this -> Game_model -> getQtrStatus($gameId);
            
            $this -> load -> model('Dashboard_model');
            $hrTrainingCostFilter = array('HR TRAINING COST');
            $hrWelfareCostFilter = array('WELLFARE PROGRAM COST');
            $hrAcquisitionCostFilter = array('ACQUISITION COST',
                                             'MKT RECRUITMENT COST',
                                             'STG RECRUITMENT COST',
                                             'IT  RECRUITMENT COST',
                                             'HR RECRUITMENT COST',
                                             'FIN RECRUITMENT COST',
                                             'OPS RECRUITMENT COST');
            
            
            $hrTotalAllocatvsAccept = $this->Dashboard_model->hrTotalAllocatvsAccept($teamId);
            $hrAttritionPer = $this->Dashboard_model->hrAttritionPercent($teamId);
            $hrDesignWiseRecruit = $this->Dashboard_model->hrDesignWiseRecruit($teamId,$gameId);
            $hrDesignDeptWiseRecruit = $this->Dashboard_model->hrDesignDeptWiseRecruit($teamId,$gameId);
            $hrEmpGrowth = $this->Dashboard_model->hrEmpGrowthPer($teamId);
            $hrTrainingCost = $this->Dashboard_model->BudgetDetails($teamId,$gameId,$hrTrainingCostFilter);
            $hrWelfareCost = $this->Dashboard_model->BudgetDetails($teamId,$gameId,$hrWelfareCostFilter);
            $hrAcquisitionCost = $this->Dashboard_model->BudgetDetails($teamId,$gameId,$hrAcquisitionCostFilter);
            $empPromotion = $this->Dashboard_model->empPromoted($teamId);
            $hrDecisionList = $this->Dashboard_model->hrDecisionList($teamId);
            $RevenueLoss = $this -> rest -> get('getRevenueLossDueToEmpNotAvailable?teamId='.$teamId.'&gameId='.$gameId);
            $hrRevenueLoss = json_decode(json_encode($RevenueLoss), true);
            $RecruitPlanvsAct = $this -> rest -> get('getrecruitPlanVsActualCount?teamId='.$teamId.'&gameId='.$gameId);
            $hrRecruitPvsA = json_decode(json_encode($RecruitPlanvsAct), true);
            //$mylearning = $this->Dashboard_model->mylearninglist($teamId);
            
            $RevenueLossChartData=array();
            $RecruitPvsAChartData=array();
            $EntryRecruitData=array();
            $ManagerRecruitData=array();
            $SrRecruitData=array();
            $GrRecruitData=array();
            $key = 0;
            
            $entry = array_values(array_filter($hrDesignDeptWiseRecruit, function ($var)  {
            return( ($var['DesignationName'] == 'ENTRY LEVEL'));
             }));
             
            foreach ($entry as $row) 
            {
                $key = $row['DepartmentName'];
                if (!array_key_exists($key, $EntryRecruitData)) {
                    $EntryRecruitData[$key] = array(
                        'DEPT' => $row['DepartmentName'],
                        'ACCEPTED' => $row['NO_OF_PEOPLE_ACCEPTED']
                    );
                } else 
                {
                    $EntryRecruitData[$key]['ACCEPTED'] = $EntryRecruitData[$key]['ACCEPTED'] + $row['NO_OF_PEOPLE_ACCEPTED'];
                }
            }
            $manager = array_values(array_filter($hrDesignDeptWiseRecruit, function ($var)  {
            return( ($var['DesignationName'] == 'MANAGER'));
             }));
             
            foreach ($manager as $row) 
            {
                $key = $row['DepartmentName'];
                if (!array_key_exists($key, $ManagerRecruitData)) {
                    $ManagerRecruitData[$key] = array(
                        'DEPT' => $row['DepartmentName'],
                        'ACCEPTED' => $row['NO_OF_PEOPLE_ACCEPTED']
                    );
                } else 
                {
                    $ManagerRecruitData[$key]['ACCEPTED'] = $ManagerRecruitData[$key]['ACCEPTED'] + $row['NO_OF_PEOPLE_ACCEPTED'];
                }
            }
            $srmanager = array_values(array_filter($hrDesignDeptWiseRecruit, function ($var)  {
            return( ($var['DesignationName'] == 'SENIOR MANAGER'));
             }));
             
            foreach ($srmanager as $row) 
            {
                $key = $row['DepartmentName'];
                if (!array_key_exists($key, $SrRecruitData)) {
                    $SrRecruitData[$key] = array(
                        'DEPT' => $row['DepartmentName'],
                        'ACCEPTED' => $row['NO_OF_PEOPLE_ACCEPTED']
                    );
                } else 
                {
                    $SrRecruitData[$key]['ACCEPTED'] = $SrRecruitData[$key]['ACCEPTED'] + $row['NO_OF_PEOPLE_ACCEPTED'];
                }
            }
            $grmanager = array_values(array_filter($hrDesignDeptWiseRecruit, function ($var)  {
            return( ($var['DesignationName'] == 'GENERAL MANAGER'));
             }));
             
            foreach ($grmanager as $row) 
            {
                $key = $row['DepartmentName'];
                if (!array_key_exists($key, $GrRecruitData)) {
                    $GrRecruitData[$key] = array(
                        'DEPT' => $row['DepartmentName'],
                        'ACCEPTED' => $row['NO_OF_PEOPLE_ACCEPTED']
                    );
                } else 
                {
                    $GrRecruitData[$key]['ACCEPTED'] = $GrRecruitData[$key]['ACCEPTED'] + $row['NO_OF_PEOPLE_ACCEPTED'];
                }
            }
            foreach ($hrRevenueLoss as $row) 
            {
    
                $key = 'Y'.$row['YEAR'].'Q'.$row['QUARTER'];
                if (!array_key_exists($key, $RevenueLossChartData)) {
                    $RevenueLossChartData[$key] = array(
                        'Year' => $row['YEAR'],
                        'Qtr' => $row['QUARTER'],
                        'Revenue' => $row['REVENUE_LOSS'],
                    );
                } else 
                {
                    $RevenueLossChartData[$key]['Revenue'] = $RevenueLossChartData[$key]['Revenue'] + $row['REVENUE_LOSS'];
                }
            }
            foreach ($hrRecruitPvsA as $row) 
            {
    
                $key = 'Y'.$row['YEAR'];
                if (!array_key_exists($key, $RecruitPvsAChartData)) {
                    $RecruitPvsAChartData[$key] = array(
                        'Year' => $row['YEAR'],
                        'Planned' => $row['PLANNED_COUNT'],
                        'Recruited' => $row['RECRUITED_COUNT'],
                    );
                } else 
                {
                    $RecruitPvsAChartData[$key]['Planned'] = $RecruitPvsAChartData[$key]['Planned'] + $row['PLANNED_COUNT'];
                    $RecruitPvsAChartData[$key]['Recruited'] = $RecruitPvsAChartData[$key]['Recruited'] + $row['RECRUITED_COUNT'];
                }
            }
            
          
            $new = array("hrTotalIntended"=>$hrTotalAllocatvsAccept[0]['NO_OF_EMPLOYEES_NEEDED'],
                         "hrTotalAccepted"=>$hrTotalAllocatvsAccept[0]['NO_OF_PEOPLE_ACCEPTED'],
                         "hrRecruitEfficiency"=>$hrTotalAllocatvsAccept[0]['RECRUITMENT_EFFICIENCY_PERCENT'],
                         "hrAttritionPercent"=>$hrAttritionPer[0]['ATTRITION_PERCENT'],
                         "hrReveneueLoss"=>$RevenueLossChartData,
                         "RecruitPA"=>$RecruitPvsAChartData,
                         "hrDecisionList"=>$hrDecisionList,
                         "hrEntryAllocat"=>$hrDesignWiseRecruit[0]['NO_OF_EMPLOYEES_NEEDED'],
                         "hrMangerAllocat"=>$hrDesignWiseRecruit[1]['NO_OF_EMPLOYEES_NEEDED'],
                         "hrSrManAllocat"=>$hrDesignWiseRecruit[2]['NO_OF_EMPLOYEES_NEEDED'],
                         "hrGrManAllocat"=>$hrDesignWiseRecruit[3]['NO_OF_EMPLOYEES_NEEDED'],
                         "hrEntryAccept"=>$hrDesignWiseRecruit[0]['NO_OF_PEOPLE_ACCEPTED'],
                         "hrMangerAccept"=>$hrDesignWiseRecruit[1]['NO_OF_PEOPLE_ACCEPTED'],
                         "hrSrManAccept"=>$hrDesignWiseRecruit[2]['NO_OF_PEOPLE_ACCEPTED'],
                         "hrGrManAccept"=>$hrDesignWiseRecruit[3]['NO_OF_PEOPLE_ACCEPTED'],
                         "entryLevel"=>$EntryRecruitData,
                         "manager"=>$ManagerRecruitData,
                         "srmanager"=>$SrRecruitData,
                         "grmanager"=>$GrRecruitData,
                         "hrEmpGrowthPer"=>$hrEmpGrowth[0]['GROWTH_PERCENT'],
                         "hrTrainingCost"=>$this->convertToSmallNum($hrTrainingCost[0]['AMOUNT'],$convertionType),
                         "hrWelfareCost"=>$this->convertToSmallNum($hrWelfareCost[0]['AMOUNT'],$convertionType),
                         "hrAcquisitionCost"=>$this->convertToSmallNum($hrAcquisitionCost[0]['AMOUNT'],$convertionType),
                         "empPromoted"=>$empPromotion[0]['NO_OF_EMP_PROMOTED'],
                         "Dept"=> $dept,
                         "qtrstatus"=>$qtrStatus,
                         "teamId"=>$teamId,
                         "gameId"=>$gameId
                        );
        
            $data['chartdata'] = json_encode($new);
            
            $data['_view'] = 'dept_dashboard/hr_view';
            $this -> load -> view('layouts/main_view', $data);  
        }
        else if($dept=="IT")
        {
            $qtrStatus=$this -> Game_model -> getQtrStatus($gameId);
            
            $this -> load -> model('Dashboard_model');
            $itCostFilter = array('IT FIXED COST',
                                   'IT SOFTWARE COST',
                                   'IT HARDWARE COST',
                                   'IT PROGRAM IMPLEMENTATION COST',
                                   'IT CHANGE MANAGEMENT COST',
                                   'IT TRAINING COST');
                                   
            $itCostDtls = $this->Dashboard_model->itCostBreakup($teamId,$itCostFilter);
            $itProgramImplementLst = $this->Dashboard_model->itProgramImplementList($teamId);
            //$mylearning = $this->Dashboard_model->mylearninglist($teamId);
            
            $new = array("itFixedCost"=>$this->convertToSmallNum($itCostDtls[0]['IT_FIXED_COST'],$convertionType),
                         "itSoftwareCost"=>$this->convertToSmallNum($itCostDtls[0]['IT_SOFTWARE_COST'],$convertionType),
                         "itHardwareCost"=>$this->convertToSmallNum($itCostDtls[0]['IT_HARDWARE_COST'],$convertionType),
                         "itImplementationCost"=>$this->convertToSmallNum($itCostDtls[0]['IT_IMPLEMENTATION_COST'],$convertionType),
                         "itProgImplementLst"=>$itProgramImplementLst,
                         "Dept"=> $dept,
                         "qtrstatus"=>$qtrStatus,
                         "teamId"=>$teamId,
                         "gameId"=>$gameId
                        );
                        
            $data['chartdata'] = json_encode($new);
            
            $data['_view'] = 'dept_dashboard/it_view';
            $this -> load -> view('layouts/main_view', $data);  
        }
        else if($dept=="FIN")
        {
            $this -> load -> library('rest', array('server' => straupAPIBaseURL , 
                                                'http_user' => 'admin', 
                                                'http_pass' => '1234', 
                                                'http_auth' => 'digest' // or 'digest'
                                                )
                                );
            $qtrStatus=$this -> Game_model -> getQtrStatus($gameId);
            
            $this -> load -> model('Dashboard_model');
            $RevFilter = array('SALES REVENUE',
                               'JV REVENUE',
                               'EXPORT REVENUE');
            $SalesReturnFilter = array('SALES RETURN');
            $RawMaterialFilter = array('OPENING RAW MATERIAL',
                                       'OPS RAWMATERIAL PURCHASE COST');
            $ClosingRawMaterialFilter = array('CLOSING RAW MATERIAL');
            $OpsSalaryFilter = array('OPS RECRUITMENT COST');
            $ProductionCostFilter = array('MACHINARY MAINTENANCE COST',
                                          'OVER HEAD COST',
                                          'PLANT MAINTENANCE',
                                          'IT_HARDWARE_DEPRECIATION',
                                          'PLANT_DEPRECIATION',
                                          'MACHINE_DEPRECIATION',
                                          'WAREHOUSE_DEPRECIATION');
            $hrcostFilter = array('MKT RECRUITMENT COST',
                                  'STG RECRUITMENT COST',
                                  'IT  RECRUITMENT COST',
                                  'HR RECRUITMENT COST',
                                  'FIN RECRUITMENT COST',
                                  'HR TRAINING COST',
                                  'WELLFARE PROGRAM COST',
                                  'STRATEGIC PROGRAM COST',
                                  'ACQUISITION COST');
            $itCostFilter = array('IT SOFTWARE COST',
                                  'IT HARDWARE COST',
                                  'IT HARDWARE AMC COST',
                                  'IT PROGRAM IMPLEMENTATION COST',
                                  'IT CHANGE MANAGEMENT COST',
                                  'IT TRAINING COST',
                                  'IT SUPPORT COST',
                                  'IT FIXED COST');
            $mktCostFilter = array('TRANSPORTATION COST',
                                   'SALES FORCE INCENTIVE',
                                   'MARGIN COST',
                                   'DISTRIBUTION SETUP COST',
                                   'DISTRIBUTION TRAINING COST',
                                   'DISTRIBUTION SUPPORT COST',
                                   'AFTER SALES COST',
                                   'WARRENTY COST',
                                   'FEATURE CATEGORY COST',
                                   'ADVERTISEMENT COST');
            $stgCostFilter = array('JV TOTAL PER UNIT COST',
                                   'JV SETUP COST',
                                   'EXPORT TOTAL PER UNIT COST',
                                   'EXPORT SETUP COST');
            $opsCostFilter = array('WAREHOUSE COST - PRODUCT',
                                   'WAREHOUSE COST',
                                   'PACKAGE COST');
            $finCostFilter = array('INTEREST_PAYMENT',
                                   'OD_INTEREST_PAYMENT');
            $incomefrominvestCostFilter = array('FD_INTEREST',
                                                'SELL_SHARE_PROFIT',
                                                'SELL_MACHINE_REVENUE',
                                                'SELL_PLANT_REVENUE',
                                                'SELL_WAREHOUSE_REVENUE');
            $corporateTaxFilter = array('CORPORATE TAX COST');
            
            $BookValue = $this->Dashboard_model->bookValue($teamId);                       
            $totRevenueDtls = $this->Dashboard_model->BudgetDetails($teamId,$gameId,$RevFilter);
            $salesReturnDtls = $this->Dashboard_model->BudgetDetails($teamId,$gameId,$SalesReturnFilter);
            $RawMaterial = $this->Dashboard_model->BudgetDetails($teamId,$gameId,$RawMaterialFilter);
            $ClosingRawMaterial = $this->Dashboard_model->BudgetDetails($teamId,$gameId,$ClosingRawMaterialFilter);
            $opsSalary = $this->Dashboard_model->BudgetDetails($teamId,$gameId,$OpsSalaryFilter);
            $ProductionCost = $this->Dashboard_model->BudgetDetails($teamId,$gameId,$ProductionCostFilter);
            $hrCost = $this->Dashboard_model->BudgetDetails($teamId,$gameId,$hrcostFilter);
            $itCost = $this->Dashboard_model->BudgetDetails($teamId,$gameId,$itCostFilter);
            $mktCost = $this->Dashboard_model->BudgetDetails($teamId,$gameId,$mktCostFilter);
            $stgCost = $this->Dashboard_model->BudgetDetails($teamId,$gameId,$stgCostFilter);
            $opsCost = $this->Dashboard_model->BudgetDetails($teamId,$gameId,$opsCostFilter);
            $finCost = $this->Dashboard_model->BudgetDetails($teamId,$gameId,$finCostFilter);
            $AddnonOperatingCost = $this->Dashboard_model->BudgetDetails($teamId,$gameId,$incomefrominvestCostFilter);
            $corporateTax = $this->Dashboard_model->BudgetDetails($teamId,$gameId,$corporateTaxFilter);
            $moveNo = $this->Dashboard_model->CurrentMove($teamId);
            $revBreakup = $this->revenueBreakup($teamId,$gameId,$RevFilter);
            $hrCostBreakup = $this->hrCostBreakup($teamId,$gameId,$hrcostFilter);
            $itCostBreakup = $this->itCostBreakup($teamId,$gameId,$itCostFilter);
            $mktCostBreakup = $this->mktCostBreakup($teamId,$gameId,$mktCostFilter);
            $stgCostBreakup = $this->stgCostBreakup($teamId,$gameId,$stgCostFilter);
            $opsCostBreakup = $this->opsCostBreakup($teamId,$gameId,$opsCostFilter);
            $finCostBreakup = $this->finCostBreakup($teamId,$gameId,$finCostFilter);
            $otherIncomeBreakup = $this->otherIncomeBreakup($teamId,$gameId,$incomefrominvestCostFilter);
            
            $DebEqu = array();
            $j=0;
            for($i=1;$i<=5;$i++)
            {
                $DebtvsEquity = $this -> rest -> get('FinReportController/getDebtvsEquity?teamId='.$teamId.'&gameId='.$gameId.'&year='.$i);
               
                $DebtEquit = (json_decode(json_encode($DebtvsEquity), true));
                array_push($DebEqu,$DebtEquit);//to add elements to exisiting array
            }
           $DebtEquity = array_reduce($DebEqu, 'array_merge', array());//to remove outer array
           
            $winning = $this -> rest -> get('DiagnosticReportController/wininigCriteriaYearWise?teamId='.$teamId);
            $winCriteria = json_decode(json_encode($winning), true);
            
            $approve = $this -> rest -> get('DiagnosticReportController/getfinAvailableAndApprovedAmount?teamId='.$teamId.'&gameId='.$gameId);
            $approvalTrend = json_decode(json_encode($approve), true);

            $result = array();
            $j=0;
            for($i=1;$i<=5;$i++)
            {
                $book = $this -> rest -> get('DiagnosticReportController/getNewBookValue?teamId='.$teamId.'&gameId='.$gameId.'&year='.$i);
               
                $data = (json_decode(json_encode($book), true));
                array_push($result,$data);//to add elements to exisiting array
            }
           
           $bookval = array_reduce($result, 'array_merge', array());//to remove outer array
            $BookValueChartData=array();
            $key = 0;
            
            $pat = array_values(array_filter($winCriteria, function ($var)  {
            return( ($var['WINING_CRITERIA_DESC'] == 'PAT'));
              }));
            
            // $totRevenueDtls = array_values(array_filter($winCriteria, function ($var)  {
            // return( ($var['WINING_CRITERIA_DESC'] == 'REVENUE GROWTH'));
              // }));
              
            $Debt = array_values(array_filter($DebtEquity, function ($var)  {
            return( ($var['HEAD'] == 'Debt'));
              }));
            
              $Equity = array_values(array_filter($DebtEquity, function ($var)  {
            return( ($var['HEAD'] == 'Equity'));
              }));
              
              $Approved = array_values(array_filter($approvalTrend, function ($var)  {
            return( ($var['HEAD'] == 'BUDGET_APPROVED'));
              }));
              $Available = array_values(array_filter($approvalTrend, function ($var)  {
            return( ($var['HEAD'] == 'BUDGET_AVAILABLE'));
              }));
              $Investment = array_values(array_filter($approvalTrend, function ($var)  {
            return( ($var['HEAD'] == 'INVESTED_AMOUNT'));
              }));
              
            //$totRevenueDtls=($totRevenueDtls[(sizeof($totRevenueDtls))-1]['Actual_Value']);
            $netsalesRevenue = $totRevenueDtls[0]['AMOUNT'] - $salesReturnDtls[0]['AMOUNT'];
            $rawMaterialInventory = $RawMaterial[0]['AMOUNT'] - $ClosingRawMaterial[0]['AMOUNT'];
            $costofGoodsSold = $rawMaterialInventory + $opsSalary[0]['AMOUNT'] + $ProductionCost[0]['AMOUNT'];
            $grossProfit = $netsalesRevenue - $costofGoodsSold;
            $sellingDistributionAndAdminCost = $hrCost[0]['AMOUNT'] + $itCost[0]['AMOUNT'] + $mktCost[0]['AMOUNT']+
                                                $stgCost[0]['AMOUNT'] + $opsCost[0]['AMOUNT'] + $finCost[0]['AMOUNT'];
            $NetProfitBeforeTax = $grossProfit - $sellingDistributionAndAdminCost + $AddnonOperatingCost[0]['AMOUNT'];
            
            $NetProfitAfterTax = $NetProfitBeforeTax - $corporateTax[0]['AMOUNT'];
            
            $expenseDtls = $this->expenseStatement($teamId,$departmentId);
            $cogsBreakUp = array($rawMaterialInventory,
                                 $opsSalary[0]['AMOUNT'],
                                 $ProductionCost[0]['AMOUNT']);
            $revenueBreakup = array();
            
            $new = array("pat"=>$pat,
                         "Debt"=>$Debt,
                         "Equity"=>$Equity,
                         "Approved"=>$Approved,
                         "Available"=>$Available,
                         "Investment"=>$Investment,
                         "BookValueChart"=>$bookval,
                         "totRevenue"=>$this->convertToSmallNum($totRevenueDtls[0]['AMOUNT'],$convertionType),
                         "grossProf"=>$this->convertToSmallNum($grossProfit,$convertionType),
                         "netProf"=>$this->convertToSmallNum($NetProfitAfterTax,$convertionType),
                         "BookValue"=>$BookValue[0]['BOOK_VALUE'],
                         "totalRevenue"=>$totRevenueDtls[0]['AMOUNT'],
                         "revbreakup"=>$revBreakup,
                         "grossProfit"=>$grossProfit,
                         "CostofGoodsSold"=>$costofGoodsSold,
                         "cogsBreakUp"=>$cogsBreakUp,
                         "SellingAdminCost"=>$sellingDistributionAndAdminCost,
                         "hrCost"=>$hrCost[0]['AMOUNT'],
                         "hrCostbreakup"=>$hrCostBreakup,
                         "itCost"=>$itCost[0]['AMOUNT'],
                         "itCostbreakup"=>$itCostBreakup,
                         "mktCost"=>$mktCost[0]['AMOUNT'],
                         "mktCostbreakup"=>$mktCostBreakup,
                         "stgCost"=>$stgCost[0]['AMOUNT'],
                         "stgCostbreakup"=>$stgCostBreakup,
                         "opsCost"=>$opsCost[0]['AMOUNT'],
                         "opsCostbreakup"=>$opsCostBreakup,
                         "finCost"=>$finCost[0]['AMOUNT'],
                         "finCostbreakup"=>$finCostBreakup,
                         "otherIncome"=>$AddnonOperatingCost[0]['AMOUNT'],
                         "otherIncomeBreakup"=>$otherIncomeBreakup,
                         "NetProfitBeforeTax"=>$NetProfitBeforeTax,
                         "corporateTax"=>$corporateTax[0]['AMOUNT'],
                         "NetProfit"=>$NetProfitAfterTax,
                         "Dept"=> $dept,
                         "qtrstatus"=>$qtrStatus,
                         "teamId"=>$teamId,
                         "gameId"=>$gameId,
                         "moveNo"=>$moveNo[0]['MoveNo'],
                         "expenseDtls"=>$expenseDtls
                        );
                        
            $data['chartdata'] = json_encode($new);
            
            $data['_view'] = 'dept_dashboard/fin_view';
            $this -> load -> view('layouts/main_view', $data);  
        }
    }
    function mktproductallocaiton($mktMainId)
    {
        $this -> load -> model('Dashboard_model');
        $mktMainTblDtls =  $this->Dashboard_model->mktMainTblForMainId($mktMainId);
        $mktProductAllocList = $this->Dashboard_model->mktProductAllocation($mktMainId);
        $mktAdvtDtls = $this->Dashboard_model->mktAdvt($mktMainId); 
        $mktDistDtls = $this->Dashboard_model->mktDist($mktMainId);
        $mktResourceDtls = $this->Dashboard_model->mktResource($mktMainId);
        $tableData = array("maintbl"=>$mktMainTblDtls,
                            "product"=>$mktProductAllocList,
                            "advt"=>$mktAdvtDtls,
                            "dist"=>$mktDistDtls,
                            "resource"=>$mktResourceDtls);
        echo json_encode($tableData);
    }
    function stgproductallocaiton($stgMainId)
    {
        $this -> load -> model('Dashboard_model');
        $stgMainTblDtls =  $this->Dashboard_model->stgProductAllocation($stgMainId);
        $stgClturalQues =  $this->Dashboard_model->stgCulturalQues($stgMainId);
        $tableData = array("maintbl"=>$stgMainTblDtls,
                           "cultural"=>$stgClturalQues);
        echo json_encode($tableData);
    }
    function hrSubmission($moveNo,$teamId)
    {
        $this -> load -> model('Dashboard_model');
        $hrRecruitmentDtls =  $this->Dashboard_model->hrRecruitmentDtl($moveNo, $teamId);
        $hrTrainingDtls =  $this->Dashboard_model->hrTrainingDtl($moveNo, $teamId);
        $hrTrainingParaDtls =  $this->Dashboard_model->hrTrainingParameterDtl($moveNo, $teamId);
        $hrWelfareDtls =  $this->Dashboard_model->hrWelfareDtl($moveNo, $teamId);
        $hrRetrenchmentDtls =  $this->Dashboard_model->hrRetrenchmentDtl($moveNo, $teamId);
        $hrPromotionDtls =  $this->Dashboard_model->hrPromotionDtl($moveNo, $teamId);
        $tableData = array("recruit"=>$hrRecruitmentDtls,
                           "training"=>$hrTrainingDtls,
                           "trainingPara"=>$hrTrainingParaDtls,
                           "welfare"=>$hrWelfareDtls,
                           "retrench"=>$hrRetrenchmentDtls,
                           "promotion"=>$hrPromotionDtls);
        echo json_encode($tableData);
    }
    function itSubmission($itMainId)
    {
        $this -> load -> model('Dashboard_model');
        $itProgramDtls =  $this->Dashboard_model->itProgramDtl($itMainId);
        $itHardwareDtls =  $this->Dashboard_model->itHardwareDtl($itMainId);
        $itTrainingDtls =  $this->Dashboard_model->itTrainingDtl($itMainId);
        $itParameterDtls =  $this->Dashboard_model->itParameterDtl($itMainId);
        $itEDIDtls =  $this->Dashboard_model->itEDIParameterDtl($itMainId);
        $tableData = array("program"=>$itProgramDtls,
                           "hardware"=>$itHardwareDtls,
                           "training"=>$itTrainingDtls,
                           "parameter"=>$itParameterDtls,
                           "edi"=>$itEDIDtls);
        echo json_encode($tableData);
    }
    function opsSubmission($moveNo,$teamId)
    {
        $this -> load -> model('Dashboard_model');
        $opsProductionDtls =  $this->Dashboard_model->opsProductionDtl($moveNo,$teamId);
        $opsRejectionDtls =  $this->Dashboard_model->opsRejectionDtl($moveNo,$teamId);
        $opsProductPlantDtls =  $this->Dashboard_model->opsProductPlantDtl($moveNo,$teamId);
        $opsProdResourceDtls =  $this->Dashboard_model->opsProdResourceDtl($moveNo,$teamId);
        $opsPlantPurchaseDtls =  $this->Dashboard_model->opsPlantPurchaseDtl($moveNo,$teamId);
        $opsMachinePurchaseDtls =  $this->Dashboard_model->opsMachinePurchaseDtl($moveNo,$teamId);
        $opsWarehousePurchaseDtls =  $this->Dashboard_model->opsWarehousePurchaseDtl($moveNo,$teamId);
        $tableData = array("production"=>$opsProductionDtls,
                           "rejection"=>$opsRejectionDtls,
                           "plantmachine"=>$opsProductPlantDtls,
                           "resource"=>$opsProdResourceDtls,
                           "plant"=>$opsPlantPurchaseDtls,
                           "machine"=>$opsMachinePurchaseDtls,
                           "warehouse"=>$opsWarehousePurchaseDtls);
        echo json_encode($tableData);
    }


    function add($dept,$teamId,$gameId)
    {
        $userId = $this->session->userdata('uid') ;
        $year = $this->getYear($this->input->post('move'));
        $quarter = $this->getQuarter($this->input->post('move'), $year);
      
        if(isset($_POST) && count($_POST) > 0)     
        {   
            $params = array(
                'YEAR' => $year,
                'QUARTER' => "Q".$quarter,
                'GAME_ID' => $gameId,
                'TEAM_ID' => $teamId,
                'MY_LEARNING' => $this->input->post('MY_LEARNING'),
                'USER_ID' => $userId,
            );
            
            $mylearning_id = $this->Mylearning_model->add_mylearning($params);
           redirect("Dashboard/dhistory/".$dept."/".$teamId."/".$gameId);
        }
    }
    function replyMail($teamId,$gameId)
    {
        $this -> load -> model('user_model');
        $details = $this->user_model->get_user_by_id($this->session->userdata('uid'));
        $data['uname'] = $details[0]->USER_NAME ; 
        $year = $this->getYear($this->input->post('move'));
        $quarter = $this->getQuarter($this->input->post('move'), $year);
       
        if(isset($_POST) && count($_POST) > 0)     
        {   
            $params = array(
                'YEAR' => $year,
                'QUARTER' => "Q".$quarter,
                'GAME_ID' => $gameId,
                'TEAM_ID' => $teamId,
                'USERNAME' => $data['uname'],
                'MY_LEARNING' => $this->input->post('MY_LEARNING'),
            );
            
            $mylearning_id = $this->Mylearning_model->add_mylearning($params);
           redirect("home");
        }
    }
    function expenseStatement($teamId,$departmentId)
    {
        $this -> load -> model('Dashboard_model');
        $expenseDtls = $this->Dashboard_model->expenseStatement($teamId,$departmentId);
        $i=0;
        $data=array();
        foreach ($expenseDtls as $row)
        {
            if($i==0)
            {
                $data[$i]['Desc']=ucwords($row['TRANSACTION_FOR']);
                $temp[$i]['Amount'] = $row['Amount'];
                $data[$i]['Amount'] = $row['Amount']-0;
                $data[$i]['Income'] = number_format($data[$i]['Amount'],2);
                $data[$i]['Expense'] = '';
                $data[$i]['Balance']= number_format($row['Amount'],2);
              
            }
            else 
            {
                $data[$i]['Year_Qtr']='Y'.$row['Year'].'Q'.$row['Qtr'];
                $data[$i]['Desc']=ucwords(strtolower($row['TRANSACTION_FOR'])); 
                $temp[$i]['Amount'] = $row['Amount'];
                $data[$i]['Amount'] = $row['Amount']-$temp[$i-1]['Amount'];
                if($data[$i]['Amount']<0)
                {
                    $data[$i]['Expense'] = number_format($data[$i]['Amount'] * -1,2);
                    $data[$i]['Income'] = '';
                }
                else 
                {
                    $data[$i]['Income'] = number_format($data[$i]['Amount'],2);
                    $data[$i]['Expense'] = '';
                }
                $data[$i]['Balance']= number_format($row['Amount'],2);;
                
            }
            $i++;

        }
        return $data;
        
    }
    function edichart($teamId,$universeToken)
    {
        
        $qtrStatus=$this -> Game_model -> getQtrStatus($teamId);
        
        $this -> load -> library('rest', array('server' => straupAPIBaseURL . 'DiagnosticReportController/', 
                                                'http_user' => 'admin', 
                                                'http_pass' => '1234', 
                                                'http_auth' => 'digest' // or 'digest'
                                                )
                                );
        $chartdata = $this -> rest -> get('wininigCriteriaYearWise?teamId='.$teamId, 'json');
        $array = json_decode(json_encode($chartdata), true);
        
        $leaderBoardDtls = $this -> rest -> get('getUniverseWiseLeaderBoard?universeToken='.$universeToken);
        $lb = json_decode(json_encode($leaderBoardDtls), true);
         
        // Filter dynamically using filter variable
        $filterBy = 'EDI'; // or Finance etc.
        $edi = array_values(array_filter($array, function ($var) use ($filterBy) {
            return( ($var['WINING_CRITERIA_DESC'] == $filterBy));
        }));
        
        // Filter static*/
        // array_values used to reindex 
        $pat = array_values(array_filter($array, function ($var)  {
            return( ($var['WINING_CRITERIA_DESC'] == 'PAT'));
        }));
        
        // Filter Array for Share Price*/
        // array_values used to reindex 
        $sharePrice = array_values(array_filter($array, function ($var)  {
            return( ($var['WINING_CRITERIA_DESC'] == 'SHARE PRICE'));
        }));
        
        // Filter Array for Revenue Growth*/
        // array_values used to reindex 
        $revGrowth = array_values(array_filter($array, function ($var)  {
            return( ($var['WINING_CRITERIA_DESC'] == 'REVENUE GROWTH'));
        }));
        
        $new = array("edi"=>$edi,
                        "pat"=>$pat,
                        "rev"=>$revGrowth,
                        "price"=>$sharePrice,
                        "lb"=>$lb,
                        "utoken"=>$universeToken,
                        "qtrstatus"=>$qtrStatus);
        // echo json_encode($new);
        
        $data['chartdata'] = json_encode($new);
        $data['_view'] = 'chartjs_view';
        $this -> load -> view('layouts/main', $data);
    }
    function leaderboard($universeToken)
    {
        $this->load ->model('Game_model');
        $chartdata = $this->leaderboardApi($universeToken);
        $lb = json_decode(json_encode($chartdata), true);
        // echo $this->rest->debug();
       
        // $data['_view'] = 'leaderboard_view';
        $lb['data'] = $lb;
        $lb['universetoken'] = $universeToken;
        // $this -> load -> view('layouts/main_view', $data);
        $data = $this -> load -> view('leaderboard_view', $lb, TRUE);
        echo json_encode($data);
        
    }
    function profileReport($deptName,$gameId,$teamId,$universeToken)
    {
        $deptName = strtoupper($deptName);
        
        $this -> load -> model('Gamemasters_model');
        $gameBatchInfo=$this->Gamemasters_model -> getGameStartInfo($universeToken);
        $userInfo=$this->Gamemasters_model -> getUserInfoforDeptandTeam($teamId,$deptName);
        $qtrStatus=$this -> Game_model -> getQtrStatus($teamId);
        $teamDtls = $this -> Gamemasters_model -> getTeamDtlsForTeamId($teamId);
        $revenuePat = $this -> Gamemasters_model -> getRevenuePatforZeroYear();
         
        $winningData = $this->leaderboardApi($universeToken);
        
        if(count($winningData)>0)
        {
             $winningDataForTeam = array_filter($winningData, function ($item) use ($teamId) {
            return( ($item->TEAM_ID == $teamId));
            }); // Filter array by teamid
            
            $winningDataForTeam = array_values(array_filter($winningDataForTeam)); //  To reset the index
        }
        else
        {
            $revenue = array_values(array_filter($revenuePat, function ($var)  {
            return( ($var['TRANSACTION_FOR'] == 'SALES REVENUE - COST'));
              }));
              $pat = array_values(array_filter($revenuePat, function ($var)  {
            return( ($var['TRANSACTION_FOR'] == 'RETAINED EARNING'));
              }));
              
               $winningDataForTeam[0] = array("TEAM_LOGO_NAME" => $teamDtls[0]['TEAM_LOGO_NAME'],
                                           "CURRENT_RANK" => 0,
                                           "REVENUE" => $revenue[0]['AMOUNT'],
                                           "PAT" => $pat[0]['AMOUNT'],
                                           "SHARE_PRICE" => 100,
                                           "EDI" => 4800);
        }
        
        $playerInfo = array("gameBatchInfo"=>$gameBatchInfo,
                                "gamePlayStatus"=>$qtrStatus,
                                "winningData"=>json_decode(json_encode($winningDataForTeam),true),
                                "userInfo"=>$userInfo,
                                "department"=>$deptName);
        
        $index = 0;
        $maxYearIndv = $this->getMaxYear($universeToken,'INDV');
        $maxYearMyLeague = $this->getMaxYear($universeToken,'MYLEAGUE');
        $maxYearGlobal = $this->getMaxYear($universeToken,'GLOBAL');
        
        $roleCountMyLeague = $this -> Game_model ->getTeamCount($universeToken,'MYLEAGUE'); // total team count for given universe token 
        $roleCountGlobal = $this -> Game_model ->getTeamCount($universeToken,'GLOBAL'); // overall team count played (universe token ignored)
        
        // var_dump($roleCountMyLeague);

        
        /* ena Target YearQtr Wise ($maxYear,$roleCount,$teamIdOrUnivsereToken,$deptName,$profileType,$allRole) */
        $enaTgtIndv = $this->enaTgt($maxYearIndv,1,0,$deptName,'INDV','NO');
        $enaTgtMyLeague = $this->enaTgt($maxYearMyLeague,$roleCountMyLeague[0]['ROLE_COUNT'],0,$deptName,'INDV','NO');
        $enaTgtGlobal = $this->enaTgt($maxYearGlobal,$roleCountGlobal[0]['ROLE_COUNT'],0,$deptName,'INDV','NO');
        
        /* ENA target sum of all YearQtr */
        $enaSumTgtIndv = $this->enaSumTgt($enaTgtIndv);
        $enaSumTgtMyLeague = $this->enaSumTgt($enaTgtMyLeague);
        $enaSumTgtGlobal = $this->enaSumTgt($enaTgtGlobal);
        
        /* Fetch achieved ENA values from Database YearQtr Wise */
        $enaAchDtlsIndv = $this -> Game_model ->getEnaData($deptName,$teamId,'INDV');
        $enaAchDtlsMyLeague = $this -> Game_model ->getEnaData($deptName,$universeToken,'MYLEAGUE');
        $enaAchDtlsGlobal = $this -> Game_model ->getEnaData($deptName,$universeToken,'GLOBAL');
        
         
        /* ENA Achieved sum of all YearQtr */
        $enaSumAchIndv = $this->enaSumAch($enaAchDtlsIndv);
        $enaSumAchMyLeague = $this->enaSumAch($enaAchDtlsMyLeague);
        $enaSumAchGlobal = $this->enaSumAch($enaAchDtlsGlobal);
        
        /* ENA Achieved Percentage YearQtr wise */
        $enaAchPerDtlsIndv = $this->enaAchPerDtls($enaTgtIndv,$enaAchDtlsIndv);
        $enaAchPerDtlsMyLeague = $this->enaAchPerDtls($enaTgtMyLeague,$enaAchDtlsMyLeague);
        $enaAchPerDtlsGlobal = $this->enaAchPerDtls($enaTgtGlobal,$enaAchDtlsGlobal);
        
         /* ENA Achieved Percentage of all YearQtr */
        $enaSumAchPerIndv = $this->enaSumAchPer($enaSumAchIndv,$enaSumTgtIndv);
        $enaSumAchPerMyLeague = $this->enaSumAchPer($enaSumAchMyLeague,$enaSumTgtMyLeague);
        $enaSumAchPerGlobal = $this->enaSumAchPer($enaSumAchGlobal,$enaSumTgtGlobal);
        
        $allRoleDtls = $this->profileReportAllRole ($teamId,$universeToken,$roleCountMyLeague[0]['ROLE_COUNT'],$maxYearMyLeague);
        // var_dump($allRoleDtls['AllRoleAchPerDtlsMyLeague']);
        $chartdata = array("scoreIndv"=>$enaSumAchPerIndv,
                        "scoreMyLeague"=>$enaSumAchPerMyLeague,
                        "scoreGlobal"=>$enaSumAchPerGlobal,
                        "trendIndv"=>$enaAchPerDtlsIndv,
                        "trendMyLeague"=>$enaAchPerDtlsMyLeague,
                        "trendGlobal"=>$enaAchPerDtlsGlobal,
                        "tblData"=>$enaSumAchMyLeague,
                        "trendAllRoleTeam"=>$allRoleDtls['AllRoleAchPerDtlsTeam'],
                        "trendAllRoleMyLeague"=>$allRoleDtls['AllRoleAchPerDtlsMyLeague'],
                        "playerInfo"=>$playerInfo,
                        "dept"=>$deptName,
                        "teamId"=>$teamId,
                        "gameId"=>$gameId,
                        "universeToken"=>$universeToken
                        ); 

        $data['chartdata']=$chartdata;
        // $data['ena'] = $enaSumTgtGlobal;                     
        $data['_view'] = 'playerprofile_view';
        $this->load->view('layouts/main_view', $data);
        
        // var_dump($enaSumTgt);
         // var_dump($enaSumAch);
          // var_dump($enaSumPer);
          // var_dump($enaAchPerDtls);
    }
    function profileReportAllRole ($teamId,$universeToken,$teamCount,$maxYear)
    {        
        /* enaTgt($maxYear,$roleCount,$teamIdOrUnivsereToken,$deptName,$profileType,$allRole) */
        $enaAllRoleTgtTeam = $this->enaTgt($maxYear,1,0,'ALLROLE','TEAM','YES');
        $enaAllRoleTgtMyLeague = $this->enaTgt($maxYear,$teamCount,0,'ALLROLE','TEAM','YES');
        
        /* Fetch ALL ROLE achieved ENA values from Database YearQtr Wise */
        //                                                              ($teamIdOrUniverseToken,$profileType)
        $enaAllRoleAchDtlsTeam = $this -> Game_model ->getAllRoleEnaData($teamId,'TEAM');
        $enaAllRoleAchDtlsMyLeague = $this -> Game_model ->getAllRoleEnaData($universeToken,'MYLEAGUE');
        
        /* ENA Achieved Percentage YearQtr wise */
        $enaAllRoleAchPerDtlsTeam = $this->enaAchPerDtls($enaAllRoleTgtTeam,$enaAllRoleAchDtlsTeam);
        $enaAllRoleAchPerDtlsMyLeague = $this->enaAchPerDtls($enaAllRoleTgtMyLeague,$enaAllRoleAchDtlsMyLeague);
        
        /******************************** END All Role Team and MyLeauge data ***********************************/
        // var_dump($enaAllRoleTgtMyLeague);
        $allRoleDtls = array("AllRoleTgtTeam"=>$enaAllRoleTgtTeam,
                        "AllRoleTgtMyLeague"=>$enaAllRoleTgtMyLeague,
                        "AllRoleAchDtlsTeam"=>$enaAllRoleAchDtlsTeam,
                        "AllRoleAchDtlsMyLeague"=>$enaAllRoleAchDtlsMyLeague,
                        "AllRoleAchPerDtlsTeam"=>$enaAllRoleAchPerDtlsTeam,
                        "AllRoleAchPerDtlsMyLeague"=>$enaAllRoleAchPerDtlsMyLeague
                        ); 
        return $allRoleDtls;
    }
    function getMaxYear($gameId,$profileType)
    {
        $this -> load -> model('Dashboard_model');
        $maxYearDtls = $this -> Game_model ->getMaxGameYear($gameId,$profileType);
        $maxYear = $maxYearDtls[0]['GAME_YEAR'];
        return $maxYear;
    }
    function enaTgt($maxYear,$roleCount,$teamIdOrUnivsereToken,$deptName,$profileType,$allRole)
    {
        
        $enaTgt = array();
        $index = 0;
        if($allRole == 'NO')
        {
            $enaTgtdtls =  $this -> Game_model -> getEnaData($deptName,$teamIdOrUnivsereToken,$profileType);
        }
        else 
        {
            $enaTgtdtls = $this -> Game_model -> getAllRoleEnaData($teamIdOrUnivsereToken,$profileType);
            // var_dump($enaTgtdtls);
        }
               
        //* Intialize Target Values for Max No. of Year Played */
        for ($y=1; $y <= $maxYear; $y++) 
        {
            // for($q=1; $q<=4;$q++)
            // {
                $enaTgt[$index]['YEAR']= $y;
                // $enaTgt[$index]['QUARTER']= $q;
                $enaTgt[$index]['FI']= $enaTgtdtls['0']['FI']*$roleCount*4;
                $enaTgt[$index]['P']= $enaTgtdtls['0']['P']*$roleCount*4;
                $enaTgt[$index]['DM']= $enaTgtdtls['0']['DM']*$roleCount*4;
                $enaTgt[$index]['PB']= $enaTgtdtls['0']['PB']*$roleCount*4;
                $enaTgt[$index]['PS']= $enaTgtdtls['0']['PS']*$roleCount*4;
                // $enaTgt[$index]['SI']= $enaTgtdtls['0']['SI']*$roleCount*4;
                // $enaTgt[$index]['CT']= $enaTgtdtls['0']['CT']*$roleCount*4;
                $enaTgt[$index]['GO']= $enaTgtdtls['0']['GO']*$roleCount*4;
                $enaTgt[$index]['Total'] = $enaTgtdtls['0']['Total']*$roleCount*4;
                $index++;
            // } 
        }
        return $enaTgt;
    }
    function enaSumTgt($enaTgt)
    {
        /* Define enaSumTgt */
        $enaSumTgt[0]['FI']= 0;
        $enaSumTgt[0]['P']= 0;
        $enaSumTgt[0]['DM']= 0;
        $enaSumTgt[0]['PB']= 0;
        $enaSumTgt[0]['PS']= 0;
        // $enaSumTgt[0]['SI']= 0;
        // $enaSumTgt[0]['CT']= 0;
        $enaSumTgt[0]['GO']= 0;
        $enaSumTgt[0]['Total']= 0;
        
         /* Compute sum total for all year and qtr for Target */
        foreach($enaTgt as $row)
        {
            $enaSumTgt[0]['FI']+= $row['FI'];
            $enaSumTgt[0]['P']+= $row['P'];
            $enaSumTgt[0]['DM']+= $row['DM'];
            $enaSumTgt[0]['PB']+= $row['PB'];
            $enaSumTgt[0]['PS']+= $row['PS'];
            // $enaSumTgt[0]['SI']+= $row['SI'];
            // $enaSumTgt[0]['CT']+= $row['CT'];
            $enaSumTgt[0]['GO']+= $row['GO'];
            $enaSumTgt[0]['Total']+= $row['Total'];
            
        }
        return $enaSumTgt;
    }
    function enaSumAch($enaAchDtls)
    {
        /* Define enaSumAch */
        $enaSumAch[0]['YEAR']= '';
        // $enaSumAch[0]['QUARTER']= '';
        
        $enaSumAch[0]['FI']= 0;
        $enaSumAch[0]['P']= 0;
        $enaSumAch[0]['DM']= 0;
        $enaSumAch[0]['PB']= 0;
        $enaSumAch[0]['PS']= 0;
        // $enaSumAch[0]['SI']= 0;
        // $enaSumAch[0]['CT']= 0;
        $enaSumAch[0]['GO']= 0;
        $enaSumAch[0]['Total']= 0;
        
        /* Compute sum total for all year and qtr for Achived */
        foreach($enaAchDtls as $row)
        {
            $enaSumAch[0]['FI']+= $row['FI'];
            $enaSumAch[0]['P']+= $row['P'];
            $enaSumAch[0]['DM']+= $row['DM'];
            $enaSumAch[0]['PB']+= $row['PB'];
            $enaSumAch[0]['PS']+= $row['PS'];
            // $enaSumAch[0]['SI']+= $row['SI'];
            // $enaSumAch[0]['CT']+= $row['CT'];
            $enaSumAch[0]['GO']+= $row['GO'];
            $enaSumAch[0]['Total']+= $row['Total'];
        }
        return $enaSumAch;
    }
    function enaAchPerDtls($enaTgt,$enaAchDtls)
    {
        $index = 0;
        
        /* Compute Achived Percentage for each year and Qtr */
        foreach ($enaTgt as $row) 
        {
            $enaAchPerDtls[$index]['YEAR'] = $row['YEAR'];
            // $enaAchPerDtls[$index]['QUARTER'] = $row['QUARTER'];
            if(!isset($enaAchDtls[$index]['FI']))
            {
                 $enaAchDtls[$index]['FI']=0;
            }
            if(!isset($enaAchDtls[$index]['P']))
            {
                 $enaAchDtls[$index]['P']=0;
            }
            if(!isset($enaAchDtls[$index]['DM']))
            {
                 $enaAchDtls[$index]['DM']=0;
            }
            if(!isset($enaAchDtls[$index]['PB']))
            {
                 $enaAchDtls[$index]['PB']=0;
            }
            if(!isset($enaAchDtls[$index]['PS']))
            {
                 $enaAchDtls[$index]['PS']=0;
            }
            // if(!isset($enaAchDtls[$index]['SI']))
            // {
                 // $enaAchDtls[$index]['SI']=0;
            // }
            // if(!isset($enaAchDtls[$index]['CT']))
            // {
                 // $enaAchDtls[$index]['CT']=0;
            // }
            if(!isset($enaAchDtls[$index]['GO']))
            {
                 $enaAchDtls[$index]['GO']=0;
            }
            if(!isset($enaAchDtls[$index]['Total']))
            {
                 $enaAchDtls[$index]['Total']=0;
            }
            $enaAchPerDtls[$index]['FI']= round(($enaAchDtls[$index]['FI']/$row['FI']) * 100);
            $enaAchPerDtls[$index]['P']= round(($enaAchDtls[$index]['P']/$row['P'])*100);
            $enaAchPerDtls[$index]['DM']= round(($enaAchDtls[$index]['DM']/$row['DM'])*100) ;
            $enaAchPerDtls[$index]['PB']= round(($enaAchDtls[$index]['PB']/$row['PB'])*100) ;
            $enaAchPerDtls[$index]['PS']= round(($enaAchDtls[$index]['PS']/$row['PS'])*100) ;
            // $enaAchPerDtls[$index]['SI']= round(($enaAchDtls[$index]['SI']/$row['SI'])*100) ;
            // $enaAchPerDtls[$index]['CT']= round(($enaAchDtls[$index]['CT']/$row['CT'])*100) ;
            $enaAchPerDtls[$index]['GO']= round(($enaAchDtls[$index]['GO']/$row['GO'])*100) ;
            $enaAchPerDtls[$index]['Total']= round(($enaAchDtls[$index]['Total']/$row['Total'])*100) ;
            $index++;
        }
        return $enaAchPerDtls;
    }
    function enaSumAchPer($enaSumAch,$enaSumTgt)
    {
        /* Compute Achived Percent for Total Year */
        foreach($enaSumAch as $row)
        {
            $enaSumAchPer[0]['FI']= round(($row['FI']/$enaSumTgt[0]['FI'])*100) ; 
            $enaSumAchPer[0]['P']= round(($row['P']/ $enaSumTgt[0]['P'])*100) ;
            $enaSumAchPer[0]['DM']= round(($row['DM']/ $enaSumTgt[0]['DM'])*100) ;
            $enaSumAchPer[0]['PB']= round(($row['PB']/$enaSumTgt[0]['PB'])*100) ;
            $enaSumAchPer[0]['PS']= round(($row['PS']/$enaSumTgt[0]['PS'])*100) ;
            // $enaSumAchPer[0]['SI']= round(($row['SI']/$enaSumTgt[0]['SI'])*100) ;
            // $enaSumAchPer[0]['CT']= round(($row['CT']/$enaSumTgt[0]['CT'])*100) ;
            $enaSumAchPer[0]['GO']= round(($row['GO']/$enaSumTgt[0]['GO'])*100) ;
            // $enaSumAchPer[0]['Total']= round(($row['Total']/$enaSumTgt[0]['Total'])*100) ;
        }
        return $enaSumAchPer;
    }
    
    function leaderboardApi($universeToken)
    {
        $this -> load -> library('rest', array('server' => straupAPIBaseURL . 'DiagnosticReportController/', 
                                                'http_user' => 'admin', 
                                                'http_pass' => '1234', 
                                                'http_auth' => 'digest' // or 'digest'
                                                )
                                );
        $chartdata = $this -> rest -> get('getUniverseWiseLeaderBoard?universeToken='.$universeToken);
        return $chartdata;
    }
    function revenueBreakup($teamId,$gameId,$RevFilter)
    {
        //to get revenue breakup for fin dashboard
        
        $this -> load -> model('Dashboard_model');
        $revenueBreakup = $this->Dashboard_model->BudgetDetailsgroupbyBudgetHead($teamId,$gameId,$RevFilter);
        
            $salesrevenue=0;
            $jvrevenue=0;
            $exportrevenue=0;
            foreach($revenueBreakup as $rev)
            {
                if($rev['BUDGET_HEAD']=='SALES REVENUE')
                {
                    $salesrevenue+=$rev['AMOUNT'];
                    
                }
                else if($rev['BUDGET_HEAD']=='JV REVENUE')
                {
                    $jvrevenue+=$rev['AMOUNT'];
                   
                }
                else if($rev['BUDGET_HEAD']=='EXPORT REVENUE')
                {
                    $exportrevenue+=$rev['AMOUNT'];
                    
                }
            }
            $revbreakup = array($salesrevenue,
                               $jvrevenue,
                               $exportrevenue);
        return $revbreakup;
    }    
    function hrCostBreakup($teamId,$gameId,$hrcostFilter)
    {
        //to get hrcost breakup for fin dashboard
        
        $this -> load -> model('Dashboard_model');
        $hrTrainingCostFilter = array('HR TRAINING COST');
            $hrWelfareCostFilter = array('WELLFARE PROGRAM COST');
            $hrSalaryCostFilter = array('ACQUISITION COST',
                                             'MKT RECRUITMENT COST',
                                             'STG RECRUITMENT COST',
                                             'IT  RECRUITMENT COST',
                                             'HR RECRUITMENT COST',
                                             'FIN RECRUITMENT COST',
                                             'STRATEGIC PROGRAM COST');
        $hrCostBreakup = $this->Dashboard_model->BudgetDetailsgroupbyBudgetHead($teamId,$gameId,$hrcostFilter);
        
            $hrSalaryCost=0;
            $hrWelfareCost=0;
            $hrTrainingCost=0;
            foreach($hrCostBreakup as $hr)
            {
                foreach($hrSalaryCostFilter as $hrs)
                {
                    if($hr['BUDGET_HEAD']==$hrs)
                    {
                        $hrSalaryCost+=$hr['AMOUNT'];
                        break;
                    }
                }
                foreach($hrTrainingCostFilter as $hrt)
                {
                    if($hr['BUDGET_HEAD']==$hrt)
                    {
                        $hrTrainingCost+=$hr['AMOUNT'];
                        break;
                    }
                }
                foreach($hrWelfareCostFilter as $hrw)
                {
                    if($hr['BUDGET_HEAD']==$hrw)
                    {
                        $hrWelfareCost+=$hr['AMOUNT'];
                        break;
                    }
                }
            }
            $hrbreakup = array($hrSalaryCost,
                               $hrTrainingCost,
                               $hrWelfareCost);
        return $hrbreakup;
    }
    function itCostBreakup($teamId,$gameId,$itCostFilter)
    {
        //to get itcost breakup for fin dashboard
        
        $this -> load -> model('Dashboard_model');
        $itImplementCostFilter = array('IT SOFTWARE COST',
                                  'IT HARDWARE COST',
                                  'IT HARDWARE AMC COST',
                                  'IT PROGRAM IMPLEMENTATION COST',
                                  'IT CHANGE MANAGEMENT COST',
                                  'IT TRAINING COST',
                                  'IT SUPPORT COST');
        $itFixedCostFilter = array('IT FIXED COST');  
        $itCostBreakup = $this->Dashboard_model->BudgetDetailsgroupbyBudgetHead($teamId,$gameId,$itCostFilter);
        
            $itImplementCost=0;
            $itFixedCost=0;
            foreach($itCostBreakup as $it)
            {
                foreach($itImplementCostFilter as $itimplem)
                {
                    if($it['BUDGET_HEAD']==$itimplem)
                    {
                        $itImplementCost+=$it['AMOUNT'];
                        break;
                    }
                }
                foreach($itFixedCostFilter as $itfix)
                {
                    if($it['BUDGET_HEAD']==$itfix)
                    {
                        $itFixedCost+=$it['AMOUNT'];
                        break;
                    }
                }
            }
            $itbreakup = array($itImplementCost,
                               $itFixedCost);
        return $itbreakup;
    }  
    function mktCostBreakup($teamId,$gameId,$mktCostFilter)
    {
        //to get mktcost breakup for fin dashboard
        
        $this -> load -> model('Dashboard_model');
        $mktTransportCostFilter = array('TRANSPORTATION COST');
            $mktDistribCostFilter = array('SALES FORCE INCENTIVE',
                                   'MARGIN COST',
                                   'DISTRIBUTION SETUP COST',
                                   'DISTRIBUTION TRAINING COST',
                                   'DISTRIBUTION SUPPORT COST');
            $mktAdsCostFilter = array('ADVERTISEMENT COST');
            $mktSalesWarrnCostFilter = array('AFTER SALES COST',
                                   'WARRENTY COST');
            $mktFeatureCostFilter = array('FEATURE CATEGORY COST');
        $mktCostBreakup = $this->Dashboard_model->BudgetDetailsgroupbyBudgetHead($teamId,$gameId,$mktCostFilter);
        
            $mktAdsCost=0;
            $mktDistribCost=0;
            $mktTransportCost=0;
            $mktSalesCost=0;
            $mktFeatureCost=0;
            
            foreach($mktCostBreakup as $mkt)
            {
                foreach($mktTransportCostFilter as $mktTrans)
                {
                    if($mkt['BUDGET_HEAD']==$mktTrans)
                    {
                        $mktTransportCost+=$mkt['AMOUNT'];
                        break;
                    }
                }
                foreach($mktDistribCostFilter as $mktDis)
                {
                    if($mkt['BUDGET_HEAD']==$mktDis)
                    {
                        $mktDistribCost+=$mkt['AMOUNT'];
                        break;
                    }
                }
                foreach($mktAdsCostFilter as $mktAds)
                {
                    if($mkt['BUDGET_HEAD']==$mktAds)
                    {
                        $mktAdsCost+=$mkt['AMOUNT'];
                        break;
                    }
                }
                foreach($mktSalesWarrnCostFilter as $mktSales)
                {
                    if($mkt['BUDGET_HEAD']==$mktSales)
                    {
                        $mktSalesCost+=$mkt['AMOUNT'];
                        break;
                    }
                }
                foreach($mktFeatureCostFilter as $mktFea)
                {
                    if($mkt['BUDGET_HEAD']==$mktFea)
                    {
                        $mktFeatureCost+=$mkt['AMOUNT'];
                        break;
                    }
                }
            }
            $mktbreakup = array($mktTransportCost,
                               $mktDistribCost,
                               $mktAdsCost,
                               $mktFeatureCost,
                               $mktSalesCost);
        return $mktbreakup;
    }
    function stgCostBreakup($teamId,$gameId,$stgCostFilter)
    {
        //to get stgcost breakup for fin dashboard
        
        $this -> load -> model('Dashboard_model');
        $stgExpUnitFilter = array('JV TOTAL PER UNIT COST',
                                   'JV SETUP COST',
                                   'EXPORT TOTAL PER UNIT COST',
                                   'EXPORT SETUP COST');
        $stgCostBreakup = $this->Dashboard_model->BudgetDetailsgroupbyBudgetHead($teamId,$gameId,$stgCostFilter);
        
            $stgJVSetupCost=0;
            $stgExpSetupCost=0;
            $stgJVunitCost=0;
            $stgExpunitCost=0;
            
            foreach($stgCostBreakup as $stg)
            {
                if($stg['BUDGET_HEAD']=='JV TOTAL PER UNIT COST')
                {
                    $stgJVunitCost+=$stg['AMOUNT'];
                }
                if($stg['BUDGET_HEAD']=='JV SETUP COST')
                {
                    $stgJVSetupCost+=$stg['AMOUNT'];
                }
                if($stg['BUDGET_HEAD']=='EXPORT TOTAL PER UNIT COST')
                {
                    $stgExpunitCost+=$stg['AMOUNT'];
                }
                if($stg['BUDGET_HEAD']=='EXPORT SETUP COST')
                {
                    $stgExpSetupCost+=$stg['AMOUNT'];
                }    
            }
            $stgbreakup = array($stgJVunitCost,
                               $stgJVSetupCost,
                               $stgExpunitCost,
                               $stgExpSetupCost);
        return $stgbreakup;
    }
    function opsCostBreakup($teamId,$gameId,$opsCostFilter)
    {
        //to get opscost breakup for fin dashboard
        
        $this -> load -> model('Dashboard_model');
        $opsWarehouseFilter = array('WAREHOUSE COST - PRODUCT',
                                   'WAREHOUSE COST');
        $opsPackageFilter = array('PACKAGE COST');
        $opsCostBreakup = $this->Dashboard_model->BudgetDetailsgroupbyBudgetHead($teamId,$gameId,$opsCostFilter);
        
            $opsWarehouseCost=0;
            $opsPackageCost=0;
            
            foreach($opsCostBreakup as $ops)
            {
                foreach($opsWarehouseFilter as $opsWare)
                {
                    if($ops['BUDGET_HEAD']==$opsWare)
                    {
                        $opsWarehouseCost+=$ops['AMOUNT'];
                        break;
                    }
                }
                foreach($opsPackageFilter as $opsPack)
                {
                    if($ops['BUDGET_HEAD']==$opsPack)
                    {
                        $opsPackageCost+=$ops['AMOUNT'];
                        break;
                    }
                }
            }
            $opsbreakup = array($opsWarehouseCost,
                               $opsPackageCost);
        return $opsbreakup;
    }
    function finCostBreakup($teamId,$gameId,$finCostFilter)
    {
        //to get fincost breakup for fin dashboard
        
        $this -> load -> model('Dashboard_model');
        $finCostBreakup = $this->Dashboard_model->BudgetDetailsgroupbyBudgetHead($teamId,$gameId,$finCostFilter);
        
        $finInterestCost=0;
        $finODIneterestCost=0;
            
        foreach($finCostBreakup as $fin)
        {
            if($fin['BUDGET_HEAD']=='INTEREST PAYMENT')
            {
                $finInterestCost+=$fin['AMOUNT'];
            }
            else if($fin['BUDGET_HEAD']=='OD INTEREST PAYMENT')
            {
                $finODIneterestCost+=$fin['AMOUNT'];
            }
        }
        $finbreakup = array($finInterestCost,
                            $finODIneterestCost);
        return $finbreakup;
    }
    function otherIncomeBreakup($teamId,$gameId,$incomefrominvestCostFilter)
    {
        //to get fincost breakup for fin dashboard
        
        $this -> load -> model('Dashboard_model');
        $otherIncomeBreakup = $this->Dashboard_model->BudgetDetailsgroupbyBudgetHead($teamId,$gameId,$incomefrominvestCostFilter);
        
        $otherIncomeFD=0;
        $otherIncomeSharesale=0;
        $otherIncomeMachinesale=0;
        $otherIncomePlantsale=0;
        $otherIncomeWarehousesale=0;
            
        foreach($otherIncomeBreakup as $other)
        {
            if($other['BUDGET_HEAD']=='FD_INTEREST')
            {
                $otherIncomeFD+=$other['AMOUNT'];
            }
            else if($other['BUDGET_HEAD']=='SELL_SHARE_PROFIT')
            {
                $otherIncomeSharesale+=$other['AMOUNT'];
            }
             else if($other['BUDGET_HEAD']=='SELL_MACHINE_REVENUE')
            {
                $otherIncomeMachinesale+=$other['AMOUNT'];
            }
            else if($other['BUDGET_HEAD']=='SELL_PLANT_REVENUE')
            {
                $otherIncomePlantsale+=$other['AMOUNT'];
            }
            else if($other['BUDGET_HEAD']=='SELL_WAREHOUSE_REVENUE')
            {
                $otherIncomeWarehousesale+=$other['AMOUNT'];
            }
        }
        $otherbreakup = array($otherIncomeFD,
                            $otherIncomeSharesale,
                            $otherIncomeMachinesale,
                            $otherIncomePlantsale,
                            $otherIncomeWarehousesale);
        return $otherbreakup;
    }
    function profiledownload($gameBatchId)
    {

        $this -> load -> model('Game_model');
        $teamInfos = $this -> Game_model -> getTeamsForBatchId($gameBatchId);
        $teamId = array_column($teamInfos, 'TEAM_ID');
        $gameId = array_column($teamInfos, 'GAME_ID');
       // for($i=1;$i<=count($teamId);$i++)
       // {
            $teamDtls = $this -> Game_model -> getPlayerInfoForTeamId( $teamId[0]);
       //     $i=0;
       //    foreach($teamDtls as $team)
       //{
          //$report=$this->profileReport($deptName,$gameId,$teamId,$universeToken);
       //      $report=json_encode($this->profileReport($team['DEPARTMENT_NAME'],$team['GAME_ID'],$team['TEAM_ID'],$team['UNIVERSE_TOKEN']));
             
       //     $report=$this->profileReportview($teamDtls[0]['DEPARTMENT_NAME'],$teamDtls[0]['GAME_ID'],$teamDtls[0]['TEAM_ID'],$teamDtls[0]['UNIVERSE_TOKEN']);
     // $i++;
     //   }
      //  }
        $data=array("reports"=>$teamDtls) ;
       // var_dump($report);
        echo json_encode($data);
    }
    
function profileReportAll($gameBatchId)
    {
        $this -> load -> model('Game_model');
        $teamInfos = $this -> Game_model -> getTeamsForBatchId($gameBatchId);
        $AllteamId = array_column($teamInfos, 'TEAM_ID');
        $i=0;
        //$AllgameId = array_column($teamInfos, 'GAME_ID');
       for($j=0;$j<count($AllteamId);$j++)
       {
           
            $teamDtls = $this -> Game_model -> getPlayerInfoForTeamId( $AllteamId[$j]);
            foreach($teamDtls as $team)
       {
          $deptName=$team['DEPARTMENT_NAME'];
          $universeToken=$team['UNIVERSE_TOKEN'];
          $teamId=$team['TEAM_ID'];
          $gameId=$team['GAME_ID'];
    
  
        $deptName = strtoupper($deptName);
        
        $this -> load -> model('Gamemasters_model');
        $gameBatchInfo=$this->Gamemasters_model -> getGameStartInfo($universeToken);
        $userInfo=$this->Gamemasters_model -> getUserInfoforDeptandTeam($teamId,$deptName);
        $qtrStatus=$this -> Game_model -> getQtrStatus($teamId);
        $winningData = $this->leaderboardApi($universeToken);

        $winningDataForTeam = array_filter($winningData, function ($item) use ($teamId) {
            return( ($item->TEAM_ID == $teamId));
        }); // Filter array by teamid
        
        $winningDataForTeam = array_values(array_filter($winningDataForTeam)); //  To reset the index
        
        $playerInfo = array("gameBatchInfo"=>$gameBatchInfo,
                                "gamePlayStatus"=>$qtrStatus,
                                "winningData"=>$winningDataForTeam,
                                "userInfo"=>$userInfo,
                                "department"=>$deptName);
        
        $index = 0;
        $maxYearIndv = $this->getMaxYear($universeToken,'INDV');
        $maxYearMyLeague = $this->getMaxYear($universeToken,'MYLEAGUE');
        $maxYearGlobal = $this->getMaxYear($universeToken,'GLOBAL');
        
        $roleCountMyLeague = $this -> Game_model ->getTeamCount($universeToken,'MYLEAGUE'); // total team count for given universe token 
        $roleCountGlobal = $this -> Game_model ->getTeamCount($universeToken,'GLOBAL'); // overall team count played (universe token ignored)
        
        // var_dump($roleCountMyLeague);

        
        /* ena Target YearQtr Wise ($maxYear,$roleCount,$teamIdOrUnivsereToken,$deptName,$profileType,$allRole) */
        $enaTgtIndv = $this->enaTgt($maxYearIndv,1,0,$deptName,'INDV','NO');
        $enaTgtMyLeague = $this->enaTgt($maxYearMyLeague,$roleCountMyLeague[0]['ROLE_COUNT'],0,$deptName,'INDV','NO');
        $enaTgtGlobal = $this->enaTgt($maxYearGlobal,$roleCountGlobal[0]['ROLE_COUNT'],0,$deptName,'INDV','NO');
        
        /* ENA target sum of all YearQtr */
        $enaSumTgtIndv = $this->enaSumTgt($enaTgtIndv);
        $enaSumTgtMyLeague = $this->enaSumTgt($enaTgtMyLeague);
        $enaSumTgtGlobal = $this->enaSumTgt($enaTgtGlobal);
        
        /* Fetch achieved ENA values from Database YearQtr Wise */
        $enaAchDtlsIndv = $this -> Game_model ->getEnaData($deptName,$teamId,'INDV');
        $enaAchDtlsMyLeague = $this -> Game_model ->getEnaData($deptName,$universeToken,'MYLEAGUE');
        $enaAchDtlsGlobal = $this -> Game_model ->getEnaData($deptName,$universeToken,'GLOBAL');
        
         
        /* ENA Achieved sum of all YearQtr */
        $enaSumAchIndv = $this->enaSumAch($enaAchDtlsIndv);
        $enaSumAchMyLeague = $this->enaSumAch($enaAchDtlsMyLeague);
        $enaSumAchGlobal = $this->enaSumAch($enaAchDtlsGlobal);
        
        /* ENA Achieved Percentage YearQtr wise */
        $enaAchPerDtlsIndv = $this->enaAchPerDtls($enaTgtIndv,$enaAchDtlsIndv);
        $enaAchPerDtlsMyLeague = $this->enaAchPerDtls($enaTgtMyLeague,$enaAchDtlsMyLeague);
        $enaAchPerDtlsGlobal = $this->enaAchPerDtls($enaTgtGlobal,$enaAchDtlsGlobal);
        
         /* ENA Achieved Percentage of all YearQtr */
        $enaSumAchPerIndv = $this->enaSumAchPer($enaSumAchIndv,$enaSumTgtIndv);
        $enaSumAchPerMyLeague = $this->enaSumAchPer($enaSumAchMyLeague,$enaSumTgtMyLeague);
        $enaSumAchPerGlobal = $this->enaSumAchPer($enaSumAchGlobal,$enaSumTgtGlobal);
        
        $allRoleDtls = $this->profileReportAllRole ($teamId,$universeToken,$roleCountMyLeague[0]['ROLE_COUNT'],$maxYearMyLeague);
      // var_dump($enaSumAchPerIndv);
        $chartdata [$i]= array("scoreIndv"=>$enaSumAchPerIndv,
                        "scoreMyLeague"=>$enaSumAchPerMyLeague,
                        "scoreGlobal"=>$enaSumAchPerGlobal,
                        "trendIndv"=>$enaAchPerDtlsIndv,
                        "trendMyLeague"=>$enaAchPerDtlsMyLeague,
                        "trendGlobal"=>$enaAchPerDtlsGlobal,
                        "tblData"=>$enaSumAchMyLeague,
                        "trendAllRoleTeam"=>$allRoleDtls['AllRoleAchPerDtlsTeam'],
                        "trendAllRoleMyLeague"=>$allRoleDtls['AllRoleAchPerDtlsMyLeague'],
                        "playerInfo"=>$playerInfo
                        ); 
                        $i++;
        }

        }
        $data['chartdata']=$chartdata;
        // $data['ena'] = $enaSumTgtGlobal;                     
      //  $data['_view'] = 'universe_playerprofile_view';
   // $this->load->view('layouts/main_view', $data);
       $datapassed=$this->load->view('universe_playerprofile_view', $data, TRUE);
       echo json_encode($datapassed);
    //   return $datapassed;
        
    }
    function universeleaderboard($universeToken)
    {
        $this->load ->model('Game_model');
        $chartdata = $this->leaderboardApi($universeToken);
        $lb = json_decode(json_encode($chartdata), true);
        // echo $this->rest->debug();
       
         $data['_view'] = 'leaderboard_view';
        $data['data'] = $lb;
        $data['universetoken'] = $universeToken;
         $this -> load -> view('layouts/main_view', $data);
      // $this -> load -> view('leaderboard_view', $lb, TRUE);
        
    }
    function teamDetailforteamName($teamName)
    {
        //$teamName=str_replace('%20',' ', $teamName);
        $teamName=urldecode($teamName);
        $this->load ->model('Game_model');
         $teamInfos = $this -> Game_model -> getTeamsForTeamName($teamName);
        // var_dump($teamInfos[0]['TEAM_ID']);
        $teamId = $teamInfos[0]['TEAM_ID'];
       
            $teamDtls = $this -> Game_model -> getPlayerInfoForTeamId( $teamId);
      
       $tableData = array("teamDtls"=>$teamDtls);
        echo json_encode($tableData);
        
    }
    
}