<?php
include (APPPATH . 'libraries/CommonUtilities.php');

class Manage_user_product extends CommonUtilities {
    public function __construct() {
        parent::__construct();
        $this->load->helper(array('form','url','html'));
        $this->load->library(array('session', 'form_validation'));
        $this -> load -> model('Game_model');
        $this -> load -> model('stratup/Game_batch_tbl_model');
        
        if (!$this -> session -> userdata('login')) {
            redirect('login');
        }
    }
    function clientmstr()
    {
        $this -> load -> model('stratup/Client_mstr_model');
        $data['ClientDetails']=$this->Client_mstr_model -> get_all_client_mstr();
        $data['_view'] = 'admin/client_add_list_view';
        $data['_navview'] = 'nav_view';
        $this->load->view('layouts/main_view', $data);
    }
    function newUserRegister()
    {
        $this -> load -> library('form_validation');
        $this -> form_validation -> set_rules('USER_FROM_DATE', 'Start Date', 'required');
        $this -> form_validation -> set_rules('USER_TO_DATE', 'End Date', 'required');
        
        $this -> load -> model('User_model');
        $fromDate = $this -> input -> post('USER_FROM_DATE'); 
        $toDate = $this -> input -> post('USER_TO_DATE'); 
        if(isset($fromDate) && isset($toDate))
        {
            $data['UserDetails']=$this->User_model -> getNewUserRegistered($fromDate,$toDate);
        }
        $data['_view'] = 'admin/newusersignup_view';
        $data['_navview'] = 'nav_view';
        $this->load->view('layouts/main_view', $data);
    }
    function addClient()
    {
        $this -> form_validation -> set_rules('clientName', 'Client Name', 'required');
        $this -> form_validation -> set_rules('clientcode', 'Client Code', 'required');
        $this -> load -> model('stratup/Client_mstr_model');
        
        $clientName=$this -> input -> post('clientName');
        $clientCode=$this -> input -> post('clientcode');
        $title= $this->input->post('Title');
        
        if ($this -> form_validation -> run() == FALSE)
        {
            // fails
            foreach ($_POST as $key => $value) 
                {
                    $data['messages'][$key] = form_error($key);
                }               
                echo json_encode($data);
        }
        else
        {
            // if(!empty($clientName) && !empty($clientCode))
            // {
                $clientmstr=$this->Client_mstr_model -> get_client_by_client_code($clientCode);
                if(count($clientmstr)>0)
                {
                    $data['messages']['msg_client'] = '<div class="alert alert-danger text-center">Client code already exists</div>';
                    // redirect('login');
                  echo json_encode($data);
                }
                else{
                    $params = array('CLIENT_NAME'=>$clientName,
                            'INDUSTRY_ID'=>1,
                            'PARTNER_ID'=>1,
                            'STATUS_ID'=>1,
                            'CONTACT_TITLE'=>$title,
                            'CONTACT_FIRST_NAME'=>$this -> input -> post('ContactFirstName'),
                            'CONTACT_MIDDLE_NAME'=>$this -> input -> post('ContactMidName'),
                            'CONTACT_LAST_NAME'=>$this -> input -> post('ContactLastName'),
                            'CONTACT_DESIGNATION'=>$this -> input -> post('Designation'),
                            'CONTACT_EMAIL_ID'=>$this -> input -> post('EmailId'),
                            'CONTACT_COUNTRY_CODE'=>$this -> input -> post('councode'),
                            'CONTACT_STD_CODE'=>$this -> input -> post('stdcode'),
                            'CONTACT_LANDLINE_NO'=>$this -> input -> post('landline'),
                            'CONTACT_MOBILE_NO'=>$this -> input -> post('Mobile'),
                            'CLIENT_CODE'=>$clientCode,
                            'LICENSE_GENERATE_STATUS'=>'A'
                            );
                           
                 $clientId=$this->Client_mstr_model->add_client_mstr($params); 
                 $data['success'] = true;
                 $data['messages']['msg_client'] = '<div class="alert alert-success text-center">Successfully Inserted.</div>';
                    echo json_encode($data);
                }
                
            // }
            // else{
                // $this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Please Enter Client Name and Client Code</div>');
                            // // redirect('login');
                          // redirect('new_User_Client/index');
            // }             
         }
    }
    function updateClientView()
    {
        $this -> load -> model('stratup/Client_mstr_model');
        $clientId = $_POST['clientId'];
        $datapassed['clientdtls']=json_decode(json_encode($this->Client_mstr_model->get_client_mstr($clientId)),TRUE);
        $data=$this->load->view('admin/client_update_view',$datapassed, TRUE);
        echo json_encode($data);
    }
    function updateClient()
    {
         $this -> form_validation -> set_rules('clientName', 'Client Name', 'required');
           $this -> form_validation -> set_rules('clientcode', 'Client Code', 'required');
        $this -> load -> model('stratup/Client_mstr_model');
        
        $clientId = $this -> input -> post('clientId');
        $clientName=$this -> input -> post('clientName');
        $clientCode=$this -> input -> post('clientcode');
        $title= $this->input->post('Title');
        $status = $this->input->post('Status');
        
        // if ($this -> form_validation -> run() == FALSE)
        // {
            // // fails
            // foreach ($_POST as $key => $value) 
                // {
                    // $data['messages'][$key] = form_error($key);
                // }               
                // echo json_encode($data);
        // }
        if(empty($clientName)|| empty($clientCode))
        {
            $this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Please Enter Client Name and Code.</div>');
                        // redirect('login');
                      redirect('client-master');
        }
        else
        {
            $clientmstr=$this->Client_mstr_model -> get_all_client_mstr_except($clientId,$clientCode);
                if(count($clientmstr)>0)
                {
                    
                    // $data['messages']['msg_updclient'] = '<div class="alert alert-danger text-center">Client code already exists</div>';
                    // // redirect('login');
                  // echo json_encode($data);
                  $this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Client code already exists</div>');
                        // redirect('login');
                      redirect('client-master');
                }
                else{
                $params = array('CLIENT_NAME'=>$clientName,
                            'STATUS_ID'=>$status,
                            'CONTACT_TITLE'=>$title,
                            'CONTACT_FIRST_NAME'=>$this -> input -> post('ContactFirstName'),
                            'CONTACT_MIDDLE_NAME'=>$this -> input -> post('ContactMidName'),
                            'CONTACT_LAST_NAME'=>$this -> input -> post('ContactLastName'),
                            'CONTACT_DESIGNATION'=>$this -> input -> post('Designation'),
                            'CONTACT_EMAIL_ID'=>$this -> input -> post('EmailId'),
                            'CONTACT_COUNTRY_CODE'=>$this -> input -> post('councode'),
                            'CONTACT_STD_CODE'=>$this -> input -> post('stdcode'),
                            'CONTACT_LANDLINE_NO'=>$this -> input -> post('landline'),
                            'CONTACT_MOBILE_NO'=>$this -> input -> post('Mobile'),
                            'CLIENT_CODE'=>$clientCode,
                            'LICENSE_GENERATE_STATUS'=>$this -> input -> post('Lic_gen_Status')
                            );
                       
             $updatedclient=$this->Client_mstr_model->update_client_mstr($clientId,$params);
             
             // $data['success'] = true;
             // $data['messages']['msg_updclient'] = '<div class="alert alert-success text-center">Successfully Inserted.</div>';
                    // echo json_encode($data);
                    $this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Successfully Updated</div>');
                        // redirect('login');
                      redirect('client-master');
                }
          
            
        }
         
    }
    function deleteClient()
    {
        $this -> load -> model('stratup/Client_mstr_model');
        $clientId = $this->input -> post('deleteclientId');
        
        $this->Client_mstr_model->delete_client_mstr($clientId);
        
        if ($this->db->trans_status() === FALSE)
            {
                    $this->db->trans_rollback();
                     $this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Oops! Something went wrong. Please try again</div>');
                     redirect('Manage_user_product/clientmstr');
            }
            else
            {
                    $this->db->trans_commit();
                    $this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Successfully Deleted</div>');
                        // redirect('login');
                      redirect('Manage_user_product/clientmstr');
            }
    }
    function userClient()
    {
        $this -> load -> model('User_model');
        $emailid = $this -> input -> post('EMAILID'); 
        $userdata = $this->session->flashdata('data1');
        $in = $userdata['user']['in'];
       
        if(isset($emailid)|| isset($in))
        {
            if(isset($emailid))
            {
                $userdetails = $this->User_model -> get_user_by_emailid($emailid);
            }
            else{
                $userdetails = $this->User_model -> get_user_by_id($in);
            }
            
            if(count($userdetails)>0)
            {
                $data['UserDetails']=$userdetails; 
                $data['usertypemstr'] = json_decode(json_encode($this->User_model->getUserTypeMstr()),TRUE);
                $data['userdtls']=json_decode(json_encode($this->User_model->get_user_by_id($userdetails[0]->USER_ID)),TRUE);
                $email = $userdetails[0]->EMAIL_ID;
                //$data['userId'] = $userdetails[0]->USER_ID;
                if(strtolower($userdetails[0]->USER_TYPE_NAME) == 'trainer')
                {
                    $data['ClientDetails']=$this->User_model -> get_client_mapped_by_email($email);
                    $this -> load -> model('stratup/Client_mstr_model');
                    $data['ClientMstr']=$this->Client_mstr_model->get_client_mstr_by_status();
                }
                $this->session->set_flashdata('msg', '');
            }
            else{
                 $this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Email ID does not exists.</div>');
            }
           
        }
        $data['_view'] = 'admin/user_client_view';
        $data['_navview'] = 'nav_view';
        $this->load->view('layouts/main_view', $data);
    }
    function updateusertype()
    {
        $this -> load -> model('User_model');
        
        $userId = $this->input->post('userId');
        $usertypeId = $this->input->post('Usertype');
        
        $params = array('USER_TYPE_ID'=>$usertypeId);
                       
        $updatedusertype=$this->User_model->update_user_mstr($userId,$params);
             
        $session_data['user'] = array(
                                "in"=>$userId,
                                "msg"=>'<div class="alert alert-success text-center">Successfully Updated</div>'
                                );
                                
        $this->session->set_flashdata('data1',$session_data);
        redirect('usertype-client');
        // $data['success'] = true;
        // $data['messages']['msg_user'] = '<div class="alert alert-success text-center">Successfully Updated.</div>';
        // echo json_encode($data); 
    }
    function updateClientmap()
    {
        $this -> load -> model('User_model');
        
        $userId = $this->input->post('usermapId');
        $clientId= $this->input->post('clientId');
        var_dump ($clientId);
        $this -> load -> model('stratup/Client_mstr_model');
        if(!is_null($clientId))
        {

            for($i=0;$i<count($clientId);$i++)
            {
                $clientmapdtls=$this->User_model->get_userClientMapping($userId,$clientId[$i]);
                if(count($clientmapdtls)==0)
                {
                    $params = array('USER_ID'=>$userId,
                                    'CLIENT_ID'=>$clientId[$i]
                                );
                    
                    $addclientmap=$this->User_model->insert_userClientMapping($params);
                } 
            }
            
            
            $ClientMstr=$this->Client_mstr_model->get_client_mstr_by_status();
            foreach($ClientMstr as $client)
            {
                if(!in_array($client['CLIENT_ID'], $clientId))
                {
                    $clientmapdtls=$this->User_model->get_userClientMapping($userId,$client['CLIENT_ID']);
                    if(count($clientmapdtls)>0)
                    {
                        $clientmap=$this->User_model->delete_userClientMapping($clientmapdtls[0]['USER_CLIENT_MAPPING_ID']);
                    }
                }
            }
        }
        else{
            $ClientMstr=$this->Client_mstr_model->get_client_mstr_by_status();
        foreach($ClientMstr as $client)
        {
                $clientmapdtls=$this->User_model->get_userClientMapping($userId,$client['CLIENT_ID']);
                if(count($clientmapdtls)>0)
                {
                    $clientmap=$this->User_model->delete_userClientMapping($clientmapdtls[0]['USER_CLIENT_MAPPING_ID']);
                }
        }
        }
        $session_data['user'] = array("in"=>$userId,
                                      "msg"=>'<div class="alert alert-success text-center">Successfully Updated</div>');
        $this->session->set_flashdata('data1',$session_data);
        redirect('usertype-client');
                    // $data['success'] = true;
                 // $data['messages']['msg_clientmap'] = '<div class="alert alert-success text-center">Successfully Updated.</div>';
                    // echo json_encode($data);    
    }
    function getEnquiry()
    {
        $this -> load -> library('form_validation');
        $this -> form_validation -> set_rules('ENQ_FROM_DATE', 'Start Date', 'required');
        $this -> form_validation -> set_rules('ENQ_TO_DATE', 'End Date', 'required');
        
        $this -> load -> model('User_model');
        $fromDate = $this -> input -> post('ENQ_FROM_DATE'); 
        $toDate = $this -> input -> post('ENQ_TO_DATE'); 
        if(isset($fromDate) && isset($toDate))
        {
            $data['enquiryDtls']=$this->User_model -> getEnquirybyDate($fromDate,$toDate);
            $Enterprise=0;
            $ReachOut=0;
            $Contact=0;
            $Partner=0;
            $Order=0;
            $Register = 0;
            $enqCount=$this->User_model -> getCountofEnquirybytype($fromDate,$toDate);
            foreach($enqCount as $e)
            {
                if($e->ENQUIRY_FOR=="Enterprise")
                {
                    $Enterprise=$e->TOTALCOUNT;
                }
                else if($e->ENQUIRY_FOR=="Partner")
                {
                    $Partner=$e->TOTALCOUNT;
                }
                else if($e->ENQUIRY_FOR=="ReachOut")
                {
                    $ReachOut=$e->TOTALCOUNT;
                }
                else if($e->ENQUIRY_FOR=="Contact")
                {
                    $Contact=$e->TOTALCOUNT;
                }
                else if($e->ENQUIRY_FOR=="Order")
                {
                    $Order=$e->TOTALCOUNT;
                }
                else if($e->ENQUIRY_FOR=="Register")
                {
                    $Register=$e->TOTALCOUNT;
                }
            }
            $data['enquiryCount']= array($Enterprise,$Partner,$ReachOut,$Contact,$Order,$Register);
        }
        $data['_view'] = 'admin/enquiry_view';
        $data['_navview'] = 'nav_view';
        $this->load->view('layouts/main_view', $data);
    }
    function productmstr()
    {
        $this -> load -> model('Gamemasters_model');
        $data['gameDetails']=$this->Gamemasters_model -> getAllGameList();
        $data['gameCate']=$this->Gamemasters_model -> getGameCategoryList();
        $data['_view'] = 'admin/product_add_list_view';
        $data['_navview'] = 'nav_view';
        $this->load->view('layouts/main_view', $data);
    }
    function addProduct()
    {
        $this -> form_validation -> set_rules('GAME_TITLE', 'Client Name', 'required');
        $this -> load -> model('Gamemasters_model');
        
        $gameTitle=$this -> input -> post('GAME_TITLE');
        
        if ($this -> form_validation -> run() == FALSE)
        {
            // fails
            foreach ($_POST as $key => $value) 
            {
                $data['messages'][$key] = form_error($key);
            }               
            echo json_encode($data);
        }
        else
        {
            $gamemstr=$this->Gamemasters_model -> getGameListForGameTitl($gameTitle);
            if(count($gamemstr)>0)
            {
                $data['messages']['msg_prod'] = '<div class="alert alert-danger text-center">Game Title already exists</div>';
                echo json_encode($data);
            }
            else
            {
                $params = array('GAME_TAG'=>$this -> input -> post('GAME_TAG'),
                            'GAME_TITLE'=>$gameTitle,
                            'GAME_DESC'=>$this -> input -> post('GAME_DESC'),
                            'GAME_LOGO_PATH'=>$this -> input -> post('GAME_LOGO_PATH'),
                            'GAME_VIDEO_PATH'=>$this -> input -> post('GAME_VIDEO_PATH'),
                            'GAME_CAT_ID'=>$this -> input -> post('GAME_CAT_ID'),
                            'SEQ_NO'=>$this -> input -> post('SEQ_NO'),
                            'STATUS'=>$this -> input -> post('STATUS'),
                            'PRICE'=>$this -> input -> post('PRICE')
                            );
                           
                $gameId=$this->Gamemasters_model->add_game_mstr($params); 
                $data['success'] = true;
                $data['messages']['msg_prod'] = '<div class="alert alert-success text-center">Successfully Inserted.</div>';
                echo json_encode($data);
            }   
        }
    }
    function updateProdView()
    {
        $this -> load -> model('Gamemasters_model');
        $gameId = $_POST['gameId'];
        $datapassed['gameCate']=$this->Gamemasters_model -> getGameCategoryList();
        $datapassed['gamedtls']=json_decode(json_encode($this->Gamemasters_model->getGameDescriptionForGameId($gameId)),TRUE);
        $data=$this->load->view('admin/product_update_view',$datapassed, TRUE);
        echo json_encode($data);
    }
    function updateProduct()
    {
        $this -> form_validation -> set_rules('GAME_TITLE', 'Game Title', 'required');
        $this -> load -> model('Gamemasters_model');
        
        $gameId = $this -> input -> post('gameId');
        $gameTitle = $this -> input -> post('GAME_TITLE');
        
        // if ($this -> form_validation -> run() == FALSE)
        // {
            // // fails
            // foreach ($_POST as $key => $value) 
                // {
                    // $data['messages'][$key] = form_error($key);
                // }               
                // echo json_encode($data);
        // }
        if(empty($gameTitle))
        {
            $this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Please Enter Game Title.</div>');
            redirect('product-master');
        }
        else
        {
            $gamemstr=$this->Gamemasters_model -> getGameListexceptgame($gameId,$gameTitle);
            if(count($gamemstr)>0)
            {
                // $data['messages']['msg_updclient'] = '<div class="alert alert-danger text-center">Client code already exists</div>';
                // echo json_encode($data);
                $this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Game Title already exists</div>');
                redirect('product-master');
            }
            else
            {
                $params = array('GAME_TAG'=>$this -> input -> post('GAME_TAG'),
                            'GAME_TITLE'=>$gameTitle,
                            'GAME_DESC'=>$this -> input -> post('GAME_DESC'),
                            'GAME_LOGO_PATH'=>$this -> input -> post('GAME_LOGO_PATH'),
                            'GAME_VIDEO_PATH'=>$this -> input -> post('GAME_VIDEO_PATH'),
                            'GAME_CAT_ID'=>$this -> input -> post('GAME_CAT_ID'),
                            'SEQ_NO'=>$this -> input -> post('SEQ_NO'),
                            'STATUS'=>$this -> input -> post('STATUS'),
                            'PRICE'=>$this -> input -> post('PRICE')
                            );
                       
                $updatedprod=$this->Gamemasters_model->update_game_mstr($gameId,$params);
             
                // $data['success'] = true;
                // $data['messages']['msg_updclient'] = '<div class="alert alert-success text-center">Successfully Inserted.</div>';
                // echo json_encode($data);
                $this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Successfully Updated</div>');
                redirect('product-master');
            }
        }
    }
    function userRoleModify()
    {
        $this -> load -> model('stratup/Game_batch_tbl_model');
        $universeToken = $this -> input -> post('universeToken'); 
      
        $in = $this->session->flashdata('in');
     
        if(isset($universeToken)|| isset($in))
        {
            if(isset($universeToken))
            {
                $game_batch_tbl = $this->Game_batch_tbl_model -> get_game_batch_tbl_foruniverse($universeToken);
            }
            else{
                $game_batch_tbl = $this->Game_batch_tbl_model -> get_game_batch_tbl_foruniverse($in);
            }
            
            if($game_batch_tbl!='')
            {
                $data['game_batch_tbl'] = $game_batch_tbl;
               
                $teamInfos = $this -> Game_model -> getTeamsForBatchId($data['game_batch_tbl']['GAME_BATCH_ID']);
               
                $data['teamCount'] = count($teamInfos);
                $data['teamId'] = array_column($teamInfos, 'TEAM_ID');
                $data['teamName'] = array_column($teamInfos, 'TEAM_LOGO_NAME');
                $data['gameBatchId'] = $data['game_batch_tbl']['GAME_BATCH_ID'];
                $data['universeToken'] = $data['game_batch_tbl']['UNIVERSE_TOKEN'];
               
                $this->session->set_flashdata('msg', '');
            }
            else{
                 $this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Universe Token does not exists.</div>');
            }
        }
        $data['_view'] = 'admin/role_modification_view';
        $data['_navview'] = 'nav_view';
        $this->load->view('layouts/main_view', $data);
    }
    function userRoleUpdateView($universeToken,$teamId)
    {
        $this -> load -> model('Game_model');
         
        $datapassed['universeToken'] = $universeToken;
        $datapassed['teamId']=$teamId;
        $datapassed['teamDtls']=json_decode(json_encode($this->Game_model -> teamuserRoleMapping($teamId)),TRUE);
       // $datapassed['deptMstr']=json_decode(json_encode($this->Game_model->departmentgameMstr($teamId)),TRUE);
       //$data=$this->load->view('role_update_view',$datapassed, TRUE);
      //  echo json_encode($data);
       $datapassed['_view'] = 'admin/role_update_view';
       $datapassed['_navview'] = 'nav_view';
       $this->load->view('layouts/main_view', $datapassed);
    }
    function updateUserRole()
    {
       $teamId=$this -> input -> post('teamId');
       $universeToken=$this -> input -> post('universe');
       
       $email=$_POST['emailID'];
       $roleId=$_POST['rolemapId'];
       $this -> load -> model('Game_model');
       foreach($email as $e)
       {
           $flag=FALSE;
           foreach($roleId as $r)
           {
               $checkuser=$this->Game_model -> checkusersroleinuniverse($universeToken,$teamId,$e);
               if(count($checkuser)>0)
               {
                   $data=array();
                   $data['messages'][''.$r.''] = '<p class="text-danger">Already Exists in Universe</p>';
                   $flag=TRUE;
                   break;
               }
               else 
               {
                   $userrole=$this->Game_model -> getusersrole($r,$e);
                   if(count($userrole)>0)
                   {
                       $data=array();
                       $data['success'] = true;
                       $data['mgs']= '<div class="alert alert-success text-center">Successfully Updated.</div>';
                       $removed = array_shift($roleId);
                       break;
                   }
                   else 
                   {
                       $this -> load -> model('User_model');
                       $userDtls = $this -> User_model -> getUserDetailsByEmail($e);
                       if(count($userDtls)>0)
                       {
                           $userId=$userDtls[0]->USER_ID;
                           $this -> Game_model -> updateuserrole($r,$userId);
                           
                           $data=array();
                           $data['success'] = true;
                           $data['mgs']= '<div class="alert alert-success text-center">Successfully Updated.</div>';
                           $removed = array_shift($roleId);
                           break;
                       }
                       else
                       {
                           $data=array();
                           $data['messages'][''.$r.''] = '<p class="text-danger">User does not exist.</p>';
                           $flag=TRUE;
                       }
                       $removed = array_shift($roleId);
                       break;
                   }
               }
            }
            if($flag==TRUE)
            {
                break;
            }
        }
        $this->session->set_userdata('in',$universeToken);
        echo json_encode($data); 
    }
    function userRoleDisplay()
    {
        // created by : Leela
        // modified by : Leela
        
        $this -> load -> model('stratup/Game_batch_tbl_model');
        $this -> load -> model('Joingame_model');
        $this -> load -> model('Game_model');
        $universeToken = $this -> input -> post('universeToken');
        $userLoginType = $this -> session -> userdata('utype');
        if (strtolower($userLoginType) == 'admin' || strtolower($userLoginType) == 'trainer')
        {
            $emailId = $this -> input -> post('emailId');
            $this -> form_validation -> set_rules('emailId', 'Email ID', 'trim|required');
            $trainerUserId = $this->session->userdata('uid');
        }
        else 
        {
            $emailId =  $this -> userId = $this->session->userdata('emailid');
            
        }
        $this -> form_validation -> set_rules('universeToken', 'Universe Token', 'trim|required');
        if ($this -> form_validation -> run())
        {
            $validUser = $this->Joingame_model -> checkEmailIdRegistered($emailId);
            $userId = $validUser[0]->USER_ID;
            if(empty($validUser))
            {
                $this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Email ID NOT Registered.</div>');
                redirect('modify-role');
            }
            
            $game_batch_tbl = $this->Game_batch_tbl_model -> get_game_batch_tbl_foruniverse($universeToken);
            
            if(empty($game_batch_tbl))
            {
                $this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Universe Token Or Email does not match.</div>');
                redirect('modify-role');
            }
            if (strtolower($userLoginType) == 'trainer')
            {
                $game_batch_tbl = $this->Game_batch_tbl_model->get_game_batch_tbl_forclient($universeToken,$trainerUserId);
                if(empty($game_batch_tbl))
                {
                    $this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">You dont have access to modify this Universe. Please contact Admin.</div>');
                    redirect('modify-role');
                }
            }
            $teamIdDtls = $this ->Joingame_model->getTeamForUserInUniverse($universeToken,$emailId);
            if(empty($teamIdDtls))
            {
                $emptyTeamDtls = $this->Joingame_model -> getAvailableTeamsInUniverse($universeToken);
                if(empty($emptyTeamDtls))
                {
                    $this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">No Room to Join. Please Contact Admin / Trainer. </div>');
                    redirect('modify-role');
                }
                else
                {
                    // call add function
                    $data['userId'] = $userId;
                    $data['teamInfos'] = array("USER_NAME"=>"","EMAIL_ID"=>"","DEPARTMENT_NAME"=>"");
                    $data['emptyTeamIds'] = array_column($emptyTeamDtls, 'TEAM_ID');
                    $data['emptyTeamId']=$data['emptyTeamIds'][0];
                    // var_dump( $data);
                }
            }
            else 
            {
                $data['teamId'] = array_column($teamIdDtls, 'TEAM_ID');
                // var_dump($data['teamId'][0]);
                $teamInfos=$this->Game_model ->getPlayerInfoForTeamId($data['teamId'][0]);
                $data['teamInfos'] = $teamInfos;
                
            }
            
            
        }
        
        
        $data['_view'] = 'admin/userroledisplay_view';
        $data['_navview'] = 'nav_view';
        $this->load->view('layouts/main_view', $data);
        
    }
    function userRoleAdd($universeToken,$teamId,$userId)
    {
        // created by : Leela
        // modified by : Leela
        
        $data['emptyTeamId']=$teamId;
        $data['universeToken']=$universeToken;
        $data['userId'] = $userId;
      //  $searchEmailId = $this -> input -> post('emailId');
        
        $goldRole[0]='IT'; 
        $goldRole[1]='HR';
        $goldRole[2]='MKT';
        // $goldRole[3]='STG';
        $goldRole[3]='FIN';
        $goldRole[4]='OPS';
        
        $silverRole[0]='HR';
        $silverRole[1]='MKT';
        $silverRole[2]='FIN';
        $silverRole[3]='OPS';
        
        $this -> load -> model('Joingame_model');
        $this -> load -> model('Gamemasters_model');
        $userDtls = $this -> Joingame_model -> getUserDtlsbyId($userId);
        $searchEmailId = $userDtls[0]->EMAIL_ID;
        
        $gameDtls = $this ->Joingame_model->fetchGameTypeUsingUniverseToken($universeToken);
        $batchId= $gameDtls[0]->GAME_BATCH_ID;
        // $gameDtls[0]->CLIENT_ID;
        // $gameDtls[0]->START_DATE;
        // $gameDtls[0]->TRAINIER_ID;
        // $gameDtls[0]->NO_OF_YEAR_IN_GAME;
        // $gameDtls[0]->COURSE_NAME;
        $stratupType = $gameDtls[0]->STRATUP_TYPE;
        // $gameDtls[0]->STRATUP_MODE;
        // $gameDtls[0]->MAX_PLAYERS;
        
        $data['SIMULATION_TYPE']=$stratupType;
        $data['MAX_PLAYER'] = 3;
        
        if ( $stratupType=='GOLD')
        {
            $maxRole=5;
            $role = $goldRole;
            $roleName = array('IT','HR','MKT','FIN','OPS'); //'STG',
            
            
        }
        else
        {
            $maxRole=4;
            $role = $silverRole;
            $roleName = array('HR','MKT','FIN','OPS');
        }
        $this->form_validation->set_message('is_unique', 'The %s is already taken');
        $this -> form_validation -> set_rules('TEAM_A_NAME', 'Company Name', 'trim|required');
        $this->form_validation->set_error_delimiters('<span class="text-danger">', '</span>');
        
        for ($i=0; $i<$maxRole; $i++)
        {
            $this -> form_validation -> set_rules('TEAM_A_PLAYER_EMAIL'.$i, 'Email ID', 'trim|required|valid_email');
        }         
        if ($this -> form_validation -> run())
        {
            $companyName=$this -> input -> post('TEAM_A_NAME');
            $companyNameAvailableDtls=$this->Gamemasters_model ->getTeamsForTeamName($companyName);
            if(count($companyNameAvailableDtls)>0)
            {
                $this->session->set_flashdata('role_add_msg', '<div class="alert alert-danger text-center">Company Name Already Exist. Please Try with Different Name</div>');
                redirect('modify-role/add/'.$universeToken.'/'.$teamId.'/'.$userId);
            }
            $checkSearchEmailIdRoleAssign = 0;
            for ($i=0; $i < $maxRole ; $i++) 
            {
                $playerEmail= $this -> input -> post('TEAM_A_PLAYER_EMAIL'.$i);
                $userRegisteredDtls = $this -> Joingame_model->checkEmailIdRegistered($playerEmail);
                if(empty($userRegisteredDtls))
                {
                    $this->session->set_flashdata('role_add_msg', '<div class="alert alert-danger text-center">'.$playerEmail .' is not Registred. Please Signup with this email Id Before Forming the team.</div>');
                    redirect('modify-role/add/'.$universeToken.'/'.$teamId.'/'.$userId);
                }
                $userAvailableInOtherTeam=$this ->Joingame_model->checkUsersNotInOtherTeam($universeToken,$teamId,$playerEmail);
                
                if(!empty($userAvailableInOtherTeam))
                {
                    $this->session->set_flashdata('role_add_msg', '<div class="alert alert-danger text-center">'.$playerEmail .' is attached to Another Team. Unable to Assign same user for two different Team.</div>');
                    redirect('modify-role/add/'.$universeToken.'/'.$teamId.'/'.$userId);
                    // var_dump($userAvailableInOtherTeam);
                }
                if($playerEmail==$searchEmailId)
                {
                    $checkSearchEmailIdRoleAssign = 1;
                }
            }
            if($checkSearchEmailIdRoleAssign==0)
            {
                $this->session->set_flashdata('role_add_msg', '<div class="alert alert-danger text-center">No Role assigned for '.$searchEmailId .' which used for search.</div>');
                redirect('modify-role/add/'.$universeToken.'/'.$teamId.'/'.$userId);
            }
            $checkTeamIdAvailable = $this ->Joingame_model->getAvailableTeamsInUniverse($universeToken);
            $availableTeamId = $checkTeamIdAvailable[0]->TEAM_ID;
            
            $this->db-> trans_begin(); 
            if($availableTeamId==$teamId)
            {
                for ($i=0; $i < $maxRole ; $i++) 
                {
                    $PlayerEmail= $this -> input -> post('TEAM_A_PLAYER_EMAIL'.$i);
                    $userDtls = $this ->Joingame_model->checkEmailIdRegistered($PlayerEmail);
                    $userId = $userDtls[0]->USER_ID;
                    $checkUserJoinnedUniverse = $this ->Joingame_model->checkuserAvailableInUniverse($universeToken,$PlayerEmail);
                    
                    if(empty($checkUserJoinnedUniverse))
                    {
                        // insert data in univserse table.
                        $universeLobbyId=$this ->Joingame_model->insertUniverseLobbyTbl($batchId,$userId);
                        $roleMasterDtls = $this -> Joingame_model -> getRoleDetailsFromMstr($roleName[$i]);
                        $roleIdRequested=$roleMasterDtls[0]->DEPARTMENT_ID;
                        $this ->Joingame_model->insertUniverseLobbyUserRoleMap($universeLobbyId,$roleIdRequested);
                    }
                    if($roleName[$i]=='IT')
                    {
                        $roleDtls = $this ->Gamemasters_model->getDepartmentIdForTeamIdDeptName($teamId, 'STG');
                        $roleId = $roleDtls[0]['DEPARTMENT_ID'];
                        $this->Gamemasters_model ->insertTeamUserRoleMaptbl($teamId, $userId, $roleId);
                    }
                    $roleDtls = $this ->Gamemasters_model->getDepartmentIdForTeamIdDeptName($teamId, $roleName[$i]);
                    $roleId = $roleDtls[0]['DEPARTMENT_ID'];
                    $this->Gamemasters_model ->insertTeamUserRoleMaptbl($teamId, $userId, $roleId);
                    
                }
                $this-> Joingame_model ->updateLogoNameForTeam($this -> input -> post('TEAM_A_NAME'), $teamId);
            }
            else 
            {
                $this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">No Room to Join. Please Contact Admin / Trainer. </div>');
                redirect('modify-role');
                
            }
            $error = $this->db-> error();
            if ( $this->db-> trans_status() === FALSE)
            {
                $this->db-> trans_rollback();
                $this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">(unknown Error) Unable to Join. Please Contact Admin / Trainer. </div>');
                redirect('modify-role');
            
            }
            else
            {
                $this->db-> trans_commit();
                $this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Role Assigned and Company Setup Completed. </div>');
                redirect('modify-role');
                
            }
        
        }        
        $data['_view'] = 'admin/userrole_add_view';
        $data['_navview'] = 'nav_view';
        $this->load->view('layouts/main_view', $data);
       
        // $params = array(
                // 'SUPPORT_TYPE_ID' => $this->input->post('SUPPORT_TYPE_ID'),
                // 'SUPPORT_STATUS_ID' => $this->input->post('SUPPORT_STATUS_ID_HIDE'),
                // 'SUPPORT_RAISED_BY' => $this->input->post('SUPPORT_RAISED_BY_HIDE'),
                // 'SUPPORT_DESC' => ($this->security->xss_clean($this->input->post('SUPPORT_DESC'))),
                // 'ATTACHMENT_PATH' => $this->input->post('ATTACHMENT_PATH'),
                // 'BUILD_TYPE' => $this->input->post('SUPPORT_BUILD_ID')
            // );
        
    }
    function userRoleEdit($universeToken,$teamId)
    {
         $this -> load -> model('Game_model');
         $this -> load -> model('Gamemasters_model');
         
        $data['universeToken'] = $universeToken;
        $data['teamId']=$teamId;
        $data['teamDtls']=$this->Game_model -> teamuserRoleMapping($teamId);
        $data['teamName']=$this->Gamemasters_model->getTeamDtlsForTeamId($teamId);
       
       
        $data['_view'] = 'admin/userrole_edit_view';
        $data['_navview'] = 'nav_view';
        $this->load->view('layouts/main_view', $data);
    }
    function updateRole()
    {
        $teamId=$this -> input -> post('teamId');
        $universeToken=$this -> input -> post('universe');
      
        $email=$_POST['emailID'];
        $rolemapId=$_POST['rolemapId'];
        $roles=$_POST['rolemapId'];
     //  $deptId=$_POST['roleId'];
        $this -> load -> model('Game_model');
        $this -> load -> model('Gamemasters_model');
        $this -> load -> model('Joingame_model');
        $this -> load -> model('User_model');
        
        $gameDtls = $this ->Joingame_model->fetchGameTypeUsingUniverseToken($universeToken);
        $batchId= $gameDtls[0]->GAME_BATCH_ID;
        
        $companyName=$this -> input -> post('companyName');
        $companyNameAvailableDtls=$this->Gamemasters_model ->getTeamsForTeamNameandID($companyName,$teamId);
        if(count($companyNameAvailableDtls)>0)
        {
            $this->session->set_flashdata('role_edit_msg', '<div class="alert alert-danger text-center">Company Name Already Exist. Please Try with Different Name</div>');
            redirect('modify-role/edit/'.$universeToken.'/'.$teamId);
        }
        foreach($email as $e)
        {
            $flag=FALSE;
            foreach($roles as $r)
            {
                $this -> load -> model('User_model');
                $checkuserregister = $this -> User_model -> getUserDetailsByEmail($e);
                if(count($checkuserregister)>0)
                {
                    $checkuser=$this->Game_model -> checkusersroleinuniverse($universeToken,$teamId,$e);
                    if(count($checkuser)>0)
                    {
                        $this->session->set_flashdata('role_edit_msg', '<div class="alert alert-danger text-center">'.$e .' is attached to Another Team. Unable to Assign same user for two different Team.</div>');
                        redirect('modify-role/edit/'.$universeToken.'/'.$teamId);
                    } 
                    else 
                    {
                        $removed = array_shift($roles);
                        break;
                    }
                }
                else
                {
                    $this->session->set_flashdata('role_edit_msg',  '<div class="alert alert-danger text-center">'.$e .' is not Registred. Please Signup with this email Id Before Forming the team.</div>');
                    redirect('modify-role/edit/'.$universeToken.'/'.$teamId);
                }
            }
        }
        $this->db-> trans_begin(); 
        foreach($email as $e)
        {
            foreach($rolemapId as $r)
            {
                $userDtls = $this -> User_model -> getUserDetailsByEmail($e);
                $userId=$userDtls[0]->USER_ID;
                $teamroleMap = $this ->Gamemasters_model ->getRoleIdFromTeamMap($r);
                $RoleDtls = $this -> Gamemasters_model ->getRoleDetailsGameMstrForID($teamroleMap[0]['ROLE_ID'],$teamId);
                $checkUserJoinnedUniverse = $this ->Joingame_model->checkuserAvailableInUniverse($universeToken,$e);
                    
                if(empty($checkUserJoinnedUniverse))
                {
                        // insert data in univserse table.
                        $universeLobbyId=$this ->Joingame_model->insertUniverseLobbyTbl($batchId,$userId);
                        $roleMasterDtls = $this -> Joingame_model -> getRoleDetailsFromMstr($RoleDtls[0]->DEPARTMENT_NAME);
                        $roleIdRequested=$roleMasterDtls[0]->DEPARTMENT_ID;
                        $this ->Joingame_model->insertUniverseLobbyUserRoleMap($universeLobbyId,$roleIdRequested);
                }
                if($RoleDtls[0]->DEPARTMENT_NAME=='IT')
                {
                    $roleDtlsId =$this -> Gamemasters_model ->getRoleDetailsGameMstrForRole('STG',$teamId);
                    $roleId = $this -> Gamemasters_model ->getTeammapIdforRoleId($roleDtlsId[0]->DEPARTMENT_ID);
                    $this -> Game_model -> updateuserrole($roleId[0]['TEAM_USER_ROLE_MAPPING_ID'],$userId);
                }
                $this -> Game_model -> updateuserrole($r,$userId);
                $removed = array_shift($rolemapId);
                break;
            }
        }
        $this-> Joingame_model ->updateLogoNameForTeam($companyName, $teamId);
          
        $error = $this->db-> error();
        if ( $this->db-> trans_status() === FALSE)
        {
            $this->db-> trans_rollback();
            $this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">(unknown Error) Unable to Join. Please Contact Admin / Trainer. </div>');
            redirect('modify-role');
        }
        else
        {
            $this->db-> trans_commit();
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Role Assigned and Company Setup Completed. </div>');
            redirect('modify-role');
        }
    }
    function userRoleDisplayForTeamInterChange()
    {
        // created by : Leela
        // modified by : Leela
        
        $this -> load -> model('stratup/Game_batch_tbl_model');
        $this -> load -> model('Joingame_model');
        $this -> load -> model('Game_model');
         
        $universeToken = $this -> input -> post('universeToken');
        
        $emailId[0] = $this -> input -> post('emailIdFrom');
        $emailId[1] = $this -> input -> post('emailIdTo');
        
        $this -> form_validation -> set_rules('universeToken', 'Universe Token', 'trim|required');
        $this -> form_validation -> set_rules('emailIdFrom', 'Email ID', 'trim|required');
        $this -> form_validation -> set_rules('emailIdTo', 'Email ID', 'trim|required');
        if ($this -> form_validation -> run())
        {
            $game_batch_tbl = $this->Game_batch_tbl_model -> get_game_batch_tbl_foruniverse($universeToken);
                if(empty($game_batch_tbl))
                {
                    $this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Universe Token does not match.</div>');
                    redirect('Manage_user_product/userRoleDisplayForTeamInterChange');
                }
            for($i=0;$i<=1;$i++)
            {
                $validUser = $this->Joingame_model -> checkEmailIdRegistered($emailId[$i]);
                if(empty($validUser))
                {
                    $this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Email'.$i. 'ID NOT Registered.</div>');
                    redirect('Manage_user_product/userRoleDisplayForTeamInterChange');
                }
                $teamIdDtls = $this ->Joingame_model->getTeamForUserInUniverse($universeToken,$emailId[$i]);
                if(empty($teamIdDtls))
                {
                    $data['teamInfos'][$i] = array("USER_NAME"=>"","EMAIL_ID"=>"","DEPARTMENT_NAME"=>"");
                }
                else 
                {
                    $data['teamId'][$i] = array_column($teamIdDtls, 'TEAM_ID');
                    // var_dump($data);
                    $teamInfos=$this->Game_model ->getPlayerInfoForTeamId($data['teamId'][$i][0]);
                    $data['teamInfos'][$i] = $teamInfos;
                    // var_dump($data);
                }
            }
        }
        //$data['universeToken'] = $universeToken;
        //$data['emailId'] = $emailId;
        $data['_view'] = 'admin/userroledisplayForTeamChange_view';
        $data['_navview'] = 'nav_view';
        $this->load->view('layouts/main_view', $data);
    }
    function userRoleEditDisplayForTeamInterChange($universeToken,$teamIdfrom,$teamIdTo)
    {
        // created by : Ashwini
        // modified by : 
        
        $this -> load -> model('stratup/Game_batch_tbl_model');
        $this -> load -> model('Joingame_model');
        $this -> load -> model('Game_model');
         
        //$universeToken = $this -> input -> post('universeToken');
        
        $teamId[0] = $teamIdfrom;
        $teamId[1] = $teamIdTo;
        
       
            $game_batch_tbl = $this->Game_batch_tbl_model -> get_game_batch_tbl_foruniverse($universeToken);
              
            for($i=0;$i<=1;$i++)
            {
              //  $teamIdDtls = $this ->Joingame_model->getTeamForUserInUniverse($universeToken,$emailId[$i]);
                //if(empty($teamIdDtls))
                //{
                  //  $data['teamInfos'][$i] = array("USER_NAME"=>"","EMAIL_ID"=>"","DEPARTMENT_NAME"=>"");
                //}
                //else 
                //{
                    $data['teamId'][$i] = $teamId[$i];
                    // var_dump($data);
                    $teamInfos=$this->Game_model ->getPlayerInfoForTeamId($teamId[$i]);
                    $data['teamInfos'][$i] = $teamInfos;
                    // var_dump($data);
               // }
            }
        
        $data['universeToken'] = $universeToken;
        //$data['emailId'] = $emailId;
        $data['_view'] = 'admin/userroleeditForTeamChange_view';
        $data['_navview'] = 'nav_view';
        $this->load->view('layouts/main_view', $data);
    }
    function clientprodmapping($clientId)
    {
        $this -> load -> model('stratup/Client_mstr_model');
        $client_prod_dtls = $this ->Client_mstr_model-> get_all_product_mapped_for_client($clientId);

        if(count($client_prod_dtls)>0)
        {
            $data['ProductDetails'] = $client_prod_dtls;
        }
        else
        {
            $data['ProductDetails'] = array();
        }
        $data['clientId'] = $clientId;
        $data['_view'] = 'admin/client_prod_map_view';
        $data['_navview'] = 'nav_view';
        $this->load->view('layouts/main_view', $data);
    }
    function updateapprovedlicsforclient()
    {
        $client_prod_map_id = $_POST['clientpromapid'];
        $approvedlics = $_POST['approvedlics']; 
        $this -> load -> model('stratup/Client_mstr_model');
        $client_prod_dtls = $this -> Client_mstr_model -> get_client_prod_dtls_id($client_prod_map_id);
        $preappeovedlics = $client_prod_dtls[0]['APPROVED_NO_OF_LICENSE'];
        $preremaininglics = $client_prod_dtls[0]['REMAINING_NO_OF_LICENSE'];

        if($approvedlics>=$preappeovedlics)
        {
            $diffofapprocedlics = $approvedlics - $preappeovedlics;
            $remaininglics = $preremaininglics + $diffofapprocedlics;
            $this->db-> trans_begin(); 

            $params = array('APPROVED_NO_OF_LICENSE' => $approvedlics,
                            'REMAINING_NO_OF_LICENSE' => $remaininglics );

            $this -> Client_mstr_model ->update_no_of_license($client_prod_map_id,$params);
            $error = $this->db-> error();
            if ( $this->db-> trans_status() === FALSE)
            {
                $this->db-> trans_rollback();
                $data['success'] = false;
                      $data['messages']['msg-clientprod'] = '<div class="alert alert-danger text-center">Oops Something went wrong.</div>';
            }
            else
            {
                $this->db-> trans_commit();
                $data['success'] = true;
                      $data['messages']['msg-clientprod'] = '<div class="alert alert-success text-center">License Updated Successfully.</div>';
            }
        }
        else
        {
            $data['success'] = false;
                  $data['messages']['msg-clientprod'] = '<div class="alert alert-danger text-center">Approved License no is less than previously approved value.</div>';
        }

        echo json_encode($data); 
    }
    function getinfoforaddclientprodmap()
    {
        $clientId = $_POST['clientId']; 
        $this -> load -> model('Gamemasters_model');

        $clientdtls = $this -> Gamemasters_model -> getClientDtlsforId($clientId);
        $stratupType = $this -> Gamemasters_model ->getStratupType();
        $stratupMode = $this -> Gamemasters_model ->getStratupMode();
        $this -> load -> model('stratup/Client_mstr_model');
        $client_prod_dtls = $this ->Client_mstr_model-> get_all_product_mapped_for_client($clientId);

        
            $data['ProductDetails'] = $client_prod_dtls;
        
        $data['clientdtls'] = $clientdtls;
        $data['stratupType'] = $stratupType;
        $data['stratupMode'] = $stratupMode;

        echo json_encode($data);
    }
    function addclientprodmap()
    {
        $data=array();
        $this -> load -> library('form_validation');
        $this -> form_validation -> set_rules('approvedlics', 'Approved License', 'required');
        $this -> form_validation -> set_rules('stratuptype', 'Simulation Type', 'required');
        $this -> form_validation -> set_rules('stratupmode', 'Mode', 'required');
        $this->form_validation->set_error_delimiters('<p class="text-danger">', '</p>');
        $clientId = $this -> input -> post('clientId');
        if ($this -> form_validation -> run() == FALSE)
        {
            foreach ($_POST as $key => $value) 
            {
                $data['messages'][$key] = form_error($key);
            }               
            echo json_encode($data);
        }  
        else
        {
            $this -> load -> model('Gamemasters_model');
            $this -> load -> model('stratup/Client_mstr_model');

            $stratupType = $this -> Gamemasters_model ->getStratupTypebyId($this -> input -> post('stratuptype'));
        $stratupMode = $this -> Gamemasters_model ->getStratupModebyId($this -> input -> post('stratupmode'));
        $client_prod_dtls = $this ->Client_mstr_model-> get_client_prod_for_mode_type($clientId,$stratupMode[0]->STRATUP_MODE,$stratupType[0]->STRATUP_TYPE);

            if(count($client_prod_dtls)>0)
            {

                     $data['messages']['msg-clientprod'] = '<div class="alert alert-danger text-center">'.$stratupType[0]->STRATUP_TYPE .' Simlulation Type and '.$stratupMode[0]->STRATUP_MODE.' Mode Already License is Created</div>';
                              
            }
            else{
                $this->db-> trans_begin(); 
                $params = array('CLIENT_ID' => $clientId,
                            'APPROVED_NO_OF_LICENSE' => $this -> input -> post('approvedlics'),
                            'REMAINING_NO_OF_LICENSE' => $this -> input -> post('approvedlics'),
                            'STRATUP_TYPE_ID' => $this -> input -> post('stratuptype'),
                            'STRATUP_MODE_ID' => $this -> input -> post('stratupmode'));

                $this -> Client_mstr_model ->insert_into_client_prod_map($params);
            $error = $this->db-> error();
            if ( $this->db-> trans_status() === FALSE)
            {
                $this->db-> trans_rollback();
                $data['success'] = false;
                      $data['messages']['msg-clientprod'] = '<div class="alert alert-danger text-center">Oops Something went wrong.</div>';
                       
            }
            else
            {
                $this->db-> trans_commit();
                $data['success'] = true;
                      $data['messages']['msg-clientprod'] = '<div class="alert alert-success text-center">License Approved Successfully.</div>';
                       
            }
            }
            
                  echo json_encode($data);
        }
    }
    function feedbackListForUniverse()
    {
        $this -> load -> model('Game_model');
        $universeToken = $this -> input -> post('universeToken'); 
        if($universeToken != "")
        {
            $data['feedbackDtls']=$this->Game_model -> getuserfeedbackforuniverse($universeToken);
        }        
        $data['_view'] = 'admin/feedback_for_universe';
        $data['_navview'] = 'nav_view';
        $this->load->view('layouts/main_view', $data);
    }

    function userTutorialStatusForUniverse()
    {
        $this -> load -> model('Game_model');
        $universeToken = $this -> input -> post('universeToken'); 
        if($universeToken != "")
        {
            $tutorialStatusWithRole = $this->Game_model -> getusertutorialStatusforuniverse($universeToken);
            foreach($tutorialStatusWithRole as &$tut)
            {
                $decisiondetails = $this->Game_model -> getPlayerInfoForTeamId($tut['TEAM_ID']);
               // var_dump($decisiondetails);
                foreach($decisiondetails as $decision)
                {
                    if($decision['USER_ID'] == $tut['USER_ID'])
                    {
                        $arr = explode(",", $tut['DEPARTMENT_NAME']);
                        //var_dump(count($arr));
                        $deptndecision = "";
                        for($i=0;$i<count($arr);$i++)
                        {
                            $dept = $arr[$i];
                            if($dept == "FIN")
                            {
                                if($deptndecision == '')
                                {
                                    $deptndecision = $dept;
                                }
                                else
                                {
                                    $deptndecision = $deptndecision.', '.$dept;
                                }
                            }
                            else if($decision['DEPARTMENT_NAME'] == $dept)
                            {
                                if($deptndecision == '')
                                {
                                    $deptndecision = $dept.'-'.$decision['DecisionCount'];
                                }
                                else
                                {
                                    $deptndecision = $deptndecision.', '.$dept.'-'.$decision['DecisionCount'];
                                }
                            }                            
                        }
                        if($tut['UNIVERSE_STRATUP_TYPE'] == $tut['STRATUP_TYPE'])
                        {
                            $tut['DEPARTMENT_DECISION'] = $deptndecision;
                        }
                        else
                        {
                            $tut['DEPARTMENT_DECISION'] = '';                            
                        }
                    }
                }
            }
            //var_dump($tutorialStatusWithRole);
            $data['tutorialStatus']=$tutorialStatusWithRole;
        }        
        $data['_view'] = 'admin/tutorial_status_for_universe';
        $data['_navview'] = 'nav_view';
        $this->load->view('layouts/main_view', $data);
    }
}
?>