<?php
class Signup extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this -> load -> helper(array('form', 'url'));
		$this -> load -> library(array('session', 'form_validation'));
        $this->load->library('facebook');
		$this -> load -> database();
		$this -> load -> model('User_model');
		$this->load->library('mailboxvalidator');
	}

	function index()
	{
	     $data=array();
        $errormgs=array();
	    $email_verified_result ='';
		$this-> form_validation->set_message('is_unique', 'The %s is already taken');
		// set form validation rules
		$this -> form_validation -> set_rules('signuptitle', 'Title', 'callback_select_validate|required');
		$this -> form_validation -> set_rules('fname_reg', 'Full Name', 'trim|required|regex_match[ /^[a-zA-Z ]+$/]+|min_length[3]|max_length[30]');
		// $this -> form_validation -> set_rules('email_reg', 'Email', 'trim|required|valid_email|is_unique[user_mstr.Email_ID]');
        $this -> form_validation -> set_rules('email_reg', 'Email', 'callback_is_unique_custom|strtolower');
        $this -> form_validation -> set_rules('mobile_number', 'Mobile Number', 'required|regex_match[/^[0-9]{10}$/]'); //{10} for 10 digits number
		//$this->form_validation->set_rules('password', 'Password', 'trim|required|matches[cpassword]|md5');
		$this -> form_validation -> set_rules('password_reg', 'Password', 'required');
		$this -> form_validation -> set_rules('cpassword_reg', 'Confirm Password', 'required|matches[password_reg]');
        $this -> form_validation -> set_rules('signupoccu', 'Occupation', 'required');
        $this -> form_validation -> set_rules('signuporg', 'Organiation', 'required');
        $this -> form_validation -> set_rules('signuploca','Location','required');
        $this->form_validation->set_error_delimiters('<p class="text-danger">', '</p>');
        
        //Temporarily removed email verification for International Client 
        //$email_verified_result = $this->mailboxvalidator->get_single_result($this -> input -> post('email_reg'));
        // echo $result->is_verified;
        // submit
        if ($this -> form_validation -> run() == FALSE)
        {
            foreach ($_POST as $key => $value) 
            {
                $data['messages'][$key] = form_error($key);
            }               
            echo json_encode($data);
        }       
        
        //elseif($email_verified_result->is_verified == 'False')
       // {
        //    $data['messages']['email_reg'] = '<div class="alert alert-danger text-center">Oops! Entered Email Id is not valid. Please try again with valid Email Id</div>';
        //    echo json_encode($data);
       // }
        else{

            $this -> load -> model('Gamemasters_model');
        $occupation=$this -> Gamemasters_model -> getOccupationMstr();
        $checkoccu=array();
        foreach($occupation as $occ)
        {
            array_push($checkoccu,$occ['OCCUPATION_ID']);
        }
        
        
        $organisation=$this -> Gamemasters_model -> getUserOrganisationMstr();
        $checkorg=array('00');
        foreach($organisation as $org)
        {
            array_push($checkorg,$org['ORGANISATION_ID']);
        }
           
        $location=$this -> Gamemasters_model -> getUserLocationMstr();
        $checkloc=array();
        foreach($location as $loc)
        {
            array_push($checkloc,$loc['LOCATION_ID']);
        }
        if(!in_array($_POST['signupoccu'], $checkoccu))
        {
             $errormgs['signupoccu']= '<p class="text-danger">Select occupation from the list!</p>';
            //$data['messages']['signupoccu'] = '<p class="text-danger">Select occupation from the list!</p>';
            //echo json_encode($data); 
        }
        if(!in_array($_POST['signuporg'], $checkorg))
        {
            $errormgs['signuporg']= '<p class="text-danger">Select organisation from the list!</p>';
            //$data['messages']['signuporg'] = '<p class="text-danger">Select organisation from the list!</p>';
            //echo json_encode($data); 
        }
        if(!in_array($_POST['signuploca'], $checkloc))
        {
            $errormgs['signuploca']= '<p class="text-danger">Select location from the list!</p>';
           // $data['messages']['signuploca'] = '<p class="text-danger">Select location from the list!</p>';
            //echo json_encode($data); 
        }
        if(count($errormgs)>0)
        {
         foreach ($errormgs as $key => $value) 
            {
                $data['messages'][$key] = $value;
            }               
            echo json_encode($data);
        }
        else
        {
            $gender='Female';
            if($this -> input -> post('signuptitle')=='Mr.')
            {
                $gender='Male';
            }
            $randomNum = rand(1,20);
            $image="PP".$randomNum;
            $data = array(
                            'TITLE'  => $this -> input -> post('signuptitle'),
                            'LOGIN_ID' => $this -> input -> post('email_reg'),
                            'FIRST_NAME' => $this -> input -> post('fname_reg'), 
                            'EMAIL_ID' => $this -> input -> post('email_reg'), 
                            'PASSWORD' => $this -> input -> post('password_reg'),
                            'GENDER' => $gender,
                            'EMAIL_VERIFIED' => '1',
                            // 'EMAIL_VERIFY_TOKEN' => $this->emailToken(),
                            'USER_TYPE_ID' => '3',
                            'OCCUATION_ID' => $this -> input -> post('signupoccu'),
                            'ORGANISATION_ID' => $this -> input -> post('signuporg'),
                            'COMAPANY_NAME' => $this -> input -> post('signuporgname'),
                            'LOCATION_ID' => $this -> input -> post('signuploca'),
                            'MOBILE_NO' => $this -> input -> post('mobile_number'),
                            'PROFILE_PIC_PATH' => 'resources/img/users/PlayerProfileIcons/'.$image.'.png'
                         );
            $this->db-> trans_begin();
            $checkUser = $this -> User_model -> getUserDetailsByEmail($this -> input -> post('email_reg'));
            if(count($checkUser)>0)
            {
                $data['messages']['msg'] = '<div class="alert alert-danger text-center">EmailId Already Exists.If you forgot your password Click on Retrive Here to get your password.</div>';
                echo json_encode($data);
            }
            else
            {
                $newUserId = $this -> User_model -> add_user_mstr($data);
                $defaultWorkspace = $this -> User_model -> getWorkspaceForClientByClientName("PROCESSBEE");
                foreach ($defaultWorkspace as $workspace) 
                {
                    $userWorkspaceParam = array('USER_ID' => $newUserId,
                                                'WS_ID' => $workspace->WS_ID,
                                                'VALID_FROM' => $workspace->VALID_FROM,
                                                'VALID_TO' => $workspace->VALID_TO);
                    $this -> User_model -> insertWorkspaceForUser($userWorkspaceParam);
                }
            }
            if ($this->db->trans_status() === FALSE)
            {
                $this->db->trans_rollback();
                //redirect('Signup');
                $data['messages']['msg'] = '<div class="alert alert-danger text-center">Oops! Something went wrong. Please try again</div>';
                echo json_encode($data);
            }
            else
            {
                $this->db->trans_commit();
                // redirect('Signup');
                $userDtls = $this->User_model->get_user_by_id($newUserId);
                $sess_data = array('login' => TRUE, 
                                   'uname' => $this -> input -> post('fname_reg'),
                                   'uid' => $newUserId,
                                   'emailid' => $this -> input -> post('email_reg'),
                                   'usertypeid'=>'3',
                                   'uimage'=>'resources/img/blank_user.png',
                                   'utype'=>$userDtls[0]->USER_TYPE_NAME
                                  );
                $this->session->set_userdata($sess_data);
                // $this->session->mark_as_temp('login', 300);
                //echo $this->db->last_query();
                // redirect("login");
                //$this ->sendmail($data['EMAIL_ID'],$data['FIRST_NAME'],$data['LOGIN_ID'],$data['EMAIL_VERIFY_TOKEN']);
                $data['success'] = true;
                echo json_encode($data);
            }
        }
        }        
	}
    function ValidateSection()
    {
         $email_verified_result ='';
        $this->form_validation->set_message('is_unique', 'The %s is already taken');
        // set form validation rules
        $this -> form_validation -> set_rules('signuptitle', 'Title', 'callback_select_validate|required');
        $this -> form_validation -> set_rules('fname_reg', 'Full Name', 'trim|required|regex_match[ /^[a-zA-Z ]+$/]+|min_length[3]|max_length[30]');
        // $this -> form_validation -> set_rules('email_reg', 'Email', 'trim|required|valid_email|is_unique[user_mstr.Email_ID]');
        $this -> form_validation -> set_rules('email_reg', 'Email', 'callback_is_unique_custom|strtolower');
        $this -> form_validation -> set_rules('mobile_number', 'Mobile Number', 'required|regex_match[/^[0-9]{10}$/]'); //{10} for 10 digits number
        //$this->form_validation->set_rules('password', 'Password', 'trim|required|matches[cpassword]|md5');
        $this -> form_validation -> set_rules('password_reg', 'Password', 'required');
        $this -> form_validation -> set_rules('cpassword_reg', 'Confirm Password', 'required|matches[password_reg]');
        $this->form_validation->set_error_delimiters('<p class="text-danger">', '</p>');
        
        //Temporarily removed email verification for international Client 
        //$email_verified_result = $this->mailboxvalidator->get_single_result($this -> input -> post('email_reg'));
        // echo $result->is_verified;
        // submit
        if ($this -> form_validation -> run() == FALSE)
        {
            // fails
            foreach ($_POST as $key => $value) 
                {
                    $data['messages'][$key] = form_error($key);
                }               
                echo json_encode($data);
        }
        //Temporarily removed email verification for international Client 
        //elseif($email_verified_result->is_verified == 'False')
        //{
        //    $data['messages']['email_reg'] = '<div class="alert alert-danger text-center">Oops! Entered Email Id is not valid. Please try again with valid Email Id</div>';
        //    echo json_encode($data);
       // }
        else {
        	  $data['success'] = true;
              echo json_encode($data);
        }
    }

	function select_validate($selectValue)
	{
		// 'none' is the first option and the text says something like "-Choose one-"
		if (empty($selectValue))
		{
			$this -> form_validation -> set_message('select_validate', 'Please Select.');
			return false;
		}
		else// user picked something
		{
			return true;
		}
	}
    function CCode_valid($clientcode)
    {
        if (empty($clientcode))
        {
            $this -> form_validation -> set_message('CCode_valid', 'The Client Code field is required.');
            return false;
        }
        else 
        {
            $data = $this -> User_model -> checkClientCodeForUserRegister($clientcode);
            if (empty($data))
            {
                $this -> form_validation -> set_message('CCode_valid', 'Not a Valid Client Code.');
                return false;
            }
            else// user picked something
            {
                return true;
            }
        }
        
    }

    function sendmail($toemail,$userfullname,$userid,$passwd)
    {
        $this->load->library('email'); // load email library
        $this->email->from(supportMailId);
        $this->email->to($toemail);
        $this->email->cc(''); 
        $this->email->subject('Bizgames Account Verification');
        $this->email->message('<p><span style="font-family:Arial,Helvetica,sans-serif">Hello '.$userfullname.',</span></p>

                                <p>Thank you for registering with Bizgames. Your account is created and must be activated before you can use it.</br>
								To activate the account <a href="'.base_url().'index.php/Signup/verifyEmail?loginId='.$userid.'&hash='.$passwd.'">Click Here</a> or copy-paste the below link in your browser:</p>

                                <p>'.base_url().'index.php/Signup/verifyEmail?loginId='.$userid.'&hash='.$passwd.'</p>

                                <p>After activation you may login using the following username:
                                
                                <p>Your Login ID : '.$userid.'</p>
                                
                                <p>Your Email ID : '.$toemail.'</p>
                                
                                
                                <p>&nbsp;</p>
                                
                                <p>Thanks,</p>
                                
                                <p>Team Bizgames</p>');
        // $this->email->attach('/path/to/file1.png'); // attach file
        // $this->email->attach('/path/to/file2.pdf');
        if ($this->email->send())
        {
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-center"> We have sent your Login Credential to your e-MailID <br /> Please <a href="'.base_url().'"/login/index.php">Click Here</a> to Login</div>');
            //echo "Mail Sent!";
        }
        else
        {
            // $this->session->set_flashdata('msg', '<div class="alert alert-success text-center">We cant find your email address</div>');
            show_error($this->email->print_debugger());
        }
            
    }
    function generate_key_string($char,$segment) 
    {
        // Modified by : Leela
        // Modified on : 26-02-2018
        // function to create random String
        $tokens = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
        
        // $segment_chars = 8;
        // $num_segments = 1;
        $segment_chars = $char;
        $num_segments = $segment;
        $key_string = '';
        for ($i = 0; $i < $num_segments; $i++) 
        {
            $segment = '';
            for ($j = 0; $j < $segment_chars; $j++) 
            {
                $segment .= $tokens[rand(0, strlen($tokens)-1)];
            }
            $key_string .= $segment;

             if ($i < ($num_segments - 1)) 
             {
                 $key_string .= '-';
             }
        }
        return $key_string;
    }
    function emailToken()
    {
        // function to check duplicate token
        do
        {
            $emailToken = $this -> generate_key_string(16,1);
            $result = $this -> User_model -> getEmailToken($emailToken);
        }
        while ($result != false);
        return $emailToken;
    }
    function verifyEmail()
    {
        $loginId = $_GET['loginId'];
        $token = $_GET['hash'];

        // function to verify new user and update Email Verified
         $data = $this->User_model->verifyEmailToken($loginId,$token);
         if(!$data)
         {
             $this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Email Verification Failed. Please ensure the link you have entered is correct. </div>');
             $this -> load -> view('message_view');
         }
         else  
         {
             if($data[0]['EMAIL_VERIFIED']==1)
             {
                 $this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Email has been verified successfully.</br> <a href="'.base_url().'">Click Here to Login</a></div>');
                 $this -> load -> view('message_view');
             }
             else 
             {
                 $this->User_model->upateVerifiedUser($data[0]['USER_ID']);
                 $this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Email has been verified successfully.</br> <a href="'.base_url().'">Click Here to Login</a></div>');
                 $this -> load -> view('message_view');
             }
             
         }
    }
public function facebookLogin(){
        $userData = array();
        $this -> load -> model('User_model');
        // Check if user is logged in
        if($this->facebook->is_authenticated()){
            // Get user facebook profile details
            $fbUserProfile = $this->facebook->request('get', '/me?fields=id,first_name,last_name,email,link,gender,locale,cover,picture');

            // Preparing data for database insertion
            // $userData['oauth_provider'] = 'facebook';
            // $userData['oauth_uid'] = $fbUserProfile['id'];
            // $userData['first_name'] = $fbUserProfile['first_name'];
            // $userData['last_name'] = $fbUserProfile['last_name'];
            // $userData['email'] = $fbUserProfile['email'];
           // $userData['gender'] = '';
           // $userData['locale'] = '';
            // $userData['cover'] = '';
           // $userData['picture'] = $fbUserProfile['picture']['data']['url'];
           // $userData['link'] = '';
            $userData['first_name'] = $fbUserProfile['first_name'];
            $userData['last_name'] = $fbUserProfile['last_name'];
            $userData['EMAIL_ID'] = $fbUserProfile['email'];
           $userData['gender'] = '';
           $userData['PROFILE_PIC_PATH'] = $fbUserProfile['picture']['data']['url'];
           $userData['EMAIL_VERIFY_TOKEN'] = $this->emailToken();
           $userData['USER_TYPE_ID'] = 3;
           
            // Insert or update user data
            $userID = $this->checkUser($userData);
            
            // Check user data insert or update status
            if(!empty($userID)){
                 $sess_data = array('login' => TRUE, 
                                        'uname' => $userData['first_name'],
                                        'uid' => $userID,
                                        'emailid' => $userData['EMAIL_ID'],
                                        'usertypeid'=>$userData['USER_TYPE_ID'],
                                        'uimage'=>$userData['PROFILE_PIC_PATH']
                                        );
                    $this->session->set_userdata($sess_data);
                    // $this->session->mark_as_temp('login', 300);
                    //echo $this->db->last_query();
                    // redirect("login");
                    $data['success'] = true;
                  //  echo json_encode($data);
                // $data['userData'] = $userData;
                // $this->session->set_userdata('userData',$userData);
            }else{
                 $userData['CREATED_ON']  = date("Y-m-d H:i:s");
                $userData['MODIFIED_ON'] = date("Y-m-d H:i:s");
              //  $insert = $this->db->insert($this->tableName,$userData);
                $insert = $this -> User_model -> add_user_mstr($userData);
             //  $data['userData'] = array();
              $userID = $this->db->insert_id();
            }
            
            // Get logout URL
            $data['logoutURL'] = $this->facebook->logout_url();
        }else{
            // Get login URL
            $data['authURL'] =  $this->facebook->login_url();
        }
        
        // Load login & profile view
      //  $this->load->view('user_authentication/index',$data);
     redirect('/login/');
    }
  function checkUser($userData = array()){
        if(!empty($userData)){
            //check whether user data already exists in database with same oauth info
           $prevCheck= $this -> User_model ->getUserDetailsByEmail($userData['EMAIL_ID']);
            //$prevCheck = $prevQuery->num_rows();
            
            if(sizeof($prevCheck) > 0){
               // $prevResult = $prevQuery->row_array();
                
                // //update user data
                // $userData['MODIFIED_ON'] = date("Y-m-d H:i:s");
                // $update = $this->db->update($this->tableName,$userData,array('USER_ID'=>$prevResult['USER_ID']));
//                 
                //get user ID
                $userID = $prevCheck[0]->USER_ID;
            }else{
                //insert user data
                $userData['CREATED_ON']  = date("Y-m-d H:i:s");
                $userData['MODIFIED_ON'] = date("Y-m-d H:i:s");
              //  $insert = $this->db->insert($this->tableName,$userData);
                $userID = $this -> User_model -> add_user_mstr($userData);
                //get user ID
                //$userID = $this->db->insert_id();
            }
        }
        
        //return user ID
        return $userID;
    }
	function is_unique_custom($emaiId)
	{
		// $username recieves the parameter automatically
	    //Go on with your query as bellow
	    if(empty($emaiId))
		{
			$this -> form_validation->set_message('is_unique_custom','The Email ID field is required.');
			return FALSE;
		}
		else 
		{
			$data = $this -> User_model ->getUserDetailsByEmail($emaiId);
		}
		if(!empty($data))
		{
			$this -> form_validation->set_message('is_unique_custom','This Email ID already registered.');
			return FALSE;
		}
		else 
		{
			return TRUE;
		}
	    
	}
}
