<?php
include (APPPATH . 'libraries/REST_Controller.php');
class DialogueService extends REST_Controller
{
		public function __construct() {
		parent::__construct();
		$this -> load -> model('Dialogueservice_model');
		}

	function computerStatements_get()
	{
		$this -> load -> model('Dialogueservice_model');
		$data = $this -> Dialogueservice_model -> getComputerStatements();
		$this -> response(json_decode(json_encode($data),true), 200);
	}
	
	function insertComputerStatements_get()
	{
		$statement = $this -> get('statement');
		$this -> load -> model('Dialogueservice_model');
		$data = $this -> Dialogueservice_model -> insertComputerStatements($statement);
		$this -> response("SUCCESS", 200);
	}
	
	function updateComputerStatements_get()
	{
		$statement = $this -> get('statement');
		$stmtcode = $this -> get('stmtcode');
		$this -> load -> model('Dialogueservice_model');
		$data = $this -> Dialogueservice_model -> updateComputerStatements($statement,$stmtcode);
		$this -> response("SUCCESS", 200);
	}
	
	function getCompPlayStatementsForTrigger_get()
	{
		$compstmtcode = $this -> get('compstmtcode');
		$this -> load -> model('Dialogueservice_model');
		$data = $this -> Dialogueservice_model -> getCompPlayStatementsForTrigger($compstmtcode);
		$this -> response($data, 200);
	}
	
	private function formatJsonToSql($categories)
	{	
		(array) $responsedata = (array) json_decode($categories);
		$in = "";
        $i=0;
        foreach ($responsedata as $condition)
        {
            if ($i!=0)
			{
				$in = $in.",";
			}
            $in = $in.$condition;
            $i++;
        }
		
		return $in;
	}
	
	function categorywiseCondnCompStmtsForPlayer_get()
	{
		//For Training List
		//$categories = '{"1":"GAME=STRATUP","2":"ROLE=HR","3":"MOVE_NO<35"}';
		$categories = $this -> get('categories');
        $this -> load -> model('Dialogueservice_model');
		$in = $this-> formatJsonToSql($categories);
        $data = $this -> Dialogueservice_model -> categorywiseCondnCompStmtsForPlayer($in);
		$compplaystmtsarray[] = '';
		if(empty($data))
		{
			$compplaystmtsarray = array();
		}
		else
		{
			foreach ($data as $compstmtcode)
	        {
	            $compplaystmts = $this -> Dialogueservice_model -> getCompPlayStatementsForTrigger($compstmtcode -> COMP_STMT_CODE);
				if ($compplaystmtsarray [0] == '')
				{
					$compplaystmtsarray = $compplaystmts;
				}
				else
				{
					foreach ($compplaystmts as $row) 
					{
						array_push($compplaystmtsarray,$row);
					}
				}
	        }
		}
        
        $this -> response($compplaystmtsarray, 200);
	}
	
	function getCompStmtsForGame_get()
	{
		//$categories = '{"1":"GAME=STRATUP","2":"ROLE=HR","3":"MOVE_NO<35"}';
		//$mode	= 'SUMMARY'; (Applicable Values - SUMMARY / DETAIL);
		//$status	= 'PENDING'; (Applicable Values - COMPLETED / PENDING);
		//$compStmtType = 'CONV'; (Applicable Values - CONV / TASK / EMAIL / IMAG/VIDEO);
		$categories = $this -> get('categories');
		$mode = $this -> get('mode');
		$status = $this -> get('status');
		$ugsStatusId = $this -> get('ugsStatusId');
		$compStmtType = $this -> get('compStmtType');
		$in = $this -> formatJsonToSql($categories);		
        $this -> load -> model('Dialogueservice_model');
        $data = $this -> Dialogueservice_model -> getCompStmtsForGame($in,$mode,$status,$ugsStatusId,$compStmtType);
        $this -> response($data, 200);
	}
	
	function answerwiseCompStmtsForPlayer_get()
	{
		$answer = $this -> get('answer');		
		$this -> load -> model('Dialogueservice_model');
		$data = $this -> Dialogueservice_model -> answerwiseCompStmtsForPlayer($answer);		
		foreach ($data as $compstmtcode)
		{
			$compplaystmts =  $this -> Dialogueservice_model -> getCompPlayStatementsForTrigger($compstmtcode -> DESTN_COMP_STMT_CODE);
		}
		$this -> response($compplaystmts, 200);
	}
	
	function triggerEvent_get()
	{	
		$this -> load -> model('Dialogueservice_model');
		
		$compstmtcode = $this -> get('compstmtcode');
		$playstmtcode = $this -> get('playstmtcode');
		$ugsStatusId = $this -> get('ugsStatusId');
		$playEntry1 = $this -> get('playEntry1');	
		
		$compplaystmts = array();
		
		if ($playstmtcode == '')
		{
			if($playEntry1 != '')
			{
				//If user sends free text as response, just record the response
				$this -> Dialogueservice_model -> insertActions($compstmtcode, $playstmtcode, $ugsStatusId, $playEntry1);
			}
			else
			{
				//If this webservice is called for the first time
				$compplaystmts = $this -> Dialogueservice_model -> getCompPlayStatementsForTrigger($compstmtcode);
			}	
		}
		else
		{
			//If $playstmtcode is not empty
			$stmtcode = $this -> Dialogueservice_model -> answerwiseCompStmtsForPlayer($playstmtcode);
			$data = $this -> Dialogueservice_model -> insertActions($compstmtcode, $playstmtcode, $ugsStatusId, $playEntry1);
			$this -> calculatePoints($playstmtcode,$ugsStatusId);
			$compplaystmts = $this -> Dialogueservice_model -> getCompPlayStatementsForTrigger($stmtcode[0] -> DESTN_COMP_STMT_CODE);	
		}
		$this -> response($compplaystmts, 200);
	}
	
	function descwiseCompStmtsForPlayer_get()
	{
		//To get Destination Computer Statement Codes a given question and predefined answer desc
		//For Invoking ask shireen from Training List
		$compstmtcode = $this -> get('compstmtcode');		
		$answerdesc = $this -> get('answerdesc');		
		$this -> load -> model('Dialogueservice_model');
		$data = $this -> Dialogueservice_model -> descwiseCompStmtsForPlayer($compstmtcode,$answerdesc);		
		$compplaystmts = '';
		foreach ($data as $compstmtcode)
		{
			$compplaystmts =  $this -> Dialogueservice_model -> getCompPlayStatementsForTrigger($compstmtcode -> DESTN_COMP_STMT_CODE);
		}
		$this -> response($compplaystmts, 200);
	}
	
	
	function insertActions_get()
	{
		//For Training List. When and action is completed, insert in to this table
		$compstatement = $this -> get('compstatement');		
		$playstatement = $this -> get('playstatement');			
		$ugsStatusId = $this -> get('ugsStatusId');				
		$playEntry1 = $this -> get('playEntry1');	
		$this -> load -> model('Dialogueservice_model');
		$data = $this -> Dialogueservice_model -> insertActions($compstatement,$playstatement,$ugsStatusId,$playEntry1);
		$this -> response("SUCCESS", 200);
	}
	
	function calculatePoints_get()
	{
		$answer = $this -> get('answer');			
		$ugsStatusId = $this -> get('ugsStatusId');			
		$this -> load -> model('Dialogueservice_model');
		$this -> calculatePoints($answer,$ugsStatusId);
		$this -> response($data, 200);		
	}
	
	private function calculatePoints($playstmtcode,$ugsStatusId)
	{
		//If first point for the current game then insert else update existing points data
		$isPoints = $this -> Dialogueservice_model -> isPointsInitiated($playstmtcode,$ugsStatusId);
		$isnewPoints = $isPoints [0] -> ISPOINTS;
		if ($isnewPoints  == "FALSE")
			$data = $this -> Dialogueservice_model -> insertPoints($playstmtcode,$ugsStatusId);
		else
			$data = $this -> Dialogueservice_model -> updatePoints($playstmtcode,$ugsStatusId);		
		return $data;
	}
	
	function getPlayerPointsForGame_get()
	{	
		$ugsStatusId = $this -> get('ugsStatusId');			
		$this -> load -> model('Dialogueservice_model');
		$data = $this -> Dialogueservice_model -> getPlayerPointsForGame($ugsStatusId);
		$this -> response($data, 200);
	}
	
	function getPointsForAnswer_get()
	{
		$answer = $this -> get('answer');				
		$this -> load -> model('Dialogueservice_model');
		$data = $this -> Dialogueservice_model -> getPointsForAnswer($answer);
		$this -> response($data, 200);
	}
	
	function getBotSuggestions_get()
	{
		$searchtext = $this -> get('searchtext');				
		$this -> load -> model('Dialogueservice_model');
		$data = $this -> Dialogueservice_model -> getBotSuggestions($searchtext);
		$this -> response($data, 200);
	}
	
	function getTimeAvailableForCurrentGame_get()
	{
		$ugsStatusId = $this -> get('ugsStatusId');				
		$this -> load -> model('Dialogueservice_model');
		$data = $this -> Dialogueservice_model -> getTimeAvailableForCurrentGame($ugsStatusId);
		$this -> response($data, 200);
	}
	
	function getStoryForUserGame_get()
	{
		// Provides a random story for a user game combination
		$gameId = $this -> get('gameId');				
		$userId = $this -> get('userId');
		$this -> load -> model('Dialogueservice_model');
		//$data = $this -> Dialogueservice_model -> getStoryForUserGame($gameId,$userId);
		$data = $this -> Dialogueservice_model -> getRandomStoryForGame($gameId);
		$this -> response($data, 200);
	}	
	
	function getStory_get()
	{
		$storyId = $this -> get('storyId');				
		$this -> load -> model('Dialogueservice_model');
		$data = $this -> Dialogueservice_model -> getStory($storyId);
		$this -> response($data, 200);
	}
	
	function getStoriesForGame_get()
	{
		$gameId = $this -> get('gameId');				
		$this -> load -> model('Dialogueservice_model');
		$data = $this -> Dialogueservice_model -> getStoriesForGame($gameId);
		$this -> response($data, 200);
	}
	
	function getStoriesForGameUser_get()
	{
		$gameId = $this -> get('gameId');				
		$userId = $this -> get('userId');			
		$paramdesc = $this -> get('paramdesc');			
		$this -> load -> model('Dialogueservice_model');
		$data = $this -> Dialogueservice_model -> getStoriesForGameUser($gameId,$paramdesc,$userId);
		$this -> response($data, 200);
	}
	
	function setUserGameStatus_get()
	{
		// For Invoking on New Game Initiation for a user
		$userId = $this -> get('userId');		
		$gsMapId = $this -> get('gsMapId');		
		$status	= $this -> get('status');		
		$this -> load -> model('Dialogueservice_model');
		
		$isGameNewDtls = $this -> Dialogueservice_model -> isGameStatusInitiated($userId,$gsMapId);
		foreach ($isGameNewDtls as $row) 
		{
			$isGameNew = $row -> ISGAME;
		}
		if ($isGameNew == "FALSE")
		{
			$this -> Dialogueservice_model -> insertGameStatus($userId, $gsMapId, '');
			$data[0]['UGS_STATUS_ID'] = $this -> db -> insert_id();
		}
		else
		{
			$this -> Dialogueservice_model -> updateGameStatus($userId,$gsMapId,$status);
			$ugsDtls = $this -> Dialogueservice_model -> getUgsDtlsForUserIdAndGsMapId($userId, $gsMapId);
			$data[0]['UGS_STATUS_ID'] = $ugsDtls[0] -> UGS_STATUS_ID;
		}
			
		$this -> response($data, 200);	
	}

	function createUserGameInstanceByStatus_get()
	{
		// For Invoking on New Game Initiation for a user by checking status. If status is sent, new game will be created else existing one will be updated
		$userId = $this -> get('userId');		
		$gsMapId = $this -> get('gsMapId');		
		$status	= $this -> get('status');		

		$this -> load -> model('Dialogueservice_model');
		
		if ($status == '')
		{
			$this -> Dialogueservice_model -> insertGameStatus($userId, $gsMapId, '');
			$data[0]['UGS_STATUS_ID'] = $this -> db -> insert_id();
		}
		else
		{
			$this -> Dialogueservice_model -> updateGameStatus($userId, $gsMapId, $status);
			$ugsDtls = $this -> Dialogueservice_model -> getUgsDtlsForUserIdAndGsMapId($userId, $gsMapId);
			$data[0]['UGS_STATUS_ID'] = $ugsDtls[0] -> UGS_STATUS_ID;
		}
			
		$this -> response($data, 200);	
	}
	
	function getFiltersForGame_get()
	{
		// Provides Answer Filters for game
		$gameId = $this -> get('gameId');				
		$parentFilterId = $this -> get('parentFilterId');
		$filterType = $this -> get('filterType');
		$this -> load -> model('Dialogueservice_model');
		$data = $this -> Dialogueservice_model -> getFiltersForGame($gameId,$parentFilterId,$filterType);
		$this -> response($data, 200);
	}		
	
	function getPlayStmtsForGameFilter_get()
	{
		//$categories = '{"1":"GROUPED=1","2":"STANDALONE3=4","3":"MOVE_NO<35"}';
		$categories = $this -> get('categories');
        $this -> load -> model('Dialogueservice_model');
        $data = $this -> Dialogueservice_model -> getPlayStmtsForGameFilter($this -> formatJsonToSql($categories));
        $this -> response($data, 200);
	}
    function setUgsStatusID_get()
    {
        //$gameId = 10;       //need to change this to dynamic        
        $userId = $this -> get('userId');
        $universeToken = $this -> get('universeToken');
        $this -> load -> model('Dialogueservice_model');
        $gametype = $this->Dialogueservice_model->getGameTypeByUniverseToken($universeToken);
        if(($gametype[0]['STRATUP_TYPE'])=="SILVER")
        {
            $gameId= 11;
        }
        else if(($gametype[0]['STRATUP_TYPE'])=="GOLD")
        {
            $gameId = 10;
        }
        else
        {
            $gameId = 13;
        }
        $gameStoryDtls = $this->Dialogueservice_model->getRandomStoryForGame($gameId);
        $gsMapId = $gameStoryDtls[0]->GS_MAP_ID;
        
        $ugsDtls = $this -> Dialogueservice_model -> getUgsStatusForUserIdGameToken($userId,$universeToken);
        if(count($ugsDtls)>0)
        {
            $data=true;
        }
        else
        {
             $data = $this -> Dialogueservice_model ->insertGameStatus($userId,$gsMapId,$universeToken);
        }
       
        $this -> response($data, 200);
    }
    function getGameletforUser_get()
	{
		// For Invoking on New Game Initiation for a user
		//Created by : Ashwini
		$userId = $this -> get('userId');		
		$this -> load -> model('Dialogueservice_model');
		
		$gameletForUser = $this -> Dialogueservice_model -> getGameletForUser($userId);
		
		$this -> response($gameletForUser, 200);	
	}
	function getGameletLevelsforUser_get()
	{
		// For Invoking on New Game Initiation for a user
		//Created by : Ashwini
		$userId = $this -> get('userId');	
		$gameId = $this -> get('gameId');
		$this -> load -> model('Dialogueservice_model');
		
		$gameletLevelsForUser = $this -> Dialogueservice_model -> getStoriesForGameUserwithPurchasedStatus($gameId,$userId);
		
		$this -> response($gameletLevelsForUser, 200);	
	}
	function getInitialCompPlayStmtForStory_get()
	{
		// For Invoking on New Game Initiation for a user
		//Created by : Ashwini
		$storyId = $this -> get('storyId');
		$this -> load -> model('Dialogueservice_model');
		
		$compplaystmts = $this -> Dialogueservice_model -> getInitialCompPlayStmtForStory($storyId);
		// Code Altered by Leela
		// mark if the myoption button should have continue or myoptions
		$compstmtcode = $compplaystmts[0]['COMP_STMT_CODE'];
		$compplaystmts[0]['IS_CONTINUE']=$this->isContinueButtonValue($compstmtcode);
		
		$this -> response($compplaystmts, 200);	
	}
	function getPlayStmt_get()
	{
		// For Invoking on New Game Initiation for a user
		//Created by : Ashwini
		// modified by : Leela
		// added player option as input param for negociation game

		$compstmtcode = $this -> get('compstmtcode');
		$playerOption = $this -> get('playerOption');
		$this -> load -> model('Dialogueservice_model');
		if(empty($playerOption))
		{
			$compplaystmts = $this -> Dialogueservice_model -> getPlayStmtForCompStmtCode($compstmtcode);
		}
		else
		{
			$compplaystmts = $this -> Dialogueservice_model -> getPlayStmtForCompStmtCodeAndPlayerOption($compstmtcode,$playerOption);
		}
		$this -> response($compplaystmts, 200);	
	}
	function getCompStmt_get()
	{
		// For Invoking on New Game Initiation for a user
		//Created by : Ashwini
		$compstmtcode = $this -> get('compstmtcode');
		$this -> load -> model('Dialogueservice_model');
		$compplaystmts = $this -> Dialogueservice_model -> getCompStmtForCompStmtCode($compstmtcode);
		// Code Altered by Leela
		// mark if the myoption button should have continue or myoptions
		$compplaystmts[0]['IS_CONTINUE']=$this->isContinueButtonValue($compstmtcode);
		// var_dump($playstmts);
		$this -> response($compplaystmts, 200);	
	}
	function isContinueButtonValue($compstmtcode)
	{
		$playstmts = $this -> Dialogueservice_model -> getPlayStmtForCompStmtCode($compstmtcode);
		if(empty($playstmts))
		{
			// no player statemtent mapped to Computer statement.
			// hence display as end of game
			$isContinue = "END";
		}
		else if($playstmts[0]['PLAY_STMT_DESC'] == 'NULL')
		{
			$isContinue = "YES";
		}
		else
		{
			$isContinue = "NO";
		}
		return $isContinue;
	}
	function getPlayerOptions_get()
	{
		// to display player choice for the given computer statement
		// check the mapping player statements for the computer statement
		// then get the list of  PARAM_OPTIONS_GROUP_CODE mapped for those player statements
		// then get the choice name based on the PARAM_OPTIONS_GROUP_CODE mapped with dial_filter_mstr
		// by PARAMETER_CODE,COMPARATOR,VALUE
		$compStmtCode = $this -> get('compstmtcode');
		$playerOptionDtls = $this -> Dialogueservice_model -> getPlayerOptionsForCompCode($compStmtCode);
		$this -> response($playerOptionDtls, 200);


	}
	function getCardForCompStmt_get()
	{
		//Created by : Ashwini
		$compstmtcode = $this -> get('compstmtcode');
		$ugsId = $this -> get('ugsId');
		$this -> load -> model('Dialogueservice_model');
		$cardDtls = $this -> Dialogueservice_model -> getCardForCompStmtCode($compstmtcode);
		$cardInInventory = $this -> Dialogueservice_model -> getCardFromInventoryForUgsIdCardCode($ugsId, $cardDtls[0]['CARD_CODE']);
		$desnCompStmtCode = "";
		if(count($cardInInventory) > 0)
		{
			$compplaystmts = $this -> Dialogueservice_model -> getPlayStmtForCompStmtCode($compstmtcode);
			$desnCompStmtCode = $compplaystmts[0]['DESTN_COMP_STMT_CODE'];

		}
		$cardDtls[0]['DESTN_COMP_STMT_CODE'] = $desnCompStmtCode;
		$this -> response($cardDtls, 200);	
	}
	function setUgsStatusIDForGameLets_get()
    {
         //to insert value into dial_user_game_status
    	//Created by : Ashwini
        $userId = $this -> get('userId');
        $gsMapId = $this -> get('gsMapId');
        $gameId = $this -> get('gameId');

        $this -> load -> model('Dialogueservice_model');
        $userGameDtls = $this -> Dialogueservice_model ->getugsIdForGameIdUserId($userId,$gameId);
        if($userGameDtls[0]['GAME_TAG'] == "NOVAC")
        {
        	if(count($userGameDtls) > 0)
	        {
	        	$lastRecord = end($userGameDtls);// to get last record from an array
	        	$data[0]['UGS_STATUS_ID'] = $lastRecord['UGS_STATUS_ID'];
	        }
	        else
	        {
	        	$this -> Dialogueservice_model ->insertGameStatus($userId,$gsMapId,'');
       			$data[0]['UGS_STATUS_ID'] = $this -> db -> insert_id();
	        }
        }
        else
        {
        	$this -> Dialogueservice_model ->insertGameStatus($userId,$gsMapId,'');
       		$data[0]['UGS_STATUS_ID'] = $this -> db -> insert_id();
        }
        $this -> response($data, 200);
    }
    function insertPointsActionForUgsStatus_get()
    {
    	 //to insert points and Actions for ugsStatusId
    	//Created by : Ashwini
        $ugsStatusId = $this -> get('ugsStatusId');
        $compstmtcode = $this -> get('compstmtcode');
        $playstmtcode = $this -> get('playstmtcode');

        $this -> load -> model('Dialogueservice_model');
    	$isActionAvailable = $this -> Dialogueservice_model ->getActionsTblDtlsForUgsAndCompStmtCode($ugsStatusId,$compstmtcode);
        if(empty($isActionAvailable))
        {
            $data=$this -> Dialogueservice_model -> insertActions($compstmtcode,$playstmtcode,$ugsStatusId);
        }
        else 
        {
            $data=$this -> Dialogueservice_model -> updateActions($compstmtcode,$playstmtcode,$ugsStatusId);
        }
        $compStmtDtls = $this -> Dialogueservice_model -> getDetailsForCompStmtCode($compstmtcode);
		$title = $compStmtDtls[0]['COMP_STMT_TITLE'];
		if(strpos($title,'INTCALC') !== false)
		{
			//Don't do anything here
		}
		else
		{
			$data=$this -> Dialogueservice_model -> insertPoints($playstmtcode,$ugsStatusId);
		}
		$datapassed = json_decode(json_encode($this -> Dialogueservice_model -> getPointsForAnimation($playstmtcode)),true);
		$this -> response($datapassed, 200);
    }
    function getLevelCompleteDetails_get()
    {
    	$ugsStatusId = $this -> get('ugsStatusId');
    	$this -> load -> model('Dialogueservice_model');	
		$this -> load -> model('Negotiation_model');
		
		$data['POINTSLIST'] = $this -> Dialogueservice_model -> getPercentTargetAchievedForStory($ugsStatusId,'Y');
		//Below lines of code is for other gamelets Level Complete
		$data['PAYOFFSCORE'] = $this -> Negotiation_model -> getPayoffScore($ugsStatusId);		
		$data['GROUPCHART'] = $this -> Dialogueservice_model -> getPlayerAnswersCategoryCountForStory($ugsStatusId,'GROUPED');
        $data['STANDCHART'] = $this -> Dialogueservice_model -> getPlayerAnswersCategoryCountForStory($ugsStatusId,'STANDALONE');
        $data['PROGRESS'] = $this -> Dialogueservice_model -> getPercentTargetAchievedForStory($ugsStatusId,'N');
        $this -> response($data, 200);
    }

    function getZoneSubCategory_get()
    {
    	//Created by : Ashwini
    	//For Novac Game
    	$zoneId = $this -> get('zoneId');
    	$ugsId = $this -> get('ugsId');
    	$userId = $this -> get('userId');
    	$this -> load -> model('Dialogueservice_model');	
		
		$zoneDtls = $this -> Dialogueservice_model -> getZoneSubCategoryForZone($zoneId);
		$cardInInventory = $this -> Dialogueservice_model -> getAllCardsFromInventoryForUgsIdUserId($ugsId, $userId);
		$i = 0;
		foreach($zoneDtls as $zone)
		{
			$data[$i]['ZONE_SUB_CATEGORY_ID'] = $zone['ZONE_SUB_CATEGORY_ID'];
			$data[$i]['ZONE_SUB_CATEGORY_DESC'] = $zone['ZONE_SUB_CATEGORY_DESC'];
			$data[$i]['ZONE_ID'] = $zone['ZONE_ID'];
			$data[$i]['QUESTION_ID'] = $zone['QUESTION_ID'];
			$data[$i]['CARD_CODE_REQUIRED_TO_UNLOCK'] = $zone['CARD_CODE_REQUIRED_TO_UNLOCK'];
			if($zone['CARD_CODE_REQUIRED_TO_UNLOCK'] != '')
			{
				if(count($cardInInventory) > 0)
				{
					foreach ($cardInInventory as $cards) 
					{
						if($cards['CARD_CODE'] == $zone['CARD_CODE_REQUIRED_TO_UNLOCK'])
						{
							if($cards['CARD_USED_STATUS'] == 'U')
							{
								$zoneUnlockStatus = "UNLOCKED";
							}
							else
							{
								$zoneUnlockStatus = "LOCKED";
							}
						}
						else
						{
							$zoneUnlockStatus = "LOCKED";
						}
					}
				}
				else
				{
					$zoneUnlockStatus = "LOCKED";
				}
			}
			else
			{
				$zoneUnlockStatus = "UNLOCKED";
			}
			$data[$i]['ZONE_UNLOCK_STATUS'] = $zoneUnlockStatus;
			$i++;
		}
        $this -> response($data, 200);
    }

    function insertCardToInventory_get()
    {
    	//Created by : Ashwini
    	$data = array();
    	$userId = $this -> get('userId');
    	if ($userId == '')
			{
				$data[0]["Success"] = "false";
				$data[1]["ErrorMsg"] = "Enter userId";
				$this -> response($data, 200);
			}
    	$ugsId = $this -> get('ugsId');
    	if ($ugsId == '')
			{
				$data[0]["Success"] = "false";
				$data[1]["ErrorMsg"] = "Enter ugsId";
				$this -> response($data, 200);
			}
    	$cardCode = $this -> get('cardCode');
    	if ($cardCode == '')
			{
				$data[0]["Success"] = "false";
				$data[1]["ErrorMsg"] = "Enter cardCode";
				$this -> response($data, 200);
			}

    	$this -> load -> model('Dialogueservice_model');	

    	$params = array('UGS_ID' => $ugsId,
    					'USER_ID' => $userId,
    					'CARD_CODE' => $cardCode,
    					'CARD_USED_STATUS' => 'N');
		$cardDtls = $this -> Dialogueservice_model -> getCardFromInventoryForUgsIdCardCode($ugsId, $cardCode);
		if(empty($cardDtls))
		{
			$this -> Dialogueservice_model -> insertCardToInventory($params);
		}

		$data[0]["Success"] = "true";
        $this -> response($data, 200);
    }

    function getCardsFromInventory_get()
    {
    	//Created by : Ashwini
    	$ugsId = $this -> get('ugsId');
    	$cardType = $this -> get('cardType');
    	$this -> load -> model('Dialogueservice_model');	
		
		$data = $this -> Dialogueservice_model -> getCardsFromInventoryForUgsIdCardType($ugsId,$cardType);
        $this -> response($data, 200);
    }

    function getLevelWiseSequenceOfProcessCard_get()
    {
    	//Created by : Ashwini
    	$ugsId = $this -> get('ugsId');
    	$this -> load -> model('Dialogueservice_model');	
		
		$data = $this -> Dialogueservice_model -> getProcessCardLevelWiseSequence($ugsId);
        $this -> response($data, 200);
    }

    function insertIntoUserProcessRemoveFromInventory_get()
    {
    	//Created by : Ashwini
    	$ugsId = $this -> get('ugsId');
    	$levelId = $this -> get('levelId');
    	$cardCode = $this -> get('cardCode');
    	$seqNo = $this -> get('seqNo');
    	$this -> load -> model('Dialogueservice_model');	
    	$params = array('UGS_ID' => $ugsId,
    					'LEVEL_ID' => $levelId,
    					'CARD_CODE' => $cardCode,
    					'SEQ_NO' => $seqNo);
		
		$data = $this -> Dialogueservice_model -> insertCardToProcess($params);
		$cardStatus = 'U';//U = Used, N = Not Used
		$data = $this -> Dialogueservice_model -> updateCardUsedStatusForCardCode($ugsId, $cardCode, $cardStatus);
        $this -> response($data, 200);
    }

    function getInputCardsForCompStmt_get()
	{
		// For Invoking on New Game Initiation for a user
		//Created by : Ashwini
		$compstmtcode = $this -> get('compstmtcode');
		$this -> load -> model('Dialogueservice_model');
		$cardDtls = $this -> Dialogueservice_model -> getInputCardsForCompStmtCode($compstmtcode);
		
		$this -> response($cardDtls, 200);	
	}

	function RemoveCardFromInventory_get()
    {
    	//Created by : Ashwini
    	$ugsId = $this -> get('ugsId');
    	$cardCode = $this -> get('cardCode');
    	$this -> load -> model('Dialogueservice_model');
		$cardStatus = 'U';//U = Used, N = Not Used
		$data = $this -> Dialogueservice_model -> updateCardUsedStatusForCardCode($ugsId, $cardCode, $cardStatus);
        $this -> response($data, 200);
    }

    function getDefauktScoreForGame_get()
    {
    	//Created by : Ashwini
    	$gsMapId = $this -> get('gsMapId');
    	$this -> load -> model('Dialogueservice_model');
		$data = $this -> Dialogueservice_model -> getDefaultScore($gsMapId);
		$this -> response($data, 200);
    }

    function getUpdatedScoreForGame_get()
    {
    	//Created by : Ashwini
    	$userId = $this -> get('userId');
    	$gameId = $this -> get('gameId');
    	$gsMapId = $this -> get('gsMapId');
    	$this -> load -> model('Dialogueservice_model');
    	$InitialPoints = $this -> Dialogueservice_model -> getDefaultScore($gsMapId);
		$totalPoint = $this -> Dialogueservice_model -> getTotalPointsForGame($userId,$gameId);
		$data = array();
		$totalValue = 0;
		if(count($totalPoint)>0)
		{
			$i = 0;
			$data[$i]['POINTS_PARAM_DESC'] = "OverallScore";
			
			$i++;
			foreach ($InitialPoints as $default) 
			{
				$value = 0;
				if($default['POINTS_PARAM_DESC'] != "OverallScore")
				{
					$data[$i]['POINTS_PARAM_DESC'] = $default['POINTS_PARAM_DESC'];
					$data[$i]['POINTS_PARAM_ICON_PATH'] = $default['POINTS_PARAM_ICON_PATH'];
					foreach ($totalPoint as $points) 
					{
						if($default['POINTS_PARAM_CODE'] == $points -> POINTS_PARAM_CODE)
						{
							$value = $points -> VALUE;						 
						}
					}
					$data[$i]['VALUE'] = (string)(($default['VALUE']) + $value);
					$totalValue += $data[$i]['VALUE'];		
				}	
				else
				{
					$data[0]['POINTS_PARAM_ICON_PATH'] = $default['POINTS_PARAM_ICON_PATH'];
					$data[0]['VALUE'] = (string)$totalValue;
				}			 		
		 		$i++;
		 	} 
		}
		else
		{
			$data = $InitialPoints;
		}
		
        $this -> response($data, 200);
    }
    function checkUserAlreadyPlayedGame_get()
    {
    	//Created by : Ashwini
    	$userId = $this -> get('userId');
    	$gameId = $this -> get('gameId');
    	$this -> load -> model('Dialogueservice_model');
        $userGameDtls = $this -> Dialogueservice_model ->getugsIdForGameIdUserId($userId,$gameId);
        if(count($userGameDtls) > 0)
	    {
	    	$lastRecord = end($userGameDtls);// to get last record from an array
	        $data[0]['UGS_STATUS_ID'] = $lastRecord['UGS_STATUS_ID'];
	    }
	    else
	    {
	       	$data[0]['UGS_STATUS_ID'] = "";
        }
        $this -> response($data, 200);
	}
	function getOverAllGameletScoreforUser_get()
	{
		// To get total score of all gamelet for a user
		//Created by : Ashwini
		$userId = $this -> get('userId');	
		$this -> load -> model('Dialogueservice_model');
		
		$totalScoreOfAllGameletsForUser = $this -> Dialogueservice_model -> getOverAllGameletScoreforUser($userId);
		
		$this -> response($totalScoreOfAllGameletsForUser, 200);	
	}
	function getInterimQandAforCompStmt_get()
	{
		// To get all interim Questions and Answer mapped for computer statment code.
		//Created by : Leela
		$compstmtcode = $this -> get('compstmtcode');
		$this -> load -> model('Dialogueservice_model');
		$interimQListDtls = $this -> Dialogueservice_model -> getInterimQforCompStmt($compstmtcode);
		$rowIndex = 0;
		$interimQandADtls = array();
		foreach ($interimQListDtls as $row) 
		{
			// UGS_STATUS_ID
			$interimQandADtls[$rowIndex]["INTQN_MAP_CODE"]=$row["INTQN_MAP_CODE"];
			$interimQDtls = $this -> Dialogueservice_model -> getInterimQuestionforQcode($row["INTQN_CODE"]);
			$interimAnsDtls = $this -> Dialogueservice_model -> getInterimAnsforQcode($row["INTQN_CODE"]);

			$interimQandADtls[$rowIndex]["QUESTION_DTLS"] = $interimQDtls;
			$interimQandADtls[$rowIndex]["ANSWER_DTLS"] = $interimAnsDtls;
			$rowIndex++;
		}
		$this -> response($interimQandADtls, 200);	
	}
	function insertIntermQandAUserRespone_get()
    {
    	 //to insert interm Questions user Response by UGS_STATUS_ID and INTQN_MAP_CODE
    	//Created by : Leela
        $ugsStatusId = $this -> get('ugsStatusId');
        $intQnMapCode = $this -> get('intQnMapCode');
		$intAnsCode = $this -> get('intAnsCode');
		
		$paramdata = array(
			'UGS_STATUS_ID' => $ugsStatusId,
			'INTQN_MAP_CODE' => $intQnMapCode,
			'INTANS_CODE' => $intAnsCode);

        $this -> load -> model('Dialogueservice_model');
    	$isDataAvailable = $this -> Dialogueservice_model ->getAvailableIntermResponseForUgs($ugsStatusId,$intQnMapCode);
        if(empty($isDataAvailable))
        {
            $data=$this -> Dialogueservice_model -> insertIntermResponse($paramdata);
        }
        else 
        {
            $data=$this -> Dialogueservice_model -> updateIntermResponse($paramdata);
        }
		$this -> response("SUCCESS", 200);
	}
	
	function getAnalyticsReport_get()
	{
		// Analytics Report - % Score Achieved for Parameters defined as number based targets
		// Created by : Siva
		$ugsStatusId = $this -> get('ugsStatusId');
		$this -> load -> model('Dialogueservice_model');
		$this -> updateAnalyticValues($ugsStatusId);
		$analyticsReport['NUMBERSCORES'] = $this -> Dialogueservice_model -> getNumberScoresForCurrentStory($ugsStatusId);
		$analyticsReport['BOOLEANSCORES'] = $this -> Dialogueservice_model -> getBooleanScoresForCurrentStory($ugsStatusId);
		$analyticsReport['OTHERSSCORES'] = $this -> Dialogueservice_model -> getOtherPlayerAnalyticsForCurrentStory($ugsStatusId);
		$analyticsReport['DOMINANTTRAIT'] = $this -> Dialogueservice_model -> getDominantTraitsForCurrentStory($ugsStatusId);
		$nodesFacedObj = $this -> Dialogueservice_model -> getNodesFacedForCurrentStory($ugsStatusId);
		$analyticsReport['NODESFACED'] = $nodesFacedObj[0]["NODESFACED"] ;
		$timeTakenObj = $this -> Dialogueservice_model -> getTimetakenForCurrentStory($ugsStatusId);
		$analyticsReport['TIMETAKEN'] = $timeTakenObj[0]["TIMETAKEN"] ;
		$outcomeObj = $this -> Dialogueservice_model -> getOutcomeForCurrentStory($ugsStatusId);
		$analyticsReport['OUTCOME'] = $outcomeObj[0]["OUTCOME"] ;

		$this -> response($analyticsReport, 200);	
	}


	function getNumberScoresForCurrentStory_get()
	{
		// Analytics Report - % Score Achieved for Parameters defined as number based targets
		// Created by : Siva
		$ugsStatusId = $this -> get('ugsStatusId');
		$this -> load -> model('Dialogueservice_model');
		$numberScores = $this -> Dialogueservice_model -> getNumberScoresForCurrentStory($ugsStatusId);
		$this -> response($numberScores, 200);	
	}

	function getBooleanScoresForCurrentStory_get()
	{
		// Analytics Report - Value for Parameters defined as True / False
		// Created by : Siva
		$ugsStatusId = $this -> get('ugsStatusId');
		$this -> load -> model('Dialogueservice_model');
		$booleanScores = $this -> Dialogueservice_model -> getBooleanScoresForCurrentStory($ugsStatusId);
		$this -> response($booleanScores, 200);	
	}	

	function getNodesFacedForCurrentStory_get()
	{
		// Analytics Report - No of answers provided by player faced in the current story
		// Created by : Siva
		$ugsStatusId = $this -> get('ugsStatusId');
		$this -> load -> model('Dialogueservice_model');
		$nodesFaced = $this -> Dialogueservice_model -> getNodesFacedForCurrentStory($ugsStatusId);
		$this -> response($nodesFaced, 200);	
	}
	
	function getTimetakenForCurrentStory_get()
	{
		// Analytics Report - Time taken from start to completion of the UGS_STATUS_ID
		// Created by : Siva
		$ugsStatusId = $this -> get('ugsStatusId');
		$this -> load -> model('Dialogueservice_model');
		$timeTaken = $this -> Dialogueservice_model -> getTimetakenForCurrentStory($ugsStatusId);
		$this -> response($timeTaken, 200);	
	}
	
	function getOutcomeForCurrentStory_get()
	{
		// Analytics Report - Final Outcome of Current Story
		// Created by : Siva
		$ugsStatusId = $this -> get('ugsStatusId');
		$this -> load -> model('Dialogueservice_model');
		$outcome = $this -> Dialogueservice_model -> getOutcomeForCurrentStory($ugsStatusId);
		$this -> response($outcome, 200);	
	}
	
	function getDominantTraitForCurrentStory_get()
	{
		// Analytics Report - Dominant trait of player for the story based on percentage achieved
		// Created by : Siva
		$ugsStatusId = $this -> get('ugsStatusId');
		$this -> load -> model('Dialogueservice_model');
		$dominantTrait = $this -> Dialogueservice_model -> getDominantTraitsForCurrentStory($ugsStatusId);
		$this -> response($dominantTrait, 200);	
	}	

	function updateAnalyticValues($ugsStatusId)
	{
		// Created By : Siva
		// This function is to be called when a story (ugs_status_id) changes state from Pending to Completed in dial_user_game_status_tbl
		// $ugsStatusId = $this -> get('ugsStatusId');
		$this -> load -> model('Dialogueservice_model');
		$analyticValue = "";$userId="";$gsMapId="";
		$ugsObject = $this -> Dialogueservice_model -> getUgsDetails($ugsStatusId);
		if ($ugsObject != null)
		{
			$gsMapId = $ugsObject[0]["GS_MAP_ID"];
			$userId = $ugsObject[0]["USER_ID"];
		}
		$updated0 = $this -> Dialogueservice_model -> updateGameStatus($userId,$gsMapId,"COMPLETED");
		
		// Update Analytics for "Dominant Decision Making Style"

		$analyticId = 1;
		$dominantTraitCount = 0;
		$dominantTraitsData = $this -> Dialogueservice_model -> getDominantTraitsForCurrentStory($ugsStatusId);
		foreach ($dominantTraitsData as $dominantTraitObj)
        {
			$analyticValue = $dominantTraitObj['POINTS_PARAM_DESC'];            
            $dominantTraitCount++;
		}
		if($dominantTraitCount > 1)
			$analyticValue = "Balanced";
		$updated1 = $this -> Dialogueservice_model -> insertAnalyticsValue($ugsStatusId, $analyticId, $analyticValue);

		// For Analytic Id "Outcome of Game"
		$analyticId = 2;
		$outcomeData = $this -> Dialogueservice_model -> getOutcomeForCurrentStory($ugsStatusId);
		foreach ($outcomeData as $outcomeObj)
        {
			$analyticValue = $outcomeObj['OUTCOME'];
		}
		$updated2 = $this -> Dialogueservice_model -> insertAnalyticsValue($ugsStatusId, $analyticId, $analyticValue);
		// $this -> response("SUCCESS", 200);			
	}

	function getOtherPlayersAnalyticsForCurrentStory_get()
	{
		$ugsStatusId = $this -> get('ugsStatusId');
		$this -> load -> model('Dialogueservice_model');
		$othersScoreData = $this -> Dialogueservice_model -> getOtherPlayerAnalyticsForCurrentStory($ugsStatusId);
		$this -> response($othersScoreData, 200);	
	}

	function insertNewUser_get()
	{
		// user registration : insert new user to user_mstr
		// created by : Leela
		$emailId = $this -> get('emailId');
		$fullName = $this -> get('fullName');
		$nickName = $this -> get('nickName');
		$password = $this -> get('password');
		$paramdata = array(
			'LOGIN_ID' => $emailId,
			'PASSWORD' => $password,
			'FIRST_NAME' => $fullName,
			'NICK_NAME' => $nickName,
			'EMAIL_ID' => $emailId,
			'USER_TYPE_ID' => "3",
			'EMAIL_VERIFIED' => "1"
		);
		$this -> load -> model('Dialogueservice_model');
		$checkEmailAvailable = $this -> Dialogueservice_model -> getExistingEmailID($emailId);
		if(empty($checkEmailAvailable))
		{
			$data=$this -> Dialogueservice_model -> insertNewUser($paramdata);
			$userId = $this->db->insert_id();
			$params = array(
                'USER_ID' => $userId,
				'GS_MAP_ID' =>115,
				'STATUS' =>'A'
			);
			$data2=$this -> Dialogueservice_model -> insertFreeGames($params);
			$message = "SUCCESS:".$userId;
		}
		else
		{
			$message = "FAILED";
		}
		$this -> response($message, 200);
	}

	function getFeedbackMstr_get()
	{
		//Created by : Ashwini
		$this -> load -> model('Dialogueservice_model');
		$data['Success']="true";
		$data['FEEDBACK_TYPES'] = $this -> Dialogueservice_model -> getFeedbackMstr();
	
		$this -> response($data, 200);
	} 

	function getUserRatingValues_get()
	{
		//Created by : Ashwini
		$this -> load -> model('Dialogueservice_model');
		$data['Success']="true";
		$data['RATING_DETAILS'] = $this -> Dialogueservice_model -> getUserRatingValues();
	
		$this -> response($data, 200);
	}

	function insertUserFeedback_get()
	{
		//Created by : Ashwini
		$userId = $this -> get('userId');
		if($userId == '')
		{
			$data["Success"] = "false";
			$data["ErrorMsg"] = "Enter userId";
			$this -> response($data, 200);
		}
		$feedback = $this -> get('feedback');

		$feedbackValues = json_decode($feedback, true);

		for($i = 0; $i < count($feedbackValues['FEEDBACK']); $i++)
		{
			$feedbackValues['FEEDBACK'][$i]['USER_ID'] = $userId;
		}
		$this->db-> trans_begin(); 
		$this -> load -> model('Dialogueservice_model');
		foreach ($feedbackValues['FEEDBACK'] as $row) 
		{
			$this -> Dialogueservice_model -> insertUserFeedback($row);
		}
		$error = $this->db-> error();
        if ( $this->db-> trans_status() === FALSE)
        {
            $this->db-> trans_rollback();
            $data['Success'] = "false";
        }
        else
        {
            $this->db-> trans_commit();
            $data["Success"] = "true";
        }
		$this -> response($data, 200);
	}

	function insertPointsForUgsStatus_get()
    {
    	 //to insert points for ugsStatusId
    	//Created by : Ashwini
		$ugsStatusId = $this -> get('ugsStatusId');
		$paramCode = $this -> get('paramCode');
		$score = $this -> get('score');

        $this -> load -> model('Dialogueservice_model');
		$checkPointsExists = $this -> Dialogueservice_model -> getPointsForUgsStatusIdandParamCode($ugsStatusId,$paramCode);
		if(empty($checkPointsExists))
		{
			$this -> Dialogueservice_model -> insertPointsForParamCode($ugsStatusId,$paramCode,$score);
		}
		else
		{
			$this -> Dialogueservice_model -> updatePointsForParamCode($ugsStatusId,$paramCode,$score);
		}
		$this -> response('SUCCESS', 200);
    }
}
?>