<?php
class Bpmservice_model extends CI_Model {
	function __construct() {
		parent::__construct();
	}

	function getProcessList() 
	{
		$sql = ('SELECT * FROM bpm_process_mstr'); 
		$query = $this -> db -> query($sql);
		return $query -> result();
	}
	
	function getProcessDetails($processId) 
	{
		$sql = ('SELECT * FROM bpm_process_mstr where process_id = ?'); 
		$query = $this -> db -> query($sql, array($processId));
		return $query -> result();
	}
	
	function getProcessVariantList($processId) 
	{
		$sql = ('SELECT * FROM bpm_variant_mstr where process_id = ?'); 
		$query = $this -> db -> query($sql, array($processId));
		return $query -> result();
	}
	
	function getRolesForProcess($processId)
	{
		$sql = ('SELECT distinct role_name as ROLE_NAME FROM bpm_activity_map_mstr  bamm
inner join bpm_activity_mstr bam on bam.activity_id = bamm.activity_id
inner join bpm_role_mstr brm on brm.role_id = bam.role_id
where level_code = "L0" and PARENT_ID = ?'); 
		$query = $this -> db -> query($sql, array($processId));
		return $query -> result();
	}
		
	function getActivityDetails($activityId) 
	{
		$sql = ('SELECT * FROM bpm_activity_mstr where activity_id = ?'); 
		$query = $this -> db -> query($sql, array($activityId));
		return $query -> result();
	}

	function getActivityForLevelParentOrder($processId,$parentActivityId,$orderId) 
	{
		$sql = ('SELECT bam.*,brm.ROLE_NAME AS ACTIVITY_ROLE FROM bpm_activity_mstr bam
inner join bpm_role_mstr brm on brm.role_id = bam.role_id where process_id = ? and parent_activity_id = ? and activity_sequence_id = ?'); 
		$query = $this -> db -> query($sql, array($processId,$parentActivityId,$orderId));
		return $query -> result();
	}

	function getActivityForLevelParent($processId,$parentActivityId) 
	{
		$sql = ('SELECT bam.*,brm.ROLE_NAME AS ACTIVITY_ROLE FROM bpm_activity_mstr bam 
inner join bpm_role_mstr brm on brm.role_id = bam.role_id where process_id = ? and parent_activity_id = ?'); 
		$query = $this -> db -> query($sql, array($processId,$parentActivityId));
		return $query -> result();
	}
}
?>