<?php
class Dialogueservice_model extends CI_Model {
	function __construct() {
		parent::__construct();
	}

	function getDetailsForUgsId($ugsStatusId) 
	{
		$sql = ('SELECT * FROM dial_user_game_status dugs
		inner join dial_game_seg_story_map_mstr dgssmm on dugs.gs_map_id = dgssmm.gs_map_id
		where ugs_status_id = ?'); 
		$query = $this -> db -> query($sql, array($ugsStatusId));
		return $query -> result();
	}
	
	function getComputerStatements() 
	{
		$sql = ('SELECT * FROM dial_player_stmt_mstr where play_stmt_code = \'10002\''); 
        //$this->db->cache_delete($this->router->fetch_class(), $this->router->fetch_method());
        //$this->db->simple_query('SET NAMES \'utf-8\'');				
		$query = $this -> db -> query($sql);

		return $query -> result();
	}
	
	function insertComputerStatements($statement) 
	{
		$sql = ('insert into dial_comp_stmt_mstr(COMP_STMT_DESC) values(?)');
		$query = $this -> db -> query($sql, array($statement));
	}
	
	function updateComputerStatements($statement,$stmtcode) 
	{
		$sql = ('update dial_comp_stmt_mstr set COMP_STMT_DESC = ? where COMP_STMT_CODE = ?');
		$query = $this -> db -> query($sql, array($statement,$stmtcode));
	}
	
	function getCompPlayStatementsForTrigger($compstmtcode) 
	{
		$sql = ('SELECT "" filter_type,
                    "" FILTER,
                    "" FILTERLOGO,
                    "" SECONDFILTER,
                    "" SECONDFILTERLOGO,
                    "COMP" TYPE,
                    comp_stmt_code CODE,
                    comp_stmt_desc AS DESCRIPTION,
					COMP_STMT_TITLE,
                    COMP_STMT_TYPE,
                    MEDIA_URL,
                    MEDIA_TYPE,
                    IMG_BG,
                    COALESCE(GAME_OBJECT, "") GAME_OBJECT,
                    COALESCE(NPC_TEXT, "") NPC_TEXT,
                    AVAILABLE_FOR_TIME_SEC,
                    IMAGE_CSS_CLASS
                FROM
                    dial_comp_stmt_mstr
                WHERE
                    COMP_STMT_CODE = ? 
                UNION SELECT * FROM (SELECT dfm.filter_type ,
                    dfm.FILTER_TITLE FILTER,
                    dfm.FILTER_ICON_PATH FILTERLOGO,
                    ST2.FILTER_TITLE SECONDFILTER,
                    ST2.FILTER_ICON_PATH SECONDFILTERLOGO,
                    "PLAY" TYPE,
                    dpsm.play_stmt_code CODE,
                    STRIP_TAGS(play_stmt_desc) AS DESCRIPTION,
					"" AS COMP_STMT_TITLE,
                    "" AS COMP_STMT_TYPE,
                    COALESCE(MEDIA_URL, "") MEDIA_URL,
                    COALESCE(MEDIA_TYPE, "") MEDIA_TYPE,
                    "" AS IMG_BG,
                    "" AS GAME_OBJECT,
                    "" AS NPC_TEXT,
                    "" AS AVAILABLE_FOR_TIME_SEC,
                    "" 
                FROM
                    dial_player_stmt_mstr dpsm
                        LEFT JOIN
                    dial_param_options_map_mstr dpomm ON dpomm.PARAM_OPTIONS_GROUP_CODE = dpsm.PARAM_OPTIONS_GROUP_CODE
                        LEFT JOIN
                    dial_filter_mstr dfm ON dfm.filter_id = dpomm.value
                        LEFT JOIN
                    (SELECT 
                        dpsm2.PLAY_STMT_CODE,
                            dfm2.FILTER_TITLE,
                            dfm2.FILTER_ICON_PATH
                    FROM
                        dial_player_stmt_mstr dpsm2
                    LEFT JOIN dial_param_options_map_mstr dpomm2 ON dpomm2.PARAM_OPTIONS_GROUP_CODE = dpsm2.PARAM_OPTIONS_GROUP_CODE
                    LEFT JOIN dial_filter_mstr dfm2 ON dfm2.filter_id = dpomm2.value
                    WHERE
                        source_COMP_STMT_CODE = ?
                            AND dfm2.filter_type = "STANDALONE") ST2 ON ST2.PLAY_STMT_CODE = dpsm.PLAY_STMT_CODE
                WHERE source_COMP_STMT_CODE = ?) A ');
				if(substr($compstmtcode,0,4) != '1015')
				$sql = $sql.'WHERE (A.filter_type = "STANDALONE" OR (A.filter_type = "GROUPED" AND A.SECONDFILTER IS NULL)  or A.filter_type is null)';
				else
				$sql = $sql.'WHERE (A.filter_type = "GROUPED" OR (A.filter_type = "STANDALONE" AND A.SECONDFILTER IS NULL)  or A.filter_type is null)';
		$query = $this -> db -> query($sql, array($compstmtcode,$compstmtcode,$compstmtcode));
		return $query -> result();
	}
	
	function categorywiseCondnCompStmtsForPlayer($in) 
	{
		$inArray = explode(',', $in);		
		// Used to Fetch Computer Statement Set based on certain conditions like '>' or '<' Eg: ntries where move_no < 20; $in = 'GAME=STRATUP,ROLE=HR,MOVE_NO<20'
		$sql = 'SELECT t.COMP_STMT_CODE FROM (SELECT COMP_STMT_CODE FROM dial_param_compstmt_map_mstr WHERE CONCAT(PARAMETER_CODE,COMPARATOR,VALUE) = \''.$inArray[0].'\') t ';
		//$sql = ('SELECT DISTINCT COMP_STMT_CODE FROM dial_param_compstmt_map_mstr WHERE CONCAT(PARAMETER_CODE,COMPARATOR,VALUE) IN ('.$in.')');
        $i=0;		
		foreach ($inArray as $inArrayVal)
		{
            if (($i!=0))
            {		
				$condnArray = '';		
				$istr = $i;		
				if (strpos($inArrayVal, '=') !== false)
					$sql = $sql.' INNER JOIN  (SELECT COMP_STMT_CODE FROM dial_param_compstmt_map_mstr WHERE CONCAT(PARAMETER_CODE,COMPARATOR,VALUE) = \''.$inArrayVal.'\') t'.$istr.' on t.COMP_STMT_CODE = t'.$istr.'.COMP_STMT_CODE ';
				else if (strpos($inArrayVal, '>') !== false)
				{
					$condnArray = explode('>', $inArrayVal);
					$sql = $sql.' INNER JOIN  (SELECT COMP_STMT_CODE FROM dial_param_compstmt_map_mstr WHERE PARAMETER_CODE = \''.$condnArray[0].'\' AND VALUE > '.$condnArray[1].') t'.$istr.' on t.COMP_STMT_CODE = t'.$istr.'.COMP_STMT_CODE';
				}
				else if (strpos($inArrayVal, '<') !== false)
				{
					$condnArray = explode('<', $inArrayVal);
					$sql = $sql.' INNER JOIN  (SELECT COMP_STMT_CODE FROM dial_param_compstmt_map_mstr WHERE PARAMETER_CODE = \''.$condnArray[0].'\' AND VALUE < '.$condnArray[1].') t'.$istr.' on t.COMP_STMT_CODE = t'.$istr.'.COMP_STMT_CODE';
				}
			}
            $i++;			
		}
		$query = $this -> db -> query($sql);
		return $query -> result();
	}
	
	function getCompStmtsForGame($in,$mode,$status,$ugsStatusId,$compStmtType) 
	{
		$inArray = explode(',', $in);		
		// Used to Fetch Computer Statement Set based on certain conditions like '>' or '<' Eg: ntries where move_no < 20; $in = 'GAME=STRATUP,ROLE=HR,MOVE_NO<20'
		// included Player statment desc by leela
		if ($mode == 'SUMMARY')
        {
            $sql = 'SELECT dcstm.COMP_STMT_TYPE,dcstm.COMP_STMT_TYPE_DESC,dcstm.ICON_PATH,COUNT(*) CNT ';
        }
			
		else if($mode == 'DETAILANSWER')
        {
            $sql = 'SELECT dcsm.COMP_STMT_CODE,COMP_STMT_DESC,COMP_STMT_TITLE,MEDIA_URL,
                        (select PLAY_STMT_DESC from dial_player_stmt_mstr where PLAY_STMT_CODE=dpat.PLAY_STMT_CODE)PLAY_STMT_DESC ';
        }
        else
        {
            $sql = 'SELECT dcsm.COMP_STMT_CODE,COMP_STMT_DESC,COMP_STMT_TITLE,MEDIA_URL ';
        }
			
		$sql = $sql.' FROM (SELECT COMP_STMT_CODE FROM dial_param_compstmt_map_mstr WHERE CONCAT(PARAMETER_CODE,COMPARATOR,VALUE) = \''.$inArray[0].'\') t ';

        $i=0;		
		foreach ($inArray as $inArrayVal)
		{
            if (($i!=0))
            {		
				$condnArray = '';		
				$istr = $i;		
				if (strpos($inArrayVal, '=') !== false)
                {
                    $sql = $sql.' INNER JOIN  (SELECT COMP_STMT_CODE FROM dial_param_compstmt_map_mstr WHERE CONCAT(PARAMETER_CODE,COMPARATOR,VALUE) = \''.$inArrayVal.'\') t'.$istr.' on t.COMP_STMT_CODE = t'.$istr.'.COMP_STMT_CODE ';
                }
				else if (strpos($inArrayVal, '>') !== false)
				{
					$condnArray = explode('>', $inArrayVal);
					$sql = $sql.' INNER JOIN  (SELECT COMP_STMT_CODE FROM dial_param_compstmt_map_mstr WHERE PARAMETER_CODE = \''.$condnArray[0].'\' AND VALUE > '.$condnArray[1].') t'.$istr.' on t.COMP_STMT_CODE = t'.$istr.'.COMP_STMT_CODE';
				}
				else if (strpos($inArrayVal, '<') !== false)
				{
					$condnArray = explode('<', $inArrayVal);
					$sql = $sql.' INNER JOIN  (SELECT COMP_STMT_CODE FROM dial_param_compstmt_map_mstr WHERE PARAMETER_CODE = \''.$condnArray[0].'\' AND VALUE < '.$condnArray[1].') t'.$istr.' on t.COMP_STMT_CODE = t'.$istr.'.COMP_STMT_CODE';
				}
			}
            $i++;			
		}
		$sql = $sql.' INNER JOIN dial_comp_stmt_mstr dcsm ON t.COMP_STMT_CODE = dcsm.COMP_STMT_CODE
		INNER JOIN dial_comp_stmt_type_mstr dcstm ON dcstm.COMP_STMT_TYPE = dcsm.COMP_STMT_TYPE';
		if ($mode == 'DETAILANSWER')
        {
            $sql = $sql.' left join dial_player_action_tbl dpat on dpat.COMP_STMT_CODE=dcsm.COMP_STMT_CODE WHERE dpat.UGS_STATUS_ID = ?';            
        }
        else 
        {
            $sql = $sql.' WHERE dcsm.COMP_STMT_CODE ';            
            if ($status == 'PENDING')
            {
                $sql = $sql.'NOT'; 
            }
            $sql = $sql.' IN (SELECT dpat.COMP_STMT_CODE FROM dial_player_action_tbl dpat where dpat.UGS_STATUS_ID=?)';
        }

		if ($compStmtType != '')
		{
			$sql = $sql.' AND dcsm.COMP_STMT_TYPE like ?';
			$query = $this -> db -> query($sql, array($ugsStatusId,'%'.$compStmtType.'%'));
		}
		else
		{
			$sql = $sql.' group by 1,2';
			$query = $this -> db -> query($sql, array($ugsStatusId));
		}
        // echo $this->db->last_query();
		return $query -> result();
	}
	
	function answerwiseCompStmtsForPlayer($answer) 
	{
		$sql = ('SELECT DESTN_COMP_STMT_CODE FROM dial_player_stmt_mstr WHERE PLAY_STMT_CODE = ?');
		$query = $this -> db -> query($sql, array($answer));
		return $query -> result();
		//Also update transaction table and points table
	}
	
	function getDetailsForCompStmtCode($compstmtcode) 
	{
		$sql = ('SELECT * FROM dial_comp_stmt_mstr WHERE COMP_STMT_CODE = ?');
		$query = $this -> db -> query($sql, array($compstmtcode));
		return $query -> result_array();
	}		
	
	function descwiseCompStmtsForPlayer($compstmtcode,$answerdesc) 
	{
		$sql = ('SELECT DESTN_COMP_STMT_CODE FROM dial_player_stmt_mstr WHERE SOURCE_COMP_STMT_CODE = ? and PLAY_STMT_DESC = ?');
		$query = $this -> db -> query($sql, array($compstmtcode,$answerdesc));
		return $query -> result();
		//Also update transaction table and points table
	}	
	
	function insertActions($compstatement,$playstatement,$ugsStatusId) 
	{
		$sql = ('insert into dial_player_action_tbl(COMP_STMT_CODE,PLAY_STMT_CODE,UGS_STATUS_ID) values(?,?,?)');
		return $this -> db -> query($sql, array($compstatement,$playstatement,$ugsStatusId));
	}
	
	function isPointsInitiated($answer,$ugsStatusId) 
	{
		$sql = ('SELECT case when count(*) > 0 then "TRUE" WHEN COUNT(*) = 0 THEN "FALSE" END AS ISPOINTS FROM dial_player_points_tbl where UGS_STATUS_ID = ?');
		$query = $this -> db -> query($sql, array($ugsStatusId));
		return $query -> result();
	}	
	
	function insertPoints($answer,$ugsStatusId) 
	{
			$sql = ('insert into dial_player_points_tbl(UGS_STATUS_ID,POINTS_PARAM_CODE,VALUE) SELECT ?,dppm.POINTS_PARAM_CODE,
	CASE INCREASE_DECREASE
	WHEN "I" THEN 0+pspm.VALUE
	WHEN "D" THEN 0-pspm.VALUE
	END AS VALUE1
	FROM dial_player_stmt_points_mstr pspm 
	INNER JOIN dial_points_param_mstr dppm on pspm.POINTS_PARAM_CODE = dppm.POINTS_PARAM_CODE 
	WHERE PLAY_STMT_CODE = ?');
			return $this -> db -> query($sql, array($ugsStatusId,$answer));
	}
	
	function insertSystemPoints($paramDesc,$value,$ugsStatusId) 
	{
			$sql = ('insert into dial_player_points_tbl(UGS_STATUS_ID,POINTS_PARAM_CODE,VALUE) SELECT ?,POINTS_PARAM_CODE,? FROM dial_points_param_mstr where POINTS_PARAM_DESC = ?');
			$query = $this -> db -> query($sql, array($ugsStatusId,$value,$paramDesc));
	}
	
	function updatePoints($answer,$ugsStatusId) 
	{
			$sql = ('update dial_player_points_tbl dppt1 inner join 
		(SELECT dppm.POINTS_PARAM_CODE,
		CASE INCREASE_DECREASE
		WHEN "I" THEN dppt.VALUE+pspm.VALUE
		WHEN "D" THEN dppt.VALUE-pspm.VALUE
		END AS VALUE1
		FROM dial_player_stmt_points_mstr pspm 
		INNER JOIN dial_points_param_mstr dppm on pspm.POINTS_PARAM_CODE = dppm.POINTS_PARAM_CODE 
		INNER JOIN dial_player_points_tbl dppt on dppm.POINTS_PARAM_CODE = dppt.POINTS_PARAM_CODE
		WHERE PLAY_STMT_CODE = ? AND UGS_STATUS_ID = ?) updatevalues on dppt1.POINTS_PARAM_CODE = updatevalues.POINTS_PARAM_CODE
		set dppt1.value = updatevalues.value1
		where dppt1.UGS_STATUS_ID = ?');
			$query = $this -> db -> query($sql, array($answer,$ugsStatusId,$ugsStatusId));		
	}
	
	function getPlayerPointsForGame($ugsStatusId) 
	{
		//Returns the  points for the current level for the given user and game
		$sql = ('SELECT POINTS_PARAM_DESC,DPPM.POINTS_PARAM_TYPE ,SUM(value) VALUE,SUM(target)target,case when round(sum(value)/sum(target)*100) >100 then 100 when round(sum(value)/sum(target)*100) < (-100) then (-100) else round(sum(value)/sum(target)*100) end percent,POINTS_PARAM_ICON_PATH FROM dial_player_points_tbl dppt
			inner join dial_story_param_target_mstr dsptm on dppt.POINTS_PARAM_CODE  = dsptm.POINTS_PARAM_CODE
			inner join dial_points_param_mstr dppm on dppt.POINTS_PARAM_CODE  = dppm.POINTS_PARAM_CODE
			inner join dial_user_game_status dugs on dugs.ugs_status_id = dppt.ugs_status_id
			inner join dial_game_seg_story_map_mstr dgssmm on dgssmm.story_id = dsptm.story_id  and dugs.gs_map_id = dgssmm.gs_map_id
			where dppt.ugs_status_id= ? AND DPPM.POINTS_PARAM_TYPE IN (\'N\',\'D\',\'A\') GROUP BY 1,2');
		$query = $this -> db -> query($sql, array($ugsStatusId));
		return $query -> result();
	}
	
	function getPlayerPointsForGamesInternalCalc($ugsStatusId) 
	{
		$sql = ('SELECT dppm.POINTS_PARAM_DESC,SUM(VALUE) TOTAL FROM dial_player_points_tbl dppt
INNER JOIN dial_points_param_mstr dppm ON dppt.POINTS_PARAM_CODE = dppm.POINTS_PARAM_CODE
WHERE UGS_STATUS_ID = ? GROUP BY 1');
		$query = $this -> db -> query($sql, array($ugsStatusId));
		return $query -> result();
	}
	
	function getSettingsForGame($ugsStatusId) 
	{
		$sql = ('SELECT * FROM dial_player_points_tbl WHERE UGS_STATUS_ID = ?');
		$query = $this -> db -> query($sql, array($ugsStatusId));
		return $query -> result();
	}
	
	function getTotalPointsForGame($userId,$gameId) 
	{
		//Returns sum of all levels' points param for the given user and game
		$sql = ('SELECT dppm.POINTS_PARAM_CODE,dppm.POINTS_PARAM_DESC,dppm.POINTS_PARAM_ICON_PATH,
		SUM(VALUE) VALUE FROM dial_player_points_tbl ppt 
		INNER JOIN dial_points_param_mstr dppm on ppt.POINTS_PARAM_CODE = dppm.POINTS_PARAM_CODE 
		inner join dial_user_game_status dugs on dugs.UGS_STATUS_ID = ppt.UGS_STATUS_ID
		inner join dial_game_seg_story_map_mstr dgssmm on dgssmm.GS_MAP_ID = dugs.GS_MAP_ID WHERE 
		USER_ID = ? AND GAME_ID = ? AND STATUS=\'P\' GROUP BY 1,2,3');
		$query = $this -> db -> query($sql, array($userId,$gameId));
		return $query -> result();
	}
	
	function getPointsForAnswer($answer) 
	{
		$sql = ('SELECT dppm.POINTS_PARAM_DESC,INCREASE_DECREASE,VALUE FROM dial_player_stmt_points_mstr pspm INNER JOIN dial_points_param_mstr dppm on pspm.POINTS_PARAM_CODE = dppm.POINTS_PARAM_CODE WHERE PLAY_STMT_CODE = ?');
		$query = $this -> db -> query($sql, array($answer));
		return $query -> result();
	}

	function getPointsForAnimation($answer) 
	{
		$sql = ('SELECT 
                    dppm.POINTS_PARAM_DESC,
                    CASE
                        WHEN INCREASE_DECREASE = "I" THEN CONCAT("+", VALUE)
                        ELSE CONCAT("-", VALUE)
                    END AS VALUE,
                    POINTS_PARAM_ICON_PATH,
                    PLAY_STMT_CUE
                FROM
                    dial_player_stmt_points_mstr pspm
                        INNER JOIN
                    dial_points_param_mstr dppm ON pspm.POINTS_PARAM_CODE = dppm.POINTS_PARAM_CODE
                        INNER JOIN
                    dial_player_stmt_mstr dpsm ON dpsm.PLAY_STMT_CODE = pspm.PLAY_STMT_CODE
                WHERE
                    dpsm.PLAY_STMT_CODE = ?
                        AND POINTS_PARAM_TYPE = "D"');
		$query = $this -> db -> query($sql, array($answer));
		return $query -> result();
	}
	
	function getBotSuggestions($searchtext) 
	{
		$sql = ('SELECT COMP_STMT_CODE,strip_tags(COMP_STMT_DESC) COMP_STMT_DESC FROM dial_comp_stmt_mstr 
		where COMP_STMT_TYPE = "BOT" AND lower(MEDIA_URL) like lower("%'.$searchtext.'%")');
		$query = $this -> db -> query($sql);
		return $query -> result();
	}	
	
	function getTimeAvailableForCurrentGame($ugsStatusId) 
	{
		$sql = ('SELECT greatest(round(dgssmm.TIME_LIMIT_SECONDS-time_to_sec(timediff(current_timestamp(),started_on))),0) TIME_AVAILABLE FROM dial_user_game_status  dugs
		INNER JOIN dial_game_seg_story_map_mstr dgssmm on dugs.GS_MAP_ID = dgssmm.GS_MAP_ID 
		where ugs_status_id = ?'); 
		$query = $this -> db -> query($sql, array($ugsStatusId));
		return $query -> result();
	}
	
	function getStoryForUserGame($gameId,$userId) 
	{
		//Returns story for game not played yet by the user
		$sql = ('select * from dial_story_mstr dsm 
		inner join dial_game_seg_story_map_mstr dgssmm on dsm.story_id = dgssmm.story_id 
		where game_id = ? and gs_map_id not in (SELECT gs_map_id FROM dial_user_game_status where user_id = ? and completed_on is not null) limit 1'); 
		$query = $this -> db -> query($sql, array($gameId,$userId));
		return $query -> result();
	}
	
	function getRandomStoryForGame($gameId) 
	{
		$sql = ('select * from dial_story_mstr dsm 
		inner join dial_game_seg_story_map_mstr dgssmm on dsm.story_id = dgssmm.story_id 
		where game_id = ?  ORDER BY RAND() limit 1'); 
		$query = $this -> db -> query($sql, array($gameId));
		return $query -> result();
	}
	
	function getGsMapIdForGameStory($gameId,$storyId) 
	{
		$sql = ('select * from dial_story_mstr dsm 
		inner join dial_game_seg_story_map_mstr dgssmm on dsm.story_id = dgssmm.story_id 
		where game_id = ?  and dsm.story_id = ?'); 
		$query = $this -> db -> query($sql, array($gameId,$storyId));
		return $query -> result();
	}
	
	function isGameStatusInitiated($userId,$gsMapId) 
	{
		$sql = ('SELECT case when count(*) > 0 then "TRUE" WHEN COUNT(*) = 0 THEN "FALSE" END AS ISGAME FROM dial_user_game_status where USER_ID = ? AND GS_MAP_ID = ?');
		$query = $this -> db -> query($sql, array($userId,$gsMapId));
		return $query -> result();
	}	
	
	function insertGameStatus($userId,$gsMapId,$universeToken) 
	{
		$sql = ('INSERT INTO dial_user_game_status (USER_ID,GS_MAP_ID,GAME_TOKEN) VALUES (?,?,?)');
		return $this -> db -> query($sql, array($userId,$gsMapId,$universeToken));
	}	
	
	function updateGameStatus($userId,$gsMapId,$status) 
	{
		if ($status == 'COMPLETED')
			$sql = ('update dial_user_game_status set COMPLETED_ON = (CURRENT_TIMESTAMP()) , STATUS = \'C\' where USER_ID = ? AND GS_MAP_ID = ?');
		else
			$sql = ('update dial_user_game_status set COMPLETED_ON = NULL , STATUS = \'P\' where USER_ID = ? AND GS_MAP_ID = ?');			
		$query = $this -> db -> query($sql, array($userId,$gsMapId));		
	}	
	
	function getFiltersForGame($gameId,$parentFilterId,$filterType) 
	{
		$sql = 'SELECT * FROM dial_filter_mstr where game_id = ? and status = \'A\' and FILTER_TYPE = ? and parent_filter_id ';
		if ($parentFilterId != '')
		{
			$sql = $sql.' = ?';
			$query = $this -> db -> query($sql, array($gameId,$filterType,$parentFilterId));
		}
		else
		{			
			$sql = $sql.' is null';
			$query = $this -> db -> query($sql, array($gameId,$filterType));			
		}
		return $query -> result();
	}	
	
	function getPlayStmtsForGameFilter($in) 
	{
		/*$in='GROUPED=5,STANDALONE3=8'*/
		$inArray = explode(',', $in);		
		$sql = 'SELECT PLAY_STMT_CODE,PLAY_STMT_DESC FROM (SELECT PARAM_OPTIONS_GROUP_CODE FROM dial_param_options_map_mstr 
					WHERE CONCAT(PARAMETER_CODE,COMPARATOR,VALUE) = '.$inArray[0].') t ';

        $i=0;		
		foreach ($inArray as $inArrayVal)
		{
            if (($i!=0))
            {		
				$condnArray = '';		
				$istr = $i;		
				$sql = $sql.' INNER JOIN  (SELECT PARAM_OPTIONS_GROUP_CODE FROM dial_param_options_map_mstr 
								WHERE CONCAT(PARAMETER_CODE,COMPARATOR,VALUE) = '.$inArrayVal.') t'.$istr.' on t.PARAM_OPTIONS_GROUP_CODE = t'.$istr.'.PARAM_OPTIONS_GROUP_CODE ';
			}
            $i++;			
		}
		$sql = $sql.' INNER JOIN dial_player_stmt_mstr dcsm ON t.PARAM_OPTIONS_GROUP_CODE = dcsm.PARAM_OPTIONS_GROUP_CODE ';
		$query = $this -> db -> query($sql);
		return $query -> result();
	}	
	
	function getStoriesForGame($gameId)
	{
		$sql = ('SELECT * FROM dial_game_seg_story_map_mstr dgssmm inner join dial_story_mstr dsm on dgssmm.story_id = dsm.story_id where game_id = ?');
		$query = $this -> db -> query($sql, array($gameId));
		return $query -> result();		
	}

	function getStoriesForGameUser($gameId,$userId)
	{
		// Returns all stories with lock unlock status and level/story rate for the given user and game
		$sql = ('		SELECT dgssmm.GS_MAP_ID,dgssmm.GAME_ID,dgssmm.STORY_ID,TIME_LIMIT_SECONDS,STORY_TITLE,STORY_DESC,STORY_SHORT_DESC,STORY_LANGUAGE,STORY_LOGO_URL, 
		round(((sum(COALESCE (value,0))/STAR_MAX_VAL)*3),0) MY_STAR_VAL, 
		case when round(((sum(COALESCE (value,0))/STAR_MAX_VAL)*3),0) < 1  || round(((sum(COALESCE (value,0))/STAR_MAX_VAL)*3),0) is null
		then \'YES\' else \'NO\' end NEXT_STORY_LOCK
		FROM dial_game_seg_story_map_mstr dgssmm 
		left join dial_story_mstr dsm on dgssmm.story_id = dsm.story_id 
		left join (select * from dial_user_game_status where user_id = ?) dugs on dgssmm.GS_MAP_ID = dugs.GS_MAP_ID 
		left JOIN dial_player_points_tbl ppt on dugs.UGS_STATUS_ID = ppt.UGS_STATUS_ID 
        left join dial_story_param_target_mstr dsptm on dsptm.story_id = dgssmm.story_id
		where game_id = ? and dsptm.TARGET_TYPE  = \'M\' 
        and (user_id = ? or user_id is null)
		group by 1,2,3,4,5,6  order by story_seq_no');
		$query = $this -> db -> query($sql, array($userId,$gameId,$userId));
		return $query -> result();		
	}
	function getStoriesForGameUserwithPurchasedStatus($gameId,$userId)
	{
		// Returns all stories with lock unlock status and level/story rate for the given user and game
		$sql = ('		SELECT dgssmm.GS_MAP_ID,dgssmm.GAME_ID,dgssmm.STORY_ID,TIME_LIMIT_SECONDS,STORY_TITLE,STORY_DESC,STORY_SHORT_DESC,STORY_LANGUAGE,STORY_LOGO_URL, 
		round(((sum(COALESCE (value,0))/STAR_MAX_VAL)*3),0) MY_STAR_VAL, 
		case when round(((sum(COALESCE (value,0))/STAR_MAX_VAL)*3),0) < 1  || round(((sum(COALESCE (value,0))/STAR_MAX_VAL)*3),0) is null
		then \'YES\' else \'NO\' end NEXT_STORY_LOCK,
		case when dugpt.UGP_ID is null
		then \'NO\' else \'YES\' end LEVEL_PURCHASED 
		FROM dial_game_seg_story_map_mstr dgssmm 
		left join dial_story_mstr dsm on dgssmm.story_id = dsm.story_id 
		left join (select * from dial_user_game_status where user_id = ?) dugs on dgssmm.GS_MAP_ID = dugs.GS_MAP_ID 
		left JOIN dial_player_points_tbl ppt on dugs.UGS_STATUS_ID = ppt.UGS_STATUS_ID 
        left join dial_story_param_target_mstr dsptm on dsptm.story_id = dgssmm.story_id
		left join (select * from dial_user_game_purchase_tbl where user_id = ? and status = "A") dugpt on dgssmm.GS_MAP_ID = dugpt.GS_MAP_ID
		where game_id = ? and dsptm.TARGET_TYPE  = \'M\' 
        and (dugpt.user_id = ? or dugpt.user_id is null)
		group by 1,2,3,4,5,6  order by story_seq_no');
		$query = $this -> db -> query($sql, array($userId,$userId,$gameId,$userId));
		return $query -> result();		
	}
	
	function getStory($storyId)
	{
		$sql = ('SELECT * FROM dial_story_mstr where story_id=?');
		$query = $this -> db -> query($sql, array($storyId));
		return $query -> result();		
	}
	
	function getHistory($ugsStatusId)
	{
		$sql = ('SELECT 
                    *
                FROM
                    (SELECT 
                        PLAY_ACTION_CODE,
                            COMP_STMT_TITLE,
                            COMP_STMT_DESC DESCR,
                            COMP_STMT_TYPE,
                            MEDIA_URL,
                            IMAGE_CSS_CLASS
                    FROM
                        dial_player_action_tbl dpat
                    LEFT JOIN dial_comp_stmt_mstr dcsm ON dpat.comp_stmt_code = dcsm.comp_stmt_code
                    WHERE
                        UGS_STATUS_ID = ?
                            AND COMP_STMT_TYPE NOT IN ("STORY" , "VIEW") UNION SELECT 
                        PLAY_ACTION_CODE,
                            "" COMP_STMT_TITLE,
                            PLAY_STMT_DESC DESCR,
                            "" COMP_STMT_TYPE,
                            "resources/img/blank_user.png" MEDIA_URL,
                            ""
                    FROM
                        dial_player_action_tbl dpat
                    LEFT JOIN dial_player_stmt_mstr dpsm ON dpat.play_stmt_code = dpsm.play_stmt_code
                    WHERE
                        UGS_STATUS_ID = ?
                            AND PLAY_STMT_DESC <> "NULL") A
                ORDER BY A.PLAY_ACTION_CODE');
		$query = $this -> db -> query($sql, array($ugsStatusId,$ugsStatusId));
		return $query -> result();	
	}
	
	function getFiltersforQuestion($compstmtcode)
	{
		$sql = ('SELECT dpsm.PLAY_STMT_CODE,dpsm.PLAY_STMT_DESC,dfm.FILTER_ID,FILTER_TITLE,FILTER_ICON_PATH FROM dial_player_stmt_mstr dpsm	LEFT JOIN dial_player_stmt_filter_map_mstr dpfm on dpsm.play_stmt_code = dpfm.play_stmt_code
		left join dial_filter_mstr dfm on dpfm.filter_id = dfm.filter_id where source_comp_stmt_code = ?');
		$query = $this -> db -> query($sql, array($compstmtcode));
		return $query -> result();	
	}
	
	function getStoryForStarter($compstmtcode)
	{
		// Master Story Writing
		$sql = ('SELECT dpsm.PLAY_STMT_CODE,dpsm.PLAY_STMT_DESC,dfm.FILTER_ID,FILTER_TITLE,FILTER_ICON_PATH FROM dial_player_stmt_mstr dpsm	LEFT JOIN dial_player_stmt_filter_map_mstr dpfm on dpsm.play_stmt_code = dpfm.play_stmt_code
		left join dial_filter_mstr dfm on dpfm.filter_id = dfm.filter_id where source_comp_stmt_code = ?');
		$query = $this -> db -> query($sql, array($compstmtcode));
		return $query -> result();	
	}
	
	function getBulkStory($storyId)
	{
		//$sql = ('SELECT TREE_ID as id,TREE_PARENT_ID as parent,DESCRIPTION as name from bulk_story_upload where STORY_ID = ?');
		$sql = ('select * from (
				select concat(\'A\',play_stmt_code) AS id,play_stmt_desc as name,CONCAT(\'Q\',source_comp_stmt_code) AS parent from (select * from dial_comp_stmt_mstr where comp_stmt_code like \'1000%\') dcsm  left join (select * from dial_player_stmt_mstr where play_stmt_code like \'1000%\') dpsm on dcsm.comp_stmt_code =  dpsm.DESTN_COMP_STMT_CODE
				UNION ALL
				select ifnull(CONCAT(\'Q\',destn_comp_stmt_code),\'Q10001\') AS id, comp_stmt_desc as name, ifnull(concat(\'A\',play_stmt_code),\'0\') AS parent from (select * from dial_comp_stmt_mstr where comp_stmt_code like \'1000%\') dcsm  left join (select * from dial_player_stmt_mstr where play_stmt_code like \'1000%\') dpsm on dcsm.comp_stmt_code =  dpsm.DESTN_COMP_STMT_CODE)
				a where a.name is not null order by a.parent');
		$query = $this -> db -> query($sql, array($storyId));
		return $query -> result();	
	}	
	
	function getPlayerAnswersCategoryCountForStory($ugsStatusId,$parameterCode)
	{
		/* Used to get Feedback page data for Chart at Story Level - $parameterCode = 'GROUPED'/'STANDALONE'*/		
		$sql = ('SELECT 
                    CASE
                        WHEN FILTER_TITLE IS NULL THEN "Others"
                        ELSE FILTER_TITLE
                    END AS FILTER_TITLE,
                    a.cnt,
                    a.total,
                    ROUND((a.cnt * 100 / a.total), 2) percent
                FROM
                    (SELECT 
                        FILTER_TITLE,
                            COUNT(*) cnt,
                            (SELECT 
                                    COUNT(*)
                                FROM
                                    dial_player_action_tbl
                                WHERE
                                    ugs_status_id = ?) total
                    FROM
                        dial_player_action_tbl dpat
                    LEFT JOIN dial_player_stmt_mstr dpsm ON dpat.PLAY_STMT_CODE = dpsm.PLAY_STMT_CODE
                    LEFT JOIN (SELECT 
                        *
                    FROM
                        dial_param_options_map_mstr
                    WHERE
                        PARAMETER_CODE = ?) dpomm ON dpomm.PARAM_OPTIONS_GROUP_CODE = dpsm.PARAM_OPTIONS_GROUP_CODE
                    LEFT JOIN dial_filter_mstr dfm ON dfm.filter_id = dpomm.value
                    WHERE
                        ugs_status_id = ?
                            AND (PARAMETER_CODE = ?
                            OR PARAMETER_CODE IS NULL)
                    GROUP BY 1) a');
		$query = $this -> db -> query($sql, array($ugsStatusId,$parameterCode,$ugsStatusId,$parameterCode));
		return $query -> result();			
	}

	function getPlayerAnswersCategoryCountForGame($userId,$gameId,$parameterCode)
	{
		/* Used to get Feedback page data for Chart at User Game Level - $parameterCode = 'GROUPED'/'STANDALONE' */
		$sql = ('select a.FILTER_TITLE,a.cnt,a.total,round(a.cnt*100/a.total) percent from (
				select FILTER_TITLE,count(*) cnt,(select count(*) from dial_player_action_tbl where UGS_STATUS_ID in (
				SELECT UGS_STATUS_ID FROM dial_user_game_status dugs
				inner join dial_game_seg_story_map_mstr dgssmm on dugs.GS_MAP_ID = dgssmm.GS_MAP_ID
				where user_id = ? and game_id=?)) total from dial_player_action_tbl dpat  
				inner join dial_player_stmt_mstr dpsm on dpat.PLAY_STMT_CODE = dpsm.PLAY_STMT_CODE 
				inner join dial_param_options_map_mstr dpomm on dpomm.PARAM_OPTIONS_GROUP_CODE = dpsm.PARAM_OPTIONS_GROUP_CODE 
				inner join dial_filter_mstr dfm on dfm.filter_id = dpomm.value 
				where UGS_STATUS_ID in (
				SELECT UGS_STATUS_ID FROM dial_user_game_status dugs
				inner join dial_game_seg_story_map_mstr dgssmm on dugs.GS_MAP_ID = dgssmm.GS_MAP_ID
				where user_id = ? and game_id=?) and PARAMETER_CODE = ? group by 1) a');
		$query = $this -> db -> query($sql, array($userId,$gameId,$userId,$gameId,$parameterCode));
		return $query -> result();			
	}	
	
	function getPercentTargetAchievedForStory($ugsStatusId,$targetTypeMain)
	{
		/* Used to get Feedback page data for target achieved in progress bar at Story Level*/
		$sql = ('SELECT POINTS_PARAM_DESC,SUM(value)value,max(target)target,case when round(sum(value)/max(target)*100)  > 100 then 100 when round(sum(value)/max(target)*100)  < (-100) then (-100) else round(sum(value)/max(target)*100) end PERCENT, POINTS_PARAM_ICON_PATH FROM dial_player_points_tbl dppt
        inner join dial_story_param_target_mstr dsptm on dppt.POINTS_PARAM_CODE  = dsptm.POINTS_PARAM_CODE
        inner join dial_points_param_mstr dppm on dppt.POINTS_PARAM_CODE  = dppm.POINTS_PARAM_CODE
		inner join dial_user_game_status dugs on dugs.ugs_status_id = dppt.ugs_status_id
		inner join dial_game_seg_story_map_mstr dgssmm on dgssmm.story_id = dsptm.story_id
		where dppt.ugs_status_id= ? 
		
		AND ');
		if($targetTypeMain == 'Y')
			$sql = $sql.'dsptm.TARGET_TYPE = "M" ';
		else
			$sql = $sql.'dsptm.TARGET_TYPE != "M" ';
		$sql = $sql.'GROUP BY 1,5 ';
		$query = $this -> db -> query($sql, array($ugsStatusId));
		return $query -> result();			
	}	
	
	function getPercentTargetAchievedForGame($userId,$gameId)
	{
		/* Used to get Feedback page data for target achieved in progress bar at User Game Level */
		$sql = ('SELECT value,target,case when round(value/target*100) > 100 then 100 when round(value/target*100) < (-100) then (-100) else round(value/target*100) end percent FROM dial_player_points_tbl dppt
		inner join dial_story_param_target_mstr dsptm on dppt.POINTS_PARAM_CODE  = dsptm.POINTS_PARAM_CODE
		inner join dial_user_game_status dugs on dugs.ugs_status_id = dppt.ugs_status_id
		inner join dial_game_seg_story_map_mstr dgssmm on dgssmm.story_id = dsptm.story_id
		where dppt.ugs_status_id in (SELECT UGS_STATUS_ID FROM dial_user_game_status dugs
		inner join dial_game_seg_story_map_mstr dgssmm on dugs.GS_MAP_ID = dgssmm.GS_MAP_ID
		where user_id = ? and game_id=?) ');
		$query = $this -> db -> query($sql, array($userId,$gameId));
		return $query -> result();			
	}
	
	function getMainTargetForStory($storyId)
	{
		/* Used to get Main Target Value for Story for display*/
		$sql = ('SELECT * FROM dial_story_param_target_mstr where story_id = ? and target_type = \'M\'');
		$query = $this -> db -> query($sql, array($storyId));
		return $query -> result();			
	}
    function getPlayerStmtForPlayStmtCode($playstmtcode)
    {
        $sql = ('select * from dial_player_stmt_mstr where PLAY_STMT_CODE = ?');
        $query = $this -> db -> query($sql, array($playstmtcode));
        return $query -> result_array();
        
    }
    function getGameletCardForCompStmtCode($compStmtCode)
    {
        $sql = ('SELECT * FROM gamelet_card where COMP_STMT_CODE=?');
        $query = $this -> db -> query($sql, array($compStmtCode));
        return $query -> result_array();
    }
    function getActionsTblDtlsForUgsAndCompStmtCode($ugsStatusId,$compstmtcode)
    {
        $sql = ('select * from dial_player_action_tbl where UGS_STATUS_ID = ? and COMP_STMT_CODE=?');
        $query = $this -> db -> query($sql, array($ugsStatusId,$compstmtcode));
        return $query -> result_array();
    }
    function updateActions($compstmtcode,$playstmtcode,$ugsStatusId) 
    {
        $sql = ('UPDATE dial_player_action_tbl SET PLAY_STMT_CODE=? where UGS_STATUS_ID = ? and COMP_STMT_CODE=?');
        $query = $this -> db -> query($sql, array($playstmtcode,$ugsStatusId,$compstmtcode));
    }
    function getGameTypeByUniverseToken($universeToken)
    {//to get game type by universe token for mapping user to gs_map_id in user_game_status table
    $stratupdb = $this->load->database('stratup', TRUE);
        $sql = ('select gbt.UNIVERSE_TOKEN,stm.STRATUP_TYPE from game_batch_tbl gbt
                    inner join product_universe_mode_map_mstr pummm on 
                    gbt.PRODUCT_UNIVERSE_MODE_MAP_ID=pummm.PRODUCT_UNIVERSE_MODE_MAP_ID
                    inner join product_universe_type_mapping_mstr putmm on 
                    pummm.PRODUCT_UNIVERSE_MAP_ID=putmm.PRODUCT_UNIVERSE_TYPE_MAP_ID
                    inner join stratup_type_mstr stm on putmm.STRATUP_PRODUCT_TYPE_ID=stm.STRATUP_TYPE_ID
                    where UNIVERSE_TOKEN=?');
        $query = $stratupdb -> query($sql, array($universeToken));
        return $query -> result_array();
    }
	function getUgsStatusForUserIdGameToken($userId,$univerToken)
	{
	    $sql = ('Select * from dial_user_game_status where USER_ID=? and GAME_TOKEN=?');
	    $query = $this -> db -> query($sql, array($userId,$univerToken));
	        return $query -> result_array();
	}
	function getGameletForUser($userId)
	{
		//Created by : Ashwini
	    $sql = ('SELECT dgm.GAME_ID,GAME_TITLE,GAME_DESC,GAME_LOGO_PATH,COALESCE(SPLASH_SCREEN_PATH,"")SPLASH_SCREEN_PATH,IFNULL(UNITY_SEQ_NO,0)UNITY_SEQ_NO, 
		case when UGP_ID is null
		then "NO" else "YES" end GAME_PURCHASED from dial_game_mstr dgm  
		LEFT JOIN (SELECT dugpt.*,dgssmm.GAME_ID from dial_user_game_purchase_tbl dugpt
		INNER JOIN dial_game_seg_story_map_mstr dgssmm on dgssmm.GS_MAP_ID = dugpt.GS_MAP_ID
		WHERE USER_ID = ? and dugpt.status = "A" ) A on A.GAME_ID = dgm.GAME_ID
		WHERE dgm.GAME_CAT_ID in (5,8,9) and dgm.status = "A" group by dgm.GAME_ID order by UNITY_SEQ_NO');
	    $query = $this -> db -> query($sql, array($userId));
	        return $query -> result_array();
	}
	function getGameletLevelsForUser($userId,$gameId)
	{
		//Created by : Ashwini
	    $sql = ('SELECT dugpt.*,dsm.* FROM dial_user_game_purchase_tbl dugpt 
					inner join dial_game_seg_story_map_mstr dgssmm on dugpt.GS_MAP_ID=dgssmm.GS_MAP_ID 
					inner join dial_story_mstr dsm on dsm.STORY_ID = dgssmm.STORY_ID
					where USER_ID = ? and GAME_ID=? and dugpt.STATUS=\'A\'');
	    $query = $this -> db -> query($sql, array($userId,$gameId));
	        return $query -> result_array();
	}
	function getInitialCompPlayStmtForStory($storyId)
	{
		//Created by : Ashwini
	    $sql = ('SELECT dcsm.COMP_STMT_CODE,
	    				dcsm.COMP_STMT_TITLE,
	    				dcsm.COMP_STMT_DESC,
						COMP_STMT_TYPE,
	    				dcsm.MEDIA_URL,
	    				dcsm.MEDIA_TYPE,
						dcsm.PLAYER_MEDIA_URL,
	    				dcsm.IMG_BG 
					FROM dial_story_mstr dsm 
					inner join dial_comp_stmt_mstr dcsm on dsm.START_COMP_STMT_CODE = dcsm.COMP_STMT_CODE
					where story_id=?');
	    $query = $this -> db -> query($sql, array($storyId));
	        return $query -> result_array();
	}
	function getPlayStmtForCompStmtCode($compstmtcode)
	{
		//Created by : Ashwini
	    $sql = ('SELECT PLAY_STMT_CODE,PLAY_STMT_DESC,DESTN_COMP_STMT_CODE,MEDIA_URL,SOURCE_COMP_STMT_CODE,MEDIA_URL
					FROM dial_player_stmt_mstr where SOURCE_COMP_STMT_CODE=?');
	    $query = $this -> db -> query($sql, array($compstmtcode));
	        return $query -> result_array();
	}
	function getCompStmtForCompStmtCode($compstmtcode)
	{
		//Created by : Ashwini
	    $sql = ('SELECT COMP_STMT_CODE,
	    				COMP_STMT_TITLE,
	    				COMP_STMT_DESC,
	    				COMP_STMT_TYPE,
	    				MEDIA_URL,
	    				MEDIA_TYPE,
						PLAYER_MEDIA_URL,
	    				IMG_BG,
						IFNULL(IMAGE_CSS_CLASS,"")IMAGE_CSS_CLASS 
					FROM dial_comp_stmt_mstr where COMP_STMT_CODE=?');
	    $query = $this -> db -> query($sql, array($compstmtcode));
	        return $query -> result_array();
	}
	function getCardForCompStmtCode($compstmtcode)
	{
		//Created by : Ashwini
	    $sql = ('SELECT COMP_STMT_CODE,
	    				CARD_CODE,
	    				CARD_TYPE,
	    				CARD_TITLE,
	    				concat(CARD_DESC," \n",VALUE1," \n",VALUE2)CARD_DESC,
	    				ICON_IMG_PATH 
					FROM gamelet_card where COMP_STMT_CODE=?');
	    $query = $this -> db -> query($sql, array($compstmtcode));
	        return $query -> result_array();
	}
	function getStoryForGame($gameId)
	{
		//Created By : Ashwini
		$sql = ("SELECT dgssmm.* FROM dial_game_seg_story_map_mstr dgssmm
					inner join dial_story_mstr dsm on dsm.STORY_ID = dgssmm.STORY_ID
					where GAME_ID=?");
		$query = $this -> db -> query($sql, array($gameId));
	        return $query -> result_array();
	}
	function insertGamePurchase($userId,$gameId)
    {
    	//Created By : Ashwini
        $sql = ('insert into dial_user_game_purchase_tbl(USER_ID,GS_MAP_ID,STATUS) values(?,?,\'A\')');
		return $this -> db -> query($sql, array($userId,$gameId));
    }

    function getZoneSubCategoryForZone($zoneId)
	{
		//Created By : Ashwini
		$sql = ('SELECT ZONE_SUB_CATEGORY_ID,ZONE_SUB_CATEGORY_DESC,ZONE_ID,QUESTION_ID,IFNULL(CARD_CODE_REQUIRED_TO_UNLOCK,"")CARD_CODE_REQUIRED_TO_UNLOCK FROM board_zone_sub_category_mstr where ZONE_ID = ?');
		$query = $this -> db -> query($sql, array($zoneId));
	        return $query -> result_array();
	}

	function insertCardToInventory($params) 
	{
		//Created by : Ashwini
		return $this->db->insert('dial_user_game_inventory', $params);
		//return $this->db->insert_id();
	}

	function getCardFromInventoryForUgsIdCardCode($ugsId, $cardCode)
	{
		//Created By : Ashwini
		$sql = ("SELECT * FROM dial_user_game_inventory where UGS_ID = ? AND CARD_CODE = ?");
		$query = $this -> db -> query($sql, array($ugsId, $cardCode));
	        return $query -> result_array();
	}

	function getAllCardsFromInventoryForUgsIdUserId($ugsId, $userId)
	{
		//Created By : Ashwini
		$sql = ("SELECT CARD_CODE,CARD_USED_STATUS FROM dial_user_game_inventory  
					where UGS_ID = ? AND USER_ID = ?");
		$query = $this -> db -> query($sql, array($ugsId, $userId));
	        return $query -> result_array();
	}

	function getCardsFromInventoryForUgsIdCardType($ugsId, $cardType)
	{
		//Created By : Ashwini
		$sql = ("SELECT gc.* FROM dial_user_game_inventory dugi inner join gamelet_card gc on gc.CARD_CODE = dugi.CARD_CODE where UGS_ID = ? AND CARD_TYPE = ? AND CARD_USED_STATUS = 'N' ");
		$query = $this -> db -> query($sql, array($ugsId, $cardType));
	        return $query -> result_array();
	}

	function getProcessCardLevelWiseSequence($ugsId)
	{
		//Created By : Ashwini
		$sql = ("SELECT dpsm.LEVEL_ID,dpsm.CARD_CODE,dpsm.SEQ_NO,A.UGS_ID,A.CARD_TITLE FROM dial_process_seq_mstr
		 dpsm left join (select dupt.*,gc.CARD_TITLE from dial_user_process_tbl dupt
			 inner join gamelet_card gc on gc.CARD_CODE = dupt.CARD_CODE where ugs_id = ?) A 
			 on dpsm.CARD_CODE = A.CARD_CODE AND dpsm.LEVEL_ID = A.LEVEL_ID 
		 ORDER BY dpsm.LEVEL_ID , dpsm.SEQ_NO Asc");
		$query = $this -> db -> query($sql, array($ugsId));
		 //echo $this->db->last_query();
	        return $query -> result_array();
	}

	function updateCardUsedStatusForCardCode($ugsId, $cardCode, $cardUsedStatus)
	{
		//Created By : Ashwini
		$sql = ('UPDATE dial_user_game_inventory SET CARD_USED_STATUS = ? where UGS_ID = ? and CARD_CODE = ?');
        $query = $this -> db -> query($sql, array($cardUsedStatus,$ugsId,$cardCode));
	}

	function insertCardToProcess($params) 
	{
		//Created by : Ashwini
		return $this->db->insert('dial_user_process_tbl', $params);
		//return $this->db->insert_id();
	}

	function getUserProcessCardArranged($ugsId)
	{
		//Created By : Ashwini
		$sql = ("SELECT * FROM dial_user_process_tbl where UGS_ID = ? order by LEVEL_ID , SEQ_NO Asc");
		$query = $this -> db -> query($sql, array($ugsId));
	        return $query -> result_array();
	}

	function getInputCardsForCompStmtCode($compstmtcode)
	{
		//Created by : Ashwini
	    $sql = ('SELECT COMP_STMT_CODE,
	    				CARD_CODE
					FROM dial_user_comp_stmt_input_mstr where COMP_STMT_CODE=?');
	    $query = $this -> db -> query($sql, array($compstmtcode));
	        return $query -> result_array();
	}

	function getDefaultScore($gsMapId)
	{
		//Created by : Ashwini
	    $sql = ('SELECT dppm.POINTS_PARAM_CODE,POINTS_PARAM_DESC ,IFNULL(POINTS_PARAM_ICON_PATH,"")POINTS_PARAM_ICON_PATH, DEFAULT_SCORE AS VALUE 
	    	FROM dial_story_param_target_mstr dsptm 
			inner join dial_points_param_mstr dppm on dsptm.POINTS_PARAM_CODE  = dppm.POINTS_PARAM_CODE
			inner join dial_game_seg_story_map_mstr dgssmm on dgssmm.story_id = dsptm.story_id  
			where dgssmm.gs_map_id= ? AND DPPM.POINTS_PARAM_TYPE IN (\'N\',\'D\',\'A\') 
			GROUP BY 1,2 order by dsptm.POINTS_PARAM_CODE;');
	    $query = $this -> db -> query($sql, array($gsMapId));
	        return $query -> result_array();
	}

	function getugsIdForGameIdUserId($userId,$gameId)
	{
		//Created by : Ashwini
	    $sql = ('SELECT UGS_STATUS_ID,USER_ID,dugs.GS_MAP_ID,GAME_TAG from dial_user_game_status dugs 
					inner join dial_game_seg_story_map_mstr dgssmm on dgssmm.GS_MAP_ID = dugs.GS_MAP_ID
					inner join dial_game_mstr dgm on dgm.GAME_ID = dgssmm.GAME_ID
					where dgm.GAME_ID = ? and user_id = ?');
	    $query = $this -> db -> query($sql, array($gameId, $userId));
	        return $query -> result_array();
	}

	function getOverAllGameletScoreforUser($userId)
	{
		//Created by : Ashwini
	    $sql = ('SELECT USER_ID,dugs.UGS_STATUS_ID,dgssmm.GS_MAP_ID,sum(VALUE) TOTAL_SCORE from dial_player_points_tbl dppt
		inner join dial_user_game_status dugs on dugs.UGS_STATUS_ID = dppt.UGS_STATUS_ID
		INNER JOIN dial_game_seg_story_map_mstr dgssmm on dgssmm.GS_MAP_ID = dugs.GS_MAP_ID
		inner join dial_game_mstr dgm on dgm.GAME_ID = dgssmm.GAME_ID
		where USER_ID = ? and dgm.GAME_CAT_ID in (5,8,9) and dgm.status = "A" ');
	    $query = $this -> db -> query($sql, array($userId));
	    return $query -> result_array();
	}
	function getPlayerOptionsForCompCode($compStmtCode)
	{
		//Created by : Leela
	    $sql = ('SELECT DISTINCT
						FILTER_TITLE
					FROM
						dial_player_stmt_mstr dpsm
							INNER JOIN
						dial_param_options_map_mstr dpom ON dpom.PARAM_OPTIONS_GROUP_CODE = dpsm.PARAM_OPTIONS_GROUP_CODE
							INNER JOIN
						dial_filter_mstr dfm ON dfm.FILTER_ID = dpom.VALUE
					WHERE
						SOURCE_COMP_STMT_CODE = ?
							AND PARAMETER_CODE = "GROUPED"
					ORDER BY 1');
	    $query = $this -> db -> query($sql, array($compStmtCode));
	        return $query -> result_array();
	}
	function getPlayStmtForCompStmtCodeAndPlayerOption($compstmtcode,$playerOption)
	{
		//Created by : Leela
	    $sql = ('SELECT 
					PLAY_STMT_CODE,
					PLAY_STMT_DESC,
					DESTN_COMP_STMT_CODE,
					MEDIA_URL,
					SOURCE_COMP_STMT_CODE,
					MEDIA_URL
				FROM
					dial_player_stmt_mstr dpsm
						LEFT JOIN
					dial_param_options_map_mstr dpom ON dpom.PARAM_OPTIONS_GROUP_CODE = dpsm.PARAM_OPTIONS_GROUP_CODE
						LEFT JOIN
					dial_filter_mstr dfm ON dfm.FILTER_ID = dpom.VALUE
				WHERE
					SOURCE_COMP_STMT_CODE = ?
						AND PARAMETER_CODE = "GROUPED"
						AND FILTER_TITLE = ?
				ORDER BY 1');
	    $query = $this -> db -> query($sql, array($compstmtcode,$playerOption));
	        return $query -> result_array();
	}
	function getInterimQforCompStmt($compstmtcode)
	{
		//Created by : Leela
	    $sql = ('SELECT 
					INTQN_MAP_CODE,
					COMP_STMT_CODE,
					INTQN_CODE
				FROM
					dial_intqn_map_mstr
				WHERE
					STATUS = "A" and
					COMP_STMT_CODE = ?');
	    $query = $this -> db -> query($sql, array($compstmtcode));
	        return $query -> result_array();
	}
	function getInterimQuestionforQcode($qcode)
	{
		//Created by : Leela
	    $sql = ('SELECT 
					INTQN_CODE, INTQN_TITLE, INTQN_DESC, INTQN_IMG
				FROM
					dial_intqn_mstr
				WHERE
					STATUS = "A" AND INTQN_CODE = ?');
	    $query = $this -> db -> query($sql, array($qcode));
	        return $query -> result_array();
	}
	function getInterimAnsforQcode($qcode)
	{
		//Created by : Leela
	    $sql = ('SELECT 
					INTANS_CODE,
					INTQN_CODE,
					INTANS_TITLE,
					INTANS_DESC,
					INTANS_IMG
				FROM
					dial_intans_mstr
				WHERE
					STATUS = "A" AND INTQN_CODE = ?');
	    $query = $this -> db -> query($sql, array($qcode));
	        return $query -> result_array();
	}
	function getAvailableIntermResponseForUgs($ugsStatusId,$intQnMapCode)
	{
		//Created by : Leela
	    $sql = ('SELECT 
		PLAY_INTACTION_CODE,
		UGS_STATUS_ID,
		INTQN_MAP_CODE,
		INTANS_CODE,
		TXT_PLAY_ENTRY1,
		TIMESTAMP
	FROM
		dial_player_intaction_tbl
	WHERE
		UGS_STATUS_ID = ? AND INTQN_MAP_CODE = ?');
	    $query = $this -> db -> query($sql, array($ugsStatusId,$intQnMapCode));
	        return $query -> result_array();
	}
	function insertIntermResponse($insertParamdata)
	{
		$this->db->insert('dial_player_intaction_tbl', $insertParamdata);
	}
	function updateIntermResponse($updateParamdata)
	{
		$this->db->update('dial_player_intaction_tbl', $updateParamdata, array('UGS_STATUS_ID' => $updateParamdata['UGS_STATUS_ID'],'INTQN_MAP_CODE'=>$updateParamdata['INTQN_MAP_CODE']));
	}

	function getNumberScoresForCurrentStory($ugsStatusId)
	{
		$sql = 'SELECT dppm.POINTS_PARAM_DESC,COALESCE((SUM(VALUE)),0) SCORE,COALESCE((MAX(TARGET)),0) TARGET,COALESCE((SUM(VALUE)/MAX(TARGET)*100),0) PERCENTAGE_SCORE FROM (SELECT * FROM DIAL_PLAYER_POINTS_TBL WHERE UGS_STATUS_ID = ?) DPPT 
		INNER JOIN dial_user_game_status DUGS ON DUGS.UGS_STATUS_ID = DPPT.UGS_STATUS_ID
		INNER JOIN dial_game_seg_story_map_mstr dgssmm on dgssmm.GS_MAP_ID = DUGS.GS_MAP_ID
		RIGHT JOIN dial_points_param_mstr dppm ON DPPT.POINTS_PARAM_CODE = dppm.POINTS_PARAM_CODE
		INNER JOIN dial_story_param_target_mstr dsptm ON dppm.POINTS_PARAM_CODE = dsptm.POINTS_PARAM_CODE
		WHERE DPPM.POINTS_PARAM_TYPE = \'S\' GROUP BY 1';
	    $query = $this -> db -> query($sql, array($ugsStatusId));
		return $query -> result_array();		
	}

	function getBooleanScoresForCurrentStory($ugsStatusId)
	{
		$sql = 'SELECT dppm.POINTS_PARAM_DESC,CASE VALUE WHEN MAX(VALUE) > 0 THEN \'Yes\' ELSE \'No\' END SCORE FROM (SELECT * FROM DIAL_PLAYER_POINTS_TBL WHERE UGS_STATUS_ID = ?) DPPT 
		INNER JOIN dial_user_game_status DUGS ON DUGS.UGS_STATUS_ID = DPPT.UGS_STATUS_ID
		INNER JOIN dial_game_seg_story_map_mstr dgssmm on dgssmm.GS_MAP_ID = DUGS.GS_MAP_ID
		RIGHT JOIN dial_points_param_mstr dppm ON DPPT.POINTS_PARAM_CODE = dppm.POINTS_PARAM_CODE
		WHERE DPPM.POINTS_PARAM_TYPE = \'B\' group by 1';
	    $query = $this -> db -> query($sql, array($ugsStatusId));
		return $query -> result_array();		
	}

	function getNodesFacedForCurrentStory($ugsStatusId)
	{
		$sql = 'SELECT COUNT(*) NODESFACED FROM dial_player_action_tbl dpat WHERE DPAT.UGS_STATUS_ID = ?';
	    $query = $this -> db -> query($sql, array($ugsStatusId));
		return $query -> result_array();		
	}

	function getTimetakenForCurrentStory($ugsStatusId)
	{
		$sql = 'SELECT ROUND((TIME_TO_SEC(TIMEDIFF(COMPLETED_ON,STARTED_ON))/60),1)  TIMETAKEN FROM dial_user_game_status WHERE UGS_STATUS_ID = ?';
	    $query = $this -> db -> query($sql, array($ugsStatusId));
		return $query -> result_array();		
	}

	function getOutcomeForCurrentStory($ugsStatusId)
	{
		$sql = 'SELECT MAX(DPPM1.POINTS_PARAM_DESC) OUTCOME FROM DIAL_PLAYER_POINTS_TBL DPPT1 
		INNER JOIN dial_points_param_mstr DPPM1 ON DPPM1.POINTS_PARAM_CODE = DPPT1.POINTS_PARAM_CODE
		WHERE VALUE = 
		(SELECT MAX(VALUE) FROM DIAL_PLAYER_POINTS_TBL DPPT 
		INNER JOIN dial_points_param_mstr DPPM ON DPPM.POINTS_PARAM_CODE = DPPT.POINTS_PARAM_CODE
		WHERE DPPT.UGS_STATUS_ID = ? AND DPPM.POINTS_PARAM_TYPE = \'O\')
		AND  DPPT1.UGS_STATUS_ID = ? AND DPPM1.POINTS_PARAM_TYPE = \'O\'';
	    $query = $this -> db -> query($sql, array($ugsStatusId,$ugsStatusId));
		return $query -> result_array();		
	}

	function getDominantTraitsForCurrentStory($ugsStatusId)
	{
		$sql = 'SELECT * FROM
		(SELECT dppm.POINTS_PARAM_DESC,SUM(VALUE)/MAX(TARGET) PERCENTAGE_SCORE
				FROM DIAL_PLAYER_POINTS_TBL DPPT 
				INNER JOIN dial_user_game_status DUGS ON DUGS.UGS_STATUS_ID = DPPT.UGS_STATUS_ID
				INNER JOIN dial_game_seg_story_map_mstr dgssmm on dgssmm.GS_MAP_ID = DUGS.GS_MAP_ID
				INNER JOIN dial_points_param_mstr dppm ON DPPT.POINTS_PARAM_CODE = dppm.POINTS_PARAM_CODE
				INNER JOIN dial_story_param_target_mstr dsptm ON dppm.POINTS_PARAM_CODE = dsptm.POINTS_PARAM_CODE
				where DUGS.UGS_STATUS_ID = ? GROUP BY 1) B WHERE B.PERCENTAGE_SCORE = (
				SELECT MAX(A.PERCENTAGE_SCORE) FROM 
				(SELECT DPPT.POINTS_PARAM_CODE,SUM(VALUE) SCORE,MAX(TARGET) TARGET,SUM(VALUE)/MAX(TARGET) PERCENTAGE_SCORE 
				FROM DIAL_PLAYER_POINTS_TBL DPPT 
				INNER JOIN dial_user_game_status DUGS ON DUGS.UGS_STATUS_ID = DPPT.UGS_STATUS_ID
				INNER JOIN dial_game_seg_story_map_mstr dgssmm on dgssmm.GS_MAP_ID = DUGS.GS_MAP_ID
				INNER JOIN dial_points_param_mstr dppm ON DPPT.POINTS_PARAM_CODE = dppm.POINTS_PARAM_CODE
				INNER JOIN dial_story_param_target_mstr dsptm ON dppm.POINTS_PARAM_CODE = dsptm.POINTS_PARAM_CODE
				WHERE DPPT.UGS_STATUS_ID = ? GROUP BY 1) A)';
	    $query = $this -> db -> query($sql, array($ugsStatusId,$ugsStatusId));
		return $query -> result_array();		
	}	

	function getOtherPlayerAnalyticsForCurrentStory($ugsStatusId)
	{
		$sql = 'SELECT ANALYTICS_DESC, MAX(ANALYTICS_VALUE) VALUE, COUNT(*) PLAYEDCOUNT,(SUM(ANALYTICS_VALUE) / COUNT(*)) * 100 PERCENTPLAYERS 
		FROM dial_player_analytics_tbl DPAT
		INNER JOIN dial_user_game_status DUGS ON DUGS.UGS_STATUS_ID = DPAT.UGS_STATUS_ID
		INNER JOIN dial_game_seg_story_map_mstr dgssmm on dgssmm.GS_MAP_ID = DUGS.GS_MAP_ID
		INNER JOIN dial_analytics_mstr dam on dam.ANALYTICS_ID = dpat.ANALYTICS_ID
		WHERE STORY_ID = (SELECT STORY_ID FROM dial_game_seg_story_map_mstr 
		WHERE GS_MAP_ID = (SELECT GS_MAP_ID FROM dial_user_game_status WHERE UGS_STATUS_ID = ?))
		GROUP BY 1';
	    $query = $this -> db -> query($sql, array($ugsStatusId));
		return $query -> result_array();		
	}

	function insertAnalyticsValue($ugsStatusId, $analyticId, $analyticValue) 
	{
		$sql = ('insert into dial_player_analytics_tbl(UGS_STATUS_ID,ANALYTICS_ID,ANALYTICS_VALUE) values(?,?,?)');
		$query = $this -> db -> query($sql, array($ugsStatusId, $analyticId, $analyticValue));
		//return $query -> result_array();
	}
	function insertNewUser($insertParamdata)
	{
		$this->db->insert(USER_SCHEMA.'.user_mstr', $insertParamdata);
	}
	function getExistingEmailID($emailId)
	{
		$sql = ('SELECT * FROM '.USER_SCHEMA.'.user_mstr where upper(EMAIL_ID) = upper(?)');
		$query = $this -> db -> query($sql, array($emailId));
		return $query -> result_array();
	}
	function getUgsDetails($ugsStatusId)
	{
		$sql = ('SELECT * FROM dial_user_game_status WHERE UGS_STATUS_ID = ?');
		$query = $this -> db -> query($sql, array($ugsStatusId));
		return $query -> result_array();
	}

	function insertFreeGames($params)
	{
		$this->db->insert('dial_user_game_purchase_tbl',$params);
        return $this->db->insert_id();
	}
	
	function getFeedbackMstr()
	{
		//Created by : Ashwini
		$sql = ('SELECT  FEEDBACK_ID,FEEDBACK_NAME,FEEDBACK_TYPE from user_feedback_mstr'); 			
		$query = $this -> db -> query($sql, array());
		return $query -> result();
	} 

	function insertUserFeedback($params)
	{
		//Created by : Ashwini
		return $this->db->insert('user_feedback_tbl', $params);
	}
	function getUserRatingValues()
	{
		//Created by : Ashwini
		$sql = ('SELECT  USER_RATING_ID,USER_RATING_NAME,USER_RATING_DESC,USER_RATING_POINTS from user_rating_mstr'); 			
		$query = $this -> db -> query($sql, array());
		return $query -> result();
	}
	function insertPointsForParamCode($ugsStatusId,$paramCode,$value) 
	{
			$sql = ('insert into dial_player_points_tbl(UGS_STATUS_ID,POINTS_PARAM_CODE,VALUE) values(?,?,?)');
			$query = $this -> db -> query($sql, array($ugsStatusId,$paramCode,$value));
	}

	function getPointsForUgsStatusIdandParamCode($ugsStatusId,$paramCode)
	{
		//Created by : Ashwini
		$sql = ('SELECT  PLAYER_POINTS_CODE,UGS_STATUS_ID,POINTS_PARAM_CODE,VALUE as SCORE from dial_player_points_tbl where UGS_STATUS_ID = ? and POINTS_PARAM_CODE = ? '); 			
		$query = $this -> db -> query($sql, array($ugsStatusId,$paramCode));
		return $query -> result();
	}

	function updatePointsForParamCode($ugsStatusId,$paramCode,$value) 
	{
			$sql = ('UPDATE dial_player_points_tbl SET VALUE = ? where UGS_STATUS_ID = ? and POINTS_PARAM_CODE = ?');
			$query = $this -> db -> query($sql, array($value, $ugsStatusId,$paramCode));
	}

	function getUgsDtlsForUserIdAndGsMapId($userId, $gsMapId)
	{
		//Created by : Pradeep
		$sql = ('SELECT * FROM dial_user_game_status where USER_ID = ? and GS_MAP_ID = ?'); 			
		$query = $this -> db -> query($sql, array($userId, $gsMapId));
		return $query -> result();
	}
}
?>