<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Game_model extends CI_Model
{
    
    function __construct()
    {
        parent::__construct();
        $this -> stratupdb = $this->load->database('stratup', TRUE);
    }

    /* sample code
     function get_user($email, $pwd)
     {
     $this -> stratupdb->where('EMAIL_ID', $email);
     $this -> stratupdb->where('PASSWORD', ($pwd));
     $query = $this -> stratupdb->get('user_mstr');
     return $query->result();
     }
     function insert_user($data)
     {
     return $this -> stratupdb->insert('user_mstr', $data);
     }

     function getUserDetailsByEmail($email)
     {
     $sql = ('select * from user_mstr where EMAIL_ID = ?');
     $query = $this -> stratupdb -> query($sql, array($email));
     return $query -> result();
     }
     */
    function getIndustryData()
    {
        $sql = ('select * from industry_mstr');
        $query = $this -> stratupdb -> query($sql);
        return $query -> result();
    }

    function getProductCatData($industryId)
    {
        $sql = ('select * from opr_product_category_mstr where INDUSTRY_ID = ?');
        $query = $this -> stratupdb -> query($sql, array($industryId));
        return $query -> result();
    }

    function getProductSubCatData($productCatId)
    {
        $sql = ('select * from opr_product_sub_category_mstr where PRODUCT_CATEGORY_ID = ?');
        $query = $this -> stratupdb -> query($sql, array($productCatId));
        return $query -> result();
    }

    function get_all_clients()
    {
        // List all Clients data
        $sql = ('select * from '.USER_SCHEMA.'.client_mstr');
        $query = $this -> stratupdb -> query($sql);
        return $query -> result();
    }

    function get_all_trainers()
    {
        // List all users mapped as Trainer
        $sql = ('SELECT 
                    USER_ID,
                    LOGIN_ID,
                    CONCAT(TITLE,
                            " ",
                            FIRST_NAME,
                            " ",
                            MIDDLE_NAME,
                            " ",
                            LAST_NAME) TRAINER_NAME,
                    USER_TYPE_ID,
                    EMAIL_VERIFIED
                FROM
                    '.USER_SCHEMA.'.user_mstr
                WHERE
                    EMAIL_VERIFIED = 1 AND USER_TYPE_ID = 2');
        $query = $this -> stratupdb -> query($sql);
        return $query -> result();
    }

    function get_all_gameproduct_type()
    {
        // List all game type data
        $sql = ('select * from stratup_type_mstr');
        $query = $this -> stratupdb -> query($sql);
        return $query -> result_array();
    }

    function get_all_universe_type()
    {
        // List all universe type data
        $sql = ('select * from universe_type_mstr');
        $query = $this -> stratupdb -> query($sql);
        return $query -> result();
    }

    function get_all_universe_mode()
    {
        // List all universe mode data
        $sql = ('select * from universe_mode_mstr');
        $query = $this -> stratupdb -> query($sql);
        return $query -> result();
    }

    function get_product_universe_mode_map_id($stratupTypeId, $universeTypeId, $universeModeId)
    {
        // fetch mapping id for product type / universe type / universe mode
        $sql = ('SELECT 
                    *
                FROM
                    product_universe_mode_map_mstr prod_uni_mod_map
                        INNER JOIN
                    universe_mode_mstr uni_mod ON uni_mod.UNIVERSE_MODE_ID = prod_uni_mod_map.MODE_ID
                        INNER JOIN
                    product_universe_type_mapping_mstr prod_uni_typ_map ON prod_uni_typ_map.PRODUCT_UNIVERSE_TYPE_MAP_ID = prod_uni_mod_map.PRODUCT_UNIVERSE_MAP_ID
                        INNER JOIN
                    stratup_type_mstr prod_type ON prod_type.STRATUP_TYPE_ID = prod_uni_typ_map.STRATUP_PRODUCT_TYPE_ID
                        INNER JOIN
                    universe_type_mstr uni_type ON uni_type.UNIVERSE_TYPE_ID = prod_uni_typ_map.UNIVERSE_TYPE_ID
                WHERE
                    prod_type.STRATUP_TYPE_ID = ?
                        AND uni_type.UNIVERSE_TYPE_ID = ?
                        AND uni_mod.UNIVERSE_MODE_ID = ?');
        $query = $this -> stratupdb -> query($sql, array($stratupTypeId, $universeTypeId, $universeModeId));
        return $query -> result();
    }

    function get_game_initiated_details_by_client($clientCode)
    {
        $sql = ('SELECT gbt.GAME_BATCH_ID      AS s_no,
                       cm.CLIENT_NAME         AS CLIENT_NAME,
                       gbt.COURSE_NAME,
                       CONCAT(um.TITLE,
                              " ",
                              um.FIRST_NAME,
                              " ",
                              um.MIDDLE_NAME,
                              " ",
                              um.LAST_NAME)
                          AS TRAINER_NAME,
                       gbt.START_DATE         AS START_DATE,
                       gbt.END_DATE           AS END_DATE,
                       gbt.NO_OF_YEAR_IN_GAME AS NO_OF_YEAR_IN_GAME,
                       gbt.MAX_PLAYERS        AS MAX_PLAYERS,
                       gbt.UNIVERSE_TOKEN     AS UNIVERSE_TOKEN,
                       stm.STRATUP_TYPE       AS STRATUP_TYPE,
                       utm.UNIVERSE_TYPE      AS UNIVERSE_TYPE,
                       umm.UNIVERSE_MODE      AS UNIVERSE_MODE,
                       smm.STRATUP_MODE_DESC  AS GAME_MODE,
                       gbt.CREATED_ON  AS CREATED_ON
                FROM game_batch_tbl    gbt
                     JOIN '.USER_SCHEMA.'.client_mstr cm ON cm.CLIENT_ID = gbt.CLIENT_ID
                     JOIN opr_product_sub_category_mstr psc
                        ON psc.PRODUCT_SUB_CATEGORY_ID = gbt.PRODUCT_SUB_CATEGORY_ID
                     JOIN '.USER_SCHEMA.'.user_mstr um ON um.USER_ID = gbt.TRAINIER_ID
                     JOIN product_universe_mode_map_mstr pumm
                        ON pumm.PRODUCT_UNIVERSE_MODE_MAP_ID =
                              gbt.PRODUCT_UNIVERSE_MODE_MAP_ID
                     JOIN product_universe_type_mapping_mstr putm
                        ON putm.PRODUCT_UNIVERSE_TYPE_MAP_ID = pumm.PRODUCT_UNIVERSE_MAP_ID
                     JOIN universe_mode_mstr umm ON umm.UNIVERSE_MODE_ID = pumm.MODE_ID
                     JOIN universe_type_mstr utm
                        ON utm.UNIVERSE_TYPE_ID = putm.UNIVERSE_TYPE_ID
                     JOIN stratup_type_mstr stm
                        ON stm.STRATUP_TYPE_ID = putm.STRATUP_PRODUCT_TYPE_ID
                     JOIN stratup_mode_mstr smm
                        ON smm.STRATUP_MODE_ID = gbt.STRATUP_MODE_ID
                        where gbt.client_id in ('.implode(',', $clientCode).') order by 1 desc');
        $query = $this -> stratupdb -> query($sql);
		// echo $this -> stratupdb->last_query();
        return $query -> result_array();
		
    }
	function get_game_initiated_details_by_client_for_date($clientCode,$fromdate,$todate)
    {
        $sql = ('SELECT gbt.GAME_BATCH_ID      AS s_no,
                       cm.CLIENT_NAME         AS CLIENT_NAME,
                       gbt.COURSE_NAME,
                       CONCAT(um.TITLE,
                              " ",
                              um.FIRST_NAME,
                              " ",
                              um.MIDDLE_NAME,
                              " ",
                              um.LAST_NAME)
                          AS TRAINER_NAME,
                       gbt.START_DATE         AS START_DATE,
                       gbt.END_DATE           AS END_DATE,
                       gbt.NO_OF_YEAR_IN_GAME AS NO_OF_YEAR_IN_GAME,
                       gbt.MAX_PLAYERS        AS MAX_PLAYERS,
                       gbt.UNIVERSE_TOKEN     AS UNIVERSE_TOKEN,
                       stm.STRATUP_TYPE       AS STRATUP_TYPE,
                       utm.UNIVERSE_TYPE      AS UNIVERSE_TYPE,
                       umm.UNIVERSE_MODE      AS UNIVERSE_MODE,
                       smm.STRATUP_MODE_DESC  AS GAME_MODE,
                       gbt.CREATED_ON  AS CREATED_ON
                FROM game_batch_tbl    gbt
                     JOIN '.USER_SCHEMA.'.client_mstr cm ON cm.CLIENT_ID = gbt.CLIENT_ID
                     JOIN opr_product_sub_category_mstr psc
                        ON psc.PRODUCT_SUB_CATEGORY_ID = gbt.PRODUCT_SUB_CATEGORY_ID
                     JOIN '.USER_SCHEMA.'.user_mstr um ON um.USER_ID = gbt.TRAINIER_ID
                     JOIN product_universe_mode_map_mstr pumm
                        ON pumm.PRODUCT_UNIVERSE_MODE_MAP_ID =
                              gbt.PRODUCT_UNIVERSE_MODE_MAP_ID
                     JOIN product_universe_type_mapping_mstr putm
                        ON putm.PRODUCT_UNIVERSE_TYPE_MAP_ID = pumm.PRODUCT_UNIVERSE_MAP_ID
                     JOIN universe_mode_mstr umm ON umm.UNIVERSE_MODE_ID = pumm.MODE_ID
                     JOIN universe_type_mstr utm
                        ON utm.UNIVERSE_TYPE_ID = putm.UNIVERSE_TYPE_ID
                     JOIN stratup_type_mstr stm
                        ON stm.STRATUP_TYPE_ID = putm.STRATUP_PRODUCT_TYPE_ID
                     JOIN stratup_mode_mstr smm
                        ON smm.STRATUP_MODE_ID = gbt.STRATUP_MODE_ID
                        where gbt.client_id in ('.implode(',', $clientCode).') and gbt.START_DATE BETWEEN ? 
                        AND DATE_ADD(?, INTERVAL 1 DAY) order by 1 desc');
        $query = $this -> stratupdb -> query($sql,array($fromdate,$todate));
        return $query -> result_array();
    }
    function get_game_initiated_details($params = array())
    {
        /*
         * Get all game_batch_tbl
         *
         */
        $this -> stratupdb -> order_by('s_no', 'DESC');
        if (isset($params) && !empty($params))
        {
            $this -> stratupdb -> limit($params['limit'], $params['offset']);
        }
        
        
            // $this -> stratupdb->where('GAME_BATCH_ID',$gameBatchId);
        
        return $this -> stratupdb -> get('game_init_view') -> result_array();

    }
    function get_game_initiated_details_for_date($fromdate,$todate)
    {
        $sql = ('SELECT 
                    *
                FROM
                    game_init_view 
                WHERE
                    START_DATE BETWEEN ? AND DATE_ADD(?,INTERVAL 1 DAY) order by s_no desc');
        $query = $this -> stratupdb -> query($sql, array($fromdate,$todate));
        //echo $this -> stratupdb->last_query();
        return $query -> result_array();
          
    }

    function get_game_batch_tbl($GAME_BATCH_ID)
    {
        return $this -> stratupdb -> get_where('game_batch_tbl', array('GAME_BATCH_ID' => $GAME_BATCH_ID)) -> row_array();
    }

    /*
     * Get all game_batch_tbl count
     */
    function get_all_game_batch_tbl_count()
    {
        $this -> stratupdb -> from('game_batch_tbl');
        return $this -> stratupdb -> count_all_results();
    }

    /*
     * Get all game_batch_tbl
     */
    function get_all_game_batch_tbl($params = array())
    {
        $this -> stratupdb -> order_by('GAME_BATCH_ID', 'desc');
        if (isset($params) && !empty($params))
        {
            echo $params['offset'];
            $this -> stratupdb -> limit($params['limit'], $params['offset']);
        }
        return $this -> stratupdb -> get('game_batch_tbl') -> result_array();

    }

    /*
     * function to add new game_batch_tbl
     */
    function add_game_batch_tbl($params)
    {
        $this -> stratupdb -> insert('game_batch_tbl', $params);
        return $this -> stratupdb -> insert_id();
    }

    /*
     * function to update game_batch_tbl
     */
    function update_game_batch_tbl($GAME_BATCH_ID, $params)
    {
        $this -> stratupdb -> where('GAME_BATCH_ID', $GAME_BATCH_ID);
        return $this -> stratupdb -> update('game_batch_tbl', $params);
    }

    function getTeamsForBatchId($gameBatchId)
    {
        // function to fetch team details for game_batch_id
        $sql = ('SELECT 
                    *
                FROM
                    team_tbl tt
                        INNER JOIN
                    game_tbl gt ON gt.GAME_ID = tt.GAME_ID
                WHERE
                    gt.GAME_BATCH_ID = ?');
        $query = $this -> stratupdb -> query($sql, array($gameBatchId));
        //echo $this -> stratupdb->last_query();
        return $query -> result_array();

    }

    /*
     * function to delete game_batch_tbl
     */
    function delete_game_batch_tbl($GAME_BATCH_ID)
    {
        return $this -> stratupdb -> delete('game_batch_tbl', array('GAME_BATCH_ID' => $GAME_BATCH_ID));

    }

    function getPlayerInfoForTeamId($teamId)
    {
        //function to fetch player name AND role name in a team for a given universe id
        $sql = ('SELECT 
                    TTL.TEAM_ID,
                    TTL.TEAM_MSTR_ID,
                    TTL.TEAM_NAME,
                    TTL.GAME_ID,
                    TTL.TEAM_LOGO_NAME,
                    TTL.MAX_PLAYER_IN_TEAM,
                    DGM.AVATAR_PIC_PATH,
                    DGM.DEPARTMENT_NAME,
                    PROFILE_PIC_PATH,
                    CONCAT(IFNULL(TITLE, ""),
                            " ",
                            IFNULL(FIRST_NAME, ""),
                            " ",
                            IFNULL(MIDDLE_NAME, ""),
                            " ",
                            IFNULL(LAST_NAME, "")) AS USER_NAME,
                    EMAIL_ID,TURM.USER_ID,
                    if(um.ORGANISATION_ID > 0,ORGANISATION_NAME,COMAPANY_NAME)ORGANISATION_NAME,
                    dcount.DecisionCount,
                    gbt.UNIVERSE_TOKEN
                FROM
                    TEAM_USER_ROLE_MAPPING_TBL TURM
                        INNER JOIN
                    TEAM_TBL TTL ON TTL.TEAM_ID = TURM.TEAM_ID
                        INNER JOIN
                    DEPARTMENT_GAME_MSTR DGM ON DGM.DEPARTMENT_ID = TURM.ROLE_ID
                        INNER JOIN
                    '.USER_SCHEMA.'.user_mstr UM ON UM.USER_ID = TURM.USER_ID
                        LEFT JOIN
                    '.USER_SCHEMA.'.user_organisation_mstr UO ON UO.ORGANISATION_ID = UM.ORGANISATION_ID
                        INNER JOIN
                    game_tbl gt ON gt.GAME_ID = ttl.GAME_ID
                        INNER JOIN
                    game_batch_tbl gbt ON gbt.GAME_BATCH_ID = gt.GAME_BATCH_ID
                        INNER JOIN
                    (SELECT 
                        "MKT" AS dept, COUNT(*) AS DecisionCount
                    FROM
                        mkt_main_tbl mmt
                    WHERE
                        team_id = ? and MOVE_NO>0 UNION ALL SELECT 
                        "OPS" AS dept, COUNT(*)
                    FROM
                        opr_main_tbl omt
                    WHERE
                        TEAM_ID = ? and MOVE_NO>0 UNION ALL SELECT 
                        "STG" AS dept, COUNT(*)
                    FROM
                        strgy_main_tbl
                    WHERE
                        team_id = ? and MOVE_NO>0 UNION ALL SELECT 
                        "HR" AS dept, COUNT(*)
                    FROM
                        hr_main_tbl hmt
                    WHERE
                        TEAM_ID = ? and MOVE_NO>0 and HR_ACTION_ID not in (3,7,8) UNION ALL SELECT 
                        "IT" AS dept, COUNT(*)
                    FROM
                        it_main_tbl
                    WHERE
                        TEAM_ID = ? UNION ALL SELECT "FIN", "View" FROM DUAL) dcount ON dcount.dept = DGM.DEPARTMENT_NAME
                WHERE
                    ttl.team_id = ?
                ORDER BY game_id , team_id , DEPARTMENT_NAME');
        $query = $this -> stratupdb -> query($sql, array($teamId,$teamId,$teamId,$teamId,$teamId,$teamId));
        //echo $this -> stratupdb->last_query();
        return $query -> result_array();
    }

    function sampledata()
    {
        $query = $this -> stratupdb -> get('followers');
        return $query -> result_array();
    }

    function getListofGamesPlayedByUser($userId)
    {
        //function to fetch all games played by the user
        $sql = ('SELECT
                    gbt.UNIVERSE_TOKEN, 
                    TTL.GAME_ID,
                    TTL.TEAM_ID,
                    TTL.TEAM_MSTR_ID,
                    TTL.TEAM_NAME,
                    ifnull(TTL.TEAM_LOGO_NAME,concat(ttl.team_id,"-",ttl.team_name)) as TEAM_LOGO_NAME,
                    TTL.MAX_PLAYER_IN_TEAM,
                    if(SUM(CASE
                        WHEN DGM.DEPARTMENT_NAME = "MKT" THEN 1
                        ELSE 0
                    END)>0,"Yes","No") AS MKT,
                    if(SUM(CASE
                        WHEN DGM.DEPARTMENT_NAME = "STG" THEN 1
                        ELSE 0
                    END)>0,"Yes","No") AS STG,
                    if(SUM(CASE
                        WHEN DGM.DEPARTMENT_NAME = "IT" THEN 1
                        ELSE 0
                    END)>0,"Yes","No") AS IT,
                    if(SUM(CASE
                        WHEN DGM.DEPARTMENT_NAME = "OPS" THEN 1
                        ELSE 0
                    END)>0,"Yes","No") AS OPS,
                    if(SUM(CASE
                        WHEN DGM.DEPARTMENT_NAME = "HR" THEN 1
                        ELSE 0
                    END)>0,"Yes","No") AS HR,
                    if(SUM(CASE
                        WHEN DGM.DEPARTMENT_NAME = "FIN" THEN 1
                        ELSE 0
                    END)>0,"Yes","No") AS FIN,
                    CONCAT(TITLE,
                            " ",
                            FIRST_NAME,
                            " ",
                            MIDDLE_NAME,
                            " ",
                            LAST_NAME) AS USER_NAME,
                    um.login_id,
                    um.user_id
                FROM
                    TEAM_USER_ROLE_MAPPING_TBL TURM
                        INNER JOIN
                    TEAM_TBL TTL ON TTL.TEAM_ID = TURM.TEAM_ID
                        INNER JOIN
                    DEPARTMENT_GAME_MSTR DGM ON DGM.DEPARTMENT_ID = TURM.ROLE_ID
                        INNER JOIN
                    '.USER_SCHEMA.'.user_mstr UM ON UM.USER_ID = TURM.USER_ID
                        INNER JOIN
                    game_tbl gt ON gt.GAME_ID = ttl.GAME_ID
                        INNER JOIN
                    game_batch_tbl gbt ON gbt.GAME_BATCH_ID = gt.GAME_BATCH_ID
                WHERE
                    um.user_id = ?
                GROUP BY TEAM_ID
                ORDER BY game_id , team_id , DEPARTMENT_NAME');
        $query = $this -> stratupdb -> query($sql, array($userId));

        // var_dump(isset($params));
        // var_dump(!empty($params));
        //echo $this -> stratupdb->last_query();
        //$this->output->enable_profiler(TRUE);

        return $query -> result_array();
    }

    function get_all_ListofGamesPlayedByUser_count($userId)
    {
        //function to fetch count of rows for all games played by the user
        $sql = ('select count(*) as TotalRows from (
                SELECT 
                    TTL.GAME_ID,
                    TTL.TEAM_ID,
                    TTL.TEAM_MSTR_ID,
                    TTL.TEAM_NAME,
                    ifnull(TTL.TEAM_LOGO_NAME,concat(ttl.team_id,"-",ttl.team_name)) as TEAM_LOGO_NAME,
                    TTL.MAX_PLAYER_IN_TEAM,
                    if(SUM(CASE
                        WHEN DGM.DEPARTMENT_NAME = "MKT" THEN 1
                        ELSE 0
                    END)>0,"Yes","No") AS MKT,
                    if(SUM(CASE
                        WHEN DGM.DEPARTMENT_NAME = "STG" THEN 1
                        ELSE 0
                    END)>0,"Yes","No") AS STG,
                    if(SUM(CASE
                        WHEN DGM.DEPARTMENT_NAME = "IT" THEN 1
                        ELSE 0
                    END)>0,"Yes","No") AS IT,
                    if(SUM(CASE
                        WHEN DGM.DEPARTMENT_NAME = "OPS" THEN 1
                        ELSE 0
                    END)>0,"Yes","No") AS OPS,
                    if(SUM(CASE
                        WHEN DGM.DEPARTMENT_NAME = "HR" THEN 1
                        ELSE 0
                    END)>0,"Yes","No") AS HR,
                    if(SUM(CASE
                        WHEN DGM.DEPARTMENT_NAME = "FIN" THEN 1
                        ELSE 0
                    END)>0,"Yes","No") AS FIN,
                    CONCAT(TITLE,
                            " ",
                            FIRST_NAME,
                            " ",
                            MIDDLE_NAME,
                            " ",
                            LAST_NAME) AS USER_NAME,
                    um.login_id,
                    um.user_id
                FROM
                    TEAM_USER_ROLE_MAPPING_TBL TURM
                        INNER JOIN
                    TEAM_TBL TTL ON TTL.TEAM_ID = TURM.TEAM_ID
                        INNER JOIN
                    DEPARTMENT_GAME_MSTR DGM ON DGM.DEPARTMENT_ID = TURM.ROLE_ID
                        INNER JOIN
                    '.USER_SCHEMA.'.user_mstr UM ON UM.USER_ID = TURM.USER_ID
                        INNER JOIN
                    game_tbl gt ON gt.GAME_ID = ttl.GAME_ID
                        INNER JOIN
                    game_batch_tbl gbt ON gbt.GAME_BATCH_ID = gt.GAME_BATCH_ID
                WHERE
                    um.user_id = ?
                GROUP BY TEAM_ID
                ORDER BY game_id , team_id , DEPARTMENT_NAME) as cnt');
        $query = $this -> stratupdb -> query($sql, array($userId));
        // echo $this -> stratupdb->last_query();
        return $query -> result_array();
    }
    function get_AllUniverseTokenByUser($userId)
    {
        //function to fetch list of universe played by user
        $sql = ('SELECT 
                        gbt.UNIVERSE_TOKEN
                    FROM
                        TEAM_USER_ROLE_MAPPING_TBL TURM
                            INNER JOIN
                        TEAM_TBL TTL ON TTL.TEAM_ID = TURM.TEAM_ID
                            INNER JOIN
                        game_tbl gt ON gt.GAME_ID = ttl.GAME_ID
                            INNER JOIN
                        game_batch_tbl gbt ON gbt.GAME_BATCH_ID = gt.GAME_BATCH_ID
                    WHERE
                        user_id = ?
                    GROUP BY 1');
        $query = $this -> stratupdb -> query($sql, array($userId));
        // echo $this -> stratupdb->last_query();
        return $query -> result_array();
    }
    function getQtrStatus($gameId)
    {
        // function to return Year & Qtr and Qtr completed status if Qtr status is zero then Qtr completed else inprogress
        $sql = ('SELECT
                    TEAM_ID, 
                    concat("Y",GETYEAR(MAX(MOVE_NO)),"-Q",GETQTR(MAX(move_no), GETYEAR(MAX(MOVE_NO)))) as GameYear,
                    CASE
                        WHEN MOD(MAX(MOVE_NO), 18) = 0 THEN "Completed"
                        ELSE "In-Progress"
                    END as Qstatus
                FROM
                    game_play_movement_tbl
                WHERE
                    game_id = ?');
        $query = $this -> stratupdb -> query($sql, array($gameId));
        // echo $this -> stratupdb->last_query();
        return $query -> result_array();
    }
    function get_all_stratup_mode_mstr()
    {
        $sql = ('SELECT 
                    STRATUP_MODE_ID, STRATUP_MODE, STRATUP_MODE_DESC
                FROM
                    stratup_mode_mstr');
        $query = $this -> stratupdb -> query($sql);
        return $query -> result_array();
        
    }
    function get_user_type($userTypeId)
    {
        $sql = ('SELECT 
                    USER_TYPE_ID, USER_TYPE_NAME
                FROM
                    user_type_mstr
                WHERE
                    USER_TYPE_ID = ?');
         $query = $this -> stratupdb->query($sql,array($userTypeId));
         return $query -> result_array();
    }
    function get_user_clients($userId)
    {
        $sql = ('SELECT 
                    cm.CLIENT_ID, cm.CLIENT_NAME, cm.CLIENT_CODE, cm.STATUS_ID
                FROM
                    '.USER_SCHEMA.'.client_mstr cm
                        INNER JOIN
                    '.USER_SCHEMA.'.user_client_mapping_mstr ucm ON ucm.CLIENT_ID = cm.CLIENT_ID
                WHERE
                    ucm.USER_ID = ?');
         $query = $this -> stratupdb->query($sql,array($userId));
         return $query -> result_array();
    }
    function get_game_duration($gameBatchId)
    {
        $sql = ('SELECT concat("Q", QUARTER) AS GameYear,
                   CONCAT(
                      FLOOR(HOUR(TIMEDIFF(QARTER_END_DATE, QUARTER_START_DATE)) / 24),
                      " days ",
                      MOD(HOUR(TIMEDIFF(QARTER_END_DATE, QUARTER_START_DATE)), 24),
                      " hours ",
                      MINUTE(TIMEDIFF(QARTER_END_DATE, QUARTER_START_DATE)),
                      " minutes")
                      AS Duration
            FROM game_play_quarter_config_tbl
            WHERE GAME_BATCH_ID = ?
            GROUP BY 1, 2;');
         $query = $this -> stratupdb->query($sql,array($gameBatchId));
         return $query -> result_array();
    }
    function getEnaData($deptName,$teamIdOrUnivsereToken,$profileType)
    {
        $sql = ('SELECT 
                     diagnosisTbl.YEAR,
                    sum(case when paramMstr.ENA_PARAMETER_ID= 1 then diagnosisTbl.VALUE end) as FI,
                    sum(case when paramMstr.ENA_PARAMETER_ID= 2 then diagnosisTbl.VALUE end) as P,
                    sum(case when paramMstr.ENA_PARAMETER_ID= 3 then diagnosisTbl.VALUE end) as DM,
                    sum(case when paramMstr.ENA_PARAMETER_ID= 4 then diagnosisTbl.VALUE end) as PB,
                    sum(case when paramMstr.ENA_PARAMETER_ID= 5 then diagnosisTbl.VALUE end) as PS,
                    -- sum(case when paramMstr.ENA_PARAMETER_ID= 6 then diagnosisTbl.VALUE end) as SI,
                    -- sum(case when paramMstr.ENA_PARAMETER_ID= 7 then diagnosisTbl.VALUE end) as CT,
                    sum(case when paramMstr.ENA_PARAMETER_ID= 8 then diagnosisTbl.VALUE end) as GO,
                    -- sum(diagnosisTbl.VALUE) as Total
                    sum(case when paramMstr.ENA_PARAMETER_ID= 1 then diagnosisTbl.VALUE end) +
                    sum(case when paramMstr.ENA_PARAMETER_ID= 2 then diagnosisTbl.VALUE end) +
                    sum(case when paramMstr.ENA_PARAMETER_ID= 3 then diagnosisTbl.VALUE end) +
                    sum(case when paramMstr.ENA_PARAMETER_ID= 4 then diagnosisTbl.VALUE end) +
                    sum(case when paramMstr.ENA_PARAMETER_ID= 5 then diagnosisTbl.VALUE end) +
                    -- sum(case when paramMstr.ENA_PARAMETER_ID= 6 then diagnosisTbl.VALUE end) ,
                    -- sum(case when paramMstr.ENA_PARAMETER_ID= 7 then diagnosisTbl.VALUE end) ,
                    sum(case when paramMstr.ENA_PARAMETER_ID= 8 then diagnosisTbl.VALUE end) as Total
                FROM
                    ena_use_case_mstr useCaseMstr
                        INNER JOIN
                    ena_param_use_case_mapping_mstr mapMstr ON mapMstr.ENA_USE_CASE_ID = useCaseMstr.ENA_USE_CASE_ID
                        INNER JOIN
                    ena_parameter_mstr paramMstr ON paramMstr.ENA_PARAMETER_ID = mapMstr.ENA_PARAMETER_ID
                        INNER JOIN
                    epistemic_diagnosis_tbl diagnosisTbl ON diagnosisTbl.PARAM_USE_CASE_MAP_ID = mapMstr.PARAM_USE_CASE_MAP_ID
                        INNER JOIN
                    department_mstr deptMstr ON deptMstr.DEPARTMENT_ID = useCaseMstr.DEPARTMENT_ID
                        inner join
                    team_tbl tt on tt.TEAM_ID=diagnosisTbl.TEAM_ID
                        inner join
                    game_tbl gt on gt.GAME_ID = tt.GAME_ID
                        inner join 
                    game_batch_tbl gbt ON gbt.GAME_BATCH_ID = gt.GAME_BATCH_ID
                WHERE
                        deptMstr.DEPARTMENT_NAME = ? ');
        if($profileType=='INDV')
        {
            $sql = $sql . (' AND diagnosisTbl.TEAM_ID = ?');
        }else if($profileType=='MYLEAGUE')
        {
            $sql = $sql . (' AND  gbt.UNIVERSE_TOKEN = ?');
        }else if($profileType=='GLOBAL')
        {
            $sql = $sql .(' AND COURSE_NAME = "PROD-LIVE"');
        }
        $sql = $sql . (' group by 1');
        
        if($profileType=='INDV' || $profileType=='MYLEAGUE')
        {
            $query = $this -> stratupdb->query($sql,array($deptName,$teamIdOrUnivsereToken));   
        }
        else 
        {
        	$query = $this -> stratupdb->query($sql,array($deptName));
        } 
         // echo $this -> stratupdb->last_query();
         return $query -> result_array();
    }
    function getMaxGameYear($universeToken,$profileType)
    {
        $sql = ('SELECT 
                    MAX(NO_OF_YEAR_IN_GAME) as GAME_YEAR
                FROM
                    game_batch_tbl');
        if($profileType='GLOBAL')
        {
            $sql = $sql .(' WHERE COURSE_NAME = "PROD-LIVE"' ); 
            
        }else 
        {
            $sql = $sql .(' WHERE UNIVERSE_TOKEN = ? AND COURSE_NAME = "PROD-LIVE"' ); 
        }
        
        $query = $this -> stratupdb->query($sql,array($universeToken));
        // echo $this -> stratupdb->last_query(); 
         return $query -> result_array();
    }
    function getTeamCount($universeToken,$profileType)
    {
        $sql = ('SELECT 
                    COUNT(tt.team_id) as ROLE_COUNT
                FROM
                    game_batch_tbl gbt
                        INNER JOIN
                    game_tbl gt ON gt.GAME_BATCH_ID = gbt.GAME_BATCH_ID
                        INNER JOIN
                    team_tbl tt ON tt.GAME_ID = gt.GAME_ID');
                

        if($profileType=='MYLEAGUE')
        {
            $sql = $sql . (' WHERE gbt.UNIVERSE_TOKEN = ?');
        }else if ($profileType=='GLOBAL')
        {
            $sql = $sql . (' WHERE COURSE_NAME = "PROD-LIVE"' );
        }
        

        $query = $this -> stratupdb->query($sql,array($universeToken));
        // echo $this -> stratupdb->last_query(); 
         return $query -> result_array();
    }
    function getAllRoleEnaData($teamIdOrUniverseToken,$profileType)
    {
        $sql = ('SELECT 
                     diagnosisTbl.YEAR,
                    sum(case when paramMstr.ENA_PARAMETER_ID= 1 then diagnosisTbl.VALUE end) as FI,
                    sum(case when paramMstr.ENA_PARAMETER_ID= 2 then diagnosisTbl.VALUE end) as P,
                    sum(case when paramMstr.ENA_PARAMETER_ID= 3 then diagnosisTbl.VALUE end) as DM,
                    sum(case when paramMstr.ENA_PARAMETER_ID= 4 then diagnosisTbl.VALUE end) as PB,
                    sum(case when paramMstr.ENA_PARAMETER_ID= 5 then diagnosisTbl.VALUE end) as PS,
                    -- sum(case when paramMstr.ENA_PARAMETER_ID= 6 then diagnosisTbl.VALUE end) as SI,
                    -- sum(case when paramMstr.ENA_PARAMETER_ID= 7 then diagnosisTbl.VALUE end) as CT,
                    sum(case when paramMstr.ENA_PARAMETER_ID= 8 then diagnosisTbl.VALUE end) as GO,
                    -- sum(diagnosisTbl.VALUE) as Total
                    sum(case when paramMstr.ENA_PARAMETER_ID= 1 then diagnosisTbl.VALUE end) +
                    sum(case when paramMstr.ENA_PARAMETER_ID= 2 then diagnosisTbl.VALUE end) +
                    sum(case when paramMstr.ENA_PARAMETER_ID= 3 then diagnosisTbl.VALUE end) +
                    sum(case when paramMstr.ENA_PARAMETER_ID= 4 then diagnosisTbl.VALUE end) +
                    sum(case when paramMstr.ENA_PARAMETER_ID= 5 then diagnosisTbl.VALUE end) +
                    -- sum(case when paramMstr.ENA_PARAMETER_ID= 6 then diagnosisTbl.VALUE end) ,
                    -- sum(case when paramMstr.ENA_PARAMETER_ID= 7 then diagnosisTbl.VALUE end) ,
                    sum(case when paramMstr.ENA_PARAMETER_ID= 8 then diagnosisTbl.VALUE end)  as Total
                FROM
                    ena_use_case_mstr useCaseMstr
                        INNER JOIN
                    ena_param_use_case_mapping_mstr mapMstr ON mapMstr.ENA_USE_CASE_ID = useCaseMstr.ENA_USE_CASE_ID
                        INNER JOIN
                    ena_parameter_mstr paramMstr ON paramMstr.ENA_PARAMETER_ID = mapMstr.ENA_PARAMETER_ID
                        INNER JOIN
                    epistemic_diagnosis_tbl diagnosisTbl ON diagnosisTbl.PARAM_USE_CASE_MAP_ID = mapMstr.PARAM_USE_CASE_MAP_ID
                        INNER JOIN
                    department_mstr deptMstr ON deptMstr.DEPARTMENT_ID = useCaseMstr.DEPARTMENT_ID
                        inner join
                    team_tbl tt on tt.TEAM_ID=diagnosisTbl.TEAM_ID
                        inner join
                    game_tbl gt on gt.GAME_ID = tt.GAME_ID
                        inner join 
                    game_batch_tbl gbt ON gbt.GAME_BATCH_ID = gt.GAME_BATCH_ID ');
               
        if($profileType=='TEAM')
        {
            $sql = $sql . (' where diagnosisTbl.TEAM_ID = ?');
        }else if($profileType=='MYLEAGUE')
        {
            $sql = $sql . (' where  gbt.UNIVERSE_TOKEN = ?');
        }else if($profileType=='GLOBAL')
        {
            $sql = $sql .(' where COURSE_NAME = "PROD-LIVE"');
        }
        $sql = $sql . (' group by 1');
        
        if($profileType=='TEAM' || $profileType=='MYLEAGUE')
        {
            $query = $this -> stratupdb->query($sql,array($teamIdOrUniverseToken));   
        }
        else 
        {
            $query = $this -> stratupdb->query($sql);
        } 
        // echo $this -> stratupdb->last_query();
         return $query -> result_array();
    }
    function gameInfoByUniverseToken($universeToken)
    {
        $sql = ('SELECT stm.STRATUP_TYPE
                    FROM game_batch_tbl    gbt
                         INNER JOIN stratup_type_mstr stm
                            ON stm.STRATUP_TYPE_ID = gbt.STRATUP_MODE_ID
                    WHERE UNIVERSE_TOKEN = ?');
                    
        $query = $this -> stratupdb->query($sql,array($universeToken));
        // echo $this -> stratupdb->last_query(); 
         return $query -> result_array();
                    
    }
    function teamuserRoleMapping($teamId)
    {//to get role mapped to user for a particular team
         $sql = ('select TEAM_USER_ROLE_MAPPING_ID AS ID,
                         TURMT.TEAM_ID,
                         TURMT.USER_ID,
                         ROLE_ID,
                         DEPARTMENT_NAME,
                         EMAIL_ID 
                    from TEAM_USER_ROLE_MAPPING_TBL turmt
                INNER JOIN team_tbl tbl on tbl.team_id=turmt.team_id
                INNER JOIN DEPARTMENT_GAME_MSTR DGM ON DGM.DEPARTMENT_ID = turmt.ROLE_ID
                INNER JOIN '.USER_SCHEMA.'.user_mstr UM ON UM.USER_ID = turmt.USER_ID
                   where turmt.team_id= ?');
                    
        $query = $this -> stratupdb->query($sql,array($teamId));
        // echo $this -> stratupdb->last_query(); 
         return $query -> result_array();
    }
    function checkusersroleinuniverse($batchId,$teamId,$emailId)
    {//to check wheather particular user is there in other team of same universe
         $sql = ('select turmt.* from team_user_role_mapping_tbl turmt
                    inner join team_tbl tt on tt.team_id=turmt.team_id
                    inner join game_tbl gt on gt.game_id=tt.game_id
                    inner join game_batch_tbl gbt on gbt.game_batch_id=gt.game_batch_id
                    inner join '.USER_SCHEMA.'.user_mstr um on um.USER_ID=turmt.USER_ID
                    where gbt.universe_token=? and turmt.team_id!=? and um.email_id=?');
                    
        $query = $this -> stratupdb->query($sql,array($batchId,$teamId,$emailId));
         return $query -> result_array();
    }
    function getusersrole($teammapId,$emailId)
    {//to get role mapped to user with mapid
         $sql = ('select turmt.* from team_user_role_mapping_tbl turmt
                    inner join '.USER_SCHEMA.'.user_mstr um on um.USER_ID=turmt.USER_ID
                    where turmt.TEAM_USER_ROLE_MAPPING_ID=? and um.email_id=?');
                    
        $query = $this -> stratupdb->query($sql,array($teammapId,$emailId));
         return $query -> result_array();
    }
    function updateuserrole($teammapId,$userId)
    {
        $sql = ('UPDATE team_user_role_mapping_tbl SET USER_ID=? WHERE TEAM_USER_ROLE_MAPPING_ID=?;');
        return $query =$this ->  stratupdb-> query($sql, array($userId,$teammapId));
    }
    function getTeamsForTeamName($teamName)
    {
        // function to fetch team details for game_batch_id
        $sql = ('SELECT 
                    *
                FROM
                    team_tbl tt
                        INNER JOIN
                    game_tbl gt ON gt.GAME_ID = tt.GAME_ID
                WHERE
                    tt.TEAM_LOGO_NAME = ?');
        $query = $this -> stratupdb -> query($sql, array($teamName));
        //echo $this -> stratupdb->last_query();
        return $query -> result_array();

    }
    function getQtrStatusforTeam($teamId)
    {
        // function to return Year & Qtr and Qtr completed status if Qtr status is zero then Qtr completed else inprogress
        $sql = ('SELECT
                    TEAM_ID, 
                    concat("Y",GETYEAR(MAX(MOVE_NO)),"-Q",GETQTR(MAX(move_no), GETYEAR(MAX(MOVE_NO)))) as GameYear,
                    CASE
                        WHEN MOD(MAX(MOVE_NO), 18) = 0 THEN "Completed"
                        ELSE "In-Progress"
                    END as Qstatus
                FROM
                    game_play_movement_tbl
                WHERE
                    team_id = ?');
        $query = $this -> stratupdb -> query($sql, array($teamId));
        // echo $this -> stratupdb->last_query();
        return $query -> result_array();
    }
    function getTrainerList($client_id)
    {
        $sql = ('SELECT um.USER_ID,concat(FIRST_NAME,\' \',LAST_NAME) AS FULL_NAME FROM '.USER_SCHEMA.'.user_mstr um inner join '.USER_SCHEMA.'.user_type_mstr utm on utm.USER_TYPE_ID=um.USER_TYPE_ID 
          inner join '.USER_SCHEMA.'.user_client_mapping_mstr ucmm on ucmm.USER_ID=um.USER_ID where utm.USER_TYPE_NAME=\'Trainer\'and ucmm.CLIENT_ID= ?');
         $query = $this -> stratupdb->query($sql,array($client_id));
         return $query -> result_array();
    }
    function getQtrStatusforAllTeamInUniverse($universeToken, $year, $quarter)
    {
        // function to return Year & Qtr and Qtr completed status if Qtr status is zero then Qtr completed else inprogress
        $sql = ('SELECT
                    tt.TEAM_ID, TEAM_LOGO_NAME,
                    concat("Y",GETYEAR(MAX(MOVE_NO)),"-Q",GETQTR(MAX(move_no), GETYEAR(MAX(MOVE_NO)))) as GameYear,
                    CASE
                    WHEN MOD(MAX(MOVE_NO), 18) = 0 THEN "Completed"
                        ELSE (CASE WHEN MOD(MAX(MOVE_NO)+1, 18) = 0 THEN "Completed" 
                        ELSE (CASE WHEN gbt.END_DATE <= current_timestamp() THEN "Completed" ELSE "In-Progress" END) END)
                    END as Qstatus
                FROM
                    game_play_movement_tbl
                    gpmt
                    INNER JOIN team_tbl tt ON tt.TEAM_ID = gpmt.TEAM_ID
                                    INNER JOIN game_tbl gt ON gt.GAME_ID = tt.GAME_ID
                                    INNER JOIN game_batch_tbl gbt ON gbt.GAME_BATCH_ID = gt.GAME_BATCH_ID
                                    WHERE gbt.UNIVERSE_TOKEN = ? AND getyear(move_no) = ? AND GETQTR(MOVE_NO, GETYEAR(MOVE_NO)) = ?
                                    group by gt.GAME_ID');
        $query = $this -> stratupdb -> query($sql, array($universeToken, $year, $quarter));
        // echo $this -> stratupdb->last_query();
        return $query -> result_array();
    }

    function getuserfeedbackforuniverse($universeToken)
    {//to get userfeedback for universe 
        $sql = ('SELECT GAME_FEEDBACK_ID,
                        ft.GAME_ID,
                        ft.USER_ID,
                        um.FIRST_NAME,
                        um.EMAIL_ID,
                        uom.ORGANISATION_NAME,
                        turm.TEAM_LOGO_NAME,
                        GAME_RATING,
                        LEARNING_RATING,
                        FEEDBACK_COMMENTS
                    FROM
                        game_feedback_tbl ft
                    INNER JOIN
                    (SELECT 
                        TEAM_USER_ROLE_MAPPING_ID,
                        tt.TEAM_ID,
                        USER_ID,
                        ROLE_ID,
                        tt.GAME_ID,
                        TEAM_LOGO_NAME
                    FROM
                        team_user_role_mapping_tbl turm
                    INNER JOIN team_tbl tt ON tt.TEAM_ID = turm.TEAM_ID) turm ON turm.USER_ID = ft.USER_ID
                        AND turm.game_id = ft.GAME_ID
                    inner join '.USER_SCHEMA.'.user_mstr um on  um.USER_ID = ft.USER_ID
                    inner join '.USER_SCHEMA.'.user_organisation_mstr uom on uom.ORGANISATION_ID=um.ORGANISATION_ID
                    WHERE
                        ft.GAME_ID IN (SELECT 
                            game_id
                        FROM
                            game_tbl
                        WHERE
                            game_batch_id IN (SELECT 
                                GAME_BATCH_ID
                            FROM
                         game_batch_tbl
                     WHERE
                         UNIVERSE_TOKEN = ?)) group by GAME_FEEDBACK_ID');                    
        $query = $this -> stratupdb->query($sql,array($universeToken));
         return $query -> result_array();
    }

    function getusertutorialStatusforuniverse($universeToken)
    {//to get usertutorial status for universe 
        $sql = ('select distinct c.USER_ID,LOGIN_ID, FIRST_NAME, EMAIL_ID,group_concat(DEPARTMENT_NAME)  AS DEPARTMENT_NAME,
         c.TEAM_ID,stm.STRATUP_TYPE as UNIVERSE_STRATUP_TYPE ,g.STRATUP_TYPE,TRAINING_STATUS,a.CREATED_ON as START_DATE
        from team_user_role_mapping_tbl c
        left join user_training_status a on a.USER_ID = c.USER_ID
        inner join '.USER_SCHEMA.'.user_mstr b on c.USER_ID = b.USER_ID
        inner join department_game_mstr dgm on dgm.DEPARTMENT_ID = c.ROLE_ID
        inner join team_tbl d on c.TEAM_ID = d.TEAM_ID
        inner join game_tbl e on e.GAME_ID = d.GAME_ID
        inner join game_batch_tbl f on e.GAME_BATCH_ID = f.GAME_BATCH_ID
        inner join product_universe_mode_map_mstr pummm on pummm.PRODUCT_UNIVERSE_MODE_MAP_ID=f.PRODUCT_UNIVERSE_MODE_MAP_ID
        inner join product_universe_type_mapping_mstr putmm on putmm.PRODUCT_UNIVERSE_TYPE_MAP_ID = pummm.PRODUCT_UNIVERSE_MAP_ID
        inner join stratup_type_mstr stm on stm.STRATUP_TYPE_ID = putmm.STRATUP_PRODUCT_TYPE_ID
        left join stratup_type_mstr g on g.STRATUP_TYPE_ID = a.STRATUP_TYPE_ID    
        where UNIVERSE_TOKEN = ? and b.USER_ID != 461 group by b.USER_ID,STRATUP_TYPE order by STRATUP_TYPE, TRAINING_STATUS');                    
        $query = $this -> stratupdb->query($sql,array($universeToken));
         return $query -> result_array();
    }
}
?>