<?php
class Gamemasters_model extends CI_Model {
	function __construct() {
		parent::__construct();
	}

	function getGameList() 
	{
		$sql = ('SELECT dgm.*,dgcm.GAME_CAT_ID,dgcm.GAME_CAT_DESC,dgcm.SEQ_NO,a.GAME_DETAIL_CODE,a.GAME_DETAIL_TITLE,a.GAME_DETAIL_DESC,
        ROUND(ifnull(sum(RATING)/count(*),0),1) AS rating,if(sum(RATING)>0,count(*) ,0) Total FROM dial_game_mstr dgm
        INNER JOIN dial_game_category_mstr dgcm on dgm.GAME_CAT_ID = dgcm.GAME_CAT_ID 
        left join(select * from dial_game_details_mstr where GAME_DETAIL_CODE=\'RIBBON\')A on A.GAME_ID = dgm.GAME_ID
         left JOIN (Select GAME_RATING AS RATING,GAME_FEEDBACK_ID AS ID,USER_ID,game as GAME_ID from '.STRATUP_SCHEMA.'.game_feedback_tbl gft
          left join (Select GAME_ID,stm.STRATUP_TYPE,if(stm.STRATUP_TYPE="SILVER",if(gbt.IS_CAMPAIGN=1,15,11),if(gbt.IS_CAMPAIGN=1,2,10)) AS GAME from '.STRATUP_SCHEMA.'.Game_batch_tbl gbt
        inner Join '.STRATUP_SCHEMA.'.Game_tbl gt on gt.Game_batch_id=gbt.game_batch_id
        inner join '.STRATUP_SCHEMA.'.product_universe_mode_map_mstr pummm on pummm.PRODUCT_UNIVERSE_MODE_MAP_ID=gbt.PRODUCT_UNIVERSE_MODE_MAP_ID
        inner join '.STRATUP_SCHEMA.'.product_universe_type_mapping_mstr putmm on putmm.PRODUCT_UNIVERSE_TYPE_MAP_ID = pummm.PRODUCT_UNIVERSE_MAP_ID
        inner join '.STRATUP_SCHEMA.'.stratup_type_mstr stm on stm.STRATUP_TYPE_ID = putmm.STRATUP_PRODUCT_TYPE_ID)A on A.GAME_ID=gft.GAME_ID
        Union
        select FEEDBACK_VALUE as RATING,FEEDBACK_ID AS ID,USER_ID,GAME_ID from dial_user_feedback_tbl )B ON dgm.game_id = B.game_id
        where dgm.status in  (\'A\',\'U\') AND dgcm.status = \'A\' group by dgm.game_id ORDER BY DGM.SEQ_NO'); 
		$query = $this -> db -> query($sql);
		return $query -> result();
	}	
	
	function getGameDescriptionForGameId($gameId) 
	{
		$sql = ('SELECT * FROM dial_game_mstr WHERE GAME_ID = ?'); 
		$query = $this -> db -> query($sql,array($gameId));
		return $query -> result();
	}	
	
	function getGameIdForGameTag($gameTag) 
	{
		$sql = ('SELECT GAME_ID FROM dial_game_mstr WHERE GAME_TAG = ?'); 
		$query = $this -> db -> query($sql,array($gameTag));
		return $query -> result();
	}	
	
	function getGameDetailsForGameId($gameId) 
	{
		$sql = ('SELECT * FROM dial_game_details_mstr WHERE GAME_ID = ? and STATUS="A"'); 
		$query = $this -> db -> query($sql,array($gameId));
		return $query -> result();
	}	
	
	function getGameDetailsForGameIdDetailsCode($gameId,$gameDetailCode) 
	{
		$sql = ('SELECT * FROM dial_game_details_mstr WHERE GAME_ID = ? AND STATUS = \'A\' AND GAME_DETAIL_CODE = ?'); 
		$query = $this -> db -> query($sql,array($gameId,$gameDetailCode));
		return $query -> result();
	}	
	
	function getTitleForGameIdDetailsCode($gameId,$gameDetailCode) 
	{
		$sql = ('SELECT DISTINCT GAME_DETAIL_CODE,GAME_DETAIL_TITLE FROM dial_game_details_mstr WHERE GAME_ID = ? AND GAME_DETAIL_CODE = ? AND STATUS = \'A\''); 
		$query = $this -> db -> query($sql,array($gameId,$gameDetailCode));
		return $query -> result();
	}	
	
	function getGameCategoryList() 
	{
		$sql = ('SELECT * FROM dial_game_category_mstr dgm WHERE STATUS = \'A\'  order by DGM.SEQ_NO'); 
		$query = $this -> db -> query($sql);
		return $query -> result();
	}	
	
	function getGameListForCategory($gameCategoryId) 
	{
		$sql = ('select  dgm.*,a.GAME_DETAIL_CODE,a.GAME_DETAIL_TITLE,a.GAME_DETAIL_DESC,round(sum(ifnull(duft.feedback_value,0))/count(*),1) rating,if(sum(duft.FEEDBACK_VALUE)>0,count(*) ,0) Total from dial_game_mstr dgm 
left JOIN (select feedback_value,game_id from dial_user_feedback_tbl) duft ON dgm.game_id = duft.game_id
left join (select * from dial_game_details_mstr where GAME_DETAIL_CODE=\'RIBBON\') A on A.GAME_ID = dgm.GAME_ID
where dgm.GAME_CAT_ID = ? and dgm.status= \'A\' group by dgm.game_id ORDER BY DGM.SEQ_NO;'); 
		$query = $this -> db -> query($sql, array($gameCategoryId));
		return $query -> result();
	}
	
	function getLastTenRatingForGame($gameId) 
	{
		$sql = ('select SUBSTR( FIRST_NAME, 1 , 2 )as FIrstTwoLetters, FIRST_NAME,FEEDBACK_VALUE,COMMENT,PROFILE_PIC_PATH from dial_user_feedback_tbl duft
left join '.USER_SCHEMA.'.user_mstr um on duft.user_id = um.user_id where game_id = ? order by feedback_id desc limit 10');
		$query = $this -> db -> query($sql, array($gameId));
		return $query -> result();
	}
    
    function getCountofAllRatingForGame($gameId) 
    {
        $sql = ('select count(*) Count from dial_user_feedback_tbl duft
left join '.USER_SCHEMA.'.user_mstr um on duft.user_id = um.user_id where game_id = ? ');
        $query = $this -> db -> query($sql, array($gameId));
        return $query -> result();
    }

    function getAllRatingForGame($params=array(),$gameId) 
    {
        $sql = ('select SUBSTR( FIRST_NAME, 1 , 2 )as FIrstTwoLetters, FIRST_NAME,FEEDBACK_VALUE,COMMENT,PROFILE_PIC_PATH,LENGTH(COMMENT) COMMENT_LEN
         from dial_user_feedback_tbl duft
left join '.USER_SCHEMA.'.user_mstr um on duft.user_id = um.user_id where game_id = ? order by COMMENT_LEN desc ');
          if (isset($params) && !empty($params))
        {
            //$this -> db -> limit($params['limit'], $params['offset']);
                $sql=$sql.' LIMIT '.$params['offset'].','.$params['limit'];
        }
        $query = $this -> db -> query($sql, array($gameId));
        return $query -> result();
    }	

	function getFeauredRatingForGame($gameId) 
	{
		$sql = ('select SUBSTR( FIRST_NAME, 1 , 2 )as FIrstTwoLetters,FIRST_NAME,FEEDBACK_VALUE,COMMENT,PROFILE_PIC_PATH from dial_user_feedback_tbl duft
left join '.USER_SCHEMA.'.user_mstr um on duft.user_id = um.user_id where game_id = ? and FEATURED_FLAG = \'Y\' order by feedback_id desc limit 10');
		$query = $this -> db -> query($sql, array($gameId));
		return $query -> result();
	}	
	
	function getStarwiseRatingForGame($gameId) 
	{
		$sql = ('select feedback_value RATING,count(*) CNT,round(count(*)/(select count(*) from dial_user_feedback_tbl where game_id = ?)*100,2) PERCENT from dial_user_feedback_tbl where game_id = ? group by 1 order by RATING DESC');
		$query = $this -> db -> query($sql, array($gameId,$gameId));
		return $query -> result();
	}
	
	function getClientList() 
	{
		$sql = ('SELECT * FROM client_mstr order by SEQ_NO');
		$query = $this -> db -> query($sql);
		return $query -> result();
	}	

	function getTesimonialsList() 
	{
		$sql = ('SELECT 
                        tm.*, gm.GAME_TITLE
                    FROM
                        testimonial_mstr tm
                            INNER JOIN
                        dial_game_mstr gm ON gm.game_id = tm.game_id
                    WHERE
                        tm.STATUS = "A"
                    LIMIT 10');
		$query = $this -> db -> query($sql);
		return $query -> result();
	}	

	function gameTopFourList() 
	{
		$sql = ('SELECT * FROM dial_game_mstr order by rand() limit 4');
		$query = $this -> db -> query($sql);
		return $query -> result();
	}
    function gameOtherCatGameList() 
    {
        $sql = ('SELECT dgm.*,A.GAME_DETAIL_CODE,A.GAME_DETAIL_TITLE,A.GAME_DETAIL_DESC,
ROUND(ifnull(sum(duft.FEEDBACK_VALUE)/count(*),0),1) rating ,if(sum(duft.FEEDBACK_VALUE)>0,count(*) ,0) Total  FROM dial_game_mstr dgm 
        left Join (select * from dial_game_details_mstr 
        where GAME_DETAIL_CODE=\'RIBBON\')A on dgm.GAME_ID=A.GAME_ID 
         left JOIN dial_user_feedback_tbl duft ON dgm.game_id = duft.game_id
          where GAME_TAG="OTHERS"  group by dgm.game_id ORDER BY dgm.GAME_ID');
        $query = $this -> db -> query($sql);
        return $query -> result();
    }
    function stratupuser()
    {
        // $stratupdb = $this->load->database('stratup', TRUE);
        $sql = ('select * from '.USER_SCHEMA.'.user_mstr');
        $query = $stratupdb->query($sql);
        return $query -> result_array();
    }
    /* stratup user details */
    function getUserDetailsForEmailId($emailId)
    {
        $stratupdb = $this->load->database('stratup', TRUE);
        $sql = ('SELECT * FROM '.USER_SCHEMA.'.user_mstr where EMAIL_ID=?');
        $query = $stratupdb -> query($sql, array($emailId));
        return $query -> result_array();
    }
    /* stratup department ID */
    function getDepartmentIdForTeamIdDeptName($teamId, $deptName)
    {
        $stratupdb = $this->load->database('stratup', TRUE);
        $sql = ('SELECT DEPARTMENT_ID FROM DEPARTMENT_GAME_MSTR WHERE TEAM_ID= ? and DEPARTMENT_NAME=?');
        $query = $stratupdb-> query($sql, array($teamId, $deptName));
        return $query -> result_array();
    }
    /* stratup Team ID */
    function getTeamDtlsForGameId($gameId)
    {
        $stratupdb = $this->load->database('stratup', TRUE);
        $sql = ('SELECT * FROM TEAM_TBL WHERE GAME_ID=?');
        $query = $stratupdb-> query($sql, array($gameId));
        //echo $stratupdb->last_query();
        return $query -> result_array();
    }
    function getTeamDtlsForTeamId($teamId)
    {
        $stratupdb = $this->load->database('stratup', TRUE);
        $sql = ('SELECT * FROM TEAM_TBL WHERE TEAM_ID=?');
        $query = $stratupdb-> query($sql, array($teamId));
        //echo $stratupdb->last_query();
        return $query -> result_array();
    }
    function updateTeamNameForTeamId($teamId,$teamName)
    {//to update teamname
        $stratupdb = $this->load->database('stratup', TRUE);
        $sql = ('UPDATE team_tbl SET TEAM_LOGO_NAME=? WHERE TEAM_ID=?;');
        $query = $stratupdb-> query($sql, array($teamName,$teamId));
        //echo $stratupdb->last_query();
       // return $query -> result_array();
    }
    function updateTeamLogoPathForTeamId($teamId,$teamlogopath)
    {//to update teamname
        $stratupdb = $this->load->database('stratup', TRUE);
        $sql = ('UPDATE team_tbl SET TEAM_LOGO_PATH=? WHERE TEAM_ID=?;');
        $query = $stratupdb-> query($sql, array($teamlogopath,$teamId));
        //echo $stratupdb->last_query();
       // return $query -> result_array();
    }
    function getTeamsForTeamName($teamName)
    {
        $stratupdb = $this->load->database('stratup', TRUE);
        $sql = ('select * from team_tbl WHERE TEAM_LOGO_NAME=?;');
        $query = $stratupdb-> query($sql, array($teamName));
        //echo $stratupdb->last_query();
        return $query -> result_array();
    }
    /* stratup insert team user role*/
    function insertTeamUserRoleMaptbl($teamId, $userId, $roleId)
    {
        $stratupdb = $this->load->database('stratup', TRUE);
        $sql = ('INSERT INTO TEAM_USER_ROLE_MAPPING_TBL
                        (
                            TEAM_ID,
                            USER_ID,
                            ROLE_ID
                        )
                        VALUES
                        (?,?,?)');
        $query = $stratupdb -> query($sql, array($teamId, $userId, $roleId));
    }
    function deleteUserFromTemUserRoleTbl($teamId, $userId)
    {
        $stratupdb = $this->load->database('stratup', TRUE);
        $sql = 'DELETE FROM team_user_role_mapping_tbl WHERE TEAM_ID = ? and USER_ID = ?';
        $query = $stratupdb -> query($sql, array($teamId, $userId));
    }
    function add_user_game_status($params)
    {
        $this->db->insert('dial_user_game_status',$params);
    }
    function listPlayedGamesByUserCount($emailId)
    {
        $sql = ('SELECT 
                   count(*) as Count
                FROM
                    dial_user_game_status ugs
                        INNER JOIN
                    '.USER_SCHEMA.'.user_mstr um ON um.user_id = ugs.user_id
                                  WHERE
                    um.email_Id = ?');
        $query = $this -> db -> query($sql,array($emailId));
        
        return $query -> result_array();
    }
    function listPlayedGamesByUser($emailId)
    {
        //this is fetching only stratup game need to modify this after coimbatore event
        // $sql = 'SELECT gm.*,ugs.game_token,UGS_STATUS_ID,A.game_id AS Stratup_game_id
        //         FROM dial_user_game_status ugs 
        //         INNER JOIN 
        //             '.USER_SCHEMA.'.user_mstr um ON um.user_id = ugs.user_id
        //         INNER JOIN
        //             dial_game_seg_story_map_mstr gssm ON gssm.GS_MAP_ID = ugs.GS_MAP_ID
        //         INNER JOIN
        //             dial_game_mstr gm ON gm.game_id = gssm.game_id
        //         INNER JOIN
        //             (SELECT gbt.GAME_BATCH_ID,gbt.UNIVERSE_TOKEN,
        //                     gt.GAME_ID,tt.TEAM_ID,tt.TEAM_LOGO_NAME,
        //                     turmt.ROLE_ID,um.USER_ID,um.LOGIN_ID
        //              FROM '.STRATUP_SCHEMA.'.game_batch_tbl gbt
        //              INNER JOIN 
        //                 '.STRATUP_SCHEMA.'.game_tbl gt ON gt.game_batch_id = gbt.game_batch_id
        //              INNER JOIN 
        //                 '.STRATUP_SCHEMA.'.team_tbl tt ON tt.game_id = gt.game_id
        //              INNER JOIN 
        //                 '.STRATUP_SCHEMA.'.team_user_role_mapping_tbl turmt ON turmt.team_id = tt.team_id
        //              INNER JOIN 
        //                 '.USER_SCHEMA.'.user_mstr um ON um.user_id = turmt.user_id
        //              WHERE um.email_id = ? GROUP BY gt.game_id) a 
        //         ON a.UNIVERSE_TOKEN = game_token
        //         WHERE um.email_Id = ? group by Stratup_game_id';
        //this is to fetch all the games played by user
        $sql='SELECT  UGS_STATUS_ID,gm.*, ugs.game_token FROM dial_user_game_status ugs
INNER JOIN '.USER_SCHEMA.'.user_mstr um ON um.user_id = ugs.user_id
INNER JOIN dial_game_seg_story_map_mstr gssm ON gssm.GS_MAP_ID = ugs.GS_MAP_ID
INNER JOIN dial_game_mstr gm ON gm.game_id = gssm.game_id
WHERE um.email_Id = ?';
        $query = $this -> db -> query($sql,array($emailId));
        // echo $this -> db->last_query();
        return $query -> result_array();
    }
    function listRolesTakenForStratupGame($gameToken,$gameId,$teamMstrName)
    {
        $sql = 'SELECT tt.team_id,
                       gt.game_id,
                       tt.TEAM_NAME,
                       tt.TEAM_LOGO_NAME,
                       um.EMAIL_ID,
                       dgm.DEPARTMENT_NAME,
                       UNIVERSE_TOKEN
                FROM '.STRATUP_SCHEMA.'.team_user_role_mapping_tbl    turm
                     INNER JOIN '.USER_SCHEMA.'.user_mstr um ON turm.USER_ID = um.USER_ID
                     INNER JOIN '.STRATUP_SCHEMA.'.team_tbl tt ON tt.TEAM_ID = turm.TEAM_ID
                     INNER JOIN '.STRATUP_SCHEMA.'.game_tbl gt ON gt.GAME_ID = tt.GAME_ID
                     INNER JOIN '.STRATUP_SCHEMA.'.game_batch_tbl gbt
                        ON gbt.GAME_BATCH_ID = gt.GAME_BATCH_ID
                     INNER JOIN '.STRATUP_SCHEMA.'.department_game_mstr dgm
                        ON dgm.DEPARTMENT_ID = turm.ROLE_ID
                WHERE UNIVERSE_TOKEN = ? and gt.game_id= ? AND tt.team_name = ?';
        $query = $this -> db -> query($sql,array($gameToken,$gameId,$teamMstrName));
        return $query -> result_array();
    }
    function getTeamUserRoleMapTbl_by_userTeam($teamId,$userId)
    {
        $stratupdb = $this->load->database('stratup', TRUE);
        $stratupdb->where('TEAM_ID', $teamId); 
        $stratupdb->where('USER_ID', $userId);
        $query=$stratupdb->get('TEAM_USER_ROLE_MAPPING_TBL');
        return $query -> result_array();
        
    }
    function getGameStartInfo($gameToken)
    {
        $sql ='SELECT gbt.START_DATE, gbt.END_DATE, gbt.NO_OF_YEAR_IN_GAME,UNIVERSE_TOKEN,cm.CLIENT_NAME
                    FROM '.STRATUP_SCHEMA.'.game_batch_tbl gbt
                    INNER JOIN '.USER_SCHEMA.'.client_mstr cm ON cm.CLIENT_ID = gbt.CLIENT_ID
                    WHERE UNIVERSE_TOKEN = ?';
        $query = $this -> db -> query($sql,array($gameToken));
        return $query -> result_array();
        
    }
	
    function getProperty($propertykey)
    {
        $sql ='SELECT PROPERTY_VALUE FROM dial_property_mstr WHERE PROPERTY_KEY = ?';
        $query = $this -> db -> query($sql,array($propertykey));
        return $query -> result_array();
    }
    function getGameCatForCatId($gameCategoryId)
    {
        $this->db->where('GAME_CAT_ID', $gameCategoryId); 
        $query = $this->db->get('dial_game_category_mstr');
        return $query -> result_array();
    }
    function getGameIdForEmailId($universeToken,$emaiId)
    {
        $stratupdb = $this->load->database('stratup', TRUE);
        $sql = (' SELECT 
                    gt.game_id
                FROM
                    '.USER_SCHEMA.'.user_mstr um
                        INNER JOIN
                    team_user_role_mapping_tbl turm ON turm.USER_ID = um.USER_ID
                        INNER JOIN
                    team_tbl tt ON tt.TEAM_ID = turm.TEAM_ID
                        INNER JOIN
                    game_tbl gt ON gt.GAME_ID = tt.GAME_ID
                        INNER JOIN
                    game_batch_tbl gbt ON gbt.GAME_BATCH_ID = gt.GAME_BATCH_ID
                WHERE
                    gbt.UNIVERSE_TOKEN = ?
                        AND um.EMAIL_ID = ?');
        $query = $stratupdb-> query($sql,array($universeToken,$emaiId));
        return $query -> result_array();
    }
    function getOverAllRatingForGame($gameId) 
    {
        $sql = ('SELECT ROUND(ifnull(sum(FEEDBACK_VALUE)/count(*),0),1) AS TOTAL_FEEDBACK_VALUE, count(*) AS TOTAL_COUNT
        FROM dial_user_feedback_tbl where GAME_ID=?');
        $query = $this -> db -> query($sql, array($gameId));
        return $query -> result();
    }
    function getUserInfoforDeptandTeam($teamId,$deptName) 
    {
         $stratupdb = $this->load->database('stratup', TRUE);
        $sql = ('SELECT um.* from '.USER_SCHEMA.'.user_mstr um 
                    inner join team_user_role_mapping_tbl turmt on um.USER_ID=turmt.USER_ID
                    inner join department_game_mstr dgm on dgm.DEPARTMENT_ID=turmt.ROLE_ID 
                    and dgm.team_id=turmt.team_id
                    where turmt.team_id=? and dgm.DEPARTMENT_NAME=?');
        $query = $stratupdb-> query($sql, array($teamId,$deptName));
        return $query -> result();
    }
    function getbanner()
    {
        $sql = ('SELECT * FROM banner_tbl where STATUS=\'A\' order by SEQ_NO ');
        $query = $this -> db -> query($sql, array());
        return $query -> result();
    }
    function getAllGameList()
    {
        $sql = ('SELECT dgm.*,dgcm.GAME_CAT_DESC from dial_game_mstr dgm left join 
                 dial_game_category_mstr dgcm on dgcm.GAME_CAT_ID = dgm.GAME_CAT_ID');
        $query = $this -> db -> query($sql, array());
        return $query -> result();
    }
    function getGameListForGameTitl($gameTitle) 
    {
        $sql = ('SELECT * FROM dial_game_mstr WHERE GAME_TITLE = ?'); 
        $query = $this -> db -> query($sql,array($gameTitle));
        return $query -> result();
    }
    function add_game_mstr($params)
    {
        $this->db->insert('dial_game_mstr',$params);
    }
    function update_game_mstr($gameId,$params)
    {
        $this->db->where('GAME_ID',$gameId);
        return $this->db->update('dial_game_mstr',$params);
    }
    function getGameListexceptgame($gameId,$gameTitle) 
    {
        $sql = ('SELECT * FROM dial_game_mstr where GAME_ID!=? and GAME_TITLE=?'); 
        $query = $this -> db -> query($sql,array($gameId,$gameTitle));
        return $query -> result();
    }
    function listSimilarPlayedGamesByUser($gameId,$emailId,$ugsStatusId)
    {
        $sql = 'SELECT 
                    gm.*, ugs.game_token,UGS_STATUS_ID
                FROM
                    dial_user_game_status ugs
                        INNER JOIN
                    '.USER_SCHEMA.'.user_mstr um ON um.user_id = ugs.user_id
                        INNER JOIN
                    dial_game_seg_story_map_mstr gssm ON gssm.GS_MAP_ID = ugs.GS_MAP_ID
                        INNER JOIN
                    dial_game_mstr gm ON gm.game_id = gssm.game_id
                WHERE
                    um.email_Id = ? and gm.game_id=? and UGS_STATUS_ID!=?';
        $query = $this -> db -> query($sql,array($emailId,$gameId,$ugsStatusId));
        // echo $this -> db->last_query();
        return $query -> result_array();
    }
    function getOccupationMstr()
    {
        $sql ='SELECT * FROM '.STRATUP_SCHEMA.'.occupation_mstr order by OCCUATION_DESC';
        $query = $this -> db -> query($sql,array());
        return $query -> result_array();
    }
    function getUserOrganisationMstr()
    {
        $sql ='SELECT * FROM '.USER_SCHEMA.'.user_organisation_mstr order by ORGANISATION_DESC';
        $query = $this -> db -> query($sql,array());
        return $query -> result_array();
    }
    function getUserLocationMstr()
    {
        $sql ='SELECT * FROM '.USER_SCHEMA.'.user_location_mstr order by LOCATION_DESC';
        $query = $this -> db -> query($sql,array());
        return $query -> result_array();
    }
    function getCampaignListFrBatchIdNull()
    {
        $sql ='select * from dial_game_mstr dgm 
            inner join dial_game_details_mstr dgdm on dgm.game_id=dgdm.game_id
            where dgm.GAME_CAT_ID=10 and dgm.status=\'A\' and dgdm.GAME_DETAIL_CODE=\'BATCHID\' 
            AND (dgdm.GAME_DETAIL_DESC IS NULL or dgdm.GAME_DETAIL_DESC ="")';
        $query = $this -> db -> query($sql,array());
        return $query -> result_array();
    }
    function getCampaignBatchId($gameId)
    {// to get batchId for a game
        $sql ='select * from dial_game_details_mstr 
            where GAME_DETAIL_CODE=\'BATCHID\' 
            and GAME_ID=?';
        $query = $this -> db -> query($sql,array($gameId));
        return $query -> result_array();
    }
    function updateCampaignBatchId($gameBatchId,$gameDetailId)
    {//to insert gameBacthId for Campaign
        $sql = ('UPDATE dial_game_details_mstr SET GAME_DETAIL_DESC=? WHERE GAME_DETAIL_ID=?;');
         $this ->  db-> query($sql, array($gameBatchId,$gameDetailId));
        //echo $stratupdb->last_query();
       // return $query -> result_array();
    }
    function getRatingFormGameForUniverse($gamebatchId) 
    {//feed back only for that campaign or Universe
        $sql = ('select SUBSTR( FIRST_NAME, 1 , 2 )as FIrstTwoLetters, FIRST_NAME,GAME_RATING,LEARNING_RATING,FEEDBACK_COMMENTS,PROFILE_PIC_PATH from '.STRATUP_SCHEMA.'.game_feedback_tbl gft
            left join '.USER_SCHEMA.'.user_mstr um on gft.user_id = um.user_id 
            inner join '.STRATUP_SCHEMA.'.game_tbl gt on gt.game_id=gft.game_id
            inner join '.STRATUP_SCHEMA.'.game_batch_tbl gbt on gbt.game_batch_id=gt.game_batch_id
            where gbt.game_batch_id=?
            order by GAME_FEEDBACK_ID desc limit 10');
        $query = $this -> db -> query($sql, array($gamebatchId));
        return $query -> result();
    }
    function getCountofAllRatingwithGameRating($gameId)
    {//To get feedback total count from both dialogue schema and stratup game
        $sql = ('select count(*) AS Count from
            (SELECT SUBSTR( FIRST_NAME, 1 , 2 )as FIrstTwoLetters, FIRST_NAME,GAME_RATING,FEEDBACK_COMMENTS,PROFILE_PIC_PATH ,Length(FEEDBACK_COMMENTs) COMMENT_LEN, Game as Game_id
            FROM '.STRATUP_SCHEMA.'.game_feedback_tbl gft
            left join (Select GAME_ID,stm.STRATUP_TYPE,if(stm.STRATUP_TYPE="SILVER",if(gbt.IS_CAMPAIGN=1,15,11),if(gbt.IS_CAMPAIGN=1,2,10)) AS GAME from '.STRATUP_SCHEMA.'.Game_batch_tbl gbt
            inner Join '.STRATUP_SCHEMA.'.Game_tbl gt on gt.Game_batch_id=gbt.game_batch_id
            inner join '.STRATUP_SCHEMA.'.product_universe_mode_map_mstr pummm on pummm.PRODUCT_UNIVERSE_MODE_MAP_ID=gbt.PRODUCT_UNIVERSE_MODE_MAP_ID
            inner join '.STRATUP_SCHEMA.'.product_universe_type_mapping_mstr putmm on putmm.PRODUCT_UNIVERSE_TYPE_MAP_ID = pummm.PRODUCT_UNIVERSE_MAP_ID
            inner join '.STRATUP_SCHEMA.'.stratup_type_mstr stm on stm.STRATUP_TYPE_ID = putmm.STRATUP_PRODUCT_TYPE_ID)A on A.GAME_ID=gft.GAME_ID
            left join '.USER_SCHEMA.'.user_mstr um on gft.user_id = um.user_id  where game = ?
            union
            select SUBSTR( FIRST_NAME, 1 , 2 )as FIrstTwoLetters, FIRST_NAME,FEEDBACK_VALUE,COMMENT,PROFILE_PIC_PATH,LENGTH(COMMENT) COMMENT_LEN,GAME_ID
                     from dial_user_feedback_tbl duft
            left join '.USER_SCHEMA.'.user_mstr um on duft.user_id = um.user_id where game_id = ? )C order by COMMENT_LEN desc');
        $query = $this -> db -> query($sql, array($gameId,$gameId));
        return $query -> result();    
    }
    function getAllRatingwithGameRating($params=array(),$gameId)
    {//To get feedback from both dialogue schema and stratup game
        $sql = ('select * from
            (SELECT SUBSTR( FIRST_NAME, 1 , 2 )as FIrstTwoLetters, FIRST_NAME,GAME_RATING as FEEDBACK_VALUE,FEEDBACK_COMMENTS as COMMENT,PROFILE_PIC_PATH ,Length(FEEDBACK_COMMENTs) COMMENT_LEN, Game as GAME_ID
            FROM '.STRATUP_SCHEMA.'.game_feedback_tbl gft
            left join (Select GAME_ID,stm.STRATUP_TYPE,if(stm.STRATUP_TYPE="SILVER",if(gbt.IS_CAMPAIGN=1,15,11),if(gbt.IS_CAMPAIGN=1,2,10)) AS GAME from '.STRATUP_SCHEMA.'.Game_batch_tbl gbt
            inner Join '.STRATUP_SCHEMA.'.Game_tbl gt on gt.Game_batch_id=gbt.game_batch_id
            inner join '.STRATUP_SCHEMA.'.product_universe_mode_map_mstr pummm on pummm.PRODUCT_UNIVERSE_MODE_MAP_ID=gbt.PRODUCT_UNIVERSE_MODE_MAP_ID
            inner join '.STRATUP_SCHEMA.'.product_universe_type_mapping_mstr putmm on putmm.PRODUCT_UNIVERSE_TYPE_MAP_ID = pummm.PRODUCT_UNIVERSE_MAP_ID
            inner join '.STRATUP_SCHEMA.'.stratup_type_mstr stm on stm.STRATUP_TYPE_ID = putmm.STRATUP_PRODUCT_TYPE_ID)A on A.GAME_ID=gft.GAME_ID
            left join '.USER_SCHEMA.'.user_mstr um on gft.user_id = um.user_id  where game = ?
            union
            select SUBSTR( FIRST_NAME, 1 , 2 )as FIrstTwoLetters, FIRST_NAME,FEEDBACK_VALUE,COMMENT,PROFILE_PIC_PATH,LENGTH(COMMENT) COMMENT_LEN,GAME_ID
                     from dial_user_feedback_tbl duft
            left join '.USER_SCHEMA.'.user_mstr um on duft.user_id = um.user_id where game_id = ? )A order by COMMENT_LEN desc');
        if (isset($params) && !empty($params))
        {
            //$this -> db -> limit($params['limit'], $params['offset']);
                $sql=$sql.' LIMIT '.$params['offset'].','.$params['limit'];
        }
        $query = $this -> db -> query($sql, array($gameId,$gameId));
        return $query -> result();  
    }
    function getStarwiseRatingwithGameRating($gameId) 
    {//To get starwise rating from both dialogue schema and stratup game
        $sql = ('select  RATING,count(*) CNT,round(count(*)/(select count(*) from 
            (Select GAME_RATING AS RATING,GAME_FEEDBACK_ID AS ID,USER_ID from '.STRATUP_SCHEMA.'.game_feedback_tbl gft 
            left join (Select GAME_ID,stm.STRATUP_TYPE,if(stm.STRATUP_TYPE="SILVER",if(gbt.IS_CAMPAIGN=1,15,11),if(gbt.IS_CAMPAIGN=1,2,10)) AS GAME from '.STRATUP_SCHEMA.'.Game_batch_tbl gbt
            inner Join '.STRATUP_SCHEMA.'.Game_tbl gt on gt.Game_batch_id=gbt.game_batch_id
            inner join '.STRATUP_SCHEMA.'.product_universe_mode_map_mstr pummm on pummm.PRODUCT_UNIVERSE_MODE_MAP_ID=gbt.PRODUCT_UNIVERSE_MODE_MAP_ID
            inner join '.STRATUP_SCHEMA.'.product_universe_type_mapping_mstr putmm on putmm.PRODUCT_UNIVERSE_TYPE_MAP_ID = pummm.PRODUCT_UNIVERSE_MAP_ID
            inner join '.STRATUP_SCHEMA.'.stratup_type_mstr stm on stm.STRATUP_TYPE_ID = putmm.STRATUP_PRODUCT_TYPE_ID)A on A.GAME_ID=gft.GAME_ID
            where game = ? and GAME_RATING > 0
            Union
            select FEEDBACK_VALUE as RATING,FEEDBACK_ID AS ID,USER_ID from dial_user_feedback_tbl where game_id=?)A 
            )*100,2) PERCENT from
            (Select GAME_RATING AS RATING,GAME_FEEDBACK_ID AS ID,USER_ID from '.STRATUP_SCHEMA.'.game_feedback_tbl gft 
            left join (Select GAME_ID,stm.STRATUP_TYPE,if(stm.STRATUP_TYPE="SILVER",if(gbt.IS_CAMPAIGN=1,15,11),if(gbt.IS_CAMPAIGN=1,2,10)) AS GAME from '.STRATUP_SCHEMA.'.Game_batch_tbl gbt
            inner Join '.STRATUP_SCHEMA.'.Game_tbl gt on gt.Game_batch_id=gbt.game_batch_id
            inner join '.STRATUP_SCHEMA.'.product_universe_mode_map_mstr pummm on pummm.PRODUCT_UNIVERSE_MODE_MAP_ID=gbt.PRODUCT_UNIVERSE_MODE_MAP_ID
            inner join '.STRATUP_SCHEMA.'.product_universe_type_mapping_mstr putmm on putmm.PRODUCT_UNIVERSE_TYPE_MAP_ID = pummm.PRODUCT_UNIVERSE_MAP_ID
            inner join '.STRATUP_SCHEMA.'.stratup_type_mstr stm on stm.STRATUP_TYPE_ID = putmm.STRATUP_PRODUCT_TYPE_ID)A on A.GAME_ID=gft.GAME_ID
            where game = ? and GAME_RATING > 0
            Union
            select FEEDBACK_VALUE as RATING,FEEDBACK_ID AS ID,USER_ID from dial_user_feedback_tbl where game_id=?)A group by 1 order by RATING desc');
        $query = $this -> db -> query($sql, array($gameId,$gameId,$gameId,$gameId));
        return $query -> result();
    }
    function getOverAllRatingwithGameRating($gameId) 
    {//To get overall rating from both dialogue schema and stratup game
        $sql = ('select ROUND(ifnull(sum(RATING)/count(*),0),1) AS TOTAL_FEEDBACK_VALUE, count(*) AS TOTAL_COUNT  from 
            (Select GAME_RATING AS RATING,GAME_FEEDBACK_ID AS ID,USER_ID from '.STRATUP_SCHEMA.'.game_feedback_tbl gft 
            left join (Select GAME_ID,stm.STRATUP_TYPE,if(stm.STRATUP_TYPE="SILVER",if(gbt.IS_CAMPAIGN=1,15,11),if(gbt.IS_CAMPAIGN=1,2,10)) AS GAME from '.STRATUP_SCHEMA.'.Game_batch_tbl gbt
            inner Join '.STRATUP_SCHEMA.'.Game_tbl gt on gt.Game_batch_id=gbt.game_batch_id
            inner join '.STRATUP_SCHEMA.'.product_universe_mode_map_mstr pummm on pummm.PRODUCT_UNIVERSE_MODE_MAP_ID=gbt.PRODUCT_UNIVERSE_MODE_MAP_ID
            inner join '.STRATUP_SCHEMA.'.product_universe_type_mapping_mstr putmm on putmm.PRODUCT_UNIVERSE_TYPE_MAP_ID = pummm.PRODUCT_UNIVERSE_MAP_ID
            inner join '.STRATUP_SCHEMA.'.stratup_type_mstr stm on stm.STRATUP_TYPE_ID = putmm.STRATUP_PRODUCT_TYPE_ID)A on A.GAME_ID=gft.GAME_ID
            where game = ? 
            Union
            select FEEDBACK_VALUE as RATING,FEEDBACK_ID AS ID,USER_ID from dial_user_feedback_tbl where game_id=?)A');
        $query = $this -> db -> query($sql, array($gameId,$gameId));
        return $query -> result();
    }
    function getAllBlogs()
    {// to get blogs list
        $sql = ('select bm.*,IFNULL(comment_cnt,0) AS COMMENT_COUNT  from blog_mstr bm left join 
(select ifnull(COMMENT_COUNT,0)+ifnull(RES_COMMENT_COUNT,0) as COMMENT_cnt,BLOG_ID from
(select count(*) as COMMENT_COUNT,bct.BLOG_COMMENT_ID,BLOG_ID,B.RES_COMMENT_COUNT from blog_comment_tbl bct 
        left join (select count(*) as RES_COMMENT_COUNT,BLOG_COMMENT_ID from blog_comment_response_tbl bcrt group by BLOG_COMMENT_ID
         )B on bct.BLOG_COMMENT_ID=B.BLOG_COMMENT_ID group by Blog_id)c)d on d.BLOG_ID=bm.BLOG_ID
         where bm.status=\'A\' order by BLog_id DESC');
        $query = $this -> db -> query($sql,array());
        return $query -> result();
    }
    function getBlogDetails($blog_Id)
    {//to get details of each blog by its id
        $sql = ('SELECT * FROM blog_details_mstr where BLOG_ID=? AND STATUS=\'A\' ORDER BY SEQ_NO ASC');
        $query = $this -> db -> query($sql,array($blog_Id));
        return $query -> result();
    }
    function getBlogComments($blog_Id,$params)
    {
        //to get details of each blog by its id
        $sql = ('SELECT * FROM blog_comment_tbl where BLOG_ID=? ORDER BY 1 DESC');
        if(isset($params)) 
        {
            $sql = $sql . ' limit '.$params['limit'].' offset '.$params['offset'];
        }
        $query = $this -> db -> query($sql,array($blog_Id));
        return $query -> result();
    }
    function getBlogCommentbyID($blog_Id)
    {// to get blog
        $sql = ('select bm.*,IFNULL(comment_cnt,0) AS COMMENT_COUNT  from blog_mstr bm left join 
(select ifnull(COMMENT_COUNT,0)+ifnull(RES_COMMENT_COUNT,0) as COMMENT_cnt,BLOG_ID from
(select count(*) as COMMENT_COUNT,bct.BLOG_COMMENT_ID,BLOG_ID,B.RES_COMMENT_COUNT from blog_comment_tbl bct 
        left join (select count(*) as RES_COMMENT_COUNT,BLOG_COMMENT_ID from blog_comment_response_tbl bcrt group by BLOG_COMMENT_ID
         )B on bct.BLOG_COMMENT_ID=B.BLOG_COMMENT_ID group by Blog_id)c)d on d.BLOG_ID=bm.BLOG_ID
         where bm.blog_ID=?');
        $query = $this -> db -> query($sql,array($blog_Id));
        return $query -> result();
    }
    function getBlogResCommentbyId($commentId)
    {
        $sql = ('SELECT * FROM blog_comment_response_tbl where BLOG_COMMENT_ID=? ');
         $query = $this -> db -> query($sql,array($commentId));
        return $query -> result();
    }
    function addBlogComment($params)
    {// to insert blog comment
         $this->db->insert('blog_comment_tbl',$params);
        return $this->db->insert_id();
    }
    function replytoBlogComment($params)
    {//to insert response to blog comment
         $this->db->insert('blog_comment_response_tbl',$params);
        return $this->db->insert_id();
    }
    function getBlogbyId($blogId)
    {
        $sql = ('SELECT * FROM blog_mstr where BLOG_ID=? ');
         $query = $this -> db -> query($sql,array($blogId));
        return $query -> result();
    }
    function getCampaignList()
    {
        $sql = ('SELECT * FROM dial_game_mstr where GAME_TAG= \'CAMP\' and status = \'A\' ORDER BY SEQ_NO DESC ');
         $query = $this -> db -> query($sql,array());
        return $query -> result();
    }
    function getCampaignLeagueDtls($gameId)
    {
        $sql = ('SELECT * FROM dial_game_details_mstr where GAME_DETAIL_CODE= \'LEAGUE\' and status = \'A\' and GAME_ID=? ');
         $query = $this -> db -> query($sql,array($gameId));
        return $query -> result();
    }
    function getRevenuePatforZeroYear()
    {
        $stratupdb = $this->load->database('stratup', TRUE);
        $sql = ('select TRANSACTION_FOR,AMOUNT from department_income_expend_transaction_tbl_mstr 
        where TRANSACTION_FOR in (\'SALES REVENUE - COST\',\'RETAINED EARNING\')');
        $query = $stratupdb-> query($sql, array());
        //echo $stratupdb->last_query();
        return $query -> result_array();
    }
    function checkUserinUniverse($batchId,$userId)
    {
        $stratupdb = $this->load->database('stratup', TRUE);
        $sql = ('select * from team_user_role_mapping_tbl turmt
                inner join team_tbl tt on tt.team_id=turmt.team_id inner join game_tbl gt on tt.game_id=gt.game_id
                inner join game_batch_tbl gbt on gbt.game_batch_id =gt.game_batch_id where gbt.game_batch_id=? and turmt.user_id=?');
                $query = $stratupdb-> query($sql, array($batchId,$userId));
        return $query -> result_array();
    }
    
    function getRoleDetailsGameMstrForID($roleId,$teamId)
    {
        //created by : Ashwini
        //function to get department Dtls from gamemstr for roleId
        $stratupdb = $this->load->database('stratup', TRUE);
        $sql = ('select DEPARTMENT_ID,DEPARTMENT_NAME,DEPARTMENT_DESC from department_game_mstr where DEPARTMENT_ID=? and Team_id=?');
        $query = $stratupdb -> query($sql,array($roleId,$teamId));
        return $query -> result();
    }
    function getRoleDetailsGameMstrForRole($roleName,$teamId)
    {
        //created by : Ashwini
        //function to get department Dtls from gamemstr for roleName
        $stratupdb = $this->load->database('stratup', TRUE);
        $sql = ('select DEPARTMENT_ID,DEPARTMENT_NAME,DEPARTMENT_DESC from department_game_mstr where DEPARTMENT_NAME=? and TEAM_ID=?');
        $query = $stratupdb -> query($sql,array($roleName,$teamId));
        return $query -> result();
    }
    function getTeamsForTeamNameandID($teamName, $teamId)
    {
        $stratupdb = $this->load->database('stratup', TRUE);
        $sql = ('select * from team_tbl WHERE TEAM_ID!=? and TEAM_LOGO_NAME=?;');
        $query = $stratupdb-> query($sql, array($teamId,$teamName));
        //echo $stratupdb->last_query();
        return $query -> result_array();
    }
     function getRoleIdFromTeamMap($teammapId)
    {
        $stratupdb = $this->load->database('stratup', TRUE);
        $sql = ('select * from TEAM_USER_ROLE_MAPPING_TBL WHERE TEAM_USER_ROLE_MAPPING_ID=? ;');
        $query = $stratupdb-> query($sql, array($teammapId));
        //echo $stratupdb->last_query();
        return $query -> result_array();
    }
    function getTeammapIdforRoleId($roleId)
    {
        $stratupdb = $this->load->database('stratup', TRUE);
        $sql = ('select * from TEAM_USER_ROLE_MAPPING_TBL where ROLE_ID=?;');
         $query = $stratupdb-> query($sql, array($roleId));
        //echo $stratupdb->last_query();
        return $query -> result_array();
    }
    function getAllRatingFormGame() 
    {// to get all feedback
        $sql = ('select SUBSTR( FIRST_NAME, 1 , 2 )as FIrstTwoLetters, FIRST_NAME,GAME_RATING,LEARNING_RATING,FEEDBACK_COMMENTS,PROFILE_PIC_PATH from '.STRATUP_SCHEMA.'.game_feedback_tbl gft
            left join '.USER_SCHEMA.'.user_mstr um on gft.user_id = um.user_id 
            inner join '.STRATUP_SCHEMA.'.game_tbl gt on gt.game_id=gft.game_id
            inner join '.STRATUP_SCHEMA.'.game_batch_tbl gbt on gbt.game_batch_id=gt.game_batch_id
            order by GAME_FEEDBACK_ID desc ');
        $query = $this -> db -> query($sql, array());
        return $query -> result();
    }
    function getTopTenFeedback()
    {//gameId is hardcoded 
         $sql = ('select SUBSTR( FIRST_NAME, 1 , 2 )as FIrstTwoLetters, FIRST_NAME,FEEDBACK_VALUE,COMMENT,PROFILE_PIC_PATH,LENGTH(COMMENT) COMMENT_LEN,GAME_ID
                     from dial_user_feedback_tbl duft
            left join y_uatstratup.user_mstr um on duft.user_id = um.user_id where game_id = 11 and LENGTH(COMMENT)<=500 order by COMMENT_LEN desc limit 10');
             $query = $this -> db -> query($sql, array());
        return $query -> result();
    }
    function getDownloadlink($gameId,$os) 
    {
        $sql = ('SELECT * FROM dial_game_details_mstr WHERE GAME_ID = ? and STATUS="A" and GAME_DETAIL_TITLE=?'); 
        $query = $this -> db -> query($sql,array($gameId,$os));
        return $query -> result();
    }
    function getCurrentParticipants($universeToken)
    {
        $stratupdb = $this->load->database('stratup', TRUE);
        $sql = ('select
                    count(distinct turm.USER_ID)+50 AS current_participants
                    from team_user_role_mapping_tbl turm
                     INNER JOIN '.USER_SCHEMA.'.user_mstr um ON um.user_id = turm.user_id
                     inner join team_tbl tt on tt.TEAM_ID=turm.TEAM_ID
                     inner join game_tbl gt on gt.GAME_ID=tt.GAME_ID
                     inner join game_batch_tbl gbt on gbt.GAME_BATCH_ID=gt.GAME_BATCH_ID
                     where gbt.UNIVERSE_TOKEN=? and turm.USER_ID<>461');
         $query = $stratupdb-> query($sql, array($universeToken));
        //echo $stratupdb->last_query();
        return $query -> result_array();
    }
    function getCampaignCateDtlsList()
    {
        $sql = ('SELECT if(dgm.status=\'A\',\'Ongoing Events\',if(dgm.status=\'U\',\'Upcoming Events\',\'Past Events\')) as Events,dgm.*,dgdm.* FROM dial_game_mstr dgm 
                inner join dial_game_details_mstr dgdm on dgm.game_id=dgdm.game_id
                where GAME_TAG= \'CAMP\' and dgm.Status!=\'I\' and dgdm.status=\'A\' and dgdm.GAME_DETAIL_CODE=\'LEAGUE\' ORDER BY dgm.Seq_no');
         $query = $this -> db -> query($sql,array());
        return $query -> result();
    }
    function getCampaignCategory()
    {//to get categories of campaign with group by category
        $sql = ('SELECT if(dgm.status=\'A\',\'Ongoing Events\',if(dgm.status=\'U\',\'Upcoming Events\',\'Past Events\')) as Events,dgm.* FROM dial_game_mstr dgm 
                where GAME_TAG= \'CAMP\' group by Events  ORDER BY dgm.status');
        $query = $this -> db -> query($sql,array());
        return $query -> result();
    }
    function getCampaignDtlsList()
    {
        $sql = ('SELECT * FROM dial_game_mstr dgm 
            inner join dial_game_details_mstr dgdm on dgm.game_id=dgdm.game_id
             where GAME_TAG= \'CAMP\' and dgm.status = \'A\' and dgdm.status = \'A\' ORDER BY dgm.GAME_ID ');
        $query = $this -> db -> query($sql,array());
        return $query -> result();
    }
    function getClientDtlsforId($clientId)
    {
        $sql = ('SELECT * FROM '.USER_SCHEMA.'.client_mstr cm where CLIENT_ID= ?');
        $query = $this -> db -> query($sql,array($clientId));
        return $query -> result();
    }
    function getStratupType()
    {
        $sql = ('SELECT * FROM '.STRATUP_SCHEMA.'.stratup_type_mstr');
        $query = $this -> db -> query($sql,array());
        return $query -> result();
    }
    function getStratupMode()
    {
        $sql = ('SELECT * FROM '.STRATUP_SCHEMA.'.stratup_mode_mstr');
        $query = $this -> db -> query($sql,array());
        return $query -> result();
    }
    function getStratupTypebyId($typeId)
    {
        $sql = ('SELECT * FROM '.STRATUP_SCHEMA.'.stratup_type_mstr where STRATUP_TYPE_ID=?');
        $query = $this -> db -> query($sql,array($typeId));
        return $query -> result();
    }
    function getStratupModebyId($modeId)
    {
        $sql = ('SELECT * FROM '.STRATUP_SCHEMA.'.stratup_mode_mstr where STRATUP_MODE_ID=?');
        $query = $this -> db -> query($sql,array($modeId));
        return $query -> result();
    }
    function getDiscountTillDateForGameId($gameId) 
	{
		$sql = ('SELECT GAME_ID,GAME_DETAIL_CODE,GAME_DETAIL_TITLE,GAME_DETAIL_DESC FROM dial_game_details_mstr 
        WHERE GAME_ID = ? AND GAME_DETAIL_CODE = "DISCOUNT" AND STATUS="A"'); 
		$query = $this -> db -> query($sql,array($gameId));
		return $query -> result();
    }    
    function getMissionMstrDtls()
    {
        $sql = ('SELECT
                    *
                FROM
                '.STRATUP_SCHEMA.'.stratup_mission_tbl
                WHERE
                STATUS = "A" ORDER BY TARGET_YEAR,TARGET_QUARTER ASC ');
        $query = $this -> db -> query($sql,array());
        return $query -> result_array();
    }
    function getMissionUniverseDtls($gameBatchId)
    {
        $sql = ('SELECT smut.MISSION_UNIVERSE_ID,smt.MISSION_ID,MISSION_TITLE,ACHIEVED_STATUS
                    FROM '.STRATUP_SCHEMA.'.stratup_mission_universe_tbl smut
                    INNER JOIN '.STRATUP_SCHEMA.'.stratup_mission_tbl smt ON smt.MISSION_ID = smut.MISSION_ID
                WHERE GAME_BATCH_ID = ? ');
        $query = $this -> db -> query($sql,array($gameBatchId));
        return $query -> result_array();
    }
    function insertMissionforUniverse($param)
    {
        $this->db->insert(STRATUP_SCHEMA.'.stratup_mission_universe_tbl',$param);
        return $this->db->insert_id();
    }
    function updateMissionAchievedStatusForUniverse($missionStatus,$gameBatchId, $missionId)
    {
        $sql = ('UPDATE '.STRATUP_SCHEMA.'.stratup_mission_universe_tbl SET ACHIEVED_STATUS=? WHERE GAME_BATCH_ID=? AND MISSION_ID=?');
        $this ->  db-> query($sql, array($missionStatus, $gameBatchId, $missionId));
    }
    function getMissionUniverseStatusForMissionId($gameBatchId, $missionId)
    {
        $sql = ('SELECT smut.MISSION_UNIVERSE_ID,smt.MISSION_ID,MISSION_TITLE,ifnull(ACHIEVED_STATUS,"")ACHIEVED_STATUS
                    FROM '.STRATUP_SCHEMA.'.stratup_mission_universe_tbl smut
                    INNER JOIN '.STRATUP_SCHEMA.'.stratup_mission_tbl smt ON smt.MISSION_ID = smut.MISSION_ID
                WHERE GAME_BATCH_ID = ? AND smt.MISSION_ID = ?');
        $query = $this -> db -> query($sql,array($gameBatchId, $missionId));
        return $query -> result_array();
    }
    function getGameListandDetailsForProductPage()
    {
        $sql = ('SELECT * FROM dial_game_mstr dgm 
            left join dial_game_details_mstr dgdm on dgm.game_id=dgdm.game_id
             where dgm.GAME_CAT_ID= 11 and dgm.status = \'A\' ORDER BY dgm.SEQ_NO ');
        $query = $this -> db -> query($sql,array());
        return $query -> result();
    }

    function getWorkspaceScheduleStatus($wsId)
    {
        $sql = ('SELECT STARTTIME.PROPERTY_DAT_VALUE START_UTC_TIME,ENDTIME.PROPERTY_DAT_VALUE END_UTC_TIME,
        CASE WHEN TIMEDIFF(current_timestamp(),ENDTIME.PROPERTY_DAT_VALUE) > 0 THEN \'EXPIRED\' 
        WHEN TIMEDIFF(current_timestamp(),STARTTIME.PROPERTY_DAT_VALUE) > 0 THEN \'STARTED\' 
        ELSE \'NOTSTARTED\' END EVENTSTATUS  
        FROM (SELECT * FROM '.USER_SCHEMA.'.WORKSPACE_PROPERTIES_MSTR WHERE PROPERTY_KEY = \'GAME_START_TIME\' AND WS_ID = ?) STARTTIME
        INNER JOIN (SELECT * FROM '.USER_SCHEMA.'.WORKSPACE_PROPERTIES_MSTR WHERE PROPERTY_KEY = \'GAME_END_TIME\' AND WS_ID = ?) ENDTIME
        ON STARTTIME.WS_ID = ENDTIME.WS_ID');
        $query = $this -> db -> query($sql,array($wsId,$wsId));
        return $query -> result_array();     
    }

}
?>