<?php

class Joingame_model extends CI_Model {
	function __construct() {
		parent::__construct();
        $this -> stratupdb = $this->load->database('stratup', TRUE);
	}

    function getTeamForUserInUniverse($universeToken,$emailId) 
    {
        // created by : Leela
        // function to get all user under a team
        $sql = ('select turm.*,tt.TEAM_LOGO_NAME,tt.TEAM_MSTR_ID,um.email_id from '.STRATUP_SCHEMA.'.team_user_role_mapping_tbl turm
                     INNER JOIN '.USER_SCHEMA.'.user_mstr um ON um.user_id = turm.user_id
                     inner join '.STRATUP_SCHEMA.'.team_tbl tt on tt.TEAM_ID=turm.TEAM_ID
                     inner join '.STRATUP_SCHEMA.'.game_tbl gt on gt.GAME_ID=tt.GAME_ID
                     inner join '.STRATUP_SCHEMA.'.game_batch_tbl gbt on gbt.GAME_BATCH_ID=gt.GAME_BATCH_ID
                     where gbt.UNIVERSE_TOKEN=?
                     and um.email_id=?');
        $query = $this -> stratupdb -> query($sql,array($universeToken,$emailId));
        return $query -> result();
    }
    function getAvailableTeamsInUniverse($universeToken)
    {
        // created by : Leela
        // function to get unallocated teamids
        $sql = (' select tt.TEAM_ID from team_tbl tt
                     left join team_user_role_mapping_tbl turm on turm.TEAM_ID=tt.TEAM_ID
                     inner join game_tbl gt on gt.GAME_ID=tt.GAME_ID
                     inner join game_batch_tbl gbt on gbt.GAME_BATCH_ID=gt.GAME_BATCH_ID
                     where gbt.UNIVERSE_TOKEN=?
                     and turm.TEAM_ID is null');
        $query = $this -> stratupdb -> query($sql,array($universeToken));
        return $query -> result();
    }
    function checkEmailIdRegistered($emailId)
    {
        // created by : Leela
        // function to check if user is registered or logged in universe
        $sql = ('select USER_ID,LOGIN_ID,EMAIL_ID from  '.USER_SCHEMA.'.user_mstr where email_id=?');
        $query = $this -> stratupdb -> query($sql,array($emailId));
        return $query -> result();
    }
    function checkuserAvailableInUniverse($universeToken,$emailId)
    {
        // created by : Leela
        // function to check if user is registered or logged in universe
        $sql = ('SELECT ult.* FROM universe_lobby_tbl ult 
                     inner join  '.USER_SCHEMA.'.user_mstr um on um.user_id=ult.user_id
                     inner join game_batch_tbl gbt on gbt.game_batch_id=ult.UNIVERSE_ID
                     where gbt.UNIVERSE_TOKEN=? and um.email_id=?');
        $query = $this -> stratupdb -> query($sql,array($universeToken,$emailId));
        return $query -> result();
    }
    function checkUsersNotInOtherTeam($batchId,$teamId,$emailId)
    {
        // created by : Leela
        //to check wheather particular user is there in other team of same universe
         $sql = ('select turmt.* from team_user_role_mapping_tbl turmt
                    inner join team_tbl tt on tt.team_id=turmt.team_id
                    inner join game_tbl gt on gt.game_id=tt.game_id
                    inner join game_batch_tbl gbt on gbt.game_batch_id=gt.game_batch_id
                    inner join '.USER_SCHEMA.'.user_mstr um on um.USER_ID=turmt.USER_ID
                    where gbt.universe_token=? and turmt.team_id!=? and um.email_id=?');
                    
        $query = $this -> stratupdb->query($sql,array($batchId,$teamId,$emailId));
         return $query -> result_array();
    }
    function fetchGameTypeUsingUniverseToken($universeToken)
    {
        // created by : Leela
        $sql = ('SELECT GAME_BATCH_ID,CLIENT_ID,START_DATE,END_DATE,TRAINIER_ID,NO_OF_YEAR_IN_GAME,COURSE_NAME,STRATUP_TYPE,STRATUP_MODE 
                    FROM game_batch_tbl gbt
                    inner join product_universe_mode_map_mstr pum on pum.PRODUCT_UNIVERSE_MODE_MAP_ID = gbt.PRODUCT_UNIVERSE_MODE_MAP_ID
                    inner join product_universe_type_mapping_mstr put on put.PRODUCT_UNIVERSE_TYPE_MAP_ID = pum.PRODUCT_UNIVERSE_MAP_ID
                    inner join stratup_type_mstr stm on put.STRATUP_PRODUCT_TYPE_ID = stm.STRATUP_TYPE_ID 
                    inner join stratup_mode_mstr sm on sm.STRATUP_MODE_ID=gbt.STRATUP_MODE_ID
                    where gbt.UNIVERSE_TOKEN = ?;');
        $query = $this -> stratupdb-> query($sql, array($universeToken));
        return $query -> result();
    }
    function insertUniverseLobbyTbl($universeId,$userId)
    {
        // created by : Leela
        // created on : 18-Jul-2019
        // To insert into universe lobby table
        $sql = ('INSERT INTO UNIVERSE_LOBBY_TBL (UNIVERSE_ID, USER_ID) VALUES (?, ?)');
       return $query = $this -> stratupdb -> query($sql, array($universeId,$userId));
    }
    function insertUniverseLobbyUserRoleMap($universeLobbyId,$roleIdRequested)
    {
        // created by : Leela
        // created on : 18-Jul-2019
        // To insert into universe lobby user role mapping table
        $sql = ('INSERT INTO universe_lobby_user_role_mapping_tbl (UNIVERSE_LOBBBY_ID, ROLE_ID_REQUESTED) 
                    VALUES (?,?)');
        $query = $this -> stratupdb -> query($sql, array($universeLobbyId,$roleIdRequested));
    }
    function getRoleDetailsFromMstr($roleName)
    {
        // created by : Leela
        $sql = ('select DEPARTMENT_ID,DEPARTMENT_NAME,DEPARTMENT_DESC from department_mstr where DEPARTMENT_NAME=?');
        $query = $this -> stratupdb -> query($sql, array($roleName));
        return $query -> result();
    }
    function updateLogoNameForTeam($teamLogoName, $teamId)
    {
        $sql = ('UPDATE team_tbl SET TEAM_LOGO_NAME = ? WHERE TEAM_ID = ?');
        $query = $this -> stratupdb -> query($sql, array( $teamLogoName, $teamId));
    }
	function getUserDtlsbyId($userId)
    {
        // created by : Ashwini
        // function to get user Dtls
        $sql = ('select USER_ID,LOGIN_ID,EMAIL_ID from  '.USER_SCHEMA.'.user_mstr where user_id=?');
        $query = $this -> stratupdb -> query($sql,array($userId));
        return $query -> result();
    }
    function checkuserAvailableInUniverseByBatchId($batchId,$emailId)
    {
        // created by : Ashwini
        // function to check if user is registered or logged in universe
        $sql = ('SELECT ult.* FROM universe_lobby_tbl ult 
                     inner join  '.USER_SCHEMA.'.user_mstr um on um.user_id=ult.user_id
                     inner join game_batch_tbl gbt on gbt.game_batch_id=ult.UNIVERSE_ID
                     where gbt.game_batch_id=? and um.email_id=?');
        $query = $this -> stratupdb -> query($sql,array($batchId,$emailId));
        return $query -> result();
    }
}
?>