<?php

class Master_model extends CI_Model 
{
    function __construct()
    {
        parent::__construct();
    }
    function getGame()
    {
        $sql = ('select * from dial_game_mstr');
        $query = $this->db->query($sql,array());
        return $query -> result();
    }
    function getStory()
    {
        $sql = ('select * from dial_story_mstr');
        $query = $this->db->query($sql,array());
        return $query -> result();
    }
    function getStoryById($storyId)
    {
        $sql = ('select * from dial_story_mstr where STORY_ID=?');
        $query = $this->db->query($sql,array($storyId));
        return $query -> result();
    }
    function getstorymapforgame($gameId)
    {
        $sql = ('SELECT dgsmm.*,dsm.STORY_TITLE FROM dial_game_seg_story_map_mstr dgsmm 
                inner join dial_story_mstr dsm on dsm.STORY_ID=dgsmm.STORY_ID where GAME_ID=?');
        $query = $this->db->query($sql,array($gameId));
        return $query -> result();
    }
    function updatestorymapforgame($gameId, $storyId,$storyparams)
    {
        $array = array('GAME_ID' => $gameId, 'STORY_ID' => $storyId);
         $this->db->where($array);
       return $this->db->update('dial_game_seg_story_map_mstr',$storyparams);
       
    }
    function addstorymapforgame($params)
    {
        $this->db->insert('dial_game_seg_story_map_mstr',$params);
        return $this->db->insert_id();
    }
    function getCompStmtbystory($storyId)
    {
        $compid=1000+$storyId;
        $this->db->like('COMP_STMT_CODE', $compid, 'after');
		$this->db->order_by("COMP_STMT_CODE", "desc");
        $query = $this->db->get('dial_comp_stmt_mstr');
         return $query -> result();
    }
    function getCompStmtbystorywithPlayerStmtFlag($storyId)
    {
        $sql = ("SELECT SUMMARY2.COMP_STMT_CODE,COMP_STMT_TITLE,COMP_STMT_TYPE,COMP_STMT_DESC,MEDIA_URL,CASE WHEN PLAY_STMT_DESC IS NULL OR POINTS IS NULL THEN 'TODO' ELSE 'DONE' END AS CONFIG FROM
        (SELECT COMP_STMT_CODE,STORY_TITLE,COMP_STMT_TITLE,COMP_STMT_DESC,COMP_STMT_TYPE,MEDIA_URL,MAX(PLAY_STMT_DESC) PLAY_STMT_DESC,GROUP_CONCAT(CONCAT(POINTS_PARAM_CODE,':',INCREASE_DECREASE,':',VALUE) SEPARATOR '\n') POINTS
         FROM (
        SELECT STORY_TITLE,DCSM.COMP_STMT_CODE,DCSM.COMP_STMT_TITLE,DCSM.COMP_STMT_DESC,DCSM.COMP_STMT_TYPE,DCSM.MEDIA_URL,PLAY_STMT_DESC,POINTS_PARAM_CODE,INCREASE_DECREASE,VALUE
        FROM dial_story_mstr dsm
        left JOIN dial_comp_stmt_mstr DCSM on substr(dcsm.COMP_STMT_CODE,1,4) = 1000+dsm.STORY_ID
        left JOIN dial_player_stmt_mstr DPSM on dcsm.comp_stmt_code = dpsm.source_comp_stmt_code
        left join dial_player_stmt_points_mstr dpspm on dpsm.play_stmt_code = dpspm.play_stmt_code
        WHERE DSM.STORY_ID=?)
        SUMMARY GROUP BY STORY_TITLE,COMP_STMT_CODE,COMP_STMT_TITLE,COMP_STMT_DESC,COMP_STMT_TYPE,MEDIA_URL
        ORDER BY STORY_TITLE,COMP_STMT_CODE desc) SUMMARY2");
        $query = $this->db->query($sql,array($storyId));
        return $query -> result();
    }
    function getCompStmtbystoryForDestn($storyId,$sourcecompId)
    {
        $compid=1000+$storyId."%";
        $sql = ('SELECT dcsm.COMP_STMT_CODE,case when dpsm.PLAY_STMT_CODE is null
                        then dcsm.COMP_STMT_DESC else concat(": ",dcsm.COMP_STMT_DESC) end COMP_STMT_DESC
                FROM dial_comp_stmt_mstr dcsm
                left join dial_player_stmt_mstr dpsm on dcsm.COMP_STMT_CODE = dpsm.DESTN_COMP_STMT_CODE
                where COMP_STMT_CODE like "'.$compid.'" AND COMP_STMT_CODE != ? AND COMP_STMT_DESC != "Level Complete"  group by dcsm.COMP_STMT_CODE order by dcsm.COMP_STMT_CODE desc');
        $query = $this->db->query($sql,array($sourcecompId));
        return $query -> result();
    }
    function getplaystmtForCompId($compid)
    {
        $sql = ('SELECT dpsm.PLAY_STMT_CODE,dpsm.SOURCE_COMP_STMT_CODE,dpsm.PLAY_STMT_DESC,
                        dpsm.DESTN_COMP_STMT_CODE,dcsm.COMP_STMT_DESC 
                        FROM dial_player_stmt_mstr dpsm inner Join dial_comp_stmt_mstr dcsm on 
                        dcsm.COMP_STMT_CODE = dpsm.DESTN_COMP_STMT_CODE where SOURCE_COMP_STMT_CODE= ?');
        $query = $this->db->query($sql,array($compid));
        return $query -> result();
    }
    function getCompStmtbyId($compid)
    {
        $sql = ('SELECT * FROM dial_comp_stmt_mstr where COMP_STMT_CODE= ?');
        $query = $this->db->query($sql,array($compid));
        return $query -> result();
    }
    
    function getLevelCompeleteCompStmtId($storyId)
    {
        $compid=1000+$storyId."%";
        $sql = ('SELECT * FROM dial_comp_stmt_mstr where COMP_STMT_CODE like ? and COMP_STMT_DESC = "Level Complete"');
        $query = $this->db->query($sql,array($compid));
        return $query -> result();
    }

    function updatecompStmtbyId($compId,$compstmtparams)
    {
         $this->db->where('COMP_STMT_CODE',$compId);
        return $this->db->update('dial_comp_stmt_mstr',$compstmtparams);
    }
    function getmaxCompcodeForStory($storyId)
    {
        $compid=1000+$storyId;
        $sql = ('SELECT SUBSTRING(MAX(COMP_STMT_CODE),5,LENGTH(MAX(COMP_STMT_CODE))-4)+1 as COMP_STMT_CODE FROM dial_comp_stmt_mstr WHERE COMP_STMT_CODE LIKE ?');
        $query = $this->db->query($sql,array($compid.'%'));
        return $query -> result();
    }
    function addcompStmtForstory($params)
    {
        $this->db->insert('dial_comp_stmt_mstr',$params);
        return $this->db->insert_id();
    }
    function getpointsparaForplayId($playId)
    {
        $sql = ('SELECT PSP_CODE,PLAY_STMT_CODE,dpspm.POINTS_PARAM_CODE,
                        dppm.POINTS_PARAM_DESC,dpspm.INCREASE_DECREASE,dpspm.VALUE 
                        FROM dial_player_stmt_points_mstr dpspm
                        inner join dial_points_param_mstr dppm on dppm.POINTS_PARAM_CODE= dpspm.POINTS_PARAM_CODE
                        where PLAY_STMT_CODE= ?');
        $query = $this->db->query($sql,array($playId));
        return $query -> result();
    }
    function getplaystmtForPlayId($playId)
    {
        $sql = ('SELECT * FROM dial_player_stmt_mstr where PLAY_STMT_CODE= ?');
        $query = $this->db->query($sql,array($playId));
        return $query -> result();
    }
    function updateplayerStmtbyId($playId,$playstmtparams)
    {
         $this->db->where('PLAY_STMT_CODE',$playId);
        return $this->db->update('dial_player_stmt_mstr',$playstmtparams);
    }
    function getmaxstmtcodeForCompId($storyId)
    {
        $playid=1000+$storyId;
        $sql = ('SELECT SUBSTRING(MAX(PLAY_STMT_CODE),5,LENGTH(MAX(PLAY_STMT_CODE))-4)+1 as PLAY_STMT_CODE FROM dial_player_stmt_mstr WHERE PLAY_STMT_CODE LIKE ?');
        $query = $this->db->query($sql,array($playid.'%'));
        return $query -> result();		 
    }
    function getPointsparammstr()
    {
        $sql = ('SELECT * FROM dial_points_param_mstr');
        $query = $this->db->query($sql,array());
        return $query -> result();
    }
    function addplayStmtForcompCode($params)
    {
        $this->db->insert('dial_player_stmt_mstr',$params);
        return $this->db->insert_id();
    }
    function updatepointsparambyId($paramId,$params)
    {
         $array = array('PSP_CODE' => $paramId);
         $this->db->where($array);
        return $this->db->update('dial_player_stmt_points_mstr',$params);
    }
    function getparabyplayparaId($playId,$paramId)
    {
        $sql = ('SELECT PSP_CODE,dpspm.POINTS_PARAM_CODE,
                        dppm.POINTS_PARAM_DESC,dpspm.INCREASE_DECREASE,dpspm.VALUE 
                        FROM dial_player_stmt_points_mstr dpspm
                        inner join dial_points_param_mstr dppm on dppm.POINTS_PARAM_CODE= dpspm.POINTS_PARAM_CODE
                        where PLAY_STMT_CODE= ? and PSP_CODE=?');
        $query = $this->db->query($sql,array($playId,$paramId));
        return $query -> result();
    }
    function addpointsparamForPlayId($params)
    {
        $this->db->insert('dial_player_stmt_points_mstr',$params);
        return $this->db->insert_id();
    }
    function getCompStmttype()
    {
        $sql = ('SELECT Distinct(COMP_STMT_TYPE) FROM dial_comp_stmt_mstr where COMP_STMT_TYPE is not null');
        $query = $this->db->query($sql,array());
        return $query -> result();
    }
    function getGameStatus($gameId)
    {
        $sql = ('SELECT GAME_TITLE,COMP_STMT_CODE,STORY_TITLE,COMP_STMT_TITLE,COMP_STMT_DESC,COMP_STMT_TYPE,MEDIA_URL,
        PLAY_STMT_DESC,DEST_COMP_STMT,DEST_COMP_STMT_TYPE,DEST_MEDIA,
        GROUP_CONCAT(CONCAT(POINTS_PARAM_DESC,":",INCREASE_DECREASE,":",VALUE) SEPARATOR "\n") POINTS
        FROM (
        SELECT GAME_TITLE,STORY_TITLE,DCSM.COMP_STMT_CODE,DCSM.COMP_STMT_TITLE,
        DCSM.COMP_STMT_DESC,DCSM.COMP_STMT_TYPE,DCSM.MEDIA_URL,PLAY_STMT_DESC,DCSMD.COMP_STMT_DESC DEST_COMP_STMT,
        DCSMD.COMP_STMT_TYPE DEST_COMP_STMT_TYPE,DCSMD.MEDIA_URL DEST_MEDIA,POINTS_PARAM_DESC,INCREASE_DECREASE,VALUE
        FROM DIAL_GAME_MSTR DGM
        LEFT JOIN dial_game_seg_story_map_mstr DGSSMM ON DGM.GAME_ID = DGSSMM.GAME_ID
        LEFT JOIN dial_story_mstr dsm ON DGSSMM.STORY_ID = DSM.STORY_ID
        left JOIN dial_comp_stmt_mstr DCSM on substr(dcsm.COMP_STMT_CODE,1,4) = 1000+dsm.STORY_ID
        left JOIN dial_player_stmt_mstr DPSM on dcsm.comp_stmt_code = dpsm.source_comp_stmt_code
        LEFT JOIN dial_comp_stmt_mstr DCSMD ON dcsmd.comp_stmt_code = dpsm.DESTN_COMP_STMT_CODE
        left join dial_player_stmt_points_mstr dpspm on dpsm.play_stmt_code = dpspm.play_stmt_code
        left join dial_points_param_mstr dppm on dppm.points_param_code = dpspm.POINTS_PARAM_CODE
        WHERE dgm.game_id=?)
        SUMMARY GROUP BY GAME_TITLE,STORY_TITLE,COMP_STMT_CODE,COMP_STMT_TITLE,COMP_STMT_DESC,COMP_STMT_TYPE,MEDIA_URL,PLAY_STMT_DESC,DEST_COMP_STMT,DEST_COMP_STMT_TYPE,DEST_MEDIA
        ORDER BY GAME_TITLE,STORY_TITLE,COMP_STMT_CODE');
        $query = $this->db->query($sql,array($gameId));
        return $query -> result();
    }
    function addstorymstr($params)
    {
        $this->db->insert('dial_story_mstr',$params);
        return $this->db->insert_id();
    }
    function getstoryDetailsById($storyId)
    {
        $sql = ('SELECT dsm.STORY_ID,STORY_TITLE,STORY_DESC,STORY_SHORT_DESC,STORY_LANGUAGE,STATUS,
                        STORY_LOGO_URL,STORY_SEQ_NO,TIME_LIMIT_SECONDS,STAR_MAX_VAL,SUCCESS_DESC,FAILURE_DESC 
                    FROM dial_game_seg_story_map_mstr dgsmm 
                    inner join dial_story_mstr dsm on dsm.STORY_ID=dgsmm.STORY_ID where dsm.STORY_ID=?');
        $query = $this->db->query($sql,array($storyId));
        return $query -> result();
    }
    function updatestorymstr($params,$storyId)
    {
        $array = array('STORY_ID' => $storyId);
         $this->db->where($array);
        return $this->db->update('dial_story_mstr',$params);
    }
    function getStorymstrWithMapping($gameId)
    {
        $sql = ('SELECT dsm.STORY_ID,STORY_TITLE,STORY_DESC,STORY_SHORT_DESC,STORY_LANGUAGE,STATUS,
        STORY_LOGO_URL,STORY_SEQ_NO,COMP_STMT_DESC,TIME_LIMIT_SECONDS,STAR_MAX_VAL,SUCCESS_DESC,FAILURE_DESC FROM dial_game_seg_story_map_mstr dgsmm 
                        inner join dial_story_mstr dsm on dsm.STORY_ID=dgsmm.STORY_ID
                        left join dial_comp_stmt_mstr dcsm on dcsm.COMP_STMT_CODE = dsm.START_COMP_STMT_CODE
                        where GAME_ID=?');
        $query = $this->db->query($sql,array($gameId));
        return $query -> result();
    }
    function validateCompStmtForStoryhasPlayerStmt($storyId)
    {
        $sql = ('SELECT SUMMARY2.COMP_STMT_CODE,COMP_STMT_TITLE,COMP_STMT_TYPE,COMP_STMT_DESC,MEDIA_URL,CASE WHEN PLAY_STMT_DESC IS NULL THEN \'TODO\' ELSE \'DONE\' END AS CONFIG FROM
            (SELECT COMP_STMT_CODE,STORY_TITLE,COMP_STMT_TITLE,COMP_STMT_DESC,COMP_STMT_TYPE,MEDIA_URL,MAX(PLAY_STMT_DESC) PLAY_STMT_DESC
            FROM (
            SELECT STORY_TITLE,DCSM.COMP_STMT_CODE,DCSM.COMP_STMT_TITLE,DCSM.COMP_STMT_DESC,DCSM.COMP_STMT_TYPE,DCSM.MEDIA_URL,PLAY_STMT_DESC
            FROM dial_story_mstr dsm
            left JOIN dial_comp_stmt_mstr DCSM on substr(dcsm.COMP_STMT_CODE,1,4) = 1000+dsm.STORY_ID
            left JOIN dial_player_stmt_mstr DPSM on dcsm.comp_stmt_code = dpsm.source_comp_stmt_code
            WHERE DSM.STORY_ID=? and COMP_STMT_DESC !="Level Complete")
            SUMMARY GROUP BY STORY_TITLE,COMP_STMT_CODE,COMP_STMT_TITLE,COMP_STMT_DESC,COMP_STMT_TYPE,MEDIA_URL
            ORDER BY STORY_TITLE,COMP_STMT_CODE desc) SUMMARY2');
        $query = $this->db->query($sql,array($storyId));
        return $query -> result();
    }
    function checkStoryhasLevelCompt($storyId)
    {
        $sql = ('SELECT CASE WHEN count(*) > 0 THEN "YES" ELSE "NO" END LEVELCOMP_MAPPED
                    FROM dial_story_mstr dsm
                    left JOIN dial_comp_stmt_mstr DCSM on substr(dcsm.COMP_STMT_CODE,1,4) = 1000+dsm.STORY_ID
                    left JOIN dial_player_stmt_mstr DPSM on dcsm.comp_stmt_code = dpsm.source_comp_stmt_code
                    left JOIN dial_comp_stmt_mstr DCSM2 on dcsm2.comp_stmt_code = dpsm.DESTN_COMP_STMT_CODE
                    WHERE DSM.STORY_ID=? and DCSM2.COMP_STMT_DESC = "Level Complete"');
        $query = $this->db->query($sql,array($storyId));
        return $query -> result();
    }
    function getCountOfCompStmtCountExceptLevelComp($storyId)
    {
        $sql = ('SELECT count(*)  As COUNT_OF_COMP_STMT
                    FROM dial_story_mstr dsm
                    left JOIN dial_comp_stmt_mstr DCSM on substr(dcsm.COMP_STMT_CODE,1,4) = 1000+dsm.STORY_ID
                    WHERE DSM.STORY_ID = ? and DCSM.COMP_STMT_DESC != "Level Complete"');
        $query = $this->db->query($sql,array($storyId));
        return $query -> result();
    }
    function getPlayerStmtWithStatusForCompId($storyId)
    {
        $sql = ('SELECT SUMMARY2.PLAY_STMT_CODE,SOURCE_COMP_STMT_CODE,PLAY_STMT_DESC,DESTN_COMP_STMT_CODE,COMP_STMT_DESC,MEDIA_URL,CASE WHEN POINTS IS NULL THEN \'TODO\' ELSE \'DONE\' END AS CONFIG FROM
        (SELECT PLAY_STMT_CODE,SOURCE_COMP_STMT_CODE,PLAY_STMT_DESC,DESTN_COMP_STMT_CODE,COMP_STMT_DESC,MEDIA_URL,GROUP_CONCAT(CONCAT(POINTS_PARAM_CODE,":",INCREASE_DECREASE,":",VALUE) SEPARATOR "\n") POINTS
         FROM (
        SELECT DPSM.PLAY_STMT_CODE,SOURCE_COMP_STMT_CODE,PLAY_STMT_DESC,DESTN_COMP_STMT_CODE,COMP_STMT_DESC,DPSM.MEDIA_URL,POINTS_PARAM_CODE,INCREASE_DECREASE,VALUE
        FROM  dial_player_stmt_mstr DPSM 
        left join dial_player_stmt_points_mstr dpspm on dpsm.play_stmt_code = dpspm.play_stmt_code
        left join dial_comp_stmt_mstr dcsm on dcsm.COMP_STMT_CODE = dpsm.DESTN_COMP_STMT_CODE
        WHERE SOURCE_COMP_STMT_CODE=? )
        SUMMARY GROUP BY PLAY_STMT_CODE,SOURCE_COMP_STMT_CODE,PLAY_STMT_DESC,DESTN_COMP_STMT_CODE,COMP_STMT_DESC,MEDIA_URL) SUMMARY2');
        $query = $this->db->query($sql,array($storyId));
        return $query -> result();
    }
    function addpointsparamForStoryId($params)
    {
        $this->db->insert('dial_story_param_target_mstr',$params);
        return $this->db->insert_id();
    }
    function updatepointsparamForStoryId($params,$targetId)
    {
        $array = array('TARGET_ID' => $targetId);
        $this->db->where($array);
        return $this->db->update('dial_story_param_target_mstr',$params);
    }
    function getPointsparammstrForStoryId($storyId)
    {
        $sql = ('SELECT STORY_ID,TARGET_ID,dsptm.POINTS_PARAM_CODE,POINTS_PARAM_DESC,APPLICABLE_GAME,POINTS_PARAM_TYPE,DEFAULT_SCORE,TARGET FROM dial_story_param_target_mstr dsptm
        inner join dial_points_param_mstr dppm on dppm.POINTS_PARAM_CODE = dsptm.POINTS_PARAM_CODE
        where story_id=?');
        $query = $this->db->query($sql,array($storyId));
        return $query -> result();
    }
    function getListofPortalGame()
    {
        $sql = ('SELECT PORTAL_GAME_ID,PORTAL_GAME_TITLE,PORTAL_GAME_DESC,
                        PORTAL_GAME_LINK,PORTAL_GAME_IMAGE_PATH 
                    from dial_portal_game_list_mstr 
                    where status = "A"');
        $query = $this->db->query($sql,array());
        return $query -> result();
    }
    function getgameMstrForGamelets()
    {
        $sql = ('SELECT GAME_ID,GAME_TITLE,GAME_DESC,GAME_LOGO_PATH,STATUS,SEQ_NO,UNITY_SEQ_NO from dial_game_mstr dgm  
		WHERE dgm.GAME_CAT_ID in (5,8,9) order by STATUS,UNITY_SEQ_NO Asc');
        $query = $this->db->query($sql,array());
        return $query -> result();
    }
    function addgamemstr($params)
    {
        $this->db->insert('dial_game_mstr',$params);
        return $this->db->insert_id();
    }
    function getGameDetailsById($gameId)
    {
        $sql = ('SELECT GAME_ID,GAME_TITLE,GAME_DESC,GAME_LOGO_PATH,SPLASH_SCREEN_PATH,STATUS,SEQ_NO,UNITY_SEQ_NO from dial_game_mstr
		WHERE GAME_ID = ?');
        $query = $this->db->query($sql,array($gameId));
        return $query -> result();
    }
    function updategamemstr($params,$gameId)
    {
        $array = array('GAME_ID' => $gameId);
        $this->db->where($array);
        return $this->db->update('dial_game_mstr',$params);
    }
}