/**
 * @author ashwini
 */
var cardOpt = {
    legend: {
        display : false
    },
    scales: {
        yAxes: [{
            gridLines : {
                display : false
            },
            stacked: true
        }],
        xAxes : [ {
            gridLines : {
                display : false
            },
            stacked: true
        } ]
    }
};
var bgColor = ['rgba(255, 99, 132, 0.2)',
				    'rgba(54, 162, 235, 0.2)',
				    'rgba(255, 206, 86, 0.2)',
				    'rgba(75, 192, 192, 0.2)',
				    'rgba(153, 102, 255, 0.2)',
				    'rgba(255, 159, 64, 0.2)'];
				    
var bdColor = ['rgba(255,99,132,1)',
                    'rgba(54, 162, 235, 1)',
                    'rgba(255, 206, 86, 1)',
                    'rgba(75, 192, 192, 1)',
                    'rgba(153, 102, 255, 1)',
                    'rgba(255, 159, 64, 1)'];
                    

function chartPat(obj){
	var objpat=obj.pat;
	var Year = [];
    var pat = [];

    for (var i in objpat) {
    	 Year.push('Y'+objpat[i].year);
         pat.push((objpat[i].Actual_Value/1000000).toFixed(2));
    }
     // Prepare Chart Start
     var config = {
        type: 'line',
        data: {
                datasets: [
                
                  {
                      label: 'PAT',
                      data: pat,
                      backgroundColor: 'rgba(255, 99, 132, 0.2)',
                      borderWidth: 1
                  }
                 
                ],
                
                labels:Year
            },
        options: {legend: {
        display : false
    },
    scales: {
        yAxes: [{
            gridLines : {
                display : false
            },
            scaleLabel: {
            display: true,
            labelString: 'In Millions'
          }
        }],
        xAxes : [ {
            gridLines : {
                display : false
            }
        } ]
    }
    }
    };
    var patChart = document.getElementById("patChart").getContext('2d');
    patChart = new Chart(patChart, config);       
    // Prepare Chart End
}
function chartDebt(obj){
	var objDebt=obj.Debt;
	var objEquity=obj.Equity;
	var Year = [];
    var Debt = [];
    var Equity = [];


    for (var i in objDebt) {
    	
    		Year.push('Y'+objDebt[i].Year+'Q'+objDebt[i].Qtr);
         Debt.push((objDebt[i].VALUE/1000000).toFixed(2));
        } 

   
     for (var i in objEquity) {
         Equity.push((objEquity[i].VALUE/1000000).toFixed(2));
    
    }
     // Prepare Chart Start
     var config = {
        type: 'bar',
        data: {
                datasets: [
                
                  {
                      label: 'Debt',
                      data: Debt,
                      backgroundColor: 'rgba(255, 99, 132, 0.2)',
                      borderWidth: 1
                  },
                  {
                      label: 'Equity',
                      data: Equity,
                      backgroundColor: 'rgba(54, 162, 235, 0.2)',
                      borderWidth: 1
                  }
                 
                ],
                
                labels:Year
            },
        options: {legend: {
        position: 'bottom'
    },
    scales: {
        yAxes: [{
            gridLines : {
                display : false
            },
            scaleLabel: {
            display: true,
            labelString: 'In Millions'
          }
        }],
        xAxes : [ {
            gridLines : {
                display : false
            }
        } ]
    }
    }
    };
    var patChart = document.getElementById("debtChart").getContext('2d');
    patChart = new Chart(patChart, config);       
    // Prepare Chart End
}
function chartApproval(obj){
	var objApproved=obj.Approved;
	var objAvailable=obj.Available;
	var objInvestment=obj.Investment;
	var Year = [];
    var Approved = [];
    var Available = [];
    var Investment = [];


    for (var i in objApproved) {
    	
    		Year.push('Y'+objApproved[i].YEAR);
         Approved.push((objApproved[i].VALUE/1000000).toFixed(2));
        } 

     for (var i in objAvailable) {
         Available.push((objAvailable[i].VALUE/1000000).toFixed(2));
    }
     for (var i in objInvestment) {
         Investment.push((objInvestment[i].VALUE/1000000).toFixed(2));
    }
     // Prepare Chart Start
     var config = {
        type: 'line',
        data: {
                datasets: [
                
                  {
                      label: 'Approved',
                      data: Approved,
                      backgroundColor: 'rgba(255, 99, 132, 0.2)',
                      borderWidth: 1
                  },
                  {
                      label: 'Available',
                      data: Available,
                      backgroundColor: 'rgba(54, 162, 235, 0.2)',
                      borderWidth: 1
                  },
                  {
                      label: 'Investment',
                      data: Investment,
                      backgroundColor: 'rgba(255, 125, 25, 0.4)',
                      borderWidth: 1
                  }
                 
                ],
                
                labels:Year
            },
        options: {legend: {
        position: 'bottom'
    },
    scales: {
        yAxes: [{
            gridLines : {
                display : false
            },
            scaleLabel: {
            display: true,
            labelString: 'In Millions'
          }
        }],
        xAxes : [ {
            gridLines : {
                display : false
            }
        } ]
    }
    }
    };
    var patChart = document.getElementById("approvalChart").getContext('2d');
    patChart = new Chart(patChart, config);       
    // Prepare Chart End
}
function chartBookValue(obj){
	var objBookValueChart=obj.BookValueChart;
	var Year = [];
    var BookValueChart = [];


    for (var i in objBookValueChart) {
    	
    		Year.push(objBookValueChart[i].YEAR+objBookValueChart[i].Year_Qtr);
         BookValueChart.push((objBookValueChart[i].BOOK_VALUE));
        } 

     // Prepare Chart Start
     var config = {
        type: 'line',
        data: {
                datasets: [
                
                  {
                      label: 'Book Value',
                      data: BookValueChart,
                      backgroundColor: 'rgba(255, 99, 132, 0.2)',
                      borderWidth: 1
                  }
                 
                ],
                
                labels:Year
            },
        options: cardOpt
    };
    var patChart = document.getElementById("bookChart").getContext('2d');
    patChart = new Chart(patChart, config);       
    // Prepare Chart End
}