/**
 * @author ashwini
 */
var cardOpt = {
    legend: {
        position: 'bottom'
    },
    scales: {
        yAxes: [{
            gridLines : {
                display : false
            }
        }],
        xAxes : [ {
            gridLines : {
                display : false
            }
        } ]
    }
};
var bgColor = ['rgba(255, 99, 132, 0.2)',
				    'rgba(54, 162, 235, 0.2)',
				    'rgba(255, 206, 86, 0.2)',
				    'rgba(75, 192, 192, 0.2)',
				    'rgba(153, 102, 255, 0.2)',
				    'rgba(255, 159, 64, 0.2)'];
				    
var bdColor = ['rgba(255,99,132,1)',
                    'rgba(54, 162, 235, 1)',
                    'rgba(255, 206, 86, 1)',
                    'rgba(75, 192, 192, 1)',
                    'rgba(153, 102, 255, 1)',
                    'rgba(255, 159, 64, 1)'];
                    
function chartProductionVsProduced(obj,chartId){
	//console.log(obj);
	var objProdSoldProduce=obj;
	var Year = [];
    var ProdSoldProduce = [];
    var ProdSold =[];

    for (var i in objProdSoldProduce) {
        Year.push('Y'+objProdSoldProduce[i].Year+'Q'+objProdSoldProduce[i].Qtr);
        ProdSoldProduce.push((objProdSoldProduce[i].ProdAllocat));
    }
    for (var i in objProdSoldProduce) {
        ProdSold.push((objProdSoldProduce[i].ProdSold));
    }
     // Prepare Chart Start
     var config = {
        type: 'line',
        data: {
                datasets: [
                  {
                      label: 'Allocated',
                      data: ProdSoldProduce,
                      backgroundColor: 'rgba(255, 99, 132, 0.2)',
                      borderWidth: 1
                  },
                  {
                      label: 'Produced',
                      data: ProdSold,
                      backgroundColor: 'rgba(54, 162, 235, 0.2)',
                      borderWidth: 1
                  }
                ],
                labels:Year
            },
        options: {legend: {
        position: 'bottom'
    },
    scales: {
        yAxes: [{
            gridLines : {
                display : false
            },
            scaleLabel: {
            display: true,
            labelString: 'No. of Products'
          }
        }],
        xAxes : [ {
            gridLines : {
                display : false
            }
        } ]
    }
    }
    };
   new Chart(document.getElementById(chartId).getContext('2d'), config);
    // Prepare Chart End
}
function chartProductionEfficiency(obj,chartId){
	//console.log(obj);
	var objProdSoldProduce=obj;
	var Year = [];
    // var ProdSoldProduce = [];
    // var ProdSold =[];
    var productionEfficiency =[];

    for (var i in objProdSoldProduce) {
        Year.push('Y'+objProdSoldProduce[i].Year+'Q'+objProdSoldProduce[i].Qtr);
        productionEfficiency.push(((objProdSoldProduce[i].ProdSold)/(objProdSoldProduce[i].ProdAllocat))*100);
    }
    // for (var i in objProdSoldProduce) {
        // ProdSold.push((objProdSoldProduce[i].ProdSold));
    // }
     // Prepare Chart Start
     var config = {
        type: 'line',
        data: {
                datasets: [
                  {
                      label: 'Production Effciency',
                      data: productionEfficiency,
                      backgroundColor: 'rgba(54, 162, 235, 0.2)',
                      borderWidth: 1
                  }
                ],
                labels:Year
            },
        options: {legend: {
        position: 'bottom'
    },
    scales: {
        yAxes: [{
            gridLines : {
                display : false
            },
            scaleLabel: {
            display: true,
            labelString: 'Production Efficiency %'
          },
          // ticks: {
                // max: 100,
                // min: 0,
                // stepSize: 10
            // }
            ticks: {
                    suggestedMin: 0,
                    suggestedMax: 100
                }
        }],
        xAxes : [ {
            gridLines : {
                display : false
            }
        } ]
    }
    }
    };
   new Chart(document.getElementById(chartId).getContext('2d'), config);
    // Prepare Chart End
}
function chartAllocatedVsSold(objAllocat,objSold,chartId){
	// var objAllocat=obj.Allocat;
	// var objSold=obj.Sold;
	var Year = [];
    var Allocat = [];
    var Sold =[];
  
    for (var i in objAllocat) {
        Year.push('Y'+objAllocat[i].Year+'Q'+objAllocat[i].Qtr);
        Allocat.push((objAllocat[i].PRODUCTS));
    }
    for (var i in objSold) {
        Sold.push((objSold[i].PRODUCTS));
    }
     // Prepare Chart Start
     var config = {
        type: 'line',
        data: {
                datasets: [
                  {
                      label: 'Allocated',
                      data: Allocat,
                      backgroundColor: 'rgba(255, 99, 132, 0.2)',
                      borderWidth: 1
                  },
                  {
                      label: 'Sold',
                      data: Sold,
                      backgroundColor: 'rgba(54, 162, 235, 0.2)',
                      borderWidth: 1
                  }
                ],
                labels:Year
            },
        options: {legend: {
        position: 'bottom'
    },
    scales: {
        yAxes: [{
            gridLines : {
                display : false
            },
            scaleLabel: {
            display: true,
            labelString: 'No. of Products'
          }
        }],
        xAxes : [ {
            gridLines : {
                display : false
            }
        } ]
    }
    }
    };
    new Chart(document.getElementById(chartId).getContext('2d'), config);
    // Prepare Chart End
}
function chartSalesEfficiency(objAllocat,objSold,chartId){
	var Year = [];
    var Allocat = [];
    var Sold =[];
    var SalesEfficiency=[];
  
    for (var i in objAllocat) {
        Year.push('Y'+objAllocat[i].Year+'Q'+objAllocat[i].Qtr);
        Allocat.push((objAllocat[i].PRODUCTS));
    }
    for (var i in objSold) {
        Sold.push((objSold[i].PRODUCTS));
        SalesEfficiency.push(((objSold[i].PRODUCTS)/(objAllocat[i].PRODUCTS))*100);
    }
     // Prepare Chart Start
     var config = {
        type: 'line',
        data: {
                datasets: [
                  {
                      label: 'Sales Efficiency',
                      data: SalesEfficiency,
                      backgroundColor: 'rgba(54, 162, 235, 0.2)',
                      borderWidth: 1
                  }
                ],
                labels:Year
            },
        options: {legend: {
        position: 'bottom'
    },
    scales: {
        yAxes: [{
            gridLines : {
                display : false
            },
            scaleLabel: {
            display: true,
            labelString: 'Sales Efficiency %'
          },
          ticks: {
                    suggestedMin: 0,
                    suggestedMax: 100
                }
        }],
        xAxes : [ {
            gridLines : {
                display : false
            }
        } ]
    }
    }
    };
    new Chart(document.getElementById(chartId).getContext('2d'), config);
    // Prepare Chart End
}
function chartAttrition(obj,chartId){
	//console.log(obj);
	var Year = [];
    var attrition =[];

    for (var i in obj) {
        Year.push('Y'+obj[i].Year+'Q'+obj[i].Qtr);
        attrition.push(obj[i].AttritionPercentage);
    }
     // Prepare Chart Start
     var config = {
        type: 'line',
        data: {
                datasets: [
                  {
                      label: 'Attrition Percentage',
                      data: attrition,
                      backgroundColor: 'rgba(54, 162, 235, 0.2)',
                      borderWidth: 1
                  }
                ],
                labels:Year
            },
        options: {legend: {
        position: 'bottom'
    },
    scales: {
        yAxes: [{
            gridLines : {
                display : false
            },
            scaleLabel: {
            display: true,
            labelString: 'Attrition %'
          },
            ticks: {
                    suggestedMin: 0,
                    suggestedMax: 100
                }
        }],
        xAxes : [ {
            gridLines : {
                display : false
            }
        } ]
    }
    }
    };
   new Chart(document.getElementById(chartId).getContext('2d'), config);
    // Prepare Chart End
}
function chartRecruitmentEfficiency(obj,chartId){
	//console.log(obj);
	var Year = [];
    var attrition =[];

    for (var i in obj) {
        Year.push('Y'+obj[i].Year+'Q'+obj[i].Qtr);
        attrition.push(obj[i].RecruitmentEfficiencyPercentage);
    }
     // Prepare Chart Start
     var config = {
        type: 'line',
        data: {
                datasets: [
                  {
                      label: 'Recruitment Efficiency Percentage',
                      data: attrition,
                      backgroundColor: 'rgba(54, 162, 235, 0.2)',
                      borderWidth: 1
                  }
                ],
                labels:Year
            },
        options: {legend: {
        position: 'bottom'
    },
    scales: {
        yAxes: [{
            gridLines : {
                display : false
            },
            scaleLabel: {
            display: true,
            labelString: 'Recruitment Efficiency %'
          },
            ticks: {
                    suggestedMin: 0,
                    suggestedMax: 100
                }
        }],
        xAxes : [ {
            gridLines : {
                display : false
            }
        } ]
    }
    }
    };
   new Chart(document.getElementById(chartId).getContext('2d'), config);
    // Prepare Chart End
}
function chartFinHealth(obj,chartId){
	//console.log(obj);
	var Year = [];
    var Pat = [];
    var Revenue = [];
    var Income = [];

    for (var i in obj) {
        Year.push(obj[i].YEAR+''+obj[i].QUARTER);
        Pat.push((obj[i].PAT/1000000).toFixed(2));
        Revenue.push((obj[i].REVENUE/1000000).toFixed(2));
        Income.push((obj[i].INCOME/1000000).toFixed(2));
    }
     // Prepare Chart Start
     var config = {
        type: 'line',
        data: {
                datasets: [
                    {
                        label: 'PAT',
                        data: Pat,
                        backgroundColor: 'rgba(255, 99, 132, 0.2)',
                        borderWidth: 1
                    },
                    {
                        label: 'Revenue',
                        data: Revenue,
                        backgroundColor: 'rgba(54, 162, 235, 0.2)',
                        borderWidth: 1
                    },
                    {
                        label: 'Income',
                        data: Income,
                        backgroundColor: 'rgba(255, 125, 25, 0.4)',
                        borderWidth: 1
                    }
                ],
                labels:Year
            },
        options: {legend: {
        position: 'bottom'
    },
    scales: {
        yAxes: [{
            gridLines : {
                display : false
            },
            scaleLabel: {
            display: true,
            labelString: 'In Millions'
          },
            ticks: {
                    suggestedMin: 0,
                    suggestedMax: 100
                }
        }],
        xAxes : [ {
            gridLines : {
                display : false
            }
        } ]
    }
    }
    };
   new Chart(document.getElementById(chartId).getContext('2d'), config);
    // Prepare Chart End
}
function chartFinHealthCost(obj,chartId){
	console.log(obj);
	var Year = [];
    var hrCost = [];
    var opsCost = [];
    var mktCost = [];
    var finCost = [];
    var cogs = [];

    for (var i in obj[0].HR_COST) {
        Year.push(obj[0].HR_COST[i].YEAR+''+obj[0].HR_COST[i].QUARTER);
        hrCost.push((obj[0].HR_COST[i].AMOUNT/1000000).toFixed(2));
    }
    for (var i in obj[0].MKT_COST) {
        mktCost.push((obj[0].MKT_COST[i].AMOUNT/1000000).toFixed(2));
    }
    for (var i in obj[0].OPS_COST) {
        opsCost.push((obj[0].OPS_COST[i].AMOUNT/1000000).toFixed(2));
    }
    for (var i in obj[0].FIN_COST) {
        finCost.push((obj[0].FIN_COST[i].AMOUNT/1000000).toFixed(2));
    }
    for (var i in obj[0].COGS) {
        cogs.push((obj[0].COGS[i].AMOUNT/1000000).toFixed(2));
    }
     // Prepare Chart Start
     var config = {
        type: 'line',
        data: {
                datasets: [
                    {
                        label: 'HR COST',
                        data: hrCost,
                        backgroundColor: 'rgba(255, 99, 132, 0.2)',
                        borderWidth: 1
                    },
                    {
                        label: 'OPS COST',
                        data: opsCost,
                        backgroundColor: 'rgba(54, 162, 235, 0.2)',
                        borderWidth: 1
                    },
                    {
                        label: 'MKT COST',
                        data: mktCost,
                        backgroundColor: 'rgba(255, 125, 25, 0.4)',
                        borderWidth: 1
                    },
                    {
                        label: 'FIN COST',
                        data: finCost,
                        backgroundColor: 'rgba(54, 125, 25, 0.4)',
                        borderWidth: 1
                    },
                    {
                        label: 'COGS',
                        data: cogs,
                        backgroundColor: 'rgba(54, 99, 25, 0.2)',
                        borderWidth: 1
                    }
                ],
                labels:Year
            },
        options: {legend: {
        position: 'bottom'
    },
    scales: {
        yAxes: [{
            gridLines : {
                display : false
            },
            scaleLabel: {
            display: true,
            labelString: 'In Millions'
          }
        }],
        xAxes : [ {
            gridLines : {
                display : false
            }
        } ]
    }
    }
    };
   new Chart(document.getElementById(chartId).getContext('2d'), config);
    // Prepare Chart End
}
function chartGrossMargin(obj,chartId){
	var Year = [];
    var GrossMargin =[];
  
    for (var i in obj) {
        Year.push(obj[i].YEAR+''+obj[i].QUARTER);
        GrossMargin.push(obj[i].GROSS_MARGIN);
    }
     // Prepare Chart Start
     var config = {
        type: 'line',
        data: {
                datasets: [
                  {
                      label: 'Gross Margin',
                      data: GrossMargin,
                      backgroundColor: 'rgba(54, 162, 235, 0.2)',
                      borderWidth: 1
                  }
                ],
                labels:Year
            },
        options: {legend: {
        position: 'bottom'
    },
    scales: {
        yAxes: [{
            gridLines : {
                display : false
            },
            scaleLabel: {
            display: true,
            labelString: 'Gross Margin %'
          },
          ticks: {
                    suggestedMin: 0,
                    suggestedMax: 100
                }
        }],
        xAxes : [ {
            gridLines : {
                display : false
            }
        } ]
    }
    }
    };
    new Chart(document.getElementById(chartId).getContext('2d'), config);
    // Prepare Chart End
}