/**
 * @author leelavinodh
 */
var cardOpt = {
    legend: {
        position: 'bottom'
    },
    scales: {
        yAxes: [{
            gridLines : {
                display : false
            },
            scaleLabel: {
            display: true
            
          }
        }],
        xAxes : [ {
            gridLines : {
                display : false
            }
        } ]
    }
};

var bgColor = ['rgba(255, 99, 132, 0.2)',
				    'rgba(54, 162, 235, 0.2)',
				    'rgba(255, 206, 86, 0.2)',
				    'rgba(75, 192, 192, 0.2)',
				    'rgba(153, 102, 255, 0.2)',
				    'rgba(255, 159, 64, 0.2)'];
				    
var bdColor = ['rgba(255,99,132,1)',
                    'rgba(54, 162, 235, 1)',
                    'rgba(255, 206, 86, 1)',
                    'rgba(75, 192, 192, 1)',
                    'rgba(153, 102, 255, 1)',
                    'rgba(255, 159, 64, 1)'];
                    
function chartSales(obj){
	var objrev=obj.rev;
	var objcost=obj.cost;
	var Year = [];
    var rev = [];
    var cost =[];

    for (var i in objrev) {
        Year.push('Y'+objrev[i].Year+'Q'+objrev[i].Qtr);
        rev.push((objrev[i].Amount/1000000).toFixed(2));
    }
    for (var i in objcost) {
        cost.push((objcost[i].Amount/1000000).toFixed(2));
    }
     // Prepare Chart Start
     var config = {
        type: 'line',
        data: {
                datasets: [
                  {
                      label: 'Revenue',
                      data: rev,
                      backgroundColor: 'rgba(255, 99, 132, 0.2)',
                      borderWidth: 1
                  },
                  {
                      label: 'Cost',
                      data: cost,
                      backgroundColor: 'rgba(54, 162, 235, 0.2)',
                      borderWidth: 1
                  }
                ],
                labels:Year
            },
        
    options:  {legend: {
        position: 'bottom'
    },
    scales: {
        yAxes: [{
            gridLines : {
                display : false
            },
            scaleLabel: {
            display: true,
            labelString: 'In Millions'
          }
        }],
        xAxes : [ {
            gridLines : {
                display : false
            }
        } ]
    }
    }
    };
    var patChart = document.getElementById("revChart").getContext('2d');
    patChart = new Chart(patChart, config);       
    // Prepare Chart End
}
function chartProd(obj){
	var objAllocat=obj.Allocat;
	var objSold=obj.Sold;
	var Year = [];
    var Allocat = [];
    var Sold =[];
  
    for (var i in objAllocat) {
        Year.push('Y'+objAllocat[i].Year+'Q'+objAllocat[i].Qtr);
        Allocat.push((objAllocat[i].PRODUCTS));
    }
    for (var i in objSold) {
        Sold.push((objSold[i].PRODUCTS));
    }
     // Prepare Chart Start
     var config = {
        type: 'line',
        data: {
                datasets: [
                  {
                      label: 'Allocated',
                      data: Allocat,
                      backgroundColor: 'rgba(255, 99, 132, 0.2)',
                      borderWidth: 1
                  },
                  {
                      label: 'Sold',
                      data: Sold,
                      backgroundColor: 'rgba(54, 162, 235, 0.2)',
                      borderWidth: 1
                  }
                ],
                labels:Year
            },
        options: {legend: {
        position: 'bottom'
    },
    scales: {
        yAxes: [{
            gridLines : {
                display : false
            },
            scaleLabel: {
            display: true,
            labelString: 'No. of Products'
          }
        }],
        xAxes : [ {
            gridLines : {
                display : false
            }
        } ]
    }
    }
    };
    var patChart = document.getElementById("salesChart").getContext('2d');
    patChart = new Chart(patChart, config);       
    // Prepare Chart End
}
function chartMode(obj){
	var objAwarenessScore=obj.AwarenessScore;
	var MODE = [];
    var AwarenessScore = [];
     var coloR = [];

         var dynamicColors = function() {
            var r = Math.floor(Math.random() * 255);
            var g = Math.floor(Math.random() * 255);
            var b = Math.floor(Math.random() * 255);
            return "rgb(" + r + "," + g + "," + b + ")";
         };

         
    for (var i in objAwarenessScore) {
        MODE.push(objAwarenessScore[i].MODE);
        AwarenessScore.push((objAwarenessScore[i].SCORE));
        coloR.push(dynamicColors());
    }
     // Prepare Chart Start
     var config = {
        type: 'pie',
        data: {
                datasets: [
                  {
                  	  label: 'MODE',
                      data: AwarenessScore,
                      backgroundColor: coloR,
                      borderWidth: 1
                  }
                ],
                labels:MODE
           },
           options:{legend: {
        position: 'bottom'
    		}
    }
    };
    var patChart = document.getElementById("modeChart").getContext('2d');
    patChart = new Chart(patChart, config);       
    // Prepare Chart End
}

