<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$route['default_controller'] = 'Login';
// $route['default_controller'] = 'forgot';
$route['404_override'] = '';
$route['translate_uri_dashes'] = FALSE;

//Login
$route['myaccount'] = 'Login/myaccount';
$route['about-us'] = 'Login/aboutus';
$route['contact-us'] = 'Login/contactus';
$route['blog'] = 'Login/blogs';
$route['blog-details/(:any)'] = 'Login/blogDescription/$1';
$route['user-profile'] = 'Login/userProfile';
$route['change-password'] = 'Login/changePwdView';
$route['sign-out'] = 'Login/logout';
$route['edit-profile'] = 'Login/userProfileEditDisplay';

//CourseDescription 
$route['game-details/(:any)'] = 'CourseDescription/gameDtls/$1';

//Competition
$route['competition'] = 'Competition/index';
$route['competition-details/(:any)'] = 'Competition/main/$1';
$route['competition-details/(:any)/(:any)'] = 'Competition/main/$1/$2';

//webgames
$route['games/(:any)'] = 'game/main/index/$1';

//Dashboard
$route['dashboard/(:any)/(:any)/(:any)'] = 'Dashboard/dhistory/$1/$2/$3';
$route['profile-report/(:any)/(:any)/(:any)/(:any)'] = 'Dashboard/profilereport/$1/$2/$3/$4';
$route['universe-leaderboard/(:any)'] = 'Dashboard/universeleaderboard/$1';
$route['leaderboard/(:any)'] = 'DashboardKeyMetrics/universeleaderboard/$1';
$route['overallPerformance/(:any)/(:any)'] = 'DashboardKeyMetrics/overAllPerformance/$1/$2';
$route['salesSnap/(:any)/(:any)'] = 'DashboardKeyMetrics/competitorAndSalesSnapshot/$1/$2';

//Mission
$route['mission/(:any)'] = 'DashboardKeyMetrics/missionInFullPageView/$1';

//Manage_user_product
$route['modify-role'] = 'Manage_user_product/userRoleDisplay';
$route['modify-role/edit/(:any)/(:any)'] = 'Manage_user_product/userRoleEdit/$1/$2';
$route['modify-role/add/(:any)/(:any)/(:any)'] = 'Manage_user_product/userRoleAdd/$1/$2/$3';
$route['enquiry'] = 'Manage_user_product/getEnquiry';
$route['client-master'] = 'Manage_user_product/clientmstr';
$route['client-product-details/(:any)'] = 'Manage_user_product/clientprodmapping/$1';
$route['product-master'] = 'Manage_user_product/productmstr';
$route['users-registered'] = 'Manage_user_product/newUserRegister';
$route['usertype-client'] = 'Manage_user_product/userClient';

//Stratup
//Support
$route['support'] = 'stratup/support/index';
$route['support/add'] = 'stratup/support/add';
$route['support/view-details/(:any)'] = 'stratup/support/view/$1';

//Game_batch_tbl
$route['course-details'] = 'stratup/Game_batch_tbl/index';
$route['create-course'] = 'stratup/Game_batch_tbl/add';
$route['player-details/(:any)'] = 'stratup/game_batch_tbl/viewTeamInfo/$1';

//Validmodule
$route['finalize-universe'] = 'stratup/Validmodule/finalizeUniverse';
$route['edi-repeat'] = 'stratup/Validmodule/checkEdiRepeat';

//stratupxonline
$route['StratUpXOnline'] = 'CourseDescription/landingpage';

//userfeedbackForUniverse
$route['users-feedback'] = 'Manage_user_product/feedbackListForUniverse';

//usertutorailForUniverse
$route['users-tutorial-status'] = 'Manage_user_product/userTutorialStatusForUniverse';