<?php
class Competition extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->helper(array('form','url','html'));
        $this->load->library(array('session', 'form_validation'));
           $this->load->library('facebook');
           //$this->load->library('Curl');
        $this->load->database();
        $this->load->model('user_model');
        //unset($_SESSION['msg']); // Need to check if this line is required if the reset password are sent through mail.
    }
    
    public function index()
    {
        $this -> load -> model('Gamemasters_model');
        $data['occupationmstr'] = json_decode(json_encode($this -> Gamemasters_model -> getOccupationMstr()),true);
        $data['organisationmstr'] = json_decode(json_encode($this -> Gamemasters_model -> getUserOrganisationMstr()),true);
        $data['locationmstr'] = json_decode(json_encode($this -> Gamemasters_model -> getUserLocationMstr()),true);
        $data['campaignCateList'] = json_decode(json_encode($this -> Gamemasters_model -> getCampaignCategory()), true);
        $campDtls= $this -> Gamemasters_model -> getCampaignCateDtlsList();
        $temp='';
        $i=-1;
        // var_dump ($campDtls);
        // exit;
        foreach($campDtls as $c)
        {
            $t=$c->GAME_DETAIL_TITLE;
            if($temp!=$c->GAME_ID)
            {
                $i++;
                   
                $campDtlsList[$i]['Events']=$c->Events;
                $campDtlsList[$i]['GAME_ID']=$c->GAME_ID;
                $campDtlsList[$i]['GAME_TITLE']=$c->GAME_TITLE.'leela';
                $campDtlsList[$i]['GAME_DESC']=$c->GAME_DESC;
                $campDtlsList[$i]['GAME_LOGO_PATH']=$c->GAME_LOGO_PATH;
                if($c->GAME_DETAIL_TITLE=="Image")
                {
                    $campDtlsList[$i][$t]=$c->MEDIA_URL;
                }
                else 
                {
                    $campDtlsList[$i][$t]=$c->GAME_DETAIL_DESC;
                }
                    
                $temp=$c->GAME_ID;
            }
            else
            {
                if($c->GAME_DETAIL_TITLE=="Image")
                {
                    $campDtlsList[$i][$t]=$c->MEDIA_URL;
                }
                else 
                {
                    $campDtlsList[$i][$t]=$c->GAME_DETAIL_DESC;
                }
                    
                $temp=$c->GAME_ID;
            }
        }
        $data['campaignDetailList']=$campDtlsList;
        // to list all the ongoing and ended events
        $data['campaignList']= json_decode(json_encode($this -> Gamemasters_model -> getCampaignList()), true);
        $data['campaignDtlsList']= json_decode(json_encode($this -> Gamemasters_model -> getCampaignDtlsList()), true);
        $data['gameInfo'] = json_decode(json_encode($this -> Gamemasters_model -> getGameDetailsForGameId(34)), true);
        $data['_view'] = 'competition_list_display_view';
        $this->load->view('layouts/main_view', $data);
    }
    public function main($gameId,$PaidFormaxplayer = NULL)
    {        
        if(!empty($_GET["param"])) 
        {
            $param = $_GET["param"];   
        }
        $this -> load -> model('Gamemasters_model');
        
        $universeToken='';
        $leaderboard=array();
        $feedback=array();
        $data['gameId'] = $gameId;
        $data['campaignDtls'] = json_decode(json_encode($this -> Gamemasters_model -> getGameDetailsForGameId($gameId)), true);
        //dial_game_mstr
        $data['campaign'] = json_decode(json_encode($this -> Gamemasters_model -> getGameDescriptionForGameId($gameId)), true);
        
        $data['occupationmstr'] = json_decode(json_encode($this -> Gamemasters_model -> getOccupationMstr()),true);
        $data['organisationmstr'] = json_decode(json_encode($this -> Gamemasters_model -> getUserOrganisationMstr()),true);
        $data['locationmstr'] = json_decode(json_encode($this -> Gamemasters_model -> getUserLocationMstr()),true);
        
        foreach($data['campaignDtls'] as $row)
        {
            if($row['GAME_DETAIL_CODE']=='BATCHID')
            {
                $data['batchId'] = $row['GAME_DETAIL_DESC'];
            }
            else if($row['GAME_DETAIL_CODE']=='SIMULATION_TYPE')
            {
                $data['gameType'] = $row['GAME_DETAIL_TITLE'];
            }
            else if($row['GAME_DETAIL_CODE']=='SIMILARCAMPAIGN')
            {
                $data['similarGame']['GAME_ID'] = $row['GAME_DETAIL_DESC'];
                $data['similarGame']['IMAGE'] = $row['MEDIA_URL'];
            }
        }
           $checkUser=array();
        if($data['batchId']!='')
        {
            $this -> load -> model('Game_model');
            $gamebatchDtls=$this -> Game_model -> get_game_batch_tbl($data['batchId']);
            $universeToken=$gamebatchDtls['UNIVERSE_TOKEN'];
            $universeToken=str_replace(' ', '%20', $universeToken);
            $leaderboard=json_decode(json_encode($this->campaignleaderboardApi($universeToken)), true);
            //to get feedback for that universe
           // $feedback = json_decode(json_encode($this -> Gamemasters_model -> getRatingFormGameForUniverse($data['batchId'])), true);
          
             $userId = $this->session -> userdata('uid');
            $checkUser = $this-> Gamemasters_model -> checkUserinUniverse($data['batchId'],$userId);            
        }
        $feedback = json_decode(json_encode($this -> Gamemasters_model -> getTopTenFeedback($data['batchId'])), true);
        $data['leaderboard']=$leaderboard;
        $data['feedback']=$feedback;
        if(count($checkUser)>0)
        {
            $data['LeagueJoin_Status']=TRUE;
        }
        else 
        {$data['LeagueJoin_Status']=FALSE;
        	
        }
        $data['bannerDtls'] = array_values(array_filter($data['campaignDtls'], function ($var)  {
            return( ($var['GAME_DETAIL_CODE'] == 'BANNER'));
        }));
        
        $leagueDtls = array_values(array_filter($data['campaignDtls'], function ($var)  {
            return( ($var['GAME_DETAIL_CODE'] == 'LEAGUE'));
        }));
        //var_dump($leagueDtls);
        // if we have multiple leagues on this page this is required now only one league wil be there hence commented   
        $leaguecnt=0;
        foreach ($leagueDtls as  $row) 
        {
            if($row['GAME_DETAIL_TITLE']=='Title')
            {
                $leaguecnt++;
            }
        }
        $i=0;
        $seq=1;
        foreach($leagueDtls as $lea)
        {
            if($lea['SEQ_NO']== $seq)
            {
                $league[$seq][$i]=$lea;
                $i++;
            }
            else{
                $i=0;
                $seq++;
                $league[$seq][$i]=$lea;
                $i++;
            }
        }
        $temp='';
        $m=0;
        for($j=1;$j<=$leaguecnt;$j++)
        {
            foreach($league[$j] as $l)
            {
                if($temp!=$l['GAME_DETAIL_TITLE'])
                {
                    $t=$l['GAME_DETAIL_TITLE'];
                    if($l['GAME_DETAIL_TITLE']=="Image")
                    {
                        $finalleag[$m][$t]=$l['MEDIA_URL'];
                    }
                    else 
                    {
                        $finalleag[$m][$t]=$l['GAME_DETAIL_DESC'];
                    }
                    
                    $temp=$l['GAME_DETAIL_TITLE'];
                }
            }
            $m++;
        }
        $timezone = 330;
        $currdate=date("Y-m-d H:i:s");

        $timestampStart = strtotime($currdate) + ($timezone * 60);
        $currentDate = date("Y-m-d H:i:s", $timestampStart);
            //var_dump( $currentDate);
      //  date_default_timezone_set('Asia/Kolkata');

      //  $currdate=new DateTime();
      // $currentDate= date_format($currdate,'Y-m-d H:i:s');
       //$currentDate= $currdate;
       $this -> load -> model('Common_model');
      // $data['paymentDetails'] = array();
      
       if($this->session->userdata('login'))
       {
            $paymentDetails = $this -> Common_model ->getPaymentForGameIdandUserId($this->session->userdata('uid'), $gameId);
            if(count($paymentDetails)>0)
            {
                $data['paymentDetails'] = $paymentDetails;
                if($paymentDetails[0]['STATUS'] == 'success' && $PaidFormaxplayer == $paymentDetails[0]['SELECTED_MAX_PLAYER'])
                {
                    $data['PaidFormaxplayer'] = $PaidFormaxplayer;    
                } 
            }                               
       }
       //$data['PaidFormaxplayer'] = $PaidFormaxplayer;
        $data['currentDate']=$currentDate;
        $data['league']=$finalleag; 
        $data['universeToken']=$universeToken;
        
        $data['tutorialVideo']= $this -> Common_model ->get_Allvideo_list();
        $UserPCdtls = $this->getuserPCinfo();
        $UserPCOS = explode(' ',$UserPCdtls['os']);
        if($UserPCOS[0]=='Mac')
        {
            $data['downloadStratup']=json_decode(json_encode($this -> Gamemasters_model -> getDownloadlink(0,$UserPCOS[0])), true);
        }
        else
        {
            $data['downloadStratup']=json_decode(json_encode($this -> Gamemasters_model -> getDownloadlink(0,'Windows')), true);
        }
        $data['currentParticipants']=$this -> Gamemasters_model -> getCurrentParticipants($universeToken);
        $this -> load -> model('User_model');
        
        $userDtls = $this->User_model -> getUserDtls($this->session -> userdata('emailid'));
        foreach ($userDtls as  $row) 
        {
            $data['mobileNumber']=$row->MOBILE_NO;
        }

        // var_dump($data['mobileNumber']);
        $data['downloadStratup']=json_decode(json_encode($this -> Gamemasters_model -> getGameDetailsForGameId(0)), true);
        if(isset($data['similarGame']))
        {
            $data['_view'] = 'campaign_new_view';
        }
        else
        {
            $data['_view'] = 'competition_view';
        }        
        $this->load->view('layouts/main_view', $data);      
    }

    function tutorial()
    {
        $data['data'] = array();
        $this -> load -> model('Common_model');
        $data['data']= $this -> Common_model ->get_Allvideo_list();
        
        $data['_view'] = 'compet_tutorial_view';
        $this->load->view('layouts/main_view',$data);
    }
    function campinvitefriends($batchId,$maxplayer,$gameType)
    {
        // $datapassed['MAX_PLAYER']= $_POST['maxplayer'];
        // $datapassed['batchId']= $_POST['batchId'];
        // $datapassed['SIMULATION_TYPE']= $_POST['gameType'];
        $datapassed['MAX_PLAYER']= $maxplayer;
        $datapassed['batchId']= $batchId;
        $datapassed['SIMULATION_TYPE']= $gameType;
        $data=$this->load->view('camp_inviteplayer_view',$datapassed, TRUE);
        echo json_encode($data);
    }
    function campaignleaderboardApi($universeToken)
    {
        $this -> load -> library('rest', array('server' => straupAPIBaseURL . 'DiagnosticReportController/', 
                                                'http_user' => 'admin', 
                                                'http_pass' => '1234', 
                                                'http_auth' => 'digest' // or 'digest'
                                                )
                                );
         $leaderBoardDtls = $this -> rest -> get('getUniverseWiseLeaderBoard?universeToken='.$universeToken);
         return $leaderBoardDtls;
    }
    function campaignleaderboard($batchId)
    {
        $this -> load -> model('Game_model');
        $gamebatchDtls=$this -> Game_model -> get_game_batch_tbl($batchId);
        $universeToken=$gamebatchDtls['UNIVERSE_TOKEN'];
        
        $chartdata = $this->campaignleaderboardApi($universeToken);
        $lb = json_decode(json_encode($chartdata), true);
        
        $lb['data'] = $lb;
        $data = $this -> load -> view('leaderboard_view', $lb, TRUE);
        echo json_encode($data);
    }
    function getuserPCinfo()
    {
           $this->load->library('user_agent');

      $data['browser'] = $this->agent->browser();

      $data['browser_version'] = $this->agent->version();

      $data['os'] = $this->agent->platform();

      $data['ip_address'] = $this->input->ip_address();
      
      return $data;
    }
   
}