<?php
include (APPPATH . 'libraries/CommonUtilities.php');
class DashboardKeyMetrics extends CommonUtilities
{
    function __construct()
    {
        parent::__construct();
        $this -> load -> helper(array(
            'url',
            'html'
        ));
        $this -> load -> library('session');
        $this -> load -> model('Game_model');
        $this -> load -> model('Mylearning_model');
        header('Access-Control-Allow-Origin: *');
        // if (!$this -> session -> userdata('login'))
        // {
        //     redirect('login');
        // }
    }

    function index()
    {
        if (strtolower($this -> session -> userdata('utype')) != 'admin')
        {
            redirect('myaccount');
        }
        else
        {
            redirect('course-details');
        }

    }

    function overAllPerformance($universeToken, $teamId)
    {
        $convertionType = implode(" ", $this->input->post());
        if(count($_POST)==0 )
        {
            $convertionType=1;
        }
        // $universeToken=
        $lb = $this -> leaderboardApi($universeToken);
        $lb = json_decode(json_encode($lb), true);
        // echo $this->rest->debug();

        // REFERENCE URL FOR How to filter a two dimensional array by value :
        // https://stackoverflow.com/questions/27447923/how-to-filter-a-two-dimensional-array-by-value
        $filterBy1 = '1';
        // Rank 1
        $filterBy2 = $teamId;

        $marketLeader = array_filter($lb, function($var) use ($filterBy1, $filterBy2)
        {
            return ($var['CURRENT_RANK'] == $filterBy1 || $var['TEAM_ID'] == $filterBy2);
        });
        // fetch game id based on Team id (My Company)
        $this -> load -> model('Gamemasters_model');
        $teamDtls = $this -> Gamemasters_model -> getTeamDtlsForTeamId($teamId);
        $gameId = $teamDtls[0]['GAME_ID'];

        // fetch game id and team id for market leader (Rank 1)
        $marketLeaderGameId = $marketLeader[0]['GAME_ID'];
        $marketLeaderTeamId = $marketLeader[0]['TEAM_ID'];

        $keyMetricMyCompany = $this -> keyMetric($teamId, $gameId);
        $keyMetricMarketLeader = $this -> keyMetric($marketLeaderTeamId, $marketLeaderGameId);

        // var_dump($keyMetricMyCompany);

        $data['leaderboard'] = $marketLeader;
        // leaderboard data only with market leader and team filtered for
        // leaderboard view
        $data['universetoken'] = $universeToken;
        $data['teamId'] = $teamId;
        // data for universe leaderboard view

        $data['keyMetric'] = array(
            "myCompany" => $keyMetricMyCompany,
            "marketLeader" => $keyMetricMarketLeader
        );
        $data['type'] = $convertionType;
        $data['conversionMethod'] = $this; // to get library file in view which is an extension of this file
       // $data['mission'] = $this->mission($universeToken);
        // $data['leaderboardview'] = 'dept_dashboard/overall_performance/universe_leaderboard_view';
        // $data['keyMetricview'] = 'dept_dashboard/overall_performance/key_metrics_view';
        // $data['keyMetrictrendview'] = 'dept_dashboard/overall_performance/key_metrics_trend_view';
        // $data['missionsideview'] = 'dept_dashboard/overall_performance/mission_in_side_view';
        $data['_view'] = 'dept_dashboard/overall_performance/overall_template_view';
        $this -> load -> view('layouts/main_view', $data);

        // $this -> load ->
        // view('dept_dashboard/overall_performance/key_metrics_trend_view',
        // $data);

    }

    function keyMetric($teamId, $gameId)
    {
        $mktInfo = $this -> mktDashboardDetails('MKT', $teamId, $gameId);
        $opsInfo = $this -> opsDashboardDetails('OPS', $teamId, $gameId);
        $hrInfo = $this -> hrDashboardDetails('HR', $teamId, $gameId);
        $finInfo = $this -> finDashboardDetails('FIN', $teamId, $gameId);

        //Key Operational Metrics
        $keyMetric['opsProductionRequest'] = $opsInfo['opsProductAllocated'];
        $keyMetric['opsProductsProduced'] = $opsInfo['opsProductProduced'];
        $keyMetric['mktProductsAllocated'] = $mktInfo['mktProductAllocat'];
        $keyMetric['mktProductsSold'] = $mktInfo['mktProductSold'];
        $keyMetric['mktRevenue'] = $mktInfo['totalrev'];

        // Key Efficiency Metrics
        $keyMetric['opsProductionEffciency'] = $opsInfo['opsProductEfficiency'];
        $keyMetric['opsCapacityUtilisation'] = $opsInfo['capUtilized'];
        $keyMetric['mktSalesEfficiency'] = $mktInfo['mktSalesEfficency'];
        $keyMetric['hrRecruitmentEfficiency'] = $hrInfo['hrRecruitEfficiency'];
        $keyMetric['hrAttritionPercentage'] = $hrInfo['hrAttritionPercent'];
        // $keyEfficiencyMetrics['finDebtVsEquityRatio'] =
        // $finInfo['opsProductProduced'];

        $keyMetric['plStatement'] = $finInfo;
        $keyMetric['finHealthTrend'] = $finInfo['finHealthData'];
        $keyMetric['finHealthCostTrend'] = $finInfo['finHealthCostData'];
        $keyMetric['grossMarginTrend'] = $finInfo['grossMarginData'];

        $keyMetric['opsProductAllocatedAndProducedTrend'] = $opsInfo['opsProductAllocatedAndProducedTrend'];
        $keyMetric['mktProductAllocatedTrend'] = $mktInfo['Allocat'];
        $keyMetric['mktProductSalesTrend'] = $mktInfo['Sold'];

        $keyMetric['attritionPercentageTrend'] = $hrInfo['attritionPercentageQtrWise'];
        $keyMetric['recruitmentEfficiencyTrend'] = $hrInfo['recruitmentEfficiencyQtrWise'];

        return ($keyMetric);
        // var_dump($keyMetric);

        // $data['mktInfo'] = json_encode($mktInfo);
        // $data['opsInfo'] = json_encode($opsInfo);
        // $data['hrInfo'] = json_encode($hrInfo);
        // $data['finInfo'] = json_encode($finInfo);
        //
        // $data['_view'] = 'dept_dashboard/overall_template_view';
        // $this -> load -> view('layouts/main_view', $data);

    }

    function mktDashboardDetails($dept, $teamId, $gameId)
    {
        $convertionType = 2;
        $qtrStatus = $this -> Game_model -> getQtrStatus($gameId);
        $this -> load -> library('rest', array(
            'server' => straupAPIBaseURL,
            'http_user' => 'admin',
            'http_pass' => '1234',
            'http_auth' => 'digest' // or 'digest'
        ));

        $this -> load -> model('Dashboard_model');
        $mktCostFilter = array(
            'MKT - ADVERTISEMENT COST',
            'MKT - AFTER SALES COST',
            'MKT - DISTRIBUTION SETUP COST',
            'MKT - DISTRIBUTION SUPPORT COST',
            'MKT - DISTRIBUTION TRAINING COST',
            'MKT - FEATURE CATEGORY COST',
            'MKT - MARGIN COST',
            'MKT - SALES FORCE INCENTIVE',
            'MKT - TRANSPORTATION COST',
            'MKT - WARRENTY COST',
            'Advertisement Cost'
        );
        $mktRevFilter = array(
            'SALES REVENUE',
            'SALES REVENUE - COST'
        );
        $mktSalaryFilter = array('MKT RECRUITMENT COST');

        // $mktCostDtls = $this -> Dashboard_model ->
        // qtrwiseIncomeAndExpenseByTrans($mktCostFilter, $teamId);
        $mktRevDtls = $this -> Dashboard_model -> qtrwiseIncomeAndExpenseByTrans($mktRevFilter, $teamId);
        // $mktProductAllocList = $this -> Dashboard_model ->
        // mktproductAllocatedList($teamId);
        $mktProductAllocated = $this -> Dashboard_model -> mktproductAllocated($teamId);
        $mktProductSold = $this -> Dashboard_model -> productSold($teamId);
        if ($mktProductAllocated[0]['PRODUCTS_ALLOTED'] > 0)
        {
            $mktSalesEfficency = round(($mktProductSold[0]['PRODUCTS_SOLD'] / $mktProductAllocated[0]['PRODUCTS_ALLOTED']) * 100);
        }
        else
        {
            $mktSalesEfficency = 0;

        }

        // $mktProdAllocatSoldProdWise = $this -> Dashboard_model ->
        // mktProdAllocatandSoldProdwise($teamId, $gameId);
        // $mktAwareAdvertise = $this -> Dashboard_model ->
        // awarenessandAdvertise($teamId);
        // $mktDistributionCost = $this -> Dashboard_model ->
        // distributionCost($teamId);
        // $mktSalaryCost = $this -> Dashboard_model -> BudgetDetails($teamId,
        // $gameId, $mktSalaryFilter);
        $mktProdAllocatQtr = $this -> Dashboard_model -> mktProdAllocatQtrwise($teamId);
        $mktProdSoldQtr = $this -> Dashboard_model -> mktProdSoldQtrwise($teamId);
        // $AwarenessScore = $this -> rest ->
        // get('/DiagnosticReportController/getModeWiseAwarenessScore?teamId=' .
        // $teamId . '&gameId=' . $gameId);
        // $mktAwarenessScore = json_decode(json_encode($AwarenessScore), true);
        // $productMstrName = $this -> Dashboard_model ->
        // getProductNameFromgameMstr($gameId);
        // $mylearning = $this->Dashboard_model->mylearninglist($teamId);
        // echo $mktAwarenessScore;
        $TotalMktCost = 0;
        $TotalMktRev = 0;
        $mktCostChartData = array();
        $mktRevChartData = array();
        $mktProdAllocatChartData = array();
        $mktProdSoldChartData = array();
        $mktAwarenessChartData = array();
        $key = 0;

        // foreach ($mktCostDtls as $row)
        // {
        // $TotalMktCost += $row['Amount'];
        // if ($row['Year'] != 0)
        // {
        // $key = 'Y' . $row['Year'] . 'Q' . $row['Qtr'];
        // if (!array_key_exists($key, $mktCostChartData))
        // {
        // $mktCostChartData[$key] = array(
        // 'Year' => $row['Year'],
        // 'Qtr' => $row['Qtr'],
        // 'Amount' => $row['Amount'],
        // );
        // }
        // else
        // {
        // $mktCostChartData[$key]['Amount'] = $mktCostChartData[$key]['Amount']
        // + $row['Amount'];
        // }
        // }
        // }
        foreach ($mktRevDtls as $row)
        {
            $TotalMktRev += $row['Amount'];
            if ($row['Year'] != 0)
            {
                $key = 'Y' . $row['Year'] . 'Q' . $row['Qtr'];
                if (!array_key_exists($key, $mktRevChartData))
                {
                    $mktRevChartData[$key] = array(
                        'Year' => $row['Year'],
                        'Qtr' => $row['Qtr'],
                        'Amount' => $row['Amount'],
                    );
                }
                else
                {
                    $mktRevChartData[$key]['Amount'] = $mktRevChartData[$key]['Amount'] + $row['Amount'];
                }
            }
        }
        foreach ($mktProdAllocatQtr as $row)
        {
            $key = 'Y' . $row['Year'] . 'Q' . $row['Qtr'];
            if (!array_key_exists($key, $mktProdAllocatChartData))
            {
                $mktProdAllocatChartData[$key] = array(
                    'Year' => $row['Year'],
                    'Qtr' => $row['Qtr'],
                    'PRODUCTS' => $row['PRODUCTS_ALLOTED'],
                );
            }
            else
            {
                $mktProdAllocatChartData[$key]['PRODUCTS'] = $mktProdAllocatChartData[$key]['PRODUCTS'] + $row['PRODUCTS_ALLOTED'];
            }
        }
        foreach ($mktProdSoldQtr as $row)
        {
            $key = 'Y' . $row['Year'] . 'Q' . $row['Qtr'];
            if (!array_key_exists($key, $mktProdSoldChartData))
            {
                $mktProdSoldChartData[$key] = array(
                    'Year' => $row['Year'],
                    'Qtr' => $row['Qtr'],
                    'PRODUCTS' => $row['PRODUCTS_SOLD'],
                );
            }
            else
            {
                $mktProdSoldChartData[$key]['PRODUCTS'] = $mktProdSoldChartData[$key]['PRODUCTS'] + $row['PRODUCTS_SOLD'];
            }
        }

        // foreach ($mktAwarenessScore as $row)
        // {
        // $key = $row['ADVERTISEMENT_MODE_NAME'];
        // if (!array_key_exists($key, $mktAwarenessChartData))
        // {
        // $mktAwarenessChartData[$key] = array(
        // 'MODE' => $row['ADVERTISEMENT_MODE_NAME'],
        // 'SCORE' => $row['AWARNESS_CREATED']
        // );
        // }
        // else
        // {
        // $mktAwarenessChartData[$key]['SCORE'] =
        // $mktAwarenessChartData[$key]['SCORE'] + $row['AWARNESS_CREATED'];
        // }
        // }

        $mktDetailsForDashboard = array(
            // "rev" => $mktRevChartData,
            // "cost" => $mktCostChartData,
            "Allocat" => $mktProdAllocatChartData,
            "Sold" => $mktProdSoldChartData,
            // "AwarenessScore" => $mktAwarenessChartData,
            "totalrev" => $TotalMktRev,
            // "totalmktcost" => $this -> convertToSmallNum($TotalMktCost,
            // $convertionType),
            // "mktProductAllocList" => $mktProductAllocList,
            "mktProductAllocat" => $mktProductAllocated[0]['PRODUCTS_ALLOTED'],
            "mktProductSold" => $mktProductSold[0]['PRODUCTS_SOLD'],
            "mktSalesEfficency" => $mktSalesEfficency,
            // "Dept" => $dept,
            // "mktProduct1Allocated" =>
            // $mktProdAllocatSoldProdWise[0]['PRODUCTS_ALLOCATED'],
            // "mktProduct2Allocated" =>
            // $mktProdAllocatSoldProdWise[1]['PRODUCTS_ALLOCATED'],
            // "mktProduct3Allocated" =>
            // $mktProdAllocatSoldProdWise[2]['PRODUCTS_ALLOCATED'],
            // "mktProduct4Allocated" =>
            // $mktProdAllocatSoldProdWise[3]['PRODUCTS_ALLOCATED'],
            // "mktProduct1Sold" =>
            // $mktProdAllocatSoldProdWise[0]['PRODUCTS_SOLD'],
            // "mktProduct2Sold" =>
            // $mktProdAllocatSoldProdWise[1]['PRODUCTS_SOLD'],
            // "mktProduct3Sold" =>
            // $mktProdAllocatSoldProdWise[2]['PRODUCTS_SOLD'],
            // "mktProduct4Sold" =>
            // $mktProdAllocatSoldProdWise[3]['PRODUCTS_SOLD'],
            // "mktAwarenessScore" => $mktAwareAdvertise[0]['AWARNESS_SCORE'],
            // "mktAdvertiseCost" => $this ->
            // convertToSmallNum($mktAwareAdvertise[0]['ADVERTISEMENT_COST'],
            // $convertionType),
            // "mktDistributionCost" => $this ->
            // convertToSmallNum($mktDistributionCost[0]['MARGIN_COST'],
            // $convertionType),
            // "mktSalaryCost" => $this ->
            // convertToSmallNum($mktSalaryCost[0]['AMOUNT'], $convertionType),
            "qtrstatus" => $qtrStatus,
            // "teamId" => $teamId,
            // "gameId" => $gameId,
            // "product" => $productMstrName
        );
        return ($mktDetailsForDashboard);

        // $data['chartdata'] = json_encode($mktDetailsForDashboard);
        // $data['_view'] = 'dept_dashboard/overall_view';
        // $this -> load -> view('layouts/main_view', $data);
    }

    function opsDashboardDetails($dept, $teamId, $gameId)
    {
        $convertionType = 2;
        $this -> load -> library('rest', array(
            'server' => straupAPIBaseURL,
            'http_user' => 'admin',
            'http_pass' => '1234',
            'http_auth' => 'digest' // or 'digest'
        ));

        $qtrStatus = $this -> Game_model -> getQtrStatus($gameId);

        $this -> load -> model('Dashboard_model');

        // $opsCostDtls = $this -> Dashboard_model ->
        // qtrwiseIncomeAndExpenseByTrans($opsCostFilter, $teamId);
        $opsProductProduction = $this -> Dashboard_model -> productProduction($teamId);
        // $opsProdwiseProduced = $this -> Dashboard_model ->
        // productWiseAllocatedProduced($teamId, $gameId);
        // $ProductInventory = $this -> Dashboard_model ->
        // productsInventory($teamId);
        // $opsSalaryCost = $this -> Dashboard_model -> BudgetDetails($teamId,
        // $gameId, $OpsSalaryFilter);
        // $opsProductAllocList = $this -> Dashboard_model ->
        // opsproductAllocatedList($teamId);
        // $opsPurchList = $this -> Dashboard_model -> opsPurchaseList($teamId);
        // $RawMaterial = $this -> Dashboard_model -> BudgetDetails($teamId,
        // $gameId, $RawMaterialFilter);
        // $ClosingRawMaterial = $this -> Dashboard_model ->
        // BudgetDetails($teamId, $gameId, $ClosingRawMaterialFilter);
        // $ProductionCost = $this -> Dashboard_model -> BudgetDetails($teamId,
        // $gameId, $opsProductionFilter);
        $ProductionQtr = $this -> Dashboard_model -> productProductionQtrwise($teamId);
        //
        // $productMstrName = $this -> Dashboard_model ->
        // getProductNameFromgameMstr($gameId);
        //
        // $productName1 = $productMstrName[0]['PRODUCT_DESC'];
        // $productName1 = str_replace(' ', '%20', $productName1);
        // $productName2 = $productMstrName[1]['PRODUCT_DESC'];
        // $productName2 = str_replace(' ', '%20', $productName2);
        // $productName3 = $productMstrName[2]['PRODUCT_DESC'];
        // $productName3 = str_replace(' ', '%20', $productName3);
        // $productName4 = $productMstrName[3]['PRODUCT_DESC'];
        // $productName4 = str_replace(' ', '%20', $productName4);
        //
        // $Cogsbreakupprod1 = $this -> rest ->
        // get('/DiagnosticReportController/getCogsBreakUp?teamId=' . $teamId .
        // '&gameId=' . $gameId . '&productName=' . $productName1);
        // $opsCogsbreakupprod1 = json_decode(json_encode($Cogsbreakupprod1),
        // true);
        // $Cogsbreakupprod2 = $this -> rest ->
        // get('/DiagnosticReportController/getCogsBreakUp?teamId=' . $teamId .
        // '&gameId=' . $gameId . '&productName=' . $productName2);
        // $opsCogsbreakupprod2 = json_decode(json_encode($Cogsbreakupprod2),
        // true);
        // $Cogsbreakupprod3 = $this -> rest ->
        // get('/DiagnosticReportController/getCogsBreakUp?teamId=' . $teamId .
        // '&gameId=' . $gameId . '&productName=' . $productName3);
        // $opsCogsbreakupprod3 = json_decode(json_encode($Cogsbreakupprod3),
        // true);
        // $Cogsbreakupprod4 = $this -> rest ->
        // get('/DiagnosticReportController/getCogsBreakUp?teamId=' . $teamId .
        // '&gameId=' . $gameId . '&productName=' . $productName4);
        // $opsCogsbreakupprod4 = json_decode(json_encode($Cogsbreakupprod4),
        // true);
        //
        // $unitcostPriceprod1 = $this -> rest ->
        // get('/DiagnosticReportController/getUnitCostvsRevenuePrice?teamId=' .
        // $teamId . '&gameId=' . $gameId . '&productName=' . $productName1);
        // $unitcostandPriceprod1 = json_decode(json_encode($unitcostPriceprod1),
        // true);
        // $unitcostPriceprod2 = $this -> rest ->
        // get('/DiagnosticReportController/getUnitCostvsRevenuePrice?teamId=' .
        // $teamId . '&gameId=' . $gameId . '&productName=' . $productName2);
        // $unitcostandPriceprod2 = json_decode(json_encode($unitcostPriceprod2),
        // true);
        // $unitcostPriceprod3 = $this -> rest ->
        // get('/DiagnosticReportController/getUnitCostvsRevenuePrice?teamId=' .
        // $teamId . '&gameId=' . $gameId . '&productName=' . $productName3);
        // $unitcostandPriceprod3 = json_decode(json_encode($unitcostPriceprod3),
        // true);
        // $unitcostPriceprod4 = $this -> rest ->
        // get('/DiagnosticReportController/getUnitCostvsRevenuePrice?teamId=' .
        // $teamId . '&gameId=' . $gameId . '&productName=' . $productName4);
        // $unitcostandPriceprod4 = json_decode(json_encode($unitcostPriceprod4),
        // true);
        //
        // $rejectionReasonprod1 = $this -> rest ->
        // get('/DiagnosticReportController/reasonForRejectionNew?teamId=' .
        // $teamId . '&gameId=' . $gameId . '&productName=' . $productName1);
        // $rejectionprod1 = json_decode(json_encode($rejectionReasonprod1),
        // true);
        // $rejectionReasonprod2 = $this -> rest ->
        // get('/DiagnosticReportController/reasonForRejectionNew?teamId=' .
        // $teamId . '&gameId=' . $gameId . '&productName=' . $productName2);
        // $rejectionprod2 = json_decode(json_encode($rejectionReasonprod2),
        // true);
        // $rejectionReasonprod3 = $this -> rest ->
        // get('/DiagnosticReportController/reasonForRejectionNew?teamId=' .
        // $teamId . '&gameId=' . $gameId . '&productName=' . $productName3);
        // $rejectionprod3 = json_decode(json_encode($rejectionReasonprod3),
        // true);
        // $rejectionReasonprod4 = $this -> rest ->
        // get('/DiagnosticReportController/reasonForRejectionNew?teamId=' .
        // $teamId . '&gameId=' . $gameId . '&productName=' . $productName4);
        // $rejectionprod4 = json_decode(json_encode($rejectionReasonprod4),
        // true);
        //
        // $unitdata = $this -> rest ->
        // get('/DiagnosticReportController/getUnitCostDtlsForGame?teamId=' .
        // $teamId . '&gameId=' . $gameId);
        // $unit = json_decode(json_encode($unitdata), true);
        // $gamePlayedyear = $this -> Dashboard_model ->
        // NoofYearsPlayed($gameId);
        $CapUtilizeData = $this -> rest -> get('/DiagnosticReportController/getAvgCapacity?teamId=' . $teamId);
        $CapUtilize = json_decode(json_encode($CapUtilizeData), true);
        // //$mylearning = $this->Dashboard_model->mylearninglist($teamId);
        // //print_r($CapUtilize);
        // $TotalOpsCost = 0;
        // $TotalOpsProductionCost = 0;
        // $TotalUnitCost = 0;
        // $unitcost = array();
        $opsAllocatChartData = array();
        // $unitcostChartData = array();
        // $key = 0;
        //
        $AvgCapUtilized = Ceil(array_sum(array_column($CapUtilize, 'Capacity_utilized')) / count($CapUtilize));
        //
        // for ($i = 1; $i <= 5; $i++)
        // {
        // $filterBy = $i;
        // $year = array_values(array_filter($unit, function($var) use
        // ($filterBy)
        // {
        // return (($var['YEAR'] == $filterBy));
        // }));
        //
        // $unitcost[$i] = array_sum(array_column($year, 'VALUE'));
        // }
        // if ($gamePlayedyear[0]['Year'] > 0)
        // {
        // $TotalUnitCost = array_sum($unitcost) / $gamePlayedyear[0]['Year'];
        // }
        // else
        // {
        // $TotalUnitCost = 0;
        // }
        //
        // // print_r($TotalUnitCost);
        foreach ($ProductionQtr as $row)
        {

            $key = 'Y' . $row['Year'] . 'Q' . $row['Qtr'];
            if (!array_key_exists($key, $opsAllocatChartData))
            {
                $opsAllocatChartData[$key] = array(
                    'Year' => $row['Year'],
                    'Qtr' => $row['Qtr'],
                    'ProdAllocat' => $row['PRODUCTS_ALLOCATED'],
                    'ProdSold' => $row['PRODUCTS_PRODUCED'],
                );
            }
            else
            {
                $opsAllocatChartData[$key]['ProdAllocat'] = $opsAllocatChartData[$key]['ProdAllocat'] + $row['PRODUCTS_ALLOCATED'];
                $opsAllocatChartData[$key]['ProdSold'] = $opsAllocatChartData[$key]['ProdSold'] + $row['PRODUCTS_PRODUCED'];
            }
        }
        //
        // $rawMaterialInventory = $RawMaterial[0]['AMOUNT'] -
        // $ClosingRawMaterial[0]['AMOUNT'];
        // $costofGoodsSold = $rawMaterialInventory + $opsSalaryCost[0]['AMOUNT']
        // + $ProductionCost[0]['AMOUNT'];

        // $new = array(
        // "opsProductAllocated" => $this ->
        // convertToSmallNum($opsProductProduction[0]['PRODUCTS_ALLOCATED'],
        // $convertionType),
        // "opsProductProduced" => $this ->
        // convertToSmallNum($opsProductProduction[0]['PRODUCTS_PRODUCED'],
        // $convertionType),
        // "opsProductEfficiency" =>
        // $opsProductProduction[0]['PRODUCTION_EFFICIENCY'],
        // "capUtilized" => $AvgCapUtilized
        // );
        $new = array(
            "opsProductAllocatedAndProducedTrend" => $opsAllocatChartData,
            "opsProductAllocated" => $opsProductProduction[0]['PRODUCTS_ALLOCATED'],
            "opsProductProduced" => $opsProductProduction[0]['PRODUCTS_PRODUCED'],
            "opsProductEfficiency" => $opsProductProduction[0]['PRODUCTION_EFFICIENCY'],
            "capUtilized" => $AvgCapUtilized
        );
        return ($new);
        // var_dump($new);
        // $data['chartdata'] = json_encode($new);
        //
        // $data['_view'] = 'dept_dashboard/ops_view';
        // $this -> load -> view('layouts/main_view', $data);

    }

    function hrDashboardDetails($dept, $teamId, $gameId)
    {
        $convertionType = 2;
        $this -> load -> library('rest', array(
            'server' => straupAPIBaseURL,
            'http_user' => 'admin',
            'http_pass' => '1234',
            'http_auth' => 'digest' // or 'digest'
        ));

        $qtrStatus = $this -> Game_model -> getQtrStatus($gameId);

        $this -> load -> model('Dashboard_model');
        $hrTrainingCostFilter = array('HR TRAINING COST');
        $hrWelfareCostFilter = array('WELLFARE PROGRAM COST');
        $hrAcquisitionCostFilter = array(
            'ACQUISITION COST',
            'MKT RECRUITMENT COST',
            'STG RECRUITMENT COST',
            'IT  RECRUITMENT COST',
            'HR RECRUITMENT COST',
            'FIN RECRUITMENT COST',
            'OPS RECRUITMENT COST'
        );
        $attritionPercentageQtrWise = array();
        $attritionPercentageQtrWiseDtls = $this -> Dashboard_model -> hrAttritionPercentageQtrWise($teamId);
        foreach ($attritionPercentageQtrWiseDtls as $row)
        {
            // loop through data and construct array key with YearQtr combination
            // for chart x axis label

            $key = 'Y' . $row['Year'] . 'Q' . $row['Qtr'];
            if (!array_key_exists($key, $attritionPercentageQtrWise))
            {
                $attritionPercentageQtrWise[$key] = array(
                    'Year' => $row['Year'],
                    'Qtr' => $row['Qtr'],
                    'AttritionPercentage' => $row['ATTRITION_PERCENTAGE']
                );
            }
            else
            {
                $attritionPercentageQtrWise[$key]['AttritionPercentage'] = $attritionPercentageQtrWise[$key]['AttritionPercentage'] + $row['ATTRITION_PERCENTAGE'];
            }
        }
        $recruitmentEfficiencyQtrWise = array();
        $recruitmentEfficiencyQtrWiseDtls = $this -> Dashboard_model -> hrRecruitmentEfficiencyQtrwise($teamId);
        foreach ($recruitmentEfficiencyQtrWiseDtls as $row)
        {
            // loop through data and construct array key with YearQtr combination
            // for chart x axis label

            $key = 'Y' . $row['Year'] . 'Q' . $row['Qtr'];
            if (!array_key_exists($key, $recruitmentEfficiencyQtrWise))
            {
                $recruitmentEfficiencyQtrWise[$key] = array(
                    'Year' => $row['Year'],
                    'Qtr' => $row['Qtr'],
                    'RecruitmentEfficiencyPercentage' => $row['RECRUITMENT_EFFICIENCY_PERCENT']
                );
            }
            else
            {
                $recruitmentEfficiencyQtrWise[$key]['RecruitmentEfficiencyPercentage'] = $recruitmentEfficiencyQtrWise[$key]['RecruitmentEfficiencyPercentage'] + $row['RECRUITMENT_EFFICIENCY_PERCENT'];
            }
        }

        $hrTotalAllocatvsAccept = $this -> Dashboard_model -> hrTotalAllocatvsAccept($teamId);
        $hrAttritionPer = $this -> Dashboard_model -> hrAttritionPercent($teamId);
        // $hrDesignWiseRecruit = $this -> Dashboard_model ->
        // hrDesignWiseRecruit($teamId, $gameId);
        // $hrDesignDeptWiseRecruit = $this -> Dashboard_model ->
        // hrDesignDeptWiseRecruit($teamId, $gameId);
        // $hrEmpGrowth = $this -> Dashboard_model -> hrEmpGrowthPer($teamId);
        // $hrTrainingCost = $this -> Dashboard_model -> BudgetDetails($teamId,
        // $gameId, $hrTrainingCostFilter);
        // $hrWelfareCost = $this -> Dashboard_model -> BudgetDetails($teamId,
        // $gameId, $hrWelfareCostFilter);
        // $hrAcquisitionCost = $this -> Dashboard_model ->
        // BudgetDetails($teamId, $gameId, $hrAcquisitionCostFilter);
        // $empPromotion = $this -> Dashboard_model -> empPromoted($teamId);
        // $hrDecisionList = $this -> Dashboard_model -> hrDecisionList($teamId);
        // $RevenueLoss = $this -> rest ->
        // get('/DiagnosticReportController/getRevenueLossDueToEmpNotAvailable?teamId='
        // . $teamId . '&gameId=' . $gameId);
        // $hrRevenueLoss = json_decode(json_encode($RevenueLoss), true);
        // $RecruitPlanvsAct = $this -> rest ->
        // get('/DiagnosticReportController/getrecruitPlanVsActualCount?teamId='
        // . $teamId . '&gameId=' . $gameId);
        // $hrRecruitPvsA = json_decode(json_encode($RecruitPlanvsAct), true);
        // //$mylearning = $this->Dashboard_model->mylearninglist($teamId);
        //
        // $RevenueLossChartData = array();
        // $RecruitPvsAChartData = array();
        // $EntryRecruitData = array();
        // $ManagerRecruitData = array();
        // $SrRecruitData = array();
        // $GrRecruitData = array();
        // $key = 0;
        //
        // $entry = array_values(array_filter($hrDesignDeptWiseRecruit,
        // function($var)
        // {
        // return (($var['DesignationName'] == 'ENTRY LEVEL'));
        // }));
        //
        // foreach ($entry as $row)
        // {
        // $key = $row['DepartmentName'];
        // if (!array_key_exists($key, $EntryRecruitData))
        // {
        // $EntryRecruitData[$key] = array(
        // 'DEPT' => $row['DepartmentName'],
        // 'ACCEPTED' => $row['NO_OF_PEOPLE_ACCEPTED']
        // );
        // }
        // else
        // {
        // $EntryRecruitData[$key]['ACCEPTED'] =
        // $EntryRecruitData[$key]['ACCEPTED'] + $row['NO_OF_PEOPLE_ACCEPTED'];
        // }
        // }
        // $manager = array_values(array_filter($hrDesignDeptWiseRecruit,
        // function($var)
        // {
        // return (($var['DesignationName'] == 'MANAGER'));
        // }));
        //
        // foreach ($manager as $row)
        // {
        // $key = $row['DepartmentName'];
        // if (!array_key_exists($key, $ManagerRecruitData))
        // {
        // $ManagerRecruitData[$key] = array(
        // 'DEPT' => $row['DepartmentName'],
        // 'ACCEPTED' => $row['NO_OF_PEOPLE_ACCEPTED']
        // );
        // }
        // else
        // {
        // $ManagerRecruitData[$key]['ACCEPTED'] =
        // $ManagerRecruitData[$key]['ACCEPTED'] + $row['NO_OF_PEOPLE_ACCEPTED'];
        // }
        // }
        // $srmanager = array_values(array_filter($hrDesignDeptWiseRecruit,
        // function($var)
        // {
        // return (($var['DesignationName'] == 'SENIOR MANAGER'));
        // }));
        //
        // foreach ($srmanager as $row)
        // {
        // $key = $row['DepartmentName'];
        // if (!array_key_exists($key, $SrRecruitData))
        // {
        // $SrRecruitData[$key] = array(
        // 'DEPT' => $row['DepartmentName'],
        // 'ACCEPTED' => $row['NO_OF_PEOPLE_ACCEPTED']
        // );
        // }
        // else
        // {
        // $SrRecruitData[$key]['ACCEPTED'] = $SrRecruitData[$key]['ACCEPTED'] +
        // $row['NO_OF_PEOPLE_ACCEPTED'];
        // }
        // }
        // $grmanager = array_values(array_filter($hrDesignDeptWiseRecruit,
        // function($var)
        // {
        // return (($var['DesignationName'] == 'GENERAL MANAGER'));
        // }));
        //
        // foreach ($grmanager as $row)
        // {
        // $key = $row['DepartmentName'];
        // if (!array_key_exists($key, $GrRecruitData))
        // {
        // $GrRecruitData[$key] = array(
        // 'DEPT' => $row['DepartmentName'],
        // 'ACCEPTED' => $row['NO_OF_PEOPLE_ACCEPTED']
        // );
        // }
        // else
        // {
        // $GrRecruitData[$key]['ACCEPTED'] = $GrRecruitData[$key]['ACCEPTED'] +
        // $row['NO_OF_PEOPLE_ACCEPTED'];
        // }
        // }
        // foreach ($hrRevenueLoss as $row)
        // {
        //
        // $key = 'Y' . $row['YEAR'] . 'Q' . $row['QUARTER'];
        // if (!array_key_exists($key, $RevenueLossChartData))
        // {
        // $RevenueLossChartData[$key] = array(
        // 'Year' => $row['YEAR'],
        // 'Qtr' => $row['QUARTER'],
        // 'Revenue' => $row['REVENUE_LOSS'],
        // );
        // }
        // else
        // {
        // $RevenueLossChartData[$key]['Revenue'] =
        // $RevenueLossChartData[$key]['Revenue'] + $row['REVENUE_LOSS'];
        // }
        // }
        // foreach ($hrRecruitPvsA as $row)
        // {
        //
        // $key = 'Y' . $row['YEAR'];
        // if (!array_key_exists($key, $RecruitPvsAChartData))
        // {
        // $RecruitPvsAChartData[$key] = array(
        // 'Year' => $row['YEAR'],
        // 'Planned' => $row['PLANNED_COUNT'],
        // 'Recruited' => $row['RECRUITED_COUNT'],
        // );
        // }
        // else
        // {
        // $RecruitPvsAChartData[$key]['Planned'] =
        // $RecruitPvsAChartData[$key]['Planned'] + $row['PLANNED_COUNT'];
        // $RecruitPvsAChartData[$key]['Recruited'] =
        // $RecruitPvsAChartData[$key]['Recruited'] + $row['RECRUITED_COUNT'];
        // }
        // }

        $new = array(
            // "hrTotalIntended" =>
            // $hrTotalAllocatvsAccept[0]['NO_OF_EMPLOYEES_NEEDED'],
            // "hrTotalAccepted" =>
            // $hrTotalAllocatvsAccept[0]['NO_OF_PEOPLE_ACCEPTED'],
            "recruitmentEfficiencyQtrWise" => $recruitmentEfficiencyQtrWise,
            "attritionPercentageQtrWise" => $attritionPercentageQtrWise,
            "hrRecruitEfficiency" => $hrTotalAllocatvsAccept[0]['RECRUITMENT_EFFICIENCY_PERCENT'],
            "hrAttritionPercent" => $hrAttritionPer[0]['ATTRITION_PERCENT']
            // "hrReveneueLoss" => $RevenueLossChartData,
            // "RecruitPA" => $RecruitPvsAChartData,
            // "hrDecisionList" => $hrDecisionList,
            // "hrEntryAllocat" =>
            // $hrDesignWiseRecruit[0]['NO_OF_EMPLOYEES_NEEDED'],
            // "hrMangerAllocat" =>
            // $hrDesignWiseRecruit[1]['NO_OF_EMPLOYEES_NEEDED'],
            // "hrSrManAllocat" =>
            // $hrDesignWiseRecruit[2]['NO_OF_EMPLOYEES_NEEDED'],
            // "hrGrManAllocat" =>
            // $hrDesignWiseRecruit[3]['NO_OF_EMPLOYEES_NEEDED'],
            // "hrEntryAccept" =>
            // $hrDesignWiseRecruit[0]['NO_OF_PEOPLE_ACCEPTED'],
            // "hrMangerAccept" =>
            // $hrDesignWiseRecruit[1]['NO_OF_PEOPLE_ACCEPTED'],
            // "hrSrManAccept" =>
            // $hrDesignWiseRecruit[2]['NO_OF_PEOPLE_ACCEPTED'],
            // "hrGrManAccept" =>
            // $hrDesignWiseRecruit[3]['NO_OF_PEOPLE_ACCEPTED'],
            // "entryLevel" => $EntryRecruitData,
            // "manager" => $ManagerRecruitData,
            // "srmanager" => $SrRecruitData,
            // "grmanager" => $GrRecruitData,
            // "hrEmpGrowthPer" => $hrEmpGrowth[0]['GROWTH_PERCENT'],
            // "hrTrainingCost" => $this ->
            // convertToSmallNum($hrTrainingCost[0]['AMOUNT'], $convertionType),
            // "hrWelfareCost" => $this ->
            // convertToSmallNum($hrWelfareCost[0]['AMOUNT'], $convertionType),
            // "hrAcquisitionCost" => $this ->
            // convertToSmallNum($hrAcquisitionCost[0]['AMOUNT'],
            // $convertionType),
            // "empPromoted" => $empPromotion[0]['NO_OF_EMP_PROMOTED'],
            // "Dept" => $dept,
            // "qtrstatus" => $qtrStatus,
            // "teamId" => $teamId,
            // "gameId" => $gameId
        );

        return ($new);

        // $data['chartdata'] = json_encode($new);
        //
        // $data['_view'] = 'dept_dashboard/hr_view';
        // $this -> load -> view('layouts/main_view', $data);

    }

    function finDashboardDetails($dept, $teamId, $gameId)
    {
        $convertionType = 2;
        $this -> load -> library('rest', array(
            'server' => straupAPIBaseURL,
            'http_user' => 'admin',
            'http_pass' => '1234',
            'http_auth' => 'digest' // or 'digest'
        ));
        $qtrStatus = $this -> Game_model -> getQtrStatus($gameId);

        $this -> load -> model('Dashboard_model');
        $RevFilter = array(
            'SALES REVENUE',
            'JV REVENUE',
            'EXPORT REVENUE'
        );
        $SalesReturnFilter = array('SALES RETURN');
        $RawMaterialFilter = array(
            'OPENING RAW MATERIAL',
            'OPS RAWMATERIAL PURCHASE COST'
        );
        $ClosingRawMaterialFilter = array('CLOSING RAW MATERIAL');
        $OpsSalaryFilter = array('OPS RECRUITMENT COST');
        $ProductionCostFilter = array(
            'MACHINARY MAINTENANCE COST',
            'OVER HEAD COST',
            'PLANT MAINTENANCE',
            'IT_HARDWARE_DEPRECIATION',
            'PLANT_DEPRECIATION',
            'MACHINE_DEPRECIATION',
            'WAREHOUSE_DEPRECIATION'
        );
        $hrcostFilter = array(
            'MKT RECRUITMENT COST',
            'STG RECRUITMENT COST',
            'IT  RECRUITMENT COST',
            'HR RECRUITMENT COST',
            'FIN RECRUITMENT COST',
            'HR TRAINING COST',
            'WELLFARE PROGRAM COST',
            'STRATEGIC PROGRAM COST',
            'ACQUISITION COST'
        );
        $itCostFilter = array(
            'IT SOFTWARE COST',
            'IT HARDWARE COST',
            'IT HARDWARE AMC COST',
            'IT PROGRAM IMPLEMENTATION COST',
            'IT CHANGE MANAGEMENT COST',
            'IT TRAINING COST',
            'IT SUPPORT COST',
            'IT FIXED COST'
        );
        $mktCostFilter = array(
            'TRANSPORTATION COST',
            'SALES FORCE INCENTIVE',
            'MARGIN COST',
            'DISTRIBUTION SETUP COST',
            'DISTRIBUTION TRAINING COST',
            'DISTRIBUTION SUPPORT COST',
            'AFTER SALES COST',
            'WARRENTY COST',
            'FEATURE CATEGORY COST',
            'ADVERTISEMENT COST'
        );
        $stgCostFilter = array(
            'JV TOTAL PER UNIT COST',
            'JV SETUP COST',
            'EXPORT TOTAL PER UNIT COST',
            'EXPORT SETUP COST'
        );
        $opsCostFilter = array(
            'WAREHOUSE COST - PRODUCT',
            'WAREHOUSE COST',
            'PACKAGE COST'
        );
        $finCostFilter = array(
            'INTEREST_PAYMENT',
            'OD_INTEREST_PAYMENT'
        );
        $incomefrominvestCostFilter = array(
            'FD_INTEREST',
            'SELL_SHARE_PROFIT',
            'SELL_MACHINE_REVENUE',
            'SELL_PLANT_REVENUE',
            'SELL_WAREHOUSE_REVENUE'
        );
        $corporateTaxFilter = array('CORPORATE TAX COST');

        // $BookValue = $this -> Dashboard_model -> bookValue($teamId);
        $totRevenueDtls = $this -> Dashboard_model -> BudgetDetails($teamId, $gameId, $RevFilter);
        $salesReturnDtls = $this -> Dashboard_model -> BudgetDetails($teamId, $gameId, $SalesReturnFilter);
        $RawMaterial = $this -> Dashboard_model -> BudgetDetails($teamId, $gameId, $RawMaterialFilter);
        $ClosingRawMaterial = $this -> Dashboard_model -> BudgetDetails($teamId, $gameId, $ClosingRawMaterialFilter);
        $opsSalary = $this -> Dashboard_model -> BudgetDetails($teamId, $gameId, $OpsSalaryFilter);
        $ProductionCost = $this -> Dashboard_model -> BudgetDetails($teamId, $gameId, $ProductionCostFilter);
        $hrCost = $this -> Dashboard_model -> BudgetDetails($teamId, $gameId, $hrcostFilter);
        $itCost = $this -> Dashboard_model -> BudgetDetails($teamId, $gameId, $itCostFilter);
        $mktCost = $this -> Dashboard_model -> BudgetDetails($teamId, $gameId, $mktCostFilter);
        $stgCost = $this -> Dashboard_model -> BudgetDetails($teamId, $gameId, $stgCostFilter);
        $opsCost = $this -> Dashboard_model -> BudgetDetails($teamId, $gameId, $opsCostFilter);
        $finCost = $this -> Dashboard_model -> BudgetDetails($teamId, $gameId, $finCostFilter);
        $AddnonOperatingCost = $this -> Dashboard_model -> BudgetDetails($teamId, $gameId, $incomefrominvestCostFilter);
        $corporateTax = $this -> Dashboard_model -> BudgetDetails($teamId, $gameId, $corporateTaxFilter);
        $moveNo = $this -> Dashboard_model -> CurrentMove($teamId);
        $revBreakup = $this -> revenueBreakup($teamId, $gameId, $RevFilter);
        $hrCostBreakup = $this -> hrCostBreakup($teamId, $gameId, $hrcostFilter);
        $itCostBreakup = $this -> itCostBreakup($teamId, $gameId, $itCostFilter);
        $mktCostBreakup = $this -> mktCostBreakup($teamId, $gameId, $mktCostFilter);
        $stgCostBreakup = $this -> stgCostBreakup($teamId, $gameId, $stgCostFilter);
        $opsCostBreakup = $this -> opsCostBreakup($teamId, $gameId, $opsCostFilter);
        $finCostBreakup = $this -> finCostBreakup($teamId, $gameId, $finCostFilter);
        $otherIncomeBreakup = $this -> otherIncomeBreakup($teamId, $gameId, $incomefrominvestCostFilter);

        $DebEqu = array();
        $j = 0;
        for ($i = 1; $i <= 5; $i++)
        {
            $DebtvsEquity = $this -> rest -> get('FinReportController/getDebtvsEquity?teamId=' . $teamId . '&gameId=' . $gameId . '&year=' . $i);
            // echo $this->rest->debug();

            $DebtEquit = (json_decode(json_encode($DebtvsEquity), true));
            array_push($DebEqu, $DebtEquit);
            //to add elements to exisiting array
        }
        $DebtEquity = array_reduce($DebEqu, 'array_merge', array());
        //to remove outer array

        $finHealthData = array();
        $winningCriteriaData = $this -> Dashboard_model -> getWiningCriteriaQuarterWise($teamId);
        $otherIncomeQuarterWise = $this -> Dashboard_model ->BudgetDetailsQuarterWise($teamId,$incomefrominvestCostFilter);
        
        $i=0;
        foreach($winningCriteriaData as $winningData)
        {
            $finHealthData[$i]['YEAR'] = $winningData['YEAR'];
            $finHealthData[$i]['QUARTER'] = $winningData['QUARTER'];
            $finHealthData[$i]['PAT'] = $winningData['PAT'];
            $finHealthData[$i]['REVENUE'] = $winningData['REVENUE'];

            foreach($otherIncomeQuarterWise as $otherinc)
            {
                if($winningData['YEAR'] == $otherinc['YEAR'])
                {
                    if($winningData['QUARTER'] == $otherinc['QUARTER'])
                    {
                        $finHealthData[$i]['INCOME'] = $otherinc['AMOUNT'];
                    }
                    else
                    {
                        $finHealthData[$i]['INCOME'] = "0";
                    }
                }
                else
                {
                    $finHealthData[$i]['INCOME'] = "0";
                }
            }
            $i++;
        }
        $finHealthCostData = array();
        $hrCostQuarterWise = $this -> Dashboard_model -> BudgetDetailsQuarterWise($teamId, $hrcostFilter);
        $mktCostQuarterWise = $this -> Dashboard_model -> BudgetDetailsQuarterWise($teamId, $mktCostFilter);
        $opsCostQuarterWise = $this -> Dashboard_model -> BudgetDetailsQuarterWise($teamId, $opsCostFilter);
        $finCostQuarterWise = $this -> Dashboard_model -> BudgetDetailsQuarterWise($teamId, $finCostFilter);
        $RawMaterialQuarterWise = $this -> Dashboard_model -> BudgetDetailsQuarterWise($teamId, $RawMaterialFilter);
        $ClosingRawMaterialQuarterWise = $this -> Dashboard_model -> BudgetDetailsQuarterWise($teamId, $ClosingRawMaterialFilter);
        $opsSalaryQuarterWise = $this -> Dashboard_model -> BudgetDetailsQuarterWise($teamId, $OpsSalaryFilter);
        $ProductionCostQuarterWise = $this -> Dashboard_model -> BudgetDetailsQuarterWise($teamId, $ProductionCostFilter);
        $costofGoodsSoldQuarterWise = $this -> Dashboard_model -> getCostOfGoodsSoldQuarterWise($teamId,$RawMaterialFilter,$ClosingRawMaterialFilter,$OpsSalaryFilter,$ProductionCostFilter);
        $netsalesRevenueQuarterWise = $this -> Dashboard_model -> getNetSalesRevenueQuarterWise($teamId, $RevFilter, $SalesReturnFilter);

        $finGrossProfitQuarterWise = $this -> finGrossProfitQuarterWise($costofGoodsSoldQuarterWise,$netsalesRevenueQuarterWise);
        
        $finHealthCostData[0]['HR_COST'] = $hrCostQuarterWise;
        $finHealthCostData[0]['MKT_COST'] = $mktCostQuarterWise;
        $finHealthCostData[0]['OPS_COST'] = $opsCostQuarterWise;
        $finHealthCostData[0]['FIN_COST'] = $finCostQuarterWise;
        $finHealthCostData[0]['COGS'] = $costofGoodsSoldQuarterWise;

        //var_dump($finHealthCostData);
        //$totRevenueDtls=($totRevenueDtls[(sizeof($totRevenueDtls))-1]['Actual_Value']);
        $netsalesRevenue = $totRevenueDtls[0]['AMOUNT'] - $salesReturnDtls[0]['AMOUNT'];
        $rawMaterialInventory = $RawMaterial[0]['AMOUNT'] - $ClosingRawMaterial[0]['AMOUNT'];
        $costofGoodsSold = $rawMaterialInventory + $opsSalary[0]['AMOUNT'] + $ProductionCost[0]['AMOUNT'];
        $grossProfit = $netsalesRevenue - $costofGoodsSold;
        $sellingDistributionAndAdminCost = $hrCost[0]['AMOUNT'] + $itCost[0]['AMOUNT'] + $mktCost[0]['AMOUNT'] + $stgCost[0]['AMOUNT'] + $opsCost[0]['AMOUNT'] + $finCost[0]['AMOUNT'];
        $NetProfitBeforeTax = $grossProfit - $sellingDistributionAndAdminCost + $AddnonOperatingCost[0]['AMOUNT'];

        $NetProfitAfterTax = $NetProfitBeforeTax - $corporateTax[0]['AMOUNT'];

        // $expenseDtls = $this -> expenseStatement($teamId, $departmentId);
        $expenseDtls = $this -> expenseStatement($teamId, 'FIN');
        $cogsBreakUp = array(
            $rawMaterialInventory,
            $opsSalary[0]['AMOUNT'],
            $ProductionCost[0]['AMOUNT']
        );
        $revenueBreakup = array();

        $new = array(
            // "pat" => $pat,
            // "Debt" => $Debt,
            // "Equity" => $Equity,
            // "Approved" => $Approved,
            // "Available" => $Available,
            // "Investment" => $Investment,
            //"BookValueChart" => $bookval,
            // "totRevenue" => $this ->
            // convertToSmallNum($totRevenueDtls[0]['AMOUNT'], $convertionType),
            // "grossProf" => $this -> convertToSmallNum($grossProfit,
            // $convertionType),
            // "netProf" => $this -> convertToSmallNum($NetProfitAfterTax,
            // $convertionType),
            // "BookValue" => $BookValue[0]['BOOK_VALUE'],
            "totalRevenue" => $totRevenueDtls[0]['AMOUNT'],
            "revbreakup" => $revBreakup,
            "grossProfit" => $grossProfit,
            "CostofGoodsSold" => $costofGoodsSold,
            "cogsBreakUp" => $cogsBreakUp,
            "SellingAdminCost" => $sellingDistributionAndAdminCost,
            "hrCost" => $hrCost[0]['AMOUNT'],
            "hrCostbreakup" => $hrCostBreakup,
            "itCost" => $itCost[0]['AMOUNT'],
            "itCostbreakup" => $itCostBreakup,
            "mktCost" => $mktCost[0]['AMOUNT'],
            "mktCostbreakup" => $mktCostBreakup,
            "stgCost" => $stgCost[0]['AMOUNT'],
            "stgCostbreakup" => $stgCostBreakup,
            "opsCost" => $opsCost[0]['AMOUNT'],
            "opsCostbreakup" => $opsCostBreakup,
            "finCost" => $finCost[0]['AMOUNT'],
            "finCostbreakup" => $finCostBreakup,
            "otherIncome" => $AddnonOperatingCost[0]['AMOUNT'],
            "otherIncomeBreakup" => $otherIncomeBreakup,
            "NetProfitBeforeTax" => $NetProfitBeforeTax,
            "corporateTax" => $corporateTax[0]['AMOUNT'],
            "NetProfit" => $NetProfitAfterTax,
            "finHealthData" => $finHealthData,
            "finHealthCostData" => $finHealthCostData,
            "grossMarginData" => $finGrossProfitQuarterWise
            // "Dept" => $dept,
            // "qtrstatus" => $qtrStatus,
            // "teamId" => $teamId,
            // "gameId" => $gameId,
            // "moveNo" => $moveNo[0]['MoveNo'],
            // "expenseDtls" => $expenseDtls
        );
        return ($new);
        // $data['chartdata'] = json_encode($new);
        //
        // $data['_view'] = 'dept_dashboard/fin_view';
        // $this -> load -> view('layouts/main_view', $data);
    }

    function revenueBreakup($teamId, $gameId, $RevFilter)
    {
        //to get revenue breakup for fin dashboard

        $this -> load -> model('Dashboard_model');
        $revenueBreakup = $this -> Dashboard_model -> BudgetDetailsgroupbyBudgetHead($teamId, $gameId, $RevFilter);

        $salesrevenue = 0;
        $jvrevenue = 0;
        $exportrevenue = 0;
        foreach ($revenueBreakup as $rev)
        {
            if ($rev['BUDGET_HEAD'] == 'SALES REVENUE')
            {
                $salesrevenue += $rev['AMOUNT'];

            }
            else
            if ($rev['BUDGET_HEAD'] == 'JV REVENUE')
            {
                $jvrevenue += $rev['AMOUNT'];

            }
            else
            if ($rev['BUDGET_HEAD'] == 'EXPORT REVENUE')
            {
                $exportrevenue += $rev['AMOUNT'];

            }
        }
        $revbreakup = array(
            $salesrevenue,
            $jvrevenue,
            $exportrevenue
        );
        return $revbreakup;
    }

    function hrCostBreakup($teamId, $gameId, $hrcostFilter)
    {
        //to get hrcost breakup for fin dashboard

        $this -> load -> model('Dashboard_model');
        $hrTrainingCostFilter = array('HR TRAINING COST');
        $hrWelfareCostFilter = array('WELLFARE PROGRAM COST');
        $hrSalaryCostFilter = array(
            'ACQUISITION COST',
            'MKT RECRUITMENT COST',
            'STG RECRUITMENT COST',
            'IT  RECRUITMENT COST',
            'HR RECRUITMENT COST',
            'FIN RECRUITMENT COST',
            'STRATEGIC PROGRAM COST'
        );
        $hrCostBreakup = $this -> Dashboard_model -> BudgetDetailsgroupbyBudgetHead($teamId, $gameId, $hrcostFilter);

        $hrSalaryCost = 0;
        $hrWelfareCost = 0;
        $hrTrainingCost = 0;
        foreach ($hrCostBreakup as $hr)
        {
            foreach ($hrSalaryCostFilter as $hrs)
            {
                if ($hr['BUDGET_HEAD'] == $hrs)
                {
                    $hrSalaryCost += $hr['AMOUNT'];
                    break;
                }
            }
            foreach ($hrTrainingCostFilter as $hrt)
            {
                if ($hr['BUDGET_HEAD'] == $hrt)
                {
                    $hrTrainingCost += $hr['AMOUNT'];
                    break;
                }
            }
            foreach ($hrWelfareCostFilter as $hrw)
            {
                if ($hr['BUDGET_HEAD'] == $hrw)
                {
                    $hrWelfareCost += $hr['AMOUNT'];
                    break;
                }
            }
        }
        $hrbreakup = array(
            $hrSalaryCost,
            $hrTrainingCost,
            $hrWelfareCost
        );
        return $hrbreakup;
    }

    function itCostBreakup($teamId, $gameId, $itCostFilter)
    {
        //to get itcost breakup for fin dashboard

        $this -> load -> model('Dashboard_model');
        $itImplementCostFilter = array(
            'IT SOFTWARE COST',
            'IT HARDWARE COST',
            'IT HARDWARE AMC COST',
            'IT PROGRAM IMPLEMENTATION COST',
            'IT CHANGE MANAGEMENT COST',
            'IT TRAINING COST',
            'IT SUPPORT COST'
        );
        $itFixedCostFilter = array('IT FIXED COST');
        $itCostBreakup = $this -> Dashboard_model -> BudgetDetailsgroupbyBudgetHead($teamId, $gameId, $itCostFilter);

        $itImplementCost = 0;
        $itFixedCost = 0;
        foreach ($itCostBreakup as $it)
        {
            foreach ($itImplementCostFilter as $itimplem)
            {
                if ($it['BUDGET_HEAD'] == $itimplem)
                {
                    $itImplementCost += $it['AMOUNT'];
                    break;
                }
            }
            foreach ($itFixedCostFilter as $itfix)
            {
                if ($it['BUDGET_HEAD'] == $itfix)
                {
                    $itFixedCost += $it['AMOUNT'];
                    break;
                }
            }
        }
        $itbreakup = array(
            $itImplementCost,
            $itFixedCost
        );
        return $itbreakup;
    }

    function mktCostBreakup($teamId, $gameId, $mktCostFilter)
    {
        //to get mktcost breakup for fin dashboard

        $this -> load -> model('Dashboard_model');
        $mktTransportCostFilter = array('TRANSPORTATION COST');
        $mktDistribCostFilter = array(
            'SALES FORCE INCENTIVE',
            'MARGIN COST',
            'DISTRIBUTION SETUP COST',
            'DISTRIBUTION TRAINING COST',
            'DISTRIBUTION SUPPORT COST'
        );
        $mktAdsCostFilter = array('ADVERTISEMENT COST');
        $mktSalesWarrnCostFilter = array(
            'AFTER SALES COST',
            'WARRENTY COST'
        );
        $mktFeatureCostFilter = array('FEATURE CATEGORY COST');
        $mktCostBreakup = $this -> Dashboard_model -> BudgetDetailsgroupbyBudgetHead($teamId, $gameId, $mktCostFilter);

        $mktAdsCost = 0;
        $mktDistribCost = 0;
        $mktTransportCost = 0;
        $mktSalesCost = 0;
        $mktFeatureCost = 0;

        foreach ($mktCostBreakup as $mkt)
        {
            foreach ($mktTransportCostFilter as $mktTrans)
            {
                if ($mkt['BUDGET_HEAD'] == $mktTrans)
                {
                    $mktTransportCost += $mkt['AMOUNT'];
                    break;
                }
            }
            foreach ($mktDistribCostFilter as $mktDis)
            {
                if ($mkt['BUDGET_HEAD'] == $mktDis)
                {
                    $mktDistribCost += $mkt['AMOUNT'];
                    break;
                }
            }
            foreach ($mktAdsCostFilter as $mktAds)
            {
                if ($mkt['BUDGET_HEAD'] == $mktAds)
                {
                    $mktAdsCost += $mkt['AMOUNT'];
                    break;
                }
            }
            foreach ($mktSalesWarrnCostFilter as $mktSales)
            {
                if ($mkt['BUDGET_HEAD'] == $mktSales)
                {
                    $mktSalesCost += $mkt['AMOUNT'];
                    break;
                }
            }
            foreach ($mktFeatureCostFilter as $mktFea)
            {
                if ($mkt['BUDGET_HEAD'] == $mktFea)
                {
                    $mktFeatureCost += $mkt['AMOUNT'];
                    break;
                }
            }
        }
        $mktbreakup = array(
            $mktTransportCost,
            $mktDistribCost,
            $mktAdsCost,
            $mktFeatureCost,
            $mktSalesCost
        );
        return $mktbreakup;
    }

    function stgCostBreakup($teamId, $gameId, $stgCostFilter)
    {
        //to get stgcost breakup for fin dashboard

        $this -> load -> model('Dashboard_model');
        $stgExpUnitFilter = array(
            'JV TOTAL PER UNIT COST',
            'JV SETUP COST',
            'EXPORT TOTAL PER UNIT COST',
            'EXPORT SETUP COST'
        );
        $stgCostBreakup = $this -> Dashboard_model -> BudgetDetailsgroupbyBudgetHead($teamId, $gameId, $stgCostFilter);

        $stgJVSetupCost = 0;
        $stgExpSetupCost = 0;
        $stgJVunitCost = 0;
        $stgExpunitCost = 0;

        foreach ($stgCostBreakup as $stg)
        {
            if ($stg['BUDGET_HEAD'] == 'JV TOTAL PER UNIT COST')
            {
                $stgJVunitCost += $stg['AMOUNT'];
            }
            if ($stg['BUDGET_HEAD'] == 'JV SETUP COST')
            {
                $stgJVSetupCost += $stg['AMOUNT'];
            }
            if ($stg['BUDGET_HEAD'] == 'EXPORT TOTAL PER UNIT COST')
            {
                $stgExpunitCost += $stg['AMOUNT'];
            }
            if ($stg['BUDGET_HEAD'] == 'EXPORT SETUP COST')
            {
                $stgExpSetupCost += $stg['AMOUNT'];
            }
        }
        $stgbreakup = array(
            $stgJVunitCost,
            $stgJVSetupCost,
            $stgExpunitCost,
            $stgExpSetupCost
        );
        return $stgbreakup;
    }

    function opsCostBreakup($teamId, $gameId, $opsCostFilter)
    {
        //to get opscost breakup for fin dashboard

        $this -> load -> model('Dashboard_model');
        $opsWarehouseFilter = array(
            'WAREHOUSE COST - PRODUCT',
            'WAREHOUSE COST'
        );
        $opsPackageFilter = array('PACKAGE COST');
        $opsCostBreakup = $this -> Dashboard_model -> BudgetDetailsgroupbyBudgetHead($teamId, $gameId, $opsCostFilter);

        $opsWarehouseCost = 0;
        $opsPackageCost = 0;

        foreach ($opsCostBreakup as $ops)
        {
            foreach ($opsWarehouseFilter as $opsWare)
            {
                if ($ops['BUDGET_HEAD'] == $opsWare)
                {
                    $opsWarehouseCost += $ops['AMOUNT'];
                    break;
                }
            }
            foreach ($opsPackageFilter as $opsPack)
            {
                if ($ops['BUDGET_HEAD'] == $opsPack)
                {
                    $opsPackageCost += $ops['AMOUNT'];
                    break;
                }
            }
        }
        $opsbreakup = array(
            $opsWarehouseCost,
            $opsPackageCost
        );
        return $opsbreakup;
    }

    function finCostBreakup($teamId, $gameId, $finCostFilter)
    {
        //to get fincost breakup for fin dashboard

        $this -> load -> model('Dashboard_model');
        $finCostBreakup = $this -> Dashboard_model -> BudgetDetailsgroupbyBudgetHead($teamId, $gameId, $finCostFilter);

        $finInterestCost = 0;
        $finODIneterestCost = 0;

        foreach ($finCostBreakup as $fin)
        {
            if ($fin['BUDGET_HEAD'] == 'INTEREST PAYMENT')
            {
                $finInterestCost += $fin['AMOUNT'];
            }
            else
            if ($fin['BUDGET_HEAD'] == 'OD INTEREST PAYMENT')
            {
                $finODIneterestCost += $fin['AMOUNT'];
            }
        }
        $finbreakup = array(
            $finInterestCost,
            $finODIneterestCost
        );
        return $finbreakup;
    }

    function otherIncomeBreakup($teamId, $gameId, $incomefrominvestCostFilter)
    {
        //to get fincost breakup for fin dashboard

        $this -> load -> model('Dashboard_model');
        $otherIncomeBreakup = $this -> Dashboard_model -> BudgetDetailsgroupbyBudgetHead($teamId, $gameId, $incomefrominvestCostFilter);

        $otherIncomeFD = 0;
        $otherIncomeSharesale = 0;
        $otherIncomeMachinesale = 0;
        $otherIncomePlantsale = 0;
        $otherIncomeWarehousesale = 0;

        foreach ($otherIncomeBreakup as $other)
        {
            if ($other['BUDGET_HEAD'] == 'FD_INTEREST')
            {
                $otherIncomeFD += $other['AMOUNT'];
            }
            else
            if ($other['BUDGET_HEAD'] == 'SELL_SHARE_PROFIT')
            {
                $otherIncomeSharesale += $other['AMOUNT'];
            }
            else
            if ($other['BUDGET_HEAD'] == 'SELL_MACHINE_REVENUE')
            {
                $otherIncomeMachinesale += $other['AMOUNT'];
            }
            else
            if ($other['BUDGET_HEAD'] == 'SELL_PLANT_REVENUE')
            {
                $otherIncomePlantsale += $other['AMOUNT'];
            }
            else
            if ($other['BUDGET_HEAD'] == 'SELL_WAREHOUSE_REVENUE')
            {
                $otherIncomeWarehousesale += $other['AMOUNT'];
            }
        }
        $otherbreakup = array(
            $otherIncomeFD,
            $otherIncomeSharesale,
            $otherIncomeMachinesale,
            $otherIncomePlantsale,
            $otherIncomeWarehousesale
        );
        return $otherbreakup;
    }

    function expenseStatement($teamId, $departmentId)
    {
        $this -> load -> model('Dashboard_model');
        $expenseDtls = $this -> Dashboard_model -> expenseStatement($teamId, $departmentId);
        $i = 0;
        $data = array();
        foreach ($expenseDtls as $row)
        {
            if ($i == 0)
            {
                $data[$i]['Desc'] = ucwords($row['TRANSACTION_FOR']);
                $temp[$i]['Amount'] = $row['Amount'];
                $data[$i]['Amount'] = $row['Amount'] - 0;
                $data[$i]['Income'] = number_format($data[$i]['Amount'], 2);
                $data[$i]['Expense'] = '';
                $data[$i]['Balance'] = number_format($row['Amount'], 2);

            }
            else
            {
                $data[$i]['Year_Qtr'] = 'Y' . $row['Year'] . 'Q' . $row['Qtr'];
                $data[$i]['Desc'] = ucwords(strtolower($row['TRANSACTION_FOR']));
                $temp[$i]['Amount'] = $row['Amount'];
                $data[$i]['Amount'] = $row['Amount'] - $temp[$i - 1]['Amount'];
                if ($data[$i]['Amount'] < 0)
                {
                    $data[$i]['Expense'] = number_format($data[$i]['Amount'] * -1, 2);
                    $data[$i]['Income'] = '';
                }
                else
                {
                    $data[$i]['Income'] = number_format($data[$i]['Amount'], 2);
                    $data[$i]['Expense'] = '';
                }
                $data[$i]['Balance'] = number_format($row['Amount'], 2); ;

            }
            $i++;

        }
        return $data;
    }

    function universeleaderboard($universeToken)
    {
        $convertionType = implode(" ", $this->input->post());
        if(count($_POST)==0 )
        {
            $convertionType=1;
        }
        $lb = $this -> leaderboardApi($universeToken);
        $lb = json_decode(json_encode($lb), true);
        // echo $this->rest->debug();
        $data['mission'] = $this -> mission($universeToken,$convertionType);
       $data['leaderboardview'] = 'dept_dashboard/overall_performance/universe_leaderboard_view';
       $data['missionview'] = 'dept_dashboard/overall_performance/mission_view';
       $data['_view'] = 'dept_dashboard/overall_performance/overall_template_view';
    //    $data['_view'] = 'dept_dashboard/overall_performance/universe_leaderboard_view';
        $data['leaderboard'] = $lb;
        $data['universetoken'] = $universeToken;
        $data['type'] = $convertionType;
        $data['conversionMethod'] = $this; // to get library file in view which is an extension of this file
        $this -> load -> view('layouts/main_view', $data);

    }

    function leaderboardApi($universeToken)
    {
        $this -> load -> library('rest', array(
            'server' => straupAPIBaseURL,
            'http_user' => 'admin',
            'http_pass' => '1234',
            'http_auth' => 'digest' // or 'digest'
        ));
        $chartdata = $this -> rest -> get('DiagnosticReportController/getUniverseWiseLeaderBoard?universeToken=' . $universeToken);
        // echo $this->rest->debug();
        return $chartdata;
    }

    function competitorAndSalesSnapshot($universeToken,$teamId)
    {
        $this -> load -> library('rest', array(
            'server' => straupAPIBaseURL,
            'http_user' => 'admin',
            'http_pass' => '1234',
            'http_auth' => 'digest' // or 'digest'
        ));

        $lb = $this -> leaderboardApi($universeToken);
        $lb = json_decode(json_encode($lb), true);

        
        $filterBy1 = '1';
        // Rank 1
        $filterBy2 = $teamId;//myCompany

        //filter from leaderboard for rank 1 team and mycompany data
        $marketLeader = array_filter($lb, function($var) use ($filterBy1, $filterBy2)
        {
            return ($var['CURRENT_RANK'] == $filterBy1 || $var['TEAM_ID'] == $filterBy2);
        });

        //filter from leaderboard for all teams except Rank 1 team and myCompany
        $listofTeamsInUniverse = array_filter($lb, function($var) use ($filterBy1, $filterBy2)
        {
            return ($var['CURRENT_RANK'] !== $filterBy1 && $var['TEAM_ID'] !== $filterBy2);
        });

        // fetch game id and team id for market leader (Rank 1)
        $marketLeaderGameId = $marketLeader[0]['GAME_ID'];
        $marketLeaderTeamId = $marketLeader[0]['TEAM_ID'];
        $marketLeaderTeamName = $marketLeader[0]['TEAM_LOGO_NAME'];

        // fetch game id based on Team id (My Company)
        $this -> load -> model('Gamemasters_model');
        $teamDtls = $this -> Gamemasters_model -> getTeamDtlsForTeamId($teamId);
        $gameId = $teamDtls[0]['GAME_ID'];
        $teamName = $teamDtls[0]['TEAM_LOGO_NAME'];

        $productName=  $this->input->post('product');
        $segmentName=  $this->input->post('segment');
        $year=  $this->input->post('year');
        $quarter=  $this->input->post('quarter');

        // fetch game id and team id for Compared Team
        $compareTeamId = $this->input->post('compareTeamId');
        $compareTeamGameId ='';
        $compareTeamTeamName = '';
        $compareTeamDtls = $this -> Gamemasters_model ->getTeamDtlsForTeamId($compareTeamId);
       
        if(count($compareTeamDtls)>0)
        {
            $compareTeamGameId = $compareTeamDtls[0]['GAME_ID'];
            $compareTeamTeamName = $compareTeamDtls[0]['TEAM_LOGO_NAME'];
        }
        
        $this -> load -> model('Dashboard_model');
        $listofProducts = $this->Dashboard_model->getProductNameFromgameMstr($gameId);
        $listofSegments = $this->Dashboard_model->getSegmentNameFromgameMstr($gameId);
        $maxYearinGame = $this-> Gamemasters_model -> getGameStartInfo($universeToken);

        if($productName== '' )
        {
            $productName=str_replace(' ', '%20', $listofProducts[0]['PRODUCT_NAME']);
        }
        if($segmentName=='' )
        {
            $segmentName=str_replace(' ', '%20', $listofSegments[0]['SEGMENT_NAME']);
        }
        if($year=='' )
        {
            $year=1;
        }
        if($quarter=='' )
        {
            $quarter=1;
        }        


        $competitorSnapshot = $this -> rest -> get('MarketingControl/getCompetitorSalesReport?productName='.$productName.'&segmentName='.$segmentName.'&gameId='.$gameId.'&teamId='.$teamId.'&year='.$year.'&quarter='.$quarter);
        $competitorSnapshot = json_decode(json_encode($competitorSnapshot), true);

        //filter only for marketLeader, mycompany and selected team(compare with other team)
        $competitorsnapshotfilterBy1 = $marketLeaderTeamId;//Rank 1(marketleader)
        $competitorsnapshotfilterBy2 = $teamId;//mycompany
        $competitorsnapshotfilterBy3 = $compareTeamId;//compare team
       
        $responsearray = array();
        $competitorSnapshotwithMarketLeader = array();
        $i = 0;
        foreach($competitorSnapshot as $row)
        {
            if(array_key_exists("TEAM_ID",$row))
            {
                $responsearray[$i]=$row;
            }
            $i++;            
        }
        if(count($responsearray)>0)
        {
            $competitorSnapshotwithMarketLeader = array_filter($responsearray, function($var2) use ($competitorsnapshotfilterBy1, $competitorsnapshotfilterBy2, $competitorsnapshotfilterBy3)
            {
                return ($var2['TEAM_ID'] == $competitorsnapshotfilterBy1 || $var2['TEAM_ID'] == $competitorsnapshotfilterBy2 || $var2['TEAM_ID'] == $competitorsnapshotfilterBy3);
            });
        }

        // if no value for in competitorSnapshot show default value(mycompany)
        $competitorSnapShotMyCompany = array('TEAM_ID' => $competitorsnapshotfilterBy2,
        'TEAM_NAME' => '',
        'PRICE' => '0',
        'SALES_AND_DISTRIBUTION_COST' => '0',
        'AWARNESS_CREATED' => '0',
        'EDI' => '0',
        'NO_OF_UNITS_ALLOCATED' => '0',
        'QUALITY' => '0',
        'NO_OF_UNIT_SOLD' => '0',
        'PERCENT_SALES' => '0',
        'REVENUE' => '0',
        'MARKET_SHARE' => '0');

        // if no value for in competitorSnapshot show default value(marketLeader)
        $competitorSnapShotMarketLeader = array('TEAM_ID' => $competitorsnapshotfilterBy1,
        'TEAM_NAME' => '',
        'PRICE' => '0',
        'SALES_AND_DISTRIBUTION_COST' => '0',
        'AWARNESS_CREATED' => '0',
        'EDI' => '0',
        'NO_OF_UNITS_ALLOCATED' => '0',
        'QUALITY' => '0',
        'NO_OF_UNIT_SOLD' => '0',
        'PERCENT_SALES' => '0',
        'REVENUE' => '0',
        'MARKET_SHARE' => '0');

        // if no value for in competitorSnapshot show default value(compared Team)
        $competitorSnapShotCompareTeam = array('TEAM_ID' => $competitorsnapshotfilterBy3,
        'TEAM_NAME' => '',
        'PRICE' => '0',
        'SALES_AND_DISTRIBUTION_COST' => '0',
        'AWARNESS_CREATED' => '0',
        'EDI' => '0',
        'NO_OF_UNITS_ALLOCATED' => '0',
        'QUALITY' => '0',
        'NO_OF_UNIT_SOLD' => '0',
        'PERCENT_SALES' => '0',
        'REVENUE' => '0',
        'MARKET_SHARE' => '0');
        
        foreach($competitorSnapshotwithMarketLeader as $row)
        {
            if($row['TEAM_ID'] == $competitorsnapshotfilterBy2)
            {
                $competitorSnapShotMyCompany = $row;
            }
            if($row['TEAM_ID'] == $competitorsnapshotfilterBy1)
            {
                $competitorSnapShotMarketLeader = $row;
            }      
            if($row['TEAM_ID'] == $competitorsnapshotfilterBy3)
            {
                $competitorSnapShotCompareTeam = $row;
            } 
        }

        //SalesSnapshot For mycompany
        $salesSnapshotMyCompany = $this -> rest -> get('MarketingControl/getSalesSnap?productName='.$productName.'&segmentName='.$segmentName.'&gameId='.$gameId.'&teamId='.$teamId.'&year='.$year.'&quarter='.$quarter);
        $salesSnapshotMyCompany = json_decode(json_encode($salesSnapshotMyCompany), true);

        foreach($salesSnapshotMyCompany as $salesSnap)
        {
            $keyMetricSalesSnapMyCompany[0][$salesSnap['UNIT_NOT_SOLD_REASON']] = (string)((int)$salesSnap['T1']+
            (int)$salesSnap['T2']+(int)$salesSnap['T3']+(int)$salesSnap['T4']+(int)$salesSnap['T5']+
            (int)$salesSnap['T6']+(int)$salesSnap['T7']+(int)$salesSnap['T8']);
        }

        //SalesSnapshot For market leader
        $salesSnapshotMarketLeader = $this -> rest -> get('MarketingControl/getSalesSnap?productName='.$productName.'&segmentName='.$segmentName.'&gameId='.$marketLeaderGameId.'&teamId='.$marketLeaderTeamId.'&year='.$year.'&quarter='.$quarter);
        $salesSnapshotMarketLeader = json_decode(json_encode($salesSnapshotMarketLeader), true);
 
        foreach($salesSnapshotMarketLeader as $salesSnap)
        {
            $keyMetricSalesSnapMarketLeader[0][$salesSnap['UNIT_NOT_SOLD_REASON']] = (string)((int)$salesSnap['T1']+
            (int)$salesSnap['T2']+(int)$salesSnap['T3']+(int)$salesSnap['T4']+(int)$salesSnap['T5']+
            (int)$salesSnap['T6']+(int)$salesSnap['T7']+(int)$salesSnap['T8']);
        }

        //SalesSnapshot For Compared Team
        if($compareTeamId != '')
        {
            $salesSnapshotCompareTeam = $this -> rest -> get('MarketingControl/getSalesSnap?productName='.$productName.'&segmentName='.$segmentName.'&gameId='.$compareTeamGameId.'&teamId='.$compareTeamId.'&year='.$year.'&quarter='.$quarter);
            $salesSnapshotCompareTeam = json_decode(json_encode($salesSnapshotCompareTeam), true);
           
            foreach($salesSnapshotCompareTeam as $salesSnap)
            {
                $keyMetricSalesSnapCompareTeam[0][$salesSnap['UNIT_NOT_SOLD_REASON']] = (string)((int)$salesSnap['T1']+
                (int)$salesSnap['T2']+(int)$salesSnap['T3']+(int)$salesSnap['T4']+(int)$salesSnap['T5']+
                (int)$salesSnap['T6']+(int)$salesSnap['T7']+(int)$salesSnap['T8']);
            }            
        }
        else
        {
            //compare team is not selected show value as 0
            $keyMetricSalesSnapCompareTeam[0] = array('ALLOACTED_PRODUCTS' => '0',
            'DEMAND IMPACT' => '0',
            'AVAILABILITY_OF_SALES_FORCE' => '0',
            'EFFECTIVENESS_OF_SALES_FORCE' => '0',
            'MANDATORY_PROGRAM_NON_IMPLEMENTATION' => '0',
            'MACRO_ECONOMIC_FACTORS' => '0',
            'PRODUCT_PRICE' => '0',
            'PRODUCT_QUALITY' => '0',
            'AFTER_SALES_SERVICE' => '0',
            'MISMATCH_FEATURES' => '0',
            'PRODUCT_AWARNESS' => '0',
            'BRAND_IMAGE' => '0',
            'DISTRIBUTOR_EFFECTIVENESS' => '0',
            'ADDITIONAL_SALES' => '0',
            'UNITS_SOLD' => '0');
        }

        $data['universetoken'] = $universeToken;
        $data['teamId'] = $teamId;

        $data['mktInfo'] = array(
            "competitorSnapShotmyCompany" => $competitorSnapShotMyCompany,
            "competitorSnapShotmarketLeader" => $competitorSnapShotMarketLeader,
            "competitorSnapShotcompareTeam" => $competitorSnapShotCompareTeam,
            "listofProducts"=>$listofProducts,
            "listofSegments"=>$listofSegments,
            "gamemaxyear" => $maxYearinGame[0]['NO_OF_YEAR_IN_GAME'],
            "marletLeaderTeamName" => $marketLeaderTeamName,
            "myCompanyTeamName" => $teamName,
            "compareTeamName" => $compareTeamTeamName,
            "listofTeamsInUniverse" => $listofTeamsInUniverse,
            "salesSnapMyCompany"=> $keyMetricSalesSnapMyCompany[0],
            "salesSnapMarketLeader"=> $keyMetricSalesSnapMarketLeader[0],
            "salesSnapCompareTeam"=> $keyMetricSalesSnapCompareTeam[0]
        );

        // $data['_view'] = 'dept_dashboard/overall_performance/competitor_snapshot_view';
        $data['mktInfoview'] = 'dept_dashboard/overall_performance/mkt_overall_view';
        $data['_view'] = 'dept_dashboard/overall_performance/overall_template_view';
        $this -> load -> view('layouts/main_view', $data);

    }

    function mission($universeToken,$convertionType)
    {     
        //fetch leaderboard for UniverseToken
        $lb = $this -> leaderboardApi($universeToken);
        $listofTeamsInUniverse = json_decode(json_encode($lb), true);

        // fetch game id and team id for Compared Team
        $compareTeamId = $this->input->post('compareTeamId');
        $compareTeamGameId ='';
        $compareTeamTeamName = '';

        $this -> load -> model('Gamemasters_model');
        $compareTeamDtls = $this -> Gamemasters_model ->getTeamDtlsForTeamId($compareTeamId);
       
        if(count($compareTeamDtls)>0)
        {
            $compareTeamGameId = $compareTeamDtls[0]['GAME_ID'];
            $compareTeamTeamName = $compareTeamDtls[0]['TEAM_LOGO_NAME'];
        }
        
        //fetch mission mstr details
        $this -> load -> model('Dashboard_model');
        $this -> load -> model('Game_model');
        $missionDtls = $this->Gamemasters_model->getMissionMstrDtls();

        
        $this -> load -> model('stratup/Game_batch_tbl_model');
        $gameBatchDtls = $this->Game_batch_tbl_model ->get_game_batch_tbl_foruniverse($universeToken);
     
        $gameBatchId = $gameBatchDtls['GAME_BATCH_ID'];
        // fetch mission details for universe
        $universeMissionDtls = $this -> Gamemasters_model->getMissionUniverseDtls($gameBatchId);
        if(count($universeMissionDtls) == 0)
        {
            foreach($missionDtls as $mission)
            {
                $param = array("MISSION_ID" => $mission['MISSION_ID'],
                        "GAME_BATCH_ID" => $gameBatchId);
                $this -> Gamemasters_model -> insertMissionforUniverse($param);
            }     
            $universeMissionDtls = $this -> Gamemasters_model->getMissionUniverseDtls($gameBatchId);       
        }

        $missionAchievedArray = array();
        $j=0;
        $i = 0;
        $responsearray = array();

        //to check mission achieved 
        foreach($missionDtls as $mission)
        {
            $responsearray[$i]['MISSION_TITLE'] = $mission['MISSION_TITLE'];
            $responsearray[$i]['MISSION_DESC'] = $mission['MISSION_DESC'];
            $responsearray[$i]['TARGET_YEAR'] = $mission['TARGET_YEAR'];
            $responsearray[$i]['TARGET_QUARTER'] = $mission['TARGET_QUARTER'];
            //to check highest capacity mission 
            if($mission['MISSION_TITLE'] == 'CAPACITY')
            {  
                $universeTeamsquarterStatus = $this -> Game_model ->getQtrStatusforAllTeamInUniverse($universeToken, $mission['TARGET_YEAR'], $mission['TARGET_QUARTER']); 
                if(count($universeTeamsquarterStatus)>0)
                {
                    if(!in_array("In-Progress", array_column($universeTeamsquarterStatus, 'Qstatus')))  
                    {
                        $machineCapacityForUniverse = $this->Dashboard_model->getTotalCapacityForUniverse($universeToken, $mission['TARGET_YEAR'], $mission['TARGET_QUARTER']);
                        if(count($machineCapacityForUniverse) > 0)
                        {
                            $capacityMissionDtls = $this->checkCommonMission($mission, $machineCapacityForUniverse,$convertionType);
                            if($capacityMissionDtls[0]!="")
                            {
                                $achieved=$this->getMissionStatus($gameBatchId,$mission,$capacityMissionDtls);
                                if(count($achieved)>0)
                                {
                                    $missionAchievedArray[$j]=$achieved;
                                    $j++;
                                }
                            }
                            $responsearray[$i]['TEAM_NAME'] = $capacityMissionDtls[0];
                            $responsearray[$i]['VALUE'] = $capacityMissionDtls[1];
                            $responsearray[$i]['TEAM_LOGO_PATH'] = $capacityMissionDtls[2];
                            
                            //fetch particular team(compare team) details for mission
                            $compareTeamValue = '';
                            if($compareTeamTeamName !='')
                            {
                                $compareTeamDtls = array_values(array_filter($machineCapacityForUniverse, function($var) use ($compareTeamTeamName)
                                {
                                    return ($var['TEAM_LOGO_NAME'] == $compareTeamTeamName);
                                }));
                                if(count($compareTeamDtls)>0)
                                {
                                    $compareTeamValue = $compareTeamDtls[0]['CAPACITY'];
                                }                    
                            }
                            $responsearray[$i]['COMPARED_TEAM_VALUE'] = $compareTeamValue;
                        }
                        else
                        {
                            $responsearray[$i] = $this -> missionNotAchievedRecord($i,$responsearray[$i]);
                        }                        
                    }
                    else
                    {
                        $responsearray[$i] = $this -> missionNotAchievedRecord($i,$responsearray[$i]);
                    }    
                }
                else
                {
                    $responsearray[$i] = $this -> missionNotAchievedRecord($i,$responsearray[$i]);
                }     
            }
            //to check highest production efficiency mission
            else if($mission['MISSION_TITLE'] == 'PRODUCTION_EFFICIENCY')
            {       
                $universeTeamsquarterStatus = $this -> Game_model ->getQtrStatusforAllTeamInUniverse($universeToken, $mission['TARGET_YEAR'], $mission['TARGET_QUARTER']); 
                if(count($universeTeamsquarterStatus)>0)
                {
                    if(!in_array("In-Progress", array_column($universeTeamsquarterStatus, 'Qstatus')))  
                    {    
                        $productionEfficiencyForUniverse = $this->Dashboard_model->getProductionDtlsforUniverse($universeToken, $mission['TARGET_YEAR'], $mission['TARGET_QUARTER'],3);
                        if(count($productionEfficiencyForUniverse) > 0)
                        {
                            $productionMissionDtls = $this->checkCommonMission($mission, $productionEfficiencyForUniverse,$convertionType);
                            if($productionMissionDtls[0]!="")
                            {
                                $achieved=$this->getMissionStatus($gameBatchId,$mission,$productionMissionDtls);
                                if(count($achieved)>0)
                                {
                                    $missionAchievedArray[$j]=$achieved;
                                    $j++;
                                }
                            }
                            $responsearray[$i]['TEAM_NAME'] = $productionMissionDtls[0];
                            $responsearray[$i]['VALUE'] = $productionMissionDtls[1];
                            $responsearray[$i]['TEAM_LOGO_PATH'] = $productionMissionDtls[2];
                            //fetch particular team(compare team) details for mission
                            $compareTeamValue = '';
                            if($compareTeamTeamName !='')
                            {
                                $compareTeamDtls = array_values(array_filter($productionEfficiencyForUniverse, function($var) use ($compareTeamTeamName)
                                {
                                    return ($var['TEAM_LOGO_NAME'] == $compareTeamTeamName);
                                }));
                                if(count($compareTeamDtls)>0)
                                {
                                    $compareTeamValue = $compareTeamDtls[0]['PRODUCTION_EFFICIENCY'];
                                }                    
                            }
                            $responsearray[$i]['COMPARED_TEAM_VALUE'] = $compareTeamValue;
                        }
                        else
                        {
                            $responsearray[$i] = $this -> missionNotAchievedRecord($i,$responsearray[$i]);
                        }                        
                    }
                    else
                    {
                        $responsearray[$i] = $this -> missionNotAchievedRecord($i,$responsearray[$i]);
                    }
                }
                else
                {
                    $responsearray[$i] = $this -> missionNotAchievedRecord($i,$responsearray[$i]);
                }
            }
            //to check which first 25k products produced mission
            else if($mission['MISSION_TITLE'] == 'PRODUCTS_PRODUCED')
            {
                $flag=false;
                $targetProdProducedTeamName="";
                $targetProdProducedValue ="";
                $targetProdProducedTeamLogo = "";
                $ProdProducedDetailsofUniverse = array();
                if($mission['TARGET_YEAR'] > 1)
                {
                    for($year = 1; $year <= $mission['TARGET_YEAR']; $year++)
                    {
                        if($mission['TARGET_QUARTER'] > 1)
                        {
                            for($qtr = 1; $qtr <= $mission['TARGET_QUARTER']; $qtr++)
                            {                                
                                $universeTeamsquarterStatus = $this -> Game_model ->getQtrStatusforAllTeamInUniverse($universeToken, $year, $qtr); 
                                if(count($universeTeamsquarterStatus)>0)
                                {
                                    if(!in_array("In-Progress", array_column($universeTeamsquarterStatus, 'Qstatus')))  
                                    {
                                        $productsProducedforUniverse = $this->Dashboard_model->getProductionDtlsforUniverse($universeToken, $mission['TARGET_YEAR'], $mission['TARGET_QUARTER'], 2);  
                                        $productionMissionDtls = $this->checkCommonMission($mission, $productsProducedforUniverse,$convertionType);
                                        if($productionMissionDtls[0]!="")
                                        {
                                            $achieved=$this->getMissionStatus($gameBatchId,$mission,$productionMissionDtls);
                                            if(count($achieved)>0)
                                            {
                                                $missionAchievedArray[$j]=$achieved;
                                                $j++;
                                            }
                                            $targetProdProducedTeamName = $productionMissionDtls[0];
                                            $targetProdProducedValue = $productionMissionDtls[1]; 
                                            $targetProdProducedTeamLogo = $productionMissionDtls[2];
                                            $flag = true;
                                            break;
                                        }          
                                    }
                                }
                            }
                        }
                        else
                        {
                            $universeTeamsquarterStatus = $this -> Game_model ->getQtrStatusforAllTeamInUniverse($universeToken, $year, $mission['TARGET_QUARTER']); 
                            if(count($universeTeamsquarterStatus)>0)
                            {
                                if(!in_array("In-Progress", array_column($universeTeamsquarterStatus, 'Qstatus')))  
                                {
                                    $productsProducedforUniverse = $this->Dashboard_model->getProductionDtlsforUniverse($universeToken, $mission['TARGET_YEAR'], $mission['TARGET_QUARTER'], 2);                
                                    $productionMissionDtls = $this->checkCommonMission($mission, $productsProducedforUniverse,$convertionType);
                                    if($productionMissionDtls[0]!="")
                                    {
                                        $achieved=$this->getMissionStatus($gameBatchId,$mission,$productionMissionDtls);
                                        if(count($achieved)>0)
                                        {
                                            $missionAchievedArray[$j]=$achieved;
                                            $j++;
                                        }
                                        $targetProdProducedTeamName = $productionMissionDtls[0];
                                        $targetProdProducedValue = $productionMissionDtls[1]; 
                                        $targetProdProducedTeamLogo = $productionMissionDtls[2];
                                        $flag = true;
                                        break;
                                    }
                                }
                            }
                        }
                        if($flag==true)
                        {
                            break;
                        }
                    }                    
                }
                else
                {
                    if($mission['TARGET_QUARTER'] > 1)
                    {
                        for($qtr = 1; $qtr <= $mission['TARGET_QUARTER']; $qtr++)
                        {
                            $universeTeamsquarterStatus = $this -> Game_model ->getQtrStatusforAllTeamInUniverse($universeToken, $mission['TARGET_YEAR'], $qtr); 
                            if(count($universeTeamsquarterStatus)>0)
                            {
                                if(!in_array("In-Progress", array_column($universeTeamsquarterStatus, 'Qstatus')))  
                                {
                                    $productsProducedforUniverse = $this->Dashboard_model->getProductionDtlsforUniverse($universeToken, $mission['TARGET_YEAR'], $mission['TARGET_QUARTER'], 2);                
                                    $productionMissionDtls = $this->checkCommonMission($mission, $productsProducedforUniverse,$convertionType);
                                    if($productionMissionDtls[0]!="")
                                    {
                                        $achieved=$this->getMissionStatus($gameBatchId,$mission,$productionMissionDtls);
                                        if(count($achieved)>0)
                                        {
                                            $missionAchievedArray[$j]=$achieved;
                                            $j++;
                                        }
                                        $targetProdProducedTeamName = $productionMissionDtls[0];
                                        $targetProdProducedValue = $productionMissionDtls[1]; 
                                        $targetProdProducedTeamLogo = $productionMissionDtls[2];
                                        $flag = true;
                                        break;
                                    }
                                }
                            }
                        }
                    }
                    else
                    {
                        $universeTeamsquarterStatus = $this -> Game_model ->getQtrStatusforAllTeamInUniverse($universeToken, $mission['TARGET_YEAR'], $mission['TARGET_QUARTER']); 
                        if(count($universeTeamsquarterStatus)>0)
                        {
                            if(!in_array("In-Progress", array_column($universeTeamsquarterStatus, 'Qstatus')))  
                            {
                                $productsProducedforUniverse = $this->Dashboard_model->getProductionDtlsforUniverse($universeToken, $mission['TARGET_YEAR'], $mission['TARGET_QUARTER'], 2);                
                                $productionMissionDtls = $this->checkCommonMission($mission, $productsProducedforUniverse,$convertionType);
                                if($productionMissionDtls[0]!="")
                                {
                                    $achieved=$this->getMissionStatus($gameBatchId,$mission,$productionMissionDtls);
                                    if(count($achieved)>0)
                                    {
                                        $missionAchievedArray[$j]=$achieved;
                                        $j++;
                                    }
                                    $targetProdProducedTeamName = $productionMissionDtls[0];
                                    $targetProdProducedValue = $productionMissionDtls[1]; 
                                    $targetProdProducedTeamLogo = $productionMissionDtls[2];
                                    $flag = true;
                                    break;
                                }
                            }
                        }
                    }
                }
                $responsearray[$i]['TEAM_NAME'] = $targetProdProducedTeamName;
                $responsearray[$i]['VALUE'] = $targetProdProducedValue; 
                $responsearray[$i]['TEAM_LOGO_PATH'] = $targetProdProducedTeamLogo;

                //fetch particular team(compare team) details for mission
                $compareTeamValue = '';
                if($compareTeamTeamName !='')
                {
                    $compareTeamDtls = array_values(array_filter($productsProducedforUniverse, function($var) use ($compareTeamTeamName)
                    {
                        return ($var['TEAM_LOGO_NAME'] == $compareTeamTeamName);
                    }));
                    if(count($compareTeamDtls)>0)
                    {
                        $compareTeamValue = $compareTeamDtls[0]['PRODUCTS_PRODUCED'];
                    }
                }
                $responsearray[$i]['COMPARED_TEAM_VALUE'] = $compareTeamValue;
            }
            //to check highest edi score mission
            else if($mission['MISSION_TITLE'] == 'EDI_SCORE')
            {
                $universeTeamsquarterStatus = $this -> Game_model ->getQtrStatusforAllTeamInUniverse($universeToken, $mission['TARGET_YEAR'], $mission['TARGET_QUARTER']); 
                if(count($universeTeamsquarterStatus)>0)
                {
                    if(!in_array("In-Progress", array_column($universeTeamsquarterStatus, 'Qstatus')))  
                    {
                        $ediDetailsforUniverse = $this -> Dashboard_model ->getWiningCriteriaforUniverse($universeToken, $mission['TARGET_YEAR'], $mission['TARGET_QUARTER'], "EDI");            
                        $winningCriterisMissionDtls = $this ->checkWinningCriteriaMission($mission, $ediDetailsforUniverse,$convertionType);
                        if($winningCriterisMissionDtls[0]!="")
                        {
                            $achieved=$this->getMissionStatus($gameBatchId,$mission,$winningCriterisMissionDtls);
                            if(count($achieved)>0)
                            {
                                $missionAchievedArray[$j]=$achieved;
                                $j++;
                            }
                        }
                        $responsearray[$i]['TEAM_NAME'] = $winningCriterisMissionDtls[0];
                        $responsearray[$i]['VALUE'] = $winningCriterisMissionDtls[1];   
                        $responsearray[$i]['TEAM_LOGO_PATH'] = $winningCriterisMissionDtls[2];
                        //fetch particular team(compare team) details for mission
                        $compareTeamValue = '';
                        if($compareTeamTeamName !='')
                        {
                            $compareTeamDtls = array_values(array_filter($ediDetailsforUniverse, function($var) use ($compareTeamTeamName)
                            {
                                return ($var['TEAM_LOGO_NAME'] == $compareTeamTeamName);
                            }));
                            if(count($compareTeamDtls)>0)
                            {
                                $compareTeamValue = $compareTeamDtls[0]['ACTUAL_VALUE'];
                            }
                        }
                        $responsearray[$i]['COMPARED_TEAM_VALUE'] = $compareTeamValue;
                    }                
                    else
                    {
                        $responsearray[$i] = $this -> missionNotAchievedRecord($i,$responsearray[$i]);
                    }
                }
                else
                {
                    $responsearray[$i] = $this -> missionNotAchievedRecord($i,$responsearray[$i]);
                }
            }
            //to check highest recruitment efficiency mission
            else if($mission['MISSION_TITLE'] == 'RECRUITMENT_EFFICIENCY')
            {
                $universeTeamsquarterStatus = $this -> Game_model ->getQtrStatusforAllTeamInUniverse($universeToken, $mission['TARGET_YEAR'], $mission['TARGET_QUARTER']); 
                if(count($universeTeamsquarterStatus)>0)
                {
                    if(!in_array("In-Progress", array_column($universeTeamsquarterStatus, 'Qstatus')))  
                    {
                        $recruitmentEfficiencyforUniverse = $this -> Dashboard_model -> hrRecruitmentEfficiencyforUniverse($universeToken, $mission['TARGET_YEAR'], $mission['TARGET_QUARTER']);
                        if(count($recruitmentEfficiencyforUniverse) > 0)
                        {
                            $recruitmentMissionDtls = $this -> checkRecruitmentMission($mission, $recruitmentEfficiencyforUniverse);
                            if($recruitmentMissionDtls[0]!="")
                            {
                                $achieved=$this->getMissionStatus($gameBatchId,$mission,$recruitmentMissionDtls);
                                if(count($achieved)>0)
                                {
                                    $missionAchievedArray[$j]=$achieved;
                                    $j++;
                                }
                            }
                            $responsearray[$i]['TEAM_NAME'] = $recruitmentMissionDtls[0];
                            $responsearray[$i]['VALUE'] = $recruitmentMissionDtls[1]; 
                            $responsearray[$i]['TEAM_LOGO_PATH'] = $recruitmentMissionDtls[2];
                            //fetch particular team(compare team) details for mission
                            $compareTeamValue = '';
                            if($compareTeamTeamName !='')
                            {
                                $compareTeamDtls = array_values(array_filter($recruitmentEfficiencyforUniverse, function($var) use ($compareTeamTeamName)
                                {
                                    return ($var['TEAM_LOGO_NAME'] == $compareTeamTeamName);
                                }));
                                if(count($compareTeamDtls)>0)
                                {
                                    $compareTeamValue = $compareTeamDtls[0]['RECRUITMENT_EFFICIENCY_PERCENT'];
                                }
                            }
                            $responsearray[$i]['COMPARED_TEAM_VALUE'] = $compareTeamValue;
                        }
                        else
                        {
                            $responsearray[$i] = $this -> missionNotAchievedRecord($i,$responsearray[$i]);
                        }                        
                    }                
                    else
                    {
                        $responsearray[$i] = $this -> missionNotAchievedRecord($i,$responsearray[$i]);
                    }               
                }
                else
                {
                    $responsearray[$i] = $this -> missionNotAchievedRecord($i,$responsearray[$i]);
                }
            }
            //to check lowest attrition percentage mission
            else if($mission['MISSION_TITLE'] == 'ATTRITION')
            {
                $universeTeamsquarterStatus = $this -> Game_model ->getQtrStatusforAllTeamInUniverse($universeToken, $mission['TARGET_YEAR'], $mission['TARGET_QUARTER']); 
                if(count($universeTeamsquarterStatus)>0)
                {
                    if(!in_array("In-Progress", array_column($universeTeamsquarterStatus, 'Qstatus')))  
                    {
                        $attritionPercentforUniverse = $this -> Dashboard_model -> hrAttritionPercentageforUniverse($universeToken, $mission['TARGET_YEAR'], $mission['TARGET_QUARTER']);
                        $attritionMissionDtls = $this -> checkAttritionMission($mission, $attritionPercentforUniverse);
                        if($attritionMissionDtls[0]!="")
                        {
                            $achieved=$this->getMissionStatus($gameBatchId,$mission,$attritionMissionDtls);
                            if(count($achieved)>0)
                            {
                                $missionAchievedArray[$j]=$achieved;
                                $j++;
                            }
                        }
                        $responsearray[$i]['TEAM_NAME'] = $attritionMissionDtls[0];
                        $responsearray[$i]['VALUE'] = $attritionMissionDtls[1]; 
                        $responsearray[$i]['TEAM_LOGO_PATH'] = $attritionMissionDtls[2];
                        //fetch particular team(compare team) details for mission
                        $compareTeamValue = '';
                        if($compareTeamTeamName !='')
                        {
                            $compareTeamDtls = array_values(array_filter($attritionPercentforUniverse, function($var) use ($compareTeamTeamName)
                            {
                                return ($var['TEAM_LOGO_NAME'] == $compareTeamTeamName);
                            }));
                            if(count($compareTeamDtls)>0)
                            {
                                $compareTeamValue = $compareTeamDtls[0]['ATTRITION_PERCENTAGE'];
                            }
                        }
                        $responsearray[$i]['COMPARED_TEAM_VALUE'] = $compareTeamValue;
                    }                
                    else
                    {
                        $responsearray[$i] = $this -> missionNotAchievedRecord($i,$responsearray[$i]);
                    }
                }
                else
                {
                    $responsearray[$i] = $this -> missionNotAchievedRecord($i,$responsearray[$i]);
                }
            }
            //to check highest revenue in quarter mission
            else if($mission['MISSION_TITLE'] == 'FIRST_QTR_REVENUE')
            {
                $universeTeamsquarterStatus = $this -> Game_model ->getQtrStatusforAllTeamInUniverse($universeToken, $mission['TARGET_YEAR'], $mission['TARGET_QUARTER']); 
                if(count($universeTeamsquarterStatus)>0)
                {
                    if(!in_array("In-Progress", array_column($universeTeamsquarterStatus, 'Qstatus')))  
                    {
                        $revenueDetailsforUniverse = $this -> Dashboard_model ->getWiningCriteriaforUniverse($universeToken, $mission['TARGET_YEAR'], $mission['TARGET_QUARTER'], "REVENUE GROWTH");
                        $winningCriterisMissionDtls = $this ->checkWinningCriteriaMission($mission, $revenueDetailsforUniverse,$convertionType);
                        if($winningCriterisMissionDtls[0]!="")
                        {
                            $achieved=$this->getMissionStatus($gameBatchId,$mission,$winningCriterisMissionDtls);
                            if(count($achieved)>0)
                            {
                                $missionAchievedArray[$j]=$achieved;
                                $j++;
                            }
                        }
                        $responsearray[$i]['TEAM_NAME'] = $winningCriterisMissionDtls[0];
                        $actualValue = explode (";", $winningCriterisMissionDtls[1]);
                        $winningvalue = "";
                        if(count($actualValue) >1)
                        {                   
                            for($k=0;$k<count($actualValue);$k++)
                            {
                                //$value[$i] =  round($value[$i]/10000000,2)."Cr";
                                if($k==0)
                                {
                                    $winningvalue = $actualValue[$k];
                                }
                                else
                                {
                                    $winningvalue = $winningvalue.";".$actualValue[$k];
                                }
                            }
                        }
                        else if($actualValue[0]!="")
                        {
                            $winningvalue = $actualValue[0];
                        }
                        $responsearray[$i]['VALUE'] = $winningvalue; 
                        $responsearray[$i]['TEAM_LOGO_PATH'] = $winningCriterisMissionDtls[2];

                        //fetch particular team(compare team) details for mission
                        $compareTeamValue = '';
                        if($compareTeamTeamName !='')
                        {
                            $compareTeamDtls = array_values(array_filter($revenueDetailsforUniverse, function($var) use ($compareTeamTeamName)
                            {
                                return ($var['TEAM_LOGO_NAME'] == $compareTeamTeamName);
                            }));
                            if(count($compareTeamDtls)>0)
                            {
                                $compareTeamValue = $compareTeamDtls[0]['ACTUAL_VALUE'];
                            }
                        }
                        $responsearray[$i]['COMPARED_TEAM_VALUE'] = $compareTeamValue;
                    }                
                    else
                    {
                        $responsearray[$i] = $this -> missionNotAchievedRecord($i,$responsearray[$i]);
                    }
                }
                else
                {
                    $responsearray[$i] = $this -> missionNotAchievedRecord($i,$responsearray[$i]);
                }
            }
            //to check first team to achieve revenue target mission
            else if($mission['MISSION_TITLE'] == 'REVENUE_TARGET')
            {
                $flag=false;
                $targetRevenueTeamName="";
                $targetRevenueValue ="";
                $targetRevenueTeamLogo = "";
                $revenueDetailsofUniverse = array();
                if($mission['TARGET_YEAR'] > 1)
                {
                    for($year = 1; $year <= $mission['TARGET_YEAR']; $year++)
                    {
                        if($mission['TARGET_QUARTER'] > 1)
                        {
                            for($qtr = 1; $qtr <= $mission['TARGET_QUARTER']; $qtr++)
                            {
                                $universeTeamsquarterStatus = $this -> Game_model ->getQtrStatusforAllTeamInUniverse($universeToken, $year, $qtr); 
                                if(count($universeTeamsquarterStatus)>0)
                                {
                                    if(!in_array("In-Progress", array_column($universeTeamsquarterStatus, 'Qstatus')))  
                                    {
                                        $revenueDetailsofUniverse = $this -> Dashboard_model ->getWiningCriteriaforUniverse($universeToken, $year, $qtr, "REVENUE GROWTH");
                                        $winningCriterisMissionDtls = $this ->checkWinningCriteriaMission($mission, $revenueDetailsofUniverse,$convertionType);
                                        if($winningCriterisMissionDtls[0] != "")
                                        {
                                            $achieved=$this->getMissionStatus($gameBatchId,$mission,$winningCriterisMissionDtls);
                                            if(count($achieved)>0)
                                            {
                                                $missionAchievedArray[$j]=$achieved;
                                                $j++;
                                            }
                                            $targetRevenueTeamName = $winningCriterisMissionDtls[0];
                                            $targetRevenueValue = $winningCriterisMissionDtls[1]; 
                                            $targetRevenueTeamLogo = $winningCriterisMissionDtls[2];
                                            $flag = true;
                                            break;
                                        }
                                    }
                                }
                            }
                        }
                        else
                        {
                            $universeTeamsquarterStatus = $this -> Game_model ->getQtrStatusforAllTeamInUniverse($universeToken, $year, $mission['TARGET_QUARTER']); 
                            if(count($universeTeamsquarterStatus)>0)
                            {
                                if(!in_array("In-Progress", array_column($universeTeamsquarterStatus, 'Qstatus')))  
                                {
                                    $revenueDetailsofUniverse = $this -> Dashboard_model ->getWiningCriteriaforUniverse($universeToken, $year, $mission['TARGET_QUARTER'], "REVENUE GROWTH");
                                    $winningCriterisMissionDtls = $this ->checkWinningCriteriaMission($mission, $revenueDetailsofUniverse,$convertionType);
                                    if($winningCriterisMissionDtls[0] != "")
                                    {
                                        $achieved=$this->getMissionStatus($gameBatchId,$mission,$winningCriterisMissionDtls);
                                        if(count($achieved)>0)
                                        {
                                            $missionAchievedArray[$j]=$achieved;
                                            $j++;
                                        }
                                        $targetRevenueTeamName = $winningCriterisMissionDtls[0];
                                        $targetRevenueValue = $winningCriterisMissionDtls[1]; 
                                        $targetRevenueTeamLogo = $winningCriterisMissionDtls[2];
                                        $flag = true;
                                    }
                                }
                            }
                        }
                        if($flag==true)
                        {
                            break;
                        }
                    }                    
                }
                else
                {
                    if($mission['TARGET_QUARTER'] > 1)
                    {
                        for($qtr = 1; $qtr <= $mission['TARGET_QUARTER']; $qtr++)
                        {
                            $universeTeamsquarterStatus = $this -> Game_model ->getQtrStatusforAllTeamInUniverse($universeToken, $mission['TARGET_YEAR'], $qtr); 
                            if(count($universeTeamsquarterStatus)>0)
                            {
                                if(!in_array("In-Progress", array_column($universeTeamsquarterStatus, 'Qstatus')))  
                                {
                                    $revenueDetailsofUniverse = $this -> Dashboard_model ->getWiningCriteriaforUniverse($universeToken, $mission['TARGET_YEAR'], $qtr, "REVENUE GROWTH");
                                    $winningCriterisMissionDtls = $this ->checkWinningCriteriaMission($mission, $revenueDetailsofUniverse,$convertionType);
                                    if($winningCriterisMissionDtls[0] != "")
                                    {
                                        $achieved=$this->getMissionStatus($gameBatchId,$mission,$winningCriterisMissionDtls);
                                        if(count($achieved)>0)
                                        {
                                            $missionAchievedArray[$j]=$achieved;
                                            $j++;
                                        }
                                        $targetRevenueTeamName = $winningCriterisMissionDtls[0];
                                        $targetRevenueValue = $winningCriterisMissionDtls[1]; 
                                        $targetRevenueTeamLogo = $winningCriterisMissionDtls[2];
                                        $flag = true;
                                        break;
                                    }
                                }
                            }
                        }
                    }
                    else
                    {
                        $universeTeamsquarterStatus = $this -> Game_model ->getQtrStatusforAllTeamInUniverse($universeToken, $mission['TARGET_YEAR'], $mission['TARGET_QUARTER']); 
                        if(count($universeTeamsquarterStatus)>0)
                        {
                            if(!in_array("In-Progress", array_column($universeTeamsquarterStatus, 'Qstatus')))  
                            {
                                $revenueDetailsofUniverse = $this -> Dashboard_model ->getWiningCriteriaforUniverse($universeToken, $mission['TARGET_YEAR'], $mission['TARGET_QUARTER'], "REVENUE GROWTH");
                                $winningCriterisMissionDtls = $this ->checkWinningCriteriaMission($mission, $revenueDetailsofUniverse,$convertionType);
                                if($winningCriterisMissionDtls[0] != "")
                                {
                                    $achieved=$this->getMissionStatus($gameBatchId,$mission,$winningCriterisMissionDtls);
                                    if(count($achieved)>0)
                                    {
                                        $missionAchievedArray[$j]=$achieved;
                                        $j++;
                                    }
                                    $targetRevenueTeamName = $winningCriterisMissionDtls[0];
                                    $targetRevenueValue = $winningCriterisMissionDtls[1]; 
                                    $targetRevenueTeamLogo = $winningCriterisMissionDtls[2];
                                }
                            }
                        }
                    }
                }
                $responsearray[$i]['TEAM_NAME'] = $targetRevenueTeamName;
                $actualValue = explode (";", $targetRevenueValue);
                $winningvalue = "";
                if(count($actualValue) >1)
                {                   
                    for($k=0;$k<count($actualValue);$k++)
                    {
                        //$value[$i] =  round($value[$i]/10000000,2)."Cr";
                        if($k==0)
                        {
                            $winningvalue = $actualValue[$k];
                        }
                        else
                        {
                            $winningvalue = $winningvalue.";".$actualValue[$k];
                        }
                    }
                }
                else if(count($actualValue)>0 && $actualValue[0]!="")
                {
                    $winningvalue = $actualValue[0];
                }
                $responsearray[$i]['VALUE'] = $winningvalue; 
               // $responsearray[$i]['VALUE'] = $targetRevenueValue; 
                $responsearray[$i]['TEAM_LOGO_PATH'] = $targetRevenueTeamLogo;

                //fetch particular team(compare team) details for mission
                $compareTeamValue = '';
                if($compareTeamTeamName !='')
                {
                    $compareTeamDtls = array_values(array_filter($revenueDetailsofUniverse, function($var) use ($compareTeamTeamName)
                    {
                        return ($var['TEAM_LOGO_NAME'] == $compareTeamTeamName);
                    }));
                    if(count($compareTeamDtls)>0)
                    {
                        $compareTeamValue = $compareTeamDtls[0]['ACTUAL_VALUE'];
                    }
                }
                $responsearray[$i]['COMPARED_TEAM_VALUE'] = $compareTeamValue;
            }
            //to check highest sales efficiency mission
            else if($mission['MISSION_TITLE'] == 'SALES_EFFICIENCY')
            {
                $universeTeamsquarterStatus = $this -> Game_model ->getQtrStatusforAllTeamInUniverse($universeToken, $mission['TARGET_YEAR'], $mission['TARGET_QUARTER']); 
                if(count($universeTeamsquarterStatus)>0)
                {
                    if(!in_array("In-Progress", array_column($universeTeamsquarterStatus, 'Qstatus')))  
                    {
                        $salesEfficiencyforUniverse = $this->Dashboard_model->getProductsSoldDetailsforUniverse($universeToken, $mission['TARGET_YEAR'], $mission['TARGET_QUARTER'], 3);     
                        $productSoldMissionDtls = $this -> checkCommonMission($mission, $salesEfficiencyforUniverse,$convertionType);
                        if($productSoldMissionDtls[0]!="")
                        {
                            $achieved=$this->getMissionStatus($gameBatchId,$mission,$productSoldMissionDtls);
                            if(count($achieved)>0)
                            {
                                $missionAchievedArray[$j]=$achieved;
                                $j++;
                            }
                        }
                        $responsearray[$i]['TEAM_NAME'] = $productSoldMissionDtls[0];
                        $responsearray[$i]['VALUE'] = $productSoldMissionDtls[1];
                        $responsearray[$i]['TEAM_LOGO_PATH'] = $productSoldMissionDtls[2];

                        //fetch particular team(compare team) details for mission
                        $compareTeamValue = '';
                        if($compareTeamTeamName !='')
                        {
                            $compareTeamDtls = array_values(array_filter($salesEfficiencyforUniverse, function($var) use ($compareTeamTeamName)
                            {
                                return ($var['TEAM_LOGO_NAME'] == $compareTeamTeamName);
                            }));
                            if(count($compareTeamDtls)>0)
                            {
                                $compareTeamValue = $compareTeamDtls[0]['SALES_EFFICIENCY'];
                            }
                        }
                        $responsearray[$i]['COMPARED_TEAM_VALUE'] = $compareTeamValue;
                    }
                    else
                    {
                        $responsearray[$i] = $this -> missionNotAchievedRecord($i,$responsearray[$i]);
                    }
                }
                else
                {
                    $responsearray[$i] = $this -> missionNotAchievedRecord($i,$responsearray[$i]);
                }
            }
            //to check highest products sold mission
            else if($mission['MISSION_TITLE'] == 'PRODUCTS_SOLD')
            {
                $universeTeamsquarterStatus = $this -> Game_model ->getQtrStatusforAllTeamInUniverse($universeToken, $mission['TARGET_YEAR'], $mission['TARGET_QUARTER']); 
                if(count($universeTeamsquarterStatus)>0)
                {
                    if(!in_array("In-Progress", array_column($universeTeamsquarterStatus, 'Qstatus')))  
                    {
                        $productsSoldforUniverse = $this->Dashboard_model->getProductsSoldDetailsforUniverse($universeToken, $mission['TARGET_YEAR'], $mission['TARGET_QUARTER'], 2);
                        $productSoldMissionDtls = $this -> checkCommonMission($mission, $productsSoldforUniverse,$convertionType);
                        if($productSoldMissionDtls[0]!="")
                        {
                            $achieved=$this->getMissionStatus($gameBatchId,$mission,$productSoldMissionDtls);
                            if(count($achieved)>0)
                            {
                                $missionAchievedArray[$j]=$achieved;
                                $j++;
                            }
                        }
                        $responsearray[$i]['TEAM_NAME'] = $productSoldMissionDtls[0];
                        $responsearray[$i]['VALUE'] = $productSoldMissionDtls[1];
                        $responsearray[$i]['TEAM_LOGO_PATH'] = $productSoldMissionDtls[2];
                        //fetch particular team(compare team) details for mission
                        $compareTeamValue = '';
                        if($compareTeamTeamName !='')
                        {
                            $compareTeamDtls = array_values(array_filter($productsSoldforUniverse, function($var) use ($compareTeamTeamName)
                            {
                                return ($var['TEAM_LOGO_NAME'] == $compareTeamTeamName);
                            }));
                            if(count($compareTeamDtls)>0)
                            {
                                $compareTeamValue = $compareTeamDtls[0]['PRODUCTS_SOLD'];
                            }
                        }
                        $responsearray[$i]['COMPARED_TEAM_VALUE'] = $compareTeamValue;
                    }
                    else
                    {
                        $responsearray[$i] = $this -> missionNotAchievedRecord($i,$responsearray[$i]);
                    }
                }
                else
                {
                    $responsearray[$i] = $this -> missionNotAchievedRecord($i,$responsearray[$i]);
                }
            }
            //to check highest territory achieved mission
            else if($mission['MISSION_TITLE'] == 'TERRITORY_ACHIEVED')
            {
                $universeTeamsquarterStatus = $this -> Game_model ->getQtrStatusforAllTeamInUniverse($universeToken, $mission['TARGET_YEAR'], $mission['TARGET_QUARTER']); 
                if(count($universeTeamsquarterStatus)>0)
                {
                    if(!in_array("In-Progress", array_column($universeTeamsquarterStatus, 'Qstatus')))  
                    {
                        $territoryAchievedforUniverse = $this ->Dashboard_model-> getTerritoriesAchievedforUniverse($universeToken,$mission['TARGET_YEAR'], $mission['TARGET_QUARTER']);
                        $territoryAchievedMissionDtls = $this -> checkCommonMission($mission, $territoryAchievedforUniverse,$convertionType);
                        if($territoryAchievedMissionDtls[0]!="")
                        {
                            $achieved=$this->getMissionStatus($gameBatchId,$mission,$territoryAchievedMissionDtls);
                            if(count($achieved)>0)
                            {
                                $missionAchievedArray[$j]=$achieved;
                                $j++;
                            }
                        }
                        $responsearray[$i]['TEAM_NAME'] = $territoryAchievedMissionDtls[0];
                        $responsearray[$i]['VALUE'] = $territoryAchievedMissionDtls[1]; 
                        $responsearray[$i]['TEAM_LOGO_PATH'] = $territoryAchievedMissionDtls[2];

                        //fetch particular team(compare team) details for mission
                        $compareTeamValue = '';
                        if($compareTeamTeamName !='')
                        {
                            $compareTeamDtls = array_values(array_filter($territoryAchievedforUniverse, function($var) use ($compareTeamTeamName)
                            {
                                return ($var['TEAM_LOGO_NAME'] == $compareTeamTeamName);
                            }));
                            if(count($compareTeamDtls)>0)
                            {
                                $compareTeamValue = $compareTeamDtls[0]['TERRITORY_ACHIEVED'];
                            }
                        }
                        $responsearray[$i]['COMPARED_TEAM_VALUE'] = $compareTeamValue;
                    }
                    else
                    {
                        $responsearray[$i] = $this -> missionNotAchievedRecord($i,$responsearray[$i]);
                    }
                }
                else
                {
                    $responsearray[$i] = $this -> missionNotAchievedRecord($i,$responsearray[$i]);
                }
            }
            //to check highest book value mission
            else if($mission['MISSION_TITLE'] == 'BOOK_VALUE')
            {
                $universeTeamsquarterStatus = $this -> Game_model ->getQtrStatusforAllTeamInUniverse($universeToken, $mission['TARGET_YEAR'], $mission['TARGET_QUARTER']); 
                if(count($universeTeamsquarterStatus)>0)
                {
                    if(!in_array("In-Progress", array_column($universeTeamsquarterStatus, 'Qstatus')))  
                    {
                        $sharePriceDetailsforUniverse = $this -> Dashboard_model ->getWiningCriteriaforUniverse($universeToken, $mission['TARGET_YEAR'], $mission['TARGET_QUARTER'], "SHARE PRICE");
                        $winningCriterisMissionDtls = $this ->checkWinningCriteriaMission($mission, $sharePriceDetailsforUniverse,$convertionType);
                        if($winningCriterisMissionDtls[0]!="")
                        {
                            $achieved=$this->getMissionStatus($gameBatchId,$mission,$winningCriterisMissionDtls);
                            if(count($achieved)>0)
                            {
                                $missionAchievedArray[$j]=$achieved;
                                $j++;
                            }
                        }
                        $responsearray[$i]['TEAM_NAME'] = $winningCriterisMissionDtls[0];
                        $responsearray[$i]['VALUE'] = $winningCriterisMissionDtls[1];     
                        $responsearray[$i]['TEAM_LOGO_PATH'] = $winningCriterisMissionDtls[2];   
                        //fetch particular team(compare team) details for mission
                        $compareTeamValue = '';
                        if($compareTeamTeamName !='')
                        {
                            $compareTeamDtls = array_values(array_filter($sharePriceDetailsforUniverse, function($var) use ($compareTeamTeamName)
                            {
                                return ($var['TEAM_LOGO_NAME'] == $compareTeamTeamName);
                            }));
                            if(count($compareTeamDtls)>0)
                            {
                                $compareTeamValue = $compareTeamDtls[0]['ACTUAL_VALUE'];
                            }
                        }
                        $responsearray[$i]['COMPARED_TEAM_VALUE'] = $compareTeamValue;     
                    }
                    else
                    {
                        $responsearray[$i] = $this -> missionNotAchievedRecord($i,$responsearray[$i]);
                    }  
                }
                else
                {
                    $responsearray[$i] = $this -> missionNotAchievedRecord($i,$responsearray[$i]);
                } 
            }
            //to check highest PAT mission
            else if($mission['MISSION_TITLE'] == 'PAT')
            {
                $universeTeamsquarterStatus = $this -> Game_model ->getQtrStatusforAllTeamInUniverse($universeToken, $mission['TARGET_YEAR'], $mission['TARGET_QUARTER']); 
                if(count($universeTeamsquarterStatus)>0)
                {
                    if(!in_array("In-Progress", array_column($universeTeamsquarterStatus, 'Qstatus')))  
                    {
                        $PATDetailsforUniverse = $this -> Dashboard_model ->getWiningCriteriaforUniverse($universeToken, $mission['TARGET_YEAR'], $mission['TARGET_QUARTER'], "PAT");
                        $winningCriterisMissionDtls = $this ->checkWinningCriteriaMission($mission, $PATDetailsforUniverse,$convertionType);
                        if($winningCriterisMissionDtls[0]!="")
                        {
                            $achieved=$this->getMissionStatus($gameBatchId,$mission,$winningCriterisMissionDtls);
                            if(count($achieved)>0)
                            {
                                $missionAchievedArray[$j]=$achieved;
                                $j++;
                            }
                        }
                        $responsearray[$i]['TEAM_NAME'] = $winningCriterisMissionDtls[0];
                        $actualValue = explode (";", $winningCriterisMissionDtls[1]);
                        $winningvalue = "";
                        if(count($actualValue) >1)
                        {                   
                            for($k=0;$k<count($actualValue);$k++)
                            {
                                //$value[$i] =  round($value[$i]/10000000,2)."Cr";
                                if($k==0)
                                {
                                    $winningvalue = $actualValue[$k];
                                }
                                else
                                {
                                    $winningvalue = $winningvalue.";".$actualValue[$k];
                                }
                            }
                        }
                        else if($actualValue[0]!="")
                        {
                            $winningvalue = $actualValue[0];
                        }
                        $responsearray[$i]['VALUE'] = $winningvalue;
                        //$responsearray[$i]['VALUE'] = $winningCriterisMissionDtls[1]; 
                        $responsearray[$i]['TEAM_LOGO_PATH'] = $winningCriterisMissionDtls[2];  
                        //fetch particular team(compare team) details for mission
                        $compareTeamValue = '';
                        if($compareTeamTeamName !='')
                        {
                            $compareTeamDtls = array_values(array_filter($PATDetailsforUniverse, function($var) use ($compareTeamTeamName)
                            {
                                return ($var['TEAM_LOGO_NAME'] == $compareTeamTeamName);
                            }));
                            if(count($compareTeamDtls)>0)
                            {
                                $compareTeamValue = $compareTeamDtls[0]['ACTUAL_VALUE'];
                            }
                        }
                        $responsearray[$i]['COMPARED_TEAM_VALUE'] = $compareTeamValue;
                    }
                    else
                    {
                        $responsearray[$i] = $this -> missionNotAchievedRecord($i,$responsearray[$i]);
                    } 
                }
                else
                {
                    $responsearray[$i] = $this -> missionNotAchievedRecord($i,$responsearray[$i]);
                }                  
            }
            $i++;
        }
       // $sorted = array_orderby($responsearray, 'TARGET_YEAR', SORT_ASC, 'TARGET_QUARTER', SORT_ASC);
       array_multisort(array_column($responsearray, 'TARGET_YEAR'),  SORT_ASC,
                array_column($responsearray, 'TARGET_QUARTER'), SORT_ASC,
                $responsearray);
        $missiondata= array("missionDtls" => $responsearray,
            "listofTeamsInUniverse" => $listofTeamsInUniverse,
            "achievedMission" => $missionAchievedArray,
            "comparedTeamName" => $compareTeamTeamName
        );
        return $missiondata;
        
        // $data['_view'] = 'dept_dashboard/overall_performance/mission_view';
        // $this -> load -> view('layouts/main_view', $data);
    }
    function missionInFullPageView($universeToken)
    {
        $data['universetoken'] = $universeToken;
        $data['mission'] = $this -> mission($universeToken);
        $data['missionview'] = 'dept_dashboard/overall_performance/mission_view';
        $data['_view'] = 'dept_dashboard/overall_performance/overall_template_view';
        $this -> load -> view('layouts/main_view', $data);
    }
    
    function checkCommonMission($missionDtls, $productionDtls,$convertionType)
    {
        //common funtion to fetch mission achieved team based on mission Target value
        $tempData = "";
        $prodEffTeamName = "";
        $prodEffValue = "";
        $prodEffTeamLogo = "";
        if(count($productionDtls)>0)
        {
            if($missionDtls['TARGET_VALUE'] == "MAX")
            {
                foreach($productionDtls as $prodEff)
                {
                    if($tempData=="")
                    {
                        $prodEffTeamName = $prodEff['TEAM_LOGO_NAME'];
                        if(strpos( $missionDtls['MISSION_TITLE'], 'EFFICIENCY' ) == true)
                        {
                            $prodEffValue = $prodEff[$missionDtls['MISSION_TITLE']]."%";
                        }
                        else
                        {
                            $prodEffValue = $this->convertToSmallNum($prodEff[$missionDtls['MISSION_TITLE']],$convertionType);
                        }                    
                        $prodEffTeamLogo = $prodEff['TEAM_LOGO_PATH'];
                    }
                    else if((int)$prodEff[$missionDtls['MISSION_TITLE']] == (int)$tempData)
                    {
                        $prodEffTeamName = $prodEffTeamName."; ".$prodEff['TEAM_LOGO_NAME'];
                        if(strpos( $missionDtls['MISSION_TITLE'], 'EFFICIENCY' ) == true)
                        {
                            $prodEffValue = $prodEffValue."; ".$prodEff[$missionDtls['MISSION_TITLE']]."%";
                        }
                        else
                        {
                            $prodEffValue = $prodEffValue."; ".$this->convertToSmallNum($prodEff[$missionDtls['MISSION_TITLE']],$convertionType);
                        }                           
                        $prodEffTeamLogo = $prodEffTeamLogo."; ".$prodEff['TEAM_LOGO_PATH'];
                    }
                    else
                    {
                        break;
                    }
                    $tempData = $prodEff[$missionDtls['MISSION_TITLE']];
                }
            }
            else if((int)$productionDtls[0][$missionDtls['MISSION_TITLE']] >= (int)$missionDtls['TARGET_VALUE'])
            {
                foreach($productionDtls as $prodEff)
                {
                    if($tempData=="")
                    {
                        $prodEffTeamName = $prodEff['TEAM_LOGO_NAME'];
                        if(strpos( $missionDtls['MISSION_TITLE'], 'EFFICIENCY' ) == true)
                        {
                            $prodEffValue = $prodEff[$missionDtls['MISSION_TITLE']]."%";
                        }
                        else
                        {
                            $prodEffValue = $this->convertToSmallNum($prodEff[$missionDtls['MISSION_TITLE']],$convertionType);
                        } 
                        $prodEffTeamLogo = $prodEff['TEAM_LOGO_PATH'];
                    }
                    else if((int)$prodEff[$missionDtls['MISSION_TITLE']] == (int)$tempData)
                    {
                        $prodEffTeamName = $prodEffTeamName."; ".$prodEff['TEAM_LOGO_NAME'];
                        if(strpos( $missionDtls['MISSION_TITLE'], 'EFFICIENCY' ) == true)
                        {
                            $prodEffValue = $prodEffValue."; ".$prodEff[$missionDtls['MISSION_TITLE']]."%";
                        }
                        else
                        {
                            $prodEffValue = $prodEffValue."; ".$this->convertToSmallNum($prodEff[$missionDtls['MISSION_TITLE']],$convertionType);
                        } 
                        
                        $prodEffTeamLogo = $prodEffTeamLogo."; ".$prodEff['TEAM_LOGO_PATH'];
                    }
                    else
                    {
                        break;
                    }
                    $tempData = $prodEff[$missionDtls['MISSION_TITLE']];
                }
            }
        }
        return $prodMissionDtls = array($prodEffTeamName,$prodEffValue,$prodEffTeamLogo);
    }

    function checkWinningCriteriaMission($missionDtls, $winningCriteriaDtls,$convertionType)
    {
        //funtion to fetch mission achieved team based on mission Target value(i.e.,winning criteria parameters)
        $tempData = "";
        $winningCriteriaTeamName = "";
        $winningCriteriaValue = "";
        $winningCriteriaTeamLogo = "";
        if(count($winningCriteriaDtls)>0)
        {
            
            if($missionDtls['TARGET_VALUE'] == "MAX")
            {
                foreach($winningCriteriaDtls as $winCriteria)
                {
                    if($tempData=="")
                    {
                        $winningCriteriaTeamName = $winCriteria['TEAM_LOGO_NAME'];
                        $winningCriteriaValue = $this->convertToSmallNum($winCriteria['ACTUAL_VALUE'],$convertionType);
                        $winningCriteriaTeamLogo = $winCriteria['TEAM_LOGO_PATH'];
                    }
                    else if((float)$winCriteria['ACTUAL_VALUE'] == (float)$tempData)
                    {
                        $winningCriteriaTeamName = $winningCriteriaTeamName."; ".$winCriteria['TEAM_LOGO_NAME'];
                        $winningCriteriaValue = $winningCriteriaValue."; ".$this->convertToSmallNum($winCriteria['ACTUAL_VALUE'],$convertionType);
                        $winningCriteriaTeamLogo = $winningCriteriaTeamLogo."; ".$winCriteria['TEAM_LOGO_PATH'];
                    }
                    else
                    {
                        break;
                    }
                    $tempData = $winCriteria['ACTUAL_VALUE'];
                }
            }
            else if((float)$winningCriteriaDtls[0]['ACTUAL_VALUE'] >= (float)$missionDtls['TARGET_VALUE'])
            {
                foreach($winningCriteriaDtls as $winCriteria)
                {
                    if($tempData=="")
                    {
                        $winningCriteriaTeamName = $winCriteria['TEAM_LOGO_NAME'];
                        $winningCriteriaValue = $this->convertToSmallNum($winCriteria['ACTUAL_VALUE'],$convertionType);
                        $winningCriteriaTeamLogo = $winCriteria['TEAM_LOGO_PATH'];
                    }
                    else if((float)$winCriteria['ACTUAL_VALUE'] == (float)$tempData)
                    {
                        $winningCriteriaTeamName = $winningCriteriaTeamName."; ".$winCriteria['TEAM_LOGO_NAME'];
                        $winningCriteriaValue = $winningCriteriaValue."; ".$this->convertToSmallNum($winCriteria['ACTUAL_VALUE'],$convertionType);
                        $winningCriteriaTeamLogo = $winningCriteriaTeamLogo."; ".$winCriteria['TEAM_LOGO_PATH'];
                    }
                    else
                    {
                        break;
                    }
                    $tempData = $winCriteria['ACTUAL_VALUE'];
                }
            }
        }
        return $winningCriteriaMissionDtls = array($winningCriteriaTeamName,$winningCriteriaValue,$winningCriteriaTeamLogo);
    }

    function checkRecruitmentMission($missionDtls, $recruitmentDtls)
    {
        //funtion to fetch recruitment mission achieved team
        $tempData = "";
        $recruitedTeamName = "";
        $recruitedValue = "";
        $recruitedTeanLogo = "";
        if($missionDtls['TARGET_VALUE'] == "MAX")
        {
            foreach($recruitmentDtls as $recruit)
            {
                if($tempData=="")
                {
                    $recruitedTeamName = $recruit['TEAM_LOGO_NAME'];
                    $recruitedValue = $recruit['RECRUITMENT_EFFICIENCY_PERCENT']."%";
                    $recruitedTeanLogo = $recruit['TEAM_LOGO_PATH'];
                }
                else if((int)$recruit['RECRUITMENT_EFFICIENCY_PERCENT'] == (int)$tempData)
                {
                    $recruitedTeamName = $recruitedTeamName."; ".$recruit['TEAM_LOGO_NAME'];
                    $recruitedValue = $recruitedValue."; ".$recruit['RECRUITMENT_EFFICIENCY_PERCENT']."%";
                    $recruitedTeanLogo = $recruitedTeanLogo."; ".$recruit['TEAM_LOGO_PATH'];
                }
                else
                {
                    break;
                }
                $tempData = $recruit['RECRUITMENT_EFFICIENCY_PERCENT'];
            }
        }
        else if((int)$recruitmentDtls[0]['RECRUITMENT_EFFICIENCY_PERCENT'] >= (int)$missionDtls['TARGET_VALUE'])
        {
            foreach($recruitmentDtls as $recruit)
            {
                if($tempData=="")
                {
                    $recruitedTeamName = $recruit['TEAM_LOGO_NAME'];
                    $recruitedValue = $recruit['RECRUITMENT_EFFICIENCY_PERCENT']."%";
                    $recruitedTeanLogo = $recruit['TEAM_LOGO_PATH'];
                }
                else if((int)$recruit['RECRUITMENT_EFFICIENCY_PERCENT'] == (int)$tempData)
                {
                    $recruitedTeamName = $recruitedTeamName."; ".$recruit['TEAM_LOGO_NAME'];
                    $recruitedValue = $recruitedValue."; ".$recruit['RECRUITMENT_EFFICIENCY_PERCENT']."%";
                    $recruitedTeanLogo = $recruitedTeanLogo."; ".$recruit['TEAM_LOGO_PATH'];
                }
                else
                {
                    break;
                }
                $tempData = $recruit['RECRUITMENT_EFFICIENCY_PERCENT'];
            }
        }
        return $recruitmentMissionDtls = array($recruitedTeamName,$recruitedValue,$recruitedTeanLogo);
    }
    function checkAttritionMission($missionDtls, $attritionDtls)
    {
        //funtion to fetch attrition mission achieved team
        $tempData = "";
        $attritionTeamName = "";
        $attritionValue = "";
        $attritionTeamLogo = "";
        if($missionDtls['TARGET_VALUE'] == "LOW")
        {
            foreach($attritionDtls as $attrition)
            {
                if($tempData=="")
                {
                    $attritionTeamName = $attrition['TEAM_LOGO_NAME'];
                    $attritionValue = $attrition['ATTRITION_PERCENTAGE']."%";
                    $attritionTeamLogo = $attrition['TEAM_LOGO_PATH'];
                }
                else if((int)$attrition['ATTRITION_PERCENTAGE'] == (int)$tempData)
                {
                    $attritionTeamName = $attritionTeamName."; ".$attrition['TEAM_LOGO_NAME'];
                    $attritionValue = $attritionValue."; ".$attrition['ATTRITION_PERCENTAGE']."%";
                    $attritionTeamLogo = $attritionTeamLogo."; ".$attrition['TEAM_LOGO_PATH'];
                }
                else
                {
                    break;
                }
                $tempData = $attrition['ATTRITION_PERCENTAGE'];
            }
        }
        else if((int)$attritionDtls[0]['ATTRITION_PERCENTAGE'] >= (int)$missionDtls['TARGET_VALUE'])
        {
            foreach($attritionDtls as $attrition)
            {
                if($tempData=="")
                {
                    $attritionTeamName = $attrition['TEAM_LOGO_NAME'];
                    $attritionValue = $attrition['ATTRITION_PERCENTAGE']."%";
                    $attritionTeamLogo = $attrition['TEAM_LOGO_PATH'];
                }
                else if((int)$attrition['ATTRITION_PERCENTAGE'] == (int)$tempData)
                {
                    $attritionTeamName = $attritionTeamName."; ".$attrition['TEAM_LOGO_NAME'];
                    $attritionValue = $attritionValue."; ".$attrition['ATTRITION_PERCENTAGE']."%";
                    $attritionTeamLogo = $attritionTeamLogo."; ".$attrition['TEAM_LOGO_PATH'];
                }
                else
                {
                    break;
                }
                $tempData = $attrition['ATTRITION_PERCENTAGE'];
            }
        }
        return $attritionMissionDtls = array($attritionTeamName,$attritionValue,$attritionTeamLogo);
    }
    function finGrossProfitQuarterWise($costofGoodsSoldQuarterWise,$netsalesRevenueQuarterWise)
    {
        $grossMarginQuarterWise = array();
        $i = 0;
        foreach($costofGoodsSoldQuarterWise as $cogs)
        {
            foreach($netsalesRevenueQuarterWise as $netsales)
            {
                if($cogs['YEAR'] == $netsales['YEAR'])
                {
                    if($cogs['QUARTER'] == $netsales['QUARTER'])
                    {
                        $grossProfit = ($cogs['AMOUNT'] - $netsales['NET_SALES_REVENUE']);
                        if($netsales['NET_SALES_REVENUE'] == 0)
                        {
                            $grossMarginQuarterWise[$i]['GROSS_MARGIN'] = 0;
                        }
                        else
                        {
                            $grossMarginQuarterWise[$i]['GROSS_MARGIN'] = round(($grossProfit/ $netsales['NET_SALES_REVENUE'])*100,2);
                        }
                        $removed = array_shift($netsalesRevenueQuarterWise);
                        break;
                    }
                    else
                    {
                        $grossMarginQuarterWise[$i]['GROSS_MARGIN'] = 0;
                        break;
                    }
                }
                else
                {
                    $grossMarginQuarterWise[$i]['GROSS_MARGIN'] = 0;
                    break;
                }                
            }
            $grossMarginQuarterWise[$i]['YEAR'] = $cogs['YEAR'];
            $grossMarginQuarterWise[$i]['QUARTER'] = $cogs['QUARTER'];
            $i++;
        }
        
        return $grossMarginQuarterWise;
    }
    function getMissionStatus($gameBatchId,$mission,$missionAchievedDtls)
    {
        $missionAchievedArray=array();
        $missionStatus = $this -> Gamemasters_model->getMissionUniverseStatusForMissionId($gameBatchId, $mission['MISSION_ID']);
        if($missionStatus[0]['ACHIEVED_STATUS'] !="Y")
        {
            $this -> Gamemasters_model->updateMissionAchievedStatusForUniverse("Y",$gameBatchId, $mission['MISSION_ID']);
            $missionAchievedArray['MISSION'] = $mission['MISSION_DESC'];
            $missionAchievedArray['TEAM_NAME'] = $missionAchievedDtls[0];
            $missionAchievedArray['VALUE'] = $missionAchievedDtls[1];
           // $j++;
        }
        return $missionAchievedArray;
    }
    function missionNotAchievedRecord($index,$missionDtls)
    {
        $missionEmptyRecord = array();
        $missionEmptyRecord = $missionDtls;
        $missionEmptyRecord['TEAM_NAME'] = "";
        $missionEmptyRecord['VALUE'] = "";
        $missionEmptyRecord['TEAM_LOGO_PATH'] = "";  
        $missionEmptyRecord['COMPARED_TEAM_VALUE'] = "";
        return $missionEmptyRecord;
    }
    function teamDetailforteamName($teamName)
    {
        //$teamName=str_replace('%20',' ', $teamName);
        $teamName=urldecode($teamName);
        $this->load ->model('Game_model');
         $teamInfos = $this -> Game_model -> getTeamsForTeamName($teamName);
        // var_dump($teamInfos[0]['TEAM_ID']);
        $teamId = $teamInfos[0]['TEAM_ID'];
       
            $teamDtls = $this -> Game_model -> getPlayerInfoForTeamId( $teamId);
      
       $tableData = array("teamDtls"=>$teamDtls);
        echo json_encode($tableData);
        
    }
    function intelligentAlert($gameId, $teamId, $moveNo)
    {
        $this->load ->model('Game_model');
        $this -> load -> library('rest', array('server' => straupAPIBaseURL . 'IntelligentAlertController/', 
                                                'http_user' => 'admin', 
                                                'http_pass' => '1234', 
                                                'http_auth' => 'digest' // or 'digest'
                                                )
                                );
        $intelligentAlert = $this -> rest -> get('getIntelligentAlertsforTeam?gameId='.$gameId.'&teamId='.$teamId.'&moveNo='.$moveNo);
       
         $data['_view'] = 'intelligentAlert_view';
        $data['data'] = $intelligentAlert;
         $this -> load -> view('layouts/main_view', $data);
      // $this -> load -> view('leaderboard_view', $lb, TRUE);
        
    }
}
