<?php
class Login extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->helper(array('form','url','html'));
		$this->load->library(array('session', 'form_validation'));
           $this->load->library('facebook');
		   //$this->load->library('Curl');
		$this->load->database();
		$this->load->model('user_model');
        //unset($_SESSION['msg']); // Need to check if this line is required if the reset password are sent through mail.
	}
    public function index()
    {
		/* Read 'code' from URL
		Get email_id from linked in for code
		If email id does not exist create entry
		else
		If code not matches with email in database, replace code
		set session data for logged in user store only id
		User session data for further services - get email from db and fire from server only
		*/
		$this -> load -> model('Gamemasters_model');
		if(isset($_GET['code']))
		{
			$code = $_GET['code'];
			//echo $code;
			$token = $this -> getLinkedinAccessToken($code);
			$email = $this -> getLinkedinEmail($token);
			$userurl = 'https://api.linkedin.com/v2/me';
			$userText = $this -> linkedinGetRequest($userurl,$token);
			
			$posturl = 'https://api.linkedin.com/v2/ugcPosts';
			$postparams = array('author'=>'urn:li:person:'.$userText['id'],'lifecycleState'=>'PUBLISHED','specificContent'=>
							array('com.linkedin.ugc.ShareContent'=>
								array('shareCommentary'=>
									array('text'=>'Siva Loggedin to Biz Games'),
									'shareMediaCategory'=>'NONE')),
									'visibility'=>array('com.linkedin.ugc.MemberNetworkVisibility'=>'CONNECTIONS'));
			$postText = $this -> linkedinPostRequest($posturl,$postparams,$token);	
		//	var_dump($postparams);
		//	var_dump($postText);
			$output = $postText;
		}
		else
		{

		}
		$data['banner'] = json_decode(json_encode($this -> Gamemasters_model -> getbanner()),true);
		$data['gameCategoryList'] = json_decode(json_encode($this -> Gamemasters_model -> getGameCategoryList()),true);
		$data['getGameList'] = json_decode(json_encode($this -> Gamemasters_model -> getGameList()),true);
		$data['getClientList'] = json_decode(json_encode($this -> Gamemasters_model -> getClientList()),true);
		$data['getTesimonialsList'] = json_decode(json_encode($this -> Gamemasters_model -> getTesimonialsList()),true);
		$data['gameTopFourList'] = json_decode(json_encode($this -> Gamemasters_model -> gameOtherCatGameList()),true);
        $data['occupationmstr'] = json_decode(json_encode($this -> Gamemasters_model -> getOccupationMstr()),true);
        $data['organisationmstr'] = json_decode(json_encode($this -> Gamemasters_model -> getUserOrganisationMstr()),true);
        $data['locationmstr'] = json_decode(json_encode($this -> Gamemasters_model -> getUserLocationMstr()),true);
        $data['campaignList'] = json_decode(json_encode($this -> Gamemasters_model -> getCampaignList()), true);
        $UserPCdtls = $this->getuserPCinfo();
        $UserPCOS = explode(' ',$UserPCdtls['os']);
        if($UserPCOS[0]=='Mac')
        {
            $data['downloadStratup']=json_decode(json_encode($this -> Gamemasters_model -> getDownloadlink(0,$UserPCOS[0])), true);
        }
        else{
            $data['downloadStratup']=json_decode(json_encode($this -> Gamemasters_model -> getDownloadlink(0,'Windows')), true);
        }
        $data['demoUrl'] = json_decode(json_encode($this -> Gamemasters_model -> getDownloadlink(0,'Game URL')), true);
		$data['authURL'] =  $this->facebook->login_url();
		$data['_view'] = 'prelogin/login_view';
		$this->load->view('layouts/main_view', $data);		
    }
	function getLinkedinAccessToken($code)
	{
		$url = 'https://www.linkedin.com/oauth/v2/accessToken';
		$params = array('grant_type'=>'authorization_code','code'=>$code,'redirect_uri'=>'http://localhost/web/beegamephp/webgames/','client_id'=>'81v5u109j6dfpj','client_secret'=>'PzunsBnlbJ9FWWhi');
		$headers = array('Content-Type: application/x-www-form-urlencoded');
		
		$ch = curl_init();
		curl_setopt_array($ch, array(
		CURLOPT_RETURNTRANSFER => 1,
		CURLOPT_URL => $url,
		CURLOPT_HTTPHEADER => $headers,
		CURLOPT_POST => 0	,
		CURLOPT_POSTFIELDS => http_build_query($params),
        CURLOPT_TIMEOUT => 30
		));
		/*if( ! $result = curl_exec($ch)) 
		{ 
			trigger_error(curl_error($ch)); 
		} */
		 $response = json_decode(curl_exec($ch),true) ;
		 return $response['access_token'];
		 
		//$data['_view'] = 'prelogin/login_view';
		//$this->load->view('layouts/main_view', $data);		 
	}
	
	function getLinkedinEmail($token)
	{
		$url = 'https://api.linkedin.com/v2/emailAddress?q=members&projection=(elements*(handle~))';
		$headers = array('Authorization: Bearer '.$token,'Connection: Keep-Alive');
		$ch = curl_init();
		curl_setopt_array($ch, array(
		CURLOPT_RETURNTRANSFER => 1,
		CURLOPT_URL => $url,
		CURLOPT_HTTPHEADER => $headers,
		CURLOPT_POST => 0,
        CURLOPT_TIMEOUT => 30
		));
		$response = json_decode(curl_exec($ch),true);
		$email = $response['elements'][0]['handle~']['emailAddress'];
		return $email; 
	}
	function linkedinGetRequest($url,$token)
	{
		$headers = array('Authorization: Bearer '.$token,'Connection: Keep-Alive');
		$ch = curl_init();
		curl_setopt_array($ch, array(
		CURLOPT_RETURNTRANSFER => 1,
		CURLOPT_URL => $url,
		CURLOPT_HTTPHEADER => $headers,
		CURLOPT_POST => 0,
        CURLOPT_TIMEOUT => 30
		));
		return json_decode(curl_exec($ch),true); 
	}
	
	function linkedinPostRequest($url,$params,$token)
	{
		$headers = array('Content-Type: application/x-www-form-urlencoded','X-Restli-Protocol-Version: 2.0.0','Authorization: Bearer '.$token,'Connection: Keep-Alive');	
		$ch = curl_init();
		curl_setopt_array($ch, array(
		CURLOPT_RETURNTRANSFER => 1,
		CURLOPT_URL => $url,
		CURLOPT_HTTPHEADER => $headers,
		CURLOPT_POST => 1,
		CURLOPT_POSTFIELDS => http_build_query($params),
        CURLOPT_TIMEOUT => 30
		));
		return json_decode(curl_exec($ch),true);		
	}
	
	function logout()
	{
        // destroy session
        $data = array('login' => '', 
                       'uname' => '',
                       'uid' => '', 
                       'clientId'=>'',
                       'usertypeid'=>'');
        $this->session->unset_userdata($data);
        $this->session->sess_destroy();
        // $data['_view'] = 'prelogin/login_view';
            // $this->load->view('layouts/main_view', $data);
            redirect(base_url()); 
    }
    function login()
    {
        $data = array('success' => false, 'messages' => array());
        $uimage = 'resources/img/blank_user.png';
        // get form input
        $email = $this->input->post("email_log");
        $password = $this->input->post("password");

        // form validation
        $this->form_validation->set_rules("email_log", "Email-ID", "trim|required");
        $this->form_validation->set_rules("password", "Password", "trim|required");
        
        if ($this -> form_validation -> run()==FALSE)
        {
            // $data['messages']['emailerr'] = '<span class="text-danger">Login Error</span>';
            foreach ($_POST as $key => $value) 
                {
                    $data['messages'][$key] = form_error($key);
                }               
                echo json_encode($data);
        }
        else 
        {
            // check for user credentials
            $uresult = $this->user_model->get_user_from_stratupdb($email, $password);
            // var_dump($uresult);
            if (count($uresult) > 0)
            {
                if ($uresult[0]->PASSWORD === $password)  {
   
                     $userDtls = $this->user_model->get_user_by_id($uresult[0]->USER_ID);
                    $uimage = $uresult[0]->PROFILE_PIC_PATH;
                    if(!isset($uresult[0]->PROFILE_PIC_PATH))
                    {
                        $uimage = 'resources/img/blank_user.png';
                    } 
                        // set session
                        $sess_data = array('login' => TRUE, 
                                            'uname' => $uresult[0]->FIRST_NAME,
                                            'uid' => $uresult[0]->USER_ID,
                                            'emailid' => $uresult[0]->EMAIL_ID,
                                            'usertypeid'=>$uresult[0]->USER_TYPE_ID,
                                            'uimage'=>$uimage,
                                            'utype'=>$userDtls[0]->USER_TYPE_NAME,
                                            'org'=>$userDtls[0]->ORGANISATION_DESC,
                                            'orgid'=>$userDtls[0]->ORGANISATION_ID,
                                            );
                        $this->session->set_userdata($sess_data);
                        // $this->session->mark_as_temp('login', 300);
                        //echo $this->db->last_query();
                        // redirect("login");
                        $data['success'] = true;
                        echo json_encode($data);
                } 
                else{
                     $data['messages']['msg'] = '<div class="alert alert-danger text-center">Invalid Login Credentials.</div>';
                                echo json_encode($data);
                }
            }
            else
            {
                //$this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Invalid Login Credentials.</div>');
                // redirect('login');
                $data['messages']['msg'] = '<div class="alert alert-danger text-center">Invalid Login Credentials.</div>';
                echo json_encode($data);
            }
            
        }
        
    }
    function myaccount()
    {
        $this -> load -> model('Gamemasters_model');
        $emailId = $this->session->userdata('emailid');
       
        // $params['limit'] = RECORDS_PER_PAGE;
        // $params['offset'] = ($this -> input -> get('per_page')) ? $this -> input -> get('per_page') : 0;
// 
        // $config = $this -> config -> item('pagination');
        // $config['base_url'] = site_url('login/myaccount?');
        // $count= $this->Gamemasters_model->listPlayedGamesByUserCount($emailId);
        // $config['total_rows'] = $count[0]['Count'] ;
        // $this->pagination->initialize($config);
      
        $data['data']=$this->Gamemasters_model -> listPlayedGamesByUser($emailId);
        $data['_view'] = 'my_account_view';
        $data['_navview'] = 'nav_view';
        $this->load->view('layouts/main_view', $data);
    }
    function myaccountDtls($gameToken)
    {
        $data['TeamA'] = array('team_id' => '',
                       'game_id'=>'',
                       'TEAM_NAME'=>'',
                       'EMAIL_ID'=>'',
                       'DEPARTMENT_NAME'=>'',
                       'UNIVERSE_TOKEN'=>'');
                       
         $data['TeamB'] = array('team_id' => '',
                       'game_id'=>'',
                       'TEAM_NAME'=>'',
                       'EMAIL_ID'=>'',
                       'DEPARTMENT_NAME'=>'',
                       'UNIVERSE_TOKEN'=>'');
                       
        $emailId = $this->session->userdata('emailid');
        $this -> load -> model('Gamemasters_model');
        //$gameId = $_POST['gameId'];
        $gameIdDtls = $this->Gamemasters_model ->getGameIdForEmailId($gameToken,$emailId);
        if(!empty($gameIdDtls))
        {
            $data['gameInfo']=$this->Gamemasters_model -> getGameStartInfo($gameToken);
            $data['TeamA']=$this->Gamemasters_model -> listRolesTakenForStratupGame($gameToken,$gameIdDtls[0]['game_id'],'A');
            $data['TeamB']=$this->Gamemasters_model -> listRolesTakenForStratupGame($gameToken,$gameIdDtls[0]['game_id'],'B');
            //to fetch gamedtls when multiple games are played in same universe
            // $data['TeamA']=$this->Gamemasters_model -> listRolesTakenForStratupGame($gameToken,$gameId,'A');
            // $data['TeamB']=$this->Gamemasters_model -> listRolesTakenForStratupGame($gameToken,$gameId,'B');
        }
        
         echo json_encode($data);
         //var_dump($gameIdDtls);
    }
    function getFeedback($ugsStatusId)
    {//to show summary of webgames played
        $this -> load -> model('Dialogueservice_model');    
        $this -> load -> model('Negotiation_model');
        $this -> load -> model('Gamemasters_model');
       // $ugsStatusId = $_POST['ugsStatusId'];
        $emailId = $this->session->userdata('emailid');
        $gameDetails = $this -> Dialogueservice_model -> getDetailsForUgsId($ugsStatusId);
        $gameId = $gameDetails [0] -> GAME_ID;
        $parameterCode = 'GROUPED';
        $datapassed['pointsList'] = json_decode(json_encode($this -> Dialogueservice_model -> getPercentTargetAchievedForStory($ugsStatusId,'Y')),true);
        $datapassed['payoffScore'] = json_decode(json_encode($this -> Negotiation_model -> getPayoffScore($ugsStatusId)),true);     
        $datapassed['groupchart'] = json_encode($this -> Dialogueservice_model -> getPlayerAnswersCategoryCountForStory($ugsStatusId,'GROUPED'));
        $datapassed['standchart'] = json_encode($this -> Dialogueservice_model -> getPlayerAnswersCategoryCountForStory($ugsStatusId,'STANDALONE'));
        $datapassed['progress'] = json_decode(json_encode($this -> Dialogueservice_model -> getPercentTargetAchievedForStory($ugsStatusId,'N')),true);
        $datapassed['gameId'] = $gameId;
        $datapassed['similargames'] = $this->Gamemasters_model -> listSimilarPlayedGamesByUser($gameId,$emailId,$ugsStatusId);
        
        $datapassed['_view'] = 'games_details_view';
        $datapassed['_navview'] = 'nav_view';
        $this->load->view('layouts/main_view', $datapassed);  
        //$data=$this->load->view('game_details_view',$datapassed, TRUE);
        //$data=$this->load->view($this -> viewlist[$gameId]['levelcomp'],$datapassed, TRUE);
       // $alldata=array("levelComp"=> $data,"Chart"=>$datapassed['pointschart']);
       // echo json_encode($data);
    }
 
    function enquiry()
    {
        // set form validation rules
        $this -> form_validation -> set_rules('name_enq', 'Full Name', 'trim|required|regex_match[ /^[a-zA-Z ]+$/]+|min_length[3]|max_length[30]');
        $this -> form_validation -> set_rules('email_enq', 'EMAIL', 'trim|required|valid_email');
        if($this -> input -> post('enquirytype')!= 'ReachOut'){
             $this -> form_validation -> set_rules('phoneno_enq', 'Phone No', 'regex_match[/^[0-9]{10}$/]');
           $this -> form_validation -> set_rules('orgname_enq', 'Organisation Name', 'required');
        }
        if($this -> input -> post('enquirytype')== 'Contact'){
            $this -> form_validation -> set_rules('noofpar_enq','No of Participants',  'required');
            if(isset($_REQUEST['facilit_enq']) && $_REQUEST['facilit_enq'] == '') { 
                  echo '<p>Please select an option.</p>';
                } 
        }
         if($this -> input -> post('enquirytype')== 'Order'){
             if(isset($_REQUEST['gamename_enq']) && $_REQUEST['gamename_enq'] == '') { 
                  echo '<p>Please select an option.</p>';
                } 
        }
        
          $this -> form_validation -> set_rules('textmsg_enq', 'Tell us your requirements', 'required');
        $this->form_validation->set_error_delimiters('<p class="text-danger">', '</p>');
        
 
        // submit
        if ($this -> form_validation -> run() == FALSE)
        {
            // fails
            foreach ($_POST as $key => $value) 
                {
                    $data['messages'][$key] = form_error($key);
                }               
                echo json_encode($data);
        }
        else
        {
            
            $params = array(
                        'ENQUIRY_FOR' => $this -> input -> post('enquirytype'), 
                        'NAME' => $this -> input -> post('name_enq'), 
                        'EMAIL' => $this -> input -> post('email_enq'),
                        'PHONENO' => $this->input -> post('phoneno_enq'),
                        'ORGANISATION' => $this-> input -> post('orgname_enq'),
                        'DESIGNATION' => $this->input -> post ('design_enq'),
                        'NO_OF_PARTICIPANT' => $this -> input -> post ('noofpar_enq'),
                        'TRAINING_DATE' => $this -> input -> post ('tradate_enq'),
                        'FACILITATION' => $_REQUEST['facilit_enq'],
                        'GAME_NAME' => $_REQUEST['gamename_enq'],
                        'NO_OF_PIECES' => $this -> input -> post ('noofpiece_enq'),
                        'MESSAGE' => $this->input -> post('textmsg_enq'),
                        'CREATED_ON'=>date('Y-m-d')
                        );
                      
             $this -> load -> model('User_model');            
            $this -> User_model -> insertEnquiry($params);
           
           
            if ($this->db->trans_status() === FALSE)
            {
                    $this->db->trans_rollback();
                    $data['messages']['msg_enq'] = '<div class="alert alert-danger text-center">Oops! Something went wrong. Please try again</div>';
                    echo json_encode($data);
                    
            }
            else
            {
                    $this->db->trans_commit();
                     $this ->sendmail($params['EMAIL'],$params['NAME']);
                     $this -> sendmailtoadmin($params);
                     if($this -> input -> post('enquirytype')== 'Contact'){
                    $data['messages']['msg_enq'] = '<div class="alert alert-success text-center">Our learning team will get in touch with you to understand your speciﬁc requirements before we send you a proposal.</div>';
                    }
                    else if($this -> input -> post('enquirytype')== 'Order'){
                         $data['messages']['msg_enq'] = '<div class="alert alert-success text-center">Our learning team will reach out to you to understand your requirements in detail</div>';
                    }
                     else{
                         $data['messages']['msg_enq'] = '<div class="alert alert-success text-center">Thanks for providing your info</div>';
                    }
                   
                    $data['success'] = true;
                    echo json_encode($data);
            }
        }
    }
    function enquiryRegister()
    {
        // set form validation rules
        $this -> form_validation -> set_rules('name_enq_reg', 'Full Name', 'trim|required|regex_match[ /^[a-zA-Z ]+$/]+|min_length[3]|max_length[30]');
        $this -> form_validation -> set_rules('email_enq_reg', 'EMAIL', 'trim|required|valid_email');
        $this -> form_validation -> set_rules('orgname_enq_reg', 'Organisation Name', 'required');
        
        $this -> form_validation -> set_rules('noofpar_enq_reg','No of Participants',  'required');
        $this->form_validation->set_error_delimiters('<p class="text-danger">', '</p>');
 
        // submit
        if ($this -> form_validation -> run() == FALSE)
        {
            // fails
            foreach ($_POST as $key => $value) 
                {
                    $data['messages'][$key] = form_error($key);
                }               
                echo json_encode($data);
        }
        else
        {            
            $params = array(
                        'ENQUIRY_FOR' => $this -> input -> post('enquirytype_reg'), 
                        'NAME' => $this -> input -> post('name_enq_reg'), 
                        'EMAIL' => $this -> input -> post('email_enq_reg'),
                        'ORGANISATION' => $this-> input -> post('orgname_enq_reg'),
                        'NO_OF_PARTICIPANT' => $this -> input -> post ('noofpar_enq_reg'),
                        'CREATED_ON'=>date('Y-m-d')
                        );
                      
            $this -> load -> model('User_model');            
            $this -> User_model -> insertEnquiry($params);
           
           
            if ($this->db->trans_status() === FALSE)
            {
                $this->db->trans_rollback();
                $data['messages']['msg_enq_reg'] = '<div class="alert alert-danger text-center">Oops! Something went wrong. Please try again</div>';
                echo json_encode($data);
                    
            }
            else
            {
                $this->db->trans_commit();
                $this ->sendmail($params['EMAIL'],$params['NAME']);
                $this -> sendmailtoadmin($params);
                
                $data['messages']['msg_enq_reg'] = '<div class="alert alert-success text-center">Thanks for providing your info. Our learning team will reach out to you to understand your requirements in detail</div>';
                
                $data['success'] = true;
                echo json_encode($data);
            }
        }
    }
    function sendmail($toemail,$userfullname)
    {
        $this->load->library('email'); // load email library
        $this->email->from(supportMailId);
        $this->email->to($toemail);
        $this->email->cc(''); 
        $this->email->subject('Bizgames - We will soon get in touch with you');
        $this->email->message('<p><span style="font-family:Arial,Helvetica,sans-serif">Hello '.$userfullname.',</span></p>

                                <p>Thank you evincing interest in our Business Simulation Games. 
                                Our learning expert will soon get in touch with you to understand your requirements further.</p>
                                
                                <p>&nbsp;</p>
                                
                                <p>Thanks,</p>
                                
                                <p>Team Bizgames</p>');
        // $this->email->attach('/path/to/file1.png'); // attach file
        // $this->email->attach('/path/to/file2.pdf');
        if ($this->email->send())
        {
           // $this->session->set_flashdata('msg', '<div class="alert alert-success text-center"> We have sent your Login Credential to your e-MailID <br /> Please <a href="'.base_url().'"/login/index.php">Click Here</a> to Login</div>');
            //echo "Mail Sent!";
        }
        else
        {
            // $this->session->set_flashdata('msg', '<div class="alert alert-success text-center">We cant find your email address</div>');
           // show_error($this->email->print_debugger());
        }
            
    }
    function sendmailtoadmin($params)
    {
        $this->load->library('email'); // load email library
        $this->email->from(supportMailId);
        $this->email->to(supportMailId);
        $this->email->cc(''); 
        $this->email->subject('Enquire from Portal');
        if($params['ENQUIRY_FOR'] == "Register")
        {
            $this->email->message('<p><span style="font-family:Arial,Helvetica,sans-serif">Hello,</span></p>

                                <p>Please find the details below of the person who has enquired from portal.</p>
                                
                                <p>&nbsp;</p>
                                
                                <p>Enquired For:'.$params['ENQUIRY_FOR'].'<br/>
                                    Name:'.$params['NAME'].'<br/>
                                    Email Id:'.$params['EMAIL'].'<br/>
                                    Organistaion:'.$params['ORGANISATION'].'<br/>
                                    No. of Participents:'.$params['NO_OF_PARTICIPANT'].'<br/>
                                    
                                </p>
                                
                                
                                <p>Thanks,</p>
                                
                                <p>Team Bizgames</p>');
        }
        else
        {
            $this->email->message('<p><span style="font-family:Arial,Helvetica,sans-serif">Hello,</span></p>

                                <p>Please find the details below of the person who has enquired from portal.</p>
                                
                                <p>&nbsp;</p>
                                
                                <p>Enquired For:'.$params['ENQUIRY_FOR'].'<br/>
                                    Name:'.$params['NAME'].'<br/>
                                    Email Id:'.$params['EMAIL'].'<br/>
                                    Contact No:'.$params['PHONENO'].'<br/>
                                    Organistaion:'.$params['ORGANISATION'].'<br/>
                                    Designation:'.$params['DESIGNATION'].'<br/>
                                    Message:'.$params['MESSAGE'].'<br/>&nbsp;
                                    No. of Participents:'.$params['NO_OF_PARTICIPANT'].'<br/>
                                    Training Date:'.$params['TRAINING_DATE'].'<br/>
                                    Facilitation:'.$params['FACILITATION'].'<br/>&nbsp;
                                    Game Name:'.$params['GAME_NAME'].'<br/>
                                    No. of Pieces:'.$params['NO_OF_PIECES'].'<br/>
                                    
                                </p>
                                
                                
                                <p>Thanks,</p>
                                
                                <p>Team Bizgames</p>');
        }
        
        // $this->email->attach('/path/to/file1.png'); // attach file
        // $this->email->attach('/path/to/file2.pdf');
        if ($this->email->send())
        {
           // $this->session->set_flashdata('msg', '<div class="alert alert-success text-center"> We have sent your Login Credential to your e-MailID <br /> Please <a href="'.base_url().'"/login/index.php">Click Here</a> to Login</div>');
            //echo "Mail Sent!";
        }
        else
        {
            // $this->session->set_flashdata('msg', '<div class="alert alert-success text-center">We cant find your email address</div>');
           // show_error($this->email->print_debugger());
        }
            
    }
    public function aboutus()
    {
        $this -> load -> model('Gamemasters_model');
         $data['occupationmstr'] = json_decode(json_encode($this -> Gamemasters_model -> getOccupationMstr()),true);
        $data['organisationmstr'] = json_decode(json_encode($this -> Gamemasters_model -> getUserOrganisationMstr()),true);
        $data['locationmstr'] = json_decode(json_encode($this -> Gamemasters_model -> getUserLocationMstr()),true);
        $data['_view'] = 'aboutus_view';
        $this->load->view('layouts/main_view', $data);
    }
    
    function userProfile()
    {
        $this -> load -> model('User_model');
        $emailId = $this->session->userdata('emailid');
        $data['userDtls'] = $this->User_model -> getUserDtls($emailId);
        $data['_profileview'] = 'basic_profile_view';   
        $data['_view'] = 'profile_view';
        $this->load->view('layouts/main_view', $data);
    }
    function userProfileEditDisplay()
    {
        $this -> load -> model('User_model');
        $this -> load -> model('Gamemasters_model');
        $emailId = $this->session->userdata('emailid');
        $data['userDtls'] = $this->User_model -> getUserDtls($emailId);
        $data['occupationmstr'] = json_decode(json_encode($this -> Gamemasters_model -> getOccupationMstr()),true);
        $data['organisationmstr'] = json_decode(json_encode($this -> Gamemasters_model -> getUserOrganisationMstr()),true);
        $data['locationmstr'] = json_decode(json_encode($this -> Gamemasters_model -> getUserLocationMstr()),true);
        $data['_profileview'] = 'basic_profile_edit_view';   
        $data['_view'] = 'profile_view';
        $this->load->view('layouts/main_view', $data);
    }
    function changePwdView()
    {
        $this -> load -> model('User_model');
        $emailId = $this->session->userdata('emailid');
        $data['userDtls'] = $this->User_model -> getUserDtls($emailId);
        $data['_profileview'] = 'change_pwd_view';   
        $data['_view'] = 'profile_view';
        $this->load->view('layouts/main_view', $data);
    }
    public function blogs()
    {
        $this -> load -> model('Gamemasters_model');
         $data['occupationmstr'] = json_decode(json_encode($this -> Gamemasters_model -> getOccupationMstr()),true);
        $data['organisationmstr'] = json_decode(json_encode($this -> Gamemasters_model -> getUserOrganisationMstr()),true);
        $data['locationmstr'] = json_decode(json_encode($this -> Gamemasters_model -> getUserLocationMstr()),true);
        $data['blogDetails'] = $this -> Gamemasters_model -> getAllBlogs();
        $data['_view'] = 'blog/blog_main_view';
        $this->load->view('layouts/main_view', $data);
    }
    public function blogDescription($blog_Id)
    {
        $this -> load -> model('Gamemasters_model');
        
        $data['blogDetails'] = json_decode(json_encode($this -> Gamemasters_model -> getBlogDetails($blog_Id)),TRUE);
        $data['blogCommentCnt'] = json_decode(json_encode($this -> Gamemasters_model -> getBlogCommentbyID($blog_Id)),TRUE);
        $params['limit'] = RECORDS_PER_PAGE; 
        $params['offset'] = ($this->input->get('per_page')) ? intval($this->input->get('per_page')) : 0;
        
        $config = $this->config->item('pagination');
        $config['base_url'] = site_url('login/blogDescription/'.$blog_Id);
        $config['total_rows'] = $data['blogCommentCnt'][0]['COMMENT_COUNT'];
        $this->pagination->initialize($config);
        
        $data['blogComment'] = json_decode(json_encode($this -> Gamemasters_model -> getBlogComments($blog_Id,$params)),TRUE);
        $data['blogId'] = $blog_Id;
        $data['_view'] = 'blog/blog_desc_view';
        $this->load->view('layouts/main_view', $data);
    }
    function commentBlog()
    {
        $this -> load -> model('Gamemasters_model');
        $blogId = $this -> input -> post('BLOG_ID');
        $comment = $this -> input -> post('comment');
        $name = $this -> input -> post('author');
        $email = $this -> input -> post('blog_email');
        $resCommentId = $this -> input -> post('comment_parent');
        if($_POST['captcha-answer']!= '')
        {
            if($_POST['opr_sym']=='+')
            {
                $result=$_POST['left_num']+$_POST['right_num'];
            }
            else if($_POST['opr_sym']=='-')
            {
                $result=$_POST['left_num']-$_POST['right_num'];
            }
            else {
                $result=$_POST['left_num']*$_POST['right_num'];
            }
            if($result==$_POST['captcha-answer'])
            {
                if($resCommentId == '')
                {
                    $params = array(
                        'COMMENTED_BY' => $name,
                        'EMAIL_ID' => $email,
                        'BLOG_COMMENT' => $comment,
                        'BLOG_ID' => $blogId,
                    );
                    
                    $commentId = $this->Gamemasters_model->addBlogComment($params);
                    $blog=$this->Gamemasters_model->getBlogbyId($blogId);
                    $params['BLOG_NAME']=$blog[0]->BLOG_DESC;
                    $this->sendblogmailtoadmin($params);
                    $data['success']=true;
                     echo json_encode($data);
                 //   redirect('Login/blogDescription/'.$blogId);
                }
                else{
                    $params = array(
                        'BLOG_COMMENT_ID' => $resCommentId,
                        'COMMENTED_BY' => $name,
                        'EMAIL_ID' => $email,
                        'BLOG_COMMENT' => $comment,
                    );
                    
                    $replycommentId = $this->Gamemasters_model->replytoBlogComment($params);
                    $blogName=$this->Gamemasters_model->getBlogbyId($blogId);
                   $params['BLOG_NAME']=$blog[0]->BLOG_DESC;
                     $this->sendblogmailtoadmin($params);
                     $data['success']=true;
                      echo json_encode($data);
                 //  redirect('Login/blogDescription/'.$blogId);
                }
            }
            else{
                $data['messages']['captcha_msg'] = '<div style="color:red">Incorrect answer</div>';
            echo json_encode($data);
            }
            
        }
        else {
           $data['messages']['captcha_msg'] = '<div style="color:red">Please enter captcha</div>';
            echo json_encode($data);
        }
        
        
    }
    function sendblogmailtoadmin($params)
    {
        $this->load->library('email'); // load email library
        $this->email->from(supportMailId);
        $this->email->to(supportMailId);
        $this->email->cc(''); 
        $this->email->subject('Comment on Blog');
        $this->email->message('<p><span style="font-family:Arial,Helvetica,sans-serif">Hello,</span></p>

                                <p>Please find the details below of the person who has commented on blog from portal.</p>
                                
                                <p>&nbsp;</p>
                                
                                <p>Blog Name:'.$params['BLOG_NAME'].'<br/>
                                    Name:'.$params['COMMENTED_BY'].'<br/>
                                    Email Id:'.$params['EMAIL_ID'].'<br/>
                                    Comment:'.$params['BLOG_COMMENT'].'<br/>
                                    
                                    
                                </p>
                                
                                
                                <p>Thanks,</p>
                                
                                <p>Team Bizgames</p>');
        // $this->email->attach('/path/to/file1.png'); // attach file
        // $this->email->attach('/path/to/file2.pdf');
        if ($this->email->send())
        {
           // $this->session->set_flashdata('msg', '<div class="alert alert-success text-center"> We have sent your Login Credential to your e-MailID <br /> Please <a href="'.base_url().'"/login/index.php">Click Here</a> to Login</div>');
            //echo "Mail Sent!";
        }
        else
        {
            // $this->session->set_flashdata('msg', '<div class="alert alert-success text-center">We cant find your email address</div>');
           // show_error($this->email->print_debugger());
        }
            
    }
    function getuserPCinfo()
    {
           $this->load->library('user_agent');

      $data['browser'] = $this->agent->browser();

      $data['browser_version'] = $this->agent->version();

      $data['os'] = $this->agent->platform();

      $data['ip_address'] = $this->input->ip_address();
      
      return $data;
    }
    function windowsbitselection()
    {
        $winbit=$_POST['winbit'];
        $this -> load -> model('Gamemasters_model');
        $data['downloadStratup']=json_decode(json_encode($this -> Gamemasters_model -> getDownloadlink(0,$winbit)), true);
         echo json_encode($data);
    }
    function userProfileEdit()
    {
        $this -> form_validation -> set_rules('editoccu', 'Occupation', 'required');
        
        $this -> load -> model('User_model');
        $this -> load -> model('Gamemasters_model');
        $occupation=$this -> Gamemasters_model -> getOccupationMstr();
        $checkoccu=array();
        foreach($occupation as $occ)
        {
            array_push($checkoccu,$occ['OCCUPATION_ID']);
        }
        
        $this -> form_validation -> set_rules('editorg', 'Organiation', 'required');
        $organisation=$this -> Gamemasters_model -> getUserOrganisationMstr();
        $checkorg=array('0');
        foreach($organisation as $org)
        {
            array_push($checkorg,$org['ORGANISATION_ID']);
        }
           
        $this -> form_validation -> set_rules('editloca', 'Location', 'required');
        $location=$this -> Gamemasters_model -> getUserLocationMstr();
        $checkloc=array();
        foreach($location as $loc)
        {
            array_push($checkloc,$loc['LOCATION_ID']);
        }
        
        $this->form_validation->set_error_delimiters('<p class="text-danger">', '</p>');
        $errormgs=array();
        if(!in_array($_POST['editoccu'], $checkoccu))
        {
            $errormgs['editoccu']= '<p class="text-danger">Select occupation from the list!</p>';
           // $data['messages']['editoccu'] = '<p class="text-danger">Select occupation from the list!</p>';
           // echo json_encode($data); 
        }
        if(!in_array($_POST['editorg'], $checkorg))
        {
            $errormgs['editorg']= '<p class="text-danger">Select organisation from the list!</p>';
            //$data['messages']['editorg'] = '<p class="text-danger">Select organisation from the list!</p>';
            //echo json_encode($data); 
        }
        if(!in_array($_POST['editloca'], $checkloc))
        {
            $errormgs['editloca']= '<p class="text-danger">Select location from the list!</p>';
            //$data['messages']['editloca'] = '<p class="text-danger">Select location from the list!</p>';
            //echo json_encode($data); 
        }
        if(count($errormgs)>0)
        {
         foreach ($errormgs as $key => $value) 
            {
                $data['messages'][$key] = $value;
            }               
            echo json_encode($data);
        }
        else{
            $userId=$this->session->userdata('uid');
        
        $data = array(
                            'FIRST_NAME' => $this -> input -> post('first_name'),
                            'OCCUATION_ID' => $this -> input -> post('editoccu'),
                            'ORGANISATION_ID' => $this -> input -> post('editorg'),
                            'COMAPANY_NAME' => $this -> input -> post('editorgname'),
                            'LOCATION_ID' => $this -> input -> post('editloca')
                         );
        
            $newUserId = $this -> User_model -> update_user_mstr($userId,$data);
        if ($this->db->trans_status() === FALSE)
            {
                    $this->db->trans_rollback();
                    // $this->session->set_flashdata('msg_profileedit', '<div class="alert alert-danger text-center">Oops! Something went wrong. Please try again</div>');
                    // redirect('Login/userProfileEditDisplay');
                   $data['messages']['msg_profileedit'] = '<div class="alert alert-danger text-center">Oops! Something went wrong. Please try again</div>';
                   echo json_encode($data);
                    
            }
            else
            {
                    $this->db->trans_commit();
                    $data['success'] = true;
                    $data['messages']['msg_profileedit'] = '<div class="alert alert-success text-center">Successfully Updated.</div>';
                   echo json_encode($data);
                   // $this->session->set_flashdata('msg_profile', '<div class="alert alert-success text-center">Successfully Updated.</div>');
                   // redirect('Login/userProfile');
            }
        }
    }
    public function contactus()
    {
        $this -> load -> model('Gamemasters_model');
         $data['occupationmstr'] = json_decode(json_encode($this -> Gamemasters_model -> getOccupationMstr()),true);
        $data['organisationmstr'] = json_decode(json_encode($this -> Gamemasters_model -> getUserOrganisationMstr()),true);
        $data['locationmstr'] = json_decode(json_encode($this -> Gamemasters_model -> getUserLocationMstr()),true);
        $data['_view'] = 'contactus_view';
        $this->load->view('layouts/main_view', $data);
    }
    function contactusform()
    {
        // set form validation rules
        $this -> form_validation -> set_rules('name_contact', 'Full Name', 'trim|required|regex_match[ /^[a-zA-Z ]+$/]+|min_length[3]|max_length[30]');
        $this -> form_validation -> set_rules('email_contact', 'EMAIL', 'trim|required|valid_email');        
          $this -> form_validation -> set_rules('textmsg_contact', 'Tell us your requirements', 'required');
        $this->form_validation->set_error_delimiters('<p class="text-danger">', '</p>');
        
 
        if ($this -> form_validation -> run())
        {
            $params = array(
                        'ENQUIRY_FOR' => $this -> input -> post('Reachout'), 
                        'NAME' => $this -> input -> post('name_contact'), 
                        'EMAIL' => $this -> input -> post('email_contact'),
                        'PHONENO' => NULL,
                        'ORGANISATION' => NULL,
                        'DESIGNATION' => NULL,
                        'NO_OF_PARTICIPANT' => NULL,
                        'TRAINING_DATE' => NULL,
                        'FACILITATION' => NULL,
                        'GAME_NAME' => NULL,
                        'NO_OF_PIECES' => NULL,
                        'MESSAGE' => $this->input -> post('textmsg_contact'),
                        'CREATED_ON'=>date('Y-m-d')
                        );
                      
             $this -> load -> model('User_model');            
            $this -> User_model -> insertEnquiry($params);
           
           
            if ($this->db->trans_status() === FALSE)
            {
                    $this->db->trans_rollback();
                     $this->session->set_flashdata('msg_contact', '<div class="alert alert-danger text-center">Oops! Something went wrong. Please try again</div>');
                redirect('contact-us');
                    
            }
            else
            {
                    $this->db->trans_commit();
                     $this ->sendmail($params['EMAIL'],$params['NAME']);
                     $this -> sendmailtoadmin($params);
                    
                    $this->session->set_flashdata('msg_contact', '<div class="alert alert-success text-center">Thanks for providing your info</div>');
                    redirect('contact-us');
            }
        }
    }
    public function clients()
    {
        $this -> load -> model('Gamemasters_model');
         $data['occupationmstr'] = json_decode(json_encode($this -> Gamemasters_model -> getOccupationMstr()),true);
        $data['organisationmstr'] = json_decode(json_encode($this -> Gamemasters_model -> getUserOrganisationMstr()),true);
        $data['locationmstr'] = json_decode(json_encode($this -> Gamemasters_model -> getUserLocationMstr()),true);
        $data['_view'] = 'clients_view';
        $this->load->view('layouts/main_view', $data);
    }
    public function product()
    {
		/* Read 'code' from URL
		Get email_id from linked in for code
		If email id does not exist create entry
		else
		If code not matches with email in database, replace code
		set session data for logged in user store only id
		User session data for further services - get email from db and fire from server only
		*/
		$this -> load -> model('Gamemasters_model');
		if(isset($_GET['code']))
		{
			$code = $_GET['code'];
			//echo $code;
			$token = $this -> getLinkedinAccessToken($code);
			$email = $this -> getLinkedinEmail($token);
			$userurl = 'https://api.linkedin.com/v2/me';
			$userText = $this -> linkedinGetRequest($userurl,$token);
			
			$posturl = 'https://api.linkedin.com/v2/ugcPosts';
			$postparams = array('author'=>'urn:li:person:'.$userText['id'],'lifecycleState'=>'PUBLISHED','specificContent'=>
							array('com.linkedin.ugc.ShareContent'=>
								array('shareCommentary'=>
									array('text'=>'Siva Loggedin to Biz Games'),
									'shareMediaCategory'=>'NONE')),
									'visibility'=>array('com.linkedin.ugc.MemberNetworkVisibility'=>'CONNECTIONS'));
			$postText = $this -> linkedinPostRequest($posturl,$postparams,$token);	
		//	var_dump($postparams);
		//	var_dump($postText);
			$output = $postText;
		}
		else
		{

		}
		$data['banner'] = json_decode(json_encode($this -> Gamemasters_model -> getbanner()),true);
		$data['gameCategoryList'] = json_decode(json_encode($this -> Gamemasters_model -> getGameCategoryList()),true);
		$data['getGameList'] = json_decode(json_encode($this -> Gamemasters_model -> getGameListandDetailsForProductPage()),true);
		$data['getClientList'] = json_decode(json_encode($this -> Gamemasters_model -> getClientList()),true);
		$data['getTesimonialsList'] = json_decode(json_encode($this -> Gamemasters_model -> getTesimonialsList()),true);
	//	$data['gameTopFourList'] = json_decode(json_encode($this -> Gamemasters_model -> gameOtherCatGameList()),true);
        $data['occupationmstr'] = json_decode(json_encode($this -> Gamemasters_model -> getOccupationMstr()),true);
        $data['organisationmstr'] = json_decode(json_encode($this -> Gamemasters_model -> getUserOrganisationMstr()),true);
        $data['locationmstr'] = json_decode(json_encode($this -> Gamemasters_model -> getUserLocationMstr()),true);
       // $data['campaignList'] = json_decode(json_encode($this -> Gamemasters_model -> getCampaignList()), true);
        $UserPCdtls = $this->getuserPCinfo();
        $UserPCOS = explode(' ',$UserPCdtls['os']);
        if($UserPCOS[0]=='Mac')
        {
            $data['downloadStratup']=json_decode(json_encode($this -> Gamemasters_model -> getDownloadlink(0,$UserPCOS[0])), true);
        }
        else{
            $data['downloadStratup']=json_decode(json_encode($this -> Gamemasters_model -> getDownloadlink(0,'Windows')), true);
        }
      //  $data['demoUrl'] = json_decode(json_encode($this -> Gamemasters_model -> getDownloadlink(0,'Game URL')), true);
		$data['authURL'] =  $this->facebook->login_url();
		$data['_view'] = 'prelogin/product_view';
		$this->load->view('layouts/main_view', $data);		
    }
}