<?php
class Main extends CI_Controller
{
	var $viewlist;
	var $userId;
	
    public function __construct()
    {
        parent::__construct();
        $this -> load -> helper(array(
            'form',
            'url',
            'html'
        ));
        $this -> load -> library(array(
            'session',
            'form_validation'
        ));
        /*if(!$this->session->userdata('login'))
        {
            redirect('login');
        }*/
		$this -> viewlist = parse_ini_file('resources/properties/gameviews.ini',true);
		if ($this->session->userdata('uid'))
			$this -> userId = $this->session->userdata('uid');
		else
			$this -> userId = 1;
    }

    public function index($gameId)
    {
		$this -> load -> model('Gamemasters_model');
		$gameDetails = json_decode(json_encode($this -> Gamemasters_model -> getGameDescriptionForGameId($gameId)));

		if($gameDetails[0]->GAME_CAT_ID!='2')
		{
			$this -> load -> model('Dialogueservice_model');	
			$storyList = json_decode(json_encode($this -> Dialogueservice_model -> getStoriesForGameUser($gameId,$this -> userId)),true);

			$data['CSS_STYLES'] = $this -> viewlist[$gameId]['CSS_STYLES'];
			$data['GAME_CSS_STYLES'] = $this -> viewlist[$gameId]['GAME_CSS_STYLES'];
			$data['IMG_SPLASH'] = $this -> viewlist[$gameId]['IMG_SPLASH'];
			$data['JS_BUTTONC'] = $this -> viewlist[$gameId]['JS_BUTTONC'];
			$data['JS_INITIAL'] = $this -> viewlist[$gameId]['JS_INITIAL'];
			$data['IMG_BG'] = $this -> viewlist[$gameId]['IMG_BG'];
			
			$data['bgm_sfx'] = $this -> viewlist[$gameId]['bgm_sfx'];
			$data['click_sfx'] = $this -> viewlist[$gameId]['click_sfx'];
			$data['correct_sfx'] = $this -> viewlist[$gameId]['correct_sfx'];
			$data['incorrect_sfx'] = $this -> viewlist[$gameId]['incorrect_sfx'];
			$data['gameover_sfx'] = $this -> viewlist[$gameId]['gameover_sfx'];
			
			$rowIndex = 0;
			$lockForNextStory = 0;
			foreach ($storyList as $row) 
			{
				if($rowIndex ==0)
				{
					$storyList[$rowIndex]['lock']='NO';
				}
				else
				{  
					if($lockForNextStory == 'YES')
					{
						$storyList[$rowIndex]['lock']='YES';
					}else
					{
						$storyList[$rowIndex]['lock']='NO';
					}
				}
				$lockForNextStory = $row['NEXT_STORY_LOCK'];
				$rowIndex++;
			} 
			
			$data['storyList'] = $storyList;			
			$data['_view'] = $this -> viewlist[$gameId]['level'];	
			$this -> load -> view($this -> viewlist[$gameId]['main'], $data);
		}
    }
	
	function getLevels()
    {
		$gameId = $_POST['gameId'];
		
		$datapassed['bgm_sfx'] = $this -> viewlist[$gameId]['bgm_sfx'];
		$datapassed['click_sfx'] = $this -> viewlist[$gameId]['click_sfx'];
		$datapassed['correct_sfx'] = $this -> viewlist[$gameId]['correct_sfx'];
		$datapassed['incorrect_sfx'] = $this -> viewlist[$gameId]['incorrect_sfx'];
		$datapassed['gameover_sfx'] = $this -> viewlist[$gameId]['gameover_sfx'];
					
        $this -> load -> model('Dialogueservice_model');	
		$storyList = json_decode(json_encode($this -> Dialogueservice_model -> getStoriesForGameUser($gameId,$this -> userId)),true);
		$rowIndex = 0;
		$lockForNextStory = 0;
		foreach ($storyList as $row) 
		{
			if($rowIndex ==0)
			{
				$storyList[$rowIndex]['lock']='NO';
			}
			else
			{  
				if($lockForNextStory == 'YES')
				{
					$storyList[$rowIndex]['lock']='YES';
				}else
				{
					$storyList[$rowIndex]['lock']='NO';
				}
			}
			$lockForNextStory = $row['NEXT_STORY_LOCK'];
			$rowIndex++;
		} 
		
		$datapassed['storyList'] = $storyList;			
		$data=$this->load->view($this -> viewlist[$gameId]['level'],$datapassed, TRUE);
		echo json_encode($data);		
    }
	
	function getStory()
	{
		$storyId = $_POST['storyId'];
		$gameId = $_POST['gameId'];
        $this -> load -> model('Dialogueservice_model');	
		$datapassed['storydata'] = json_decode(json_encode($this -> Dialogueservice_model -> getGsMapIdForGameStory($gameId,$storyId)),true);
		$datapassed['pendingTasks'] = json_decode(json_encode($this -> Dialogueservice_model -> getCompStmtsForGame('GAME=RETAIL','SUMMARY','PENDING','10000','')),true);			
		$data=$this->load->view($this -> viewlist[$gameId]['leveldetails'],$datapassed, TRUE);
		echo json_encode($data);		
	}
	
	function getStmtsforGame()
	{
		$in = $_POST['compstmtparam'];
		$comptype = $_POST['comptype'];		
		$ugsStatusId = $_POST['ugsStatusId'];
        $gameId = $_POST['gameId'];
        $this -> load -> model('Dialogueservice_model');
        if($gameId==26) 
        {
            $datapassed['questionList'] = json_decode(json_encode($this -> Dialogueservice_model -> getCompStmtsForGame($in,'DETAILANSWER','COMPLETED',$ugsStatusId,$comptype)),true);
            $i=0;
            foreach ($datapassed['questionList'] as &$row) 
            {
                // $datapassed[$i]['cardDtls'] = $this -> Dialogueservice_model ->getGameletCardForCompStmtCode($row['COMP_STMT_CODE']);
                $cardDtls = $this -> Dialogueservice_model ->getGameletCardForCompStmtCode($row['COMP_STMT_CODE']);
                $row['COMP_STMT_CODE']=$cardDtls[0]['COMP_STMT_CODE'];
                $row['CARD_CODE']=$cardDtls[0]['CARD_CODE'];
                $row['CARD_TYPE']=$cardDtls[0]['CARD_TYPE'];
                $row['CARD_TITLE']=$cardDtls[0]['CARD_TITLE'];
                $row['CARD_DESC']=$cardDtls[0]['CARD_DESC'];
                $row['VALUE1']=$cardDtls[0]['VALUE1'];
                $row['VALUE2']=$cardDtls[0]['VALUE2'];
                $row['VALUE3']=$cardDtls[0]['VALUE3'];
                $row['VALUE4']=$cardDtls[0]['VALUE4'];
                $row['VALUE5']=$cardDtls[0]['VALUE5'];
                $cardDtls = array();
                $i++;
            }
            
        }
        else
        {
            $datapassed['questionList'] = json_decode(json_encode($this -> Dialogueservice_model -> getCompStmtsForGame($in,'DETAIL','PENDING',$ugsStatusId,$comptype)),true);
        }
		  
		
		$gameDetails = $this -> Dialogueservice_model -> getDetailsForUgsId($ugsStatusId);
		
		
		$data=$this->load->view($this -> viewlist[$gameId]['tasklist'],$datapassed, TRUE);
		echo json_encode($data);
		// var_dump($datapassed);
	}

    function startgame()
    {
        $this -> load -> model('Dialogueservice_model');	
		$gsMapId = $_POST['gsMapId'];		
		$gameInit = $this -> Dialogueservice_model -> insertGameStatus($this -> userId,$gsMapId,'');
		$ugsStatusId = $this -> db -> insert_id();
		$datapassed['ugsStatusId'] = $ugsStatusId;	
		
		$gameDetails = $this -> Dialogueservice_model -> getDetailsForUgsId($ugsStatusId);
		$gameId = $gameDetails [0] -> GAME_ID;
		$datapassed['gameId'] = $gameId;
		
		$data=$this->load->view($this -> viewlist[$gameId]['story'],$datapassed, TRUE);
		echo json_encode($data);
    }	
	
	function triggerEvent()
	{
        $this -> load -> model('Dialogueservice_model');	
		$gameId = $_POST['gameId'];
		$compstmtcode = $_POST['compstmtcode'];
		$playstmtcode = isset($_POST['playstmtcode'])?$_POST['playstmtcode']:"";
		$ugsStatusId = $_POST['ugsStatusId'];
		$playEntry1 = $_POST['playEntry1'];	
		$parentFilterId = $_POST['parentFilterId'];
		$filterType = $_POST['filterType'];
		$filterinput = $_POST['filterinput'];
		$in = $_POST['compstmtparam'];
		$datapassed4['currpointsList'] = json_decode(json_encode($this -> Dialogueservice_model -> getPointsForAnimation($playstmtcode)),true);
		if ($playstmtcode == '')
		{
			$datapassed['compstmt'] = json_decode(json_encode($this -> Dialogueservice_model -> getCompPlayStatementsForTrigger($compstmtcode)),true);
			$datapassed['compstmt'][0]['DESCRIPTION']=str_replace("<?php echo site_url()?>",site_url(), $datapassed['compstmt'][0]['DESCRIPTION']);
			$datapassed['answerfilters'] = json_decode(json_encode($this -> Dialogueservice_model -> getFiltersforQuestion($compstmtcode)),true);
            $datapassed['uniqueNegStyle']= $this->getUniqueNegStyle($datapassed['compstmt']);
            $datapassed['cardDtls'] = $this -> Dialogueservice_model ->getGameletCardForCompStmtCode($compstmtcode);
            $jsvar['backgroundimg'] = $datapassed['compstmt'][0]['IMG_BG'];
			$jsvar['bganimation'] = $datapassed['compstmt'][0]['IMAGE_CSS_CLASS'];
			$jsvar['pstmtAvatarImg'] = isset($datapassed['compstmt'][1]['MEDIA_URL'])?$datapassed['compstmt'][1]['MEDIA_URL']:"";
			$jsvar['pstmtAvatarClass'] = isset($datapassed['compstmt'][1]['IMAGE_CSS_CLASS'])?$datapassed['compstmt'][1]['IMAGE_CSS_CLASS']:"";
		}
		else
		{
			$stmtcode = $this -> Dialogueservice_model -> answerwiseCompStmtsForPlayer($playstmtcode);
            $datapassed['compstmt'] = json_decode(json_encode($this -> Dialogueservice_model -> getCompPlayStatementsForTrigger($stmtcode[0] -> DESTN_COMP_STMT_CODE)),true);
			$datapassed['compstmt'][0]['DESCRIPTION']=str_replace("<?php echo site_url()?>",site_url(), $datapassed['compstmt'][0]['DESCRIPTION']);   
            $datapassed['answerfilters'] = json_decode(json_encode($this -> Dialogueservice_model -> getFiltersforQuestion($stmtcode[0] -> DESTN_COMP_STMT_CODE)),true);
            $datapassed4['currpointsList'] = json_decode(json_encode($this -> Dialogueservice_model -> getPointsForAnimation($playstmtcode)),true);
            $datapassed['uniqueNegStyle']= $this->getUniqueNegStyle($datapassed['compstmt']);
            $datapassed['cardDtls'] = $this -> Dialogueservice_model ->getGameletCardForCompStmtCode($stmtcode[0] -> DESTN_COMP_STMT_CODE);
			$jsvar['backgroundimg'] = $datapassed['compstmt'][0]['IMG_BG'];
			$jsvar['bganimation'] = $datapassed['compstmt'][0]['IMAGE_CSS_CLASS'];
			$jsvar['pstmtAvatarImg'] = isset($datapassed['compstmt'][1]['MEDIA_URL'])?$datapassed['compstmt'][1]['MEDIA_URL']:"";
			$jsvar['pstmtAvatarClass'] = isset($datapassed['compstmt'][1]['IMAGE_CSS_CLASS'])?$datapassed['compstmt'][1]['IMAGE_CSS_CLASS']:"";

            $playerStmtDtls = $this -> Dialogueservice_model ->getPlayerStmtForPlayStmtCode($playstmtcode);
            if($playerStmtDtls[0]['PLAY_STMT_DESC']!='NULL')
            {
                $isActionAvailable = $this -> Dialogueservice_model ->getActionsTblDtlsForUgsAndCompStmtCode($ugsStatusId,$compstmtcode);
                if(empty($isActionAvailable))
                {
                    $this -> Dialogueservice_model -> insertActions($compstmtcode,$playstmtcode,$ugsStatusId,$playEntry1);
                }
                else 
                {
                    $this -> Dialogueservice_model -> updateActions($compstmtcode,$playstmtcode,$ugsStatusId);
                }
                
            }
			// changed by leela while fixing life of manager. Need to check will this impact other games.
			// commented the condiatinal check wheter points alreaty initiated. Instead insert all the records. 
			// since the points are finally summed up. 
			// Also Answer parameter is not used and from second time onwards it is always using updated and no new points is getting inserted
			
			/*
			$isPoints = $this -> Dialogueservice_model -> isPointsInitiated($playstmtcode,$ugsStatusId);
			$isnewPoints = $isPoints [0] -> ISPOINTS;
			if ($isnewPoints  == "FALSE")
            {
                $this -> Dialogueservice_model -> insertPoints($playstmtcode,$ugsStatusId);
            }
				
			else
            {
                $this -> Dialogueservice_model -> updatePoints($playstmtcode,$ugsStatusId);
            }
			 * 
			 */
			$compStmtDtls = $this -> Dialogueservice_model -> getDetailsForCompStmtCode($compstmtcode);
			$title = $compStmtDtls[0]['COMP_STMT_TITLE'];
			if(strpos($title,'INTCALC') !== false)
			{
				//Don't do anything here
			}
			else
			{
				$this -> Dialogueservice_model -> insertPoints($playstmtcode,$ugsStatusId);
			}
		}
        
		$title = $datapassed['compstmt'][0]['COMP_STMT_TITLE'];
		if(strpos($title,'INTDISP')!==false)
		{
			$titlearray = explode(':',$title);
			$formulaarray = explode(',',$titlearray[1]);
			$storedData = $this -> Dialogueservice_model -> getPlayerPointsForGamesInternalCalc($ugsStatusId);
			$value = array();
			for ($i=0; $i < count($storedData) ; $i++) 
			{
				$value[$storedData[$i] -> POINTS_PARAM_DESC]=$storedData[$i] -> TOTAL;
			}			
			for ($j=0;$j<count($formulaarray);$j++)
			{
				$replaceValue = $value[$formulaarray[$j]];
				$datapassed['compstmt']	[0]['DESCRIPTION'] = str_replace($formulaarray[$j],$replaceValue,$datapassed['compstmt'][0]['DESCRIPTION']);
			}
		}
		
		$datapassed1['pointsList'] = json_decode(json_encode($this -> Dialogueservice_model -> getPlayerPointsForGame($ugsStatusId)),true);
		if($gameId==26)
        {
            $datapassed2['pendingTasks'] = json_decode(json_encode($this -> Dialogueservice_model -> getCompStmtsForGame($in,'SUMMARY','COMPLETED',$ugsStatusId,'')),true);
        }
        else 
        {
        	$datapassed2['pendingTasks'] = json_decode(json_encode($this -> Dialogueservice_model -> getCompStmtsForGame($in,'SUMMARY','PENDING',$ugsStatusId,'')),true);
        }
				

		if ($filterinput== '')
			$filterinput = '\'GROUPED='.$parentFilterId.'\'';
		$datapassed['answerList'] = json_decode(json_encode($this -> Dialogueservice_model -> getPlayStmtsForGameFilter($filterinput)),true);						
		$datapassed['historyList'] = json_decode(json_encode($this -> Dialogueservice_model -> getHistory($ugsStatusId)),true);			
		$datapassed4['pointsList'] = json_decode(json_encode($this -> Dialogueservice_model -> getPlayerPointsForGame($ugsStatusId)),true);	
	
		$data=$this->load->view($this -> viewlist[$gameId]['mechanics'],$datapassed, TRUE);		
		$data1=$this->load->view($this -> viewlist[$gameId]['points'],$datapassed1, TRUE);	
		$data2=$this->load->view($this -> viewlist[$gameId]['taskcatlist'],$datapassed2, TRUE);	
        if(!empty($datapassed4['currpointsList']))
        {
            $data4=$this->load->view($this -> viewlist[$gameId]['pointsanime'],$datapassed4, TRUE); 
        }
        else 
        {
            $data4="";
        }
			

		$alldata = array("mechanics"=>$data,"points"=>$data1,"catlist"=>$data2,"currpoints"=>$data4,"jsvar"=>$jsvar);
		echo json_encode($alldata);
		// var_dump($datapassed2);
		// var_dump($datapassed['compstmt'] );
		// echo "========================";
		// var_dump($datapassed['compstmt'] );
	}
	
	function calculateCustomPoints()
	{
		// Invoke this Service only if COMP_STMT_TITLE contains INTCALC in its content
		// Format for the data in COMP_STMT_TITLE is "INTCALC:INCOME=[CAKEPRICE]*30;"
		// INCOME and CAKEPRICE are points parameters stored based on previous selections
		$ugsStatusId = $_POST['ugsStatusId'];
		$compstmtcode = $_POST['compstmtcode'];
		$playstmtcode = $_POST['playstmtcode'];
		$playEntry1 = $_POST['playEntry1'];
        $this -> load -> model('Dialogueservice_model');			
		$compStmtDtls = $this -> Dialogueservice_model -> getDetailsForCompStmtCode($compstmtcode);
		$title = $compStmtDtls[0]['COMP_STMT_TITLE'];
		if(strpos($title,'INTCALC')!==false)
		{
			$titlearray = explode(':',$title);
			$formulaarray = explode('=',$titlearray[1]);
			$targetparam = $formulaarray[0];
			$input = $formulaarray[1];
			$storedData = $this -> Dialogueservice_model -> getPlayerPointsForGamesInternalCalc($ugsStatusId);
			$value = array();
			for ($i=0; $i < count($storedData) ; $i++) 
			{
				$value[$storedData[$i] -> POINTS_PARAM_DESC]=$storedData[$i] -> TOTAL;
			}
			$input = '$calcValue = '.str_replace(']','\']',str_replace('[','$value[\'',$input)).';';
			eval($input);
			$this -> Dialogueservice_model -> insertSystemPoints($targetparam,$calcValue,$ugsStatusId);			
			if ($calcValue == $playEntry1) // Value of income from Player Points Table
			{
				// if value is correct insert points to be updated.
				$this -> Dialogueservice_model -> insertPoints($playstmtcode,$ugsStatusId);
			}		
		}
		if(strpos($title,'INTGAME')!==false)
		{
			$titlearray = explode(':',$title);
			$targetparam = $titlearray[1];			
			$this -> Dialogueservice_model -> insertSystemPoints($targetparam,$playEntry1,$ugsStatusId);
		}
		echo json_encode("Success");
	}
	
	function getCompStmtsForGame()
    {
        $this -> load -> model('Dialogueservice_model');	
		$ugsStatusId = $_POST['ugsStatusId'];
		
		$gameDetails = $this -> Dialogueservice_model -> getDetailsForUgsId($ugsStatusId);
		$gameId = $gameDetails [0] -> GAME_ID;
		
		$in = $_POST['compstmtparam'];
		if($gameId==26)
        {
            $datapassed['pendingTasks'] = json_decode(json_encode($this -> Dialogueservice_model -> getCompStmtsForGame($in,'SUMMARY','COMPLETED',$ugsStatusId,'')),true);
        }
        else 
        {
            $datapassed['pendingTasks'] = json_decode(json_encode($this -> Dialogueservice_model -> getCompStmtsForGame($in,'SUMMARY','PENDING',$ugsStatusId,'')),true);
        }
				
		$data=$this->load->view($this -> viewlist[$gameId]['taskcatlist'],$datapassed, TRUE);
		echo json_encode($data);
    }	
	
	function getPoints()
    {
        $this -> load -> model('Dialogueservice_model');	
		$ugsStatusId = $_POST['ugsStatusId'];
		
		$gameDetails = $this -> Dialogueservice_model -> getDetailsForUgsId($ugsStatusId);
		$gameId = $gameDetails [0] -> GAME_ID;
		
		$datapassed['pointsList'] = json_decode(json_encode($this -> Dialogueservice_model -> getPlayerPointsForGame($ugsStatusId)),true);
				
		$data=$this->load->view($this -> viewlist[$gameId]['points'],$datapassed, TRUE);
		echo json_encode($data);
    }		
	
	function getFilters()
    {
        $this -> load -> model('Dialogueservice_model');	
		$gameId = $_POST['gameId'];
		$parentFilterId = $_POST['parentFilterId'];
		$filterType = $_POST['filterType'];
		$compstmtcode = $_POST['compstmtcode'];
		$filterinput = $_POST['filterinput'];
		
		if ($filterType != 'GROUPED')
		$datapassed['filterList'] = json_decode(json_encode($this -> Dialogueservice_model -> getFiltersForGame($gameId,$parentFilterId,$filterType)),true);
		$datapassed['gpfilterList'] = json_decode(json_encode($this -> Dialogueservice_model -> getFiltersForGame($gameId,$parentFilterId,$filterType)),true);	
		if ($filterinput== '')
			$filterinput = '\'GROUPED='.$parentFilterId.'\'';
		$datapassed['answerList'] = json_decode(json_encode($this -> Dialogueservice_model -> getPlayStmtsForGameFilter($filterinput)),true);						
		$data=$this->load->view($this -> viewlist[$gameId]['filter'],$datapassed, TRUE);
		echo json_encode($data);
    }		
	
	function getHistory()
    {
        $this -> load -> model('Dialogueservice_model');	
		$ugsStatusId = $_POST['ugsStatusId'];
		$gameDetails = $this -> Dialogueservice_model -> getDetailsForUgsId($ugsStatusId);
		$gameId = $gameDetails [0] -> GAME_ID;
		
		$datapassed['historyList'] = json_decode(json_encode($this -> Dialogueservice_model -> getHistory($ugsStatusId)),true);
		
        		
		$data=$this->load->view($this -> viewlist[$gameId]['history'],$datapassed, TRUE);
		echo json_encode($data);
    }
    function getFeedback()
    {
        $this -> load -> model('Dialogueservice_model');	
		$this -> load -> model('Negotiation_model');
		$ugsStatusId = $_POST['ugsStatusId'];
		
		$gameDetails = $this -> Dialogueservice_model -> getDetailsForUgsId($ugsStatusId);
		$gameId = $gameDetails [0] -> GAME_ID;
        $parameterCode = 'GROUPED';
		$datapassed['pointsList'] = json_decode(json_encode($this -> Dialogueservice_model -> getPercentTargetAchievedForStory($ugsStatusId,'Y')),true);
		$datapassed['payoffScore'] = json_decode(json_encode($this -> Negotiation_model -> getPayoffScore($ugsStatusId)),true);		
		$datapassed['groupchart'] = json_encode($this -> Dialogueservice_model -> getPlayerAnswersCategoryCountForStory($ugsStatusId,'GROUPED'));
        $datapassed['standchart'] = json_encode($this -> Dialogueservice_model -> getPlayerAnswersCategoryCountForStory($ugsStatusId,'STANDALONE'));
        $datapassed['progress'] = json_decode(json_encode($this -> Dialogueservice_model -> getPercentTargetAchievedForStory($ugsStatusId,'N')),true);
        $datapassed['gameId'] = $gameId;
        $data=$this->load->view($this -> viewlist[$gameId]['levelcomp'],$datapassed, TRUE);
       // $alldata=array("levelComp"=> $data,"Chart"=>$datapassed['pointschart']);
        echo json_encode($data);
    }	
	
    function getSettings()
    {
        // not sure whether these lines are required//
        $this -> load -> model('Dialogueservice_model');	
		$ugsStatusId = $_POST['ugsStatusId'];
		
		$gameDetails = $this -> Dialogueservice_model -> getDetailsForUgsId($ugsStatusId);
		$gameId = $gameDetails [0] -> GAME_ID;
		$datapassed['settingsList'] = json_decode(json_encode($this -> Dialogueservice_model -> getSettingsForGame($ugsStatusId)),true);
		//***********
		
		$historyAvailable = $this -> Dialogueservice_model -> getHistory($ugsStatusId);
		if(count($historyAvailable)>0)
		{
			$datapassed['historyAvailable'] = "YES";
		}
		else
		{
			$datapassed['historyAvailable']="NO";
		}
        $data=$this->load->view($this -> viewlist[$gameId]['settings'],$datapassed, TRUE);
        echo json_encode($data);
    }
    function getUniqueNegStyle($negStyleList)
    {
        $negStyle = array();
        $negStyle[] = 'Walk Off';
            foreach ($negStyleList as $row) 
            {
                if(!empty($row['FILTER']))
                {
                    if($row['filter_type']=='GROUPED')
                    {
                        $negStyle[] = $row['FILTER'];
                    }
                }
            }
            $uniquenegStyle = array_values(array_unique($negStyle));
            return $uniquenegStyle;
    }
	function getHelp()
    {
        // not sure whether these lines are required//
        // $this -> load -> model('Dialogueservice_model');	
		// $ugsStatusId = $_POST['ugsStatusId'];
		
		// $gameDetails = $this -> Dialogueservice_model -> getDetailsForUgsId($ugsStatusId);
		// $gameId = $gameDetails [0] -> GAME_ID;
		// $datapassed['settingsList'] = json_decode(json_encode($this -> Dialogueservice_model -> getSettingsForGame($ugsStatusId)),true);
		//***********
		$datapassed['helpList'] = "";
        $data=$this->load->view('negotiation/help_view',$datapassed, TRUE);
        echo json_encode($data);
    }
	   function getMinigame()
    {
        $datapassed['minigame'] = "";
        $data=$this->load->view('game/minigame_view',$datapassed, TRUE);
        echo json_encode($data);
    }
}
