<?php

class Story_mstr extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->helper(array('form','url','html'));
        $this->load->library(array('session', 'form_validation'));
        $this->load->model('user_model');
        // if(!$this->session->userdata('login'))
        // {
        //     redirect("master/Story_mstr");
        // }
    }
    function index()
    {
        $this -> load -> view('master/master_login_view');
    }
    function login()
	{
		$data = array('success' => false, 'messages' => array());
		$uimage = 'resources/img/blank_user.png';
		// get form input
		$emailId = $this->input->post("email");
		$password = $this->input->post("psw");

		// form validation
		$this->form_validation->set_rules("email", "Email Id", "trim|required");
		$this->form_validation->set_rules("psw", "Password", "trim|required");
			
		if ($this -> form_validation -> run()==FALSE)
		{
			//$this->session->set_flashdata('msg', '<span class="text-danger text-center">Login Error</span>');
			foreach ($_POST as $key => $value) 
			{
				$data['messages'][$key] = form_error($key);
			}               
			$this->session->set_flashdata('msg', '<span class="text-danger text-center">'.$data.'</span>');
			redirect("master/Story_mstr");
			//$this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Invalid Login Credentials.</div>');
		}
		else 
		{
			// check for user credentials
            $this -> load -> model('user_model');
			$uresult = $this->user_model->get_user_from_stratupdb($emailId, $password);
			if (count($uresult)>0)
			{
				 $userDtls = $this->user_model->get_user_by_id($uresult[0]->USER_ID);
				$uimage = $uresult[0]->PROFILE_PIC_PATH;
				if(!isset($uresult[0]->PROFILE_PIC_PATH))
				{
					$uimage = 'resources/img/blank_user.png';
				} 
				
				// set session
				$sess_data = array('login' => TRUE, 
                                            'uname' => $uresult[0]->FIRST_NAME,
                                            'uid' => $uresult[0]->USER_ID,
                                            'emailid' => $uresult[0]->EMAIL_ID,
                                            'uimage'=>$uimage,
                                            'usertype'=>$userDtls[0]->USER_TYPE_NAME,
                                            );
				$this->session->set_userdata($sess_data);
									
				if($sess_data['usertype'] !="Admin" && $sess_data['usertype'] != "Trainer")
				{
					$this->session->set_flashdata('msg_login', '<div class="alert alert-danger text-center">Sorry, you don\'t have access to login.</div>');
					redirect('master/Story_mstr');
				}
				else
				{
					$data['success'] = true;
					// echo json_encode($data);
					redirect("master/Story_mstr/getListofGamePortals");
				}
			} 
			else
			{
				$this->session->set_flashdata('msg_login', '<div class="alert alert-danger text-center">Invalid Login Credentials</div>');
				redirect('master/Story_mstr');
			}
		}
    }
    function logout()
	{
        // destroy session
        $data = array('login' => '', 
                       'uname' => '',
                       'uid' => '', 
                       'emailid'=>'',
                       'uimage'=>'',
                       'usertype'=>'');
        $this->session->unset_userdata($data);
        $this->session->sess_destroy();
        // $data['_view'] = 'prelogin/login_view';
            // $this->load->view('layouts/main_view', $data);
            redirect('master/Story_mstr'); 
    }
    function getListofGamePortals()
    {
        if(!$this -> session -> userdata('login'))
        {
            redirect('master/Story_mstr'); 
        }
        $this -> load -> model('Master_model');
        $data['listofGames'] = json_decode(json_encode($this -> Master_model -> getListofPortalGame()),true);
        $data['_view']= "master/main_games_list_view";
        $this -> load -> view('master/master_main_view',$data);
    }
    function getGameletsList()
    {
        $this -> load -> model('Master_model');
        $data['gameList'] = json_decode(json_encode($this -> Master_model -> getgameMstrForGamelets()),true);
        $data['_view']= "master/game_mstr_view";
        $this -> load -> view('master/master_main_view',$data);
    }
    function addgameView()
    {
        $this -> load -> model('Master_model');
        $datapassed = "";
		$data = $this -> load -> view('master/game_mstr_add_view',$datapassed,TRUE);
		$alldata = array("addView"=>$data);
		echo json_encode($alldata);		 
    }
    function addGameMstr()
    {
        $this -> load -> model('Master_model');
        if(isset($_POST) && count($_POST) > 0)     
        {
            $error = false;
            $required = array('gameTitle', 'gameDesc', 'gameStatus');

            // make sure each Mandatory fields exists and is not empty
            //if input fields are in array then based on count loop will execute else count will be zero
            $error = $this->validationForMandatoryFields($required,0);
            if($error == false)
            {
                $gameparam = array(
                    'GAME_TITLE' => $this->input->post('gameTitle'),
                    'GAME_DESC' => $this->input->post('gameDesc'),
                    'GAME_LOGO_PATH' => $this->input->post('gameimageurl'),
                    'SPLASH_SCREEN_PATH' => $this->input->post('splashScreenurl'),
                    'GAME_CAT_ID' => "8",
                    'SEQ_NO' => $this->input->post('gameSeqNo'),
                    'STATUS' => $this->input->post('gameStatus'),
                    'UNITY_SEQ_NO' => $this->input->post('unitySeqNo'),
                );
                $addgame = $this->Master_model->addgamemstr($gameparam);
                $data['success'] = true;
                $data['messages']['msg_game'] = '<div class="alert alert-success text-center">Inserted Successfully.</div>';
            }
            else
            {
                $data['success'] = false;
                $data['messages']['msg_game'] = '<div class="alert alert-danger text-center">Please Enter Mandatory Fields.</div>';
            }            
        }
        else
        {
            $data['success'] = false;
            $data['messages']['msg_game'] = '<div class="alert alert-danger text-center">oops! Something went wrong.</div>';
        }
        echo json_encode($data);		
    }
    function updategameView($gameId)
    {
        $this -> load -> model('Master_model');
        $datapassed['gameDetails'] = json_decode(json_encode($this -> Master_model -> getGameDetailsById($gameId)),true);;
		$data = $this -> load -> view('master/game_mstr_edit_view',$datapassed,TRUE);
		$alldata = array("editView"=>$data);
		echo json_encode($alldata);		 
    }
    function updateGameMstr()
    {
        $this -> load -> model('Master_model');
        if(isset($_POST) && count($_POST) > 0)     
        {
            $error = false;
            $required = array('gameTitle', 'gameDesc', 'gameStatus');

            // make sure each Mandatory fields exists and is not empty
            //if input fields are in array then based on count loop will execute else count will be zero
            $error = $this->validationForMandatoryFields($required,0);
            if($error == false)
            {
                $gameparam = array(
                    'GAME_TITLE' => $this->input->post('gameTitle'),
                    'GAME_DESC' => $this->input->post('gameDesc'),
                    'GAME_LOGO_PATH' => $this->input->post('gameimageurl'),
                    'SPLASH_SCREEN_PATH' => $this->input->post('splashScreenurl'),
                    'GAME_CAT_ID' => "8",
                    'SEQ_NO' => $this->input->post('gameSeqNo'),
                    'STATUS' => $this->input->post('gameStatus'),
                    'UNITY_SEQ_NO' => $this->input->post('unitySeqNo'),
                );
                $gameId = $this->input->post('gameId');
                $updategame = $this->Master_model->updategamemstr($gameparam,$gameId);
                $data['success'] = true;
                $data['messages']['msg_game'] = '<div class="alert alert-success text-center">Updated Successfully.</div>';
            }
            else
            {
                $data['success'] = false;
                $data['messages']['msg_game'] = '<div class="alert alert-danger text-center">Please Enter Mandatory Fields.</div>';
            }            
        }
        else
        {
            $data['success'] = false;
            $data['messages']['msg_game'] = '<div class="alert alert-danger text-center">oops! Something went wrong.</div>';
        }
        echo json_encode($data);		
    }
    function getStoryMapping()
    {
        $this -> load -> model('Master_model');  
        $data['gameList'] = json_decode(json_encode($this -> Master_model -> getGame()),true);
      
        $gameId = $this->input->post('GAME_ID');
        $in = $this->session->flashdata('in');

        if($in !='')
        {
            $data['storyMap']= json_decode(json_encode($this -> Master_model ->getstorymapforgame($in)),true);
            $data['gameId']=  $in;
            $data['selectedgame'] = $in;
        }
        else
        {
            $data['storyMap']= json_decode(json_encode($this -> Master_model ->getstorymapforgame($gameId)),true);
            $data['gameId']=  $gameId;
            // $data['storyId']=  $storyId;
        }
        $data['_view'] = 'master/story_mapping_view';
        $this -> load -> view('master/master_main_view',$data);
    }

    function getstorymapbyid($gameId,$storyId)
    {
        $this -> load -> model('Master_model');
        $story = $this -> Master_model ->getstorymapforgame($gameId, $storyId);
        echo json_encode($story);
    }

    function storymapedited()
    {
        $this -> load -> model('Master_model');
        
        $gameid = $this->input->post('gameId');
        $storyid = $this->input->post('storyId');
        
        if(isset($_POST) && count($_POST) > 0)     
        {   
            $storyparams = array(
                'TIME_LIMIT_SECONDS' => $this->input->post('timelmt'),
                'ACTIVE' => $this->input->post('active'),
                'STAR_MAX_VAL' => $this->input->post('maxvalue'),
                'SUCCESS_DESC' => $this->input->post('sucDesc'),
                'FAILURE_DESC' => $this->input->post('failDesc'),
            );
            $story=$this->Master_model->updatestorymapforgame($gameid,$storyid,$storyparams);
            $this->session->set_flashdata('in',$gameid);
            $this->session->set_flashdata('sin',$storyid);
            redirect("master/Story_mstr/getStoryMapping");
        }
    }

    function addStoryMapView($gameId)
    {      
        $this -> load -> model('Master_model');
        $data['gameId'] = $gameId;
        $data['storyList'] = json_decode(json_encode($this -> Master_model -> getStory()),true);
        $this -> load -> view('master/story_mapping_add_view',$data);
    }

    function addStorymap()
    {
        $this -> load -> model('Master_model');
        //   $data['gameList'] = json_decode(json_encode($this -> Master_model -> getGame()),true);
     
        if(isset($_POST) && count($_POST) > 0)     
        {
            $gameId = $this->input->post('GAME_ID');
           // $storyId = $this->input->post('STORY_ID');
            $params = array(
                'GAME_ID' => $gameId,
                'STORY_ID' => $this->input->post('STORY_ID'),
                'TIME_LIMIT_SECONDS' => $this->input->post('Time_limit'),
                'ACTIVE' => $this->input->post('active_status'),
                'STAR_MAX_VAL' => $this->input->post('star_max'),
                'SUCCESS_DESC' => $this->input->post('Succ_Desc'),
                'FAILURE_DESC' => $this->input->post('Fail_Desc'),
            );
            
            $addStory = $this->Master_model->addstorymapforgame($params);
            $this->session->set_flashdata('in',$gameId);
            redirect("master/Story_mstr/getStoryMapping");
        }
        $this -> load -> view('master/story_mstr_add_view',$data);
    }

    function getcompStmt($gameId,$storyId)
    {
        if(!$this -> session -> userdata('login'))
        {
            redirect('master/Story_mstr'); 
        }
        $this -> load -> model('Master_model'); 
        $data['gameId']=$gameId; 		
        $data['storyId']=$storyId;
        $data['storyDtls'] = json_decode(json_encode($this -> Master_model -> getStoryById($storyId)),true);
        $data['compStmt']= json_decode(json_encode($this -> Master_model -> getCompStmtbystorywithPlayerStmtFlag($storyId)),true);
        //$this -> load -> view('master/compstm_mstr_view',$data);
        $data['_view']= "master/compstm_mstr_view";
        $this -> load -> view('master/master_main_view',$data);
    }

    function getplayerStmt($compId,$storyId)
    {     
      $this -> load -> model('Master_model');  
        $datapassed['playerStmt'] = json_decode(json_encode($this -> Master_model -> getPlayerStmtWithStatusForCompId($compId)),true);
        $datapassed['storyId'] = $storyId;
        $datapassed['compId'] = $compId;
        $data=$this->load->view('master/play_stmt_view',$datapassed,TRUE);
        echo json_encode($data);
    }
    function updateCompStmtView($compId)
    {
        $this -> load -> model('Master_model');
        $datapassed['compstmt'] = $this -> Master_model ->getCompStmtbyId($compId);
        $datapassed['compStmttype']= json_decode(json_encode($this -> Master_model -> getCompStmttype()),true);
        $data=$this->load->view('master/compstmt_edit_view',$datapassed,TRUE);
        $alldata = array("editView"=>$data,"compstmt"=>$datapassed['compstmt'] );
        echo json_encode($alldata);
    }
    function updateCompStmt()
    {
        $this -> load -> model('Master_model');
        
        $compId = $this->input->post('compId');
        //$storyId = $this->input->post('storyId');
        if(isset($_POST) && count($_POST) > 0)     
        {   
            $error = false;
            $required = array('compDesc', 'compType');

            // make sure each Mandatory fields exists and is not empty
            //if input fields are in array then based on count loop will execute else count will be zero
            $error = $this->validationForMandatoryFields($required,0);
            if($error == false)
            {
                $compstmtparams = array(
                    'COMP_STMT_TITLE' => $this->input->post('compTitle'),
                    'COMP_STMT_DESC' => $this->input->post('compDesc'),
                    'COMP_STMT_TYPE' => $this->input->post('compType'),
                    'MEDIA_URL' =>  $this->input->post('imageurl'),
                    'PLAYER_MEDIA_URL' => $this->input->post('imagePlayerurl'),
                    'IMG_BG' => $this->input->post('imagebgurl'),
                );
                $story=$this->Master_model->updatecompStmtbyId($compId,$compstmtparams);
                //  $this->session->set_flashdata('in',$storyId);
                // redirect("master/Story_mstr/getcompStmt");
                $data['success'] = true;
                $data['messages']['msg_editcompstmt'] = '<div class="alert alert-success text-center">Updated Successfully.</div>';
            }
            else
            {
                $data['success'] = false;
                $data['messages']['msg_editcompstmt'] = '<div class="alert alert-danger text-center">Please Enter Mandatory fields.</div>';
            }
        }
        else
        {
            $data['success'] = false;
            $data['messages']['msg_editcompstmt'] = '<div class="alert alert-danger text-center">oops! Something went wrong.</div>';
        }
        echo json_encode($data);		
    }
    function addcmpStmtView($storyId)
    {
		$this -> load -> model('Master_model');
        $datapassed['storyId'] = $storyId;
        $datapassed['storyDtls'] = json_decode(json_encode($this -> Master_model -> getStoryById($storyId)),true);
		$datapassed['compStmttype']= json_decode(json_encode($this -> Master_model -> getCompStmttype()),true);
		$data = $this -> load -> view('master/compstmt_add_view',$datapassed,TRUE);
		$alldata = array("editView"=>$data);
		echo json_encode($alldata);		 
    }
    function addCompStmt()
    {
        $this->load->library('upload');
         $this -> load -> model('Master_model');
     //  $data['storyList'] = json_decode(json_encode($this -> Master_model -> getStory()),true);
        if(isset($_POST) && count($_POST) > 0)     
        {
            $error = false;
            $required = array('compDesc', 'compType');

            // make sure each Mandatory fields exists and is not empty
            //if input fields are in array then based on count loop will execute else count will be zero
            $error = $this->validationForMandatoryFields($required,0);
            if($error == false)
            {
                $storyId = $this->input->post('STORY_ID');
                $maxcompcode = $this->Master_model->getmaxCompcodeForStory($storyId);
                $compcode = $maxcompcode[0] -> COMP_STMT_CODE;
                if($compcode != '')
                {
                    $compStmtCode = (1000+$storyId).$compcode;
                }
                else {
                    $compStmtCode = (1000+$storyId).'1';
                }
                //get count of comp stmt except level complete
                //if count is greater than 0 then add this as initial comp stmt for story
                // else don't add this as initial comp stmt for story
                $countofCompStmtForStory = $this->Master_model->getCountOfCompStmtCountExceptLevelComp($storyId);

                if($countofCompStmtForStory[0]->COUNT_OF_COMP_STMT == 0)
                {
                    $params = array("START_COMP_STMT_CODE" => $compStmtCode);
                    $this->Master_model->updatestorymstr($params,$storyId);
                }

                $compstmtparams = array(
                    'COMP_STMT_CODE' => $compStmtCode,
                    'COMP_STMT_TITLE' => $this->input->post('compTitle'),
                    'COMP_STMT_DESC' => $this->input->post('compDesc'),
                    'COMP_STMT_TYPE' => $this->input->post('compType'),
                    'MEDIA_URL' =>  $this->input->post('imageurl'),
                    'PLAYER_MEDIA_URL' => $this->input->post('imagePlayerurl'),
                    'IMG_BG' => $this->input->post('imagebgurl'),
                );
                $addcompStmt = $this->Master_model->addcompStmtForstory($compstmtparams);              
                
                //$this->session->set_flashdata('in',$storyId);
                /*$target = "resources/img/";
                $target = $target . basename( $_FILES['Filename']['name']);

                //This gets all the other information from the form
                $Filename=basename( $_FILES['Filename']['name']);
                if(move_uploaded_file($_FILES['Filename']['tmp_name'], $target)) {
                    // insert into Database
                    $compstmtparams = array(
                        'COMP_STMT_CODE' => $compStmtCode,
                        'COMP_STMT_TITLE' => $this->input->post('compTitle'),
                        'COMP_STMT_DESC' => $this->input->post('compDesc'),
                        'COMP_STMT_TYPE' => $this->input->post('compType'),
                        'MEDIA_URL' => $target,
                    );
                    $addcompStmt = $this->Master_model->addcompStmtForstory($compstmtparams);
                } else {
                    //Gives and error if its not
                    echo "Sorry, there was a problem uploading your file.";
                }*/

                $data['success'] = true;
                $data['comp_stmt_code'] = $compStmtCode;
                $data['messages']['msg_compstmt'] = '<div class="alert alert-success text-center">Inserted Successfully.</div>';
            }
            else
            {
                $data['success'] = false;
                $data['comp_stmt_code'] = $compStmtCode;
                $data['messages']['msg_compstmt'] = '<div class="alert alert-danger text-center">Please Enter Mandatory fields.</div>';
            }
        }
        else
        {
            $data['success'] = false;
            $data['comp_stmt_code'] = '';
            $data['messages']['msg_compstmt'] = '<div class="alert alert-danger text-center">oops! Something went wrong.</div>';
        }
        // $this -> load -> view('master/compstmt_add_view',$data);
        echo json_encode($data);
    }
    function getpointsParam($playId,$storyId)
    {
      $this -> load -> model('Master_model');  
     $datapassed['pointspara'] = json_decode(json_encode($this -> Master_model -> getpointsparaForplayId($playId)),true);
     $datapassed['playId'] = $playId;
     $datapassed['storyId'] = $storyId;
       $data=$this->load->view('master/points_param_view',$datapassed,TRUE);
       
       echo json_encode($data);
    }
    function updateplayStmtView($compId,$playId,$storyId)
    {
        $this -> load -> model('Master_model');
        $datapassed['compId'] = $compId;
        $datapassed['storyId'] = $storyId;
        $datapassed['playId'] = $playId;
        $datapassed['playerstmt'] = json_decode(json_encode($this -> Master_model ->getplaystmtForPlayId($playId)),true);
        $datapassed['compstmtDetails'] =  json_decode(json_encode($this -> Master_model ->getCompStmtbyId($compId)),true);
        $datapassed['destncompstmt'] = json_decode(json_encode($this -> Master_model ->getCompStmtbystoryForDestn($storyId,$compId)),true);
        $data=$this->load->view('master/play_stmt_edit_view',$datapassed,TRUE);
         $alldata = array("editView"=>$data,
        "playId"=>$datapassed['playId'] );
         echo json_encode($alldata);
    }
    function updateplayStmt()
    {
       $this -> load -> model('Master_model');
        
        $playId = $this->input->post('playId');
        if(isset($_POST) && count($_POST) > 0)     
        {   
            $error = false;
            $required = array('playDesc', 'DESIT_STMT_CODE');
            // make sure each Mandatory fields exists and is not empty
            //if input fields are in array then based on count loop will execute else count will be zero
            $error = $this->validationForMandatoryFields($required,0);

            if($error == false)
            {
                $playstmtparams = array(
                    'PLAY_STMT_DESC' => $this->input->post('playDesc'),
                    'DESTN_COMP_STMT_CODE' => $this->input->post('DESIT_STMT_CODE'),
                    'MEDIA_URL' =>  $this->input->post('playerstmt-imageurl'),
                );
                $playerstmt=$this->Master_model->updateplayerStmtbyId($playId,$playstmtparams);
                $data['success'] = true;
                $data['messages']['msg_editplayerstmt'] = '<div class="alert alert-success text-center">Updated Successfully.</div>'; 
            }
            else
            {
                $data['success'] = false;
                $data['messages']['msg_editplayerstmt'] = '<div class="alert alert-danger text-center">Please Enter Mandatory fields.</div>';
            }
        }
        else
        {
            $data['success'] = false;
            $data['messages']['msg_editplayerstmt'] = '<div class="alert alert-danger text-center">oops! Something went wrong.</div>';
        }
        echo json_encode($data);
    }
    function addplayStmtView($compId,$storyId)
    {    
		$this -> load -> model('Master_model');
		$datapassed['compId'] = $compId;
        $datapassed['storyId'] = $storyId;
        $datapassed['compstmtDetails'] =  json_decode(json_encode($this -> Master_model ->getCompStmtbyId($compId)),true);
        $datapassed['destncompstmt'] = json_decode(json_encode($this -> Master_model ->getCompStmtbystoryForDestn($storyId,$compId)),true);
        $datapassed['compStmttype']= json_decode(json_encode($this -> Master_model -> getCompStmttype()),true);
        $datapassed['paramMstr'] = json_decode(json_encode($this -> Master_model ->getPointsparammstr()),true);
        $levelcompeteDtls = json_decode(json_encode($this -> Master_model -> getLevelCompeleteCompStmtId($storyId)),true);
        if(count($levelcompeteDtls)>0 )
        {
            $datapassed['levecomplete'] = $levelcompeteDtls;
        }
        else
        {
            $datapassed['levecomplete'] = array();
        }
		$data = $this -> load -> view('master/play_stmt_add_view',$datapassed,TRUE);
		$alldata = array("editView"=>$data,"compId"=>$datapassed['compId']);
		echo json_encode($alldata);			
    }
    function addPlayerStmt()
    {    
         $this -> load -> model('Master_model');
         $checktoaddplayerStmt = $this->input->post('newPlayerStmt');
         $neworexisting = $this->input->post('selectCompStmt');
        if(isset($_POST) && count($_POST) > 0)     
        {
            $error = false;
            if($checktoaddplayerStmt == "yes")
            {
                $required = array('playDesc');
                // make sure each Mandatory fields exists and is not empty
                //if input fields are in array then based on count loop will execute else count will be zero
                $error = $this->validationForMandatoryFields($required,0);
                if($neworexisting == 'newCompStmt' && $error == false)
                {
                    $required = array('compDesc', 'compType');
                    $error = $this->validationForMandatoryFields($required,0);
                }
                else if($neworexisting == 'existingCompStmt' && $error == false)
                {
                    $required = array('DESIT_STMT_CODE');
                    $error = $this->validationForMandatoryFields($required,0);
                }
                else if($error == false)
                {
                    $required = array('levelCompleteId');
                    $error = $this->validationForMandatoryFields($required,0);
                }
                if($this->input->post('addPointstoStmt') == "yes" && $error == false)
                {
                    $required = array('POINTS_PARAM_CODE', 'incDecs', 'paraValue');
                    
                    // check for Mandatory fields 
                    //if input fields are in array then based on count loop will execute 
                    $error = $this->validationForMandatoryFields($required,count($_POST['POINTS_PARAM_CODE']));               
                }  
            }
            
            if($error == false)
            {
                $storyId = $this->input->post('storyId');
                // check if its new or existing comp_stmt
                
                $sourceCompStmtCode = $this->input->post('compId');
                $desgncompStmtCode = '';
                $addanotherPlayerStmt = $this->input->post('anotherPlayerStmt');
                if($neworexisting == 'newCompStmt')
                {
                    $maxcompcode = $this->Master_model->getmaxCompcodeForStory($storyId);
                    $compcode = $maxcompcode[0] -> COMP_STMT_CODE;
                    if($compcode != '')
                    {
                        $compStmtCode = (1000+$storyId).$compcode;
                    }
                    else {
                        $compStmtCode = (1000+$storyId).'1';
                    }
                
                    $compstmtparams = array(
                        'COMP_STMT_CODE' => $compStmtCode,
                        'COMP_STMT_TITLE' => $this->input->post('compTitle'),
                        'COMP_STMT_DESC' => $this->input->post('compDesc'),
                        'COMP_STMT_TYPE' => $this->input->post('compType'),
                        'MEDIA_URL' =>  $this->input->post('compstmt-imageurl'),
                    );
                   $this->Master_model->addcompStmtForstory($compstmtparams);
                   $desgncompStmtCode = $compStmtCode;
                }
                else if($neworexisting == 'existingCompStmt')
                {
                    $desgncompStmtCode = $this->input->post('DESIT_STMT_CODE');
                }
                else
                {
                    //level compelete comp stmt
                    $desgncompStmtCode = $this->input->post('levelCompleteId');
                }
                $maxplayercode = $this->Master_model->getmaxstmtcodeForCompId($storyId);
                $playercode = $maxplayercode[0] -> PLAY_STMT_CODE;			
                if($playercode!='')
                {
                    $playerStmtCode = (1000+$storyId).$playercode;
                }
                else 
                {
                    $playerStmtCode = (1000+$storyId).'1';
                }
                $checktoaddplayerStmt = $this->input->post('newPlayerStmt');
                if($checktoaddplayerStmt == "yes")
                {
                    $playerStmtDesc = $this->input->post('playDesc');;
                }
                else
                {
                    $playerStmtDesc = "NULL";
                }
                $playerstmtparams = array(
                    'PLAY_STMT_CODE' => $playerStmtCode,
                    'SOURCE_COMP_STMT_CODE' => $sourceCompStmtCode,
                    'PLAY_STMT_DESC' => $playerStmtDesc,
                    'DESTN_COMP_STMT_CODE' => $desgncompStmtCode,
                    'MEDIA_URL' =>  $this->input->post('playerstmt-imageurl'),
                );
                $addplayStmt = $this->Master_model->addplayStmtForcompCode($playerstmtparams);
               // $this->session->set_flashdata('in',$storyId);
                if($this->input->post('addPointstoStmt') == "yes" && $checktoaddplayerStmt == "yes")
                {
                    for($i=0;$i < count($_POST['POINTS_PARAM_CODE']);$i++)
                    {
                        $pointsparams = array(
                            'PLAY_STMT_CODE' => $addplayStmt,
                            'POINTS_PARAM_CODE' => $_POST['POINTS_PARAM_CODE'][$i],
                            'INCREASE_DECREASE' => $_POST['incDecs'][$i],
                            'VALUE' => $_POST['paraValue'][$i],
                        );
                        $addpointparam = $this->Master_model->addpointsparamForPlayId($pointsparams);
                    }                
                }     
                $data['success'] = true;
                $data['sourceCompStmtCode'] = $sourceCompStmtCode;
                $data['addanotherPlayerStmt'] = $addanotherPlayerStmt;
                $data['messages']['msg_playerstmt'] = '<div class="alert alert-success text-center">Inserted Successfully.</div>'; 
            }
            else
            {
                $data['success'] = false;
                $data['sourceCompStmtCode'] = $sourceCompStmtCode;
                $data['addanotherPlayerStmt'] = $addanotherPlayerStmt;
                $data['messages']['msg_playerstmt'] = '<div class="alert alert-danger text-center">Please Enter Mandatory fields.</div>';
            }  
        }      
        else
        {
            $data['success'] = false;
            $data['sourceCompStmtCode'] = '';
            $data['addanotherPlayerStmt'] = '';
            $data['messages']['msg_playerstmt'] = '<div class="alert alert-danger text-center">oops! Something went wrong.</div>';
        }
       // $this -> load -> view('master/compstmt_add_view',$data);
        echo json_encode($data);
        //$this -> load -> view('master/playstmt_add_view',$data);     
    }
    
    function updatePointsParam()
    {
       $this -> load -> model('Master_model');
        
        $paramId = $this->input->post('paramId');
        if(isset($_POST) && count($_POST) > 0)     
        {   
            $required = array('POINTS_PARAM_CODE', 'incDecs','paraValue');
            // make sure each Mandatory fields exists and is not empty
            //if input fields are in array then based on count loop will execute else count will be zero
            $error = $this->validationForMandatoryFields($required,0);
            if($error == false)
            {
                $params = array(
                    'POINTS_PARAM_CODE' => $this->input->post('POINTS_PARAM_CODE'),
                    'INCREASE_DECREASE' => $this->input->post('incDec'),
                    'VALUE' => $this->input->post('paraValue'),
                );
                $playerstmt=$this->Master_model->updatepointsparambyId($paramId,$params);
                $data['success'] = true;
                $data['messages']['msg_param'] = '<div class="alert alert-success text-center">Updated Successfully.</div>';
            }
            else
            {
                $data['success'] = false;
                $data['messages']['msg_param'] = '<div class="alert alert-danger text-center">Please Enter Mandatory fields.</div>';
            }
        }
        else
        {
            $data['success'] = false;
            $data['messages']['msg_param'] = '<div class="alert alert-danger text-center">oops! Something went wrong.</div>';
        }
        echo json_encode($data);
    }
    function updatepointsParamView($playId,$paramId,$storyId)
    {
        $this -> load -> model('Master_model');
        $datapassed['storyId'] = $storyId;
        $datapassed['playId'] = $playId;
        $datapassed['paramId'] = $paramId;
        $datapassed['pointsparam'] = $this -> Master_model ->getparabyplayparaId($playId,$paramId);
        $datapassed['paramMstr'] = $this -> Master_model ->getPointsparammstrForStoryId($storyId);
        $data=$this->load->view('master/param_edit_view',$datapassed,TRUE);
         $alldata = array("editView"=>$data);
         echo json_encode($alldata);
    }
    function addpointsParamView($playId,$storyId)
    {
		$this -> load -> model('Master_model');
		$datapassed['playId'] = $playId;
		$datapassed['storyId'] = $storyId;
		$datapassed['paramMstr'] = json_decode(json_encode($this -> Master_model ->getPointsparammstrForStoryId($storyId)),true);
		$data=$this->load->view('master/param_add_view',$datapassed,TRUE);
		$alldata = array("editView"=>$data,
		"playId"=>$datapassed['playId'] );
		echo json_encode($alldata);
    }
    function addpointsParam()
    {
        $this -> load -> model('Master_model');
        if(isset($_POST) && count($_POST) > 0)     
        {
            $required = array('POINTS_PARAM_CODE', 'incDecs','paraValue');
            // make sure each Mandatory fields exists and is not empty
            //if input fields are in array then based on count loop will execute else count will be zero
            $error = $this->validationForMandatoryFields($required,0);
            if($error == false)
            {
                $playId = $this->input->post('playId');
                $pointsparams = array(
                    'PLAY_STMT_CODE' => $playId,
                    'POINTS_PARAM_CODE' => $this->input->post('POINTS_PARAM_CODE'),
                    'INCREASE_DECREASE' => $this->input->post('incDecs'),
                    'VALUE' => $this->input->post('paraValue'),
                );
                $addpointparam = $this->Master_model->addpointsparamForPlayId($pointsparams);
                $data['success'] = true;
                $data['messages']['msg_param'] = '<div class="alert alert-success text-center">Inserted Successfully.</div>';
            }
            else
            {
                $data['success'] = false;
                $data['messages']['msg_param'] = '<div class="alert alert-danger text-center">Please Enter Mandatory fields.</div>';
            }
        }
        else
        {
            $data['success'] = false;
            $data['messages']['msg_param'] = '<div class="alert alert-danger text-center">oops! Something went wrong.</div>';
        }
        echo json_encode($data);
    }
    function getPointsparammstr()
    {
        $this -> load -> model('Master_model');
        $datapassed['paramMstr'] = json_decode(json_encode($this -> Master_model ->getPointsparammstr()),true);
		$alldata = array("paramMstr"=>$datapassed['paramMstr']);
		echo json_encode($alldata);	
    }
    function getPointsparamForStoryId($storyId)
    {
        $this -> load -> model('Master_model');
        $datapassed['paramMstr'] = json_decode(json_encode($this -> Master_model ->getPointsparammstrForStoryId($storyId)),true);
		$alldata = array("paramMstr"=>$datapassed['paramMstr']);
		echo json_encode($alldata);	
    }
    public function getAllImageFromResource()
    { 
        $dirname = "resources/img/";
        $images = glob($dirname.'*.{jpg,JPG,jpeg,JPEG,png,PNG}',GLOB_BRACE);
        $sorted_files=array(); /* a new array that have modification time as values
        and files as keys the purpose is to sort files according to the values in reverse order */ 
        $i = 0;
        foreach ($images as $file)
        {
            $sorted_files[$i]['time']=filemtime($file);
            $sorted_files[$i]['image']=$file;
            $i++;
        }
        // arsort($sorted_files);
        array_multisort( array_column($sorted_files, "time"), SORT_DESC, $sorted_files );
        $data['images']=array_column($sorted_files, "image");
        echo json_encode($data);
    } 
    public function uploadImagetoResource()
    {        
        if(isset($_FILES['Filename']['name']))
        {
            $config['upload_path'] = './resources/img/';
            $config['allowed_types'] = 'jpg|jpeg|png';
            $this -> load ->library('upload',$config);
            if(!$this->upload->do_upload('Filename'))
            {
               // echo $this->upload->display_errors();
               //Gives and error if its not uploaded
                $data['success'] = "Sorry, there was a problem uploading your file.";
                echo json_encode($data);
            }
            else
            {
                $data = $this->upload->data();

                //to resize the uploaded image
                $config['image_library'] = 'gd2'; // gd2 library to resize image
                $config['source_image'] = './resources/img/'.$data['file_name'];
                $config['create_thumb'] = FALSE;
                $config['maintain_ratio'] = FALSE;
                $config['quality'] = '60%';
                $config['width'] = 1024; //width in pixel
                $config['height'] = 1024; //height in pixel
                $config['new_image'] = './resources/img/'.$data['file_name'];
                $this->load->library('image_lib',$config);
                $this->image_lib->resize();
                $data['success'] = true;
                echo json_encode($data);
            }
        }
    }
    function getGameStatusinExcel($gameId)
    {
        $this->load->model('Master_model');
        $gameStatus = $this->Master_model -> getGameStatus($gameId);
        $data['gameStatus'] = $gameStatus;
       
        require(APPPATH.'third_party/PHPExcel.php');
        require(APPPATH.'third_party/PHPExcel/Writer/Excel2007.php');
          
        //instance of phpexcel
        $objPHPExcel = new PHPExcel();
           
        //set basic standard properties
        $objPHPExcel->getProperties()->setCreator("");
        $objPHPExcel->getProperties()->setLastModifiedBy("");
        $objPHPExcel->getProperties()->setTitle("");
        $objPHPExcel->getProperties()->setSubject("");
        $objPHPExcel->getProperties()->setDescription("");
          
        //create active sheet
        $objPHPExcel->setActiveSheetIndex(0);
          
        //set data values 
        $objPHPExcel->getActiveSheet()->SetCellValue('A1','GAME_TITLE');
        $objPHPExcel->getActiveSheet()->SetCellValue('B1','COMP_STMT_CODE');
        $objPHPExcel->getActiveSheet()->SetCellValue('C1','STORY_TITLE');
        $objPHPExcel->getActiveSheet()->SetCellValue('D1','COMP_STMT_TITLE');
        $objPHPExcel->getActiveSheet()->SetCellValue('E1','COMP_STMT_DESC');
        $objPHPExcel->getActiveSheet()->SetCellValue('F1','COMP_STMT_TYPE');
        $objPHPExcel->getActiveSheet()->SetCellValue('G1','MEDIA_URL');
        $objPHPExcel->getActiveSheet()->SetCellValue('H1','PLAY_STMT_DESC');
        $objPHPExcel->getActiveSheet()->SetCellValue('I1','DEST_COMP_STMT');
        $objPHPExcel->getActiveSheet()->SetCellValue('J1','DEST_COMP_STMT_TYPE');
        $objPHPExcel->getActiveSheet()->SetCellValue('K1','DEST_MEDIA');
        $objPHPExcel->getActiveSheet()->SetCellValue('L1','POINTS');
          
        //add rows to excel
        $row = 2;
        //data is fetched from database
        foreach ($data['gameStatus'] as $value) 
        {
            $objPHPExcel->getActiveSheet()->setCellValue('A'.$row,$value->GAME_TITLE);
            $objPHPExcel->getActiveSheet()->setCellValue('B'.$row,$value->COMP_STMT_CODE);
            $objPHPExcel->getActiveSheet()->setCellValue('C'.$row,$value->STORY_TITLE);
            $objPHPExcel->getActiveSheet()->setCellValue('D'.$row,$value->COMP_STMT_TITLE);
            $objPHPExcel->getActiveSheet()->setCellValue('E'.$row,$value->COMP_STMT_DESC);
            $objPHPExcel->getActiveSheet()->setCellValue('F'.$row,$value->COMP_STMT_TYPE);
            $objPHPExcel->getActiveSheet()->setCellValue('G'.$row,$value->MEDIA_URL);
            $objPHPExcel->getActiveSheet()->setCellValue('H'.$row,$value->PLAY_STMT_DESC);
            $objPHPExcel->getActiveSheet()->setCellValue('I'.$row,$value->DEST_COMP_STMT);
            $objPHPExcel->getActiveSheet()->setCellValue('J'.$row,$value->DEST_COMP_STMT_TYPE);
            $objPHPExcel->getActiveSheet()->setCellValue('K'.$row,$value->DEST_MEDIA);
            $objPHPExcel->getActiveSheet()->setCellValue('L'.$row,$value->POINTS);
            
            $row++;
        }
          
        // create filename
        $filename="Game-Status-Details.xlsx";
        //create title of file
        $objPHPExcel->getActiveSheet()->setTitle("Game ".$gameId);
        
        //access to download the file
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreedsheetml.sheet');
        header('Content-Disposition: attachment;filename="'.$filename.'"');
        header('Cache-COntrol: max-age=0');
        
        $objWriter = \PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        $objWriter->save('php://output');
        //$this->sendmail($file);
        // redirect('game/Main');
        exit;
    }

    function getStory($gameId)
    {
        if(!$this -> session -> userdata('login'))
        {
            redirect('master/Story_mstr'); 
        }
        $this -> load -> model('Master_model');  
        $data['gameId'] = $gameId;
        $data['gameDtls'] = json_decode(json_encode($this -> Master_model ->getGameDetailsById($gameId)),true);
        $data['storymstr']= json_decode(json_encode($this -> Master_model ->getStorymstrWithMapping($gameId)),true);
       // $this -> load -> view('master/story_mstr_view',$data);
        $data['_view']= "master/story_mstr_view";
        $this -> load -> view('master/master_main_view',$data);
    }

    function addStoryMstr()
    {
        $this -> load -> model('Master_model');
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $error = false;
            $required = array('storyTitle', 'storyDesc', 'storyShortDesc', 'storySeqNo');

            // make sure each Mandatory fields exists and is not empty
            //if input fields are in array then based on count loop will execute else count will be zero
            $error = $this->validationForMandatoryFields($required,0);
            if($error == false)
            {
                $paramrequired = array('POINTS_PARAM_CODE', 'targetType', 'targetValue');
                // make sure each Mandatory fields exists and is not empty
                //if input fields are in array then based on count loop will execute else count will be zero
                $error = $this->validationForMandatoryFields($paramrequired,count($_POST['POINTS_PARAM_CODE']));
            }
            if($error == false)
            {
                $storyparam = array(
                    'STORY_TITLE' => $this->input->post('storyTitle'),
                    'STORY_DESC' => $this->input->post('storyDesc'),
                    'STORY_SHORT_DESC' => $this->input->post('storyShortDesc'),
                    'STORY_LANGUAGE' => "English",
                    'STATUS' => "I",
                    'STORY_LOGO_URL' => $this->input->post('storyimageurl'),
                    'STORY_SEQ_NO' => $this->input->post('storySeqNo'),
                );
                $addstoryparam = $this->Master_model->addstorymstr($storyparam);
                $compStmtCode = 1000+$addstoryparam."1";
                $compstmtparams = array(
                    'COMP_STMT_CODE' => $compStmtCode,
                    'COMP_STMT_DESC' => "Level Complete",
                );
                $addcompStmt = $this->Master_model->addcompStmtForstory($compstmtparams);
                for($i=0;$i < count($_POST['POINTS_PARAM_CODE']);$i++)
                {
                    $pointsparams = array(
                        'STORY_ID' => $addstoryparam,
                        'POINTS_PARAM_CODE' => $_POST['POINTS_PARAM_CODE'][$i],
                        'TARGET_TYPE' => $_POST['targetType'][$i],
                        'TARGET' => $_POST['targetValue'][$i],
                    );
                    $addpointparam = $this->Master_model->addpointsparamForStoryId($pointsparams);
                }
                $gameId = $this->input->post('GAME_ID');
            // $storyId = $this->input->post('STORY_ID');
                $params = array(
                    'GAME_ID' => $gameId,
                    'STORY_ID' => $addstoryparam,
                    'TIME_LIMIT_SECONDS' => $this->input->post('Time_limit'),
                    'ACTIVE' => 'A',
                    'STAR_MAX_VAL' => $this->input->post('star_max'),
                    'SUCCESS_DESC' => $this->input->post('Succ_Desc'),
                    'FAILURE_DESC' => $this->input->post('Fail_Desc'),
                );
                
                $addStory = $this->Master_model->addstorymapforgame($params);
                $data['success'] = true;
                $data['messages']['msg_story'] = '<div class="alert alert-success text-center">Inserted Successfully.</div>';
            }
            else
            {
                $data['success'] = false;
                $data['messages']['msg_story'] = '<div class="alert alert-danger text-center">Please Enter Mandatory fields</div>';
            }
        }
        else
        {
            $data['success'] = false;
            $data['messages']['msg_story'] = '<div class="alert alert-danger text-center">oops! Something went wrong.</div>';
        }
        echo json_encode($data);		
    }
    function addstoryView($gameId)
    {
        $this -> load -> model('Master_model');
        $datapassed['gameId'] = $gameId;
		$data = $this -> load -> view('master/story_mstr_add_view',$datapassed,TRUE);
		$alldata = array("addView"=>$data);
		echo json_encode($alldata);		 
    }

    function editstoryView($storyId,$gameId)
    {
        $this -> load -> model('Master_model');
        $datapassed['gameId'] = $gameId;
        $datapassed['storyDetails'] = $this->Master_model->getstoryDetailsById($storyId);
        $datapassed['paramDetails'] = $this->Master_model->getPointsparammstrForStoryId($storyId);
        $datapassed['paramMstr'] = $this -> Master_model ->getPointsparammstr();
		$data = $this -> load -> view('master/story_mstr_edit_view',$datapassed,TRUE);
		$alldata = array("editView"=>$data);
		echo json_encode($alldata);		 
    }
    function editStoryMstr()
    {
        $this -> load -> model('Master_model');
        if(isset($_POST) && count($_POST) > 0)     
        {
            $error = false;
            $required = array('storyTitle', 'storyDesc', 'storyShortDesc', 'storySeqNo');

            // make sure each Mandatory fields exists and is not empty
            //if input fields are in array then based on count loop will execute else count will be zero
            $error = $this->validationForMandatoryFields($required,0);
            if($error == false)
            {
                $paramrequired = array('POINTS_PARAM_CODE', 'targetType', 'targetValue');
                // make sure each Mandatory fields exists and is not empty
                //if input fields are in array then based on count loop will execute else count will be zero
                if(count($_POST['POINTS_PARAM_CODE']) > 0)
                {
                    $error = $this->validationForMandatoryFields($paramrequired,count($_POST['POINTS_PARAM_CODE']));
                }
                else
                {
                    $data['success'] = false;
                    $data['messages']['msg_story'] = '<div class="alert alert-danger text-center">Please Enter Mandatory fields</div>';
                }
            }
            if($error == false)
            {
                $gameId = $this->input->post('gameId');
                $storyId = $this->input->post('storyId');
                $storyparam = array(
                    'STORY_TITLE' => $this->input->post('storyTitle'),
                    'STORY_DESC' => $this->input->post('storyDesc'),
                    'STORY_SHORT_DESC' => $this->input->post('storyShortDesc'),
                    'STORY_LOGO_URL' => $this->input->post('storyimageurl'),
                    'STORY_SEQ_NO' => $this->input->post('storySeqNo'),
                );
                $updatestoryparam = $this->Master_model->updatestorymstr($storyparam,$storyId);
                //update gameStory mapping
                $params = array(
                    'TIME_LIMIT_SECONDS' => $this->input->post('Time_limit'),
                    'STAR_MAX_VAL' => $this->input->post('star_max'),
                    'SUCCESS_DESC' => $this->input->post('Succ_Desc'),
                    'FAILURE_DESC' => $this->input->post('Fail_Desc'),
                );
                
                $updateMapping = $this->Master_model->updatestorymapforgame($gameId, $storyId,$params);
                //update storyparam target
                for($i=0;$i < count($_POST['POINTS_PARAM_CODE']);$i++)
                {
                    if(isset($_POST['targetId'][$i]))
                    {
                        $pointsparams = array(
                            'POINTS_PARAM_CODE' => $_POST['POINTS_PARAM_CODE'][$i],
                            'TARGET_TYPE' => $_POST['targetType'][$i],
                            'TARGET' => $_POST['targetValue'][$i],
                        );
                        $updatepointparam = $this->Master_model->updatepointsparamForStoryId($pointsparams,$_POST['targetId'][$i]);
                    }
                    else
                    {
                        $pointsparams = array(
                            'STORY_ID' => $storyId,
                            'POINTS_PARAM_CODE' => $_POST['POINTS_PARAM_CODE'][$i],
                            'TARGET_TYPE' => $_POST['targetType'][$i],
                            'TARGET' => $_POST['targetValue'][$i],
                        );
                        $addpointparam = $this->Master_model->addpointsparamForStoryId($pointsparams);
                    }                
                }

                $data['success'] = true;
                $data['messages']['msg_story'] = '<div class="alert alert-success text-center">Inserted Successfully.</div>';
            }
            else
            {
                $data['success'] = false;
                $data['messages']['msg_story'] = '<div class="alert alert-danger text-center">Please Enter Mandatory fields</div>';
            }
        }
        else
        {
            $data['success'] = false;
            $data['messages']['msg_story'] = '<div class="alert alert-danger text-center">oops! Something went wrong.</div>';
        }
        echo json_encode($data);		
    }
    function validateAndPublishStory($storyId)
    { 
        $this -> load -> model('Master_model');
        $validateCompstmt = $this->Master_model->validateCompStmtForStoryhasPlayerStmt($storyId);
        $validated = true;
        foreach($validateCompstmt as $validate)
        {
            if($validate->CONFIG == "TODO")
            {
                $validated = false;
                break;
            }
        }
        if($validated == true)
        {
            $checkStoryhasLevelComp = $this->Master_model->checkStoryhasLevelCompt($storyId);
            if($checkStoryhasLevelComp[0]->LEVELCOMP_MAPPED == "YES")
            {
                $params = array("STATUS" => "A");
                $this->Master_model->updatestorymstr($params,$storyId);
                $data['success'] = true;
                $data['messages'] = '<div class="alert alert-success text-center">Story has been validated and Active.</div>';
            }
            else
            {
                $data['success'] = false;
                $data['messages'] = '<div class="alert alert-danger text-center">Level Complete is not Mapped to this Story. Check before publishing.</div>';
            }
        }
        else
        {
            $data['success'] = false;
            $data['messages'] = '<div class="alert alert-danger text-center">Some System Conversation does not have Player Conversation. Check before publishing.</div>';
        }
		echo json_encode($data);		 
    }

    function validationForMandatoryFields($requiredArray,$count)
    {
        //to check if mandatory fields are empty
        $error = false;
        if($count > 0)
        {
            for($i=0;$i<$count;$i++)
            {
                // Loop over field names, make sure each one exists and is not empty
                foreach($requiredArray as $field) 
                {
                    if (empty($_POST[$field][$i])) 
                    {
                        $error = true;
                        break;
                    }
                } 
                if($error == true)
                {
                    break;
                }
            }
        }
        else
        {
            // Loop over field names, make sure each one exists and is not empty
            foreach($requiredArray as $field) 
            {
                if (empty($_POST[$field])) 
                {
                    $error = true;
                    break;
                }
            }
        }
        
        return $error;
    }
}