<?php
class login extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->helper(array('form','url','html'));
		$this->load->library(array('session', 'form_validation'));
		$this->load->database();
		$this->load->model('user_model');
        //unset($_SESSION['msg']); // Need to check if this line is required if the reset password are sent through mail.
	}
    public function index()
    {
		// get form input
		$email = $this->input->post("email");
        $password = $this->input->post("password");
        $clientCode = $this->input->post("clientid");

		// form validation
		$this->form_validation->set_rules("email", "Email-ID", "trim|required");
		$this->form_validation->set_rules("password", "Password", "trim|required");
		$this->form_validation->set_rules("clientid", "ClientID", "trim|required");
        
		if ($this->form_validation->run() == FALSE)
        {
			// validation fail
			$this->load->view('login_view');
		}
		else
		{
			// check for user credentials
			$uresult = $this->user_model->get_user($email, $password);
			if (count($uresult) > 0)
			{
			    // check for email verifed
                $userEmailVerified = $this->user_model->checkEmailVerified($email, $password);
                if(empty($userEmailVerified))
                {
                    $this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Your Email ID is not verified, Check your mail for the link to activate your account.</div>');
                    redirect('login');
                }
            
			    $userDtls = $this->user_model->get_user_by_id($uresult[0]->USER_ID); // need to remove this line.
                $uimage = $uresult[0]->PROFILE_PIC_PATH;
                if(!isset($uresult[0]->PROFILE_PIC_PATH))
                {
                    $uimage = 'resources/img/blank_user.png';
                } 
                $clientValidDtls = $this->user_model->validate_ClientCode_ForLogin($clientCode,$uresult[0]->USER_ID);
                if(count($clientValidDtls)>0)
                {
                    // set session
                    $sess_data = array('login' => TRUE, 
                                        'uname' => $uresult[0]->FIRST_NAME,
                                        'uid' => $uresult[0]->USER_ID,
                                        'clientCode'=>$clientCode,
                                        'usertypeid'=>$uresult[0]->USER_TYPE_ID,
                                        'userimage'=>$uimage,
                                        'utype'=>$userDtls[0]->USER_TYPE_NAME);
                    $this->session->set_userdata($sess_data);
                    // $this->session->mark_as_temp('login', 300);
                    //echo $this->db->last_query();
                    redirect("home");
                }
                else 
                {
                    $this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Invalid Client Code. Check with your professor for the correct code.</div>');
                    redirect('login');
                }
			}
			else
			{
				$this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Invalid Login Credentials.</div>');
				redirect('login');
			}
		}
    }
    
}