<?php
/* 
 * Generated by CRUDigniter v3.2 
 * www.crudigniter.com
 */
 include (APPPATH . 'libraries/CommonUtilities.php');
class Mylearning extends CommonUtilities{
    function __construct()
    {
        parent::__construct();
        if(!$this->session->userdata('login'))
        {
            redirect('login');
        }
        $this->load->model('Mylearning_model');
    } 

    /*
     * Listing of mylearning
     */
    function index()
    {
        $userId=$this->session->userdata('uid'); 
        $this -> load -> model('user_model');
        $details = $this->user_model->get_user_by_id($this->session->userdata('uid'));
        $usertype = $details[0]->USER_TYPE_NAME;
        
        $params['limit'] = RECORDS_PER_PAGE; 
        $params['offset'] = ($this->input->get('per_page')) ? intval($this->input->get('per_page')) : 0;
        
        $config = $this->config->item('pagination');
        $config['base_url'] = site_url('stratup/mylearning/index?');
        $config['total_rows'] = count($this->Mylearning_model->get_all_mylearning_count($userId,$usertype));
        $this->pagination->initialize($config);

        $data['mylearning'] = $this->Mylearning_model->get_all_mylearning($params,$userId,$usertype);
        $data['data'] = array();  
        $data['_view'] = 'stratup/mylearning/index';
        $data['_navview'] = 'nav_view';
        $this->load->view('layouts/main_view',$data);
    }

    /*
     * Adding a new mylearning
     */
    function add()
    {
        $userId = $this->session->userdata('uid');
        
        $this -> load -> model('Mylearning_model');
        $lastgame = $this->Mylearning_model->getLastPlayedgame($userId);
       if(count($lastgame)>0)
       {
        $teamid = $lastgame[0]['TEAM_ID'];
        
        $gameid = $lastgame[0]['GAME_ID'];
        $moveNo = $lastgame[0]['MoveNo'];
        $year = $this->getYear($moveNo);
        $quarter = $this->getQuarter($moveNo, $year); 
       }
       else{
           $teamid = 0;
        
        $gameid = 0;
        $moveNo = 0;
        $year = $this->getYear($moveNo);
        $quarter = $this->getQuarter($moveNo, $year); 
       }
        
        if(isset($_POST) && count($_POST) > 0)     
        {   
            $params = array(
				'YEAR' => $year,
				'QUARTER' => "Q".$quarter,
				'GAME_ID' => $gameid,
				'TEAM_ID' => $teamid,
				'MY_LEARNING' => $this->input->post('MY_LEARNING'),
				'USER_ID' => $userId,
            );
            
            $mylearning_id = $this->Mylearning_model->add_mylearning($params);
            redirect('stratup/mylearning/index');
        }
        else
        {
                        
            $data['_view'] = 'stratup/mylearning/index';
            $data['_navview'] = 'nav_view';
            $this->load->view('layouts/main_view',$data);
        }
    }
    function testmylearn()
    {        
        $data['_view'] = 'samples/diary_view';
        $this->load->view('layouts/main',$data);
    }
}
