<?php
class Signup extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this -> load -> helper(array('form', 'url'));
		$this -> load -> library(array('session', 'form_validation'));
		$this -> load -> database();
		$this -> load -> model('User_model');
	}

	function index()
	{
		$this->form_validation->set_message('is_unique', 'The %s is already taken');
		// set form validation rules
		$this -> form_validation -> set_rules('title', 'Title', 'callback_select_validate');
		$this -> form_validation -> set_rules('fname', 'First Name', 'trim|required|alpha|min_length[3]|max_length[30]');
		$this -> form_validation -> set_rules('lname', 'Last Name', 'trim|required|alpha|max_length[30]');
		//$this -> form_validation -> set_rules('email', 'Email ID', 'trim|required|valid_email|is_unique[user_mstr.EMAIL_ID]');
		$this -> form_validation -> set_rules('email', 'Email', 'callback_is_unique_custom');		
		//$this->form_validation->set_rules('password', 'Password', 'trim|required|matches[cpassword]|md5');
		$this -> form_validation -> set_rules('password', 'Password', 'required');
		$this -> form_validation -> set_rules('cpassword', 'Confirm Password', 'matches[password]');
		$this -> form_validation -> set_rules('loginid', 'Login Id', 'required|alpha_numeric|callback_is_unique_custom_login|strtolower');
        $this -> form_validation -> set_rules('clientcode','Client Code','callback_CCode_valid');
		$this -> form_validation -> set_rules('mobile', 'Mobile Number', 'regex_match[/^[0-9]{10}$/]');
		// $this -> form_validation -> set_rules('dob', 'Date Of Birth', 'required');
		// $this -> form_validation -> set_rules('industryid', 'Industry', 'callback_select_validate');
		// $this -> form_validation -> set_rules('occupation', 'Occupation', 'callback_select_validate');
		
		// submit
		if ($this -> form_validation -> run() == FALSE)
		{
			// fails
			$this -> load -> view('signup_view');
		}
		else
		{
		    $this->db->trans_begin();
		    $gender='Female';
		    if($this -> input -> post('title')=='Mr.')
            {
                $gender='Male';
            }
            $clientcode = $this -> User_model -> checkClientCodeForUserRegister($this -> input -> post('clientcode'));
            $clientId = $clientcode[0]['CLIENT_ID'];
			//insert user details into db
			$data = array(
                        'TITLE' => $this -> input -> post('title'),
                        'FIRST_NAME' => $this -> input -> post('fname'), 
                        'LAST_NAME' => $this -> input -> post('lname'), 
                        'EMAIL_ID' => $this -> input -> post('email'), 
                        'MOBILE_NO' => $this -> input -> post('mobile'),
                        'LOGIN_ID' => $this -> input -> post('loginid'),         
                        'PASSWORD' => $this -> input -> post('password'),
                        'GENDER' => $gender,
                        'EMAIL_VERIFY_TOKEN' => $this->emailToken(),
                        'USER_TYPE_ID' => '3'
            			// 'DATE_OF_BIRTH' => $this -> input -> post('dob'), 
            			// 'HIGHEST_EDUCATIONAL_QUALIFICATION' => $this -> input -> post('qualification'), 
            			// 'OCCUATION_ID' => $this -> input -> post('occupation'), 
            			// 'INDUSTRY_ID' => $this -> input -> post('industryid'),
            			// 'INDUSTRY_ID' => ('1'),
            			);
                        
			if ($this -> User_model -> insert_user($data))
			{
			    $newUserId = $this->db->insert_id();
                $userClientMapData = array(
                'USER_ID'=>$newUserId,
                'CLIENT_ID'=>$clientId
                );
                if($this -> User_model -> insert_userClientMapping($userClientMapData))
                {
                    // $this -> session -> set_flashdata('msg', '<div class="alert alert-success text-center">You are Successfully Registered! Please <a href="'. base_url().'">Click Here</a> to Login </div>');
                    // $this -> load -> view('message_view');
                    //redirect('signup');
                }
                else 
                {
                    // error
                    $this -> session -> set_flashdata('msg', '<div class="alert alert-danger text-center">Oops! Something went wrong. Please try again</div>');
                    //redirect('signup');
                }
			}
			else
			{
				// error
				$this -> session -> set_flashdata('msg', '<div class="alert alert-danger text-center">Oops! Something went wrong. Please try again</div>');
				redirect('signup');
			}
            if ($this->db->trans_status() === FALSE)
            {
                    $this->db->trans_rollback();
                    redirect('signup');
            }
            else
            {
                    $this->db->trans_commit();
                    $this -> session -> set_flashdata('msg', '<div class="alert alert-success text-center">Almost done... </br>Hi '.$data['FIRST_NAME'].' We have sent an email with a confirmation link to your email address. Please allow 5-10 minutes for this message to arrive. Click the link to activate your account.</div>');
                    $this ->sendmail($data['EMAIL_ID'],$data['FIRST_NAME'],$data['LOGIN_ID'],$data['EMAIL_VERIFY_TOKEN']);
                    redirect('signup');
            }
		}
	}

	function select_validate($selectValue)
	{
		// 'none' is the first option and the text says something like "-Choose one-"
		if (empty($selectValue))
		{
			$this -> form_validation -> set_message('select_validate', 'Please Select.');
			return false;
		}
		else// user picked something
		{
			return true;
		}
	}
    function CCode_valid($clientcode)
    {
        if (empty($clientcode))
        {
            $this -> form_validation -> set_message('CCode_valid', 'The Client Code field is required.');
            return false;
        }
        else 
        {
            $data = $this -> User_model -> checkClientCodeForUserRegister($clientcode);
            if (empty($data))
            {
                $this -> form_validation -> set_message('CCode_valid', 'Not a Valid Client Code.');
                return false;
            }
            else// user picked something
            {
                return true;
            }
        }
        
    }

    function sendmail($toemail,$userfullname,$userid,$passwd)
    {
        $this->load->library('email'); // load email library
        $this->email->from(supportMailId);
        $this->email->to($toemail);
        $this->email->cc(''); 
        $this->email->subject('STRATUP Account Verification');
        $this->email->message('<p><span style="font-family:Arial,Helvetica,sans-serif">Hello '.$userfullname.',</span></p>

                                <p>Thank you for registering with STRATUP. Your account is created and must be activated before you can use it.</br>
								To activate the account <a href="'.base_url().'index.php/Signup/verifyEmail?loginId='.$userid.'&hash='.$passwd.'">Click Here</a> or copy-paste the below link in your browser:</p>

                                <p>'.base_url().'index.php/Signup/verifyEmail?loginId='.$userid.'&hash='.$passwd.'</p>

                                <p>After activation you may login using the following username:
                                
                                <p>Your Login ID : '.$userid.'</p>
                                
                                
                                <p>&nbsp;</p>
                                
                                <p>Thanks,</p>
                                
                                <p>Team Processbee</p>');
        // $this->email->attach('/path/to/file1.png'); // attach file
        // $this->email->attach('/path/to/file2.pdf');
        if ($this->email->send())
        {
            //$this->session->set_flashdata('msg', '<div class="alert alert-success text-center"> We have sent your Login Credential to your e-MailID <br /> Please <a href="'.base_url().'"/login/index.php">Click Here</a> to Login</div>');
            //echo "Mail Sent!";
        }
        else
        {
            // $this->session->set_flashdata('msg', '<div class="alert alert-success text-center">We cant find your email address</div>');
            // show_error($this->email->print_debugger());
        }
            
    }
    function generate_key_string($char,$segment) 
    {
        // Modified by : Leela
        // Modified on : 26-02-2018
        // function to create random String
        $tokens = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
        
        // $segment_chars = 8;
        // $num_segments = 1;
        $segment_chars = $char;
        $num_segments = $segment;
        $key_string = '';
        for ($i = 0; $i < $num_segments; $i++) 
        {
            $segment = '';
            for ($j = 0; $j < $segment_chars; $j++) 
            {
                $segment .= $tokens[rand(0, strlen($tokens)-1)];
            }
            $key_string .= $segment;

             if ($i < ($num_segments - 1)) 
             {
                 $key_string .= '-';
             }
        }
        return $key_string;
    }
    function emailToken()
    {
        // function to check duplicate token
        do
        {
            $emailToken = $this -> generate_key_string(16,1);
            $result = $this -> User_model -> getEmailToken($emailToken);
        }
        while ($result != false);
        return $emailToken;
    }
    function verifyEmail()
    {
        $loginId = $_GET['loginId'];
        $token = $_GET['hash'];

        // function to verify new user and update Email Verified
         $data = $this->User_model->verifyEmailToken($loginId,$token);
         if(!$data)
         {
             $this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">Email Verification Failed. Please ensure the link you have entered is correct. </div>');
             $this -> load -> view('message_view');
         }
         else  
         {
             if($data[0]['EMAIL_VERIFIED']==1)
             {
                 $this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Email has been verified successfully.</br> <a href="'.base_url().'">Click Here to Login</a></div>');
                 $this -> load -> view('message_view');
             }
             else 
             {
                 $this->User_model->upateVerifiedUser($data[0]['USER_ID']);
                 $this->session->set_flashdata('msg', '<div class="alert alert-success text-center">Email has been verified successfully.</br> <a href="'.base_url().'">Click Here to Login</a></div>');
                 $this -> load -> view('message_view');
             }
             
         }
    }
function is_unique_custom($emaiId)
	{
		// $username recieves the parameter automatically
	    //Go on with your query as bellow
	    if(empty($emaiId))
		{
			$this -> form_validation->set_message('is_unique_custom','The Email ID field is required.');
			return FALSE;
		}
		else 
		{
			$data = $this -> User_model ->getUserDetailsByEmail($emaiId);
		}
		if(!empty($data))
		{
			$this -> form_validation->set_message('is_unique_custom','This Email ID already registered.');
			return FALSE;
		}
		else 
		{
			return TRUE;
		}
	    
	}
	
function is_unique_custom_login($loginid)
	{
		// $username recieves the parameter automatically
	    //Go on with your query as bellow
	    if(empty($loginid))
		{
			$this -> form_validation->set_message('is_unique_custom_login','The Login ID field is required.');
			return FALSE;
		}
		else 
		{
			$data = $this -> User_model ->getUserDetailsByLogin($loginid);
		}
		if(!empty($data))
		{
			$this -> form_validation->set_message('is_unique_custom_login','This Login ID already registered.');
			return FALSE;
		}
		else 
		{
			return TRUE;
		}
	    
	}	
	
}
