<?php
include (APPPATH. 'libraries/CommonUtilities.php');

class Support extends CommonUtilities 
{
    function __construct()
    {
        parent::__construct();
        if(!$this->session->userdata('login'))
        {
            redirect('login');
        }
        $this -> load -> helper(array('url', 'html'));
        $this -> load -> library('session');
        $this->load->model('stratup/Support_model');
    }
    /*
     * Listing of support_main_tbl
     */
    function index()
    {
        $userId=$this->session->userdata('uid');
        $this -> load -> model('user_model');
        $details = $this->user_model->get_user_by_id($this->session->userdata('uid'));
        $usertype = $details[0]->USER_TYPE_NAME;
        
        $params['limit'] = RECORDS_PER_PAGE; 
        $params['offset'] = ($this->input->get('per_page')) ? intval($this->input->get('per_page')) : 0;
        
        $config = $this->config->item('pagination');
        $config['base_url'] = site_url('stratup/support/index?');
        $config['total_rows'] = count($this->Support_model->get_all_support_main_tbl_count($userId,$usertype));
        $this->pagination->initialize($config);

        $data['support_main_tbl'] = $this->Support_model->get_all_support_main_tbl($params,$userId,$usertype);
        $data['_view'] = 'stratup/support/index';
         $data['_navview'] = 'nav_view';
        $this->load->view('layouts/main_view',$data);
    }

    /*
     * Adding a new support_main_tbl
     */
    function add()
    {
        // $clean = $this->security->xss_clean($this->input->post('SUPPORT_DESC'));
        // print_r($_POST) ; 
        $this -> load -> library('form_validation');
		$this -> form_validation -> set_rules('SUPPORT_TYPE_ID', 'Support Type', 'required');
		$this -> form_validation -> set_rules('SUPPORT_BUILD_ID', 'Platform', 'required');
		$this -> form_validation -> set_rules('SUPPORT_DESC', 'Description', 'required');
		
		 
        $this -> load -> model('user_model');
        $details = $this->user_model->get_user_by_id($this->session->userdata('uid'));
         $data['uname'] = $details[0]->USER_NAME ;
        $data['uemail'] = $details[0]->EMAIL_ID;
        
		if ($this -> form_validation -> run())
		{
			$params = array(
                'SUPPORT_TYPE_ID' => $this->input->post('SUPPORT_TYPE_ID'),
                'SUPPORT_STATUS_ID' => $this->input->post('SUPPORT_STATUS_ID_HIDE'),
                'SUPPORT_RAISED_BY' => $this->input->post('SUPPORT_RAISED_BY_HIDE'),
                'SUPPORT_DESC' => ($this->security->xss_clean($this->input->post('SUPPORT_DESC'))),
                'ATTACHMENT_PATH' => $this->input->post('ATTACHMENT_PATH'),
                'BUILD_TYPE' => $this->input->post('SUPPORT_BUILD_ID')
            );
            
            $support_main_tbl_id = $this->Support_model->add_support_main_tbl($params);
			//$ticketId = $this->db->insert_id();
            // $this ->sendticketmail($data['uemail']);
            
            // Mail Content for Admin Start
            $fromEmailId = $data['uemail'];
			$toEmailId = supportMailId;
			$subject = 'Support Ticket : '.$support_main_tbl_id;
			$message = 'New Support Ticket has been received. To review the ticket, click on the link below.<br />
						<br />
						To access support ticket, <a href="'.base_url().'">click here</a>';
			$this ->sendmail($fromEmailId,$toEmailId,'',$subject,$message);
			// Mail content Admin End
			
			// Mail Content for End User Start
            $fromEmailId = supportMailId;
            $toEmailId = $data['uemail'];
			$subject = 'STRATUP: Support Ticket ID: '.$support_main_tbl_id;
			$message = '<p>Dear '.$data['uname'].',</p>
						<p>Thank you for letting us know your concerns. We deeply regret the inconvenience caused. A support ticket has been raised and my team member is currently looking into the issue.</p>
						<p>We will soon get back to you with a possible resolution.</p>
						<p>You can track the status of your ticket '.$support_main_tbl_id.' <strong><a href="'.base_url().'">click here</a><br /></strong></p>
						<p><strong>Appreciate your patience,</strong></p>
						<p>Leela Vinodh</p>
						<p>Head Projects</p>';
			$this ->sendmail($fromEmailId,$toEmailId,'',$subject,$message);
			// Mail content for End user End
			
            redirect('support');
		}
        else
        {
            $this->load->model('stratup/Support_model');
            $data['all_support_type_mstr'] = $this->Support_model->get_all_support_type_mstr();

            $this->load->model('stratup/Support_model');
            $data['all_support_status_mstr'] = $this->Support_model->get_all_support_status_mstr();

            $this->load->model('stratup/User_mstr_model');
            $data['all_user_mstr'] = $this->User_mstr_model->get_all_user_mstr();
            
            $data['raisedby'][0] = array('uid'=>$this->session->userdata('uid'),
                                        'uname'=>$this->session->userdata('uname'));
            
            $data['_view'] = 'stratup/support/add';
            $data['_navview'] = 'nav_view';
            $this->load->view('layouts/main_view',$data);
        }
    }  
    

    /*
     * Editing a support_main_tbl
     */
    function edit($SUPPORT_MAIN_ID)
    {   
        // check if the support_main_tbl exists before trying to edit it
        $data['support_main_tbl'] = $this->Support_model->get_support_main_tbl($SUPPORT_MAIN_ID);
        
        if(isset($data['support_main_tbl']['SUPPORT_MAIN_ID']))
        {
            if(isset($_POST) && count($_POST) > 0)     
            {   
                $params = array(
                    'SUPPORT_TYPE_ID' => $this->input->post('SUPPORT_TYPE_ID'),
                    'SUPPORT_STATUS_ID' => $this->input->post('SUPPORT_STATUS_ID'),
                    'SUPPORT_RAISED_BY' => $this->input->post('SUPPORT_RAISED_BY'),
                    'SUPPORT_DESC' => $this->input->post('SUPPORT_DESC')
                );

                $this->Support_model->update_support_main_tbl($SUPPORT_MAIN_ID,$params);            
                redirect('stratup/support/index');
            }
            else
            {
                $data['all_support_type_mstr'] = $this->Support_model->get_all_support_type_mstr();

                $data['all_support_status_mstr'] = $this->Support_model->get_all_support_status_mstr();

                $this->load->model('stratup/User_mstr_model');
                $data['all_user_mstr'] = $this->User_mstr_model->get_all_user_mstr();

                $data['_view'] = 'stratup/support/edit';
                $this->load->view('layouts/main_view',$data);
            }
        }
        else
            show_error('The support_main_tbl you are trying to edit does not exist.');
    }
    function remove($SUPPORT_MAIN_ID)
    {
        $support_main_tbl = $this->Support_model->get_support_main_tbl($SUPPORT_MAIN_ID);

        // check if the support_main_tbl exists before trying to delete it
        if(isset($support_main_tbl['SUPPORT_MAIN_ID']))
        {
            $this->Support_model->delete_support_main_tbl($SUPPORT_MAIN_ID);
            redirect('stratup/support/index');
        }
        else
            show_error('The support_main_tbl you are trying to delete does not exist.');
    }
    function view($SUPPORT_MAIN_ID)
    {
        $this -> load -> model('user_model');
        $details = $this->user_model->get_user_by_id($this->session->userdata('uid'));
         $data['uname'] = $details[0]->USER_NAME ;
        $data['uemail'] = $details[0]->EMAIL_ID;
        // print_r($_POST);
        // check if the support_main_tbl exists before trying to edit it
        $data['all_support_status_mstr'] = $this->Support_model->get_all_support_status_mstr();
        $data['support_main_tbl'] = $this->Support_model->get_support_main_tbl($SUPPORT_MAIN_ID);
        $data['responseDtls'] = $this->Support_model->get_support_response_tbl($SUPPORT_MAIN_ID);
        $data['responseCount'] = count($data['responseDtls']);
        if(isset($data['support_main_tbl']['SUPPORT_MAIN_ID']))
        {
            if(isset($_POST) && count($_POST) > 0)     
            {   
                $params = array(
                    'SUPPORT_MAIN_ID'=> $SUPPORT_MAIN_ID,
                    'RESPONSE_DESC' => $this->input->post('RESPONSE_DESC'),
                    'CREATED_BY' => $this->session->userdata('uid'),
                    'ATTACHMENT_PATH' => $this->input->post('ATTACHMENT_PATH'),
                );
         
                $mainTblParams=array('SUPPORT_STATUS_ID'=>$this->input->post('SUPPORT_STATUS_ID'));

                // $this->Support_model->update_support_main_tbl($SUPPORT_MAIN_ID,$params); 
                if(!empty($params['RESPONSE_DESC']))
                {
                    $this->Support_model->add_support_response_tbl($params);
                    $data['responseDtls'] = $this->Support_model->get_support_response_tbl($SUPPORT_MAIN_ID);
                    $data['responseCount'] = count($data['responseDtls']);
                }
                if(!empty($mainTblParams))
                {
                    $this->Support_model->update_support_main_tbl($SUPPORT_MAIN_ID,$mainTblParams);
                    $data['support_main_tbl'] = $this->Support_model->get_support_main_tbl($SUPPORT_MAIN_ID);
                }
                // redirect('support/index');
                // $this ->replyticketmail($data['uemail']);
				// Mail Content for End User Start
				$requestRaisedUserDtls = $this->user_model->get_user_by_id($data['support_main_tbl']['SUPPORT_RAISED_BY']);
            $fromEmailId = supportMailId;
            $toEmailId = $requestRaisedUserDtls[0]->EMAIL_ID;
			$subject = 'STRATUP: Support Ticket ID: '.$SUPPORT_MAIN_ID;
			$message = '<p>Dear '.$requestRaisedUserDtls[0]->USER_NAME.',</p>
						<p>'.$this->input->post('RESPONSE_DESC').'</p>
						<p>You can track the status of your ticket '.$SUPPORT_MAIN_ID.' <strong><a href="'.base_url().'">click here</a><br /></strong></p>
						<p><strong>Appreciate your patience,</strong></p>
						<p>Leela Vinodh</p>
						<p>Head Projects</p>';
			$this ->sendmail($fromEmailId,$toEmailId,'',$subject,$message);
			// Mail content for End user End
				
				
                $data['_view'] = 'stratup/support/view';
                $this->load->view('layouts/main_view',$data,'refresh');
                
            }
            else
            {
                $data['all_support_status_mstr'] = $this->Support_model->get_all_support_status_mstr();
                $data['_view'] = 'stratup/support/view';
                $this->load->view('layouts/main_view',$data);
            }
        }
        else
            show_error('The support_main_tbl you are trying to edit does not exist.');
    }
    function download($filename = NULL) 
    {
    // load download helder
    $this->load->helper('download');
    // read file contents
    $data = file_get_contents(base_url('download/casestudy/'.$filename));
    force_download($filename, $data);
    }
    function sendticketmail($fromemail)
    {
        $this->load->library('email'); // load email library
        $this->email->to('contactus@processbee.com');
        $this->email->from($fromemail);
        $this->email->cc(''); 
        $this->email->subject('Support Ticket');
        $this->email->message('test mail');
        // $this->email->attach('/path/to/file1.png'); // attach file
        // $this->email->attach('/path/to/file2.pdf');
        if ($this->email->send())
        {
            //$this->session->set_flashdata('msg', '<div class="alert alert-success text-center"> We have sent your Login Credential to your e-MailID <br /> Please <a href="'.base_url().'"/login/index.php">Click Here</a> to Login</div>');
            //echo "Mail Sent!";
        }
        else
        {
            // $this->session->set_flashdata('msg', '<div class="alert alert-success text-center">We cant find your email address</div>');
           // show_error($this->email->print_debugger());
        }
            
    }
    function replyticketmail($toemail)
    {
        $this->load->library('email'); // load email library
        $this->email->from('contactus@processbee.com');
        $this->email->to($toemail);
        $this->email->cc(''); 
        $this->email->subject('Support Ticket');
        $this->email->message('test mail');
        // $this->email->attach('/path/to/file1.png'); // attach file
        // $this->email->attach('/path/to/file2.pdf');
        if ($this->email->send())
        {
            //$this->session->set_flashdata('msg', '<div class="alert alert-success text-center"> We have sent your Login Credential to your e-MailID <br /> Please <a href="'.base_url().'"/login/index.php">Click Here</a> to Login</div>');
            //echo "Mail Sent!";
        }
        else
        {
            // $this->session->set_flashdata('msg', '<div class="alert alert-success text-center">We cant find your email address</div>');
           // show_error($this->email->print_debugger());
        }
            
    }
}
?>