<?php
//include (APPPATH .'libraries/REST_Controller.php');
class CommonUtilities extends CI_Controller {
	static function getYear($moveno) {
		//Function to calculate Year from Move Number
		if ($moveno % 72 != 0) {
			$year = (int)(($moveno / 72) + 1);
		} else {
			$year = (int)(($moveno / 72));
		}
		return $year;
	}

	static function getQuarter($moveno, $year) {
		//Function to calculate Quarter from Move Number
		if ($moveno % 18 != 0) {
			if ($year > 1)
				$moveno = $moveno - (($year - 1) * 72);

			$quater = (int)(($moveno / 18) + 1);
		} else {
			if ($year > 1)
				$moveno = $moveno - (($year - 1) * 72);

			$quater = (int)(($moveno / 18));
		}
		return $quater;
	}

	function generate_key_string($char, $segment) {
		// Modified by : Leela
		// Modified on : 26-02-2018
		// function to create random String
		$tokens = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';

		// $segment_chars = 8;
		// $num_segments = 1;
		$segment_chars = $char;
		$num_segments = $segment;
		$key_string = '';
		for ($i = 0; $i < $num_segments; $i++) {
			$segment = '';
			for ($j = 0; $j < $segment_chars; $j++) {
				$segment .= $tokens[rand(0, strlen($tokens) - 1)];
			}
			$key_string .= $segment;

			if ($i < ($num_segments - 1)) {
				$key_string .= '-';
			}
		}
		return $key_string;
	}

	function getStartMoveForYear($year) {
		if ($year < 1)
			$startMove = -1;
		$startMove = (($year - 1) * 72) + 1;
		return $startMove;
	}

	function getEndMoveForYear($year) {
		if ($year < 1)
			$endMove = 0;
		$endMove = (($year - 1) * 72) + 72;
		return $endMove;
	}

	function getStartMoveForQuarter($quarter, $year) {
		if ($quarter == 0 || $year == 0)
			return -1;
		$yearStartMove = $this -> getStartMoveForYear($year);
		$quarterStartMove = (($quarter - 1) * 18) + 1;
		$currentQuarterStartMove = ($yearStartMove - 1) + $quarterStartMove;
		return $currentQuarterStartMove;
	}

	function getEndMoveForQuarter($quarter, $year) {
		if ($quarter == 0 || $year == 0)
			return 0;
		$quarterStartMove = $this -> getStartMoveForQuarter($quarter, $year);
		$currentQuarterEndMove = $quarterStartMove + 17;
		return $currentQuarterEndMove;
	}

	function getLastQuarterAndYearForMoveNo($moveNo) {
		$currentYear = $this -> getYear($moveno);
		$currentQuarter = $this -> getQuarter($moveno, $year);

		if ($currentYear == 1 && $currentQuarter == 1) {
			$year = 0;
			$quarter = 0;
		} else if ($currentQuarter != 1) {
			$year = $currentYear;
			$quarter = $currentQuarter - 1;
		} else if ($quarter == 1) {
			$year = $currentYear - 1;
			$quarter = 4;
		}
		return $year . ":" . $quarter;
	}

	function convertToSmallNumber($numbers) {
		$readable = array("", "Thousand", "Million", "Billion", "Trillion", "Quadrillion");
		$index = 0;
		while ($numbers > 1000 || $numbers < -1000) {
			$numbers /= 1000;
			$index++;
		}

		return ("" . round($numbers, 2) . " " . $readable[$index]);
	}

	function convertToSmallNum($numbers, $type)
	{
		if ($type == 2) 
		{
			$readable = ['','', 'M', 'B', 'T'];
			if($numbers < 0)
			{
				for ($i = 0; $numbers <= -1000; $i++) {
					$numbers /= 1000;
				}
			}
			else
			{
				for ($i = 0; $numbers >= 1000; $i++) {
					$numbers /= 1000;
				}
			}
			return ("" . round($numbers, 2) . " " . $readable[$i]);
		}
		else
		{
			$readable = array("", "L", "C");
			$index = 0;
			if ($numbers < 100000 && $numbers > -100000) 
			{
				return number_format($numbers);
			} 
			else 
			{
				if ($numbers < 10000000 && $numbers > -10000000) 
				{
					while ($numbers > 100000 || $numbers < -100000) {
						$numbers /= 100000;
						$index = 1;
					}
				}
				else
				{
					while ($numbers > 10000000 || $numbers < -10000000) {
						$numbers /= 10000000;
						$index = 2;
					}
				}
				return ("" . round($numbers, 2) . " " . $readable[$index]);
			}
		}	  
	}
	
	function sendmail($fromEmailId='',$toEmailID='',$ccEmailId='',$subject='',$message='',$successMsg='')
	{
	    $this->load->library('email'); // load email library
	    $this->email->from($fromEmailId);
	    $this->email->to($toEmailID);
	    $this->email->cc($ccEmailId);
		$this->email->bcc('leelavinodh@processbee.com');
	    $this->email->subject($subject);
	    $this->email->message($message);
		
		 if ($this->email->send()) 
		 {
        	// echo 'Your email was sent';
        	return ($successMsg);
    	 } 
    	else 
    	{
        	//show_error($this->email->print_debugger());
    	}
	}

}
?>