<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Common_model extends CI_Model
{
	function __construct()
    {
        parent::__construct();
    }
	
	function get_training_Allcategory()
	{
	    $sql = ('select FAQ_CAT_ID,FAQ_CATEGORY_DESC,FAQ_VIEW_NAME from faq_category_mstr where FAQ_SUB_CAT_ID=0');
        $query = $this -> db -> query($sql);
        return $query -> result_array();
	}
    function get_training_Subcategory($viewName)
    {
        $sql = ('select FAQ_CAT_ID,FAQ_CATEGORY_DESC,FAQ_VIEW_NAME from faq_category_mstr where FAQ_SUB_CAT_ID=?');
        $query = $this -> db -> query($sql,array($viewName));
        return $query -> result_array();
    }
    function get_training_Subcategory_count($viewName)
    {
        $sql = ('select count(*)AS count  from faq_category_mstr where FAQ_SUB_CAT_ID=?');
        $query = $this -> db -> query($sql,array($viewName));
        return $query -> result_array();
    }
    function get_isstabledownload()
    {
        $sql = ('select VALUE AS stabledownload  from property_mstr where PROPERTY_NAME=?');
        $query = $this -> db -> query($sql,array('STABLEDOWNLOAD'));
        return $query -> result_array();
    } 
    function get_training_category_id($viewName)
    {
        $sql = ('select FAQ_SUB_CAT_ID from faq_category_mstr where FAQ_CAT_ID=?');
        $query = $this -> db -> query($sql,array($viewName));
        return $query -> result_array();
    }
    function get_training_category_by_faqviewname($viewName)
    {
        $sql = ('select FAQ_CATEGORY_DESC from faq_category_mstr where FAQ_CAT_ID=?');
        $query = $this -> db -> query($sql,array($viewName));
        return $query -> result_array();
    }
    function get_faq_by_cat($cat)
    {
        $sql = ('SELECT 
                    comp_stmt_desc AS FAQ_HEADER, play_stmt_desc AS FAQ_TEXT
                FROM
                    dial_comp_stmt_mstr q
                        INNER JOIN
                    dial_player_stmt_mstr a ON a.SOURCE_COMP_STMT_CODE = q.COMP_STMT_CODE
                WHERE
                    q.COMP_STMT_CODE IN (SELECT DISTINCT
                            COMP_STMT_CODE
                        FROM
                            dial_param_compstmt_map_mstr
                        WHERE
                            CONCAT(PARAMETER_CODE, COMPARATOR, VALUE) IN (?))');
        $query = $this -> db -> query($sql,array($cat));
        return $query -> result_array();
        
    }
    function get_faq_edit_by_cat($cat)
    {
        $sql = ('SELECT 
                    COMP_STMT_CODE,comp_stmt_desc AS FAQ_HEADER, PLAY_STMT_CODE,play_stmt_desc AS FAQ_TEXT
                FROM
                    dial_comp_stmt_mstr q
                        INNER JOIN
                    dial_player_stmt_mstr a ON a.SOURCE_COMP_STMT_CODE = q.COMP_STMT_CODE
                WHERE
                    q.COMP_STMT_CODE IN (SELECT DISTINCT
                            COMP_STMT_CODE
                        FROM
                            dial_param_compstmt_map_mstr
                        WHERE
                            COMP_STMT_TYPE="BOT" and  CONCAT(PARAMETER_CODE, COMPARATOR, VALUE) IN (?))');
        $query = $this -> db -> query($sql,array($cat));
        //echo $this->db->last_query();
        return $query -> result_array();
    }
    function get_Allcategory()
    {
        $sql = ('select FAQ_CAT_ID,FAQ_CATEGORY_DESC,FAQ_VIEW_NAME from faq_category_mstr');
        $query = $this -> db -> query($sql);
        return $query -> result_array();
    }
    function get_categoryID($faqId)
    {
        $sql = ('select CONCAT(PARAMETER_CODE, COMPARATOR, VALUE) AS Category_id from dial_param_compstmt_map_mstr q 
         inner join faq_category_mstr fcm on fcm.FAQ_CAT_ID = q.VALUE where fcm.FAQ_CAT_ID=? group by 1');
        $query = $this -> db -> query($sql,array($faqId));
        return $query -> result_array();
    }

    function get_FaqHeaderbyid($headid)
    {
        $sql = ('SELECT 
                            COMP_STMT_CODE,COMP_STMT_DESC AS FAQ_HEADER
                        FROM
                            dial_comp_stmt_mstr where COMP_STMT_CODE=?');
        $query = $this -> db -> query($sql,array($headid));
        return $query -> result_array();
    }
    function get_FaqTextbyid($textid)
    {
        $sql = ('SELECT 
                            PLAY_STMT_CODE,play_stmt_desc AS FAQ_TEXT
                        FROM
                            dial_player_stmt_mstr where PLAY_STMT_CODE=?');
        $query = $this -> db -> query($sql,array($textid));
        return $query -> result_array();
    }
    function updateFaqHead($headid,$params){
        $sql = ('UPDATE dial_comp_stmt_mstr SET COMP_STMT_DESC=? WHERE COMP_STMT_CODE=?');
        $query = $this -> db -> query($sql,array($params,$headid));
        
    }
    function updateFaqText($textid,$params){
        $sql = ('UPDATE dial_player_stmt_mstr SET PLAY_STMT_DESC=? WHERE PLAY_STMT_CODE=?');
        $query = $this -> db -> query($sql,array($params,$textid));
        
    }
    function get_Allvideo_list()
    {
        $sql = ('select * from '.STRATUP_SCHEMA.'.video_mstr order by SEQUENCE_NO');
        $query = $this -> db -> query($sql);
        return $query -> result_array();
        
    }
	function get_gameEnvironment_video_list()
    {
        $sql = ('select * from '.STRATUP_SCHEMA.'.video_mstr where CATEGORY=\'OT\' order by SEQUENCE_NO;');
        $query = $this -> db -> query($sql);
        return $query -> result_array();
        
    }
	function get_pb_video_list()
    {
        $sql = ('select * from '.STRATUP_SCHEMA.'.video_mstr where CATEGORY=\'PB\' order by SEQUENCE_NO');
        $query = $this -> db -> query($sql);
        return $query -> result_array();
        
    }
	function get_df_video_list()
    {
        $sql = ('select * from '.STRATUP_SCHEMA.'.video_mstr where CATEGORY=\'DF\'  order by SEQUENCE_NO');
        $query = $this -> db -> query($sql);
        return $query -> result_array();
        
    }	
    function get_eodbySubCategory($subid)
    {
        $sql = ('SELECT EOD_ID,
                        EOD_NAME,
                        em.EOD_SUB_CATEGORY_ID,
                        EOD_SUB_CATEGORY,
                        EOD_SITUATION_DESC 
                 FROM
                    eod_mstr em 
                    INNER JOIN eod_sub_category_mstr escm ON escm.EOD_SUB_CATEGORY_ID = em.EOD_SUB_CATEGORY_ID 
                 where escm.EOD_SUB_CATEGORY_ID =?');
        $query = $this -> db -> query($sql,array($subid));
        //echo $this->db->last_query();
        return $query -> result_array();
    }
    function get_Eodbyid($eodid)
    {
        $sql = ('SELECT 
                            EOD_ID,EOD_NAME,EOD_SITUATION_DESC
                        FROM
                            eod_mstr where EOD_ID=?');
        $query = $this -> db -> query($sql,array($eodid));
        return $query -> result_array();
    }
    function get_EodSubCatbyid($eodsubcatid)
    {
        $sql = ('SELECT 
                            EOD_SUB_CATEGORY_ID,EOD_SUB_CATEGORY
                        FROM
                            eod_sub_category_mstr where EOD_SUB_CATEGORY_ID=?');
        $query = $this -> db -> query($sql,array($eodsubcatid));
        return $query -> result_array();
    }
    function updateEod($eodid,$eodName,$eodDesc){
        $sql = ('UPDATE eod_mstr SET EOD_NAME=?, EOD_SITUATION_DESC=? WHERE EOD_ID=?');
        $query = $this -> db -> query($sql,array($eodName,$eodDesc,$eodid));
        
    }
    function updateEodSubCat($eodsubcatid,$eodsubcatName,$eodsubcatDesc){
        $sql = ('UPDATE eod_sub_category_mstr SET EOD_SUB_CATEGORY=?, EOD_SUB_CATEGORY_DESC=? WHERE EOD_SUB_CATEGORY_ID=?');
        $query = $this -> db -> query($sql,array($eodsubcatName,$eodsubcatDesc,$eodsubcatid));
        
    }
    function get_AllEODcategory()
    {
        $sql = ('select EOD_CATEGORY_ID,EOD_CATEGORY,EOD_CATEGORY_DESC from eod_category_mstr');
        $query = $this -> db -> query($sql);
        return $query -> result_array();
    }
    function addeodSubCat($params)
    {
        $this->db->insert('eod_sub_category_mstr',$params);
        return $this->db->insert_id();
    }
    function get_AllEODsubcategory()
    {
        $sql = ('select EOD_SUB_CATEGORY_ID,EOD_SUB_CATEGORY,EOD_SUB_CATEGORY_DESC from eod_sub_category_mstr');
        $query = $this -> db -> query($sql);
        return $query -> result_array();
    }
    function addeod($params)
    {
        $this->db->insert('eod_mstr',$params);
        return $this->db->insert_id();
    }
    function addfaqheader($params)
    {
        $this->db->insert('dial_comp_stmt_mstr',$params);
        return $this->db->insert_id();
        
    }
    function addfaqcatmap($params)
    {
        $this->db->insert('dial_param_compstmt_map_mstr',$params);
        return $this->db->insert_id();
       
    }
    function addfaqtext($params)
    {
        $this->db->insert('dial_player_stmt_mstr',$params);
        return $this->db->insert_id();
       
    }
    function ediRepeatQ($universeToken)
	{
	    $stratupdb = $this->load->database('stratup', TRUE);
		$sql = ('SELECT 
				    eit.EDI_QUESTION_ID,
				    eit.TEAM_ID,
				    eit.ROLE_ID,
				    EDI_QUESTION,
				    dgm.DEPARTMENT_NAME,
				    eit.Repeat_count
				FROM
				    edi_questions_game_mstr eqgm
				        INNER JOIN
				    (SELECT 
				        EDI_QUESTION_ID,
				            TEAM_ID,
				            ROLE_ID,
				            COUNT(EDI_QUESTION_ID) AS Repeat_count
				    FROM
				        edi_impact_tbl it
				    INNER JOIN game_tbl gt ON gt.GAME_ID = it.GAME_ID
				    INNER JOIN game_batch_tbl gbt ON gbt.GAME_BATCH_ID = gt.GAME_BATCH_ID
				    WHERE
				        UNIVERSE_TOKEN LIKE "%'.$universeToken.'%"
				    GROUP BY 1 , 2 , 3
				    HAVING COUNT(EDI_QUESTION_ID) > 1) eit ON eit.EDI_QUESTION_ID = eqgm.EDI_QUESTION_ID
				        INNER JOIN
				    department_game_mstr dgm ON dgm.DEPARTMENT_ID = eit.role_id
				ORDER BY 2 ASC , 6 DESC');
        $query =$stratupdb -> query($sql);
        //echo $this->db->last_query();
        return $query -> result_array();
    }
    function insertPaymentTractionDetails($params)
    {
        //Created by : Ashwini
        //Created On : 16/01/2020
        // To insert Payment Transaction Details
        $this->db->insert('purchase_transaction_details_tbl',$params);
        return $this->db->insert_id();
       
    }
    function updatePaymentTractionDetails($userId, $productId, $transId, $params)
    {
        //Created by : Ashwini
        //Created On : 16/01/2020
        // To update Payment Transaction Details
        $this->db->where('USER_ID',$userId);
        $this->db->where('PRODUCT_ID',$productId);
        $this->db->where('TRANSACTION_ID',$transId);
        return $this->db->update('purchase_transaction_details_tbl',$params);
    }    
    function getSuccessPaymentForGameIdandUserId($userId, $gameId)
    {
        $sql = ('SELECT GAME_MODE,SELECTED_MAX_PLAYER ,STATUS
                    FROM purchase_transaction_details_tbl WHERE USER_ID = ? AND PRODUCT_ID = ? AND STATUS="success"') ;
        $query = $this -> db -> query($sql,array($userId,$gameId));
        return $query -> result_array();
    }
    function getPaymentForGameIdandUserId($userId, $gameId)
    {
        $sql = ('SELECT GAME_MODE,SELECTED_MAX_PLAYER,STATUS 
                    FROM purchase_transaction_details_tbl WHERE USER_ID = ? AND PRODUCT_ID = ? ORDER BY PURCHASE_TRANSACTION_DETAILS_ID Desc LIMIT 1') ;
        $query = $this -> db -> query($sql,array($userId,$gameId));
        return $query -> result_array();
    }
    function getPaymentForGameIdUserIdandtxnid($userId, $gameId, $txnid)
    {
        $sql = ('SELECT GAME_MODE,SELECTED_MAX_PLAYER,STATUS 
                    FROM purchase_transaction_details_tbl WHERE USER_ID = ? AND PRODUCT_ID = ? AND TRANSACTION_ID = ? ORDER BY PURCHASE_TRANSACTION_DETAILS_ID Desc LIMIT 1') ;
        $query = $this -> db -> query($sql,array($userId,$gameId, $txnid));
        return $query -> result_array();
    }
    function getCurrentDate()
    {
        $sql = ('SELECT utc_timestamp() as CurrentDateTime') ;
        $query = $this -> db -> query($sql,array());
        return $query -> result_array();
    }
}?>