<?php

class Finance_model extends CI_Model 
{
    function __construct()
    {
        parent::__construct();
    }
    
    function userRegistration($userName, $emailId, $status, $password)
    {
        $sql = ('INSERT INTO '.USER_SCHEMA.'.user_mstr (USER_NAME, EMAIL_ID, STATUS, PASSWORD) VALUES (?,?,?,?)');
        $query = $this->db->query($sql,array($userName, $emailId, $status, $password));
    }
    function checkDuplicateUserRegistration($userName)
    {
        $sql = ('SELECT * FROM '.USER_SCHEMA.'.user_mstr where USER_NAME=?');
        $query = $this->db->query($sql,array($userName));
        return $query -> result();
    }
    function getMaxGameId()
    {
        $sql = ('select max(GAME_ID) from game_mstr');
        $query = $this->db->query($sql);
        return $query -> result();
    }
    function createGame()
    {
        $sql = ('INSERT INTO game_mstr (GAME_DESC) values(?)');
        $query = $this->db->query($sql,array('New Game'));
        return $this->db->insert_id();
    }
    function joinGame($gameId,$userId)
    {
        $sql = ('INSERT INTO game_users (GAME_ID, USER_ID, STATUS) values(?, ?, \'A\')');
        $query = $this->db->query($sql,array($gameId, $userId));
        return $this->db->insert_id();
        
    }
    function getCategoryListFromCategoryMaster()
    {
        $sql = ('select * from wlb_category_mstr where CATEGORY_TYPE not in (\'Transaction\',\'Board\')');
        $query = $this->db->query($sql);
        return $query -> result();
    }
    function getCategoryTypeDescList()
    {
        $sql = ('select * from wlb_categorytype_columns_mstr where ICON=\'Y\' 
        group by CATEGORY_TYPE_DESC  order by CATCOL_CODE Asc');
        $query = $this->db->query($sql);
        return $query -> result();
    }
    function getCategoryTypeFromCategoryTypeMstr($catTypeDesc)
    {
        $sql = ('select * from wlb_categorytype_columns_mstr where CATEGORY_TYPE_DESC=?');
        $query = $this->db->query($sql,array($catTypeDesc));
        return $query -> result();
    }
    function getCategoryListFromCategoryType($categoryType)
    {
        $sql = ('select * from wlb_category_mstr where CATEGORY_TYPE=? ');
        $query = $this->db->query($sql,array($categoryType));
        return $query -> result();
    }
    function getCategoryCodeFromCategoryName($categoryName)
    {
        $sql = ('select * from wlb_category_mstr where CATEGORY_DESC=? ');
        $query = $this->db->query($sql,array($categoryName));
        return $query -> result();
    }
    function getProductListBasedonCategory($categoryCode)
    {
        $sql = ('select * from wlb_product_mstr pm 
                    inner join wlb_category_mstr cm on cm.CATEGORY_CODE = pm.CATEGORY_CODE 
                    INNER JOIN wlb_categorytype_columns_mstr ctm on cm.CATEGORY_TYPE = ctm.CATEGORY_TYPE 
                    where pm.CATEGORY_CODE=?');
        $query = $this->db->query($sql,array($categoryCode));
        return $query -> result();
    }
    function insertGameUsers($userId, $gameUserId, $status)
    {
        $sql = ('INSERT INTO game_users (USER_ID, UGS_STATUS_ID, STATUS) VALUES (?, ?, ?)');
        $query = $this->db->query($sql,array($userId, $gameUserId, $status));
    }
    function getGameUserId($userId,$gameId)
    {
        $sql = ('SELECT 
                    GAME_ID, USER_ID, UGS_STATUS_ID, STATUS
                FROM
                    '.WLB_SCHEMA.'.z_game_users
                WHERE
                    USER_ID = ? AND GAME_ID = ?');
        $query = $this->db->query($sql,array($userId,$gameId));
        return $query -> result();
    }
    function insertGameTrans($gameUserId,$productCode, $transType, $amount,$boughtOnRound,$sold,$soldRound)
    {
        $sql = ('INSERT INTO wlb_game_transactions(
                              UGS_STATUS_ID,
                              PRODUCT_CODE,
                              DEBIT_CREDIT,
                              AMOUNT,
                              BOUGHT_ON_ROUND,
                              SOLD,
                              SOLD_ON_ROUND)
                    VALUES (?,?,?,?,?,?,?)');
        $query = $this->db->query($sql,array($gameUserId,$productCode, $transType, $amount,$boughtOnRound,$sold,$soldRound));
    }
    function getHoldingsForusernCategory($gameUserId,$categoryName)
    {
        $sql = ('SELECT 
                    TRANS_ID,
                    ccm.CATEGORY_TYPE_DESC,
                    cm.CATEGORY_CODE,
                    cm.CATEGORY_DESC,
                    pm.PRODUCT_CODE,
                    pm.PRODUCT_TITLE,
                    AMOUNT,
                    VALUE,
                    INTEREST,
                    SOL,
                    FIN_INDEX,
                    PER_INDEX,
                    PRO_INDEX,
                    NUM_OTHERS,
                    STR_OTHERS
                FROM
                    wlb_game_transactions gt
                        INNER JOIN
                    wlb_product_mstr pm ON gt.product_code = pm.product_code
                        INNER JOIN
                    wlb_category_mstr cm ON cm.CATEGORY_CODE = pm.CATEGORY_CODE
                     INNER JOIN
                    wlb_categorytype_columns_mstr ccm ON cm.CATEGORY_TYPE = ccm.CATEGORY_TYPE
                WHERE
                    UGS_STATUS_ID = ? AND DEBIT_CREDIT = \'D\' 
                        AND SOLD = \'N\' and cm.CATEGORY_CODE not in (8,11) and ccm.CATEGORY_TYPE_DESC = ?');
        $query = $this->db->query($sql,array($gameUserId,$categoryName));
        return $query -> result();
    }
    function getTransactionHistory($gameUserId)
    {
        $sql = ('SELECT 
                    pm.PRODUCT_TITLE, DEBIT_CREDIT, SUM(AMOUNT) AMOUNT
                FROM
                    wlb_game_transactions gt
                        INNER JOIN
                    wlb_product_mstr pm ON gt.product_code = pm.product_code
                WHERE
                    UGS_STATUS_ID = ?
                GROUP BY 1 , 2;');
        $query = $this->db->query($sql,array($gameUserId));
        return $query -> result();
    }
    function getTransactionHistoryForCategory($gameUserId,$categoryName)
    {
        $sql = ('SELECT 
                    pm.PRODUCT_TITLE, DEBIT_CREDIT, SUM(AMOUNT) AMOUNT
                FROM
                    wlb_game_transactions gt
                        INNER JOIN
                    wlb_product_mstr pm ON gt.product_code = pm.product_code
                     INNER JOIN
                    wlb_category_mstr cm ON pm.CATEGORY_CODE = cm.CATEGORY_CODE
                    INNER JOIN
                    wlb_categorytype_columns_mstr ccm ON cm.CATEGORY_TYPE = ccm.CATEGORY_TYPE
                WHERE
                    UGS_STATUS_ID = ? and ccm.CATEGORY_TYPE_DESC = ?
                GROUP BY 1 , 2 ');
        $query = $this->db->query($sql,array($gameUserId,$categoryName));
        return $query -> result();
    }
    function getPersonalStatus($gameUserId)
    {
        $sql = ('SELECT CATEGORY_TYPE,DEBIT_CREDIT,sum(FIN_INDEX) FIN_INDEX,
                        sum(PER_INDEX) PER_INDEX,sum(PRO_INDEX) PRO_INDEX,sum(SOC_INDEX) SOC_INDEX,
                        sum(VALUE) VALUE,sum(INTEREST) INTEREST,sum(SOL) SOL 
                FROM wlb_game_transactions gt 
                    inner join wlb_product_mstr pm on pm.PRODUCT_CODE = gt.PRODUCT_CODE
                    LEFT JOIN wlb_category_mstr CM ON PM.CATEGORY_CODE = CM.CATEGORY_CODE 
                where UGS_STATUS_ID = ?
                GROUP BY 1 , 2;');
        $query = $this->db->query($sql,array($gameUserId));
        return $query -> result();
    }   
    function getUserForEmailId($emailId)
    {
        $sql = ('select EMAIL_ID from '.USER_SCHEMA.'.user_mstr where EMAIL_ID=?');
        $query = $this -> db -> query($sql, array($emailId));
        return $query -> result();
    }
    function getLoginForUserid($loginid)
    {
        $sql = ('SELECT *
                    FROM '.USER_SCHEMA.'.USER_MSTR 
                        where USER_NAME = ? or EMAIL_ID=?');
        $query = $this -> db -> query($sql, array($loginid,$loginid));
        return $query -> result();
    }
    function listOfUsersInGame($gameId)
    {
        $sql = ('SELECT 
                    um.USER_ID, USER_NAME, EMAIL_ID, GAME_ID
                FROM
                    '.WLB_SCHEMA.'.z_game_users gu
                        INNER JOIN
                    '.WLB_SCHEMA.'.z_user_mstr um ON gu.user_id = um.USER_ID
                WHERE
                    gu.STATUS = "A" and GAME_ID=?');
        $query = $this -> db -> query($sql, array($gameId));
        return $query -> result();
    }
    function getProductForProductName($productName)
    {
        $sql = ('select * from wlb_product_mstr where PRODUCT_TITLE=?');
        $query = $this->db->query($sql,array($productName));
          //echo $this->db->last_query();
        return $query -> result();
      
    }
    function updateSold($transId)
    {
        $sql = ('UPDATE wlb_game_transactions SET SOLD="Y" WHERE TRANS_ID=?');
        $query = $this -> db -> query($sql, array($transId));
    }
    function getUserList($gameId)
    {
        $sql = ('select * from game_users where GAME_ID=?');
        $query = $this->db->query($sql,array($gameId));
        return $query -> result();
    }
    function getgameUserDtls($gameUserId)
    {
        $sql = ('select * from '.WLB_SCHEMA.'.game_users where UGS_STATUS_ID=?');
        $query = $this->db->query($sql,array($gameUserId));
        return $query -> result();
    }
    function isPointsInitiated($ugsStatusId) 
    {
        $sql = ('SELECT case when count(*) > 0 then "TRUE" WHEN COUNT(*) = 0 THEN "FALSE" END AS ISPOINTS FROM dial_player_points_tbl where UGS_STATUS_ID = ?');
        $query = $this -> db -> query($sql, array($ugsStatusId));
        return $query -> result();
    }
    function insertPoints($ugsStatusId,$money,$time,$day,$month,$year) 
    {
        $sql = ('insert into dial_player_points_tbl(UGS_STATUS_ID,POINTS_PARAM_CODE,VALUE) 
            SELECT ?,dppm.POINTS_PARAM_CODE,
            CASE POINTS_PARAM_DESC
            WHEN "Money" THEN 0+?
            WHEN "Time" THEN 0+?
            WHEN "Day" THEN 0+?
            WHEN "Month" THEN 0+?
            WHEN "Year" THEN 0+?
            END AS VALUE1
            from dial_points_param_mstr dppm where POINTS_PARAM_CODE not in (1,2,3,4)');
            $query = $this -> db -> query($sql, array($ugsStatusId,$money,$time,$day,$month,$year));
    }
    function updatePoints($ugsStatusId,$money,$time,$day,$month,$year) 
    {
            $sql = ('update dial_player_points_tbl dppt1 inner join 
        (SELECT dppm.POINTS_PARAM_CODE,
        CASE POINTS_PARAM_DESC
        WHEN  "Money" THEN ?
        WHEN  "Time" THEN ?
        WHEN  "Day" THEN ?
        WHEN  "Month" THEN dppt.VALUE+?
        WHEN  "Year" THEN dppt.VALUE+?
        END AS VALUE1
        FROM dial_points_param_mstr dppm 
        INNER JOIN dial_player_points_tbl dppt on dppm.POINTS_PARAM_CODE = dppt.POINTS_PARAM_CODE
        WHERE dppt.POINTS_PARAM_CODE not in (1,2,3,4)) updatevalues on dppt1.POINTS_PARAM_CODE = updatevalues.POINTS_PARAM_CODE
        set dppt1.value = updatevalues.value1
        where dppt1.UGS_STATUS_ID = ?');
            $query = $this -> db -> query($sql, array($money,$time,$day,$month,$year,$ugsStatusId));       
    }
    function getPointsForGame($ugsStatusId) 
    {
        //Returns the  points for the current level for the given user and game
        $sql = ('SELECT POINTS_PARAM_DESC,VALUE,POINTS_PARAM_TYPE,POINTS_PARAM_ICON_PATH FROM dial_player_points_tbl ppt 
        INNER JOIN dial_points_param_mstr dppm on ppt.POINTS_PARAM_CODE = dppm.POINTS_PARAM_CODE 
        WHERE dppm.APPLICABLE_GAME = "Finance" AND UGS_STATUS_ID = ?');
        $query = $this -> db -> query($sql, array($ugsStatusId));
        return $query -> result();
    }
    function getuseractivity()
    {
        $sql = ('SELECT * FROM wlb_activity_mstr');
        $query = $this -> db -> query($sql, array());
        return $query -> result();
    }
    function insertuseractivity($ugsStatusId,$catCode,$activityId)
    {
        $sql = ('insert into wlb_game_story_profile(UGS_STATUS_ID,CATEGORY_CODE,ACTIVITY_ID) 
             VALUES (?,?,?)');
        $query = $this -> db -> query($sql, array($ugsStatusId,$catCode,$activityId));
       
    }
    function getPriorityCat()
    {
        $sql = ('SELECT * FROM wlb_categorytype_columns_mstr where ICON="P";');
        $query = $this -> db -> query($sql, array());
        return $query -> result();
    }
    function insertPriorityonCat($ugsStatusId,$catCode,$priorityUnit,$priorityType,$prioritytarget)
    {
        $sql = ('insert into wlb_game_current_priority(UGS_STATUS_ID,CATEGORY_CODE,PRIOIRTY_UNIT,
        PRIOIRTY_UNIT_TYPE,TARGET)
        VALUES(?,?,?,?,?)');
        $query = $this -> db -> query($sql, array($ugsStatusId,$catCode,$priorityUnit,$priorityType,$prioritytarget));
    }
    function updatePriorityonCat($ugsStatusId,$catCode,$prioritytarget)
    {
        $sql = ('UPDATE wlb_game_current_priority SET TARGET=? WHERE CATEGORY_CODE=? and UGS_STATUS_ID=?');
        $query = $this -> db -> query($sql, array($prioritytarget,$catCode,$ugsStatusId));
    }
    
    function isPriorityonCat($ugsStatusId,$categoryType)
    {
        $sql = ('select case when count(*) > 0 then "TRUE" WHEN COUNT(*) = 0 THEN "FALSE" END AS ISPOINTS 
        from wlb_game_current_priority 
        where UGS_STATUS_ID=? and 
        CATEGORY_CODE in (select CATEGORY_CODE from  wlb_category_mstr where Category_type=?)');
        $query = $this -> db -> query($sql, array($ugsStatusId,$categoryType));
         return $query -> result();
    }
    function getPriorityDesc($categoryType,$ugsStatusId)
    {
        $sql = ('select cm.CATEGORY_CODE,cm.CATEGORY_DESC,cm.CATEGORY_ICON,
                        ifnull(sum(gcp.TARGET),0)As TARGET
                 from wlb_category_mstr cm 
                    left Join wlb_game_current_priority gcp  on cm.CATEGORY_CODE=gcp.CATEGORY_CODE 
                 where cm.Category_type=? and gcp.UGS_STATUS_ID =? 
                 group by cm.CATEGORY_CODE ');
        $query = $this -> db -> query($sql, array($categoryType,$ugsStatusId));
         return $query -> result();
    }
}

?>