<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class test_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
    }

    function mktMainTbl($teamId)
    {
        $sql = ('SELECT mmt.MKT_MAIN_ID,
           PRODUCTION_ALLOCATION_ID          AS OrderId,
           MOVE_NO                           AS MoveNO,
           GETYEAR(MOVE_NO)                  AS Year,
           GETQTR(MOVE_NO, GETYEAR(MOVE_NO)) AS Qtr,
           msm.SEGMENT_DISPLAY_NAME          AS Segment,
           pm.PRODUCT_desc                   AS ProductName,
           SUM(NO_OF_PRODUCTS)               AS AllotedUnits,
           ROUND(AVG(PRODUCT_PRICE))         AS Price
    FROM mkt_main_tbl    mmt
         INNER JOIN mkt_territory_product_allocation_tbl mpa
            ON mpa.MKT_MAIN_ID = mmt.MKT_MAIN_ID
         INNER JOIN opr_product_game_mstr pm ON pm.PRODUCT_ID = mpa.PRODUCT_ID
         INNER JOIN mkt_segment_game_mstr msm
            ON msm.SEGMENT_ID = mmt.SEGMENT_ID
    WHERE mmt.team_id = ? AND MKT_ACTIONS_ID = 1 AND move_no > 0
    GROUP BY 1, 2, 3');
        $query = $this -> db -> query($sql,array($teamId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function mktMainTblForMainId($mktMainId)
    {
        $sql = ('SELECT mmt.MKT_MAIN_ID      AS OrderId,
           MOVE_NO                           AS MoveNO,
           GETYEAR(MOVE_NO)                  AS Year,
           GETQTR(MOVE_NO, GETYEAR(MOVE_NO)) AS Qtr,
           msm.SEGMENT_DISPLAY_NAME          AS Segment,
           pm.PRODUCT_desc                   AS ProductName,
           SUM(NO_OF_PRODUCTS)               AS AllotedUnits,
           ROUND(AVG(PRODUCT_PRICE))         AS Price
    FROM mkt_main_tbl    mmt
         INNER JOIN mkt_territory_product_allocation_tbl mpa
            ON mpa.MKT_MAIN_ID = mmt.MKT_MAIN_ID
         INNER JOIN opr_product_game_mstr pm ON pm.PRODUCT_ID = mpa.PRODUCT_ID
         INNER JOIN mkt_segment_game_mstr msm
            ON msm.SEGMENT_ID = mmt.SEGMENT_ID
    WHERE mmt.mkt_main_id = ? AND MKT_ACTIONS_ID = 1 AND move_no > 0
    GROUP BY 1, 2, 3');
        $query = $this -> db -> query($sql,array($mktMainId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function mktProductAllocation($mktMainId)
    {
        $sql = ('SELECT MKT_MAIN_ID,
                   PRODUCTION_ALLOCATION_ID,
                   pm.PRODUCT_DESC,
                   tcm.TERRITORY_NAME,
                   NO_OF_PRODUCTS,
                   PRODUCT_PRICE,
                   DISCOUNT,
                   TRANSPORTATION_COST
            FROM mkt_territory_product_allocation_tbl    mpat
                 INNER JOIN opr_product_game_mstr pm
                    ON pm.PRODUCT_ID = mpat.PRODUCT_ID
                 INNER JOIN mkt_territory_characteristics_game_mstr tcm
                    ON tcm.TERRITORY_CHARACTERISTIC_ID = mpat.TERRITORY_ID
            WHERE MKT_MAIN_ID = ?');
        $query = $this -> db -> query($sql,array($mktMainId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function mktAdvt($mktMainId)
    {
        $sql = ('SELECT advt.TERRITORY_ADVERTISEMENT_ID,
                   advt.MKT_MAIN_ID,
                   tcm.TERRITORY_NAME,
                   advt.PRODUCT_ID,
                   mode.ADVERTISEMENT_MODE_NAME,
                   unit.ADVERTISEMENT_UNIT,
                   advt.ADVERTISEMENT_UNIT_FREQUENCY,
                   advt.ADVERTISEMENT_COST,
                   advt.AWARNESS_CREATED
            FROM mkt_territory_advertisement_tbl    advt
                 INNER JOIN mkt_advertisement_mode_game_mstr mode
                    ON mode.ADVERTISEMENT_MODE_ID = advt.ADVERTISEMENT_MODE_ID
                 INNER JOIN mkt_advertisement_unit_game_mstr unit
                    ON unit.ADVERTISEMENT_UNIT_ID = advt.ADVERTISEMENT_UNIT_ID
                 INNER JOIN mkt_territory_characteristics_game_mstr tcm
        ON tcm.TERRITORY_CHARACTERISTIC_ID = advt.TERRITORY_CHARACTERISTIC_ID
            WHERE MKT_MAIN_ID =?');
        $query = $this -> db -> query($sql,array($mktMainId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function mktDist($mktMainId)
    {
        $sql = ('SELECT cat.DISTRIBUTION_CATEGORY_DESC,
                   tcm.TERRITORY_NAME,
                   necom.MARIGN,
                   necom.SALES_INCENTIVE,
                   necom.MARGIN_COST,
                   necom.SALES_INCENTIVE_COST,
                   necom.TRAINING,
                   necom.MARKETING_SUPPORT
            FROM mkt_territory_distribution_non_ecommerce_tbl    AS necom
                 INNER JOIN mkt_distribution_main_tbl AS dmt
                    ON dmt.DISTRIBUTION_MAIN_ID = necom.DISTRIBUTION_MAIN_ID
                 INNER JOIN mkt_territory_characteristics_game_mstr tcm
                    ON tcm.TERRITORY_CHARACTERISTIC_ID =
                          necom.TERRITORY_CHARACTERISTIC_ID
                 INNER JOIN mkt_distribution_category_game_mstr cat
                    ON cat.DISTRIBUTION_CATEGORY_ID = dmt.DISTRIBUTION_CATEGORY_ID
            WHERE dmt.MKT_MAIN_ID = ?
            UNION ALL
            SELECT cat.DISTRIBUTION_CATEGORY_DESC,
                   "Common For All Territory" AS TERRITORY_NAME,
                   ecom.MARIGN,
                   ecom.SALES_INCENTIVE,
                   ecom.MARGIN_COST,
                   ecom.SALES_INCENTIVE_COST,
                   ecom.TRAINING,
                   ecom.MARKETING_SUPPORT
            FROM mkt_territory_distribution_ecommerce_tbl    AS ecom
                 INNER JOIN mkt_distribution_main_tbl AS dmt
                    ON dmt.DISTRIBUTION_MAIN_ID = ecom.DISTRIBUTION_MAIN_ID
                 INNER JOIN mkt_distribution_category_game_mstr cat
                    ON cat.DISTRIBUTION_CATEGORY_ID = dmt.DISTRIBUTION_CATEGORY_ID
            WHERE dmt.MKT_MAIN_ID = ?;');
        $query = $this -> db -> query($sql,array($mktMainId,$mktMainId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
    function mktResource($mktMainId)
    {
        $sql = ('SELECT tcm.TERRITORY_NAME, dgm.DESIGNATION_NAME, sf.NO_OF_EMPLOYEES
                    FROM mkt_territory_employee_allocaton_tbl    AS sf
                         INNER JOIN mkt_territory_characteristics_game_mstr tcm
                            ON tcm.TERRITORY_CHARACTERISTIC_ID = sf.TERRITORY_ID
                         INNER JOIN hr_designation_game_mstr dgm
                            ON dgm.DESIGNATION_ID = sf.DESIGNATION_ID
                    WHERE MKT_MAIN_ID = ?
                    ORDER BY tcm.TERRITORY_CHARACTERISTIC_ID, dgm.DESIGNATION_ID;');
        $query = $this -> db -> query($sql,array($mktMainId));
        // echo $this->db->last_query();
        return $query -> result_array();
    }
}
?>