<link rel="stylesheet" href="<?php echo site_url('resources/css/font-continuum.min.css');?>">

<!-- START ACCORDION-->
<br />
<div class="row">
	<div class="col-md-12">
		<div class="box box-solid">
			<div class="box-header with-border">
				<h3 class="box-title">Budget FAQ</h3>
			</div>
			<!-- /.box-header -->
			<div class="box-body">
				<div class="box-group" id="accordion">
					<!-- we are adding the .panel class so bootstrap.js collapse plugin detects it -->
					<div class="panel box">
						<div class="box-header with-border">
							<h4 class="box-title"><a data-toggle="collapse" data-parent="#accordion" href="#collapseOne"> How do you play “STRATUP”? </a></h4>
						</div>
						<div id="collapseOne" class="panel-collapse collapse">
							<div class="box-body">

							        <p>	The “STRATUP” global challenge is a virtual business contest among the competing teams in the market place.
							            Each team consists of six participants representing the head of the department of Marketing, Finance, 
							            Operations,International Business, Information Technology and Human Resource in a manufacturing company.
							        </p>
							</div>
						</div>
					</div>
					<div class="panel box">
						<div class="box-header with-border">
							<h4 class="box-title"><a data-toggle="collapse" data-parent="#accordion" href="#collapseTwo"> Which Market does the business operate in? </a></h4>
						</div>
						<div id="collapseTwo" class="panel-collapse collapse">
							<div class="box-body">
								<p> The virtual market space where the teams operate is an 8*8 chessboard. The 64 squares represent a market such 
								    as India, USA, China etc. The pink cells on the chess board represent the territory. There are total 8 market 
								    territories on the chess board and each team has to acquire the territory to sell the product there.  You should 
								    acquire territory 1, 2, 3, 4 and 5 before moving on to territory 6, 7 and 8.
								</p>    
							</div>
						</div>
					</div>
					<div class="panel box">
						<div class="box-header with-border">
							<h4 class="box-title"><a data-toggle="collapse" data-parent="#accordion" href="#collapseThree"> Who are the Avatars?  </a></h4>
						</div>
						<div id="collapseThree" class="panel-collapse collapse">
							<div class="box-body">
								<p>The department heads who run the business are portrayed as an Avatar in the game. When you log in with a credential 
								    and assume the role of a department head, you will be able to move the respective avatar. Each of these avatars 
								    follows the movement of a specific chess element.
								</p>
							</div>
						</div>
					</div>
					
					<div class="panel box">
                        <div class="box-header with-border">
                            <h4 class="box-title"><a data-toggle="collapse" data-parent="#accordion" href="#collapse4"> How do I Identify the roles portrayed by the Avatar? </a></h4>
                        </div>
                        <div id="collapse4" class="panel-collapse collapse">
                            <div class="box-body">
                                <p>You can also identify the avatars on the board by clicking on the “Avatar” option under the “PREF” menu button. The avatar that you represent (or can control) is represented with a yellow base and you will ONLY be able to control the avatar that you represent.
                                </p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="panel box">
                        <div class="box-header with-border">
                            <h4 class="box-title"><a data-toggle="collapse" data-parent="#accordion" href="#collapse5"> How do the Avatar’s move?  </a></h4>
                        </div>
                        <div id="collapse5" class="panel-collapse collapse">
                            <div class="box-body">
                                <p>The avatars on the board move similar to the powers that they hold. The powers in the game are similar to the movements in the game of Chess. For example the HR avatar moves like a queen, Finance as a horse, Operations as an elephant, Marketing as a bishop, IT and Strategy as a king.
                                   In a quarter, each team can make nine moves by moving the avatar on the chess board. You can see your moves as well as the opponent’s moves at the top left corner of the screen under the “Timer” section. The pink line in the timer section corresponds to the moves and the blue line corresponds to the timer.
                                </p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="panel box">
                        <div class="box-header with-border">
                            <h4 class="box-title"><a data-toggle="collapse" data-parent="#accordion" href="#collapse6"> How do you acquire a territory?  </a></h4>
                        </div>
                        <div id="collapse6" class="panel-collapse collapse">
                            <div class="box-body">
                                <p>To acquire a territory, the team needs to move specific department heads (avatars) to the respective territory and the information regarding which avatar (s) should be moved to the territory can be obtained by clicking on the territory numbers e.g. T1, T2, T3 etc displayed at the top right corner of the screen.  However, since the avatars move like chess elements, it would take a series of moves (iterations) to reach the destination cell from the current position. For example: the finance avatar moves like a horse and therefore can travel 3 cells (L shape) at a time. If the current position of your finance avatar is 15 cells away from the destination cell e.g. Territory 3, then you would need approximately 5 moves to reach there. 
                                    Note: You and your opponent team are allowed to move the avatars on the board alternately as in chess. For instance: if you move your Finance avatar in the current turn, then in the next turn, the control goes to your opponent team to move its avatars.
                                </p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="panel box">
                        <div class="box-header with-border">
                            <h4 class="box-title"><a data-toggle="collapse" data-parent="#accordion" href="#collapse7"> What should you keep in mind?  </a></h4>
                        </div>
                        <div id="collapse7" class="panel-collapse collapse">
                            <div class="box-body">
                                <p>&#9673; Before you take any decision to achieve a territory, you should keep two things in mind. First, what is the market demand of the respective territory. Second, how many moves (series of moves) it would take to navigate your avatars and acquire the territory.</p> 
                                <p> If there is a territory with high market demand but can be reached after a series of moves not attainable in one quarter, then you will not be able to make any profit in the current quarter. On the contrary, if you acquire a territory which has moderate market demand but is reachable with less number of moves, then you will be able to generate the revenue in the current quarter. </p>
                                <p>&#9673; Your opponent can see the moves that you are making on the chess board and can dislodge your avatars as in chess. For example: Your opponent team can move its HR avatar and temporarily dislodge your HR avatar from the game. In such a scenario, your team will not be able to take any decision that involves HR or acquire a territory that needs the movement of the HR avatar. </p>
                                 <p>   However, this dislodgement is a temporary phenomenon and you can recall the avatar after TWO moves on the chess board. But remember that within those two moves your opponent may attain an advantageous position which otherwise would have been yours as a first mover.</p>
                                 <p>&#9673; When you acquire a particular territory, your avatars will occupy the respective pink cell on the chess board. As long as your avatars are positioned on the pink cell, your opponent can’t enter into the territory and acquire it. When you move your avatars from the territory, your opponent can then enter in and have a market share.     
                                </p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="panel box">
                        <div class="box-header with-border">
                            <h4 class="box-title"><a data-toggle="collapse" data-parent="#accordion" href="#collapse8"> Other information  </a></h4>
                        </div>
                        <div id="collapse8" class="panel-collapse collapse">
                            <div class="box-body">
                                <p>The EDI score (Employee Development Index) displayed on the top right corner of the screen reflects how competent and satisfied are your employees in the organization. EDI score is one of the winning criteria in STRATUP global challenge and constitutes 20% of the overall winning score. If you want to improve your EDI score, you need to navigate to the EDI tab, analyze the parameters and implement appropriate measures.</p> 
                                <p>The rectangular box that displays “Year”, “Move” and “Last move” on the screen records the last avatar movement made on the chess board at a given point in time.  It could be either yours or your opponent’s move depending on whose turn it was to move the avatars.</p>
                                <p>You need to navigate to the tabs displayed at the bottom of the screen and take decisions with respect to the department for which you have assumed the role of a manager or department head.</p>
                            </div>
                        </div>
                    </div>
                    
				</div>
			</div>
			<!-- /.box-body -->
		</div>
		<!-- /.box -->
	</div>
	<!-- /.col -->

</div>
<!-- /.row -->
<!-- END ACCORDION & CAROUSEL-->
