
/* global describe, it, jsPDF, comparePdf, expect */
/**
 * Standard spec tests
 */

describe('Plugin: addimage', () => {
	
	  it('bmp1p', () => {
            var bmp1p = 'data:image/bmp;base64,Qk0eAgAAAAAAAD4AAAAoAAAAZAAAAB4AAAABAAEAAAAAAOABAAAAAAAAAAAAAAAAAAAAAAAAAAAAAP///wD////////////////wAAAA////////////////8AAAAP////////////////AAAAD////////////////wAAAA////////////////8AAAAP///gD+fz+fP/////AAAAD///4APn4fnz/////wAAAA///+fj5+H58/////8AAAAP///n+efB+fP/////AAAAD///5/nnwPnz/////wAAAA///+f558z58/////8AAAAP///n+eeMefP/////AAAAD///5+PnnnnwH////wAAAA///+AH5x458Af///8AAAAP///gD+c/OfPj////AAAAD///5+fmPxnz8f///wAAAA///+fz5n+Z8/n///8AAAAP///n8+Z/mfP5////AAAAD///5/Pkf8nz+f///wAAAA///+fz5P/J8/H///8AAAAP///n4+D/wfPj////AAAAD///4Afh/+HwA////wAAAA///+Af4f/h8A////8AAAAP////////////////AAAAD////////////////wAAAA////////////////8AAAAP////////////////AAAAD////////////////wAAAA////////////////8AAAAP////////////////AAAAA=';
            const doc = new jsPDF('p', 'pt', 'a4', false);
            doc.addImage(bmp1p, 'BMP', 100, 200, 100, 30, undefined, undefined);
	    

            comparePdf(doc.output(), 'bmp1p.pdf', 'addimage');
	  })
	
	  it('bmp4p', () => {
            var bmp4p = 'data:image/bmp;base64,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';
            const doc = new jsPDF('p', 'pt', 'a4', false);
            doc.addImage(bmp4p, 'BMP', 100, 200, 120, 30, undefined, undefined);
		  
            comparePdf(doc.output(), 'bmp4p.pdf', 'addimage');
	  })
	
	  it('bmp8p', () => {
            var bmp8p = 'data:image/bmp;base64,Qk3uDwAAAAAAADYEAAAoAAAAZAAAAB4AAAABAAgAAAAAALgLAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAAAgAAAAICAAIAAAACAAIAAgIAAAMDAwADA3MAA8MqmAAAgQAAAIGAAACCAAAAgoAAAIMAAACDgAABAAAAAQCAAAEBAAABAYAAAQIAAAECgAABAwAAAQOAAAGAAAABgIAAAYEAAAGBgAABggAAAYKAAAGDAAABg4AAAgAAAAIAgAACAQAAAgGAAAICAAACAoAAAgMAAAIDgAACgAAAAoCAAAKBAAACgYAAAoIAAAKCgAACgwAAAoOAAAMAAAADAIAAAwEAAAMBgAADAgAAAwKAAAMDAAADA4AAA4AAAAOAgAADgQAAA4GAAAOCAAADgoAAA4MAAAODgAEAAAABAACAAQABAAEAAYABAAIAAQACgAEAAwABAAOAAQCAAAEAgIABAIEAAQCBgAEAggABAIKAAQCDAAEAg4ABAQAAAQEAgAEBAQABAQGAAQECAAEBAoABAQMAAQEDgAEBgAABAYCAAQGBAAEBgYABAYIAAQGCgAEBgwABAYOAAQIAAAECAIABAgEAAQIBgAECAgABAgKAAQIDAAECA4ABAoAAAQKAgAECgQABAoGAAQKCAAECgoABAoMAAQKDgAEDAAABAwCAAQMBAAEDAYABAwIAAQMCgAEDAwABAwOAAQOAAAEDgIABA4EAAQOBgAEDggABA4KAAQODAAEDg4ACAAAAAgAAgAIAAQACAAGAAgACAAIAAoACAAMAAgADgAIAgAACAICAAgCBAAIAgYACAIIAAgCCgAIAgwACAIOAAgEAAAIBAIACAQEAAgEBgAIBAgACAQKAAgEDAAIBA4ACAYAAAgGAgAIBgQACAYGAAgGCAAIBgoACAYMAAgGDgAICAAACAgCAAgIBAAICAYACAgIAAgICgAICAwACAgOAAgKAAAICgIACAoEAAgKBgAICggACAoKAAgKDAAICg4ACAwAAAgMAgAIDAQACAwGAAgMCAAIDAoACAwMAAgMDgAIDgAACA4CAAgOBAAIDgYACA4IAAgOCgAIDgwACA4OAAwAAAAMAAIADAAEAAwABgAMAAgADAAKAAwADAAMAA4ADAIAAAwCAgAMAgQADAIGAAwCCAAMAgoADAIMAAwCDgAMBAAADAQCAAwEBAAMBAYADAQIAAwECgAMBAwADAQOAAwGAAAMBgIADAYEAAwGBgAMBggADAYKAAwGDAAMBg4ADAgAAAwIAgAMCAQADAgGAAwICAAMCAoADAgMAAwIDgAMCgAADAoCAAwKBAAMCgYADAoIAAwKCgAMCgwADAoOAAwMAAAMDAIADAwEAAwMBgAMDAgADAwKAA8Pv/AKSgoACAgIAAAAD/AAD/AAAA//8A/wAAAP8A/wD//wAA////AP///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////29PT09PT09PT/b/////////////////v3Hx///////2dXHx///////2dXHy///////////////v0tr///////////////////////////////////////////////////////9vT09PT09PT09PT/b//////////////79x8f//////v3FxsQn/////9nVx8v//////////////79La////////////////////////////////////////////////////////b0+X//////+3T0+P//////////////+/cfH//////3ZxcXHy//////Z1cfL//////////////+/S2v///////////////////////////////////////////////////////29Pl////////79PT+//////////////v3Hx/////79ycXFx8f/////2dXHy///////////////v0tr///////////////////////////////////////////////////////9vT5f////////2V0/n/////////////79x8f////+/cbEIcnEJ////9nVx8v//////////////79La////////////////////////////////////////////////////////b0+X////////9k9P5/////////////+/cfH////2dXHx/3Zx8f////Z1cfL//////////////+/S2v///////////////////////////////////////////////////////29Pl////////7dPT+//////////////v3Hx////v3GxCf+/crEJ///2dXHy///////////////v0tr///////////////////////////////////////////////////////9vT5f//////7dPT4///////////////79x8f///3Zx8f//9nVx8v//9nVx8v//////////////79LS0tLS0tIJ////////////////////////////////////////////////b09PT09PT09PT4////////////////+/cfH//79ycQn///+/cbEJ//Z1cfL//////////////+/S0tLS0tLS0tr//////////////////////////////////////////////29PT09PT09PT/b/////////////////v3Hx//+/cbEJ////9nRxCf/2dXHy///////////////v0tr/////5tLS2v////////////////////////////////////////////9vT5f/////v09P5////////////////79x8f/2dXHx//////+/cfH/9nVx8v//////////////79La///////v0tIJ////////////////////////////////////////////b0+X//////+3T0/2//////////////+/cfH/v3GxCf//////9nSxCfZ1cfL//////////////+/S2v//////9tTS6////////////////////////////////////////////29Pl///////9k9P7///////////////v3Hx/3Zx8f////////92cfH2dXHy///////////////v0tr///////bd0uL///////////////////////////////////////////9vT5f///////ZPT+///////////////79x8QhycQn/////////v3KxCHVx8v//////////////79La///////21NLi////////////////////////////////////////////b0+X//////+/T0/v//////////////+/cfG+cbEJ//////////Z1cfJ1cfL//////////////+/S2v//////79LS6////////////////////////////////////////////29Pl/////+/T09P9v//////////////v3GxdHHy////////////v3GxdHHy///////////////v0tr/////79LS0v////////////////////////////////////////////9vT09PT09PT09P9v///////////////79xcXGxCf////////////Z0cXFx8v//////////////79LS0tLS0tLS0gn/////////////////////////////////////////////b09PT09PT0+X//////////////////+/cXFx8v//////////////v3FxcfL//////////////+/S0tLS0tLS6////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////w==';
            const doc = new jsPDF('p', 'pt', 'a4', false);
            doc.addImage(bmp8p, 'BMP', 100, 200, 100, 30, undefined, undefined);

            comparePdf(doc.output(), 'bmp8p.pdf', 'addimage');
	  })
	
	  it('bmp24p', () => {
            var bmp24p = 'data:image/bmp;base64,Qk1eIwAAAAAAADYAAAAoAAAAZAAAAB4AAAABABgAAAAAACgjAAAAAAAAAAAAAAAAAAAAAAAA////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////UJj8JBztJBztJBztJBztJBztJBztJBztJBzt/7vz////////////////////////////////////////////////////1anhzEg/5mo////h////////////////9///zGqmzEg/7oo/////////////////////9///zGqmzEg/96lk////////////////////////////////////////////btneTLEiq78i///e////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////UJj8JBztJBztJBztJBztJBztJBztJBztJBztJBztUBzt/933////////////////////////////////////////////1anhzEg/5mo////h////////////////3cf/zEg/zEg/3Ug////E////////////////9///zGqmzEg/96lk////////////////////////////////////////////btneTLEiq78i///e////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////UJj8JBztm0rt///8////////////////drv/JBztJBztdhzt///5////////////////////////////////////////1anhzEg/5mo////h////////////////zIrEzEg/zEg/zEg/96lk////////////////9///zGqmzEg/96lk////////////////////////////////////////////btneTLEiq78i///e////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////UJj8JBztm0rt///8////////////////////m93/JBzxJBzt3pjx////////////////////////////////////////1anhzEg/5mo////h////////////5uP/zEhkzEg/zEg/zEg/5mo////h////////////9///zGqmzEg/96lk////////////////////////////////////////////btneTLEiq78i///e////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////UJj8JBztm0rt///8////////////////////3v//JEr3JBztvXLt////////////////////////////////////////1anhzEg/5mo////h////////////1anhzEg/3Ug/5uPEzEhkzEg//8eF////////////9///zGqmzEg/96lk////////////////////////////////////////////btneTLEiq78i///e////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////UJj8JBztm0rt///8////////////////////vf//JBzzJBztvXLt////////////////////////////////////////1anhzEg/5mo////h////////9///zGqmzEg/7oo/////zIrEzEg/7oo/////////////9///zGqmzEg/96lk////////////////////////////////////////////btneTLEiq78i///e////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////UJj8JBztm0rt///8////////////////////drv/JBztJBzt3pjx////////////////////////////////////////1anhzEg/5mo////h////////3cf/zEg/1Ug//+Om////5uP/zEhk1Ug//+Om////////9///zGqmzEg/96lk////////////////////////////////////////////btneTLEiq78i///e////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////UJj8JBztm0rt///8////////////////drv/JBztJBztdhzt///5////////////////////////////////////////1anhzEg/5mo////h////////zIrEzEg/5mo////h////9///zGqmzEg/96lk////////9///zGqmzEg/96lk////////////////////////////////////////////btneTLEiTLEiTLEiTLEiTLEiTLEibrEi//Ka////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////UJj8JBztJBztJBztJBztJBztJBztJBztJBztJBztdhzt///5////////////////////////////////////////////1anhzEg/5mo////h////5uP/zEhkzEg//8eF////////////3cf/zEg/3Ug////E////9///zGqmzEg/96lk////////////////////////////////////////////btneTLEiTLEiTLEiTLEiTLEiTLEiTLEiTLEiq78i///e////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////UJj8JBztJBztJBztJBztJBztJBztJBztJBzt/7vz////////////////////////////////////////////////////1anhzEg/5mo////h////1anhzEg/3Ug////E////////////7v//zEiFzEg//8eF////9///zGqmzEg/96lk////////////////////////////////////////////btneTLEiq78i///e////////////TMy9TLEiTLEiq78i///e////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////UJj8JBztm0rt///8////////////m93/JBzxJBztvXLt////////////////////////////////////////////////1anhzEg/5mo////h9///zGqmzEg/7oo/////////////////////1anhzEg/5mo////h9///zGqmzEg/96lk////////////////////////////////////////////btneTLEiq78i///e////////////////btneTLEiTLEi/+Z1////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////UJj8JBztm0rt///8////////////////drv/JBztUBzt/933////////////////////////////////////////////1anhzEg/5mo////h3cf/zEg/1Ug//+Om////////////////////7v//zEiF1Ug//+Om9///zGqmzEg/96lk////////////////////////////////////////////btneTLEiq78i///e////////////////yP//TLF1TLEi49lO////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////UJj8JBztm0rt///8////////////////vf//JBzzJBzt3pjx////////////////////////////////////////////1anhzEg/5mo////hzIrEzEg/5mo////h////////////////////////zIrEzEg/7oo/9///zGqmzEg/96lk////////////////////////////////////////////btneTLEiq78i///e////////////////4///TL+aTLEiyMwi////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////UJj8JBztm0rt///8////////////////vf//JBzzJBzt3pjx////////////////////////////////////////////1anhzEg/5mo/5uPhzEhkzEg//8eF////////////////////////////5uP/zEhk3Ug/9//EzGqmzEg/96lk////////////////////////////////////////////btneTLEiq78i///e////////////////yP//TLF1TLEiyMwi////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////UJj8JBztm0rt///8////////////////m93/JBzxJBzt3pjx////////////////////////////////////////////1anhzEg/5mo/1anEzEg/3Ug////E////////////////////////////9///zGqmzEg/7qlkzGqmzEg/96lk////////////////////////////////////////////btneTLEiq78i///e////////////////jeb/TLEiTLEi49lO////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////UJj8JBztm0rt///8////////////m93/JBzxJBztUBzt/933////////////////////////////////////////////1anhzEg/3Wo/zGqFzEg/96lk////////////////////////////////////3cf/zEg/3Wo/zGqFzEg/96lk////////////////////////////////////////////btneTLEiq78i///e////////////jeb/TLEiTLEijbEi//+9////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////UJj8JBztJBztJBztJBztJBztJBztJBztJBztJBzt/7vz////////////////////////////////////////////////1anhzEg/zEg/zEg/1Ug//+Om////////////////////////////////////7v//zEiFzEg/zEg/zEg/96lk////////////////////////////////////////////btneTLEiTLEiTLEiTLEiTLEiTLEiTLEiTLEibrEi//Ka////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////UJj8JBztJBztJBztJBztJBztJBztJBztm0rt///8////////////////////////////////////////////////////1anhzEg/zEg/zEg/96lk////////////////////////////////////////////3cf/zEg/zEg/zEg/96lk////////////////////////////////////////////btneTLEiTLEiTLEiTLEiTLEiTLEiTLEi49lO////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////';
            const doc = new jsPDF('p', 'pt', 'a4', false);
            doc.addImage(bmp24p, 'BMP', 100, 200, 100, 30, undefined, undefined);

            comparePdf(doc.output(), 'bmp24p.pdf', 'addimage');
	  })
	
	  it('bmp32p', () => {
	     var bmp32p = 'data:image/bmp;base64,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';
	     const doc = new jsPDF('p', 'pt', 'a4', false);
	     doc.addImage(bmp32p, 'BMP', 100, 200, 152, 35, undefined, undefined);
	    
            comparePdf(doc.output(), 'bmp32p.pdf', 'addimage');
	  })
})
