
/* global describe, it, jsPDF, comparePdf, expect */
/**
 * Standard spec tests
 */

describe('Plugin: addimage filetypeRecognition', () => {

	it('webp dataUrl', () => {
		var webp = 'data:image/webp;base64,UklGRg5sAABXRUJQVlA4TAJsAAAvgYFiEE3Ikm01CCQfENDm9v4XnKixp+Y/ov8ToP8yj+IvoJcRn7leR3zjro0R3xw7FPGBu7YeYdvMXezoiH1miD22CzPhDPWIR+wDM78A/RYmgaT8zC4YyjHMHNBJzJ+wsMZY/GDLD8wYUkvWAtUYf6Cnw/o4ugXw1Rg1JGQmVfEXTs6hAS1VSeAfsIgzUt6/v5mZAO6fRWXDb2ZmmTjWZvusMhWnWVaVA7E4dri7m1lVZkbEacKZYxH2yldVmZkVEXK/ptYq4oXf5KoicAe6WzEdEfHIbzpT0g0LSXYTD3xDAQ5aPoiV31uvVJGTj7FoO47jmGLyHZmJ8HGjxZEREdK1ULt73yn1cjJJERHyWdPx5HXbcRymWE5IZmYf2Y0J3L/rhRQBWv8Bpsf/gP6BiG+8fYOkL5oNCvW8pbvxLbFP2qTQGjIzJYAb9y2wyNsfAMFCqffuaJ1ZEVUCd+iVMt64u+7PqojC59ISKeLFdSFg0ed5nsV1XZfZxPSLPWMYaN1tZjZsOUmI7jdn6YlfNHZWgZAE0gVPepyFnuK0IlKPcbMHA0LPAZF6w7C786fgEQt4BH5d153iDwjcfVrAbWzbtTIi+iKyBdB/TW7hidD/H+89D90QEsiRJDluEloDA2rNetN/w2gC7Ei2VSvziUP+URHC4E/vm3Nw7/8EwL9VX3hCDHWHl/XbCmaYOaw62B7MbhyRbXZemmkmAWbxxTD+yC7FB27VlYzozDDgiWO7YyuIObB4+4KBH47v2ccYnwKG9jSyz16fMLoQw/2FvoI9+omT7tYffl7s8cVvUYoZGZkp3ekOPxFX14+sYszMkCnlKE4LKc5nXBgaAEh3FjC6ftz9f3xhPrKKMWZsrKcUAIlMUzDm5dw000wFQgJDoczqi5hVViJTzKEExJgSTuAKM5PEiIiACjF6AQBQYmTemHPOacQ5Y4wUJ0RDilIBAiapBWNMAJ5eYoy4pWPNMccc4VOKcYL0VoopISCw7Fh2mEQEEHMAxLj2MM31nCHEGJOawElOZEx5SSlGZMN+x7LDGAKASIaUQubcPh8xhJiyxPwT/QQ4y30+Y0yIEdlEgBhzBQC5zCqlFNK25porxhRjTmHt4ZR+MuraMN6X5nDgtm0YNU5qu/v/j9N12+EeEBETMPQP0ZWZ+SPYSspk4gcAELonga8AUucEPkpAT4n8AgnqOTI/yGSyY5wwE68hxcMDUfmeGnYU9w0vYUfa5rn0Wsokbf6OJNCmaDNpmyahb0hb4t6dbPjATTtQtn+ALckU1SxJX3C39Zbv4ca0LS25k1+JtilFREg2SX2gLWlFv66QCe3wAnYAyYqaETFlE5t8IzegbatqWSHbJpoSjzLV6a1UZXmPxswHIBp9qxm6btxAnAFowJ0lH0KSSOCuAG3Bg1uZEqBOYAeAaABU5klB/QQtU6B22h9oy91kIhuITJ5pN3QLSMkUmalkdkg4UdlDh4SkRKaYk01KCTx52hLKTBLMhG74lZTJ1P4X9DQlfqE3kN+k+EzgJ2S+k19k6kWQNFUuV21sm7JpAq+APqV8zNSroDSntLmXliS8wqpaNWdcUt1IVbVWRFzxLKvW3EaE1KSqqrWNqCdZa9VuRsTcVNXaV0TkgyuiatZGESFbEWG1ueaKqDyrFfa8r2pVnrP1iqoHEaqTVbbWWuVo5YoHY1xR0kld9lWrx+oRVWMcjauqdHCNMcZVbcVaa66qMcY46tqPY+3H7Z1+Rt1ObduuLTsHqzI9NGoC4B0OHyn0UmoyxT4755VMnVwdRqERoWqtYAwYH9mHcWFcBJ+U+MxUDAqZYHwYjNpIcuQN/KkslQtQ7n/FJpJkK302wAlmfqKGDHkoICJyEwEAEh3u7pO7k4AQTESCHLaRgAYEIIm8/wRg0bZttW05Y8y5aEPxYehC9b8TdZWvCjNv3msvmkOsA+ps/djqQZhxiGH+qLr+ZoSTaYqrPjNloQqdBqRodmCY3YIwJyeSpjzqD/gjoxgKQrsBGaEOnCsWNX0dqNODMNhhlvy7EZltA685dulIJjUii4aVHUmSaytZs+8BRvCN/+7gw9NajyRt2w7L+b5yV47Vdl2x7aygN5GhhtlGrsw5Szbgcdu2rcKx6q/vQxLJVlZ+SQSiEYEIRPlRsDgq4JBI5ATYdf9flSTnmJmZmZmZmZkdMTNT7I3M+Cr4BGy/xDrjFKvu7brn3D63w68x6lGZ3VHpmm66KnPY0ezuCzh2aKmM2Wqia7YnNbZUwTKVmSGmfKWKT3A0aUv7AKPFvo9QjjbsdB1RdiczP0BHFZU0oVWZaUZLeWdm36CjkTrqyFxJV7SRGVuO2M5azkaKcBDbVqCcBmgCvgmkATZYTQAmkAYYgQg22AhW2Cg2cAKsyP/n2HbTCkxUpSVkwYjTDgSzdiNtQQuQYHTOOeecc84sxz5nemaOpufAL9MKEjM1SujeGtQPnRr2kKnaObG7Agt5AUcoT9WDhscwNVZagGucDV11uOKQuweVUaOLH7zwlqmQs32QtARRo66rFdhIVZeK3R0IOdC7gkHjBC97ZUyQbdMx3Z/tE+Cotm0h2Q3IQCNsog2wATb4NHg0wKGz9xt8Rk4fDSbAbrZtq20rc66Nu7u7pE5EDXRBR8egE0u1B4fQXdYMxlh7c11rT+InR2ogmsEXYH+KtXFSHF4snOGJJhYPLONaDRBTyMD9LWFFRKwUGQlWDocKvosOtAWduNOD5ycl+irYKSmxnTLg1ra1LDoXd3cnJKYO+rCOJKQDQjqwiEUGM5NZ5C4XaiAACJR7aZpccHefwUnaSESSeyaywu/BCBA1uSR3B24kgI2UVQXv8d5nryF1OlIiDRVcCSrhOuAKwLRACQ8N8EQMIbHPiJibAKzZtj2bJKdmNwgjKf+ExDxa732bqv8H3/vXShmcCSgDi9wDXvLStWF88hpTpMgL/wgKyzvadJKRxe6J5yN/Ak8QohPBByoVRbAWTjTyJoJORdRTR40kOVIUgOPP0r1291zCsW3tePY8sV1mZSyZQPpMK5UxANsdK/+2bfN9bkyALmbblkmSnBqeWWZmZmZmZmZmZmZmZmZmZmZmZmZm3v0xIiszTu81VJt+ZZtSMVKryuzlVB51mYdTMUdmu446VGtqvaYa068aqbWlMLbZOaZQLvPmmDpij3p5a0yhbEO3flMvv0rTlMLUy1u9hlQa62ikGkOHck56eWuOQtWmrn+OssxVWmjFotlpTuVR19HydqrGtMwQSmkgFaYuaRlTYWa72pSKwTSNao9CNaYusY0kyUm/FkAI734EeJB/VlCsatumNSMRRA0l6EE1PkngPn8Nso1UkzuDV36kN3iVCbAjbf9i20r/e8lex667a4SFFCPQ6TAKZsUMyNzduXJ879X/oPv6BN4I7yK7hXu00Ft/nJXcCBuDy05+SYd/XM4A0E52EblGDql7dqtxol+RUaTu7i7Rrc5IT4TbipEOcZuAZa4nohaeWbSLiKqNa+POIG7dCLfIMoqWbdtpJOleMYTCQcWMjV81/5k0M6MprQjpyaJt63ir8/1/bdsNavcab7ZtP9m2bVtPfKptt1d/MtI77oiTfkmRr3+cLyaAi/z/73/bUk53k3McAjPAMgdmyQRuMQGKETCP6NI5R3w/v99ae91NHfuYwJIdhkCO9nqyYgK3sC+y+lah4k1DoFDNDGhJz+D4rwL3lIQZ4I69Q6DakcF1UNQiqGiROPSt68jgMja57bdGIc8QyFgUtoN1I9m2EjXulrP/bRGS2UyEu6lt24k2VY4O6EAGiKJHQZCAFMoxkFPFKBgBQyZtG0q/WdgE4M3/f5E8Of+ZZWZmjOuyPvsyODHroKp7RQG8wlAEdHzXbiVyriw9z0fQUWwG5bTArSDksrvQEYyvGFosuZfAhqAEMIJvBJfIwojMyugrykT+RNAu3DaSJEmMWmn99/TV7hKubdvGnnO+6rdt27ZtJbVt25WfKCMPkza1dWMC6Nb/p0hy/jXHDC5lgGleHGefxWQxeczMzLhwMCdz7V8CrTBo3Pb2/fMR/BIoU1ZlUGLJrVj05B1F0CFMAuPvu1hkKY3Kp8SSWd5EcG8ykMvumkpDEawLt7ZtVdXauLtbSnnUQk5mERWQMYjcIXX77i4Xbm3bqpW5v/8P1EDIoC4aOXcMGqEDMpeIEtzdPTZItm2brlZs2zZLySvms22/DShaDbBdsm3bnoADwL+PL67ihIi0B4LhcIJrKCaSKCYTN2IKLihBWu+cF9zDKpFNbEyGnM4JTu+LIVMrjuMM2V3wQdCHRN1Y3OOMHh7Jnk2950AOjIWL3T0DbwdPxzvwcrwC2xf7yC4EQbTDnlYsusH1wqmpqYVTePwIbF1beyR6yaHriuFNt9NJcXtEJ7R8ajHSrq39+tdbewD9U9hjf8NhTBSKYXB5QMvPYPl7kH7rGfj1WegBHLsT7MMWUTsdXL7u9M5vClUveRTuFsO9BrBGsBVDFNGauNyT83nK51D89vGb7x4GIFSCYzgSNZu4PL7zegp++DgYvkW8mgROsPaBRE3xxHmPTudqXodvHuu2x0CC1cWM+jaiZhPnmYu5uFXx1W+diFMgkTWbUd9F1GxmOM5c1LdXxXe/dRJOBXLW7PRViNcmGY61K8A7r4ovv9qN4o6B6Wu9f1/EyGCK8+Xj6pDAtx8AN4YdDdBs9TV0xQpxPmdcD84UTNV/wXXiaWAg7kR9CjuIB86168IlgKn90I3j1mGATtx30BrE5SndBBI0gg+Iq8HjwUDW7PYRiPldnGfefio0jr03hdtADpiwL6A1iMtjefv+0Wg+EPYgD1kYBb6/fxeXl3FZ9KaHdlh5wMTBLoozrIf/yvmDRvb6cNswIYuDXGpwOf+GcMag0b0LXDNMIO4GNpPicv7toEYj/Ii4DDwtTEhNQItxe1G4AdA4z7hWPBLykJkgFhncXiSuHzTWQ5eNfJBGgauV4fYi8G403hNOmKDVWorbrbagMb8vJ7I0UM0dxO2F47pB47ba/TiQBarof340vf3EJeMJYQZZMDuqW6D3f2R83NPBKg1ih/DFtgbwKLh0WATlH0XbvX/uB1p4rHeLqTzRb+wo0MR3u0cEKcUNLgBtfOWgdmQ3gD4+EVIX1ueo3Xl+WyO4g5Wd8q23ClvsTJPy2l7vxuYX1XPBFjQtV37KfbhwNqc4p9B5SzhFNDG4pbe7wLa5pLUovvNFgybnVdyFC1wu8SieAm4LND3v6qrcEHKIR/XacPwmCNd1G27wuaNlVQ7vBkFT9G4uxJVzOSNaimpnTpOEj9+WG3ybK1qP6rR3Q0+fBO9si5ArOpSPcw7QFL78fSISIUcEq3TyuAWQ7COAzKSheymDJ4JGZvLqEc273NB6lC8Tf921zJrJh8fkMwD7n7j0EwcHGw+OFo3Q5oUO9X/d6c5kz5rHBi53f+LZ4Rh6i/uCAl1O6Kza3h+Hi0+KlT1PBiwH6DxdGMbGeHRkDEB5xxPZulfgkwrOB4IioH7VOFs4m7Hy8zB2zjkdnDm6OrG/0WNg0cOhBePrTuMEeoO/KCBogcCg3vYZOP2hv+qHAnRvet44beByywNj+e0A7N3s+P19XYVWAAguhp1P4GDBreGHAm07f5eFRHTeB98zFgCzP2uHqd2WbQUHQdD1zxDjlWMHW4UT3jWAk8VWW54IiPyse8OfBM4QJ5g9dWPLwzjAaF+XOG8WbXZ+6Dd6csDJ4Ccenyj9k/eARwMcADsdfuo2C6eu073V4zgD/DZsvvijAvaPvzNOFL/eXeMpAbOuBCeCqdmejjCt3o2EcfzXQ1gV/jAw/6+fNHD8VEhbDTrjmXCYjaH63ddNxUqf+xFOrNG7TYjzfddZfMRnwP6w1Sxs937z3m+eTmN7MJFd2GELlv3mMbh4nA+mXnwujrtC50bigvyUqtlee0H3T0xg/cx4XMx8u15c7jg9nDq6bZAcXQ7nhLdqRGh0bhMKuXoLTPeaCfP3vCtg+ZiYsQjL0uDctf39+4BJa+uqJ8BkHagtmT9sATN2gXPEW021ThUumELfRuLCLDA58DvC3uswfxYs/5N/IX92yZanAtknJBBBFNRXXzd/CMxIA4NzTgkW7HasHItP0DaV6nKBRt82oaCL/6ThQXAHYD84OyzGtH2jt8Ny8bLTQRAE+4KUlrIC0dy85Dz11X92eI+B0Umgb88DmfEUOHSGxVeG6Bgff3w8I0Y2WKyorl69ohopVo87E7RC10biwpQKwIPiZYl/l36MuZnfHMvFy2qLwiDR9bndw9hcMG/RhhHP8152dBLITu82IXfoXjb9YxF72ZkzN9Rx3r9ixeKuiPTjYqNrm1DYuRvgZT+YfeNckMD4EX8Sy/ecVW3R5PSSJd24uGjGIu/Z4L3sr0oDzdPaDDwrdhziX1wSItH6ei/7ekSwtHjOtKprPW5UhZ6JHBdIlc3vFTCwFKC+HOsTO5nJyfeseVB5TMVKDTBx2Ble2TvWXwQqXc9noHx/KLPVzq598PLl2B2AAZOxMcbGDMZ/MW2aSyU3BNXo2SYUeO2ikTsFfFAzwNiiskXpK43JculZIG6hE0ec4ZVnfnQdSKwrAbRv5PHaXa60fvDz1TGfNmfpKWJ7nC4aW/V6qwoA/Tu/f9UNdQM9i8JC+dwZoKcAlN9uAZbNn5UM1JYN4yTYVTPYfON0ceIbLQPCDxoGGHpTSpv0O2vdZham89//Ewdxf/KIs14NKJ0rtq46W+uK0zLRs4LtCMP7xQbIPTbqWE7f4e9Wl/0WKoA4UowKSu6DNypOHOvIAD3rAeYtY+0JnIzseB/AODB9yzYiveAhMToOpXPBV3fku8KIjolBob/7G1LpCOGZ0YLNqgy/THu7YC44Dmm/6df/S3fQhmntFAGweYZdj2nvcIesA/07v0yV6Jy5cg1kN1vrQNxpaliLgjcvYzQFyQlsCn2dExOiogimYifkmh//z79eEBM6swH4yzy+dLON9F1iEli4+xKiuHXjjWD+RaMUuTDSr2bhoK0Tngk5rBUZr/s5jKICArBTEB369p+Id6ImVBIB5Hpp/jirvQ5dh8/95h1Eee+rfgSlPebbcbujX6EHYQ2K7VinfW1/rzvEnWD9cPf6vimwFt4M0cHjV1S11UBlGCgkuUDsblK/K7wp9O26AsftE3bmugIbNm7nHHFBiDnEhoedIX471ukRPx4ivb0jT4He3NLEagEB2CmImKuvfoZC2kC8Ctqu+U1KwLKj9MKcPbGbbs2MF5fhtK+vP7W0P+6A3EZvyuhXykZIFJF1S+weVEr4BazzaS13Aiii3m4T7eNeaBCvc9xhVP0J9VvrSYB4Hsp1Bg4BG50wSW1RG+bl3XoXzCOSbd2J9TU7MO+w5fxbjZqJSzR1S/w9qELSt7Gten6nrwqoKHi9my9IhgKMXCNy9H3fT9a9VfcEA6kQkj7fPXGouwMMLsa0Pm/eONFY7V862wbFh0Y6f/jtIxNr1rp/K1xYoexhfYboVk/awGCqoYzsNs8L7b0cRn3f95f53C7e1EBK8IvM4fUI1yUAvAUtGRxmszRXgfp2pNO2gHB994nDAlaNcSHY3vBqbpmuXoXE7/vYbe+SUtHzQkTRMvGb/937v47bS4RCFKalWzbLm+TiUFYg35ECCukhbGfXru0/kAACoKCPgfSiVWkbaCbVvzowo3VzfuIcQNwiDAjz1Y5XikuYxAsV0ybX/Zd/Ua0vIJKbvl7friZIgPoQbw6g0FrG7uCZYEnw2PjmEoggmKmq7+v4mjWTFqbDidCEiXFeZA4kY4IWhU+x2/65xAvgB4CcGy2p9FfMepVQRKFzbXzrURMQlNQw5AoeNrNb7jD0pm+aBgmkmb5OINfKeFLVN+72EGit24BSNTBQz7BiGgtciyOdCj14P7OeMPAVFVEsZOQqDLeZvNtKUFHRxaOVn2gBSAotKjazxzzQQ+MTe4HOtaN9fQjmCmPjy5Ylfc/3Bkvb1W1AJTRQ9o46vbvdNWKdiiVJZ/04gAqW0fKCUl+A3pGzItuHXQttOM3u2nXf+ERMc5kVHThUGH/Zt5vwYDS/rG7D7t/dm9ipN0EogB+gsJxDCEAlK5CUayagtcFwV7e2nXbEI4OAIrl5kprbVbWjgKIf8aYFgUR50o3cb45AqFEjyJnOakVQ8QOArEvLu2F2xMxZzdB1la6FrjRv9qg4cB1RAFE0CES6PzdhS0HRpbleqOTfbpkzchEQEelTLEdvzQtEBJstWtAL5MdfHHthVAEtdYTbujF9hxdtUdBAARXRQIyrB/OAAihq0Hi8kFENjnVkZxGNA8ZkohyKSO/4yG1m2GFeLg67Es4Gq7/rtzc0yBr5i/6/U8HSEFB6Cd1ngok3LVbb1sYmRoqkagAisqysi4g4CfMC6F7ZJdXS3PAc4SRflUCLIa8XpBaWAE0OKiwefGgMCaV8FBlt6iLly67OVURhNLlGgeA4KGHcGDsMSk+4g5MEyjRyXSca6Nx+UImAQtuiSUUTURRrk5FjXlhWFFoLFhpuxlOGHOes6Oy2znUOEJF8eEwAnaOhOof59GEhqluBIlkMFGNzvE0+cj4Os0uMUFVdGsy3k2wFEG83aV5rvCd4cVbEr6Ckk1GTBopaPcC4IC9zhzYBY7uMoehosMROWg2s9YoGvSI+eqmDIorn+wrpqDG6lEoxIZ4a1OQccTkoGSzGQFHtbOsc7TeJqiq01nqB2EkVjQc7GNX3vRzoqoBhpDiUpK+qQFi0y8dPpS7XOQ5VNBvM6lNmfF9VfXVcsi6TF6jyX14CRRTE9zyv1/cyK5JEhCZ1kXLhR6SSgEomi6yPR1UVNahBUVFgfetCiz22qWNXhSaWa0Yu/Zezac4qygfNy5T2iBKjSakcg9sVFeM8n2my21cYqCW9v+BIyopjfnWAxMSg2ayuSURBFFHs5trWJfX4zTikiEJl8ctq16zooKtHRoqOIJ4DEKVl+cpHVFHgVvC71u4Ek39rw/WjB4LOQofJBSIURUAFFQUVsbzM9fDchTFGEbRv9obwRaIk1aNMitGgUgYU41rQV5NUQHWTo/6CvQHSV4oDbbEO+grNhr1nhwiK41yznNPzPL/58YEKPb3h+peJjkyPUimyQTyHgLIsTb5iHVGFn3IUZmYM8b9VGT7aXDrrCcP0IAAeHId9Inj5OYfvFEAt11hex+Y3K5QuQNATBLtHhwkOzRL6Cio0z+cW6ytKeqqH+Snw9w+5BOMf61r3V6jWm4GB1WHI2/3MhdeBs4W+3vt+q82+EihLk+XtbJuZYwQFmF0N1w9ERYAczecARMFyzVedVN2kAvzTA5pwhCPdKj49VTbsGQbBXif80j+vvZ3Bf/eqo6/2HRFqcuyd8755IkcFUdHRMJweFakepVJUQ1VRjO25tXz1Of0FCww/9Ch/3YQf13VxWO21QWJtEC5/CPCOu9YA3upHjd4HjqZYrvnQXb0ZCAr0h8GBErHU0iC1bWybB1lfGbmD9T8RAJo/2oy/MnDMNbKUdUHQ+o6iQ3vcNQywZo/f9lYBuRaLm+Pz33WZd6UmcoaIhuBYCmSbx3Hzia5c0K8Grgpf3WzsBb/8TCkxKwi+awjM+F3vbMJn3CGOmhAsnraHsBfpcBBbIanNbJgvWJ/Aiw6XMd30amHGcX5/u8CgPAYm8wq8479oNuEr7f7jAGsLN5+/GMNC+dUgGIwGEYEhS2hX21yWT3CX4bQZX75qcuQ7xB47TEF2aRA8XzYH0P7if8xsm3+9TRuPswmR0CAeBKeIGCqBaRAP+QQ3LBgUi00+CEYOvPFTgHPEETTRHCSXDz8rDLxXu1nmcvGCj/XK57FcU3w/L1ERJGW2XWbPfJIbOsMRi/PDvNZdXq8OdL8bJFjTGc+ZFD5vuuEjtjnc8R+L9eibR1FF8jUOiRghksR8ML58GoethGLRnP2hmH+GMCqPgb7QN+H12hlZfugNMLwmXt+Oi66+H4iMxghGohzLU5+CDgcVC7tbQIl0NcT8m/+LvdbUMX51gVd1yCsvREsxgqy6mTbMtz7JHxoEVReeFLNRFg3g4gYi/vlBLMj6oh+kVBzL8csnMRSEgQs+xtCNGRoxNGRBe/wg/UTw9b67i47f3oFGjiDscyGny0yqakNE/Pa6yX7QqmuSWEGeKdEQuKGaRAkpqUW+fX50OOYHLHwPigi/rhgFK142PBHkk0ooasjGoBFq3E/EauGxTyEKCi2+V1Aq+RaNXI8fkh1TataxVzP0q/UQ+Ruamsb97X7jp2B0yEiRJEl3R5TQk4gNZwJ6DqeUTybrWiqWajM1jVxicm6Pn/4UtDiTgnSxEFRIjRDx+ZmQ9SWVA+l2jGlzoZt9oTRLJSLRanKNtvk7fkCQNF2sYhSYMVGN2MvskoW1r+egR+u0+IPpMGRl3V7Pf7qvpEXk2ISI6IJoMDpk5PjmPoEqqqqiJMxFjME/WWXFYYbsrfW/OcntOuaFIWMPAXuH+Jd9tS3nDA0VbSEaMx3K5GhRr4JiW0Q1Yju9xVwYWulAx+Cbd2gmhIfG29n6Xf8b9tFyDCMv5e1iBRFyjHn1FCAq1gyoFCN2zH+9GHi1w9mZE/fH4PW86asqwKxXszH37mC+0i6W1mIh6JqoMIFhaKRQAkVJchW8SK3oOGAH8GpfYmNrvzAELa0vM28iC3ziTKvvuJXzPkLysrWGDGWoGBU63EXSb04gqJoJhEpZI6N83e84B2DDBxfNugb9SYBDnTh2/5L3BGj5FxtMFv+PAPORW5dgeXc5URlrUCpNtVxRQF1sglApRkTh7BD8jzkAuclVaeJZDu/pq5l4e5equ2PaQvxNV/2Z+YZrXXYIoZEhaE0ga6KDSH+MLI+K9RMpUEXJNUDwImE82hHin4v5H7s4dO496Ht/0jD0id6bfEbPucAEdlz0235TEL44zrtNjrFctx//dk8ORZQa/UllGTp1eJ0iCAYx9qWvIPLL/+e/d4zrJN1+Cde7fbrDewb+/zd+/vVves/xnwP84t/+G/71f4SSqtmriKyLCoogIpW+2uowZK+YwcjC6uF8JZBA0Jrzl9w7/xf/w+uuf/zHAGdYfK+7pqn/I+O/96uL0n9dZMchv/qn/kj8tf8QjGAzrwtarhooBKVarVKqhOxItKbBYbeeZ0VJEKFZGPbFi0DwC3d9618WLeJXv/nq7gHPv32aLtmMP/0UuOMx7/Pj/QBOUFzn//8H/vovPpeOZvYi5U0NlFS+VkLCkgRDi6LGaE8XaZPPp9VABBaT4xOqK5HzV/YC+O9jX+/vfsTbPz9N/Q7v2Qz/fdljLrrShaemBr88X37dj7993JJms0N6r1KJp4o5CUTagiB7VKI21p515aHcR0pENGKMyYu68TKgX9kt4I3+/f/yaZqmz2VzvuJ9xzxmeb6pwbDt23/87/ryZX32Tk6tL8+3YcovlosKIimQDyKKu7ojpkS9HbkSiOuyzTWsuhbLWUVTkyVdY2rtO7oCs0vHeXAx4Af/WJ/5WXz6FThMjd3zFnuvRcd84c4DBPU83/66f/yLm89GLnv8Ot/e92cvp6KAooHwfERzrDviK5GXCv0Qy9HLoOT79qrublNTLPA4HLhmkrcHrpm5lT5fYkDDDnwTmM2fO5g/By0hUrDpOHbhnDF/HLtwGrPiLWBn7EKKbQxC3b7xuYUoAkgAUstHldGdV0nEbnOTJcEujNggrKoiL0LX1YSMnrvtwJlTV6evb/0jCpd486944pt5KJQ8T/pceCu4NXSupHTz7jLa49jvXIvv3CsdomI255JjQwUVUDEQ1bHmtJB668rqUuDcnDfrN8dKSfapT72fe+icd+rc+Vs2vfhg/RusvcaV36bJkukPeeSRk58Rp9/jbnq6yG5+vOLJL+2e+N7iTrfdsXfcuXfc6a7b9oonSHuSZmvJJpGZsklsMmyC/N3nrf9xNTIXnOpt3Gbq47DfMQRqqGtq5VfAR1bB9BmgRL/RnFiu2lkgPGnIZZcdZmbffCMmivfqvar61M9L8jmX+jnn+k3e3QgF1l9Tpt+yctlD61+ap750uOnpkpuer7rr7q6T72knvmLKRZvfCQUypVv/0Z0Qd6KY460STkg4VZOnsNy0V9zhoTv3oZtddkrcFLmS66MVEsRou4n/on23NYfC2yPTr1MDKNd2yBqgIIoo8FQoqmrUMRIgOFuE1T6qXo1B3yQt1KPqVf1G5/pNHpQc+rPDDyseVj/0hNe4m58vuuPutpuerpiuroKqyO5ljihCJWJzM8syy8qaptkq5akuutMTN7FsMI1yMCKpQ0IdGmLLz8gNWLkc1peAql7WYVoYRTGWnxz5mvYS/WGQyA8E2bHhVJexYkZtoF3DH+7l140flBz+1aNGp01x1eeY0UJWrOm3391y+jOjwvYuSvZPWREroLmVS6xc8NoSMyQJZSlKyLZKWwHFyzO7SY9RGMcUT10FXt7Nf0y/EdTHgVyyAHRkl5gQFQVB5alQyO4fDA01gFhrWsh+emgLHxQOZk2IlymbqS4M+LCvvm78pMQa/hxF0RL3FTbBClfxjBZmyO6fgoPxzfODNi+xbMu5+WsLTMsooShF8zKkbEj/12bIChizFATFbPbXRW0MiXJ3RBSsHw0u6j3Lda0mvmDUzFOhsybcN5I0QFFE0plQOs4cwT85L6tbM5LAyIivpOlZjvCoYaMnJduFnUoxowWsuKUvXwUh2FCYAA4DVm8vsf9WiVicbCDOrV++3awIyaIM8xG5ct2v6v40Ri7H/A5C5vL/KEbrvwbKZqPM2fXjX+cjPx2eCqVEyEf00DDjQFE7RXzzX+rq2q9ALA747Ukdtfxhn5Ud4WlJhciMu/CVa/qsFhEK+74A9u+9zMCtxMyYv3Y5twfzg3Fu81gOsCgx8iYUhfp1vx7WBkyoPJZhdhsBYyTzqKEfaFs3yX7FvPv+0hvfh8kuKmhuov1EkKiQ7MnQQEONicRFPp7vy3/5272ZHIOAknua/Nv0XldkzIGA6UA+psl8iw2dL3tZCHb4suH7lsulLc1EfLAYsHzt3OKyCMkwVxRZisN6WPfrYd8ADZdS4ukqZj4086AdWjLfHTffzSbfn0bfeVLIaHj1eiHo6xSpPxR+KA021pgQFTuU/cBEARRremWN6YAf1t1x9d7Wey+AvfLO7LQdpy6366QWJ7Q6zbJRExqVET2kG5os0tK0jJNIQSJzi0I/Up9Er5GRSihp+hM1u7M+N7nro2bSvqKJMLfZtxu3PQJgp512wucf9l/+Zt0f8m37gcrT4HCGUThtBQtOHoIAgmD3hO7708Nzy5/TH5fUeH30Wre0Pfu223PRqgOOk1lO1GFT2iSF5aa9wZtMgy2lZXxTuSxHxf+Vyhip2SsjtXEa/9G79dnlCIUuDiNnHz78/4EBBwE8j477BkjvhodEGbVF15dYjbxgV7GL08bHtn18WBt2CGuZ2K/stTi1B2NWzSWrduy4cBb92JqoDc0mVK2GwZZCylK0chCG10iliv6hKlWZG95+1DAZ1W29ssJUnH9z5Yf3rVOf5zznuXwPSj5iw6OhSIOPtUVsKFqr2UGH5XzoR1+ZmDKcrMWunL+vRsDqI6P22sME251jO7PpcnPWMqyL29Sqn8SQZOYWZdFcYFRqpGYiU7V3mj7Q7OancxMT+VL7ysnnP1/atpAZTAVF6epKqIrpyIlDADXz6gj3KnKe7KKdsqqEg6nZ25Ifmw0Qr8XT0SpNh71oMmDYmR1XZtWVtqxv3EZJE7KlFSFJ5kbWmyAiNUA/hSo154bGafoq1LlGrfHPvJwVhqrttnvjnc3md4zP+Iv1BkcYRDRTEwDdmiQIOmZN58if0g2XHNGEZnuOUYPXQTXSMIF+7G9fVFWx24a9c6xSti5pwiAhZcuyaJEKY0IkNGeqZro3BG+wcKw8TiXvREkTIEWbzRDOG0te/DHQ4Dqasi4KDz01NPcU2C/yJg4QEk/XZU9B+pGZip08XltQbUc15QG/z9+yGookE0wH2arqvmZCZy4flcesT3+MRPRCh0xozgE4vb990UfKMXMTQGhMEWAw5bHxoHAyeJPHxT1CNdPVk1AlaJntPxUynaFy7Q3HZkkW2NLqvEXFBqoDavDajuoVbzL74pV+ykuMX6iqWZM2SWeKw7EJRmMCFRqpKnQQBWrueXtsjt7enLNzC4fRGnvMwdTT5hkCUN124GeKEQaPOc8+P+SR4nOgWkEwqiDoo73Rc7Rl3x+3d4mkccanb/7g+uq6JiHpx1SiBByx+vxv88Nn4jOfwZqMCUWUS7FX37hovHe3hubtr9d/PTK7yr67b64vHrHaVV+dmpoa9KDm/GdfFu4P94KGJUgtWRel/395l4DhpC/yjPArKRC1eNJdPc1q9vVzO7ZV1Y6o1Q/K0HWtrv/Y6nmY3iMOy898xnvZ1oQ9LCHROEvHe+/LmHvvHfroM2rsLn7ZuXjm0DDrVDYYTIVZu6fBpWD9ZxQaEl0d6Sh1ZE/fu2EN/KQP9YmcpFRVAJ51bI/3BJtc32MuRQ1JGlcTEmnUqCIAFJhmKRUJVVUb2+41cZRjPY03qmkAf3z8emb1XOX/CSuNBYuXffqwqclgMDUNa7e5nj0uFjeLx0JDEkNDRsRZpbNbMgCqGvo5Rb3M+MRIoc/AU+/iOVZ3YUfdhBkgqba0mpCMRaDl+gjCdKPAoFI3zfQy2sEbGu/VuLv33nyxV6fGOn/NNwINRaady4piUMxzO44uOvr3t9mlAXVE0g/xRt3qxfyZSkVNU1L2VNXPtQuCMiUfJ3UnO+KKgV4XVFxJtdoQtS5qsOtSa9b0lrawhyZkG7qUyWj6vnFzvMe96Y6QKke//n/NrPH5yK5XChkMYqdjoqJ933biM9TJxNIO0VC3uoKjoZIHFCopfM9T34DqlHy5QOKRLkSMkDRh2ti0jc1g9NEMC4OxZsEwqBI2a/eoGnnT4A1VLKWuf/z6cZzk996zVdPqGppIURSDaa01MSoqKheNgUQZOi3NEEkc6tRuZh6VfIoiCPFSIOIpqAbhRdKvdoQuTgHKXGN6zv9tyChCakcmTH8cMQuE8ejDouGoCTzPG7quUsrve5Y+cu4YQ5CiKArZtNY0VxUFzg0/U4fVNUPMTZQ5uBtqVwDy+SiqQBj6vu97PqlLxKIummQn8kkXJw80ZZpkenRD2n/BONmeDKW0hWHstGFaxMO9D4smJQgk+pEm5fe/qh88Vs/fDuP1qiJSSAytTREU487txX4pE6+rFYImKFS9UFwvfnnYKHLdNhu2FgDmA4Kgzas8zyWVViuppLFApGJ1DDIN42ZyViBMADYAE5AtsYYKshD7+0a03TaivS1BvPPJf5DAF21YjFY2OSanhKMd7E0bCIIRNEJwBQb1wnHd2B+MsdppzGHbKuQTC6NuIp+xRQApCVZIwChWq9GAuI7kzuLCG/obNtcaL5a9vImRsh2zq2ztHlBlYZZGgN8N5tjTamt53aj03SR+w5s2EEyrDxWDutMvVzDbSgodSCtBaQUN7atvq/kiVJJGpBSykgpydKIdjpklMyzZgMyLmgIqkWokb38Rj7K0WzoxpIEmPm3scl5rvRJRajeL68cjoYEIymiD4OsG5aLxgojYgYNtjJktRAqRVtB9c7HIEson80gqBKtIrXIMek5nYU4HeTesDrAUwdNtOy3sYdLIEq+6ph6xzOsOo8DwzePdZqiBIAtdMAzoZn8FETbbLAc9PDbXgyCvaGpT9cyLKa8AISEB1liJaxJFI0JvaaxqM+lFeN1USeY5oqMBTzHGlKY+Nax5nZEdAqjU/vD1QBEqTRAEXDgQxYMByGmOmWHbzC4IKO2gGf8FiG6CMO1JRSI9p06dhefy2DDtgqYgCXF+bYftlFXTabqapKlGgNaT3U97sdbytlK7ZahxITZogaB7fvbzQbh43ASw3JGwZTw0acVEtRF1KEVXaAT262QfK9Qv/qLr/b73e/UNhD/Fc9feblybqfngpmXvHCWMAdJUde1+9vnpqVFPa60XimmirsTdLwZ60PFYHIXdMACHdftQQAzncmyOLauAmN+JfLhA5AuXo9EFlYAoIUCTlf3+c4eqfvFOnTrvnb+ye57QFTEwU/eBDbrFfcaZQq8ZA4wCJid9Sk+ecpwc1yUCKFCvVxTYA4fgJUA0DQisvx6fIv3T7hw/tkMvjMGGsbizzSxtRszmFQTAU1AE4KiSP/U6Oejh8QKjPeZt+8+gqcifuAz+zGsFG0tDY/e8m7Wr2f6pX/1Lnxx/62GQsT7znOWcQ3EQ0le7DyTMLnQYY8ae1phsjCjNjK9RtMUvSXgUWBPgkkXYhThU+Xqo8iNS1j+M3EICUteK3HevRcTTYtk9WNalZZltbJt/+I/GL31y/3XtRjiXcdaxje+R+tpdoUPWbCYvxmxtY2iTrcHjm8kAy1RBTMDCYWGGwUx2isFm0tECozvI4dVs32/hgi7h+ZbrsOhXgrSF1lqWMdts/lj8+59c979r34ZtM621nDe57O703SrOFWARSUrCNENr6R4LSpq2Ey7qzQCHbYgUZupB3GFK9ZdhemlPn591OS7LtZHnXmthxpjN//Lff2q8L5PzcJnmWB+xtDdS94WXAoybbTnPbDNj2ilsi6r3xpqblq+ZgYQEcWAc01rI8uT+3Eo5N/7hJz9/cpLNnqdLW+veCGt5c2Y2s7/pj4FsW3cwAZ9lMIHjQdovGUfDfNugi4MXY+0m87iqKjqSMCMIbCEwBmJistdKBd413KUA05npSWL1SJqmM7antmL3nnJdXoaZmYM/CrJVvwm8FBNsZgUmE/j/kUjb9reOvMXrS4hsGI3SMuK9qk8bCSNsXjsOlBCs4/sfCn8ZrtcFGgWMASYnZZi5jRaLyTnWzPDiT8GeSMalg6xfB770jZQl7g6nCBDD2EauG5sNM7PQrpaqeu+9Nr1NmIHEBNue4iCHxOGDv/92ybWDuulVfnIyndwz2565h3vWWjSisea0g2nLdnbYH8B54DPL+Csk/2f/jb/yNJi3t822mRnTwZpp+TPO2bSDTJjZIxMCB3/nl7XXEDAcjniXQmGLoupkWqsnGS1mDGOMeWVsfzw+sT37dIAxkr3Z2KxkX/q3/RGQ5LoPwHJMpDDLqgUfOsLmHNc+b/YPAgbBuUiBc9C0I2M9V3Q6tvjW2rJaqzVqeWEwxrwegz8OnxaXBEOj3WIytY1c27/gP+I6djH2xra22Yw17IImxeu0Y7/8dYbEtMU/NtLIvwgTIOC1PYfn4ARvbVF3q4XV1NYobDBvjGHM/OhPwKf1L0YbsRZMh5C67w/vC89lXjF22hiMGdPhaZs0qWrTEmFJDJln9PuLYBBwuL86t8ypVQtrrS1socHNXCP0MBjmDcOw7c/+0Sd14ti2ETNPbSHX/z0LKJHkOqITk9FQ1GZNSE09xpJO1lbAWOZW3T5Kv4IvBLPgcB+WiGjS28IWRWE7FkGHtbL54EbDYFT/6yfFVo1W1eI0cXBS7fzdEcx1Yxcz9mobM2aymbkOXtXXDU+Qdwki5HljI0520RkT9jkI4BzMKn8bdkTTogfYylpYye5p1NKW6y67DIa5znX70U/gk9r0xNFI/RbLc0ZVpr7PAMxxs8MwM2bMbJjL2LBBFKCVtU07isDIEabb4FQX7ZV3qU37PAEL5OipUtu6lU2rIeS4MG8YzHGu2/jbfuOn1H0GsJOZXkIErs8RyPy+CwWbMzsNmzHDhm0tbPOgC4qqQtOR303LkZw1EetiqsiVTuyyWSDXScpOUKNeH7XWWk0Lqqch65VdmOMcZ64/gU+JTe30limuZw5FpqN4jgVCSESSUCI3t9s1Medp0Z36vZuDEZoxO+CMXgY4IrgWmIEQbn/Z90L+su67O78CtZCFGtxYZs4x5znOmz/6B2Ua2A9s9DUSVF3tz4xMl7MHOM91jBchUtK9bWJmGxumwtbSfAb7u9+4nwdlGyVV9uFAkJvnBuZY+Xw/vPQqbN38f/fo5/errrYp8twj3CuLNrJynDfnPG/vJyDTKeFkYYO1YPxOJAMH5ep/SLzkaBa5OI4hr4K4uQ3BY2Ob64RtMn2ngIjM7GDc+/Mve/vo9sg1uN2Cdl5mES675i49p76Z5xlq94SmYGnCwg4v5+W8P5yORPEVdoyZz/X8ACQqnsseWKcuISJvSZJjzoNl1dooiu7NJyuzsqtYcDm5O8AXl7ZlaqGCpbzMosNOXeZD57rZnsjDqcFetUoa+ViaMlF1N92WaOP2HlWsw3kYIi9yje9htskeszYZSnikKOb8mTf7H1GkmO3fQXzT/8Yc4sujawI9z0aJJriHSaOF+cD54Hm58IUSJUJbTEDmXymQ0INF8sx/XnkRFazDXAcReadgjo8ZZpfY9ZFBMbXgX9Ehv1pxyO/mHey/tE2AmHfz32hOi35ZtCHQWvj8xh2IFuvuSUsTa3l7lw+edx/yOnn2jZQ9qp9BROpTWcZglR5OIu/GzABU7Im5DiLklQ5DZrOxmbFsk8FgMDimneI2/nbu1KEB64BfBcommrZVvjzbaFpaJqSRXJe9+Ijzge/5gDwEDqgCInwphgnU3eJ/JJa8ncgxhJB3UMU0qBBmGxRFMXXMqWO+8YXbzgeA6LOHFBFCE5m1XPtI88HW/nhUHudJjSz1nyilOoG6yRJbSuF8B4KQa8hWzMyMwdjY1tPCCGv3CB0PLQ3aMB9XcPtq1IFRMH6TplBD4XOZR5va6YQu5JprDgpiXI4z7LFmECO0pPoe3PctyLn5WMN1a+3omgoxWsVEvpJmTEygcNIPw7g8ueacc8yct8ZG22yePTejtUZ5cj8x11pNLaxh3t7hK74OlRhMSFMfMRkHh9Ln0oZOB3t1zbHLMdjG7AqzbWb2bCy21oqF1VzTmpwzGXvnk9xmC5UoVsH4RWSgliiV9EMbx3sHOXc4Hs6zITPzbJtZ3hxFg9QgDS1cPvXqEqWo1shif0hTqg3UXq0NZXWE3kGXY4fQiSIj2Iw1GXkkQqoUWcJazKdtrbX1A9tCKTgyMJEPmJTiBGon/UAZV/fetcNxtqUxs82asWf2tMzE43uQtVqOuaYhx08tb3uJYtQmSI1yM1xnNBIU70+srYy5wz7k2unlbF6vbXZ8msaIpt2TaxAaWov5yVgunoBiFItkRi2RYyglKAeUbaG6fcg5hNQbzH131dOMnNu9SNHb7Osy/aqRlCCOFDIpxQY9t7INtYEqHvcRjrnusnWhFNZjeZ3WavMyKkICpAjlozoK1aCRYFJl4oxGkZ5bZF8CUPYK6t7MuVfykDDC4LZe5LXYX/RLp85oFEmNGlEKpYSer4bs8+fl7Ir1zqiOhHSpu6OEGSwWpGl0vDuzz4c5oaJsqDOKDYiVSEm2oee+In0/QBmZe0vMmJczg2zeLkPm3UCA9k8Z+qXDV0dQQtEkoefPDkX64rgFpq1M596QhGEUhTzv3EYUqXS9M2D2b33SbiEf6jtjm4Qski8p0vOyEv395A6jbtvMDIZcN4QRhsiMeVOA9hFlkiH5UM9ZbipXmlJIP0dDHMozptB1Zs7LtZkPTmzMh4r9PAz9CkDRFR8sezTEoXbOwIBK+ZgxxtCYicXmODP7yVeAbYoq4DlLisrlyjTIcXInrUq6JClFYTIvhwnR0ddpvyJlRySKzdmKhllcnqeM+nk9x8V6Z7Fgc50x0H4bhiE18EccSexi+dQsDXTc2pxhH3hz2IW1djLL612MQez3AWuTcTVgxJ+KbPUpVB0i77BVLUSk6IB1mpeppHxtvhw4PlWojzSQGOfcyxxULW6TbwBfHHMdm11en1qa69iwr4EyMJ6ogtfuaOUV4QR3+ma3Qt1zIO806ufNmcGadjItmZnrXL8OBoD2uDIw9C4osDIIKplWkIyU7u4+UHg834BVjy4hEizz5nIuVTBfh5MAKjEZKcg4SntQfkqgcnGeA/45yCUfcYxhru/d47RqeGlHI0ICHuXCBEqPk3/aR1jIi17thWGO793kAMCoStBadPAigI3NMnodVIo07FOz+SrWL3IMgrw5GMzxvbu0k9ZaO64WjNhjhHUxecsK0Ydo4Mk25B/Dd3PM23Oc89znMMCovzAPLhZnmUexHIHl8Xg08RsiNkr+SXx0J+Sjzsv5Oq3ntBuejT9rrOVx8Gq9rjlfwbUxtI55Urq6OS5J5bjDgPURdLr23rw5X6t2Oodxz/gsgN5HwcPivLjKQ/ZGK4QYAiujaL1uLc+tzkhryWEYv+3Vx56v51FJgMU7nozFWByvjPBqjFaI/ClcnR6Aq2rS22g71H0Hfbz5Op7O2SaRBvjWwkJyzI+sV/CWhwIRL5dWZ/Tdlf97+S3d9tbLq1HrMGl9qNuHvXfXqgAlz57Ms+lsH5jd9hOJsR0n6JHawP2BSJdLNX29oIVLYIWK1yX87txlh/vOEx0PJgVvweMXP6pcL5i9qExqtJ0ukmG+PULlUk1vV3UF6ZzvVEf3gyiRLxG8BPOPRA9F5DCrl8pkeD3W6SIEO3kGiGi5VNPbmOtJawnnYe2rmGyTyABcAut2QvLWG9NEuBh/SZ+24wHAbqk0XarpaauqJb0NF/ofN6Hkle3Vs7tJmCHXc9MkeCDo+hjWVqJcgOJ0bpWerula0lxyernVPjVreHVJJIjEsBKzjU2lqp1z1m3V4/ow+Szxb9YzZNcIdlLesA51tL+qBlvySr2qLPJsY6xQidvgs3TtouE0TCLUFJbrEtmae0l7sYijtdpn2ZCNtqos8j0bZST769fRwFt+QOaugc1KpOncGNlWhvQ3sJ4mKCZF2aA1nQTjehqpWrXiDsCBgC/kxTNWJ4I4UetVepqKeH1qgmCpbqAhHxTPZwsSs3ocBeJWLfeJZAQvVbhjYFmJY3Ncz5BDQ9xtQiU7Vv8sPbIFgksah1zOlVGGrfg+hPBah3xsWA1jPV29B9mZggEt2pgkMJa88QWD641FHtcR6LO6b6wJ+Xq8G5ZZrDdrepqOgQ0kRW+SrToJ6nE/shZPhreIecORG4FFX2hR1jPkzrQkGhKZsjas1b+SAtZOVJWhNUGi3Jj2CfNmXA+yiD950zArlTCdboyRXVUwwEVi0oYnwRu43ljk8VzehETF7GdimHmLMAlrGPNzNbKtridxmxqrf2pR9CSFXSUx235d3sCw2U2B5yb7E9820z4xNAJYntu89a4dQFUhoU+k5CZO7OiN847WGOTy3IumwOOhGg9Unhk5LklP4afQc0HXxFDrP6Wr7lgAMA0Dn7gJY4iGYlCYgDwrLXiT3QT6QKCDVzg2XSsKjw2ApYVFwDSkNCTScKMxQGCReCIoKeD6JiDfCmR6++oPB5IVcIgDEfb1AuXqXdiu4eywaq2NWDCuZlOeXCIJXN8YYPFbQEvrOMmvgTyFeakXw3juxe8kukCKr0+igVuNAaLSIfH1t9/uWXgXwBvhQC9F3z/3Yp8G7Ml5AknKBZVA4iqmnPqeL0Ar+Hzt6SyPZgWSx6bB+wQaQcVLny6gFRxMHZNwrzGAWhU9cKk723QJ1Ky1EROqxYQHPqt8AlXcagygRKGGBNZa4SxZ3br4GkElKZzPLHx8iSuNAdTKw6AhgTUpnM+ukLsaGuJjm7DW2tAYoK4WhXdkd+vjasZ2LKBEPGQYIS6H5UrTLwq99hADB91BYx9bZFnrUxEDBzI9xKSqakO16VfXSHU64rBM7BuybZYKbfpppDwZL/YUxIIRC1k3NxcVI2WyTuQUPDNigEgLqsg6fDyqagNt8vkaoY7MN/HY95t+OZo6HfxqdyRTJJY9Ywxjr8++wvMmXPUZlUeHvRjQi8CSbwIdGlhx9UtxJK5VyDjIxZt6ZRsjlSVXiXMEGB2IBqk9vNIDpz5Nfd/GyzrYF3/gIzi0cBBOpVKJhNfkK9twuPZP/nonnR6sG7LRrlXE3kxVO2Vt6nlqpbbWPgbPAVR6wOrMHE1FJGGnHdtek6+M9Zgd+Ri8C9sIhSaImTJUESnlbTj0aOL7uJIQYN5i0MTuJjz8dWK0egzEFGU7NhNiuAVB3asLrA6jJh0W7Q40dnhZs7yI4Vt3YtBGUUM+nDUIeTd4VsSbdp6djNmo2VMAlT4wyPB3L2Ece8dnBjDwn+x52rQrqo0xw/JV30R+O9bp0Mi5KX99wITeA7Y4K9K093AwvmpGz49CpROsTuJKYUbyN/9JOJI9T5t2ZRvtwKZHgN72fwS0coeMC8eeZrBypSOa9B42F5F/zz3p+wSA0YtIjE9LXAWseCS8+PViIFJRm3RlO2OJr9RM3x3bcdfrBc23Zas9reg9I5wOIlGuNOWKdkqvXcJ6CzRoZvRan5b4QTb43FOHgjblymqj+ymA9Y4tuOt1gw97W3aabuOkMUuBpnwRm0mxscXSoJ1Rk/fMr1QqZm3b2yuqI3Vjfxakbuwj6P3OiI3ZT7IJGtrM2AiX5wh7ZSx7EVEtgV5EdG+UvZnB5u9ANB2Jmrzne/W6xbQ2W+qFeviEdZLq8AkLUHwnF1it9BHEgZY2M+ZPVywGsalQTPGTcl8rXT5538mIWD0CmnpCh7HjclpqppgWabg7KeQncznsMGH1tZVYiqaum7J12aJPUWwW1Za6t48CtM/ykXNvH+B5cDOoW30WmrpCE0ZPGWaq2C5j7BR5nRCgfZOP2Oms9nZ4OQteRs63uAMQH7S1FfPb1zYojFRtkYx7U0FdEHbq1QcA2gf54C7XTorjnealULTCCCDA7M8Rv030hQ7sWAGoVEawm8+QLj6OOc8u172HfVL50BxDkI8+GAY/+rxXGcH41c9Cg8ZGHca+RyW3YJHrDz+7vrr2zrw7mDnvLfbJ5P1cQ+TcoXd2mPMY/ch1l7rZa/Bn/PU6Q5hRK7tQQOKbDtQpH7jDzHGwOe4d9knk7SAi1+iNj3gZc90Pf8MYjILZL+Fv6G0Hxuu55WdGHFBl6ZtvvhRCJr03k2HMHJi57g32leXdoEuQDkSnTjuNcZj5L3/aYWTE5POgQnO7hr3YL8CSyaoi6BY//Lto6YJ84DBszWXjwua6V+wryZtBIiQhUa75wLluzDD/781gCihI6wlxRncIM14yDVDwBXxC+um/L5Fr+YibC5dhNtbYYK/YR8ubIcklURQiOXaa44xhu/xoZoyCANwR6vwN/Q3hJfV6hRF8FNLlh3cUQr1oLzaMDTMb5mHYYK+YK3kzdJCkFEl0iQkNE7uMmfGbf7vLzOe6IKx8DFChwV3D2AJrtZiMo+hF+u2/LkreCfYBD+NhZmOeCxv2CuIob0YSScrtklIrkQ8es7XZzH/5jc3Y/nJF9Alw1+C1jA4RZjSmUdZnVVEUVZSpN26eJB2D0wKCqIDEWNbQpnIMeuOD8zrLdbWWpmVCiSJJ0ZghkDEiIEhMdhIQQUS4N5YFC0gNehxDzcKJYKmieBSPIldKUKTkLXgLAQQQYsI0mNajIh2C3uidvM5yjKWRkayl3DJEqoCyOYPkSigQQRB0R0QSkM9ba2sQoslRzNhBrVBdiI96UEWV3xSoonnq/51WJEkQ8fZzs9Fc1xh2Yi/yMotGk2sWWVsqJYqCsrlDBEEEiZ/n+UKsEJ5/SICt1CBGm03GXn1cSWdXfVTROLromKoKzhLewlsLASEuIiD2jjVFEZaGXrzMOYTVxG4T9Eiut1QoKIDGahBCRBAKRGRHhAIRQc4yMWdiDBEtfSKGs8Wna9tqRZPxWmznRwsHFuj6NruKRzyG8crH+4637+LqZ37nFbAUkCSBtpiGNk0bBsOwFyMvo4YmaEJb99rurUpuKJoQj5Is0KP43PPl1uPjVjhbEd78wlVgQDHNv7kIpMD/WygoJH4owPPfsxdkBp2O4dN3kLnqK56u5m1U2mAMLI6Syig+iHJrzHmVj+dfP2IMItIhuom8cviD5m1qyFnCOSa4hjaXGAQBEWFZ1ppGB8fBMOzwbqRockxsxZpk9263qALdIjujTUrrdIHT2aA1TkcDNARlvnWAGXIyq4DxLNyCg2uYraG2hpglzjRvMwpFCgpJDwWQ30KMVkfm07hyjJ4M8s+efv8qKtJLmKCwflByTIcqL8mrce7vUIbk8KcDkr1eVn42IhOsseES8/pwjW2MqQgUvg9WTw5JrQOy0rzODlERubaMZPdTu5/Vbu4kKjJbZDapjmqcsbhGIVUlSIMuzGYHWAJVCRU9qxBZGdSQYI0LlngzicJRWMwGnOWWYCK9Ip3CcdLpd43XdCLntN9z2GdfXgABJO/lExYI8ixXuCMzzpEZZcb2ZZaVGdsHk8BMgvD/1MaYIq5zPzIv3GI5z5thSEqXa3ZvN6un3Y97eUq37w1n328+vtO8/Mr8UEBxjWvUtRCCViLVw2qeKajGqchyyKqszOiRZdFdwvxRuNEk3uu/OaQZmn3alrsftNdvq65dRUOJUAkQSlkSYcjDSDJMFleaLGvpRSGI451e/xndoT26fAtYHrP1TiAXNI6qgqoAhJrZ2C7bsFwXYfdiCS0WiC8U9XiN70ZuzXL7djIn5vl9x16WHXutNn+psfuZM5ScLAw7QiVSSmdkd9ypL+30JEukF4VQe0hHL3/mfzAdyKf/g1GAczV1+s7mDGWOfKdpN9dRhWrQ2Q1ahSD0nUAakcMY8sd8ha00+jjk6WH0gwm66PSnG3GkjgfbHSsXNI6qYowxzetp03CKLGTuIWioqHgBj3q1HttDV3BuuEBk1c5Ti/lrtdljs6PfMpwaaIFSqkIiXdHsQrEjGYlEqIO/nBBSOCoWdhXkfz/36uj0nd5c8hzlTrPewZATGhUlkrHfyiIHZMNI8dKAqdVPGSEQxoTwhJUYoUHQ2+H3WMK2nw/uHiaxeWdmbGYGO1wXWYhGS0RFRUVV1Z4bg0tDYyetH7b4yKLiVDAPEM6BJJQrxJg6BnqHnSFVi1b3EOqjUPvLQ+C4DrNgViAFi32f0zGdS7nTuOcClFNFHQnlEDVH7USkMMK9syGHSC9ZlYN+TBrbGMIT+hjEgPYCosWlCfooKyJzOFieBnI+poA7c9lsGFtmlySyxGpa1gIVFRXrDMGDMnNpamjzNQYUwjmQTkI5QUojlaRlpOjdl3ZDgu9NVLE6BI4thBT85SG8nA9EnKJsCB77NKcjzaW507xnoBbFVBF1VJFyOl/KHXHvz3Nr5JK0uSAJDeDLPm4YT5zuOTSc+WpsbeURLZp/kA2IjMst+vQDawnKv64bDdYntl1BMcZgCIlBjtXdfT+Z0KJl0UAUTOk1l7Lmual+WN0QKOprAJEZAG2QE0kremRs17kt7gPcPOH3JWsTJkg99Ufop0vt2rbHU0hHKRzz8myI0hBBFOMIjR/6+yxnWHr/nZa9YUgiYz0CKrkUD+R+VOqBPPdQP1yabzfipRAvtQ4+09pffsbaJ4w+0XjIEeJqHFvPtHxQUMMEcouq3xfIg6SJjNWuT0y7Qq9gV9s8O2pjOX/eapnbaDVHlaD0NZ68afWj4e/T6qK4RhGSPqyeEjKoiYy1avYPKqWqx+D+XA9L3s99T9qHS4mDAAEjXDBv265zzXnkIxsQXn6UAkiIFEUJjmbmQHB4VXIG0hzNnRd9QWTQhlNHbWih4iIUXYlB/3zv7bh8B78S8GXgy0bwanAF3/yo1sc3+YyNwGocs41t60nQJwFPJP/ZxDAQNBxOlPmwb7M2sla7PJ39bcFgPMGYmTDS9b5X2z01TSwLBF7beH293Y+bH9ZFU44rBhTXGDysksg1FXSNUCpZyeBbj6k9JPGYRquFau/HCIwfacCH+OUjGnS2eekJGQGD4NcVaM+96rgVOXNp7zzvGygJfhtaj9aa4YKKuypTvnEJWsCXjV3B2Q3ObtbBBeuwPnH2QbkPlT+oTIqMivEJNQSlSJ+sJ0wEgirJhlg/tHDYn7/lGYAxxgZhVvehWlqOMa0e1pDm80cjeVfw1b5nRkT5xMMe/7D6YY+/xsM+b9rYAIOIJgqq5HgbzhONPbnx+3LhzBmC4f4UoZpxuz3v76fbjhu6bN8MBUSPl89AVgv9X68uZqjfrhygxXD6z+PS7ywPZPse4fcIUSSyJZGOo2AENrXyUdMP1PrEdqPMOa5yLAMlFEe8voZZtvh5OZvKUxdqPjg3RXuJV++9qqpXvDdn92S53bt3PwEKAqmmXr0Pzo3HCkdUGlF5NARpLOT1qBwRn09atPvIn5Z9QkQtaNcLQhCEg70Q+FB/vbfPPqIhxykdO1VYq/AVYF1FnClpR+rxCFow0NpxOT4k/LLFh0V6uZ9fwDpZp0RiLWuRPuv0vZU+Zs7XIGMs9NrYRcu4eTaTVrmYgO2lqWvMqU99cpqurvfuVrt337Sggnjx4r1P08gbwlO3sbyGUUJVkRPCUwmwpJJQ6iN5sMizrT7A1OgR/VPw+3ubPF7YBc/y0Yf0X0iPx1gE8SsFmP96tTBDPm+sUtCCnI5L303+ut1HFViRX4BEWicx6ceYbSE/bft9lT+13cIVyW3b5cW3W7QsyU2CqhJTpHYn9V5jqjrLubWmdtfnXwnuScAXKniv3hy7TJZLBbUaJWEEWFOxZkgxKkXxL+5M8YKDhyvRpEZSpN5C7AcXCETgjBHv4ZOPMCL7IqsKSxXe73mq4EzZnEs1ajySQdhje8nci825IjpzfTxVXRxHxJSoTqToVFfdB/XfV61KgIjaLi9jtA4cEyaNIzJuDG/3UvCqimqSkUFL9flLuaoWihaqqdVmM0hCw+fyV0Illewj3BBMBYRQoazoZ8w/Y3Eq0w3Tzdg102GrL62/zz4EHGj9ffe7s+2YJUQ8FkFU4Z9L76mAGeJ5qlpJZNBCvp/5daf3ZWVnSSSnYnLE9NKLXvSQQVL4+wtW7LGB+4vi0jqstox/pqKGXP5VJJe/moHrepKq9+p9ipDU7nW7q7V7EC+IF2+9IUwKqXKRMqWQGNYri4Ups/inkkCZOwAr9zC/1MU9WdWiJm6mkZuJXG9FsDJvyBY2J+xc27Z54psWOc4RZ9haej+ao4+kDmBxxeSol279Nmx8iRGMxb0c94rqVJdIHOMuqpGoMsWec/9fDWq7F2V7bed0OQ5tVmvB+CtC9ddx40xW27z3mvpIKqla+rzPlp57qKAIQVIYzY9LhVBBCimKtSK1a8oEpKAQ9YjGszZuj0OKRo+oEA52c/YjM8IKKNASysgawzbXGZveFBeRcz+55FaQhFbVWY9cMzdnJxDnSi1XJLJVw30ywuxxC7u+32IUSPMn5y2aEVhEy8BikYcXGda5xkWkghJj7EHCquqZvE5N1X07J4AorSfVj2EcqUQqlCCRjiIaQRI5AJ8nddX0rMeNO9MTN1vJoJgP9oOMZf8lFAOCvmn2qjgzyw4ii4g4d5mdPNP6V0VkCY2d9RjXLm569Pexh73v8iVc0WPeDwqJpDrRlWmdRIpsFLLp+xnfmR1SJVRJRrfaHq9IsiORTYz/VQQYF1BVNCUiCodYDShC59XX1noccpCEAq04KKZkoGmS47cA4hqZRZdN9DNYSlayipuBQRAcvlTz/vf3A0LrHO4LpIhUw6rqPrhJM4FDOneJPQ1JjXVf/kO/su1HVZCz5+4K5n2RJ6qLQUwxqM7dxa7VmZ36vMsfXvTaj5Wpxz5vJZl3bo6LiFrkhUNSh7bUjWgJdSuoagmEMGQgWkNSBckhF4P8Za4vhk17dtuPqDbBwRSmoOWa6bBNOOzZs86AQ6YO40XrnumNXUU8wAuUCl3pU16y+VjlDwQDAQO3CgrV5SAGV3GKbKRFmPH5Xf2giEFRK2ml6MrKnxetJ/YW3MvhkJzoFje3ZfWr0F0Xr6pZFptgQoqiSJx0fcohuRiE1s9u82ElF+HIXOZiXnGkcaC2YgUYiA6WGAPk+qJ1z/CaPZD9e4G5AVKSYxxPT2g/Z9ZV4BSGQt7mjmyMRGEje6OQkxg+YfZ+ebwHVgN5YWiI6HkOrnsjOcDl0n3HnVSP+3HfXeW92uaVUWZgKtxkoSBDIqDdHMwHw35U+2kz9Mg0cwERdEbC9TYBvwDhugyRGEmqA5nwYfsP9xgemCb6g7+L0710b3isXIE5sUBNvejlVE+RtxjFOsX7FF1RQ2ta1HJTFk5vTu/lOON4OV2zRN3bPVQ56tgcBZSZEQwyCFmsfytF4ZNZRu7jeMm1TXPxziYpUvw9aps9FYFcO4E2EM6Zdi8hg341GXeGHbdjvOnmdpK4qmA4rkAhqU4NhUR2u0YyYzbWGz8HlYGhMubg4KYkLJniGNIYh6/x+0clmGulnjR5GW1BZFDi9QSTwKKCitYI5KiMXGK84uaOE4fziMPYghuOCMEB61YiKhULRpJCHUZC2JN1zizCIQQjcwTpMLgnun+yt6cMnmi4jytjCwIgUd0dknE3SJTRqc5ORoohJjGIIZyo3UxFRBZ6wOtl7hz5i1zdMGLI8/fO2vfvSN13N5X7ftyz+7m7u6uxNbrbvbPtM0rgACbgVEMBQbYBHOoweEz/sQZnUoO5ZsIULNywXA9mQZkO4AXwbKD1ROvJCOQ6UPFdsmanMxACCEqQGeOcp2mKcIf22Z5f7yGfg3KlsN60VzolKdNVmF5FYWPvFFlIhBFrova4IgQQQESpR6kNaYjg/GO++29854mIRNctyPE7d2h0jSErY96r0TDd5j7X4XbCV9zXQp85MB1YsKHFYWCD2FOp9ZoMCqQxkGaE+Qf6gQB4/wGzzZT2A4Z3F2OH44/d6/d4eqiUPd9GfhN7BYUzYoqJIU/sPe+SdVongSRV+dYK28tDiEidYCGQQ4jgHOcXm9/03aVzV+HWndpaKvkzllaZZWWkmN6rsA/sCWSyY4FbXyqeMvFgSUVWwnw9b9Es5HrshAPrJlsGotcKkBNhlu9TzjXrQksgBO9v+8BHpgj5MIZAfZ6kQUMdRPLpmjbPRccUgcVLwYin6AvKWvSyY8OmokixYgYZNkxD4gii5lNLsiIIoU7D0jSSPY5SmYGL2rVYpUpfbvBevSe6Xm/ulG5WU4WyhqGVkhBCiLkmObvYy1u7RNdYy5lUnHHGzYh7Oir0VmQlHxCpHlNKxZJwsoztPbdTjseshckZml27n+F9efSLUqHHDxlOjdKpbrtsSRJwNvgFwLP7vkgHC6BIomwn9hLJSqE6uwUzmXtYlCZEdZ0EWmYJBGMmucgOD/w06Ka4PffuDQgatcsmGY1ySEMepMHMBslNIHWdnEtiBlKe1OaMZmUp6Q3NDcLJOFNjX1y0q6U4dRpTqkP44hOTcq4N5Ohihv4CzbeXh5CHV5kyM2NwXusknXDTxSYhoy/TRP9/rMwA6wXAL8reqVArFcrGygzVKSpSJEyHkKQOc8mUs/nAOHri52unH5E1SRnVh+pV5CZ9SakHouv1MBmva8p4jF3f/4H6Vi6TPNK9YImSpiP5PhaaqWlWaonKSIXp69yhk7MKUrPFihJEUkpN2JpG5y0jZyAWyAsCP59dFoJFUYoGgJLkyuA1Xp+Y6y7vDLD4cmPv9W3iEUR3TRRr2bArkQJJWpRFQYO+bUQshD5WkWSiXJbBSszymHIrbMyHwzcGbti2azBmWp6bCarRdtuEYRleMzNERt5aL7LJl5B7QZYwjUkycOaM4ix6RBv9I+0z7ZYpmfpKpDqTag/Xn7PDtl/VAiD5z+eWxQh6D68yNFrE4tItec16rXbsAAJ2+cdxvh18PcqeooJaVZA7QkajFkmUDZTvBeg6iGR/rMtkeYyZmp8nL6nKQJgwKu38Sli2m3saFJHudif0w/3cFxlRq/fYl1By7x7zTAS9IAPaCDknjuiRWhR6wY1aqKBOpRb0VuOcAWOqU0jNUTmq7c5MAguAYYFq1//dZ7NBsChKMcMAuitnmQUlT9OJ2V8bKZ9APBKPvgg8m94othLFWgTrXpRe2LDLAHcZwOV4SB2ScKKbpZ+H2C/fIj+zzS9o15hlWUYEvZkxFqmuS4wRrnkJ4fRIotM96AUZNOFn4aQWeqKlV4qsI2k8an4RLWe3TLE0p06HCsTTMIvsclxbdZoWKDO02TCKwYIQI/5VjREi7jWeysC6JrvtC8iNL+8hKKhXAJDAK6mroOzWIpChgiRNUUTaQa+NYHBwDx2YRI7XUg6ppov9fknf7pRj42dP3PSUmSqj0/NGNPQpPeeM1Thd9Huguye9IKPFYEsnWpw5U+GMQkuFL/J1xDb3JBpnUSKNP0/qU0h+hW2xEKDpWbv2nAn9/8YMzTkvPHfgCXj7gDiuPb/Y3XrvJUpka++xFzHEpDq7ig6lgTuOpC4TPeeuy5FM/Pn0ch/+rCxLS5ddnsoM2f2EIVG7PLYFD4dkXYyPdYtoeFRKHjFyd096QfaMczI1qZF0Tb2VTN0t21JxOsVSgzqTfr4JIZQprjjFwgLKC8uZwFxykETEoQGTvb3YwH/HXDsVksFMFDYqJAo2Oy6cEZeFQP3MuHNLIYEoqVK9UJmTjLu7cier1NN5WC/JiAQJSeX9OmG8ijOOLAgLgoVgIVhCONuywxqIJg8ZQh3+21yVVZLmUi+Fy9XL0kNvz5EBMmdOLoY48PFVwg3+Qn6K/l78FIniVVMh2bF3hcS+iySGCxJ7d5fEkdKu3TKNEKSE6Em8cep/Bt1JlHhMwK2sEDGkf61KSUopweZYJ3XqSNA4E94pCRaEBWFBxEJj4mtYGu0FoIX/qZECqSDIkFCV5ohz2VwGz9oRDmhJvUPdOsCAIjKfOzfnHNwNr3KioljdpkSxDonLgkjqei+t0pQBUmLXoMqqrityY6xB1Ct1d8tRW4NERBCJSgwIwLtQS7X+6zjBGc3CXOatVuaaN7BIEeNnUdFND6QQ6p2OYYeRSucsg7nESTSGSM0RwGx3d83y/cWpeYXiMJyoshZBokRFNi4akUTa8eq110Zpm64wKJGA5HXP7BV3uu/uLBraKIrqrwhCIJF0RSfVcpym8dTzX5B6C+tcgoViXs3ZcAlorjYsJXrgQS0CKcyUGQYSqJbCOXJNkEitYgD7cubzE4YUg7thIH8kYuo7OyO8Gtjpu2TEsz0uStv0OxG9KkhlMnYNyVCaRS6AWIgE3AGdVMubixtfR0KFWgih3jHXW3A5wIJIQQRWSQ3AylDPAuHK7gt4ViaIuWwtgduMpjfvsS4hD3YA1qxZKYBwUME+119cMi9XyFvMKIGNQhZRIkmCERfu0sVw96w7DO3Cfd3s9ARUAj8sUfO6dZAQlznhTqrlTdzs59rnbbG4CEONvFOELAgLisxbnPG1K8OpSAMLiEDFF3adAwRkWecsgfNoIfesRQU4Dml3930KmncXh4FCma5Ca++LKvSdvawkxh0X9uS5179laJc91wSAQFAHZlBtZrCTMWYQAbSXAROdVMub+I17GGg0qzlYkGy3mAXN0ZYjFfozhbSb47cggCRkzaR38vtHToLOPkUgAFesmRHm3aB49cSk7wS1mjEt1rIXwTpIZM8dn3fM0C5MgE03MMmOyWJrWL2zAALgjjGmv5NqeZOnHh8qNZKVYs4Gs6h3KAPzhmVDWNGC5SSow/HlXQUB0015jnjy+yRyZ5AmAbOe4cha5QMVW7UK6cszQIEXgJ4NaRhccMaFwDEmS2Nn7xSF2amp8KRDt06SkkZd5xK5drpAbmSBh9yaobkq4IDjsuQ0z5kPc0dkDcnIcbY//fl6igem6WiBgea7aDRZCGrECXgBPJtdfiqQoKQMQe2BUI2v4NuQtL9F/cqsIbpan/wsuu77QfQim+PiH2ZyjHuGJGC6MZwYiVB9xy4muShXQWvSJ2Xx1OnfncpNCkj0eaUu/R/qnRzYe48hayICOMcxlZPKGn+ZNWRds1ZOQNss41QWi2CD4de+K4MzYi7mdVaI6O8CJVB4BDyRZgI3JinKAtKwilwLsRyNwAyDsB534XjcV7AMpjeUzzNIUs/ZiaFlx6YKha1EY17BJFqrf/mcLSczNwIQGsUhOc0Hy6jD07K1myXgOGdZ3llrSV2MpFJIrWvRCcie5LZpGgeLPfA1OaMHsSDGrD52gASKCME4DlW+Ms03Qd9Lk1xEQ0sg0oCEmdrkHOJxWoyahaJnUCUAL4BXkZxxWZQoYjODGUrIYE6FXswgnji42VeS2FKQ9FZWriVOaUD5kc0eWzQr5iBSkGVxWmo5TElRHKis7L0DNkSdqlcLDB8ItShRGcjKXObBgnkPJPwbfMffK5EJiBQKZJYwI1TDjL5HJkixBGeYfT+UawWoJz0Pbx1fRKqZyL8nog4owMe3Mk7tEkUFazViEpOVuvH12e0LiHyBlGqdEdNfllQiERbPMo9hqTipczhH1bxkmZY5WqGyrvM6WcpO7cRpXdYnCswNs6NCY5EakZmV4x4mEqmR64BSYPw3gpv1gGzBDL8nvwV+5+jjaXT2g0geIbe+4PEsb56JMSG9RAEH3T6IIRGGCxXspXAVJlEURaJQHJJPO8xFjmFjEy9oLaHY1XUkN54bimD2kbL9KmRW0yiCOcXhcM47y7qwrJFS9pNa97ViD6LbTm97UpYyGYgdviRFVoQTwmJWgJF7miggYSQkp377lztehWbDHBLAIzO8nPzes8AUC+gjLw/JcXJ0Oiox8J2JXEO3HiQG9BSJioofnZg+1+WzPfNywfFPi7MGaZJyzTVVATkd+0r7wpe1xoJINKWWpRsvs6zvLKaqKVEXyLpaJ5MpwQAPnVijO6VDmezQ+HaZa7vjzRgSSHId8JqLVs3yeYAYihgBiPUcc5bgwh4WyAUBhAQpxSIUc4y5Cgm9FiM6FNwCQpiExGEIgRzY2dgJZqHYWmGKSYwnHp+6R5IpgxebpDkhmXbXOyqRdB/3kPRLm98NG7Lv4m424Czz/s9+Dg533Fs/d7hf96nJOqms++lzR6XWoD80/w5g60WdlIGP/R1BhyJkIswBTNtxAPwn/LnmAr8gUaD2cHm3fW4MMdB7UBPdXy2BRf/NcISERJLhiSIPUXIUa8ogA6mVFsI6SAJRBw7y0YhhxZn7SPGCSCu2Ru0Icmr9+ud3G3MxNmxsZxkUEzXBSGoYfcUSJbvuZ/k8+9MwUqouUIj3nHGZZb76tPYP7ABjpsgc3rlEVjeiJS1FdYS5zBm4g/DuNJcQHJCNYZWiM9g5YTXX/CVNMBwWbgSwr73UltSO2tCCRBqrxrmUH1/b9sVu6uYOwD/6pT/44gtclY5SqgmKEHIMSH2PHJ8EGVC7HJoS0kECkCQH4QhI2GyBcNlI2EswwygUT70886RwHgIvIpN0QA5k40gIldGjHPaHu7dzjGKEDWup3HiBqcVFvvHerwpGUFIHae2IpI4oOSGMuQP/d0DgWA1CLkKFGiFYFNkCQgZB2OnQjjOEqQ0ZyuC3SNItim6+fvbzoH6p+KWkG3scyAf2gXQAC2RXaD8zLCRG5DAmaI8VvXmPopMBWBU59EJ4XTkgqyTEIMjBBRkZiJTJhrVEEVNNgp9+vk+NJMktbSQZHlvgNjeSdPTHyzjYQvfNPCM45GFzzV1IjElsMsL5yKef+pKonvVQqjJoMmiyIRRuQzupRZFEYI4zmoRGzTVYmEOxAQOiB4XXbju0n4cUIIMMBNJ44aClOw5cHvwdsAfmS0UvJb4UeE8HwIFwYBzQQyBOR03tT1QiQd9R9a33eMwgw2pID1EM3UcQG4pn0mEU+N1G4jhsTpy1dtaiKMSBeuLpsL9qjDASm8xIkMNaiJZIpQa/bPkz79a2/ZxO1+j8/z7sD+ebn0Gr/8Dngxhcg8Y1aFqL5lph6dx7X0DRKjRV0imJHkTNYzKSt22VMR0NWEaPOW4wL8hgV/ALI0HRCI5/yvYeqNR4SKECV5CQiW6UdXW+OEAPtAPrpfiXAm7ogDpQDsgHNJtXqJ+JyvWH7/RaQ4bnQUp0rRZCT9AKmgg+DiguEJw1IokjIDOSoKJEEa3nvn/9VUUYkuSMFyKFhYvWFgFoADj4+z28r94YFFZS+Jmf8TPwM75D8B8sQ98y9O/A7k7s9kR3Xyfa31yAgAQqyv4iIK0ccaKJWQ2kUbApYm0iMCcVCh3BQmrEiUJFQ0syh3/ZyVUgSaRAbwbdi4fs3qHv+PwkB9BnB/pL4Xfz4YA7IFw3U3OrqQNR3v79TXsUE546Wg+Z4KlxX7h5CM9nOBZJtlKQbElwieQYE0qYcZz8+jWFoKYFIze2YI3aEbaBlsDS/OO3DXtdQqoFxvQzP/Mz/Izzf4DgV/A30G7Piu2k8WN1Wmsl6H0claYTBuZQOI7ZhGK9iGkaaFILShozlbGQgZzBEqxmBXY5ZlWFYkEQISmnijbQbdfPiG84Xz2rPv/spfiXAm/lADtgDkCkNJvNtE9t1VgigqboRSw+jwg5WRBzCuKgQZ8Qfobs5osYUosNW7KWoOI4dvnja9+zbhOMYRGbFMgo3QBB2eDeW/1n3zkF6eR+xs/8zFv/wUC73W4PjHe8G9Gp5qTe8Z+/+7moQSuOJBROYx0aHPvNtUxlsqyk0WyIuWo7l9Doxx9Usl8BfihYMsJydS4etnj+G97Qs2ufHvAvhdzIAXGAo5AEpGu07w1/Gb6rPLxDT0qk5wVTCqKm50QBh6N30yZ8r9LgCCeGRUqicYgg2DmO1xu/1/6uYAqUWTDkIMQLSTJN62FXfP23bmqtwVPP5tcf3Qjqk8Ph3f+gLfh5pG34/0+AU5HKf/q/oMKxFGmBzIKSgQCmdLdhXEThOFYyZt6woKnAnneg4k+eJ/NEFVCo6QoMLBAO33B42LVq/3kp7DY+/Tyx0MTvxnp+d7/9FzwdyqpHqEo7KJEigIVRToAtAr5wsS9wvh45R7yjsFMhIwkqHGg4Jjf+D/4VClsKlBmoqTDhWOMJj9qa0PjvT1l/MpwHHebcKzOEr7zXMs9S+YnE6+NQgFjCmFrBSjRaGpUKShpBxoIpNkny2w4lolVoIzquSi3uG/KWv5/09Q+GBS6HJTDif44AHx4fPjwarNjjNwb7UuDu4fMPTK7bnvZ7y/nlZTh7sFZWZTVobYFSBgIMOoCOVv1Q3L4QkKEnTl2FIkpIG6JsB3JI9XIbsqEWGgfAAZ4MAC3eeHn73e0Pf+MfyQ6aIU3rYrZmCJMoppFUTWTEkz9ErlAhYwZNI7ylDhBXK80VTdZNpWix6Af/h36/phFNkGEsEG3423D+ctj3OGPOjcdvDfzNgLewzxssQiPSiqax42vjpS0rm0Lgcp8cwAQK9PoGTCDMSwqhduxsLOrHL5cNYZ46Ig7RbYKaBKwnHBUrouvH2+GJkTVVC4dpD3y5zNqF2Vwu4YrqcaZYJ5p4EYdEFdRIyaC2OZJNUQP3WEaiXaAuwxEdhZCmOKJfvhyp/4QaSYLCMBUZetDZ4/c4HpcfxDTI4zcGeSngDj44HwBqDVqSsL3rZmFF74GVvns/3oqOUkA0+kwgJpwAEYAv3vuiirIjnEN36XYCNS1IG8EsAsXEhAm8+Ceiuvnk+MjU7NqGRSFlYa3q/87BWhcz5wHO3ab9XKIdj5H3cZZYhlmoR+UKkmiERtGhaLNhpFG4wT13prOpEm007Wv1ne4/7v1HLjIGRdd63KvP+5483WVl9vAHRwfAtsc2s0ZkHh/u4IGiITlPQsKOvpv5JS0Lyhq2trVfKmFyuYT1bTKz4AYLCzABYQhwSREBgb0E7BnaFZY1xSJTEEkwg6k5s86Wed8Tv/xdPju+euN2V8fW+R2VcFkWdoT/UhajxcLYGjHn4HBZ9bZdtXVCtXjzoYNLFYyu1HTATAJqyZ8YDRUKTZnNKI6GPr+XSgolg8KRwj2PpNDMpQO9JIk5uofceHv4g4/7bLze9+h/xsnJjJ2zGcYXj8fDxLy6O2hyHSwtAXDOuQ0th4eHh9vDLRyyZQuwpf/9bEMfnHxYPNjAF2GzET68wrdZ2Iu97pDcNGFZDTZbmOAcnIPbduGQD304+NDGD/0sfdB+G9624YtsNpsvMuNmb8bDeMbewZ+2YJs9HpplkfNLAbegK1qtkQQAzrm+bU/vSeNBe8Nmw2azwWOzvNpczuZ6zuG1bNl+6EPjH/6cwqb/i2w37LltD+eJjHIHXe2JpsWCqztweLg93B5yyLazpbvtbLMfNB94gM1ms2Hj6ri0rHXx+mtrOThX73DLdrv9kA/50OiHg5/dD4Zv8zY9X9yw2bLd7GUGc8ro7fPYdrpuY+w5adBaG2OYGwwhYjIaolmntQtzWhpDI5ONYZgbDJHmsrVmzieZ8zY2N7ixXazC4PG0tAzZjLnc25brCMu5aaylzXX2Ss1aNM15bcZc723LZbROy2BVF7XIYPabz/8OynRx3uY6aNHWNgZzi51ElstpYc2UtcJmbNLCmi7MxpznFoOIycSjHuU8FXO9ucXm1fJqWI3WZGbD3GYXzZuuNU2YtDlvE6ZpLW84u5i7DGpWjxhtnSEiZHreg2cbBQ0RzNNaMGN3E7meaHNuxJowHhjNucb0BnYnEqFHI7MUnVLOw9Ndfnx6Nech6JFcvnbe25fLN1ltVjTn0aMGm5FzY0ttvdl5b18uo7VoD0F1oVJhz6f7fH40iuYcIrNWt7aYtrLm1eYNL9oFWraamLu6nHma5nlRhUgfn+70efBmzjHkOvRYbF6dG+ziXENTY1kG7e9okGXRpsHm9bnBLs4NYbCeFZLLj+9ys33yvJhzWieNMLaLucUu0rBgZJrLhYWZrRNNRrCY2cXcYqdEecrlsubi8vkuN/zxkycRtLAI1oxhbjJE1sJiy+vLmvMY6+K8YmGNMcxNRkiqTMMaQ/Hx3dNNvzt4vsuINHk1M+Z6b1+uI4vpkQwjQ9NgDBkhs+fEGHO9ty/XkUrOi0cYfHLweudfGg==';
	    
		expect(jsPDF.API.getImageFileTypeByImageData(jsPDF.API.convertStringToImageData(webp))).toEqual("WEBP");
	});
	
	it('jpeg dataUrl', () => {
		let jpgImage = 'data:image/jpeg;base64,/9j/4AAQSkZJRgABAQEAYABgAAD/2wBDAAIBAQIBAQICAgICAgICAwUDAwMDAwYEBAMFBwYHBwcGBwcICQsJCAgKCAcHCg0KCgsMDAwMBwkODw0MDgsMDAz/2wBDAQICAgMDAwYDAwYMCAcIDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAz/wAARCAABAAEDASIAAhEBAxEB/8QAHwAAAQUBAQEBAQEAAAAAAAAAAAECAwQFBgcICQoL/8QAtRAAAgEDAwIEAwUFBAQAAAF9AQIDAAQRBRIhMUEGE1FhByJxFDKBkaEII0KxwRVS0fAkM2JyggkKFhcYGRolJicoKSo0NTY3ODk6Q0RFRkdISUpTVFVWV1hZWmNkZWZnaGlqc3R1dnd4eXqDhIWGh4iJipKTlJWWl5iZmqKjpKWmp6ipqrKztLW2t7i5usLDxMXGx8jJytLT1NXW19jZ2uHi4+Tl5ufo6erx8vP09fb3+Pn6/8QAHwEAAwEBAQEBAQEBAQAAAAAAAAECAwQFBgcICQoL/8QAtREAAgECBAQDBAcFBAQAAQJ3AAECAxEEBSExBhJBUQdhcRMiMoEIFEKRobHBCSMzUvAVYnLRChYkNOEl8RcYGRomJygpKjU2Nzg5OkNERUZHSElKU1RVVldYWVpjZGVmZ2hpanN0dXZ3eHl6goOEhYaHiImKkpOUlZaXmJmaoqOkpaanqKmqsrO0tba3uLm6wsPExcbHyMnK0tPU1dbX2Nna4uPk5ebn6Onq8vP09fb3+Pn6/9oADAMBAAIRAxEAPwD+f+iiigD/2Q==';
		expect(jsPDF.API.getImageFileTypeByImageData(jsPDF.API.convertStringToImageData(jpgImage))).toEqual("JPEG");
	});

	it('jpeg base64', () => {
		let jpgImage = '/9j/4AAQSkZJRgABAQEAYABgAAD/2wBDAAIBAQIBAQICAgICAgICAwUDAwMDAwYEBAMFBwYHBwcGBwcICQsJCAgKCAcHCg0KCgsMDAwMBwkODw0MDgsMDAz/2wBDAQICAgMDAwYDAwYMCAcIDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAz/wAARCAABAAEDASIAAhEBAxEB/8QAHwAAAQUBAQEBAQEAAAAAAAAAAAECAwQFBgcICQoL/8QAtRAAAgEDAwIEAwUFBAQAAAF9AQIDAAQRBRIhMUEGE1FhByJxFDKBkaEII0KxwRVS0fAkM2JyggkKFhcYGRolJicoKSo0NTY3ODk6Q0RFRkdISUpTVFVWV1hZWmNkZWZnaGlqc3R1dnd4eXqDhIWGh4iJipKTlJWWl5iZmqKjpKWmp6ipqrKztLW2t7i5usLDxMXGx8jJytLT1NXW19jZ2uHi4+Tl5ufo6erx8vP09fb3+Pn6/8QAHwEAAwEBAQEBAQEBAQAAAAAAAAECAwQFBgcICQoL/8QAtREAAgECBAQDBAcFBAQAAQJ3AAECAxEEBSExBhJBUQdhcRMiMoEIFEKRobHBCSMzUvAVYnLRChYkNOEl8RcYGRomJygpKjU2Nzg5OkNERUZHSElKU1RVVldYWVpjZGVmZ2hpanN0dXZ3eHl6goOEhYaHiImKkpOUlZaXmJmaoqOkpaanqKmqsrO0tba3uLm6wsPExcbHyMnK0tPU1dbX2Nna4uPk5ebn6Onq8vP09fb3+Pn6/9oADAMBAAIRAxEAPwD+f+iiigD/2Q==';
		expect(jsPDF.API.getImageFileTypeByImageData(jsPDF.API.convertStringToImageData(jpgImage))).toEqual("JPEG");
	}); 

	it('png dataUrl', () => {
		let pngImage = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAIAAACQd1PeAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAMSURBVBhXY/j//z8ABf4C/qc1gYQAAAAASUVORK5CYII=';
		expect(jsPDF.API.getImageFileTypeByImageData(jsPDF.API.convertStringToImageData(pngImage))).toEqual("PNG");
	});

	it('png base64', () => {
		let pngImage = 'iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAIAAACQd1PeAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAMSURBVBhXY/j//z8ABf4C/qc1gYQAAAAASUVORK5CYII=';
		expect(jsPDF.API.getImageFileTypeByImageData(jsPDF.API.convertStringToImageData(pngImage))).toEqual("PNG");
	});

	it('gif89a dataUrl', () => {
		let gifImage = 'data:image/gif;base64,R0lGODlhAQABAHAAACH5BAEAAPwALAAAAAABAAEAhwAAAAAAMwAAZgAAmQAAzAAA/wArAAArMwArZgArmQArzAAr/wBVAABVMwBVZgBVmQBVzABV/wCAAACAMwCAZgCAmQCAzACA/wCqAACqMwCqZgCqmQCqzACq/wDVAADVMwDVZgDVmQDVzADV/wD/AAD/MwD/ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMrADMrMzMrZjMrmTMrzDMr/zNVADNVMzNVZjNVmTNVzDNV/zOAADOAMzOAZjOAmTOAzDOA/zOqADOqMzOqZjOqmTOqzDOq/zPVADPVMzPVZjPVmTPVzDPV/zP/ADP/MzP/ZjP/mTP/zDP//2YAAGYAM2YAZmYAmWYAzGYA/2YrAGYrM2YrZmYrmWYrzGYr/2ZVAGZVM2ZVZmZVmWZVzGZV/2aAAGaAM2aAZmaAmWaAzGaA/2aqAGaqM2aqZmaqmWaqzGaq/2bVAGbVM2bVZmbVmWbVzGbV/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkAM5kAZpkAmZkAzJkA/5krAJkrM5krZpkrmZkrzJkr/5lVAJlVM5lVZplVmZlVzJlV/5mAAJmAM5mAZpmAmZmAzJmA/5mqAJmqM5mqZpmqmZmqzJmq/5nVAJnVM5nVZpnVmZnVzJnV/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswAmcwAzMwA/8wrAMwrM8wrZswrmcwrzMwr/8xVAMxVM8xVZsxVmcxVzMxV/8yAAMyAM8yAZsyAmcyAzMyA/8yqAMyqM8yqZsyqmcyqzMyq/8zVAMzVM8zVZszVmczVzMzV/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A//8rAP8rM/8rZv8rmf8rzP8r//9VAP9VM/9VZv9Vmf9VzP9V//+AAP+AM/+AZv+Amf+AzP+A//+qAP+qM/+qZv+qmf+qzP+q///VAP/VM//VZv/Vmf/VzP/V////AP//M///Zv//mf//zP///wAAAAAAAAAAAAAAAAgEAPcFBAA7';
		expect(jsPDF.API.getImageFileTypeByImageData(jsPDF.API.convertStringToImageData(gifImage))).toEqual("GIF89a");
	});

	it('gif89a base64', () => {
		let gifImage = 'R0lGODlhAQABAHAAACH5BAEAAPwALAAAAAABAAEAhwAAAAAAMwAAZgAAmQAAzAAA/wArAAArMwArZgArmQArzAAr/wBVAABVMwBVZgBVmQBVzABV/wCAAACAMwCAZgCAmQCAzACA/wCqAACqMwCqZgCqmQCqzACq/wDVAADVMwDVZgDVmQDVzADV/wD/AAD/MwD/ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMrADMrMzMrZjMrmTMrzDMr/zNVADNVMzNVZjNVmTNVzDNV/zOAADOAMzOAZjOAmTOAzDOA/zOqADOqMzOqZjOqmTOqzDOq/zPVADPVMzPVZjPVmTPVzDPV/zP/ADP/MzP/ZjP/mTP/zDP//2YAAGYAM2YAZmYAmWYAzGYA/2YrAGYrM2YrZmYrmWYrzGYr/2ZVAGZVM2ZVZmZVmWZVzGZV/2aAAGaAM2aAZmaAmWaAzGaA/2aqAGaqM2aqZmaqmWaqzGaq/2bVAGbVM2bVZmbVmWbVzGbV/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkAM5kAZpkAmZkAzJkA/5krAJkrM5krZpkrmZkrzJkr/5lVAJlVM5lVZplVmZlVzJlV/5mAAJmAM5mAZpmAmZmAzJmA/5mqAJmqM5mqZpmqmZmqzJmq/5nVAJnVM5nVZpnVmZnVzJnV/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswAmcwAzMwA/8wrAMwrM8wrZswrmcwrzMwr/8xVAMxVM8xVZsxVmcxVzMxV/8yAAMyAM8yAZsyAmcyAzMyA/8yqAMyqM8yqZsyqmcyqzMyq/8zVAMzVM8zVZszVmczVzMzV/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A//8rAP8rM/8rZv8rmf8rzP8r//9VAP9VM/9VZv9Vmf9VzP9V//+AAP+AM/+AZv+Amf+AzP+A//+qAP+qM/+qZv+qmf+qzP+q///VAP/VM//VZv/Vmf/VzP/V////AP//M///Zv//mf//zP///wAAAAAAAAAAAAAAAAgEAPcFBAA7';
		expect(jsPDF.API.getImageFileTypeByImageData(jsPDF.API.convertStringToImageData(gifImage))).toEqual("GIF89a");
	});

	it('bmp dataUrl', () => {
		let bmpImage = 'data:image/bmp;base64,Qk06AAAAAAAAADYAAAAoAAAAAQAAAAEAAAABABgAAAAAAAQAAADEDgAAxA4AAAAAAAAAAAAA////AA==';
		expect(jsPDF.API.getImageFileTypeByImageData(jsPDF.API.convertStringToImageData(bmpImage))).toEqual("BMP");
	});

	it('bmp base64', () => {
		let bmpImage = 'Qk06AAAAAAAAADYAAAAoAAAAAQAAAAEAAAABABgAAAAAAAQAAADEDgAAxA4AAAAAAAAAAAAA////AA==';
		expect(jsPDF.API.getImageFileTypeByImageData(jsPDF.API.convertStringToImageData(bmpImage))).toEqual("BMP");
	});

	it('tiff dataUrl', () => {
		let tiffImage = 'data:img/tiff;base64,SUkqAA4AAACAP+BP+AgTAP4ABAABAAAAAAAAAAABBAABAAAAAQAAAAEBBAABAAAAAQAAAAIBAwAEAAAA+AAAAAMBAwABAAAABQAAAAYBAwABAAAAAgAAABEBBAABAAAACAAAABUBAwABAAAABAAAABYBAABAAAAAQAAABcBBAABAAAABgAAABoBBQABAAAAAAEAABsBBQABAAAACAEAABwBAwABAAAAAQAAACgBAwABAAAAAgAAAD0BAwABAAAAAgAAAFIBAwABAAAAAgAAAABRBAABAAAAAAAAAAFRAwABAAAAAQAAAARRAQABAAAA/AAAAAAAAAAIAAgACAAIAAx3AQDoAwAADHcBAOgDAAA==';
		expect(jsPDF.API.getImageFileTypeByImageData(jsPDF.API.convertStringToImageData(tiffImage))).toEqual("TIFF");
	});

	it('tiff base64', () => {
		let tiffImage = 'SUkqAA4AAACAP+BP+AgTAP4ABAABAAAAAAAAAAABBAABAAAAAQAAAAEBBAABAAAAAQAAAAIBAwAEAAAA+AAAAAMBAwABAAAABQAAAAYBAwABAAAAAgAAABEBBAABAAAACAAAABUBAwABAAAABAAAABYBAABAAAAAQAAABcBBAABAAAABgAAABoBBQABAAAAAAEAABsBBQABAAAACAEAABwBAwABAAAAAQAAACgBAwABAAAAAgAAAD0BAwABAAAAAgAAAFIBAwABAAAAAgAAAABRBAABAAAAAAAAAAFRAwABAAAAAQAAAARRAQABAAAA/AAAAAAAAAAIAAgACAAIAAx3AQDoAwAADHcBAOgDAAA==';
		expect(jsPDF.API.getImageFileTypeByImageData(jsPDF.API.convertStringToImageData(tiffImage))).toEqual("TIFF");
	});
	
	it('UNKNOWN base64', () => {
		let invalidImage = 'invalid';
		expect(jsPDF.API.getImageFileTypeByImageData(jsPDF.API.convertStringToImageData(invalidImage, 'UNKNOWN'))).toEqual("UNKNOWN");
		expect(jsPDF.API.getImageFileTypeByImageData(jsPDF.API.convertStringToImageData(invalidImage))).toEqual("UNKNOWN");
		expect(jsPDF.API.getImageFileTypeByImageData(jsPDF.API.convertStringToImageData(invalidImage), 'PNG')).toEqual("PNG");
	});
})
