/**
 * @author ashwini
 */
var cardOpt = {
    legend: {
        position: 'bottom'
    },
    scales: {
        yAxes: [{
            gridLines : {
                display : false
            }
        }],
        xAxes : [ {
            gridLines : {
                display : false
            }
        } ]
    }
};
var bgColor = ['rgba(255, 99, 132, 0.2)',
				    'rgba(54, 162, 235, 0.2)',
				    'rgba(255, 206, 86, 0.2)',
				    'rgba(75, 192, 192, 0.2)',
				    'rgba(153, 102, 255, 0.2)',
				    'rgba(255, 159, 64, 0.2)'];
				    
var bdColor = ['rgba(255,99,132,1)',
                    'rgba(54, 162, 235, 1)',
                    'rgba(255, 206, 86, 1)',
                    'rgba(75, 192, 192, 1)',
                    'rgba(153, 102, 255, 1)',
                    'rgba(255, 159, 64, 1)'];
                    

function chartProd(obj){
	var objstgAllocat=obj.stgAllocatQtr;
	var Year = [];
	var stgSold = [];
    var stgAllocat = [];

    for (var i in objstgAllocat) {
    	 Year.push('Y'+objstgAllocat[i].Year+'Q'+objstgAllocat[i].Qtr);
         stgAllocat.push((objstgAllocat[i].ProdAllocat));
         stgSold.push((objstgAllocat[i].ProdSold));
        
    }
    
     // Prepare Chart Start
     var config = {
        type: 'line',
        data: {
                datasets: [
                
                  {
                      label: 'Allocated',
                      data: stgAllocat,
                      backgroundColor: 'rgba(255, 99, 132, 0.2)',
                      borderWidth: 1
                  },
                  {
                      label: 'Sold',
                      data: stgSold,
                      backgroundColor: 'rgba(54, 162, 235, 0.2)',
                      borderWidth: 1
                  }
                 
                ],
                
                labels:Year
            },
        options: {legend: {
        position: 'bottom'
    },
    scales: {
        yAxes: [{
            gridLines : {
                display : false
            },
            scaleLabel: {
            display: true,
            labelString: 'No. of Products'
          }
        }],
        xAxes : [ {
            gridLines : {
                display : false
            }
        } ]
    }
    }
    };
    var patChart = document.getElementById("prodChart").getContext('2d');
    patChart = new Chart(patChart, config);       
    // Prepare Chart End
}
function chartRev(obj){
	var objExport=obj.stgExportRevYear;
	var objJV=obj.stgJVRevYear;
	 var Year = [];
    var Export = [];
    var JV = [];

    for (var i in objExport) {
        Year.push('Y'+objExport[i].YEAR);
        Export.push((objExport[i].VALUE/1000000).toFixed(2));
    }
    for (var i in objJV) {
        JV.push((objJV[i].VALUE/1000000).toFixed(2));
    }
     // Prepare Chart Start
     var config = {
        type: 'line',
        data: {
                datasets: [
                  {
                      label: 'EXPORT',
                      data: Export,
                      backgroundColor: 'rgba(255, 99, 132, 0.2)',
                      borderWidth: 1
                  },
                  {
                      label: 'Joint Venture',
                      data: JV,
                      backgroundColor: 'rgba(54, 162, 235, 0.2)',
                      borderWidth: 1
                  }
                ],
                labels:Year
            },
        options: {legend: {
        position: 'bottom'
    },
    scales: {
        yAxes: [{
            gridLines : {
                display : false
            },
            scaleLabel: {
            display: true,
            labelString: 'In Millions'
          }
        }],
        xAxes : [ {
            gridLines : {
                display : false
            }
        } ]
    }
    }
    };
    var patChart = document.getElementById("revChart").getContext('2d');
    patChart = new Chart(patChart, config);       
    // Prepare Chart End
}
function chartScore(obj){
	var objstgCounwiseScore=obj.stgCounwiseScore;
	var COUNTRY = [];
    var stgCounwiseScore = [];
     var coloR = [];

         var dynamicColors = function() {
            var r = Math.floor(Math.random() * 255);
            var g = Math.floor(Math.random() * 255);
            var b = Math.floor(Math.random() * 255);
            return "rgb(" + r + "," + g + "," + b + ")";
         };

         
    for (var i in objstgCounwiseScore) {
        COUNTRY.push(objstgCounwiseScore[i].COUNTRY);
        stgCounwiseScore.push((objstgCounwiseScore[i].SCORE));
        coloR.push(dynamicColors());
    }
     // Prepare Chart Start
     var config = {
        type: 'pie',
        data: {
                datasets: [
                  {
                  	  
                      data: stgCounwiseScore,
                      backgroundColor: coloR,
                      borderWidth: 1
                  }
                ],
                labels:COUNTRY
           },
           options:{legend: {
        position: 'bottom'
    		}
    }
    };
    var patChart = document.getElementById("scoreChart").getContext('2d');
    patChart = new Chart(patChart, config);       
    // Prepare Chart End
}